

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppProcessIdxArchiveFile.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppProcessIdxArchiveFile.sp,v $ $Id: AppProcessIdxArchiveFile.sp,v 1.1.2.1 2020/12/15 00:14:10 sjanakiraman Exp $";
--
--  +========================================================================+
--  |   Procedure:  AppProcessIdxArchiveFile()
--  |
--  | Description:  Process archiveFile information from IdxArchFile table and decide the status
--	|
--  |
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppProcessIdxArchiveFile')
BEGIN
	print '>>> Drop Stored Procedure: AppProcessIdxArchiveFile <<<'
	drop procedure AppProcessIdxArchiveFile
END
IF EXISTS (select * from GxQscripts where name='AppProcessIdxArchiveFile')
	delete from GxQscripts where name = 'AppProcessIdxArchiveFile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppProcessIdxArchiveFile')
	delete from GXDBVersions where aliasname = 'AppProcessIdxArchiveFile'
GO
print '... Creating Procedure: AppProcessIdxArchiveFile'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppProcessIdxArchiveFile
	@i_subclientId INT,
	@processType INT = 7
AS
	DECLARE @o_errorCode INT = 0
	DECLARE @o_errorMsg NVARCHAR(MAX)=''
	DECLARE @c_holeThreshold DECIMAL
	DECLARE @c_afileFileCreatedMonths DECIMAL
	SET @c_holeThreshold = ISNULL( (SELECT value from MMConfigs WITH(NOLOCK) where name ='SPACE_RECLAMATION_SYNTHESIS_HOLE_THRESHOLD'),50)
	SET @c_afileFileCreatedMonths = ISNULL( (SELECT value from MMConfigs WITH(NOLOCK) where name ='SPACE_RECLAMATION_DONT_PRUNE_AFILE_CREATED_WITHIN_X_MONTHS'),6)
	/*
	enum IdxArchiveFileProcessingStatus
	{
		NO_ACTION=0,
		PREPARING_TO_INDEX_DELETE=1, --present only index and started the counting for processing
		READY_TO_INDEX_DELETE =2, --ready to delete these afileIds from index
		PICKED_TO_INDEX_DELETE =3,
		INDEX_DELETE_DONE = 4,
		INDEX_DELETE_FAILED = 5,
		PREPARING_TO_SYNTHESIS = 6,
		READY_TO_SYNTHESIS = 7,
		PICKED_TO_SYNTHESIS =8,
		SYNTHESIS_DONE = 9,
		SYNTHESIS_FAILED = 10,
		PREPARING_TO_PRUNE =11,
		READY_TO_PRUNE=12,
		PICKED_TO_PRUNE=13,
		PRUNING_DONE= 14,
		PRUNING_FAILED =15 ,
		PRUNING_DONE_INDEXDELETE_PENDING=16,
		PRUNING_DONE_INDEXDELETE_DONE=17,
		PRUNING_DONE_INDEXDELETE_FAILED=18
	}*/
	DECLARE @status_noaction INT = 0
	DECLARE @status_preparingindexdelete INT = 1
	DECLARE @status_readyindexdelete INT = 2
	DECLARE @status_preparingsynthesis INT = 6
	DECLARE @status_readysynthesis INT = 7
	DECLARE @status_preparingpruning INT = 11
	DECLARE @status_readypruning INT = 12
	 /*
   enum IdxArchiveFileFlag
	{
		NO_PRESENCE = 0,
		PRESENT_IN_INDEX = 1,  --1 << 0 only present in index .
		PRESENT_IN_CSDB = 2    --1 << 1 only present in csdb
	}*/
   DECLARE @presentInCSDB INT = 2
   DECLARE @presentInIndex INT = 1
	BEGIN TRY
	BEGIN TRAN
		IF object_id( 'tempdb.dbo.#commonfilterarch') IS NOT NULL
			DROP TABLE #commonfilterarch
		CREATE TABLE #commonfilterarch (afileid INT PRIMARY KEY )
		--process only those items whose
		--- index collection time is less than 1 days (we dont want to process stale entries as the the DB and index may have been out of sync )
		--- Status is no action OR any preparing states OR ready states
		INSERT into #commonfilterarch
		SELECT Idx.ArchiveFileId from IdxArchiveFile Idx WITH(NOLOCK)
		WHERE  DATEDIFF(day, dateadd(s,CollectionTime,'19700101'),GETUTCDATE()) < 1
		AND  Status in (@status_noaction, @status_preparingindexdelete,@status_readyindexdelete,@status_preparingsynthesis,@status_readysynthesis,@status_preparingpruning,@status_readypruning)
		AND SubclientId = @i_subclientId
		IF object_id( 'tempdb.dbo.#selectioncriteriaarch') IS NOT NULL
			DROP TABLE #selectioncriteriaarch
		CREATE TABLE #selectioncriteriaarch (afileid INT PRIMARY KEY)
	-------------------- index delete -----------------------------------
	IF ( @processType & 1 = 1)
	BEGIN
		-- consider archive files only when status is no action/preparing/ready to index delete and present only in index ( flag=1)
		INSERT INTO #selectioncriteriaarch
		SELECT TMP.afileid
		from #commonfilterarch TMP
		JOIN IdxArchiveFile Idx WITH(NOLOCK) ON Idx.ArchiveFileId = TMP.afileid
		where Idx.status in (@status_noaction,@status_preparingindexdelete,@status_readyindexdelete)
		AND Idx.flag = @presentInIndex
		AND Idx.SubclientId = @i_subclientId
		-- For all selected afiles in previous step, increment the verification count
		UPDATE IdxArchiveFile
		SET VerificationCount = VerificationCount + 1 ,
		Status = CASE  WHEN VerificationCount > 1 THEN @status_readyindexdelete ELSE @status_preparingindexdelete END
		WHERE ArchiveFileId in (select afileid from #selectioncriteriaarch )
		AND SubclientId = @i_subclientId
		--If count > 2, we can mark them ready to index delete. Space reclamation job will pick these items and process them ( by deleting them from index )
		-- else set intermediate state to preparing_to_index_delete, so that we know how many are in transitioning state
		-- since we are updating both count and status in single update call, instead of > 2 , it is compared with > 1
		--If for some reason, there are previous entries set to preparing/ready state , but doesnt qualify now, we reset the state and count to start the count from beginning.
		UPDATE IdxArchiveFile
		SET VerificationCount = 0, Status = 0
		WHERE ArchiveFileId NOT in ( select afileid from #selectioncriteriaarch )
		AND ArchiveFileId in (select afileId from #commonfilterarch)
		AND SubclientId = @i_subclientId
		AND Status in ( @status_preparingindexdelete,@status_readyindexdelete )
		TRUNCATE TABLE #selectioncriteriaarch
	END
	-------------------- index delete -----------------------------------
	-------------------- Synthesis ----------------------------------------
	IF ( @processType & 2 = 2)
	BEGIN
		INSERT INTO #selectioncriteriaarch
		SELECT TMP.afileid from #commonfilterarch TMP
		JOIN IdxArchiveFile Idx WITH(NOLOCK) ON Idx.ArchiveFileId = afileid
		WHERE Idx.status in (@status_noaction, @status_preparingsynthesis, @status_readysynthesis) --only noactionneeded, gettingreadytosynthesis, readytosynthesis,
		AND Idx.flag = @presentInIndex | @presentInCSDB --present in both index and csdb
		AND SubclientId = @i_subclientId
		AND Idx.NumberOfMaskedItems > 0 -- atleast some items masked
		AND Idx.NumberOfValidItems > 0 -- if valid item 0, then it is for pruning, not synthesis
		AND Idx.NumberOfMaskedItems > ((@c_holeThreshold/100.0)*Idx.TotalNumberOfItems) -- more than hole threshold
		UPDATE IdxArchiveFile
		SET VerificationCount = VerificationCount + 1 ,
		Status = CASE  WHEN VerificationCount > 1 THEN @status_readysynthesis ELSE @status_preparingsynthesis END
		where ArchiveFileId in ( select afileid from #selectioncriteriaarch )
		AND SubclientId = @i_subclientId
		UPDATE IdxArchiveFile
		SET VerificationCount = 0, Status = 0
		Where ArchiveFileId NOT in ( select afileid from #selectioncriteriaarch )
		AND ArchiveFileId in ( select afileId from #commonfilterarch)
		AND SubclientId = @i_subclientId
		AND Status in ( @status_preparingsynthesis,@status_readysynthesis )
		TRUNCATE TABLE #selectioncriteriaarch
	END
	--------------------- Synthesis ----------------------------------------
	-------------------- Pruning  ----------------------------------------
	IF ( @processType & 4 = 4 )
	BEGIN
		-- this may not bre correct, if index restore happens.. Correct way is to read from SECollection/metacollection/dbProps
		DECLARE @lastPlaybackTime INT
		SET @lastPlaybackTime   = (select dbState.properties.value('(/Indexing_DbStats/@lastPlayedBkpTime)[1]','INT') from App_IndexDBInfo I WITH(NOLOCK)
		INNER JOIN IdxDbState dbState WITH(NOLOCK) ON dbState.dbId = I.id
		INNER JOIN APP_Application A WITH(NOLOCK) ON I.backupSetId = A.backupSet
		where A.id = @i_subclientId AND idxDbEngineType = 2)
		INSERT INTO #selectioncriteriaarch
		SELECT TMP.afileid from #commonfilterarch TMP
		JOIN IdxArchiveFile Idx WITH(NOLOCK) ON Idx.ArchiveFileId = afileid
		JOIN archFile AF WITH(NOLOCK)  ON Idx.ArchiveFileId = AF.id AND AF.appId = Idx.SubclientId
		WHERE Idx.status in (@status_noaction, @status_preparingpruning, @status_readypruning) --pick only items whose status are no action/preparingtoprune/readytoprune
		AND Idx.flag in( @presentInCSDB,(@presentInCSDB|@presentInIndex))  -- present only in csdb or present in both
		AND SubclientId = @i_subclientId
		AND ( ( Idx.flag = (@presentInCSDB|@presentInIndex) AND Idx.TotalNumberOfItems > 0 AND Idx.NumberOfMaskedItems = Idx.TotalNumberOfItems  AND Idx.NumberOfValidItems = 0)  OR -- present in both csdb and index. All items are masked and no valid items
			(Idx.flag = @presentInCSDB AND Idx.TotalNumberOfItems = 0 AND Idx.NumberOfValidItems = 0 AND Idx.NumberOfMaskedItems =0 ) ) -- not present in index, so the counts are 0.
		AND Idx.subclientid NOT in ( select srcSubClientId from APP_LiveBrowseRecoveryPoints WITH(NOLOCK) ) --not refered by any recovery point
		AND DATEDIFF(month, dateadd(s,AF.cTime,'19700101'), GETUTCDATE()) > @c_afileFileCreatedMonths --afile is older than configured months
		AND AF.cTime < @lastPlaybackTime -- afile is older than last playback time. (i.e not recent archive files)
		UPDATE IdxArchiveFile
		SET VerificationCount = VerificationCount + 1 ,
		Status = CASE  WHEN VerificationCount > 1 THEN @status_readypruning ELSE @status_preparingpruning END
		where ArchiveFileId in ( select afileid from #selectioncriteriaarch ) AND SubclientId = @i_subclientId
		Update IdxArchiveFile
		SET VerificationCount = 0, Status = 0
		WHERE ArchiveFileId NOT in ( select afileid from #selectioncriteriaarch )
		AND ArchiveFileId in ( select afileId from #commonfilterarch)
		AND SubclientId = @i_subclientId
		AND Status in ( @status_preparingpruning,@status_readypruning )
	END
-------------------- Pruning ----------------------------------------
	COMMIT TRAN
 END TRY
 BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	EXECUTE dbo.GetError @o_errorMsg OUTPUT, @o_errorCode OUTPUT
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRANSACTION;
	END
	;THROW
 END CATCH;
	IF object_id( 'tempdb.dbo.#commonfilterarch') IS NOT NULL
		drop table #commonfilterarch
	IF object_id( 'tempdb.dbo.#selectioncriteriaarch') IS NOT NULL
		drop table #selectioncriteriaarch
	DECLARE @o_readyToIndexDelete BIGINT = 0
	DECLARE @o_readyToSynthesis   BIGINT = 0
	DECLARE @o_readyToPrune       BIGINT = 0
	SELECT
	    @o_readyToIndexDelete += IIF((Status = @status_readyindexdelete), 1,0),
	    @o_readyToSynthesis += IIF((Status = @status_readysynthesis), 1,0),
	    @o_readyToPrune += IIF((Status = @status_readypruning), 1,0)
	FROM IdxArchiveFile WITH(NOLOCK)
	WHERE
	subclientId = @i_subclientId
	SELECT
	@o_readyToIndexDelete 'o_readyToIndexDelete',
	@o_readyToSynthesis 'o_readyToSynthesis',
	@o_readyToPrune 'o_readyToPrune',
	@o_errorCode 'o_errorCode',
	@o_errorMsg 'o_errorMsg'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppProcessIdxArchiveFile')
	delete from GxQscripts where name = 'AppProcessIdxArchiveFile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppProcessIdxArchiveFile')
	delete from GXDBVersions where aliasname = 'AppProcessIdxArchiveFile'
GO

insert into GXDBVersions values(2, 'AppProcessIdxArchiveFile',  '00010001000200010000', 'AppProcessIdxArchiveFile', '00010001000200010000')
GO

