

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppProcessDIPs.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppProcessDIPs')
BEGIN
	print '>>> Drop Stored Procedure: AppProcessDIPs <<<'
	drop procedure AppProcessDIPs
END
IF EXISTS (select * from GxQscripts where name='AppProcessDIPs')
	delete from GxQscripts where name = 'AppProcessDIPs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppProcessDIPs')
	delete from GXDBVersions where aliasname = 'AppProcessDIPs'
GO
print '... Creating Procedure: AppProcessDIPs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppProcessDIPs
/*
*	This SP modifies archPipelineFirewall entries based on archPipeline entries.
*	Parameters: i_params contains information required for processing. It is of type XML with root tag App_WildcardDIPWorkqueueParams
*				i_requestType specifies the operation to be performed. Valid values are INSERT = 1, DELETE = 2, UPDATE = 3
*/
  @i_params XML,
  @i_requestType INTEGER
AS
  DECLARE @errorCode INTEGER
  DECLARE @errorMessage NVARCHAR(MAX)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
/*
*	Sample input XML:
*
*	<App_WildcardDIPWorkqueueParams requestType="1" archpipelineID="1">
*		<newDIP srcInterface="172*" destInterface="172.16.26.53" srcType="2" destType="0" isActive="1">
*			<srcClientGroup clientGroupId="5"/>
*			<destClient clientId="2"/>
*		</newDIP>
*	</App_WildcardDIPWorkqueueParams>
*
*/
/* id from archPipeline table which gives us interface information */
DECLARE @dipId INTEGER = 0
/* INSERT = 1 / DELETE = 2 / UPDATE = 3 */
DECLARE @operationType INTEGER = 0
/* Interface wildcard type. Non_Wildcard = 0, CIDR = 1, Wildcard = 2 */
DECLARE @srcInterfaceType INTEGER = 0
/* Interface wildcard type. Non_Wildcard = 0, CIDR = 1, Wildcard = 2 */
DECLARE @dstInterfaceType INTEGER = 0
DECLARE @srcClientId_APL INTEGER = 0
DECLARE @dstClientId_APL INTEGER = 0
DECLARE @srcClientGroupId_APL INTEGER = 0
DECLARE @dstClientGroupId_APL INTEGER = 0
DECLARE @srcInterface VARCHAR (64)
DECLARE @dstInterface VARCHAR (64)
DECLARE @isActive INTEGER = 0
SET @errorCode = 0
SET @errorMessage = ''
SET @operationType = @i_requestType
SET @dipId = @i_params.value('/App_WildcardDIPWorkqueueParams[1]/@archpipelineID', 'INTEGER')
SET @srcInterfaceType = @i_params.value('/App_WildcardDIPWorkqueueParams[1]/newDIP[1]/@srcType', 'INTEGER')
SET @dstInterfaceType = @i_params.value('/App_WildcardDIPWorkqueueParams[1]/newDIP[1]/@destType', 'INTEGER')
IF @dipId IS NULL OR @dipId=0 AND @operationType <> 2 /* Except for "DELETE DIP", @dipId should be valid */
BEGIN
	SET @errorCode = 1
	SET @errorMessage = 'Received empty/0 archPipeline.id'
	GOTO RETURN_FROM_HERE
END
SELECT @srcClientId_APL=srcClientId, @dstClientId_APL=destClientId, @srcClientGroupId_APL=srcGroupId, @dstClientGroupId_APL=destGroupId, @srcInterface=srcInterface
		, @dstInterface=destInterface, @isActive=isActive
FROM archPipeline
WHERE id=@dipId
IF @@ROWCOUNT=0
BEGIN
	/*
	*	As Workqueue processing is not sequential, in delete cases it is possible that the archPipeline entry for the given @dipId no longer exists.
	*/
IF @operationType <> 2
	BEGIN
		SET @errorCode = 2
		SET @errorMessage = 'No valid entries in archPipeline table for id = ' + CAST(@dipId AS NVARCHAR(16))
		GOTO RETURN_FROM_HERE
	END
END
DECLARE @createdTime INTEGER = dbo.GetUnixTime(GETUTCDATE())
DECLARE @modifiedTime INTEGER = 0
IF object_id('tempdb.dbo.#SrcClientInterfaceMap') IS NOT NULL
			DROP TABLE #SrcClientInterfaceMap
CREATE TABLE #SrcClientInterfaceMap (clientId INTEGER, interface NVARCHAR(255))
CREATE CLUSTERED INDEX SrcClientInterfaceMap_clientId_Idx ON #SrcClientInterfaceMap(clientId)
CREATE INDEX SrcClientInterfaceMap_interface_Idx ON #SrcClientInterfaceMap(interface)
IF object_id('tempdb.dbo.#DstClientInterfaceMap') IS NOT NULL
	DROP TABLE #DstClientInterfaceMap
CREATE TABLE #DstClientInterfaceMap (clientId INTEGER, interface NVARCHAR(255))
CREATE CLUSTERED INDEX DstClientInterfaceMap_clientId_Idx ON #DstClientInterfaceMap(clientId)
CREATE INDEX DstClientInterfaceMap_interface_Idx ON #DstClientInterfaceMap(interface)
IF @operationType = 1  /* INSERT INTO archPipelineFirewall */
BEGIN
	IF @isActive<>0
		EXEC AppProcessWildcardInterfaces @srcClientId_APL, @srcClientGroupId_APL, @dstClientId_APL, @dstClientGroupId_APL, @srcInterfaceType
											, @srcInterface, @dstInterfaceType, @dstInterface
END
ELSE IF @operationType = 2 /* DELETE FROM archPipelineFirewall */
BEGIN
	/*
	*	DELETE FROM archPipelineFirewall happens on a DELETE CASCADE
	*	We only want to insert workqueue token to push network configuration for these clients
	*/
	/*
	*	As Workqueue processing is not sequential, in delete cases it is possible that the archPipeline entry for the given @dipId no longer exists/valid.
	*	So, fall back to the information provided in the xml.
	*/
	SET @srcClientId_APL = @i_params.value('/App_WildcardDIPWorkqueueParams[1]/newDIP[1]/srcClient[1]/@clientId', 'INTEGER')
	SET @dstClientId_APL = @i_params.value('/App_WildcardDIPWorkqueueParams[1]/newDIP[1]/destClient[1]/@clientId', 'INTEGER')
	SET @srcClientGroupId_APL = @i_params.value('/App_WildcardDIPWorkqueueParams[1]/newDIP[1]/srcClientGroup[1]/@clientGroupId', 'INTEGER')
	SET @dstClientGroupId_APL = @i_params.value('/App_WildcardDIPWorkqueueParams[1]/newDIP[1]/destClientGroup[1]/@clientGroupId', 'INTEGER')
	SET @srcInterface = @i_params.value('/App_WildcardDIPWorkqueueParams[1]/newDIP[1]/@srcInterface', 'NVARCHAR(64)')
	SET @dstInterface = @i_params.value('/App_WildcardDIPWorkqueueParams[1]/newDIP[1]/@destInterface', 'NVARCHAR(64)')
	SET @isActive = @i_params.value('/App_WildcardDIPWorkqueueParams[1]/newDIP[1]/@isActive', 'INTEGER')
	EXEC AppProcessWildcardInterfaces @srcClientId_APL, @srcClientGroupId_APL, @dstClientId_APL, @dstClientGroupId_APL, @srcInterfaceType
											, @srcInterface, @dstInterfaceType, @dstInterface
END
ELSE IF @operationType = 3 /* UPDATE archPipelineFirewall */
BEGIN
	/* NOTE: Only interfaces and isActive can be modified as part of Update */
	/* Interface wildcard type. Non_Wildcard = 0, CIDR = 1, Wildcard = 2 */
	DECLARE @oldSrcInterfaceType INTEGER = 0
	/* Interface wildcard type. Non_Wildcard = 0, CIDR = 1, Wildcard = 2 */
	DECLARE @oldDstInterfaceType INTEGER = 0
	DECLARE @oldSrcClientId_APL INTEGER = 0
	DECLARE @oldDstClientId_APL INTEGER = 0
	DECLARE @oldSrcClientGroupId_APL INTEGER = 0
	DECLARE @oldDstClientGroupId_APL INTEGER = 0
	DECLARE @oldSrcInterface VARCHAR (64)
	DECLARE @oldDstInterface VARCHAR (64)
	DECLARE @oldIsActive INTEGER = 0
	SET @oldSrcInterfaceType = @i_params.value('/App_WildcardDIPWorkqueueParams[1]/oldDIP[1]/@srcType', 'INTEGER')
	SET @oldDstInterfaceType = @i_params.value('/App_WildcardDIPWorkqueueParams[1]/oldDIP[1]/@destType', 'INTEGER')
	SET @oldSrcClientId_APL = @i_params.value('/App_WildcardDIPWorkqueueParams[1]/oldDIP[1]/srcClient[1]/@clientId', 'INTEGER')
	SET @oldDstClientId_APL = @i_params.value('/App_WildcardDIPWorkqueueParams[1]/oldDIP[1]/destClient[1]/@clientId', 'INTEGER')
	SET @oldSrcClientGroupId_APL = @i_params.value('/App_WildcardDIPWorkqueueParams[1]/oldDIP[1]/srcClientGroup[1]/@clientGroupId', 'INTEGER')
	SET @oldDstClientGroupId_APL = @i_params.value('/App_WildcardDIPWorkqueueParams[1]/oldDIP[1]/destClientGroup[1]/@clientGroupId', 'INTEGER')
	SET @oldSrcInterface = @i_params.value('/App_WildcardDIPWorkqueueParams[1]/oldDIP[1]/@srcInterface', 'NVARCHAR(64)')
	SET @oldDstInterface = @i_params.value('/App_WildcardDIPWorkqueueParams[1]/oldDIP[1]/@destInterface', 'NVARCHAR(64)')
	SET @oldIsActive = @i_params.value('/App_WildcardDIPWorkqueueParams[1]/oldDIP[1]/@isActive', 'INTEGER')
	IF @srcClientId_APL<>@oldSrcClientId_APL OR @dstClientId_APL<>@oldDstClientId_APL OR @srcClientGroupId_APL<>@oldSrcClientGroupId_APL OR @dstClientGroupId_APL<>@oldDstClientGroupId_APL
	BEGIN
		SET @errorCode=3
		SET @errorMessage='Old client/Group IDs do not match New client/Group.'
			+ 'Old source Client ID :[' + CAST(@oldSrcClientId_APL AS NVARCHAR(16)) + ']'
			+ 'New source Client ID :[' + CAST(@srcClientId_APL AS NVARCHAR(16)) + ']'
			+ 'Old destination Client ID :[' + CAST(@oldDstClientId_APL AS NVARCHAR(16)) + ']'
			+ 'New destination Client ID :[' + CAST(@dstClientId_APL AS NVARCHAR(16)) + ']'
			+ 'Old source Client Group ID:[' + CAST(@oldSrcClientGroupId_APL AS NVARCHAR(16)) + ']'
			+ 'New source Client Group ID:[' + CAST(@srcClientGroupId_APL AS NVARCHAR(16)) + ']'
			+ 'Old destination Client Group ID:[' + CAST(@oldDstClientGroupId_APL AS NVARCHAR(16)) + ']'
			+ 'New destination Client Group ID:[' + CAST(@dstClientGroupId_APL AS NVARCHAR(16)) + ']'
		GOTO RETURN_FROM_HERE
	END
	/* This table consists of clients we have to push network configuration to. */
	IF object_id('tempdb.dbo.#clientList') IS NOT NULL
		DROP TABLE #clientList
	CREATE TABLE #clientList(clientId INTEGER)
	CREATE CLUSTERED INDEX clientList_clientId_Idx ON #clientList(clientId)
	/* If the DIP is Disabled, just delete the entries */ /* ToDo : Maybe we should add an isActive to archPipelineFirewall table to avoid rematching of wildcard DIPs?? */
	IF @isActive<>@oldIsActive AND @isActive=0
	BEGIN
		/* We have to push network configuration for all these clients */
		INSERT INTO #clientList
		SELECT srcClientId
		FROM archPipelineFirewall WHERE archPipelineId=@dipId
		UNION ALL
		SELECT destClientId
		FROM archPipelineFirewall WHERE archPipelineId=@dipId
		DELETE FROM archPipelineFirewall WHERE archPipelineId=@dipId
		INSERT INTO APP_WorkQueueRequest (clientId, remoteClient, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag)
SELECT clientId, -1, 5, '', @createdTime, 0, 0, 0
		FROM #clientList
	END
	ELSE
	BEGIN
		/* In any other case, old entries need to be deleted and new entries should be added */
		/* Avoid rematching wildcard DIPs*/
		DECLARE @reprocessSrcInterface INTEGER = 0
		DECLARE @reprocessDstInterface INTEGER = 0
		IF @srcInterface=@oldSrcInterface
		BEGIN
			INSERT INTO #SrcClientInterfaceMap
			SELECT srcClientId, srcInterface
			FROM archPipelineFirewall
			WHERE archPipelineId=@dipId
		END
		ELSE
		BEGIN
			SET @reprocessSrcInterface = 1
		END
		IF @dstInterface=@oldDstInterface
		BEGIN
			INSERT INTO #DstClientInterfaceMap
			SELECT destClientId, destInterface
			FROM archPipelineFirewall
			WHERE archPipelineId=@dipId
		END
		ELSE
		BEGIN
			SET @reprocessDstInterface = 1
		END
		/* No changes in interfaces */
		IF @reprocessSrcInterface=0 AND @reprocessDstInterface=0
			GOTO RETURN_FROM_HERE
		INSERT INTO #clientList
		SELECT srcClientId
		FROM archPipelineFirewall WHERE archPipelineId=@dipId
		UNION ALL
		SELECT destClientId
		FROM archPipelineFirewall WHERE archPipelineId=@dipId
		DELETE FROM archPipelineFirewall WHERE archPipelineId=@dipId
		IF @reprocessSrcInterface<>0 AND @reprocessDstInterface<>0
			EXEC AppProcessWildcardInterfaces @srcClientId_APL, @srcClientGroupId_APL, @dstClientId_APL, @dstClientGroupId_APL, @srcInterfaceType
												, @srcInterface, @dstInterfaceType, @dstInterface
		ELSE IF @reprocessSrcInterface<>0
			EXEC AppProcessWildcardInterfaces @srcClientId_APL, @srcClientGroupId_APL, 0, 0, @srcInterfaceType
												, @srcInterface, 0, ''
		ELSE IF @reprocessDstInterface<>0
			EXEC AppProcessWildcardInterfaces 0, 0, @dstClientId_APL, @dstClientGroupId_APL, 0
												, '', @dstInterfaceType, @dstInterface
		/* Push to the #clientList */
		INSERT INTO APP_WorkQueueRequest (clientId, remoteClient, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag)
SELECT clientId, -1, 5, '', @createdTime, 0, 0, 0
		FROM #clientList
	END
	IF object_id('tempdb.dbo.#clientList') IS NOT NULL
		DROP TABLE #clientList
END
IF @operationType = 1 OR @operationType = 3
BEGIN
	/* Insert values into archPipelineFirewall */
	INSERT INTO archPipelineFirewall (srcClientId, destClientId, srcInterface, destInterface, created, modified, archPipelineId)
	SELECT DISTINCT Src.clientId, Dst.clientId, Src.interface, Dst.interface, @createdTime, @modifiedTime, @dipId
	FROM #SrcClientInterfaceMap Src
	CROSS JOIN #DstClientInterfaceMap Dst
END
/* Insert Workqueue request to push network configuration */
INSERT INTO APP_WorkQueueRequest (clientId, remoteClient, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag)
SELECT Src.clientId, -1, 5, '', @createdTime, 0, 0, 0
FROM #SrcClientInterfaceMap Src
UNION ALL
SELECT Dst.clientId, -1, 5, '', @createdTime, 0, 0, 0
FROM #DstClientInterfaceMap Dst
RETURN_FROM_HERE:
	IF object_id('tempdb.dbo.#SrcClientInterfaceMap') IS NOT NULL
		DROP TABLE #SrcClientInterfaceMap
	IF object_id('tempdb.dbo.#DstClientInterfaceMap') IS NOT NULL
		DROP TABLE #DstClientInterfaceMap
	IF object_id('tempdb.dbo.#clientList') IS NOT NULL
		DROP TABLE #clientList
	SELECT @errorCode, @errorMessage
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppProcessDIPs')
	delete from GxQscripts where name = 'AppProcessDIPs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppProcessDIPs')
	delete from GXDBVersions where aliasname = 'AppProcessDIPs'
GO

insert into GXDBVersions values(2, 'AppProcessDIPs',  '00000000000000000000', 'AppProcessDIPs', '00000000000000000000')
GO

