

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPrepeareCSForEdgeMiniBrand.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPrepeareCSForEdgeMiniBrand.sp,v $ $Id: AppPrepeareCSForEdgeMiniBrand.sp,v 1.1.2.11 2019/07/17 20:47:30 syadav Exp $";
--
--  +========================================================================+
--  |   Procedure:  AppPrepeareCSForEdgeMiniBrand()
--  |
--  | Description:
--  |
--  |       Input:
--  |      Output:
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPrepeareCSForEdgeMiniBrand')
BEGIN
	print '>>> Drop Stored Procedure: AppPrepeareCSForEdgeMiniBrand <<<'
	drop procedure AppPrepeareCSForEdgeMiniBrand
END
IF EXISTS (select * from GxQscripts where name='AppPrepeareCSForEdgeMiniBrand')
	delete from GxQscripts where name = 'AppPrepeareCSForEdgeMiniBrand'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPrepeareCSForEdgeMiniBrand')
	delete from GXDBVersions where aliasname = 'AppPrepeareCSForEdgeMiniBrand'
GO
print '... Creating Procedure: AppPrepeareCSForEdgeMiniBrand'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPrepeareCSForEdgeMiniBrand
AS
  DECLARE @errCode integer = 0
  DECLARE @errString varchar(MAX) = 'Success'
DECLARE @subclientPolicyName  NVARCHAR(MAX) = ''
DECLARE @storagePolicyID INT = ISNULL((SELECT TOP 1 id FROM archGroup WHERE id > 2 ORDER BY id ASC),1)
DECLARE @userId  INT = 1
DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(MAX) = N'Success'
DECLARE @nowTime  INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @subclientPolicyId INT
DECLARE @defaultsubclientId  INT
DECLARE @INSERT_PROP_RESULTS table (
    errorCode           integer,
    hasChanged          integer,
    propId              integer,
    errorString         varchar(1024)
)
DECLARE @errorTable TABLE(
	errorCode INT,
	errorString NVARCHAR(MAX)
)
BEGIN TRY
--CreateMacSubclientPolicy.sql START
SET @subclientPolicyName = 'MacPolicy'
IF NOT EXISTS (SELECT 1 FROM APP_BackupSetName WITH (NOLOCK) WHERE name = @subclientPolicyName AND status & 0x80 <> 0) --CV_STATUS_POLICY_BSET
BEGIN
    INSERT INTO APP_BackupSetName
        VALUES(@subclientPolicyName, @nowTime, @nowTime, 0x80, 0, 0, 2, NEWID())
    SET @subclientPolicyId = (SELECT id FROM APP_BackupSetName with(nolock) WHERE name = @subclientPolicyName)
    --Insert into APP_BackupSetProp
    INSERT INTO APP_BackupSetProp
        VALUES(@subclientPolicyId, 'Associated subclient Policy Ida Type', 7, '3', @nowTime, 0, 0)
    INSERT INTO APP_BackupSetProp
        VALUES(@subclientPolicyId, 'Subclient Policy Create UserId', 7, CAST(@userId AS NVARCHAR(10)), @nowTime, 0, 0)
    INSERT INTO APP_BackupSetProp
        VALUES(@subclientPolicyId, 'Use Change Journal', 2, '0', @nowTime, 0, 0)
    --Insert into APP_Application
    INSERT INTO APP_Application
        VALUES( 2 , 1030, 1, @subclientPolicyId, 0, @storagePolicyID, @storagePolicyID, @nowTime, @nowTime, 'default', 8, 0, 0, 2, NEWID())
    SET @defaultsubclientId = SCOPE_IDENTITY()
    --Insert into APP_SubclientProp
    INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'last data SP', 10, '1', @nowTime, 0,0)
    INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'last log SP', 10, '1', @nowTime, 0,0)
    INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'sys: pre post option', 10, '0', @nowTime, 0,0)
    INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'prepost password', 1, '3cfe3eeb854e8aa64e0155bec019674d5', @nowTime, 0,0)
    INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'sys:nStreams', 7, '2', @nowTime, 0,0)
    INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'FLR Hash Block Size', 7, '0', @nowTime, 0,0)
    INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'FLR Hash Min File Size', 7, '0', @nowTime, 0,0)
    INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'Use VSS Options', 7, '0', @nowTime, 0,0)
    INSERT INTO APP_ScFilterFile(componentNameId, type, fileName, created, modified, ccpId)
        VALUES (@defaultsubclientId, 1, '\%Documents%', @nowTime, 0, 0)
    INSERT INTO APP_ScFilterFile(componentNameId, type, fileName, created, modified, ccpId)
        VALUES (@defaultsubclientId, 1, '\%Desktop%', @nowTime, 0, 0)
    INSERT INTO APP_ScFilterFile(componentNameId, type, fileName, created, modified, ccpId)
        VALUES (@defaultsubclientId, 1, '\%Music%', @nowTime, 0, 0)
    INSERT INTO APP_ScFilterFile(componentNameId, type, fileName, created, modified, ccpId)
        VALUES (@defaultsubclientId, 1, '\%Pictures%', @nowTime, 0, 0)
END
--CreateMacSubclientPolicy.sql END
--CreateWindowsSubclientPolicy.sql START
SET @subclientPolicyName = 'WindowsPolicy'
IF NOT EXISTS (SELECT 1 FROM APP_BackupSetName WITH (NOLOCK) WHERE name = @subclientPolicyName AND status & 0x80 <> 0) --CV_STATUS_POLICY_BSET
BEGIN
    INSERT INTO APP_BackupSetName
        VALUES(@subclientPolicyName, @nowTime, @nowTime, 0x80, 0, 0, 2, NEWID())
    SET @subclientPolicyId = (SELECT id FROM APP_BackupSetName with(nolock) WHERE name = @subclientPolicyName)
    --Insert into APP_BackupSetProp
    INSERT INTO APP_BackupSetProp
        VALUES(@subclientPolicyId, 'Associated subclient Policy Ida Type', 7, '2', @nowTime, 0, 0)
    INSERT INTO APP_BackupSetProp
        VALUES(@subclientPolicyId, 'Subclient Policy Create UserId', 7, CAST(@userId AS NVARCHAR(10)), @nowTime, 0, 0)
    INSERT INTO APP_BackupSetProp
        VALUES(@subclientPolicyId, 'Use Change Journal', 2, '0', @nowTime, 0, 0)
    --Insert into APP_Application
    INSERT INTO APP_Application
        VALUES( 2 , 1030, 1, @subclientPolicyId, 0, @storagePolicyID, @storagePolicyID, @nowTime, @nowTime, 'default', 8, 0, 0, 2, NEWID())
    SET @defaultsubclientId = SCOPE_IDENTITY()
    --Insert into APP_SubclientProp
    INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'last data SP', 10, '1', @nowTime, 0,0)
    INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'last log SP', 10, '1', @nowTime, 0,0)
    INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'sys: pre post option', 10, '0', @nowTime, 0,0)
    INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'Use VSS Enabled', 2, '1', @nowTime, 0,0)
    INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'Use VSS for System State', 2, '0', @nowTime, 0,0)
    INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'prepost password', 1, '3cfe3eeb854e8aa64e0155bec019674d5', @nowTime, 0,0)
    INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'System State', 2, '0', @nowTime, 0,0)
    INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'System State on Full Backup Only', 2, '0', @nowTime, 0,0)
    INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'sys:nStreams', 7, '2', @nowTime, 0,0)
    INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'FLR Hash Block Size', 7, '0', @nowTime, 0,0)
    INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'FLR Hash Min File Size', 7, '0', @nowTime, 0,0)
    INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'Use VSS Options', 7, '2', @nowTime, 0,0)
    INSERT INTO APP_ScFilterFile(componentNameId, type, fileName, created, modified, ccpId)
        VALUES (@defaultsubclientId, 1, '\%Documents%', @nowTime, 0, 0)
    INSERT INTO APP_ScFilterFile(componentNameId, type, fileName, created, modified, ccpId)
        VALUES (@defaultsubclientId, 1, '\%Desktop%', @nowTime, 0, 0)
    INSERT INTO APP_ScFilterFile(componentNameId, type, fileName, created, modified, ccpId)
        VALUES (@defaultsubclientId, 1, '\%Music%', @nowTime, 0, 0)
    INSERT INTO APP_ScFilterFile(componentNameId, type, fileName, created, modified, ccpId)
        VALUES (@defaultsubclientId, 1, '\%Pictures%', @nowTime, 0, 0)
    INSERT INTO APP_ScFilterFile(componentNameId, type, fileName, created, modified, ccpId)
        VALUES (@defaultsubclientId, 1, '\%Videos%', @nowTime, 0, 0)
    INSERT INTO APP_ScFilterFile(componentNameId, type, fileName, created, modified, ccpId)
        VALUES (@defaultsubclientId, 3, '\%Temporary Files%', @nowTime, 0, 0)
END
--CreateWindowsSubclientPolicy.sql END
--GenerateAuthCode.sql START
DECLARE @simpanaInstallDir nvarchar(255) = (SELECT (SELECT install_dir FROM APP_Platform WHERE clientId = 2 AND platformType = 1) + '\EdgeDrive')
--Set lock down
INSERT @INSERT_PROP_RESULTS
EXEC  AppInsertGlobalParam
            @isPIT = 1,
            @createdTime = @nowTime,
            @name = N'Secure Agent Install',
            @newValue = N'1'
--Set Webconsole login to show only My Data
INSERT @INSERT_PROP_RESULTS
EXEC  AppInsertGlobalParam
            @isPIT = 0,
            @createdTime = @nowTime,
            @name = N'CvFeaturesList',
            @newValue = N'32769'
--Enable Quota Feature for commcell
IF EXISTS (SELECT * FROM APP_AdvanceSettings WHERE keyName = 'EnableFSQuotaManagement')
BEGIN
    DELETE APP_AdvanceSettings WHERE keyName = 'EnableFSQuotaManagement'
END
INSERT INTO [CommServ].[dbo].[APP_AdvanceSettings]
           ([entityId]
           ,[keyName]
           ,[type]
           ,[relativePath]
           ,[value]
           ,[enabled]
           ,[deleted]
           ,[entityType]
           ,[sourceId]
           ,[sourceEntityType])
     VALUES
           (2
           ,'EnableFSQuotaManagement'
           ,'INTEGER'
           ,'CommServDB.GxGlobalParam'
           ,'1'
           ,1
           ,0
           ,3
           ,0
           ,0
           )
--Enable Quota Feature on GUI
IF EXISTS (SELECT * FROM APP_AdvanceSettings WHERE keyName = 'bEnableFSQuotaManagementGUI')
BEGIN
    DELETE APP_AdvanceSettings WHERE keyName = 'bEnableFSQuotaManagementGUI'
END
INSERT INTO [CommServ].[dbo].[APP_AdvanceSettings]
           ([entityId]
           ,[keyName]
           ,[type]
           ,[relativePath]
           ,[value]
           ,[enabled]
           ,[deleted]
           ,[entityType]
           ,[sourceId]
           ,[sourceEntityType])
     VALUES
           (2
           ,'bEnableFSQuotaManagementGUI'
           ,'BOOLEAN'
           ,'CommServDB.Console'
           ,'true'
           ,1
           ,0
           ,3
           ,0
           ,0
           )
--Assign all client owner capabilities to Laptop Clients group
DECLARE @laptopCGId INT = (SELECT id FROM App_Clientgroup WHERE name = 'Laptop Clients' AND flag = 4096)
IF @laptopCGId > 0
BEGIN
       IF NOT EXISTS (SELECT * FROM UMUserandGroupEntityAssociation WHERE entityType = 2572 AND objectId = @laptopCGId AND userId = 0 AND groupId = 0 AND providerId = 0)
       BEGIN
              INSERT INTO [UMUserandGroupEntityAssociation]
                        ([userId]
                        ,[groupId]
                        ,[providerId]
                        ,[capabilities]
                        ,[entityType]
                        ,[objectId]
                        ,[ownerUserId])
              VALUES
                        (0
                        ,0
                        ,0
                        ,(select SUM(POWER(2.0, id-1)) FROM UMCapability)
                        ,2572
                        ,@laptopCGId
                        ,1)
       END
       ELSE
              UPDATE UMUserandGroupEntityAssociation
              SET capabilities = (select SUM(POWER(2.0, id-1)) FROM UMCapability)
              WHERE entityType = 2572 AND objectId = @laptopCGId AND userId = 0 AND groupId = 0 AND providerId = 0
        --this is for inserting into new security tables from v11
        DECLARE @clientGroupOwnerConfigureXML XML = '<App_SecurityAssociationForEntityList>
                                                            <ownerAssociations>
                                                                <categoryPermission categoriesPermissionOperationType="1">
                                                                    <!-- configure all permissions for this client group owner capabilities -->
                                                                    <categoriesPermissionList _type_="123"/>
                                                                </categoryPermission>
                                                            </ownerAssociations>
                                                    </App_SecurityAssociationForEntityList>'
		INSERT @errorTable
        EXEC sec_setSecurityAssociationsFromEntity @clientGroupOwnerConfigureXML, 1, 0, 0, 28, @laptopCGId, 0, 0, 0, 0, 0, 0, 0, 0
END
--Generate Auth code
IF NOT EXISTS (SELECT 1 FROM UMGroups WITH (NOLOCK) WHERE name = 'Laptop users' AND umdsProviderId = 0)
BEGIN
    INSERT INTO UMGroups(groupFlags, allCapabilities, allAssociations, selfAssociation, name, description, origCCId, GUID, umdsProviderId, email, lastCredSetTime)
        VALUES( 1,0,0,1,'Laptop users', '', 2, NEWID(), 0, '', 0)
END
INSERT @INSERT_PROP_RESULTS
EXEC  AppInsertGlobalParam
            @isPIT = 1,
            @createdTime = @nowTime,
            @name = N'UserRegistration',
            @newValue = N'1'
IF NOT EXISTS (SELECT 1 FROM CloudAuthorization WHERE authCode = 'EDGESIGNUP')
BEGIN
INSERT INTO cloudAuthorization
VALUES('EDGESIGNUP', '', 288, '', 1, 'Edge authcode', DATEDIFF(s, '1970-01-01 00:00:00', GETDATE()), -1, -1)
END
--Assign Installation capability to Laptop Users group
DECLARE @laptopUsersGroupId INT = (SELECT id FROM UMGroups WHERE name = 'Laptop users' AND umdsProviderId = 0)
DECLARE @capabilityId INT = 7               --the name is changed from v11. Let us not depend on name anymore. This is macro EV_MANAGE_INSTALLATION
IF NOT EXISTS (SELECT * FROM UMGroupCapability WHERE groupId = @laptopUsersGroupId AND capabilityId = @capabilityid)
BEGIN
    INSERT INTO UMGroupCapability (groupId, capabilityId, flag)
        SELECT @laptopUsersGroupId, @capabilityId, 0
END
IF NOT EXISTS (SELECT * FROM UMSecurityAssociations WHERE userOrGroupId = @laptopUsersGroupId AND isUser = 0 AND permissionId = 65 AND entityTYpe1 = 1 AND entityID1 = 2)
    --According to Anand, we need to insert Install Client for this user group on commcell level
    INSERT INTO UMSecurityAssociations (userOrGroupId, isUser, roleId, permissionId, entityTYpe1, entityID1, authorId)
        SELECT @laptopUsersGroupId, 0, 0, 65, 1, 2, 1               --CAT_COMMCELL_INSTALL_CLIENT (instead of depending on name, hard-coding the id directly from macro)
        --SELECT @laptopUsersGroupId, 0, 0, CAT_COMMCELL_INSTALL_CLIENT, COMMCELL_ENTITY, DEFAULT_COMMCELL_ID, US_ADMIN_USER_ID
--Generate Download URL and add it to GxGlobalParam
DECLARE @PackageUrlWin64 NVARCHAR(MAX) = 'https://cloud.commvault.com/edge/'
DECLARE @PackageUrlWin32 NVARCHAR(MAX) = 'https://cloud.commvault.com/edge/'
DECLARE @PackageUrlMac NVARCHAR(MAX) = 'https://cloud.commvault.com/edge/'
DECLARE @releaseId INT = 11
DECLARE @highestSP INT = 1
DECLARE @minorSP   INT
IF EXISTS(SELECT 1 FROM simAllGalaxyRel WHERE id = (SELECT releaseId FROM APP_Client WHERE id = 2))
AND EXISTS(SELECT 1 FROM SimInstalledPackages WHERE ClientId = 2 AND simPackageID = 1)
BEGIN
    SET @releaseId = (SELECT release FROM simAllGalaxyRel WHERE id = (SELECT releaseId FROM APP_Client WHERE id = 2))
    SET @highestSP = ISNULL((SELECT HighestSP FROM SimInstalledPackages WHERE ClientId = 2 AND simPackageID = 1), 1)
    SET @minorSP = ISNULL((SELECT SpMinorVersion FROM SimInstalledPackages WHERE ClientId = 2 AND simPackageID = 1), 0)
    SET @PackageUrlWin64 = @PackageUrlWin64 + CAST(@releaseId AS NVARCHAR(10)) + '/' + CAST(@highestSP AS NVARCHAR(10))
    SET @PackageUrlWin32 = @PackageUrlWin32 + CAST(@releaseId AS NVARCHAR(10)) + '/' + CAST(@highestSP AS NVARCHAR(10))
    SET @PackageUrlMac = @PackageUrlMac + CAST(@releaseId AS NVARCHAR(10)) + '/' + CAST(@highestSP AS NVARCHAR(10))
    IF @minorSP = 0
    BEGIN
        SET @PackageUrlWin64 = @PackageUrlWin64 + '/Edge_x64.exe'
        SET @PackageUrlWin32 = @PackageUrlWin32 + '/Edge_x86.exe'
        SET @PackageUrlMac = @PackageUrlMac + '/Edge_Mac.dmg'
    END
    ELSE
    BEGIN
        SET @PackageUrlWin64 = @PackageUrlWin64 + '/' + CAST(@minorSP AS NVARCHAR(10)) + '/Edge_x64.exe'
        SET @PackageUrlWin32 = @PackageUrlWin32 + '/' + CAST(@minorSP AS NVARCHAR(10)) + '/Edge_x86.exe'
        SET @PackageUrlMac = @PackageUrlMac + '/' + CAST(@minorSP AS NVARCHAR(10)) + '/Edge_Mac.dmg'
    END
END
ELSE
BEGIN
    SET @PackageUrlWin64 = @PackageUrlWin64 + '11/1/Edge_x64.exe'
    SET @PackageUrlWin32 = @PackageUrlWin32 + '11/1/Edge_x86.exe'
    SET @PackageUrlMac = @PackageUrlMac + '11/1/Edge_Mac.dmg'
END
INSERT @INSERT_PROP_RESULTS
EXEC  AppInsertGlobalParam
            @isPIT = 0,
            @createdTime = @nowTime,
            @name = N'PackageUrlWin64',
            @newValue = @PackageUrlWin64
INSERT @INSERT_PROP_RESULTS
EXEC  AppInsertGlobalParam
            @isPIT = 0,
            @createdTime = @nowTime,
            @name = N'PackageUrlWin32',
            @newValue = @PackageUrlWin32
INSERT @INSERT_PROP_RESULTS
EXEC  AppInsertGlobalParam
            @isPIT = 0,
            @createdTime = @nowTime,
            @name = N'PackageUrlMac',
            @newValue = @PackageUrlMac
--GenerateAuthCode.sql END
--SystemCreatedPolicyForDLO.sql START
    DECLARE @l_taskId1      INTEGER
    DECLARE @l_subTaskId1   INTEGER
    DECLARE @l_patternId1   INTEGER
    DECLARE @currentDate    DATETIME
    DECLARE @currentTime    INTEGER
    DECLARE @xmlText        XML
    SET @userId = (SELECT TOP 1 id FROM UMUsers WHERE flags&0x40=0x40)
    SET @currentDate = CONVERT(VARCHAR(12), GETUTCDATE())
    set @currentTime = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETDATE()))
    IF OBJECT_ID('tempdb.dbo.#TM_IDTable') IS NOT NULL
        DROP TABLE #TM_IDTable
    SELECT 0 as id, 0 as type INTO #TM_IDTable
    DECLARE @oem INT = ISNULL((SELECT CAST(value AS INT) FROM gxglobalparam WHERE name = 'MiniBrandId'), 0)
    DECLARE @dloClientGroup INT = ISNULL((SELECT MAX(id) FROM APP_ClientGroup WHERE flag&4096=4096 AND name = 'Laptop Clients'), 0)
    IF  @dloClientGroup = 0
    BEGIN
        SET @errString = 'ERROR: Could not find Laptop Clients group'
        GOTO ERROR_EXIT
    END
    -----------------------------------------------------------------------------
    -- System Created Schedule Policy for DLO
    IF NOT EXISTS (SELECT * FROM TM_Task WHERE flags&0x100 = 0x100)
    BEGIN
        -- Schedule Policy
        INSERT INTO TM_Task(taskName,
                            taskType,
                            flags,
                            status,
                            created,
                            modified,
                            alertId,
                            ownerId,
                            runUserId,
                            initiatedFrom,
                            sequenceNumber,
                            localeId,
                            description,
                            deleted,
                            disabled,
                            uninstalled,
                            invalid,
                            defaultTask,
                            savedReport,
                            serial,
                            policyType,
                            origCCId,
                            GUID,
                            isEZOperation,
                            isAgentlessSRM,
                            hidden)
        OUTPUT  INSERTED.taskId , 1 INTO #TM_IDTable
        VALUES             ('System Created for Laptop Clients',                -- Task Name
                            4,      -- Task Type
                            0x100,                              -- Task Flags
                            0,                              -- Status
                            0,                              -- Created
                            0,                              -- Modified
                            0,                              -- Alert ID
                            @userId,                            -- Owner ID
                            @userId,                            -- Run User ID
                            3,          -- Initiated From
                            0,                              -- Seq No
                            0,                              -- Locale ID
                            'System created schedule policy for Laptop clients',        -- Description
                            0,                              -- Deleted
                            0,                              -- Disabled
                            0,                              -- Uninstalled
                            0,                              -- Invalid
                            1,                              -- Default Task ???
                            0,                              -- Saved Report
                            0,                              -- Serial
                            0,                              -- Policy Type
                            DEFAULT,                        -- Original CC ID
                            newid(),                        -- GUID
                            0,                              -- isEZOperation
                            0,                              -- isAgentlessSRM
                            0)                              -- hidden
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_Task'
            GOTO ERROR_EXIT
        END
        SET @l_taskId1 = (SELECT id FROM #TM_IDTable WHERE type = 1)
        -- Association is all laptop clients
        INSERT INTO TM_AssocEntity (assocType,
                                    taskId,
                                    flags,
                                    created,
                                    clientGroupId,
                                    clientId,
                                    apptypeId,
                                    instanceId,
                                    backupsetId,
                                    subclientId,
                                    policyId,
                                    copyId,
                                    srmReportSet,
                                    srmReportType,
                                    exclude,
                                    trackingPolicyId,
                                    MediaAgentId,
                                    agentlessPolicyId,
                                    workflowId,
                                    sidbStoreId,
                                    libraryId,
                                    logMonitoringPolicyId)
        VALUES                      (28,            -- CLIENT_GROUP_ENTITY
                                     @l_taskId1,
                                     0,
                                     @currentTime,
                                     @dloClientGroup,
                                     0,
                                     0,
                                     0,
                                     0,
                                     0,
                                     0,
                                     0,
                                     0,
                                     0,
                                     0,
                                     0,
                                     0,
                                     0,
                                     0,
                                     0,
                                     0,
                                     0)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_AssocEntity'
            GOTO ERROR_EXIT
        END
        -- Schedule 1 :
        -- Incremental Schedule
        INSERT INTO TM_SubTask (subTaskName,
                                taskId,
                                subTaskType ,
                                operationType,
                                flags       ,
                                subTaskOrder,
                                deleted,
                                uninstalled,
                                defaultTask)
        OUTPUT  INSERTED.subTaskId , 2 INTO #TM_IDTable
        VALUES                 ('',                                 -- SubTask Name
                                @l_taskId1,                     -- Task ID
                                2,                          -- SubTask Type
                                2,                          -- Operation Type
                                0,                          -- Flags
                                0,                          -- SubTask Order
                                0,                          -- Deleted
                                0,                          -- Uninstalled
                                0)                          -- Default Task ???
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTask'
            GOTO ERROR_EXIT
        END
        SET @l_subTaskId1 = (SELECT id FROM #TM_IDTable WHERE type = 2)
        -- Pattern 1:
        -- OSC schedule
        INSERT INTO TM_Pattern(name,
                               ownerId,
                               status,
                               flags,
                               freq_type,
                               freq_interval,
                               freq_relative_interval,
                               freq_recurrence_factor,
                               freq_subday_interval,
                               skipOccurence,
                               skipDayNumber,
                               active_start_date,
                               active_start_time,
                               active_end_date,
                               active_end_time,
                               active_end_occurence,
                               created,
                               modified,
                               tzId,
                               calendarId,
                               description,
                               local_start_date,
                               local_end_date,
                               disabled,
                               deleted,
                               scheduling,
                               freq_restart_interval)
        OUTPUT  INSERTED.patternId , 3 INTO #TM_IDTable
        VALUES                ('',                          -- Name
                               @userId,                     -- Owner ID
                               0,                           -- Status
                               0,                           -- Flags
                               1024,                        -- Freq Type
                               0,                           -- Freq Interval
                               0,                           -- Freq Relative Interval
                               0,                           -- Freq Recurrence Factor
                               0,                           -- Freq Subday Interval
                               0,                           -- Skip Occurrence
                               0,                           -- Skip Day Number
                               @currentDate,                    -- Active Start Date
                               0,                           -- Active Start Time
                               '1970-01-01 00:00:00',               -- Active End Date
                               0,                           -- Active End Time
                               0,                           -- Active End Occurrence
                               0,                           -- Created
                               0,                           -- Modified
                               1000,                    -- Time Zone Id
                               1,                           -- Calendar Id
                               '',                          -- Description
                               DATEDIFF(s, '1970-01-01 00:00:00', @currentDate),    -- Local Start Date
                               0,                           -- Local End Date
                               0,                           -- Disabled
                               0,                           -- Deleted
                               0,                           -- Scheduling
                               0)                           -- Freq Restart Interval
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_Pattern '
            GOTO ERROR_EXIT
        END
        SET @l_patternId1 = (SELECT id FROM #TM_IDTable WHERE type = 3)
        -- Create Pattern Assoc
        INSERT INTO TM_PatternAssoc(patternId,
                                    subTaskId,
                                    flags,
                                    disabled,
                                    deleted,
                                    scheduling)
        VALUES(@l_patternId1,             -- Pattern ID
                                    @l_subTaskId1,              -- SubTask ID
                                    0,                          -- Flags
                                    0,                          -- Disabled
                                    0,                          -- Deleted
                                    0)                          -- Scheduling
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_PatternAssoc '
            GOTO ERROR_EXIT
        END
        -- SubTask XML Options
        INSERT INTO TM_SubTaskXMLOptions(subTaskID,
                                         xmlValue)
        VALUES                          (@l_subTaskId1,
                                         '<TMMsg_JobOption><backupOpts truncateLogsOnSource="0" backupLevel="2" incLevel="1" isSpHasInLineCopy="0" sybaseSkipFullafterLogBkp="0" runIncrementalBackup="1" doNotTruncateLog="0" runSILOBackup="0"><mediaOpt /><dataOpt followMountPoints="1" createNewIndex="0" useCatalogServer="1" skipConsistencyCheck="0" enforceTransactionLogUsage="0" /></backupOpts><commonOpts><automaticSchedulePattern minSyncInterval="0" minSyncIntervalMinutes="2" maxBackupInterval="72" minBackupInterval="36" maxBackupIntervalMinutes="0" ignoreOpWindowPastMaxInterval="0" minBackupIntervalMinutes="0"><minNetworkBandwidth enabled="0" /><stopIfOnBattery enabled="0" /><acPower enabled="0" /><stopSleepIfBackUp enabled="0" /><cpuUtilization enabled="0" /><specfificNetwork enabled="0" /><newOrModifiedFile enabled="0" /><wiredNetworkConnection enabled="0" /><emergencyBackup emergencyBackupCommandName=""><emergencyBackup enabled="0" /></emergencyBackup></automaticSchedulePattern><perfJobOpts /></commonOpts></TMMsg_JobOption>')
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskXMLOptions '
            GOTO ERROR_EXIT
        END
        SET @xmlText = (SELECT xmlValue FROM TM_SubTaskXMLOptions WHERE subTaskId = @l_subTaskId1)
        INSERT INTO TM_JobXMLOptions SELECT 0, @xmlText, @l_taskId1, @l_subTaskId1, 0, @currentTime, 0
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created  Schedule Policy-- Failed to insert in TM_JobXMLOptions'
            GOTO ERROR_EXIT
        END
        -- SubTask Options
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       100003,          -- BKP_OPTION
                                       15,
                                       6296592)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       100004,          -- BKP_EXTENDED
                                       1,
                                       '1000000000100100000000000000000100000000000000000010000000000000011')
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       100005,          -- BKP_NAS_OPTION
                                       15,
                                       4)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       140015,          -- COM_EXTENDED
                                       1,
                                       '1000000000100100000000000000000100000000000000000010000000000000011')
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       177623377,           -- options[1]/backupOpts[1]/@isSpHasInLineCopy
                                       0,
                                       0)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       236666161,           -- options[1]/commonOpts[1]/automaticSchedulePattern[1]/minNetworkBandwidth[1]/@enabled
                                       0,
                                       0)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
		                              optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       312510015,           -- options[1]/backupOpts[1]/@runIncrementalBackup
                                       0,
                                       1)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       362764450,           -- options[1]/commonOpts[1]/automaticSchedulePattern[1]/@minSyncIntervalMinutes
                                       8,
                                       2)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       416206437,           -- options[1]/commonOpts[1]/automaticSchedulePattern[1]/wiredNetworkConnection[1]/@enabled
                                       0,
                                       0)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       458405394,           -- options[1]/backupOpts[1]/@backupLevel
                                       7,
                                       2)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       589118090,           -- options[1]/backupOpts[1]/@runSILOBackup
                                       0,
                                       0)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       649116404,           -- options[1]/backupOpts[1]/dataOpt[1]/@useCatalogServer
                                       0,
                                       1)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       697451464,           -- options[1]/backupOpts[1]/dataOpt[1]/@enforceTransactionLogUsage
                                       0,
                                       0)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       703512134,           -- options[1]/commonOpts[1]/automaticSchedulePattern[1]/@maxBackupInterval
                                       8,
                                       72)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       756999446,           -- options[1]/backupOpts[1]/@incLevel
                                       7,
                                       1)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       800343273,           -- options[1]/commonOpts[1]/automaticSchedulePattern[1]/emergencyBackup[1]/@emergencyBackupCommandName
                                       0,
                                       '')
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       850125934,           -- options[1]/commonOpts[1]/automaticSchedulePattern[1]/stopSleepIfBackUp[1]/@enabled
                                       0,
                                       0)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       974354278,           -- options[1]/backupOpts[1]/@doNotTruncateLog
                                       0,
                                       0)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       1110217321,          -- options[1]/commonOpts[1]/automaticSchedulePattern[1]/@minBackupIntervalMinutes
                                       8,
                                       0)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       1197257326,          -- options[1]/backupOpts[1]/dataOpt[1]/@skipConsistencyCheck
                                       0,
                                       0)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       1205284996,          -- options[1]/commonOpts[1]/automaticSchedulePattern[1]/specfificNetwork[1]/@enabled
                                       0,
                                       0)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       1197257326,          -- options[1]/backupOpts[1]/dataOpt[1]/@skipConsistencyCheck
                                       0,
                                       0)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       1205284996,          -- options[1]/commonOpts[1]/automaticSchedulePattern[1]/specfificNetwork[1]/@enabled
                                       0,
                                       0)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       1266111406,          -- options[1]/commonOpts[1]/automaticSchedulePattern[1]/cpuUtilization[1]/@enabled
                                       0,
                                       0)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       1712751984,          -- options[1]/commonOpts[1]/automaticSchedulePattern[1]/@maxBackupIntervalMinutes
                                       8,
                                       0)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       1515007811,          -- options[1]/commonOpts[1]/automaticSchedulePattern[1]/acPower[1]/@enabled
                                       0,
                                       0)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       1545679425,          -- options[1]/commonOpts[1]/automaticSchedulePattern[1]/@minSyncInterval
                                       8,
                                       0)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       1611532840,          -- options[1]/commonOpts[1]/automaticSchedulePattern[1]/@minSyncInterval
                                       8,
                                       36)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       1641015063,          -- options[1]/commonOpts[1]/automaticSchedulePattern[1]/stopIfOnBattery[1]/@enabled
                                       0,
                                       0)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       1667682014,          -- options[1]/commonOpts[1]/automaticSchedulePattern[1]/newOrModifiedFile[1]/@enabled
                                       0,
                                       0)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       1712751984,          -- options[1]/commonOpts[1]/automaticSchedulePattern[1]/emergencyBackup[1]/emergencyBackup[1]/@enabled
                                       0,
                                       0)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       1735011734,          -- options[1]/backupOpts[1]/@sybaseSkipFullafterLogBkp
                                       0,
                                       0)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       1817749836,          -- options[1]/backupOpts[1]/dataOpt[1]/@followMountPoints
                                       0,
                                       1)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       2045937773,          -- options[1]/backupOpts[1]/dataOpt[1]/@createNewIndex
                                       0,
                                       0)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_SubTaskOptions(subTaskID,
                                      optionID,
                                      type,
                                      value)
        VALUES                        (@l_subTaskId1,
                                       2055741185,          -- options[1]/backupOpts[1]/@truncateLogsOnSource
                                       0,
                                       0)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'
            GOTO ERROR_EXIT
        END
        INSERT INTO TM_JobOptions SELECT 0, OPT.optionId, OPT.type, OPT.value, @l_taskId1, @l_subTaskId1, 0, @currentTime, 0
        FROM TM_SubTaskOptions AS OPT
        INNER JOIN TM_StaticTaskOption ST ON ST.optionId = OPT.optionId AND ST.defVal<>OPT.value
        WHERE subTaskId = @l_subTaskId1 AND OPT.optionId NOT IN (152984797, 587329586, 1189579219, 1496752764, 38201114, 458405394, 239177580)
        SET @errCode = @@ERROR
        IF  @errCode <> 0
        BEGIN
            SET @errString = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_JobOptions'
            GOTO ERROR_EXIT
        END
    END
--SystemCreatedPolicyForDLO.sql END
--Create Client groups for firewall topology START
DECLARE @scgId INTEGER
DECLARE @allCapability bigint = ISNULL((SELECT CAST(CAST(value AS NVARCHAR(MAX)) AS BIGINT) FROM GXGlobalParam WHERE name = 'SystemOwnerCapibilities' ),(select SUM(POWER(2.0, id-1)) FROM UMCapability))
DECLARE @ownerId int = ISNULL((SELECT TOP(1) id from UMUsers where (flags & 0x40 = 0x40)), 1)
DECLARE @masterRoleId INT = ISNULL((SELECT id FROM UMRoles WHERE name = 'Master' AND flags & (1 | 2) <> 0), 1)
DECLARE @scgExitCode INT = 0
DECLARE @scgExitMsg VARCHAR(1024) = ''
DECLARE @unixTime INT = dbo.getUnixTime(GETDATE())
IF NOT EXISTS (SELECT 1 from app_clientgroup WHERE (flag & 0x80000) != 0)
BEGIN
			DECLARE @CSClientGroupRule nvarchar (max) = '<scgRule op="0"><rules><rule op="1"><rules><rule filterID="100" propID="2" propType="4" secValue="CS Client" value="11" /></rules><rules><rule filterID="100" propID="2" propType="4" secValue="MediaAgent" value="5" /></rules><rules><rule filterID="108" propID="9" propType="6" value="&lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot;?&gt;&lt;App_AdvanceKeyInfo&gt;&lt;packages val=&quot;726&quot; /&gt;&lt;packages val=&quot;252&quot; /&gt;&lt;/App_AdvanceKeyInfo&gt;" /></rules><rules><rule filterID="1" propID="24" propType="1" /></rules></rule></rules></scgRule>'
			--SCG_PKID_CLIENT_PROP=2=prodID
			DECLARE @CSClientGroupRuleQuery NVARCHAR (MAX) = ''
			EXEC APPSCGV2GenerateQueryParams @CSClientGroupRule, @scgExitCode OUTPUT, @scgExitMsg OUTPUT, @CSClientGroupRuleQuery OUTPUT
			insert into app_clientgroup (name, description, flag, status, userId, refTime, modified, fwPorts, origCCId)
			values('Infrastructure', 'Select CS, MA, WebConsole, WebServer, proxy clients.', 0x81000, 0, @ownerId, 0, '0', '', 2)
			SET @scgId = @@IDENTITY
			-- refer vaultcx\Source\Include\AppMgr\AppClientGroupPropDefines.h
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@scgId, 'Client Group Unique Id', 7, 3, @unixTime, 0),
(@scgId, 'System Created', 7, 0, @unixTime, 0)
			insert into app_scgrule (scgId, ruleXml, ruleQuery, ownerId, created, modified)
			values(@scgId,
				@CSClientGroupRule,
				@CSClientGroupRuleQuery,
				1, 0, '0')
			INSERT INTO [UMUserandGroupEntityAssociation]
			([userId] ,[groupId] ,[providerId] ,[capabilities] ,[entityType] ,[objectId] ,[ownerUserId])
			VALUES (@ownerId ,0 ,0 ,@allCapability ,2572 ,@scgId , 0)
			--can we call sec_setCreatorForEntity stored procedure from here ?
			INSERT INTO [UMSecurityAssociations] (roleId, permissionId, userOrGroupId, isUser, entityType1, entityID1, isCreator, authorId)
				SELECT @masterRoleId, 0, @ownerID, 1, 28, @scgId, 1, 1
			EXEC AppSCGRefresh 1, @scgId
END
IF NOT EXISTS (SELECT 1 from app_clientgroup WHERE (flag & 0x100000) != 0)
BEGIN
			--SCG_PKID_CLIENT_ACTS_AS_PROXY=24=prodId
			DECLARE @ProxyClientRule nvarchar (max) = '<scgRule op="0"><rules><rule op="0"><rules><rule filterID="1" propID="24" propType="1" /></rules></rule></rules></scgRule>'
			DECLARE @ProxyClientRuleQuery NVARCHAR (MAX) = ''
			EXEC APPSCGV2GenerateQueryParams @ProxyClientRule, @scgExitCode OUTPUT, @scgExitMsg OUTPUT, @ProxyClientRuleQuery OUTPUT
			insert into app_clientgroup (name, description, flag, status, userId, refTime, modified, fwPorts, origCCId)
			values('Proxy Clients', 'Select proxy clients', 0x101000, 0, @ownerId, 0, '0', '', 2)
			SET @scgId = @@IDENTITY
			-- refer vaultcx\Source\Include\AppMgr\AppClientGroupPropDefines.h
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@scgId, 'Client Group Unique Id', 7, 4, @unixTime, 0),
(@scgId, 'System Created', 7, 0, @unixTime, 0)
			insert into app_scgrule (scgId, ruleXml, ruleQuery, ownerId, created, modified)
			values(@scgId,
				@ProxyClientRule,
				@ProxyClientRuleQuery,
				1, 0, '0')
			INSERT INTO [UMUserandGroupEntityAssociation]
			([userId] ,[groupId] ,[providerId] ,[capabilities] ,[entityType] ,[objectId] ,[ownerUserId])
			VALUES (@ownerId ,0 ,0 ,@allCapability ,2572 ,@scgId , 0)
			--can we call sec_setCreatorForEntity stored procedure from here ?
			INSERT INTO [UMSecurityAssociations] (roleId, permissionId, userOrGroupId, isUser, entityType1, entityID1, isCreator, authorId)
				SELECT @masterRoleId, 0, @ownerID, 1, 28, @scgId, 1, 1
			EXEC AppSCGRefresh 1, @scgId
END
--Create Client groups for firewall topology END
INSERT @INSERT_PROP_RESULTS
EXEC  AppInsertGlobalParam
            @isPIT = 0,
            @createdTime = @nowTime,
            @name = N'EdgeOEMConfiguredBrand',
            @newValue = N'1'
ERROR_EXIT:
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
   set @errCode = ERROR_NUMBER()
   set @errString = 'Problems executing [' +ERROR_PROCEDURE() +'], Line['
                    + CONVERT(nvarchar(10),ERROR_LINE()) + '] :' +ERROR_MESSAGE()
END   CATCH
SELECT @errCode, @errString
GO

IF EXISTS (select * from GxQscripts where name = 'AppPrepeareCSForEdgeMiniBrand')
	delete from GxQscripts where name = 'AppPrepeareCSForEdgeMiniBrand'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPrepeareCSForEdgeMiniBrand')
	delete from GXDBVersions where aliasname = 'AppPrepeareCSForEdgeMiniBrand'
GO

insert into GXDBVersions values(2, 'AppPrepeareCSForEdgeMiniBrand',  '00010001000200110000', 'AppPrepeareCSForEdgeMiniBrand', '00010001000200110000')
GO

