

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPreReqForClientDeletion.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppPreReqForClientDeletion')
BEGIN
	print '>>> Drop Stored Procedure: AppPreReqForClientDeletion <<<'
	drop procedure AppPreReqForClientDeletion
END
IF EXISTS (select * from GxQscripts where name='AppPreReqForClientDeletion')
	delete from GxQscripts where name = 'AppPreReqForClientDeletion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPreReqForClientDeletion')
	delete from GXDBVersions where aliasname = 'AppPreReqForClientDeletion'
GO
print '... Creating Procedure: AppPreReqForClientDeletion'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppPreReqForClientDeletion
  @clientId integer,
  @userId integer,
  @localeId integer
AS
  DECLARE @errorCode integer=0
  DECLARE @errorString nvarchar(max) = ''
DECLARE @PLATFORM_TYPE_MEDIA_AGENT	INT = 2
IF EXISTS (SELECT 1 FROM APP_Platform (NOLOCK) WHERE clientId = @clientId AND platformType = @PLATFORM_TYPE_MEDIA_AGENT)
BEGIN
SET @errorCode = (4707 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	GOTO PROC_EXIT
END
DECLARE @clientIdInchar nvarchar(10)
DECLARE @clientList table ( clientId integer)
DECLARE @clCnt INT = 0
SET @clientIdInchar = CAST(@clientId as nvarchar(10))
INSERT INTO @clientList
SELECT componentNameId
FROM APP_CLIENTPROP (NOLOCK)
WHERE
attrName = 'Object Server Member Servers List'
AND
attrval = @clientIdInchar
AND
modified = 0
SET @clCnt = @@ROWCOUNT
IF @clCnt > 0
BEGIN
SET @errorCode = (1968 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	SET @errorString = ISNULL((SELECT EvLocaleMsgs.Message
	from EvLocaleMsgs (NOLOCK)
where EvLocaleMsgs.MessageId = (1968 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	AND [localeId] = @localeId),'')
	DECLARE @names nvarchar(max)
	SELECT @names = COALESCE(@names + ', ', '') + name FROM @clientList JOIN APP_CLIENT ON id = clientId
	-- Now replace the parameter with the entity name
	SET @errorString = replace(@errorString,'^1%s',ISNULL(@names,''))
END
IF @errorCode = 0 -- If no error so far, check if client is associated to a resource pool as an index server
BEGIN
	DECLARE @resourcePoolId INT = -1
	SET @resourcePoolId = ISNULL((SELECT resourcePoolId FROM APP_ResourcePool (NOLOCK) WHERE indexServerClientId = @clientId),-1)
	IF @resourcePoolId != -1 -- Found a resource pool associated to client
	BEGIN
		DECLARE @resourcePoolName NVARCHAR(MAX)
		SET @resourcePoolName = (SELECT resourcePoolName FROM APP_ResourcePool (NOLOCK) WHERE resourcePoolId = @resourcePoolId)
SET @errorCode = (4533 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString =  ISNULL((SELECT EvLocaleMsgs.Message
										FROM EvLocaleMsgs (NOLOCK)
WHERE EvLocaleMsgs.MessageId = (4533 | (CAST(POWER(2, 24) AS BIGINT) * 35))
										AND [localeId] = @localeId),'Failed to delete client as its associated to a resource pool. Please delete the resource pool and try again')
		SET @errorString = REPLACE(@errorString, '^1%s',@resourcePoolName)
	END
END
PROC_EXIT:
IF @errorCode <> 0 AND @errorString = ''
BEGIN
	SET @errorString = ISNULL((SELECT EvLocaleMsgs.Message
	from EvLocaleMsgs (NOLOCK)
	where EvLocaleMsgs.MessageId = @errorCode
	AND [localeId] = @localeId),'')
END
SELECT @errorCode,@errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppPreReqForClientDeletion')
	delete from GxQscripts where name = 'AppPreReqForClientDeletion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPreReqForClientDeletion')
	delete from GXDBVersions where aliasname = 'AppPreReqForClientDeletion'
GO

insert into GXDBVersions values(2, 'AppPreReqForClientDeletion',  '00000000000000000000', 'AppPreReqForClientDeletion', '00000000000000000000')
GO

