

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPreProcessAdvancedIndexingRequest.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppGetCompanyProperties()
--  | Description:  Allows for GET of company properties for provided ProviderID
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPreProcessAdvancedIndexingRequest.sp,v $ $Id: AppPreProcessAdvancedIndexingRequest.sp,v 1.1.2.2 2020/09/13 05:04:30 pankajkumar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPreProcessAdvancedIndexingRequest')
BEGIN
	print '>>> Drop Stored Procedure: AppPreProcessAdvancedIndexingRequest <<<'
	drop procedure AppPreProcessAdvancedIndexingRequest
END
IF EXISTS (select * from GxQscripts where name='AppPreProcessAdvancedIndexingRequest')
	delete from GxQscripts where name = 'AppPreProcessAdvancedIndexingRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPreProcessAdvancedIndexingRequest')
	delete from GXDBVersions where aliasname = 'AppPreProcessAdvancedIndexingRequest'
GO
print '... Creating Procedure: AppPreProcessAdvancedIndexingRequest'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPreProcessAdvancedIndexingRequest
  @o_xmlText XML OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @userId     		INTEGER
DECLARE @localeId     		INTEGER
DECLARE @i_StoragePolicy	INTEGER
DECLARE @i_AppType			INTEGER
DECLARE @errorCode			INTEGER
DECLARE @errorString		NVARCHAR(1024)
BEGIN TRY
	SET @userId			=	ISNULL (( SELECT ref.value('@userId', 'INT')
									FROM @o_xmlText.nodes ('App_AdvancedIndexingPreProcessRequest/processinginstructioninfo/user') R(ref)), 0)
	SET @localeId			=	ISNULL (( SELECT ref.value('@localeId', 'INT')
									FROM @o_xmlText.nodes ('App_AdvancedIndexingPreProcessRequest/processinginstructioninfo/locale') R(ref)), 0)
	SET @i_StoragePolicy	=	ISNULL (( SELECT ref.value('@storagePolicyId', 'INT')
									FROM @o_xmlText.nodes ('App_AdvancedIndexingPreProcessRequest/storagePolicy') R(ref)), -1)
	SET @i_AppType			=	ISNULL (( SELECT ref.value('@appTypeId', 'INT')
									FROM @o_xmlText.nodes ('App_AdvancedIndexingPreProcessRequest/agentType') R(ref)), 0)
	DECLARE @packagesTbl TABLE (t_simPackageId INT)
	--VSA requires 2 packages to be installed
	DECLARE @packageCount INT = 2
	INSERT INTO @packagesTbl
VALUES	(55),
(1306) ,
(263),
(1156)
	--NFS Object store requires 3 packages to be installed
	IF @i_AppType =4  --App::EdgeSystemDriveTypes_NFS_OBJECT_STORE
	BEGIN
		SET @packageCount = 3
		INSERT INTO @packagesTbl
VALUES	(725),
(1157)
	END
	-- Now get all Media Agents for the this Storage Policy
	DECLARE @mediaAgentsTbl TABLE (clientId INT, clientName NVARCHAR(MAX), isAllPackageInstalled INT)
	-- Be optimistic
	SET @errorCode = 0
	SET @errorString = ''
	DECLARE @doesAllMAHaveRequiredPackages INT
	-- IF Storage Policy not provided
	IF (@i_StoragePolicy = -1) AND NOT EXISTS(SELECT 1 FROM @o_xmlText.nodes ('App_AdvancedIndexingPreProcessRequest/mediaAgents') R(ref))
	BEGIN
SET @errorCode = (1 | (CAST(POWER(2, 24) AS BIGINT) * 1))
SET @errorString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)  WHERE messageId = (1 | (CAST(POWER(2, 24) AS BIGINT) * 1)) AND localeId = @localeId)
	END
	IF (@errorCode = 0 AND @i_StoragePolicy != -1)
	BEGIN
		IF EXISTS (SELECT 1 FROM archGroup WHERE id=@i_StoragePolicy)
		BEGIN
			INSERT INTO @mediaAgentsTbl
			SELECT	DPool.ClientId, AC.displayName ,0
				FROM	ArchGroup AG WITH(READUNCOMMITTED),
						MMDataPath DPath WITH(READUNCOMMITTED),
						MMDrivePool DPool WITH(READUNCOMMITTED),
						App_Client AC  WITH(READUNCOMMITTED)
				WHERE	AG.id = @i_StoragePolicy
						AND AG.defaultCopy = DPath.CopyId
						AND DPath.DrivePoolId = DPool.DrivePoolId
						AND AC.id=DPool.ClientId
				ORDER BY 2 DESC
		END
		ELSE
		BEGIN
SET @errorCode = (25 | (CAST(POWER(2, 24) AS BIGINT) * 80))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (25 | (CAST(POWER(2, 24) AS BIGINT) * 80)) and localeid = @localeId)
		END
	END
	ELSE
	BEGIN
		INSERT INTO @mediaAgentsTbl
		SELECT	AC.id, AC.displayName ,0
		FROM	@o_xmlText.nodes ('App_AdvancedIndexingPreProcessRequest/mediaAgents') R(ref)
				INNER JOIN App_Client AC  WITH(READUNCOMMITTED)
				ON AC.id=ref.value('@clientId', 'INT')
		ORDER BY 2 DESC
	END
	UPDATE @mediaAgentsTbl
	SET isAllPackageInstalled  = (CASE WHEN (SELECT COUNT(S.simPackageID)
											FROM simInstalledPackages S WITH(READUNCOMMITTED)
											JOIN @packagesTbl P ON S.simPackageID = P.t_simPackageId
											WHERE S.ClientId = M.clientId) = @packageCount
									 THEN 1
									 ELSE 0 END)
	FROM @mediaAgentsTbl M
	IF EXISTS (SELECT 1 FROM @mediaAgentsTbl WHERE isAllPackageInstalled=0)
			SET @doesAllMAHaveRequiredPackages = 0
		ELSE
			SET @doesAllMAHaveRequiredPackages = 1
	SET @o_xmlText =(SELECT
						@doesAllMAHaveRequiredPackages AS '@doesAllMAHaveRequiredPackages',
						(
							SELECT
								clientId AS '@clientId', clientName AS '@clientName'
								FROM @mediaAgentsTbl WHERE isAllPackageInstalled=1
								FOR  XML PATH('mediaAgentsWithPackagesInstalled'), TYPE
						),
						(
							SELECT
								clientId AS '@clientId', clientName AS '@clientName'
								FROM @mediaAgentsTbl WHERE isAllPackageInstalled=0
								FOR  XML PATH('mediaAgentsWithPackagesMissing'), TYPE
						),
						(
							SELECT @errorCode  AS '@errorCode', @errorString AS '@errorMessage'
								FOR    XML PATH('genericError'), TYPE
						)
				FOR XML PATH('App_AdvancedIndexingPreProcessResponse'),TYPE)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @o_xmlText =(SELECT
						(
							SELECT @errorCode  AS '@errorCode', @errorString AS '@errorMessage'
								FOR    XML PATH('genericError'), TYPE
							)
						FOR XML PATH('AppAdvancedIndexingPreProcessResponse'),TYPE)
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
	SELECT @o_xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppPreProcessAdvancedIndexingRequest')
	delete from GxQscripts where name = 'AppPreProcessAdvancedIndexingRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPreProcessAdvancedIndexingRequest')
	delete from GXDBVersions where aliasname = 'AppPreProcessAdvancedIndexingRequest'
GO

insert into GXDBVersions values(2, 'AppPreProcessAdvancedIndexingRequest',  '00010001000200020000', 'AppPreProcessAdvancedIndexingRequest', '00010001000200020000')
GO

