

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPostFailoverActions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2019  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPostFailoverActions')
BEGIN
	print '>>> Drop Stored Procedure: AppPostFailoverActions <<<'
	drop procedure AppPostFailoverActions
END
IF EXISTS (select * from GxQscripts where name='AppPostFailoverActions')
	delete from GxQscripts where name = 'AppPostFailoverActions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPostFailoverActions')
	delete from GXDBVersions where aliasname = 'AppPostFailoverActions'
GO
print '... Creating Procedure: AppPostFailoverActions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPostFailoverActions
AS
  DECLARE @errCode INTEGER
  DECLARE @errStr NVARCHAR(1024)
SET @errCode = 0
SET @errStr = ''
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
BEGIN
	-- SP is called post planned or unplanned failover. We can use this to configure whatever needed due to change in CS
	-- This is called post updatecssecondinstance.. once all configuration is done. Error here doesnt impact return code for updatecssecondinstance call.
	-- No tran passed here.
	-- Delete from runtime. IF cs timezone has changed post failover, we want to recompute runtimes so that they run at correct time.
	-- MR 287950
	DELETE FROM TM_RunTime WHERE processed = 0
	DECLARE @xmlForWQ XML = NULL
	DECLARE @WQResponse TABLE(xmlResponse XML)
	DECLARE @workToken INT = 62 -- 62:WORK_TOKEN_UPDATE_CLIENT_CONFIG
	-- push work tokens to update clock skew time for all clients post failover.
	SET @xmlForWQ = ( SELECT @workToken '@workToken',
		(
			SELECT clientId '@clientId' FROM PatchInstallHistory (NOLOCK)
			group by clientID
			HAVING max(HighestSP)>21
			FOR XML PATH('entityList'),TYPE
		)
		FOR XML PATH('App_SubmitWorkQueueReq')
	)
	IF @xmlForWQ IS NOT NULL
	BEGIN
		INSERT INTO @WQResponse
		EXEC AppWorkQueueSubmitRequestXML @xmlForWQ
	END
	SELECT @errCode, ISNULL(@errStr,'')
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppPostFailoverActions')
	delete from GxQscripts where name = 'AppPostFailoverActions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPostFailoverActions')
	delete from GXDBVersions where aliasname = 'AppPostFailoverActions'
GO

insert into GXDBVersions values(2, 'AppPostFailoverActions',  '00000000000000000000', 'AppPostFailoverActions', '00000000000000000000')
GO

