

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPostFSAddonInstall.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016 CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +================================================================================================+
--  |   Procedure:  AppPostFSAddonInstall()
--  |
--  | Description:  SP for Modifying subclient properties post windows install of FS Addon.
--  |
--  |       Input:  client id
--  |      Output:  ErrorCode, ErrorString to determine status of the operation
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   1.0		   rengu  	To Enable Archiving feature after FS Addon installation
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppPostFSAddonInstall <<<'

IF EXISTS (select * from sysobjects where name='AppPostFSAddonInstall')
	drop procedure AppPostFSAddonInstall
IF EXISTS (select * from GxQscripts where name='AppPostFSAddonInstall')
	delete from GxQscripts where name = 'AppPostFSAddonInstall'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPostFSAddonInstall')
	delete from GXDBVersions where aliasname = 'AppPostFSAddonInstall'
GO
print '... Creating Procedure: AppPostFSAddonInstall'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPostFSAddonInstall
  @clientId int
AS
  DECLARE @oxml XML
--Declarations
DECLARE @errorCode INT=0
DECLARE @errorString nvarchar(MAX)=N'Success'
DECLARE @permissionsList nvarchar(2048)=NULL
DECLARE @subClientId INT = -1;
DECLARE @planId INT = 0
DECLARE @archivingFeatureType INT = 6
DECLARE @archivingEnabledOnPlan INT = 0
DECLARE @archivingPresentOnClient INT = 0
DECLARE @nowTime INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
DECLARE @workQOutPutTbl TABLE (errCode INT, errString NVARCHAR(MAX))
DECLARE @workQueueParam NVARCHAR(MAX) = NULL
DECLARE @clientOSType INT = 0
DECLARE @archivingPermissionId INT = 0
DECLARE @archivingPkgId INT = 753  /*WIN INSTALL PACKAGE ID*/
DECLARE @i_osType INT = 1 /* 1-Windows, 2-UNIX*/
DECLARE @retentionDaysFromPolicy INT = 0
DECLARE @subClientPolicyId INT= -1
DECLARE @idaType INT = 0
---------------------------------------------------
-- Audit Parameters
---------------------------------------------------
DECLARE @opMsgId            INTEGER
DECLARE @opEvMsgId          INTEGER
DECLARE @opId               INTEGER
DECLARE @paramMsgId         INTEGER
DECLARE @paramData          NVARCHAR(1024)
DECLARE @dataIsEvent        INTEGER = 0
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	SET @clientOSType = dbo.scgGetClientOSType(@clientId)
	--Checking if valid client
	IF @clientId > 0 AND EXISTS(SELECT 1 FROM App_Client WHERE id = @clientId AND (status & 4096) = 4096) AND (@clientOSType = @i_osType) /*WIN*/
	BEGIN
		if OBJECT_ID('tempdb.dbo.#existingpermissions') is not null drop table dbo.#existingpermissions
		create table #existingpermissions
		(
			permissionId integer PRIMARY KEY,
			enabled integer
		);
		SET @permissionsList = ISNULL((
SELECT attrVal FROM App_ClientProp WHERE componentNameId = @clientId AND attrName = 'Feature'
		),'')
		INSERT INTO #existingpermissions
		SELECT Value,1 FROM
			dbo.cte_split_inline(@permissionsList,',') WHERE Value <> 0
		SET @archivingPresentOnClient = ISNULL((SELECT 1 FROM #existingpermissions WHERE permissionId = @archivingFeatureType),0)
	---------------------------------------------------------------------
	-- Archiving Feature Checks
	---------------------------------------------------------------------
		SET @archivingPermissionId = (SELECT id FROM UMPermissions WHERE permissionName='Archiving' )
		--fetching plan Id for the client
		SET @planId = ISNULL((
			SELECT CAST(attrVal AS INT) FROM APP_ClientProp
WHERE componentNameId = @clientId AND attrName = 'Associated Plan'
			),0)
		--Checking whether Archiving is Enabled on Plan Level
		SET @archivingEnabledOnPlan = ISNULL((SELECT 1 FROM   UMRolesPermissions URP INNER JOIN UMPermissions UP ON URP.permissionId = UP.id
WHERE  URP.roleId = CAST(dbo.AppPlanGetEntityValue(@planId, 'Feature', default) AS INT)
												AND UP.id = @archivingPermissionId ),0)
		-- "OR" because the archiving feature after being enabled can still be disabled from the plan. But we should still support Archiving
		IF @archivingEnabledOnPlan = 1 OR @archivingPresentOnClient = 1
		BEGIN
			--Fetching default subclient id
			SET @subClientId = ISNULL( (SELECT SC.id
FROM APP_Application SC WHERE SC.clientId = @clientId AND SC.subclientStatus & 0x00008 = 0x00008
AND SC.subclientStatus & 0x00010 != 0x00010),-1)
SET @idaType = ISNULL((SELECT attrval FROM APP_ClientProp WITH (NOLOCK) WHERE attrname = 'Ida Type'
	                                    AND componentNameId = @clientId AND modified = 0),4)
SET @subClientPolicyId = IIF(@idaType = 2, dbo.AppPlanGetEntityValueV2(@planId, 'Subclient policy 2', default),
IIF(@idaType=3, dbo.AppPlanGetEntityValueV2(@planId, 'Subclient policy 3', default),
dbo.AppPlanGetEntityValueV2(@planId, 'Subclient policy 4', default)))
			SET @retentionDaysFromPolicy = ISNULL((SELECT CAST(SCP.attrVal AS INT) FROM APP_SubClientProp SCP
												WHERE SCP.attrName = N'Days to keep items past their expiration'
												AND SCP.modified = 0
												AND SCP.componentNameId = @subClientPolicyId),730)
			--Updating Subclient properties
			UPDATE APP_SubClientProp SET modified = @nowTime
			WHERE componentNameId = @subClientId
AND attrName IN ('Is Archive Retention Mode Enabled','User deleted stubs expiration days','Turbo Mode Enable Stubbing','Enable Redundancy For Data Backedup')
			AND modified = 0
			INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
VALUES(@subClientId,'Is Archive Retention Mode Enabled', 7, 1 , @nowTime, 0, 0),
(@subClientId,'User deleted stubs expiration days', 7, @retentionDaysFromPolicy , @nowTime, 0, 0),
(@subClientId,'Turbo Mode Enable Stubbing' , 2, 1 , @nowTime, 0, 0),
(@subClientId,'Enable Redundancy For Data Backedup' , 2, 1 , @nowTime, 0, 0)
			--Updating Ida properties
IF NOT EXISTS( SELECT 1 FROM APP_IDAProp IP where IP.attrName = 'Enable Archive' AND IP.modified = 0
							AND IP.componentNameId =
								(
									SELECT id FROM APP_IDAName WHERE clientId = @clientId AND appTypeId IN (SELECT appTypeId FROM APP_AppTypeGroupAssoc WHERE appGroupId IN (34,57) /*APPGRP_UnixFileSystem, APPGRP_WindowsFileSystemIDA */	)
								)
						 )
			BEGIN
				INSERT INTO APP_IDAProp
SELECT AG.id,'Enable Archive' , 2, 1 , @nowTime, 0, 0
						FROM APP_IDAName AG
						WHERE AG.appTypeId IN (
							select appTypeId from APP_AppTypeGroupAssoc where appGroupId IN ( 57, 34) /*APPGRP_WindowsFileSystemIDA*/
						)
						AND AG.clientId = @clientId
			END
			--After the properties are modified start a job for the modified subclient
			SET @workQueueParam = CONVERT( NVARCHAR(MAX),(SELECT @subClientId AS '@subclientID' FOR XML PATH('TMMsg_SubclientChangeReq'), TYPE))
			INSERT INTO @workQOutPutTbl
			EXEC AppWorkQueueSubmitRequest 7/*WORK_TOKEN_SUBCLIENT_CONTENT*/, 0, 0, @clientId, 0, @workQueueParam
			SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
		END
	END
	ELSE
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Invalid Client Id'
	END
	if OBJECT_ID('tempdb.dbo.#existingpermissions') is not null drop table dbo.#existingpermissions
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
            SET @errorCode = ERROR_NUMBER()
            SET @errorString = N'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
END  CATCH
GENERATE_OUTPUT:
	SET @oxml = (
					SELECT	@errorCode as '@errorCode',
							@errorString as '@errorMessage'
								FOR XML PATH ( 'App_GenericResp' ),TYPE
				 )
	SELECT @oxml
GO

IF EXISTS (select * from GxQscripts where name = 'AppPostFSAddonInstall')
	delete from GxQscripts where name = 'AppPostFSAddonInstall'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPostFSAddonInstall')
	delete from GXDBVersions where aliasname = 'AppPostFSAddonInstall'
GO

insert into GXDBVersions values(2, 'AppPostFSAddonInstall',  '00000000000000000000', 'AppPostFSAddonInstall', '00000000000000000000')
GO

