

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPopulateVMSubclientAssociations.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPopulateVMSubclientAssociations.sp,v $ $Id: AppPopulateVMSubclientAssociations.sp,v 1.1.2.5 2020/02/28 16:29:05 alakra Exp $";
-- 	+---------------------------------------------------------------------------------------+
--	| 			Procedure : "AppPopulateVMSubclientAssociations"
--	|	This Procedure is used to do intial processing of VM to subclient association
-- 	+---------------------------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPopulateVMSubclientAssociations')
BEGIN
	print '>>> Drop Stored Procedure: AppPopulateVMSubclientAssociations <<<'
	drop procedure AppPopulateVMSubclientAssociations
END
IF EXISTS (select * from GxQscripts where name='AppPopulateVMSubclientAssociations')
	delete from GxQscripts where name = 'AppPopulateVMSubclientAssociations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPopulateVMSubclientAssociations')
	delete from GXDBVersions where aliasname = 'AppPopulateVMSubclientAssociations'
GO
print '... Creating Procedure: AppPopulateVMSubclientAssociations'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPopulateVMSubclientAssociations
  @xmlText XML,
  @o_xmlText NVARCHAR(MAX) OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
----DECLARE @xmlText XML ='<App_AssociateVMToPlanRequest>
--  <processinginstructioninfo>
--    <user userId="1"></user>
--  </processinginstructioninfo>
--  <vmInfo>
--    <plan planId="1" planName="Server plan core"></plan>
--    <vmClients clientId="51" clientName="glider1"></vmClients>
--    <vmClients clientId="49" clientName="glider5"></vmClients>
--  </vmInfo>
--  <vmInfo>
--    <plan planId="2" planName="Mixed Storage CS included"></plan>
--    <vmClients clientId="50" clientName="glider2"></vmClients>
--    <vmClients clientId="58" clientName="priyafailback"></vmClients>
--    <vmClients clientId="56" clientName="priyaazlin"></vmClients>
--	<vmClients clientId="62" clientName="hsauto3"></vmClients>
--  </vmInfo>
--  <vmInfo>
--    <plan planId="14" planName="Server Plan"></plan>
--    <vmClients clientId="53" clientName="priyaazwin1"></vmClients>
--    <vmClients clientId="57" clientName="priyaazlin1"></vmClients>
--  </vmInfo>
--</App_AssociateVMToPlanRequest>'
DECLARE  @o_errCode				INTEGER
DECLARE  @o_errString			VARCHAR(1024)
BEGIN TRY
	DECLARE @i_userId INTEGER=0
	SET @i_userId = ISNULL((SELECT  ref.value('@userId', 'INT') AS client
								  FROM    @xmlText.nodes('App_AssociateVMToPlanRequest/processinginstructioninfo/user') R ( ref )),0)
	DECLARE @i_localeId INTEGER=0
	SET @i_localeId = ISNULL((SELECT  ref.value('@localeId', 'INT') AS client
								  FROM    @xmlText.nodes('App_AssociateVMToPlanRequest/processinginstructioninfo/locale') R ( ref )),0)
	DECLARE @userCompanyId NVARCHAR(32) = dbo.AppGetCompanyForUserOrUserGroup(@i_userId , 1)
	DECLARE @companyName NVARCHAR(128)= ISNULL((SELECT hostName FROM UMDSProviders WHERE @userCompanyId=CAST(id AS NVARCHAR(32)) AND @userCompanyId<>'0'), 'Commcell')
	DECLARE @CompanyLikeInitial NVARCHAR(32) = @userCompanyId + '[^0-9]%'
	DECLARE @CompanyLikeMid		NVARCHAR(32) = '%[^0-9]' + @userCompanyId + '[^0-9]%'
	DECLARE @CompanyLikeEnd		NVARCHAR(32) = '%[^0-9]' + @userCompanyId
	DECLARE @invalidClients NVARCHAR(MAX)
	DECLARE @invalidPlans	NVARCHAR(MAX)
	IF object_id('tempdb.dbo.#InputVMList')	IS NOT null						DROP TABLE #InputVMList
	IF object_id('tempdb.dbo.#InputClientListTbl')	IS NOT null				DROP TABLE #InputClientListTbl
	IF OBJECT_ID('tempdb.dbo.#validSubclients') IS NOT NULL					DROP TABLE #validSubclients
	IF OBJECT_ID('tempdb.dbo.#subclientsContent') IS NOT NULL				DROP TABLE #subclientsContent
	IF OBJECT_ID('tempdb.dbo.#subclientsContent_Original') IS NOT NULL		DROP TABLE #subclientsContent_Original
	IF OBJECT_ID('tempdb.dbo.#subclientsFilter') IS NOT NULL				DROP TABLE #subclientsFilter
	IF OBJECT_ID('tempdb.dbo.#subclientsInputPlanMapping') IS NOT NULL		DROP TABLE #subclientsInputPlanMapping
	IF OBJECT_ID('tempdb.dbo.#FinalSubclientProcessing') IS NOT NULL		DROP TABLE #FinalSubclientProcessing
	IF OBJECT_ID('tempdb.dbo.#userClients') IS NOT NULL						DROP TABLE #userClients
	IF OBJECT_ID('tempdb.dbo.#PlansList')	IS NOT NULL						DROP TABLE #PlansList
	IF OBJECT_ID('tempdb.dbo.#userSubClients') IS NOT NULL					DROP TABLE #userSubClients
	IF OBJECT_ID('tempdb.dbo.#taggedSubClients') IS NOT NULL				DROP TABLE #taggedSubClients
	--0x4888034 means filter out subclient having any one of bits:
	--CV_STATUS_DELETED,CV_STATUS_DUMMY,CV_STATUS_HIDDEN,CV_STATUS_EDC_DISCOVERED,CV_STATUS_NEEDS_MORE_CONFIG,CV_STATUS_MINING,CV_STATUS_REFERENCE_COPY
	DECLARE @invalidSubclient INT = 0x4888034
	-- Initial Input
	CREATE TABLE #InputVMList
	(
		vmClientId			INT,
		vmClientName		NVARCHAR(MAX),
		planId				INT,
		planName			NVARCHAR(MAX)
	)
	-- Processed Input with basic details
	-- We will exclude any protected VM
	CREATE TABLE #InputClientListTbl
	(
		vmClientId					INT,
		vmClientName				NVARCHAR(MAX),
		vmClientGuid				NVARCHAR(128),
		planId						INT,
		pseudoClientId				INT,
		pseudoInstanceId			INT,
		currentVMGroupId			INT,
		isDirectPartOfContent		INT,
		newVMGroupId				INT,
		isProtectedVM				INT,
		isProcessed					INT DEFAULT 0
	)
	CREATE TABLE #validSubclients (clientId INT, instanceID INT, backupsetId INT, subclientID INT, planId INT, isAnyIndirectContentPresent INT DEFAULT 0)
	CREATE TABLE #subclientsContent (id INT NOT NULL IDENTITY PRIMARY KEY, subclientId INT, vmClientId INT, vmClientName NVARCHAR(MAX), vmGuid NVARCHAR(128))
	CREATE TABLE #subclientsContent_Original (id INT NOT NULL IDENTITY PRIMARY KEY, subclientId INT, vmClientId INT, vmClientName NVARCHAR(MAX), vmGuid NVARCHAR(128))
	CREATE TABLE #subclientsInputPlanMapping (id INT NOT NULL IDENTITY PRIMARY KEY, subclientId INT, planId INT, planCount INT)
	CREATE TABLE #subclientsFilter (subclientId INT, vmClientId INT, vmClientName NVARCHAR(MAX), vmGuid NVARCHAR(128), isCurrentAssociation INT)
	-- Final XML will have vmContentOperationType and vmFilterOperationType. There will be no vmDiskFilterOperationType
	CREATE TABLE #FinalSubclientProcessing (id INT NOT NULL IDENTITY PRIMARY KEY, subclientId INT, subClientName NVARCHAR(1024), backupsetId INT, instanceId INT, clientId INT, planId INT, finalContent XML, finalFilter XML, oldsubclientId INT)
	CREATE TABLE #PlansList(planId INT NOT NULL)
	CREATE CLUSTERED INDEX PlansList_planId_idx ON #PlansList(planId)
	CREATE TABLE #userClients                      (t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT)
	CREATE TABLE #userSubClients                   (t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT)
	CREATE TABLE #taggedSubClients                 (id INT NOT NULL IDENTITY PRIMARY KEY, subClientId INT, isUserCompanyTagged INT)
	-- Poupulate details from request
	INSERT INTO #InputVMList
	SELECT ISNULL(clientInfo.N.value('(@clientId)', 'INT'), 0),ISNULL(clientInfo.N.value('(@clientName)', 'NVARCHAR(MAX)'), 0),ISNULL(R.ref.query('.').value('(//./plan/@planId)[1]', 'INT'), 0),ISNULL(R.ref.query('.').value('(//./plan/@planName)[1]', 'nvarchar(1024)'), 0)
	FROM @xmlText.nodes('App_AssociateVMToPlanRequest/vmInfo') R ( ref )
	cross apply R.ref.nodes('vmClients') as  clientInfo(N)
	-- Security Check
	-- All plan that user have rights to use
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 159, '#PlansList'
	-- All client that user have rights to manage - EV_MANAGE_APPLICATION
EXEC sec_getIdaObjectsForUser @i_userId, 3 , 2, 1, '#userClients'
	-- All subclient that user have atleast view rights
EXEC sec_getIdaObjectsForUser @i_userId, 7 , 0, 1, '#userSubClients'
	-- Client input present for which user don't seems to have right or missing form above list
	IF EXISTS (SELECT 1 FROM #InputVMList IVM
				LEFT OUTER JOIN #userClients UC
					ON UC.t_clientId=IVM.vmClientId
				WHERE UC.t_clientId IS NULL)
	BEGIN
		SELECT @invalidClients = COALESCE(@invalidClients+', ' ,'') + IVM.vmClientName FROM #InputVMList IVM
				LEFT OUTER JOIN #userClients UC
					ON UC.t_clientId=IVM.vmClientId
				WHERE UC.t_clientId IS NULL
SET @o_errCode = (4495 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @o_errString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
						WHERE messageId = @o_errCode AND [localeId] = @i_localeId)
		--SET @o_errString = REPLACE(@o_errString, '^1%s', 'EV_MANAGE_APPLICATION')
		SET @o_errString = REPLACE(@o_errString, '^1%s', 'Agent Management')
		SET @o_errString = REPLACE(@o_errString, '^2%s', @invalidClients)
		GOTO GENERATE_OUTPUT
	END
	-- User should have "Use Plan" rights on all the provided plan
	IF EXISTS (SELECT 1 FROM #InputVMList IVM
			LEFT OUTER JOIN #PlansList PL
				ON PL.planId=IVM.planId
			WHERE PL.planId IS NULL)
	BEGIN
		SELECT @invalidPlans = COALESCE(@invalidPlans+', ' ,'') + IVM.planName FROM #InputVMList IVM
			LEFT OUTER JOIN #PlansList PL
				ON PL.planId=IVM.planId
			WHERE PL.planId IS NULL
		GROUP BY IVM.planName
SET @o_errCode = (4496 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @o_errString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
						WHERE messageId = @o_errCode AND [localeId] = @i_localeId)
		--SET @o_errString = REPLACE(@o_errString, '^1%s', CAT_PLAN_ASSOCIATIONS_ADD_REMOVE_NAME)
		SET @o_errString = REPLACE(@o_errString, '^1%s', 'Use Plan')
		SET @o_errString = REPLACE(@o_errString, '^2%s', @invalidPlans)
		GOTO GENERATE_OUTPUT
	END
	-- First check if all the provided clients are valid one and unprotected VMs
	-- If request consist of any protected VM, then we need to skip the same
	IF EXISTS (SELECT 1 FROM #InputVMList IVM
					LEFT OUTER JOIN APP_ClientProp ACPVM
						ON ACPVM.componentNameId=IVM.vmClientId AND ACPVM.attrName='Virtual Server Discovered Clients' AND ACPVM.attrval='1' AND ACPVM.modified=0
						WHERE  ACPVM.id IS NULL)
	BEGIN
		SELECT @invalidClients = COALESCE(@invalidClients+', ' ,'') + vmClientName
		FROM  #InputVMList IVM
		LEFT OUTER JOIN APP_ClientProp ACPVM
			ON ACPVM.componentNameId=IVM.vmClientId AND ACPVM.attrName='Virtual Server Discovered Clients' AND ACPVM.attrval='1' AND ACPVM.modified=0
		WHERE ACPVM.id IS NULL
SET @o_errCode = (4493 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @o_errString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
						WHERE messageId = @o_errCode AND [localeId] = @i_localeId)
		SET @o_errString = REPLACE(@o_errString, '^1%s', @invalidClients)
		GOTO GENERATE_OUTPUT
	END
	IF EXISTS (SELECT 1 FROM #InputVMList IVM
					LEFT OUTER JOIN App_Plan AP
						ON AP.id=IVM.planId
					WHERE AP.id IS NULL )
	BEGIN
		SELECT @invalidPlans = COALESCE(@invalidPlans+', ' ,'') + planName
		FROM  #InputVMList IVM
		LEFT OUTER JOIN App_Plan AP
			ON AP.id=IVM.planId
		WHERE AP.id IS NULL
SET @o_errCode = (4494 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @o_errString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
						WHERE messageId = @o_errCode AND [localeId] = @i_localeId)
		SET @o_errString = REPLACE(@o_errString, '^1%s', @invalidPlans)
		GOTO GENERATE_OUTPUT
	END
	-- Processed input is ready
	-- Insert details from input table to our processing table with some basic entries
	INSERT INTO #InputClientListTbl
	SELECT DISTINCT IVM.vmClientId, IVM.vmClientName, ACP.attrVal, IVM.planId,
					AAP.clientId, AAP.instance, ISNULL(CAST(ACPSUB.attrval AS INT), 0), 0, 0,
					CASE WHEN ACPJOB.id IS NOT NULL THEN 1
                       ELSE 0 END
					   , 0
	FROM #InputVMList IVM
	INNER JOIN APP_ClientProp ACPI  WITH (NOLOCK)
		ON ACPI.componentNameId=IVM.vmClientId AND ACPI.attrName='Virtual Machine Instance ID' AND ACPI.modified=0
	INNER JOIN APP_ClientProp ACP WITH (NOLOCK)
		ON ACP.componentNameId=IVM.vmClientId AND ACP.attrName='Virtual Machine Instance UUID' AND ACP.modified=0
	INNER JOIN APP_Application AAP
		ON CAST(AAP.instance AS NVARCHAR(32))=ACPI.attrVal AND AAP.subclientStatus & 0x4888034 = 0
	LEFT OUTER JOIN APP_ClientProp ACPSUB WITH(NOLOCK)
ON ACPSUB.componentNameId=IVM.vmClientId AND ACPSUB.attrName='Last Backup Subclient' AND ACPSUB.modified=0
	LEFT OUTER JOIN APP_ClientProp ACPJOB WITH(NOLOCK)
			ON ACPJOB.componentNameId=IVM.vmClientId AND ACPJOB.attrName='Last Backup JobID' AND ACPJOB.modified=0
	-- For Protected VM client where plans were changed atleast once, that will need to refer "next backup subclient"
	UPDATE ICTL
		SET ICTL.currentVMGroupId=ACP.attrval
	FROM #InputClientListTbl ICTL
	INNER JOIN APP_ClientProp ACP
ON ICTL.vmclientid=ACP.componentNameId and ACP.attrName='Next Backup Subclient' AND ACP.modified=0
	--0x4888034 means filter out subclient having any one of bits:
	--CV_STATUS_DELETED,CV_STATUS_DUMMY,CV_STATUS_HIDDEN,CV_STATUS_EDC_DISCOVERED,CV_STATUS_NEEDS_MORE_CONFIG,CV_STATUS_MINING,CV_STATUS_REFERENCE_COPY
	-- Get details of all subclient that match below criteria
	-- Get all subclients for the hypervisors whose instanceid is mapped to given VM's
	INSERT INTO #validSubclients(clientId , instanceID , backupsetId , subclientID, planId)
	SELECT DISTINCT AAP.clientId, AAP.instance, AAP.backupSet, AAP.id, ASCP.attrVal
		FROM APP_Application AAP
	INNER JOIN #InputClientListTbl ICL
		ON ICL.pseudoClientId=AAP.clientId AND AAP.appTypeId=106
	LEFT OUTER JOIN APP_SubClientProp ASCP
ON ASCP.componentNameId=AAP.id AND ASCP.attrName='Associated Plan' AND ASCP.modified = 0 AND ASCP.cs_attrName=CHECKSUM(N'Associated Plan')
	WHERE AAP.subclientStatus&0x4888034=0
	-- First get all tageed subclient for this company
	INSERT INTO #taggedSubClients
	SELECT componentNameId, 1 FROM APP_SubClientProp
WHERE attrName='Tagged CompanyId' AND modified=0 AND cs_attrName=CHECKSUM(N'Tagged CompanyId') AND (attrval LIKE @CompanyLikeInitial
																											OR attrVal LIKE @CompanyLikeMid OR attrVal LIKE @CompanyLikeEnd OR attrVal=@userCompanyId)
	-- Update list to also get all subclients that are not tagded for this user company but is tagged for someone else
	INSERT INTO #taggedSubClients
	SELECT componentNameId, 0 FROM APP_SubClientProp ASCP
	LEFT OUTER JOIN #taggedSubClients TS
		ON TS.subClientId=ASCP.componentNameId
WHERE TS.id IS NULL AND attrName='Tagged CompanyId' AND modified=0 AND cs_attrName=CHECKSUM(N'Tagged CompanyId') AND (attrval NOT LIKE @CompanyLikeInitial
																											AND attrVal NOT LIKE @CompanyLikeMid AND attrVal NOT LIKE @CompanyLikeEnd AND attrVal<>@userCompanyId)
	-- Simple Logic
	-- For commcell users (company id=0).. general security rights suffice
	-- For any company user -- only keep 'Current VM group Id' and VM which was created for that company(which have our new propery set)
	DELETE VSC
	FROM #validSubclients VSC
	LEFT OUTER JOIN #InputClientListTbl ICTL
		ON VSC.subclientID=ICTL.currentVMGroupId
	LEFT OUTER JOIN #taggedSubClients TS
		ON TS.subClientId=VSC.subclientID AND TS.isUserCompanyTagged=1
	WHERE ICTL.currentVMGroupId IS NULL AND TS.subClientId IS NULL and @userCompanyId<>'0'
	-- Delete All VM which already have same plan associated to there "Last Backup Subclient"
	DELETE ICTL
	 FROM #InputClientListTbl ICTL
	 INNER JOIN #validSubclients VSC
		ON VSC.subclientID=ICTL.currentVMGroupId AND VSC.planId=ICTL.planId
	-- update our table to see if there is any indirect content in the VMGroup content
	UPDATE VSC
	SET VSC.isAnyIndirectContentPresent=final.regexPresent
	FROM #validSubclients VSC
	INNER JOIN ( SELECT TMP.subclientId, 1 AS regexPresent FROM
							(
								SELECT CAST(CAST(attrVal AS VARCHAR(MAX)) AS XML) x, ASCP.componentNameId AS subclientId
								FROM APP_SubClientProp  ASCP
								INNER JOIN #validSubclients VS
								ON VS.subclientID=ASCP.componentNameId
								where ASCP.attrName='Virtual Server Dyanimc Content'
								AND modified=0 AND ASCP.cs_attrName=CHECKSUM(N'Virtual Server Dyanimc Content')
							) tmp
							CROSS APPLY x.nodes('/VirtualServer_VMSubClientEntity/children[@displayName]') AS T(c)
							WHERE T.c.query('.').value('(//./@type)[1]', 'nvarchar(1024)')<>'9') final
	ON final.subclientId=VSC.subclientID
	-- Insert content for all VM group that are going to be processed for the same
	INSERT INTO #subclientsContent(subclientId , vmClientId , vmClientName , vmGuid)
	SELECT tmp.subclientId, ACp.componentNameId, T.c.query('.').value('(//./@displayName)[1]', 'nvarchar(1024)'), T.c.query('.').value('(//./@name)[1]', 'nvarchar(1024)')
							FROM
							(
								SELECT CAST(CAST(attrVal AS VARCHAR(MAX)) AS XML) x, ASCP.componentNameId AS subclientId
								FROM APP_SubClientProp  ASCP
								INNER JOIN #validSubclients VS
								ON VS.subclientID=ASCP.componentNameId
								where ASCP.attrName='Virtual Server Dyanimc Content'
								AND modified=0 AND ASCP.cs_attrName=CHECKSUM(N'Virtual Server Dyanimc Content')
							) tmp
							CROSS APPLY x.nodes('/VirtualServer_VMSubClientEntity/children[@displayName]') AS T(c)
							LEFT OUTER JOIN APP_ClientProp ACP
								ON ACP.attrName='Virtual Machine Instance UUID' AND ACP.attrVal=T.c.query('.').value('(//./@name)[1]', 'nvarchar(1024)') AND ACP.modified=0
							WHERE T.c.query('.').value('(//./@type)[1]', 'nvarchar(1024)')='9'
	INSERT INTO #subclientsContent_Original(subclientId , vmClientId , vmClientName , vmGuid)
	SELECT subclientId , vmClientId , vmClientName , vmGuid  from #subclientsContent
	UPDATE ICTL
	SET ICTL.isDirectPartOfContent=1
	FROM #InputClientListTbl ICTL
	INNER JOIN #subclientsContent_Original SC
	ON SC.subclientId=ICTL.currentVMGroupId AND SC.vmGuid=ICTL.vmClientGuid
	-- Insert filter for all VM group that are going to be processed for the same
	INSERT INTO #subclientsFilter (subclientId , vmClientId , vmClientName , vmGuid,isCurrentAssociation )
	SELECT tmp.subclientId, ACP.componentNameId, T.c.query('.').value('(//./@displayName)[1]', 'nvarchar(1024)'), T.c.query('.').value('(//./@name)[1]', 'nvarchar(1024)'),1
							FROM
							(
								SELECT CAST(CAST(attrVal AS VARCHAR(MAX)) AS XML) x, ASCP.componentNameId AS subclientId
								FROM APP_SubClientProp  ASCP
								INNER JOIN #validSubclients VS
								ON VS.subclientID=ASCP.componentNameId
								where ASCP.attrName='Virtual Server Filters'
								AND modified=0 AND ASCP.cs_attrName=CHECKSUM(N'Virtual Server Filters')
							) tmp
							CROSS APPLY x.nodes('/VirtualServer_VMSubClientEntity/children[@displayName]') AS T(c)
							LEFT OUTER JOIN APP_ClientProp ACP
								ON ACP.attrName='Virtual Machine Instance UUID' AND ACP.attrVal=T.c.query('.').value('(//./@name)[1]', 'nvarchar(1024)') AND ACP.modified=0
							WHERE T.c.query('.').value('(//./@type)[1]', 'nvarchar(1024)')='9'
	-- Now start processing of request
	-- Delete all VM from its current association(identified by "Last backup subclient")
	-- This is done to identify best processing routes
	DELETE  SCC
	FROM #subclientsContent SCC
	INNER JOIN #InputClientListTbl ICL
	ON ICL.vmClientId=SCC.vmClientId AND ICL.currentVMGroupId=SCC.subclientId
	-- Now for VM where "last backup subclient" still has something present, cannot be used for reassociation to new plan
	-- If there is nothing in explcit content and no regex for content , we can simply use the current subclient to associate plan
	-- This is techinically the case where VM is associated to correct VMgroup
	-- don't update plan of same VMGroup
	-- UPDATE ICTL
	-- SET ICTL.newVMGroupId=ICTL.currentVMGroupId,
	-- 	ICTL.isProcessed=1
	-- FROM #InputClientListTbl ICTL
	-- INNER JOIN #validSubclients VS
	-- 	ON VS.subclientID=ICTL.currentVMGroupId AND VS.isAnyIndirectContentPresent=0 AND ICTL.planId=VS.planId
	-- LEFT OUTER JOIN #subclientsContent SCC
	-- ON SCC.subclientId=ICTL.currentVMGroupId
	-- WHERE SCC.subclientId IS NULL AND ICTL.currentVMGroupId<>0
	-- INSERT INTO #subclientsInputPlanMapping
	-- SELECT ICTL.currentVMGroupId as subclientId, ICTL.planId as planId, count(ICTL.planId) over (partition by ICTL.currentVMGroupId order by ICTL.planId desc) AS RN
	-- FROM #InputClientListTbl ICTL
	-- WHERE ICTL.currentVMGroupId<>0
	-- group by ICTL.currentVMGroupId, ICTL.planId
	-- order by 3 desc
	-- AT this moment , we should have our existing associations ready.. VM which can stay in there current VM group and already added
	-- Next comes to see if all VM part of VM group have been removed
	-- If that is the case, then try to add one of the current VM which was already part of it.. logic being highest number of vmclients who want to use same plan will go back in it VM group
	-- don't update plan of same VMGroup
	-- UPDATE ICTL
	-- SET ICTL.newVMGroupId=ICTL.currentVMGroupId,
	-- ICTL.isProcessed=1
	-- FROM #InputClientListTbl ICTL
	-- INNER JOIN #validSubclients VS
	-- 	ON VS.subclientID=ICTL.currentVMGroupId AND VS.isAnyIndirectContentPresent=0
	-- INNER JOIN
	-- (SELECT MIN(x.id) AS id,  -- change to MAX if you want the highest
	-- 		MIN(x.planId) AS planId,
	-- 		 x.subclientId,
	-- 		 x.planCount
	-- 	FROM #subclientsInputPlanMapping x
	-- 	JOIN (SELECT p.subclientId,
	-- 				 MAX(planCount) AS max_total
	-- 			FROM #subclientsInputPlanMapping p
	-- 		GROUP BY p.subclientId) y ON y.subclientId = x.subclientId
	-- 							  AND y.max_total = x.planCount
	-- GROUP BY x.subclientId, x.planCount) Tmp
	-- 	ON TMP.subclientId=ICTL.currentVMGroupId AND TMP.planId=ICTL.planId
	-- LEFT OUTER JOIN #subclientsContent SCC
	-- ON SCC.subclientId=ICTL.currentVMGroupId
	-- WHERE SCC.subclientId IS NULL
	-- Now look for the subclient where we do have the same plan present
	-- Logic is to identify subclient within same instance and wiht same plan
	-- If present, we are going to use that one.. else we will create new one
	-- first update from our table as we might have decided to update plan of existing subclient
	UPDATE ICTL
	SET ICTL.newVMGroupId=ICTL2.newVMGroupId,
	ICTL.isProcessed=1
	FROM #InputClientListTbl ICTL
	INNER JOIN #InputClientListTbl ICTL2
		ON ICTL2.pseudoInstanceId=ICTL.pseudoInstanceId AND ICTL2.planId=ICTL.planId AND ICTL2.newVMGroupId<>0
	WHERE ICTL.isProcessed=0
	--If still not processed, then check with existing subclients
	UPDATE ICTL
	SET ICTL.newVMGroupId=VS.subclientID,
	ICTL.isProcessed=1
	FROM #InputClientListTbl ICTL
	INNER JOIN #validSubclients VS
		ON VS.instanceID=ICTL.pseudoInstanceId AND VS.planId=ICTL.planId
	LEFT OUTER JOIN #InputClientListTbl ICTL2	-- We don't want to consider VMGroup whose plan will be changed in our request
		ON VS.subclientID=ICTL2.newVMGroupId AND VS.planId<>ICTL2.planId
	WHERE ICTL.isProcessed=0 AND ICTL2.newVMGroupId IS NULL
	-- Same subclient reuse is done
	-- Existing VMgroup identification is done
	-- whatever is left.. we need new VM group for the same
	DECLARE @planId INT
	DECLARE @subclientId INT
	DECLARE @instanceId INT
	DECLARE @content XML
	DECLARE @filter XML
	DECLARE @newVMs XML
	DECLARE @filterVMs XML
	DECLARE @oldsubclientId INT
	--- **********************************************First Cursor - Add VM to content - Start*********************************************************
	DECLARE ClientInfoContentAddCursor CURSOR
	FOR
	SELECT newVMGroupId, pseudoInstanceId, planId FROM #InputClientListTbl
	GROUP BY pseudoInstanceId,planId,newVMGroupId
	OPEN ClientInfoContentAddCursor
	FETCH FROM ClientInfoContentAddCursor INTO @subclientId, @instanceId,@planId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @oldsubclientId = 0
		SET @content = (SELECT CAST(CAST(attrVal AS VARCHAR(MAX)) AS XML) FROM APP_SubClientProp WHERE componentNameId=@subclientId AND attrName='Virtual Server Dyanimc Content' AND modified=0 AND cs_attrName=CHECKSUM(N'Virtual Server Dyanimc Content'))
		--SET @filter = (SELECT CAST(CAST(attrVal AS VARCHAR(MAX)) AS XML) FROM APP_SubClientProp WHERE componentNameId=@subclientId AND attrName='Virtual Server Filters' AND modified=0 AND cs_attrName=CHECKSUM(N'Virtual Server Filters'))
		-- Now all VM's which maps to Criteria of @subclientId, @instanceId,@planId will be inserted into the table.
		-- For new subclients, we will insert new XML along with default backupset Id
		IF @content IS NULL
		BEGIN
			-- New subclient
			-- <children allOrAnyChildren="1" displayName="DN_smallvm3_s_DN" equalsOrNotEquals="1" name="5017cab7-fb77-ae6a-dde3-86ddc49e5931" path="" type="9" />
			SET @content = (SELECT
								(SELECT 1 AS '@allOrAnyChildren', vmClientName AS '@displayName', 1 AS '@equalsOrNotEquals', vmClientGuid AS '@name', '' AS '@path', 9 AS '@type'
										 FROM #InputClientListTbl ICTL
										 WHERE ICTL.newVMGroupId=@subclientId AND pseudoInstanceId=@instanceId AND ICTL.planId=@planId
										FOR XML PATH('children'),TYPE)
									FOR XML PATH('VirtualServer_VMSubClientEntity'),TYPE)
			-- This will be used to copy over security when we create new VMgroup
			-- In case of multiple VM going into same VMgroup, then we will take top 1
			SET @oldsubclientId = (SELECT TOP 1 currentVMGroupId FROM #InputClientListTbl ICTL
										 WHERE ICTL.newVMGroupId=@subclientId AND pseudoInstanceId=@instanceId AND ICTL.planId=@planId AND currentVMGroupId<>0)
		END
		ELSE
		BEGIN
			-- Old subclient
			-- INSERT All VM which fit into this criteria
			SET @newVMs =
					(SELECT
						'1' as '@allOrAnyChildren',
						ICTL.vmClientGuid as '@name',
						'9' as '@type',
						ICTL.vmClientName as '@displayName',
						'1' as '@equalsOrNotEquals',
						'' AS '@path'
						FROM   #InputClientListTbl ICTL
						LEFT OUTER JOIN #subclientsContent_Original SC
							ON SC.subclientId=@subclientId AND SC.vmGuid=ICTL.vmClientGuid
						WHERE SC.subclientId IS NULL AND ICTL.newVMGroupId=@subclientId AND pseudoInstanceId=@instanceId AND ICTL.planId=@planId
						FOR XML PATH('children'), TYPE
					)
			SET @content.modify('insert sql:variable("@newVms") into (/VirtualServer_VMSubClientEntity)[1]')
		END
		INSERT INTO #FinalSubclientProcessing
		SELECT @subclientId, '', 0, @instanceId, 0, @planId, @content, NULL,@oldsubclientId
		FETCH FROM ClientInfoContentAddCursor INTO @subclientId, @instanceId,@planId
	END
	CLOSE ClientInfoContentAddCursor
	DEALLOCATE ClientInfoContentAddCursor
	--- **********************************************First Cursor - Add VM to content - END*********************************************************
	--- **********************************************Second Cursor - Remove VM to old content - Start*********************************************************
	-- Now remove all VM from there content if there current VMgroup id is valid one and new vmgroupid is invalid one or different one
	-- This will only be applicable for cases where VM is direct part of content
	DECLARE ClientInfoContentRemoveCursor CURSOR
	FOR
	SELECT currentVMGroupId FROM #InputClientListTbl
	WHERE currentVMGroupId<>0 AND currentVMGroupId<>newVMGroupId AND isDirectPartOfContent=1
	GROUP BY currentVMGroupId
	OPEN ClientInfoContentRemoveCursor
	FETCH FROM ClientInfoContentRemoveCursor INTO @subclientId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		-- Content can come from our processed request earlier or the subclient has not been processed at all
		-- First try from our table
		SET @content = (SELECT finalContent FROM #FinalSubclientProcessing WHERE subclientId=@subclientId AND finalContent IS NOT NULL)
		-- Read content from subclient prop table only if it has not been processed by us yet
		IF @content IS NULL
		BEGIN
			SET @content = (SELECT CAST(CAST(attrVal AS VARCHAR(MAX)) AS XML) FROM APP_SubClientProp WHERE componentNameId=@subclientId AND attrName='Virtual Server Dyanimc Content' AND modified=0 AND cs_attrName=CHECKSUM(N'Virtual Server Dyanimc Content'))
		END
		-- Now all VM's which maps to Criteria of @subclientId, @instanceId,@planId will be inserted into the table.
		-- For new subclients, we will insert new XML along with default backupset Id
		IF @content IS NOT NULL
		BEGIN
			DECLARE @vmGuid NVARCHAR(64)
			-- over here we are going to loop through our current client list table to see what needs to be added to filter
			DECLARE VMListCursor CURSOR
			FOR
				SELECT vmClientGuid FROM #InputClientListTbl
				WHERE currentVMGroupId<>0 AND currentVMGroupId<>newVMGroupId and currentVMGroupId=@subclientId
			OPEN VMListCursor
			FETCH FROM VMListCursor INTO @vmGuid
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SET @content.modify('delete (/VirtualServer_VMSubClientEntity/children[@name=sql:variable("@vmGuid")])')
				FETCH NEXT FROM VMListCursor INTO @vmGuid;
			END;
			CLOSE VMListCursor;
			DEALLOCATE VMListCursor;
			UPDATE #FinalSubclientProcessing
			SET finalContent=@content
			WHERE subclientId=@subclientId
			IF @@ROWCOUNT = 0
			BEGIN
				INSERT INTO #FinalSubclientProcessing
				SELECT @subclientId, '', 0, 0, 0, 0, @content, NULL, 0
			END
		END
		FETCH FROM ClientInfoContentRemoveCursor INTO @subclientId
	END
	CLOSE ClientInfoContentRemoveCursor
	DEALLOCATE ClientInfoContentRemoveCursor
	-- Content Processing is done. Now is the time to process same thing for filter
	--- **********************************************Second Cursor - Remove VM to old content - End*********************************************************
	--select 'content processing finished', * from #FinalSubclientProcessing
	--- ************************************Third Cursor - Add VM to filter if wasn't directly associated - Start**********************************************
	-- First loop will be to add any VM client to filter list in case of current VMgroup and new VMgroup are different and current one is valid one
	DECLARE ClientInfoFilterAddCursor CURSOR
	FOR
	SELECT currentVMGroupId FROM #InputClientListTbl
	WHERE currentVMGroupId<>0 AND currentVMGroupId<>newVMGroupId AND isDirectPartOfContent=0
	GROUP BY currentVMGroupId
	OPEN ClientInfoFilterAddCursor
	FETCH FROM ClientInfoFilterAddCursor INTO @subclientId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @filter = (SELECT CAST(CAST(attrVal AS VARCHAR(MAX)) AS XML) FROM APP_SubClientProp WHERE componentNameId=@subclientId AND attrName='Virtual Server Filters' AND modified=0 AND cs_attrName=CHECKSUM(N'Virtual Server Filters'))
		-- Now all VM's which maps to Criteria of @subclientId, @instanceId,@planId will be inserted into the table.
		-- For new subclients, we will insert new XML along with default backupset Id
		IF @filter IS NULL
		BEGIN
			-- <children allOrAnyChildren="1" displayName="DN_smallvm3_s_DN" equalsOrNotEquals="1" name="5017cab7-fb77-ae6a-dde3-86ddc49e5931" path="" type="9" />
			SET @filter = (SELECT
								(SELECT 1 AS '@allOrAnyChildren', vmClientName AS '@displayName', 1 AS '@equalsOrNotEquals', vmClientGuid AS '@name', '' AS '@path', 9 AS '@type'
										 FROM #InputClientListTbl ICTL
										 WHERE ICTL.currentVMGroupId=@subclientId AND currentVMGroupId<>newVMGroupId AND isDirectPartOfContent=0
										FOR XML PATH('children'),TYPE)
									FOR XML PATH('VirtualServer_VMSubClientEntity'),TYPE)
		END
		ELSE
		BEGIN
			-- Old subclient
			-- INSERT All VM which fit into this criteria
			SET @filterVMs =
					(SELECT
						'1' as '@allOrAnyChildren',
						ICTL.vmClientGuid as '@name',
						'9' as '@type',
						ICTL.vmClientName as '@displayName',
						'1' as '@equalsOrNotEquals',
						'' AS '@path'
						FROM   #InputClientListTbl ICTL
						LEFT OUTER JOIN #subclientsFilter SC
							ON SC.subclientId=@subclientId AND SC.vmGuid=ICTL.vmClientGuid
						WHERE SC.subclientId IS NULL AND ICTL.currentVMGroupId=@subclientId AND currentVMGroupId<>newVMGroupId AND isDirectPartOfContent=0
						FOR XML PATH('children'), TYPE
					)
			SET @filter.modify('insert sql:variable("@filterVMs") into (/VirtualServer_VMSubClientEntity)[1]')
		END
		UPDATE #FinalSubclientProcessing
		SET finalFilter=@filterVMs
		WHERE subclientId=@subclientId
		IF @@ROWCOUNT = 0
		BEGIN
			INSERT INTO #FinalSubclientProcessing
			SELECT @subclientId, '', 0, 0, 0, 0, NULL, @filter,0
		END
		FETCH FROM ClientInfoFilterAddCursor INTO @subclientId
	END
	CLOSE ClientInfoFilterAddCursor
	DEALLOCATE ClientInfoFilterAddCursor
	--- ************************************Third Cursor - Add VM to filter if wasn't directly associated - END**********************************************
	--- ***********************Fourth and Final Cursor - Remove VM from filter for NEW VM group if present in filter - Start**************************************
	-- Last Step.. remove any VM from Filter list where newVMgroup Id is different from the current VM group Id
	-- Now remove all VM from there filters if there new VMgroup id is valid one and different from current one
	DECLARE ClientInfoFilterRemoveCursor CURSOR
	FOR
	SELECT newVMGroupId FROM #InputClientListTbl
	WHERE newVMGroupId<>0 AND newVMGroupId<>currentVMGroupId
	GROUP BY newVMGroupId
	OPEN ClientInfoFilterRemoveCursor
	FETCH FROM ClientInfoFilterRemoveCursor INTO @subclientId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		-- Content can come from our processed request earlier or the subclient has not been processed at all
		-- First try from our table
		SET @filter = (SELECT finalFilter FROM #FinalSubclientProcessing WHERE subclientId=@subclientId AND finalFilter IS NOT NULL)
		-- Read content from subclient prop table only if it has not been processed by us yet
		IF @filter IS NULL
		BEGIN
			SET @filter = (SELECT CAST(CAST(attrVal AS VARCHAR(MAX)) AS XML) FROM APP_SubClientProp WHERE componentNameId=@subclientId AND attrName='Virtual Server Filters' AND modified=0 AND cs_attrName=CHECKSUM(N'Virtual Server Filters'))
		END
		-- Now all VM's which maps to Criteria of @subclientId, @instanceId,@planId will be inserted into the table.
		-- For new subclients, we will insert new XML along with default backupset Id
		IF @filter IS NOT NULL
		BEGIN
			DECLARE @vmGuidFilter NVARCHAR(64)
			-- over here we are going to loop through our current client list table to see what needs to be added to filter
			DECLARE VMFilterListCursor CURSOR
			FOR
				SELECT vmClientGuid FROM #InputClientListTbl
				WHERE newVMGroupId<>0 AND currentVMGroupId<>newVMGroupId AND newVMGroupId=@subclientId
			OPEN VMFilterListCursor
			FETCH FROM VMFilterListCursor INTO @vmGuidFilter
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SET @filter.modify('delete (/VirtualServer_VMSubClientEntity/children[@name=sql:variable("@vmGuidFilter")])')
				FETCH NEXT FROM VMFilterListCursor INTO @vmGuidFilter;
			END;
			CLOSE VMFilterListCursor;
			DEALLOCATE VMFilterListCursor;
			UPDATE #FinalSubclientProcessing
				SET finalFilter=@filter
				WHERE subclientId=@subclientId
			IF @@ROWCOUNT = 0
			BEGIN
				INSERT INTO #FinalSubclientProcessing
				SELECT @subclientId, '', 0, 0, 0, 0, NULL, @filter,0
			END
		END
		FETCH FROM ClientInfoFilterRemoveCursor INTO @subclientId
	END
	CLOSE ClientInfoFilterRemoveCursor
	DEALLOCATE ClientInfoFilterRemoveCursor
	--- ***********************Fourth and Final Cursor - Remove VM from filter for NEW VM group if present in filter - End**************************************
	-- For new subclients update backupset and subclient name
	-- subclient name will be plan name which we are going to check once more prior to subclient creation
	UPDATE FSC
		SET FSC.subClientName=@companyName + '_' + APP.name,
			FSC.backupsetId=ABN.id,
			FSC.clientId=AAP.clientId
	FROM #FinalSubclientProcessing FSC
	INNER JOIN App_Plan APP
		ON APP.id=FSC.planId
	INNER JOIN APP_Application AAP
		ON AAP.instance=FSC.instanceId
	INNER JOIN APP_BackupSetName ABN
--ON ABN.id=AAP.backupSet AND ABN.status&0x00008=0x00008
		ON ABN.id=AAP.backupSet AND ABN.status&0x00008=0x00008
	WHERE subclientId=0
	-- To avoid name collision, run loop to append possible values
	DECLARE @counter INT = 1
	WHILE EXISTS(
					SELECT TOP 1 1 FROM #FinalSubclientProcessing FSC
							INNER JOIN APP_Application AAP
								ON AAP.instance=FSC.instanceId AND AAP.subclientName=FSC.subClientName AND AAP.clientId=FSC.clientId AND AAP.backupSet=FSC.backupsetId
				)
	BEGIN
		UPDATE FSC
		SET FSC.subClientName=FSC.subClientName + ' ('+ CAST(@counter AS NVARCHAR(32)) + ')'
		FROM #FinalSubclientProcessing FSC
		INNER JOIN APP_Application AAP
			ON AAP.instance=FSC.instanceId AND AAP.subclientName=FSC.subClientName AND AAP.clientId=FSC.clientId AND AAP.backupSet=FSC.backupsetId
		WHERE subclientId=0
		SET @counter += 1
	END
	UPDATE FSC
	SET FSC.clientId=AAP.clientId,
		FSC.instanceId=AAP.instance,
		FSC.backupsetId=AAP.backupSet
	FROM #FinalSubclientProcessing FSC
	INNER JOIN APP_Application AAP
		ON AAP.id=FSC.subclientId
	WHERE subclientId<>0 AND FSC.clientId=0
	--select 'Allprocessing done', * from #FinalSubclientProcessing
GENERATE_OUTPUT:
	-- Generate final XML to be returned
	SET @o_xmlText = CAST((SELECT @invalidClients AS '@invalidClients', @invalidPlans AS '@invalidPlans',
						(SELECT
							(SELECT CASE WHEN FSC.finalfilter IS NOT NULL THEN 1 ELSE NULL END) AS '@vmFilterOperationType',
							(SELECT CASE WHEN FSC.finalContent IS NOT NULL THEN 1 ELSE NULL END) AS '@vmContentOperationType',
							(SELECT FSC.planId AS '@planId'
								FOR XML PATH('plan'),TYPE),
							(SELECT FSC.backupsetId AS '@backupsetId',FSC.instanceId AS '@instanceId',FSC.clientId AS '@clientId', FSC.subclientName AS '@subclientName'
								FOR XML PATH('vsaEntity'),TYPE),
							(SELECT FSC.oldsubclientId AS '@subclientId'
								FOR XML PATH('currentVSAEntity'),TYPE),
							(SELECT FSC.finalContent.value('(/VirtualServer_VMSubClientEntity/@allOrAnyChildren)[1]', 'INT') as '@allOrAnyChildren',
									FSC.finalContent.value('(/VirtualServer_VMSubClientEntity/@name)[1]', 'NVARCHAR(MAX)') as '@name',
									FSC.finalContent.value('(/VirtualServer_VMSubClientEntity/@type)[1]', 'INT') as '@type',
									FSC.finalContent.value('(/VirtualServer_VMSubClientEntity/@path)[1]', 'NVARCHAR(MAX)') as '@path',
									FSC.finalContent.value('(/VirtualServer_VMSubClientEntity/@displayName)[1]', 'NVARCHAR(MAX)') as '@displayName',
									FSC.finalContent.value('(/VirtualServer_VMSubClientEntity/@equalsOrNotEquals)[1]', 'INT') as '@equalsOrNotEquals',
									FSC.finalContent.value('(/VirtualServer_VMSubClientEntity/@upgradePath)[1]', 'NVARCHAR(MAX)') as '@upgradePath',
									FSC.finalContent.value('(/VirtualServer_VMSubClientEntity/@value)[1]', 'NVARCHAR(MAX)') as '@value',
									FSC.finalContent.query('/VirtualServer_VMSubClientEntity/*')
											FOR XML PATH('vmContent'), TYPE),
							(SELECT FSC.finalFilter.value('(/VirtualServer_VMSubClientEntity/@allOrAnyChildren)[1]', 'INT') as '@allOrAnyChildren',
									FSC.finalFilter.value('(/VirtualServer_VMSubClientEntity/@name)[1]', 'NVARCHAR(MAX)') as '@name',
									FSC.finalFilter.value('(/VirtualServer_VMSubClientEntity/@type)[1]', 'INT') as '@type',
									FSC.finalFilter.value('(/VirtualServer_VMSubClientEntity/@path)[1]', 'NVARCHAR(MAX)') as '@path',
									FSC.finalFilter.value('(/VirtualServer_VMSubClientEntity/@displayName)[1]', 'NVARCHAR(MAX)') as '@displayName',
									FSC.finalFilter.value('(/VirtualServer_VMSubClientEntity/@equalsOrNotEquals)[1]', 'INT') as '@equalsOrNotEquals',
									FSC.finalFilter.value('(/VirtualServer_VMSubClientEntity/@upgradePath)[1]', 'NVARCHAR(MAX)') as '@upgradePath',
									FSC.finalFilter.value('(/VirtualServer_VMSubClientEntity/@value)[1]', 'NVARCHAR(MAX)') as '@value',
									FSC.finalFilter.query('/VirtualServer_VMSubClientEntity/*')
											FOR XML PATH('vmFilter'), TYPE)
							FROM #FinalSubclientProcessing FSC WHERE subclientId=0
							FOR XML PATH('newAssociations'),TYPE),
						(SELECT
							(SELECT CASE WHEN FSC.finalfilter IS NOT NULL THEN 1 ELSE NULL END) AS '@vmFilterOperationType',
							(SELECT CASE WHEN FSC.finalContent IS NOT NULL THEN 1 ELSE NULL END) AS '@vmContentOperationType',
							(SELECT FSC.planId AS '@planId'
								FOR XML PATH('plan'),TYPE),
							(SELECT FSC.subclientId AS '@subclientId',FSC.backupsetId AS '@backupsetId',FSC.instanceId AS '@instanceId',FSC.clientId AS '@clientId'
								FOR XML PATH('vsaEntity'),TYPE),
							(SELECT FSC.finalContent.value('(/VirtualServer_VMSubClientEntity/@allOrAnyChildren)[1]', 'INT') as '@allOrAnyChildren',
									FSC.finalContent.value('(/VirtualServer_VMSubClientEntity/@name)[1]', 'NVARCHAR(MAX)') as '@name',
									FSC.finalContent.value('(/VirtualServer_VMSubClientEntity/@type)[1]', 'INT') as '@type',
									FSC.finalContent.value('(/VirtualServer_VMSubClientEntity/@path)[1]', 'NVARCHAR(MAX)') as '@path',
									FSC.finalContent.value('(/VirtualServer_VMSubClientEntity/@displayName)[1]', 'NVARCHAR(MAX)') as '@displayName',
									FSC.finalContent.value('(/VirtualServer_VMSubClientEntity/@equalsOrNotEquals)[1]', 'INT') as '@equalsOrNotEquals',
									FSC.finalContent.value('(/VirtualServer_VMSubClientEntity/@upgradePath)[1]', 'NVARCHAR(MAX)') as '@upgradePath',
									FSC.finalContent.value('(/VirtualServer_VMSubClientEntity/@value)[1]', 'NVARCHAR(MAX)') as '@value',
									FSC.finalContent.query('/VirtualServer_VMSubClientEntity/*')
											FOR XML PATH('vmContent'), TYPE),
							(SELECT FSC.finalFilter.value('(/VirtualServer_VMSubClientEntity/@allOrAnyChildren)[1]', 'INT') as '@allOrAnyChildren',
									FSC.finalFilter.value('(/VirtualServer_VMSubClientEntity/@name)[1]', 'NVARCHAR(MAX)') as '@name',
									FSC.finalFilter.value('(/VirtualServer_VMSubClientEntity/@type)[1]', 'INT') as '@type',
									FSC.finalFilter.value('(/VirtualServer_VMSubClientEntity/@path)[1]', 'NVARCHAR(MAX)') as '@path',
									FSC.finalFilter.value('(/VirtualServer_VMSubClientEntity/@displayName)[1]', 'NVARCHAR(MAX)') as '@displayName',
									FSC.finalFilter.value('(/VirtualServer_VMSubClientEntity/@equalsOrNotEquals)[1]', 'INT') as '@equalsOrNotEquals',
									FSC.finalFilter.value('(/VirtualServer_VMSubClientEntity/@upgradePath)[1]', 'NVARCHAR(MAX)') as '@upgradePath',
									FSC.finalFilter.value('(/VirtualServer_VMSubClientEntity/@value)[1]', 'NVARCHAR(MAX)') as '@value',
									FSC.finalFilter.query('/VirtualServer_VMSubClientEntity/*')
											FOR XML PATH('vmFilter'), TYPE)
							FROM #FinalSubclientProcessing FSC WHERE subclientId<>0
							FOR XML PATH('updateAssociations'),TYPE),
							( SELECT @o_errCode '@errorCode', @o_errString '@errorMessage'
									FOR XML PATH('error'), TYPE)
						FOR XML PATH('App_ProcessVMAssociations'),TYPE) AS NVARCHAR(MAX))
		IF (@o_xmlText is NULL) OR LEN(@o_xmlText) = 0
		SET @o_xmlText = '<App_ProcessVMAssociations/>'
	IF object_id('tempdb.dbo.#InputVMList')	IS NOT null						DROP TABLE #InputVMList
	IF object_id('tempdb.dbo.#InputClientListTbl')	IS NOT null				DROP TABLE #InputClientListTbl
	IF OBJECT_ID('tempdb.dbo.#validSubclients') IS NOT NULL					DROP TABLE #validSubclients
	IF OBJECT_ID('tempdb.dbo.#subclientsContent') IS NOT NULL				DROP TABLE #subclientsContent
	IF OBJECT_ID('tempdb.dbo.#subclientsContent_Original') IS NOT NULL		DROP TABLE #subclientsContent_Original
	IF OBJECT_ID('tempdb.dbo.#subclientsFilter') IS NOT NULL				DROP TABLE #subclientsFilter
	IF OBJECT_ID('tempdb.dbo.#subclientsInputPlanMapping') IS NOT NULL		DROP TABLE #subclientsInputPlanMapping
	IF OBJECT_ID('tempdb.dbo.#FinalSubclientProcessing') IS NOT NULL		DROP TABLE #FinalSubclientProcessing
	IF OBJECT_ID('tempdb.dbo.#userClients') IS NOT NULL						DROP TABLE #userClients
	IF OBJECT_ID('tempdb.dbo.#PlansList')	IS NOT NULL						DROP TABLE #PlansList
	IF OBJECT_ID('tempdb.dbo.#taggedSubClients') IS NOT NULL				DROP TABLE #taggedSubClients
END TRY
----=====================================================================
----==============  COME HERE IF THERE WAS A PROBLEM!     ===============
----=====================================================================
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_errCode    = ERROR_NUMBER()
	SET @o_errString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @o_xmlText = ( SELECT
				( SELECT @o_errCode '@errorCode', @o_errString '@errorMessage'
						FOR XML PATH('error'), TYPE
				)
	FOR XML PATH(''),
	ROOT('App_ProcessVMAssociations'))
END CATCH
	SELECT @o_xmlText
GO

IF EXISTS (select * from GxQscripts where name = 'AppPopulateVMSubclientAssociations')
	delete from GxQscripts where name = 'AppPopulateVMSubclientAssociations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPopulateVMSubclientAssociations')
	delete from GXDBVersions where aliasname = 'AppPopulateVMSubclientAssociations'
GO

insert into GXDBVersions values(2, 'AppPopulateVMSubclientAssociations',  '00010001000200050000', 'AppPopulateVMSubclientAssociations', '00010001000200050000')
GO

