

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPopulateDefaultEmailTemplates.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Divya Trivedi
-- Create date: 1/8/2018
-- Description:	To populate default email templates
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPopulateDefaultEmailTemplates')
BEGIN
	print '>>> Drop Stored Procedure: AppPopulateDefaultEmailTemplates <<<'
	drop procedure AppPopulateDefaultEmailTemplates
END
IF EXISTS (select * from GxQscripts where name='AppPopulateDefaultEmailTemplates')
	delete from GxQscripts where name = 'AppPopulateDefaultEmailTemplates'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPopulateDefaultEmailTemplates')
	delete from GXDBVersions where aliasname = 'AppPopulateDefaultEmailTemplates'
GO
print '... Creating Procedure: AppPopulateDefaultEmailTemplates'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPopulateDefaultEmailTemplates
  @errorCode integer         OUTPUT,
  @errorString varchar(1024)   OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
set @errorCode = 0
set @errorString  = ''
declare @globalCompanyId int = 0	--company ID for global templates
declare @globalTemplateAuthorId int = (SELECT id FROM UMUsers where (flags & CAST (0x040 AS INT)) = CAST(0x040 AS INT) )
declare @unixTime int = (select dbo.GetUnixTime(GetUTCDate()))
declare @comcellLocale nvarchar(max) = isnull((select top 1 value from GXGlobalParam where name = 'Commcell Locale' and modified = 0), 0)
DECLARE @installedSPVersion  INT
DECLARE @defaultCCId int = 2
IF EXISTS(SELECT * FROM APP_ComponentProp WHERE propertyTypeId =  3624 AND componentId = @defaultCCId)
	SET @installedSPVersion = (SELECT TOP 1 InstallHistory.C.value('@sp', 'int') AS sp
	FROM (SELECT componentId, CAST(stringVal AS XML) AS historyXml
		FROM APP_ComponentProp
WHERE propertyTypeId =  3624 AND componentId = @defaultCCId ) AS results
	CROSS APPLY results.historyXml.nodes('/PatchInstallHistory/SPVer') AS InstallHistory(C)
	ORDER BY InstallHistory.C.value('@installTime','int'))
ELSE
	SET @installedSPVersion = (SELECT TOP 1 HighestSP FROM PatchInstallHistory WHERE ClientId = @defaultCCId ORDER BY OpTime)
--declare @isEmailTemplateFreshSetup nvarchar(255) = isnull((select value from GXGlobalParam where name = 'EmailTemplateFreshSetup'), 0)
 --Currently only 1st bit of flag column is used to denote system created global templates property. If in future, remaining bits are used to denote something, in the insert statement use bitwise OR operator for flag column. eg 1|2|4|8 and so on for each bit.
DECLARE @status INT = 1
IF OBJECT_ID('tempdb.dbo.#EmailTemplateTypesListForPopulateAction') IS NOT null	DROP TABLE #EmailTemplateTypesListForPopulateAction
create table #EmailTemplateTypesListForPopulateAction
(
									templateTypeId				int primary key,
									templateTypeName			nvarchar(255),
									subject						nvarchar(255),
									emailBody					nvarchar(max)
)
INSERT INTO #EmailTemplateTypesListForPopulateAction(templateTypeId, templateTypeName,  subject, emailBody)
(
SELECT ETT.[typeId]
		, dbo.fn_EvFormatEventMsgText(0, @comcellLocale, ETT.locNameId, 0,2)
		, dbo.fn_EvFormatEventMsgText(0, @comcellLocale, ETT.locDefaultSubjectId, 0,2)
		, dbo.fn_EvFormatEventMsgText(0, @comcellLocale, ETT.locDefaultEmailBodyId, 0,2)
		--if no property record is found, append empty string
		+ isnull(
				--concat localized messages
				(SELECT '' + dbo.fn_EvFormatEventMsgText(0, @comcellLocale, _ID, 0,2)
					FROM dbo.SplitStringByDelimiter(
						  (
							--Get property for comma separated additional email body message IDs
							select top 1 ETTProp.attrVal
							from App_EmailTemplateTypeProp ETTProp
where ETTProp.componentNameId = ETT.typeId and ETTProp.modified = 0 and ETTProp.attrName = 'additionalLocDefaultEmailBodyIds'
							order by ETTProp.created desc
						  ),
						  -- message IDs are expected to be separated by comma in the property additionalLocDefaultEmailBodyIds
						 ','
					 )
			  FOR XML PATH (''), TYPE).value('.', 'nvarchar(max)')
			  , '')
		FROM APP_EmailTemplateType ETT
)
--Update image data in emailBody from properties table, if present - START
IF OBJECT_ID('tempdb.dbo.#EmailTemplateTypesWithImage') IS NOT null	DROP TABLE #EmailTemplateTypesWithImage
create table #EmailTemplateTypesWithImage
(
									rowId					int primary key identity(1,1),
									templateTypeId			int
)
Declare @totalTemplateTypes int, @currentTemplateTypeRecord int = 1, @templateTypeEmailBody nvarchar(max)
INSERT INTO #EmailTemplateTypesWithImage(templateTypeId)
select distinct componentNameId from App_EmailTemplateTypeProp where  modified = 0 and attrType = 138
SET @totalTemplateTypes = @@ROWCOUNT
declare @currentTemplateTypeId int
WHILE @currentTemplateTypeRecord <= @totalTemplateTypes
BEGIN
	SELECT @currentTemplateTypeId = templateTypeId
	FROM #EmailTemplateTypesWithImage
	where RowID = @currentTemplateTypeRecord
	select @templateTypeEmailBody = emailbody from #EmailTemplateTypesListForPopulateAction where templateTypeId = @currentTemplateTypeId
	update imagePropsKey
			set @templateTypeEmailBody = replace(@templateTypeEmailBody, '$'+imagePropsKey.attrName+'$', imagePropsKey.attrVal)
			from App_EmailTemplateTypeProp imagePropsKey
			where imagePropsKey.modified = 0
				and imagePropsKey.attrType = 138
				and imagePropsKey.componentNameId = @currentTemplateTypeId
			option (maxdop 1);
	update #EmailTemplateTypesListForPopulateAction
	set emailBody = @templateTypeEmailBody
	where templateTypeId = @currentTemplateTypeId
	SET @currentTemplateTypeRecord = @currentTemplateTypeRecord + 1
END
--Update image data in emailBody from properties table, if present - END
--Add global template for every new email template type introduced in the system
IF ( @installedSPVersion >= 12)
BEGIN
	BEGIN TRY
		BEGIN TRANSACTION emailTemplateTran
			--update existing non-modified templates
			--first update so that just inserted ros are not updated unnecessarily
			UPDATE template
			set
				name = typeTemp.templateTypeName,
				modifiedBy = @globalTemplateAuthorId,
				createdOn = @unixTime,
				modifiedOn = @unixTime,
				localeId = @globalCompanyId,
				subject = typeTemp.subject,
				emailBody = typeTemp.emailBody
			FROM App_EmailTemplate template
			join #EmailTemplateTypesListForPopulateAction typeTemp
			on template.type = typeTemp.templateTypeId and template.ownerCompanyId = @globalCompanyId and template.status & 1 = 1 and template.createdOn = template.modifiedOn
			--insert missing templates
			INSERT INTO App_EmailTemplate([name], [createdBy],	[modifiedBy],	[createdOn],	[modifiedOn],	[type],	[ownerCompanyId],	[localeId], isDefault,	[subject],	[emailBody], [status])
			SELECT typeTemp.templateTypeName, @globalTemplateAuthorId, @globalTemplateAuthorId, @unixTime, @unixTime, typeTemp.templateTypeId,  @globalCompanyId, @comcellLocale, 1, typeTemp.subject,  typeTemp.emailBody, @status
				from #EmailTemplateTypesListForPopulateAction typeTemp
				left join App_EmailTemplate template on template.type = typeTemp.templateTypeId and template.ownerCompanyId = @globalCompanyId
				where template.type is null
		COMMIT TRANSACTION emailTemplateTran
	END TRY
	BEGIN CATCH
		IF (@@TRANCOUNT > 0) ROLLBACK TRANSACTION emailTemplateTran
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR) --dbUpgrade scripts replace this const with a print statement to log errors. required for all catch blocks.
		SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
	END CATCH
END
IF OBJECT_ID('tempdb.dbo.#EmailTemplateTypesWithImage') IS NOT NULL DROP TABLE #EmailTemplateTypesWithImage
IF OBJECT_ID('tempdb.dbo.#EmailTemplateTypesListForPopulateAction') IS NOT NULL DROP TABLE #EmailTemplateTypesListForPopulateAction
SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppPopulateDefaultEmailTemplates')
	delete from GxQscripts where name = 'AppPopulateDefaultEmailTemplates'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPopulateDefaultEmailTemplates')
	delete from GXDBVersions where aliasname = 'AppPopulateDefaultEmailTemplates'
GO

insert into GXDBVersions values(2, 'AppPopulateDefaultEmailTemplates',  '00000000000000000000', 'AppPopulateDefaultEmailTemplates', '00000000000000000000')
GO

