

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanValidateIndexServer.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanValidateIndexServer.sp,v $ $Id: AppPlanValidateIndexServer.sp,v 1.1.2.1 2020/11/04 21:57:12 cnaik Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  |   Procedure:  AppPlanValidateIndexServer
--  |
--  | Description:  Stored Procedure to validate storage type & storage policy for index server
--  |
--  |
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppPlanValidateIndexServer')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanValidateIndexServer <<<'
	drop procedure AppPlanValidateIndexServer
END
IF EXISTS (select * from GxQscripts where name='AppPlanValidateIndexServer')
	delete from GxQscripts where name = 'AppPlanValidateIndexServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanValidateIndexServer')
	delete from GXDBVersions where aliasname = 'AppPlanValidateIndexServer'
GO
print '... Creating Procedure: AppPlanValidateIndexServer'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppPlanValidateIndexServer
  @i_planId INT, 
  @i_storagePolicyId INT,
  @i_userId INT,
  @o_isvalid INT  = 0 OUTPUT,
  @o_errorCode INT    = 0 OUTPUT,
  @o_errorMsg NVARCHAR(1024) = '' OUTPUT
AS
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	SET @o_errorCode = 0; SET @o_errorMsg  = ''; SET @o_isvalid = 0;
	IF (@i_planId IS NULL) AND (@i_storagePolicyId IS NULL)
	BEGIN
        SET @o_errorCode = 1;  SET @o_errorMsg  = 'Invalid parameter: plan ID or storage policy';
       RETURN
    END
	IF (@i_storagePolicyId IS NULL)  OR (@i_storagePolicyId = 0)
	BEGIN
SET @i_storagePolicyId = ISNULL(dbo.AppPlanGetEntityValueV2(@i_planId, 'Storage policy', default),0)
	END
	--if we still cannot get storage policy id
	IF  (@i_storagePolicyId = 0)
	BEGIN
        SET @o_errorCode = 1;  SET @o_errorMsg  = 'Could not find storage policy';
       RETURN
    END
	declare @storageType nvarchar(128), @storageCopy nvarchar(128)
	SELECT @storageType=
				CASE
WHEN LibraryTypeId <> 3 THEN 'Tape'
WHEN EXISTS(SELECT 1 FROM MMMountPath MP WHERE MP.LibraryId = L.LibraryId AND MP.MountPathTypeId = 7) THEN 'Cloud'
WHEN EXISTS(SELECT 1 FROM MMSDSStoragePool S WHERE S.LibraryId = L.LibraryId) THEN 'Hyperscale'
ELSE 'Disk'
				END ,
			@storageCopy = agc.name
	FROM archGroup ag WITH(NOLOCK)
		INNER JOIN MMDataPath P WITH(NOLOCK) ON P.CopyId = ag.defaultCopy
		INNER JOIN MMDrivePool DP WITH(NOLOCK) ON DP.DrivePoolId = P.DrivePoolId
		INNER JOIN MMMasterPool M WITH(NOLOCK) ON M.MasterPoolId = DP.MasterPoolId
		INNER JOIN MMLibrary L WITH(NOLOCK) ON L.LibraryId = M.LibraryId
		INNER JOIN archGroupCopy agc WITH(NOLOCK) ON agc.archGroupId = ag.id
		AND ag.id  = @i_storagePolicyId
IF @storageType = 'Cloud' AND @storageCopy = 'Primary'
	BEGIN
		SET @o_isvalid = 1
	END
	ELSE
	BEGIN
		SET @o_isvalid = 0
	END
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanValidateIndexServer')
	delete from GxQscripts where name = 'AppPlanValidateIndexServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanValidateIndexServer')
	delete from GXDBVersions where aliasname = 'AppPlanValidateIndexServer'
GO

insert into GXDBVersions values(2, 'AppPlanValidateIndexServer',  '00010001000200010000', 'AppPlanValidateIndexServer', '00010001000200010000')
GO

