

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanUserMapping.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppPlanUserMapping()
--  | Description:  Allows for GET of user role in Plan context as MSP Admin, Tenant Admin and Tenant User
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanUserMapping.sp,v $ $Id: AppPlanUserMapping.sp,v 1.1.2.3 2016/03/22 18:56:46 anarde Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppPlanUserMapping <<<'

IF EXISTS (select * from sysobjects where name='AppPlanUserMapping')
	drop procedure AppPlanUserMapping
IF EXISTS (select * from GxQscripts where name='AppPlanUserMapping')
	delete from GxQscripts where name = 'AppPlanUserMapping'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUserMapping')
	delete from GXDBVersions where aliasname = 'AppPlanUserMapping'
GO
print '... Creating Procedure: AppPlanUserMapping'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanUserMapping
  @i_userId INTEGER,
  @o_xmlText XML OUTPUT,
  @o_errCode INTEGER OUTPUT,
  @o_errString nvarchar(1024) OUTPUT
AS
SET NOCOUNT ON
DECLARE @providerId     INTEGER
DECLARE @userRole      	INTEGER
BEGIN TRY
	BEGIN
		IF EXISTS(SELECT top 1 umDSProviderId FROM UMUsers Where id=@i_userId and enabled=1)
		BEGIN
			SELECT @providerId = umDSProviderId FROM UMUsers Where id=@i_userId
			IF EXISTS(select top 1 id from UMDSProviders with (nolock) where id=@providerId and serviceType !=5)
				BEGIN
					-- MSP Admin
					-- User Enum defined in api.x
					SET @userRole = 0
				END
			ELSE
			BEGIN
				IF EXISTS(select top 1 groupId from UMUserGroup UU INNER JOIN UMGroups UG ON UU.groupId=UG.id where UG.groupFlags&0x10000 <> 0 and UU.userId=@i_userId)
					BEGIN
						-- User has rights
						-- Tenant Admin
						SET @userRole = 1
					END
				ELSE
					BEGIN
						-- User does not have all rights
						-- Tenant User
						SET @userRole = 2
					END
			END
			set @o_errCode = 0
			set @o_errString = ''
			SET @o_xmlText = (SELECT @providerId AS '@id',
								@userRole AS '@userRole'
				FOR XML PATH('Api_GetUserMappings'),TYPE)
		END
		ELSE
			BEGIN
				set @o_errCode = 1001
				set @o_errString = 'Not able to determine user role'
				set @o_xmlText = '<Api_GetUserMappings/>'
			END
	END
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

    set @o_errCode = ERROR_NUMBER()
    set @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @o_xmlText = '<Api_GetUserMappings/>'
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanUserMapping')
	delete from GxQscripts where name = 'AppPlanUserMapping'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUserMapping')
	delete from GXDBVersions where aliasname = 'AppPlanUserMapping'
GO

insert into GXDBVersions values(2, 'AppPlanUserMapping',  '00010001000200030000', 'AppPlanUserMapping', '00010001000200030000')
GO

