

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanUpdateV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanUpdateV2.sp,v $ $Id: AppPlanUpdateV2.sp,v 1.1.2.84 2020/12/29 19:43:35 rengu Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppPlanUpdateV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanUpdateV2 <<<'
	drop procedure AppPlanUpdateV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanUpdateV2')
	delete from GxQscripts where name = 'AppPlanUpdateV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateV2')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateV2'
GO
print '... Creating Procedure: AppPlanUpdateV2'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppPlanUpdateV2
  @i_userId INT,
  @i_localeId INT,
  @x_xmlData XML OUTPUT 
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
-- debug
-- IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES  WHERE TABLE_NAME = 'App_PlanDebug') BEGIN
--     CREATE TABLE App_PlanDebug (id INT IDENTITY(1,1), [procedure] SYSNAME NOT NULL, [parameter] SYSNAME NOT NULL, value VARCHAR(MAX), [timestamp] DATETIME DEFAULT(GETUTCDATE()))
DECLARE @debug INT = 0
IF (@debug = 0) AND (EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES  WHERE TABLE_NAME = 'App_PlanDebug')) BEGIN
    DECLARE @debugStmnt AS NVARCHAR(MAX) = 'INSERT INTO App_PlanDebug([procedure],[parameter],[value]) VALUES(''AppPlanUpdate'', ''@x_xmlData'',''' +  CAST(@x_xmlData AS VARCHAR(MAX)) + ''')'
    EXEC sp_executesql @debugStmnt
END
DECLARE @currentTime INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
DECLARE @planId      INT = (SELECT ISNULL(ref.value('@planId', 'INT'),'') AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/summary/plan') R ( ref ))
DECLARE @basePlanId  INT = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE componentNameId = @planId AND attrName = 'Base plan'), 0)
DECLARE @userHasCapabilityUpdate INT = 0
DECLARE @userHasCapabilityInvite INT = 0
DECLARE @opType INT
DECLARE @idsStr AS VARCHAR(MAX) = '';
DECLARE @iterator INT = 0;
DECLARE @errorCode      INT = 0
DECLARE @errorString    NVARCHAR(MAX) = NULL
DECLARE @continue BIT = 1
DECLARE @x_xmlGroupResp     XML
DECLARE @adminUserId INT = ISNULL((SELECT  TOP 1 UG.userId
                                   FROM    UMUserGroup UG INNER JOIN UMGroups G ON G.id = UG.groupId
                                                          INNER JOIN UMUsers  U ON U.id = UG.groupId AND G.allAssociations = 1 AND G.allCapabilities = 1 AND G.selfAssociation = 1 AND U.enabled = 1), 0)
DECLARE @permissionsList VARCHAR(MAX) = NULL
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__UsersToBeDeassociated') IS NOT NULL DROP TABLE #AppPlanUpdate_tmp__UsersToBeDeassociated
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__UsersToBeReassociated') IS NOT NULL DROP TABLE #AppPlanUpdate_tmp__UsersToBeReassociated
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__Security_VisibleUsers')  IS NOT NULL DROP TABLE #AppPlanUpdate_tmp__Security_VisibleUsers
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__Security_VisibleUsersGroups')  IS NOT NULL DROP TABLE #AppPlanUpdate_tmp__Security_VisibleUsersGroups
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__Configuration')  IS NOT NULL DROP TABLE #AppPlanUpdate_tmp__Configuration
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__IdsSet')  IS NOT NULL DROP TABLE #AppPlanUpdate_tmp__IdsSet
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__ExecutionErrors') IS NOT NULL DROP TABLE #AppPlanUpdate_tmp__ExecutionErrors
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__SubclientUpdate') IS NOT NULL DROP TABLE #AppPlanUpdate_tmp__SubclientUpdate
IF OBJECT_ID('tempdb.dbo.#PlanDetails_PlanProps')       IS NOT NULL DROP TABLE #PlanDetails_PlanProps
CREATE TABLE #AppPlanUpdate_tmp__UsersToBeDeassociated(userId integer)
CREATE TABLE #AppPlanUpdate_tmp__UsersToBeReassociated(userId integer)
CREATE TABLE #AppPlanUpdate_tmp__Security_VisibleUsers(userId integer)
CREATE TABLE #AppPlanUpdate_tmp__Security_VisibleUsersGroups(userGroupId integer);
CREATE TABLE #AppPlanUpdate_tmp__IdsSet([type] INT, id INT)
CREATE TABLE #AppPlanUpdate_tmp__ExecutionErrors(__type__ INT, errCode INT, errMessage NVARCHAR(MAX))
CREATE TABLE #AppPlanUpdate_tmp__SubclientUpdate(recId INT IDENTITY(1,1) PRIMARY KEY, recType INT, idaType INT, [attribute] NVARCHAR(32), [value] NVARCHAR(32))
CREATE TABLE #PlanDetails_PlanProps         (depth INT, componentNameId INT, attrName VARCHAR(512), attrType INT, attrVal VARCHAR(MAX), [entityTypeId] INT, [Status] INT, PRIMARY KEY(attrName))
DECLARE @const_Required  INT = 1,
        @const_Forbidden INT = 2,
        @const_Possible  INT = 3
DECLARE @const_idTypeNew INT = 1,
        @const_idTypeCur INT = 2,
        @const_idTypeRes INT = 3
DECLARE @planName    NVARCHAR(255) = NULL
DECLARE @planSubType INT           = NULL
DECLARE @planOwnerId INT           = NULL
-- restrictions bits
DECLARE @constSealed    INT = 0x00000001 -- plan is sealed
DECLARE @const_Inheritance  INT = 1
DECLARE @const_DirectAssoc  INT = 2
CREATE TABLE #AppPlanUpdate_tmp__Configuration([type] integer, id integer);
IF (NOT EXISTS (SELECT id FROM App_Plan WHERE (id = @planId) AND ((flag & 0x00004) = 0) AND ((flag & 0x40000000) = 0) )   )
BEGIN
INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, 2, N'Plan not found')
    SET @continue = 0
END
-- moved up to check for replication plan security rights
IF @continue = 1
	SELECT  @planName = name, @planOwnerId = ownerId, @planSubType = subType FROM APP_Plan WHERE id = @planId
-- to check if user has rights to modify plan
IF @continue = 1 BEGIN
    EXEC sec_checkPermissionOnEntity @i_userId, 157, @userHasCapabilityUpdate OUTPUT, 158, @planId
    EXEC sec_checkPermissionOnEntity @i_userId, 159, @userHasCapabilityInvite OUTPUT, 158, @planId
    IF (@userHasCapabilityUpdate = 0) AND (@userHasCapabilityInvite = 0) AND (NOT EXISTS (SELECT id FROM App_Plan WHERE id = @planId AND ownerId = @i_userId))
	BEGIN
		-- sec_checkPermissionOnEntity just checks for rights on the plan. For replication plans, you need some extra checks like checking rights on the Hypervisor
        -- associated with the replication task of the plan.
IF(@planId <> 0 AND @planSubType = 83918853)
		BEGIN
EXEC [dbo].[sec_CheckRepPlanEntitiesSecurity] @planId, 158,@planSubType, @i_userId,0, @continue OUTPUT
			IF(@continue = 1)
			BEGIN
				SET @userHasCapabilityUpdate = 1
				SET @userHasCapabilityInvite = 1
			END
			ELSE
			BEGIN
INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, 5, N'Access denied.')
				SET @continue = 0
			END
		END
		ELSE
		BEGIN
INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, 5, N'Access denied.')
			SET @continue = 0
		END
    END
END
IF @continue = 1 BEGIN
    BEGIN TRY
        INSERT INTO #AppPlanUpdate_tmp__Configuration
SELECT @const_Required, _ID FROM dbo.SplitIDString((SELECT attrVal FROM App_PlanProp WHERE componentNameId = @planId AND attrName = 'Defintion entities : required'))
            UNION ALL
SELECT @const_Forbidden, _ID FROM dbo.SplitIDString((SELECT attrVal FROM App_PlanProp WHERE componentNameId = @planId AND attrName = 'Defintion entities : forbidden'))
            UNION ALL
SELECT @const_Possible,  _ID FROM dbo.SplitIDString((SELECT attrVal FROM App_PlanProp WHERE componentNameId = @planId AND attrName = 'Defintion entities : possible'))
        BEGIN TRANSACTION
        IF @userHasCapabilityUpdate = 1 BEGIN
        -- ========================================================================================================================================================================
        -- start updating
        -- ========================================================================================================================================================================
        -- prepare audit operation -------------------------------------------------------------------------------------------------------------------------------------------------
DECLARE @opMsgId    INT = (609 | (CAST(POWER(2, 24) AS BIGINT) * 84)) -- 'Modify existing plan'
        DECLARE @opEvMsgId  INT -- dummy not used.
        DECLARE @paramMsgId INT = 0
        DECLARE @opId       INT = 0
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userId, 158, @planId, @opEvMsgId OUTPUT, @opId OUTPUT
        -- -------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        -- get plans own client group. if client group is not set then plan does not require it or client group is inherited
DECLARE @clientGroupId INT = dbo.AppPlanGetEntityValueV2(@planId, 'Assigned client group', @const_DirectAssoc)
        -- update plan name if requested
        DECLARE @newPlanName NVARCHAR(255) = (SELECT ref.value('@planName', 'nvarchar(255)') AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/summary/plan') R ( ref ))
        IF @newPlanName IS NOT NULL AND @planName != @newPlanName BEGIN
            -- along with the plan name change all associated entities names will be changed :  storage policies, schedule policies, subclient policies, configuration policies
            -- features and access policies roles, replication schedules...
            EXEC AppPlanUpdateNameV2 @planId, @newPlanName, @i_userId, @i_localeId, @errorCode OUTPUT, @errorString OUTPUT
            IF @errorCode != 0 BEGIN
INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)
            END ELSE BEGIN
                -- audit
SET @paramMsgId = (1642 | (CAST(POWER(2, 24) AS BIGINT) * 85))  -- 	Plan '^1%s' renamed: new plan name is '^2%s'
                EXEC EvGuiAuditSetParamData @opId, @planName, 0
                EXEC EvGuiAuditSetParamData @opId, @newPlanName, 0
                EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
                SET @planName = @newPlanName
            END
            SET @paramMsgId = 0
            -- update table with new name
            UPDATE App_Plan SET name = @newPlanName WHERE id = @planId
            SET @planName = @newPlanName
        END
        -- update plan description if requested
        DECLARE @planDesc NVARCHAR(MAX) = (SELECT ref.value('@description', 'nvarchar(max)') AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/summary') R ( ref ))
        IF @planDesc IS NOT NULL BEGIN
            UPDATE App_Plan SET description = @planDesc WHERE id = @planId
        END
        -- update plan status if requested
        DECLARE @planStatus  INT =  (SELECT ref.value('@planStatusFlag', 'INT') AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/summary') R ( ref ))
        IF @planStatus IS NOT NULL BEGIN
            -- status change requested. store new value. if attempt to enable was made then actual status will be calculated at the very end of the this proc
            IF @planStatus = 0 OR @planStatus = 1 BEGIN
                UPDATE App_Plan SET flag = @planStatus WHERE id = @planId
            END
        END
        -- get/update plan definition values
        DECLARE @definitionMember XML = (SELECT @x_xmlData.query('Api_UpdatePlanReq/definition'))
        IF LEN(CAST(@definitionMember AS VARCHAR(MAX))) != 0 BEGIN
            TRUNCATE TABLE #AppPlanUpdate_tmp__Configuration
            -- definition values were specified in the request.
            -- -- list of required entities
            INSERT INTO #AppPlanUpdate_tmp__Configuration
                SELECT DISTINCT @const_Required, ref.value('@val', 'INT') FROM @x_xmlData.nodes('Api_UpdatePlanReq/definition/required') R ( ref )
            SET @idsStr = NULL
            SELECT @idsStr = COALESCE(@idsStr+ ',', '') + CAST(id AS VARCHAR(32)) FROM #AppPlanUpdate_tmp__Configuration WHERE [type] = @const_Required
            SET @idsStr = ISNULL(@idsStr , '')
EXEC AppPlanSetEntityValueV2 @planId, 'Defintion entities : required', @idsStr, @errorCode OUTPUT, @errorString OUTPUT
            -- -- list of forbidden entities
            INSERT INTO #AppPlanUpdate_tmp__Configuration
                SELECT DISTINCT @const_Forbidden, ref.value('@val', 'INT') FROM @x_xmlData.nodes('Api_UpdatePlanReq/definition/forbidden') R ( ref )
            SET @idsStr = NULL
            SELECT @idsStr = COALESCE(@idsStr+ ',', '') + CAST(id AS VARCHAR(32)) FROM #AppPlanUpdate_tmp__Configuration WHERE [type] = @const_Forbidden
            SET @idsStr = ISNULL(@idsStr , '')
EXEC AppPlanSetEntityValueV2 @planId, 'Defintion entities : forbidden', @idsStr, @errorCode OUTPUT, @errorString OUTPUT
            -- -- list of possible entities
            INSERT INTO #AppPlanUpdate_tmp__Configuration
                SELECT DISTINCT @const_Possible, ref.value('@val', 'INT') FROM @x_xmlData.nodes('Api_UpdatePlanReq/definition/possible') R ( ref )
            SET @idsStr = NULL
            SELECT @idsStr = COALESCE(@idsStr+ ',', '') + CAST(id AS VARCHAR(32)) FROM #AppPlanUpdate_tmp__Configuration WHERE [type] = @const_Possible
            SET @idsStr = ISNULL(@idsStr , '')
EXEC AppPlanSetEntityValueV2 @planId, 'Defintion entities : possible', @idsStr, @errorCode OUTPUT, @errorString OUTPUT
        END
        IF @debug != 0 BEGIN
            SELECT 'required',  id AS [required]  FROM #AppPlanUpdate_tmp__Configuration WHERE [type] = @const_Required
            SELECT 'forbidden', id AS [forbidden] FROM #AppPlanUpdate_tmp__Configuration WHERE [type] = @const_Forbidden
            SELECT 'possible',  id AS [possible]  FROM #AppPlanUpdate_tmp__Configuration WHERE [type] = @const_Possible
        END
        -- update inheritance rules. upon update completion descendants statuses will be recalculated. ----------------------------------------------------------------------------
        EXEC AppPlanUpdateRestrictionsV2 @i_userId, @i_localeId, @planId, @debug, @x_xmlData
        -- update schedule --------------------------------------------------------------------------------------------------------------------------------------------------------
        DECLARE @scheduleId VARCHAR(32) = (SELECT ref.value('@taskId', 'VARCHAR(32)') AS id FROM @x_xmlData.nodes('Api_UpdatePlanReq/schedule/task') R ( ref ))
        IF ISNUMERIC(@scheduleId) = 1
        BEGIN
            DECLARE @oldScheduleId INT = 0
            -- for laptop plan only : if schedule value is being replaced then schedule to client group association should be removed
IF (@planSubType = 33554439) AND (@clientGroupId IS NOT NULL) BEGIN
SET @oldScheduleId = CAST(ISNULL(dbo.AppPlanGetEntityValueV2(@planId, 'Schedule policy', default), '0') AS INT)
                IF @oldScheduleId != 0
                    DELETE FROM TM_AssocEntity  WHERE assocType = 28 AND clientGroupId = @clientGroupId AND taskId = @oldScheduleId
            END
EXEC AppPlanSetEntityValueV2 @planId, 'Schedule policy', @scheduleId, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (35, @errorCode, @errorString)
        END
        -- update storage ----------------------------------------------------------------------------------------------------------------------------------------------------------
        DECLARE @storageId VARCHAR(32) = (SELECT ref.value('@storagePolicyId', 'VARCHAR(32)') AS id FROM @x_xmlData.nodes('Api_UpdatePlanReq/storage/storagePolicy ') R ( ref ))
        IF ISNUMERIC(@storageId) = 1
        BEGIN
EXEC AppPlanSetEntityValueV2 @planId, 'Storage policy', @storageId, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (17, @errorCode, @errorString)
        END
		-- update storage rules ----------------------------------------------------------------------------------------------------------------------------------------------------
		-- GET RULE DETAILS FROM App_PlanProp TABLE FOR THE PLAN. STORE ALL THE RULEIDS-RANK-STORAGEPOLICYID FOR THE PLAN AS Api::PlanRuleMaps STRUCTURE.
DECLARE @storageRules XML = dbo.AppPlanGetEntityValueV2(@planId, 'Storage Rules', default)
		-- iterate each storage rule and form the xml with the details
		DECLARE @rulesCount INT = 0, @iter INT = 1, @rank INT, @policyId INT, @ruleId INT
		DECLARE @ruleXml XML
		SET @rulesCount = @x_xmlData.value('count(//.[@ruleId])', 'INT')
		WHILE (@iter <= @rulesCount)
		BEGIN
			SET @ruleXml = (SELECT ref.query('.') FROM @x_xmlData.nodes('Api_UpdatePlanReq/storageRules/rules[sql:variable("@iter")]') R ( ref ))
			SELECT @rank = @ruleXml.value('(/rules/@rank)[1]','int'), @ruleId = @ruleXml.value('(/rules/rule/@ruleId)[1]', 'int'),
				@policyId = @ruleXml.value('(/rules/storage/storagePolicy/@storagePolicyId)[1]', 'int')
			SET @iter = @iter + 1
			IF @rank IS NULL OR @ruleId IS NULL OR @policyId IS NULL
				continue;
			-- if first rule then push the rule in the xml ELSE check and just update the rank field. Cannot update other fields.
			IF @storageRules IS NULL
				SET @storageRules = '<Api_PlanRuleMaps></Api_PlanRuleMaps>'
			IF @storageRules.exist('//rules/rule[@ruleId=sql:variable("@ruleId")]') = 0
			BEGIN
				-- modify the attribute's value of the inserted node
				SET @storageRules.modify('insert <rules rank=""><rule ruleId=""/><policy storagePolicyId=""/></rules> as first into (/Api_PlanRuleMaps)[1]')
				SET @storageRules.modify('replace value of (/Api_PlanRuleMaps/rules/rule/@ruleId)[1] with sql:variable("@ruleId")')
				SET @storageRules.modify('replace value of (/Api_PlanRuleMaps/rules/policy/@storagePolicyId)[1] with sql:variable("@policyId")')
			END
			SET @storageRules.modify('replace value of (/Api_PlanRuleMaps/rules[rule/@ruleId=sql:variable("@ruleId")]/./@rank)[1] with sql:variable("@rank")')
		END
		IF @storageRules IS NOT NULL BEGIN
			DECLARE @rules varchar(max) = CAST(@storageRules as varchar(max))
EXEC AppPlanSetEntityValueV2 @planId, 'Storage Rules', @rules, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (159, @errorCode, @errorString)
		END
		-- Start  - update entity assignment rules ----------------------------------------------------------------------------------------------------------------------------------------------------
		IF @x_xmlData.exist('Api_UpdatePlanReq/entityRules') = 1
		BEGIN
			DECLARE @entityRuleXml XML
			SET @entityRuleXml = (SELECT
										@x_xmlData.value('(/Api_UpdatePlanReq/entityRules/@ruleOperation)[1]', 'INT') as '@ruleOperation',
										@x_xmlData.query('Api_UpdatePlanReq/entityRules/*')
									FOR XML PATH('Api_PlanEntityRulesInfoResp'), TYPE)
			IF @entityRuleXml IS NOT NULL
			BEGIN
				DECLARE @entityRules varchar(max) = CAST(@entityRuleXml as varchar(max))
EXEC AppPlanSetEntityValueV2 @planId, 'Entity rules', @entityRules, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (159, @errorCode, @errorString)
			END
		END
		-- End  - update entity assignment rules ----------------------------------------------------------------------------------------------------------------------------------------------------
        -- corresponded retention period value -------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
            DECLARE @retentionPeriod        INT = (SELECT ref.value('@retainBackupDataForDays', 'INT') AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/storage/copy[1]/retentionRules') R (ref))
DECLARE @retentionPeriodCurrent INT = dbo.AppPlanGetEntityValueV2(@planId, 'Subclient retention period', default)
            IF @retentionPeriod IS NULL AND @retentionPeriodCurrent IS NULL BEGIN
                (SELECT @retentionPeriod = retentionDays FROM archAgingRule WHERE copyId IN (SELECT defaultCopy FROM archGroup WHERE id = @storageId))
            END
            IF @retentionPeriod IS NOT NULL BEGIN
EXEC AppPlanSetEntityValueV2 @planId, 'Subclient retention period', @retentionPeriod, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (17, @errorCode, @errorString)
            END
        END
        -- update log schedule ----------------------------------------------------------------------------------------------------------------------------------------------------
        DECLARE @logScheduleId VARCHAR(32) = (SELECT ref.value('@taskId', 'VARCHAR(32)') AS id FROM @x_xmlData.nodes('Api_UpdatePlanReq/database/scheduleLog/task') R ( ref ))
        IF ISNUMERIC(@logScheduleId) = 1
        BEGIN
EXEC AppPlanSetEntityValueV2 @planId, 'Log schedule policy', @logScheduleId, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (35, @errorCode, @errorString)
        END
		--- For Server plan make sure to sync associations of planId for Log schedule policy and schedule policy everytime changes are made
IF @planId <> 0 AND @planSubType = 33554437
		BEGIN
			EXEC AppPlanUpdateScheduleAssociations @planId, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (35, @errorCode, @errorString)
		END
		-- update days between auto convert backup ------------------------------------------------------------------------------------------------------------------------------------------------------
        DECLARE @daysBetweenAutoConvertBackup VARCHAR(32) = (SELECT ref.value('@daysBetweenAutoConvertBackup', 'VARCHAR(32)') AS id FROM @x_xmlData.nodes('Api_UpdatePlanReq/database') R ( ref ))
        IF ISNUMERIC(@daysBetweenAutoConvertBackup) = 1
        BEGIN
EXEC AppPlanSetEntityValueV2 @planId, 'Days between auto convert of DB backup job', @daysBetweenAutoConvertBackup, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (35, @errorCode, @errorString)
        END
        -- update log storage ------------------------------------------------------------------------------------------------------------------------------------------------------
        DECLARE @logStorageId VARCHAR(32) = (SELECT ref.value('@storagePolicyId', 'VARCHAR(32)') AS id FROM @x_xmlData.nodes('Api_UpdatePlanReq/database/storageLog/storagePolicy ') R ( ref ))
        IF ISNUMERIC(@logStorageId) = 1
        BEGIN
EXEC AppPlanSetEntityValueV2 @planId, 'Log storage policy', @logStorageId, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (17, @errorCode, @errorString)
        END
        -- update features ---------------------------------------------------------------------------------------------------------------------------------------------------------
        DECLARE @featuresRoleId VARCHAR(32) = (SELECT ref.value('@roleId', 'VARCHAR(32)') AS id FROM @x_xmlData.nodes('Api_UpdatePlanReq/laptop/features/feature/role') R ( ref ))
        IF ISNUMERIC(@featuresRoleId) = 1
        BEGIN
EXEC AppPlanSetEntityValueV2 @planId, 'Feature', @featuresRoleId, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (120, @errorCode, @errorString)
        END
        -- update access policy ----------------------------------------------------------------------------------------------------------------------------------------------------
        DECLARE @accessRoleId VARCHAR(32) = (SELECT ref.value('@roleId', 'VARCHAR(32)') AS id FROM @x_xmlData.nodes('Api_UpdatePlanReq/laptop/accessPolicies/accessPolicy/role') R ( ref ))
        IF ISNUMERIC(@accessRoleId) = 1
        BEGIN
EXEC AppPlanSetEntityValueV2 @planId, 'Access policy', @accessRoleId, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (120, @errorCode, @errorString)
        END
        -- update edge drive value -------------------------------------------------------------------------------------------------------------------------------------------------
        DECLARE @edgeDriveClientId VARCHAR(32) = (SELECT ref.value('@clientId', 'VARCHAR(32)') AS id FROM @x_xmlData.nodes('Api_UpdatePlanReq/featureInfo/edgedriveInfo/edgeDriveAssociations/clientEntity') R ( ref ))
IF (ISNUMERIC(@edgeDriveClientId) = 1) AND (dbo.AppPlanGetEntityValueV2(@planId, 'Assgined Edge Drive', default) IS NULL)
        BEGIN
EXEC AppPlanSetEntityValueV2 @planId, 'Assgined Edge Drive', @edgeDriveClientId, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES ( 3, @errorCode, @errorString)
        END
        -- update mailbox archiving policy -----------------------------------------------------------------------------------------------------------------------------------------
        DECLARE @configurationPolicy VARCHAR(32) = (SELECT ref.value('@policyId', 'VARCHAR(32)') AS id FROM @x_xmlData.nodes('Api_UpdatePlanReq/exchange/mbArchiving/policyEntity') R ( ref ))
        IF ISNUMERIC(@configurationPolicy) = 1
        BEGIN
EXEC AppPlanSetEntityValueV2 @planId, 'Exchange mailbox archiving policy', @configurationPolicy, @errorCode OUTPUT, @errorString OUTPUT
            IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (154, @errorCode, @errorString) -- configuration policy entity value from CvEntities.x is 154
        END
        -- update mailbox retention policy -----------------------------------------------------------------------------------------------------------------------------------------
        SET @configurationPolicy = NULL
        SET @configurationPolicy = (SELECT ref.value('@policyId', 'VARCHAR(32)') AS id FROM @x_xmlData.nodes('Api_UpdatePlanReq/exchange/mbRetention/policyEntity') R ( ref ))
        IF ISNUMERIC(@configurationPolicy) = 1
        BEGIN
EXEC AppPlanSetEntityValueV2 @planId, 'Exchange mailbox retention policy', @configurationPolicy, @errorCode OUTPUT, @errorString OUTPUT
            IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (154, @errorCode, @errorString) -- configuration policy entity value from CvEntities.x is 154
        END
        -- update mailbox clean up policy ------------------------------------------------------------------------------------------------------------------------------------------
        SET @configurationPolicy = NULL
        SET @configurationPolicy = (SELECT ref.value('@policyId', 'VARCHAR(32)') AS id FROM @x_xmlData.nodes('Api_UpdatePlanReq/exchange/mbCleanup/policyEntity') R ( ref ))
        IF ISNUMERIC(@configurationPolicy) = 1
        BEGIN
EXEC AppPlanSetEntityValueV2 @planId, 'Exchange mailbox cleanup policy', @configurationPolicy, @errorCode OUTPUT, @errorString OUTPUT
            IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (154, @errorCode, @errorString) -- configuration policy entity value from CvEntities.x is 154
        END
        -- update mailbox journal policy -------------------------------------------------------------------------------------------------------------------------------------------
        SET @configurationPolicy = NULL
        SET @configurationPolicy = (SELECT ref.value('@policyId', 'VARCHAR(32)') AS id FROM @x_xmlData.nodes('Api_UpdatePlanReq/exchange/mbJournal/policyEntity') R ( ref ))
        IF ISNUMERIC(@configurationPolicy) = 1
        BEGIN
EXEC AppPlanSetEntityValueV2 @planId, 'Exchange mailbox journal policy', @configurationPolicy, @errorCode OUTPUT, @errorString OUTPUT
            IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (154, @errorCode, @errorString) -- configuration policy entity value from CvEntities.x is 154
        END
        -- update data configuration policy ----------------------------------------------------------------------------------------------------------------------------------------
        SET @configurationPolicy = NULL
        SET @configurationPolicy = (SELECT ref.value('@policyId', 'VARCHAR(32)') AS id FROM @x_xmlData.nodes('Api_UpdatePlanReq/eePolicyInfo/eePolicy/policyEntity') R ( ref ))
        IF ISNUMERIC(@configurationPolicy) = 1
		BEGIN
EXEC AppPlanSetEntityValueV2 @planId, 'Data classification policy', @configurationPolicy, @errorCode OUTPUT, @errorString OUTPUT
            IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (154, @errorCode, @errorString) -- configuration policy entity value from CvEntities.x is 154
        END
        -- update content indexing policy ------------------------------------------------------------------------------------------------------------------------------------------
        SET @configurationPolicy = NULL
        SET @configurationPolicy = (SELECT ref.value('@policyId', 'VARCHAR(32)') AS id FROM @x_xmlData.nodes('Api_UpdatePlanReq/ciPolicyInfo/ciPolicy/policyEntity') R ( ref ))
        IF ISNUMERIC(@configurationPolicy) = 1
		BEGIN
EXEC AppPlanSetEntityValueV2 @planId, 'Content Indexing Policy', @configurationPolicy, @errorCode OUTPUT, @errorString OUTPUT
            IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (154, @errorCode, @errorString) -- configuration policy entity value from CvEntities.x is 154
        END
		-------------------
		-- OFFICE 365 -----
		-------------------
		-- update office 365 CloudOffice backup policy -----------------------------------------------------------------------------------------------------------------------------------------
        SET @configurationPolicy = NULL
        SET @configurationPolicy = (SELECT ref.value('@policyId', 'VARCHAR(32)') AS id FROM @x_xmlData.nodes('Api_UpdatePlanReq/office365Info/o365CloudOffice/caBackup/policyEntity') R ( ref ))
        IF ISNUMERIC(@configurationPolicy) = 1
        BEGIN
EXEC AppPlanSetEntityValueV2 @planId, 'Office 365 backup policy', @configurationPolicy, @errorCode OUTPUT, @errorString OUTPUT
            IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (154, @errorCode, @errorString) -- configuration policy entity value from CvEntities.x is 154
        END
        -- update office 365 CloudOffice cleanup policy -----------------------------------------------------------------------------------------------------------------------------------------
        SET @configurationPolicy = NULL
        SET @configurationPolicy = (SELECT ref.value('@policyId', 'VARCHAR(32)') AS id FROM @x_xmlData.nodes('Api_UpdatePlanReq/office365Info/o365CloudOffice/caCleanup/policyEntity') R ( ref ))
        IF ISNUMERIC(@configurationPolicy) = 1
        BEGIN
EXEC AppPlanSetEntityValueV2 @planId, 'Office 365 cleanup policy', @configurationPolicy, @errorCode OUTPUT, @errorString OUTPUT
            IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (154, @errorCode, @errorString) -- configuration policy entity value from CvEntities.x is 154
        END
        -- update office 365 CloudOffice retention policy -----------------------------------------------------------------------------------------------------------------------------------------
        SET @configurationPolicy = NULL
        SET @configurationPolicy = (SELECT ref.value('@policyId', 'VARCHAR(32)') AS id FROM @x_xmlData.nodes('Api_UpdatePlanReq/office365Info/o365CloudOffice/caRetention/policyEntity') R ( ref ))
        IF ISNUMERIC(@configurationPolicy) = 1
        BEGIN
EXEC AppPlanSetEntityValueV2 @planId, 'Office 365 retention policy', @configurationPolicy, @errorCode OUTPUT, @errorString OUTPUT
            IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (154, @errorCode, @errorString) -- configuration policy entity value from CvEntities.x is 154
        END
		-- update office 365 mailbox archiving policy -----------------------------------------------------------------------------------------------------------------------------------------
		SET @configurationPolicy = NULL
        SET @configurationPolicy = (SELECT ref.value('@policyId', 'VARCHAR(32)') AS id FROM @x_xmlData.nodes('Api_UpdatePlanReq/office365Info/o365Exchange/mbArchiving/policyEntity') R ( ref ))
        IF ISNUMERIC(@configurationPolicy) = 1
        BEGIN
EXEC AppPlanSetEntityValueV2 @planId, 'Office 365 Mailbox archive policy', @configurationPolicy, @errorCode OUTPUT, @errorString OUTPUT
            IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (154, @errorCode, @errorString) -- configuration policy entity value from CvEntities.x is 154
        END
        -- update office 365 mailbox retention policy -----------------------------------------------------------------------------------------------------------------------------------------
        SET @configurationPolicy = NULL
        SET @configurationPolicy = (SELECT ref.value('@policyId', 'VARCHAR(32)') AS id FROM @x_xmlData.nodes('Api_UpdatePlanReq/office365Info/o365Exchange/mbRetention/policyEntity') R ( ref ))
        IF ISNUMERIC(@configurationPolicy) = 1
        BEGIN
EXEC AppPlanSetEntityValueV2 @planId, 'Office 365 Mailbox retention policy', @configurationPolicy, @errorCode OUTPUT, @errorString OUTPUT
            IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (154, @errorCode, @errorString) -- configuration policy entity value from CvEntities.x is 154
        END
        -- update office 365 mailbox clean up policy ------------------------------------------------------------------------------------------------------------------------------------------
        SET @configurationPolicy = NULL
        SET @configurationPolicy = (SELECT ref.value('@policyId', 'VARCHAR(32)') AS id FROM @x_xmlData.nodes('Api_UpdatePlanReq/office365Info/o365Exchange/mbCleanup/policyEntity') R ( ref ))
        IF ISNUMERIC(@configurationPolicy) = 1
        BEGIN
EXEC AppPlanSetEntityValueV2 @planId, 'Office 365 Mailbox cleanup policy', @configurationPolicy, @errorCode OUTPUT, @errorString OUTPUT
            IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (154, @errorCode, @errorString) -- configuration policy entity value from CvEntities.x is 154
        END
		------
		------
        -- analytics engine --------------------------------------------------------------------------------------------------------------------------------------------------------
        DECLARE @analyticsIndexServerId VARCHAR(32) = (SELECT ref.value('@clientId', 'VARCHAR(32)') AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/eDiscoveryInfo/analyticsIndexServer') R ( ref ))
        IF ISNUMERIC(@analyticsIndexServerId) = 1
        BEGIN
EXEC AppPlanSetEntityValueV2 @planId, 'Analytics Index Server Id', @analyticsIndexServerId, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (3, @errorCode, @errorString)
        END
        -- content analyzer --------------------------------------------------------------------------------------------------------------------------------------------------------
        DECLARE @contentAnalyzer VARCHAR(32) = (SELECT ref.value('@cloudId', 'VARCHAR(32)') AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/eDiscoveryInfo/contentAnalyzerCloud') R ( ref ))
        IF ISNUMERIC(@contentAnalyzer) = 1
        BEGIN
EXEC AppPlanSetEntityValueV2 @planId, 'Content Analyzer Cloud Id', @contentAnalyzer, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (169, @errorCode, @errorString)
        END
		----Updating AppSetFirewallTPPM to setup TPPM between Index Server and Content analyzer--------------------------------------------------------------------
		-- -- This Store proc will get called evrrytime any update is being made for the data classification plan but insertion will happen only if the entry doesnt exist
IF @planId <> 0 and (@planSubType = 117506053)
		BEGIN
			EXEC CreateTPPMForISToCA @planId
		END
        -- update alerts ----------------------------------------------------------------------------------------------------------------------------------------------------------
SET @opType = (SELECT ISNULL(ref.value('@alertOperationType', 'INT'), 0) AS [type] FROM @x_xmlData.nodes('Api_UpdatePlanReq/alerts') R ( ref ))
IF @opType != 0 BEGIN
            -- -- get list of currently existing alerts. Associate only subscription based alerts
            INSERT INTO #AppPlanUpdate_tmp__IdsSet
                SELECT  @const_idTypeCur, CAST(_ID AS INT)
FROM    dbo.SplitIDString(dbo.AppPlanGetEntityValueV2(@planId, 'Alert', default))
				INNER JOIN NTNotificationRule (NOLOCK) ON CAST(NTNotificationRule.id AS NVARCHAR(10)) = _ID
AND (NTNotificationRule.status & 128)>0
AND NTNotificationRule.revision = 1 AND (NTNotificationRule.status & 2 )= 0
            -- -- get list of alerts specified in the request
            INSERT INTO  #AppPlanUpdate_tmp__IdsSet
                SELECT  @const_idTypeNew, ref.value('@alertId', 'INT')
                FROM    @x_xmlData.nodes('Api_UpdatePlanReq/alerts/alert') R (ref)
				INNER JOIN NTNotificationRule (NOLOCK) ON CAST(NTNotificationRule.id AS NVARCHAR(10)) = ref.value('@alertId', 'INT')
AND (NTNotificationRule.status & 128)>0
AND NTNotificationRule.revision = 1 AND (NTNotificationRule.status & 2 )= 0
IF @opType = 1 -- replace old entities set with new entities set.
                INSERT INTO #AppPlanUpdate_tmp__IdsSet
                    SELECT  @const_idTypeRes, id FROM #AppPlanUpdate_tmp__IdsSet WHERE ISNUMERIC(id) > 0 AND [type] = @const_idTypeNew
ELSE IF @opType = 2 -- old and new
                INSERT INTO #AppPlanUpdate_tmp__IdsSet
                    SELECT  DISTINCT @const_idTypeRes, id FROM #AppPlanUpdate_tmp__IdsSet WHERE ISNUMERIC(id) > 0
ELSE IF @opType = 3 -- only those existing in old set and not existsing in a new one
                INSERT INTO #AppPlanUpdate_tmp__IdsSet
                    SELECT  @const_idTypeRes, id FROM #AppPlanUpdate_tmp__IdsSet WHERE [type] = @const_idTypeCur
                                                                    AND id NOT IN (SELECT id FROM #AppPlanUpdate_tmp__IdsSet WHERE ISNUMERIC(id) > 0 AND [type] = @const_idTypeNew)
                                                                    AND ISNUMERIC(id) > 0
            -- ELSE
            -- -- no need to process PLAN_ENTITY_LISTOP__CLEAR as #AppPlanUpdate_tmp__IdsSet will not have any records of const_idTypeRes type so resulting list will be empty
            -- -- Remove recipient cache for all alerts in request so that they are refreshed again
            DELETE FROM  NTNotificationProp
WHERE       (attrName = 'Recipient UserId' OR attrName = 'Recipient UserGroupId')
                    AND componentNameId IN (SELECT DISTINCT id FROM #AppPlanUpdate_tmp__IdsSet WHERE ISNUMERIC(id) > 0 AND [type] != @const_idTypeRes)
            -- at this point table @#AppPlanUpdate_tmp__IdsSet contains list ow elements to replace current value with.
            -- build string
            SET @idsStr = NULL
            SELECT  @idsStr = COALESCE(@idsStr+ ',', '') + CAST(Id AS VARCHAR(32))
            FROM    #AppPlanUpdate_tmp__IdsSet
            WHERE   [type] = @const_idTypeRes
            ORDER   BY id ASC
            -- no need for table data any more. make sure that temporary table is empty for next usage
            TRUNCATE TABLE #AppPlanUpdate_tmp__IdsSet
            IF @debug != 0 BEGIN
                SELECT 'alerts table::current', * FROM #AppPlanUpdate_tmp__IdsSet WHERE [type] = @const_idTypeCur
                SELECT 'alerts table::new',     * FROM #AppPlanUpdate_tmp__IdsSet WHERE [type] = @const_idTypeNew
                SELECT 'alerts table::res',     * FROM #AppPlanUpdate_tmp__IdsSet WHERE [type] = @const_idTypeRes
                SELECT 'alerts comma-separated string', @idsStr
            END
            -- -- set alerts value
            SET @idsStr = ISNULL(@idsStr, '')
EXEC AppPlanSetEntityValueV2 @planId, 'Alert', @idsStr, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (64, @errorCode, @errorString)
        END
        -- replication targets -----------------------------------------------------------------------------------------------------------------------------------------------------
SET @opType = (SELECT ISNULL(ref.value('@replicationTargetOperationType', 'INT'), 0) AS [type] FROM @x_xmlData.nodes('Api_UpdatePlanReq/replicationTargets') R ( ref ))
IF @opType != 0 BEGIN
            -- -- get list of currently existing alerts
            INSERT INTO #AppPlanUpdate_tmp__IdsSet
                SELECT  @const_idTypeCur, CAST(_ID AS INT)
FROM    dbo.SplitIDString(dbo.AppPlanGetEntityValueV2(@planId, 'Replication schedule policy', default))
            -- -- get list of alerts specified in the request
            INSERT INTO #AppPlanUpdate_tmp__IdsSet
                SELECT  @const_idTypeNew, ref.value('@taskId', 'INT')
                FROM    @x_xmlData.nodes('Api_UpdatePlanReq/replicationTargets/planReplicationTargets/taskInfo/task') R (ref)
IF @opType = 1
                INSERT INTO #AppPlanUpdate_tmp__IdsSet
                    SELECT @const_idTypeRes, id FROM #AppPlanUpdate_tmp__IdsSet WHERE ISNUMERIC(id) > 0 AND [type] = @const_idTypeNew
ELSE IF @opType = 2
                INSERT INTO #AppPlanUpdate_tmp__IdsSet
                    SELECT @const_idTypeRes, id FROM #AppPlanUpdate_tmp__IdsSet WHERE ISNUMERIC(id) > 0
ELSE IF @opType = 3 -- only those existing in old set and not existsing in a new one
                INSERT INTO #AppPlanUpdate_tmp__IdsSet
                    SELECT  @const_idTypeRes, id FROM #AppPlanUpdate_tmp__IdsSet WHERE [type] = @const_idTypeCur
                                                                    AND id NOT IN (SELECT id FROM #AppPlanUpdate_tmp__IdsSet WHERE ISNUMERIC(id) > 0 AND [type] = @const_idTypeNew)
                                                                    AND ISNUMERIC(id) > 0
            -- ELSE
            -- -- no need to process PLAN_ENTITY_LISTOP__CLEAR as #AppPlanUpdate_tmp__IdsSet will not have any records of const_idTypeRes type so resulting list will be empty
            -- at this point table @#AppPlanUpdate_tmp__IdsSet contains list ow elements to replace current value with.
            -- build string
            SET @idsStr = NULL
            SELECT  @idsStr = COALESCE(@idsStr+ ',', '') + CAST(Id AS VARCHAR(32))
            FROM    #AppPlanUpdate_tmp__IdsSet
            WHERE   [type] = @const_idTypeRes
            ORDER   BY id ASC
            IF @debug != 0 BEGIN
                SELECT 'replication schedules table::current', * FROM #AppPlanUpdate_tmp__IdsSet WHERE [type] = @const_idTypeCur
                SELECT 'replication schedules table::new',     * FROM #AppPlanUpdate_tmp__IdsSet WHERE [type] = @const_idTypeNew
                SELECT 'replication schedules table::res',     * FROM #AppPlanUpdate_tmp__IdsSet WHERE [type] = @const_idTypeRes
                SELECT 'replication schedules comma-separated string', @idsStr
            END
            -- -- set replication target values
            SET @idsStr = ISNULL(@idsStr , '')
EXEC AppPlanSetEntityValueV2 @planId, 'Replication schedule policy', @idsStr, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (69, @errorCode, @errorString)
            -- For all deleted replication schedules mark schedule deleted - ones that exist in the table with type  = @const_idTypeCur but do not exist with type = @const_idTypeRes
            UPDATE TM_Task SET deleted = 1
            WHERE  taskId IN (SELECT id FROM #AppPlanUpdate_tmp__IdsSet WHERE [type] = @const_idTypeCur
                              EXCEPT
                              SELECT id FROM #AppPlanUpdate_tmp__IdsSet WHERE [type] = @const_idTypeRes)
            -- no need for table data any more. make sure that temporary table is empty for next usage
            TRUNCATE TABLE #AppPlanUpdate_tmp__IdsSet
        END
        -- update subclient policies -----------------------------------------------------------------------------------------------------------------------------------------------
SET @opType  = (SELECT ISNULL(ref.value('@backupContentOperationType', 'INT'), 0) AS [type] FROM @x_xmlData.nodes('Api_UpdatePlanReq/laptop/content') R ( ref ))
IF @opType <> 0 BEGIN
            -- create intermediate tables
            DECLARE @idsSubCur AS TABLE([type] NVARCHAR(32), [id] NVARCHAR(32))
            DECLARE @idsSubNew AS TABLE([type] NVARCHAR(32), [id] NVARCHAR(32))
            DECLARE @idsSubRes AS TABLE([type] NVARCHAR(32), [id] NVARCHAR(32))
            -- -- get list of new subclient policies
            INSERT INTO @idsSubNew
SELECT  'Subclient policy' + ' ' + ref.value('(../../@idatype)[1]', 'NVARCHAR(32)') AS [type],
                        ref.value('@backupsetId', 'NVARCHAR(32)')        AS [id]
                FROM    @x_xmlData.nodes('Api_UpdatePlanReq/laptop/content/backupContent/subClientPolicy/backupSetEntity') R (ref)
            -- -- get list of currently existing subclient policies
            INSERT INTO @idsSubCur
SELECT attrName, CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @planId AND attrName LIKE 'Subclient policy' + '%'
            -- -- remove entries that belong directly to the plan. inherited entries will not be deleted and later on will not be updated during
            -- -- setting entity value
            DECLARE @SubclientPolicyNameTemplate VARCHAR(32)= 'Subclient policy' + ' %'
            DELETE FROM App_PlanProp WHERE componentNameId = @planId AND attrName LIKE @SubclientPolicyNameTemplate
            -- -- build resulting subclient policies set
IF @opType = 1
                INSERT INTO @idsSubRes SELECT [type], [id] FROM @idsSubNew WHERE ISNUMERIC(id) > 0
ELSE IF @opType = 2
                INSERT INTO @idsSubRes SELECT [type], [id] FROM @idsSubNew WHERE ISNUMERIC(id) > 0
                                       UNION
                                       SELECT [type], [id] FROM @idsSubCur WHERE ISNUMERIC(id) > 0 AND [type] NOT IN (SELECT [type] FROM @idsSubNew)
ELSE IF @opType = 3
                INSERT INTO @idsSubRes SELECT [type], [id] FROM @idsSubCur WHERE ISNUMERIC(id) > 0 AND [type] NOT IN (SELECT [type] FROM @idsSubNew WHERE ISNUMERIC(id) > 0)
            -- -- reinsert subclient policy ids
            DECLARE @iteratorAttrName VARCHAR(64) = (SELECT MIN([type]) FROM @idsSubRes)
            WHILE @iteratorAttrName IS NOT NULL BEGIN
                DECLARE @value NVARCHAR(32) = (SELECT id FROM @idsSubRes WHERE [type] = @iteratorAttrName)
                EXEC AppPlanSetEntityValueV2 @planId, @iteratorAttrName, @value, @errorCode OUTPUT, @errorString OUTPUT
                IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (65, @errorCode, @errorString) -- 65 : 65
                -- next iteration
                SELECT @iteratorAttrName = MIN([type]) FROM @idsSubRes WHERE [type] > @iteratorAttrName
            END
        END
        -- update subclient policies components ------------------------------------------------------------------------------------------------------------------------------------
        DECLARE @defSubclientWin INT = 0, @defSubclientContentWin INT = 0, @defSubclientRetentionWin INT = 0,
                @defSubclientLin INT = 0, @defSubclientContentLin INT = 0, @defSubclientRetentionLin INT = 0,
                @defSubclientMac INT = 0, @defSubclientContentMac INT = 0, @defSubclientRetentionMac INT = 0,
				@defSubclientArcRulesWin INT = 0, @defSubclientArcRulesLin INT = 0
        SELECT  @defSubclientWin          = ISNULL(ref.value('(definesSubclientWin/@definesEntity)[1]',          'INT'), 0),
                @defSubclientLin          = ISNULL(ref.value('(definesSubclientLin/@definesEntity)[1]',          'INT'), 0),
                @defSubclientMac          = ISNULL(ref.value('(definesSubclientMac/@definesEntity)[1]',          'INT'), 0)
        FROM    @x_xmlData.nodes('Api_UpdatePlanReq/laptop/content') R ( ref )
        SELECT  @defSubclientContentWin   = IIF( @defSubclientWin != 0 AND @basePlanId  = 0, 1, ISNULL(ref.value('(definesSubclientContentWin/@definesEntity)[1]',   'INT'), 0)),
                @defSubclientContentLin   = IIF( @defSubclientLin != 0 AND @basePlanId  = 0, 1, ISNULL(ref.value('(definesSubclientContentLin/@definesEntity)[1]',   'INT'), 0)),
                @defSubclientContentMac   = IIF( @defSubclientMac != 0 AND @basePlanId  = 0, 1, ISNULL(ref.value('(definesSubclientContentMac/@definesEntity)[1]',   'INT'), 0)),
                @defSubclientRetentionWin = IIF( @defSubclientWin != 0 AND @basePlanId  = 0, 1, ISNULL(ref.value('(definesSubclientRetentionWin/@definesEntity)[1]', 'INT'), 0)),
                @defSubclientRetentionLin = IIF( @defSubclientLin != 0 AND @basePlanId  = 0, 1, ISNULL(ref.value('(definesSubclientRetentionLin/@definesEntity)[1]', 'INT'), 0)),
                @defSubclientRetentionMac = IIF( @defSubclientMac != 0 AND @basePlanId  = 0, 1, ISNULL(ref.value('(definesSubclientRetentionMac/@definesEntity)[1]', 'INT'), 0)),
				@defSubclientArcRulesWin  = IIF( @defSubclientWin != 0 AND @basePlanId  = 0, 1, ISNULL(ref.value('(definesSubclientArcRulesWin/@definesEntity)[1]',  'INT'), 0)),
				@defSubclientArcRulesLin  = IIF( @defSubclientLin != 0 AND @basePlanId  = 0, 1, ISNULL(ref.value('(definesSubclientArcRulesLin/@definesEntity)[1]',  'INT'), 0))
        FROM    @x_xmlData.nodes('Api_UpdatePlanReq/laptop/content') R ( ref )
        IF @debug != 0 BEGIN
            SELECT 'subclient components definition flags', @defSubclientWin, @defSubclientLin, @defSubclientMac,
                                                            @defSubclientContentWin, @defSubclientContentLin, @defSubclientContentMac,
                                                            @defSubclientRetentionWin, @defSubclientRetentionLin, @defSubclientRetentionMac,
															@defSubclientArcRulesWin, @defSubclientArcRulesLin
        END
        DECLARE @componentValueXML XML = NULL
        DECLARE @componentValueSTR NVARCHAR(MAX) = NULL
        -- -- subclient content ----------------------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
            -- -- -- windows subclient content
            IF @defSubclientWin = 1 AND @defSubclientContentWin = 1 BEGIN
                SET @componentValueXML = (SELECT T.c.query('.')
                                          FROM   @x_xmlData.nodes('/Api_UpdatePlanReq/laptop/content/backupContent/subClientPolicy/subClientList[1]/content') T(c)
                                          WHERE  T.c.value('(../../../@idatype)[1]', 'INT') = 2
                                          FOR XML PATH(''), ROOT('App_SubClientInfo') )
SET @componentValueSTR = IIF(@componentValueXML IS NULL, dbo.AppPlanGetEntityValueV2(@planId, 'Subclient policy 2', 2), CONVERT(VARCHAR(MAX), @componentValueXML))
EXEC AppPlanSetEntityValueV2 @planId, 'Subclient content 2', @componentValueSTR, @errorCode OUTPUT, @errorString OUTPUT
                IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (65, @errorCode, @errorString)
            END
            -- -- -- linux subclient content
            SET @componentValueXML = NULL
            SET @componentValueSTR = NULL
            IF @defSubclientLin = 1 AND @defSubclientContentLin = 1 BEGIN
                SET @componentValueXML = (SELECT T.c.query('.')
                                          FROM   @x_xmlData.nodes('/Api_UpdatePlanReq/laptop/content/backupContent/subClientPolicy/subClientList[1]/content') T(c)
                                          WHERE  T.c.value('(../../../@idatype)[1]', 'INT') = 3
                                          FOR XML PATH(''), ROOT('App_SubClientInfo') )
SET @componentValueSTR = IIF(@componentValueXML IS NULL, dbo.AppPlanGetEntityValueV2(@planId, 'Subclient policy 3', 2), CONVERT(VARCHAR(MAX), @componentValueXML))
EXEC AppPlanSetEntityValueV2 @planId, 'Subclient content 3', @componentValueSTR, @errorCode OUTPUT, @errorString OUTPUT
                IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (65, @errorCode, @errorString)
            END
            -- -- -- mac subclient content
            SET @componentValueXML = NULL
            SET @componentValueSTR = NULL
            IF @defSubclientMac = 1 AND @defSubclientContentMac = 1 BEGIN
                SET @componentValueXML = (SELECT T.c.query('.')
                                          FROM   @x_xmlData.nodes('/Api_UpdatePlanReq/laptop/content/backupContent/subClientPolicy/subClientList[1]/content') T(c)
                                          WHERE  T.c.value('(../../../@idatype)[1]', 'INT') = 4
                                          FOR XML PATH(''), ROOT('App_SubClientInfo') )
SET @componentValueSTR = IIF(@componentValueXML IS NULL, dbo.AppPlanGetEntityValueV2(@planId, 'Subclient policy 4', 2), CONVERT(VARCHAR(MAX), @componentValueXML))
EXEC AppPlanSetEntityValueV2 @planId, 'Subclient content 4', @componentValueSTR, @errorCode OUTPUT, @errorString OUTPUT
                IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (65, @errorCode, @errorString)
            END
        END
        -- -- retention rules ------------------------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
            -- -- -- windows retention rules
            SET @componentValueXML = NULL
            SET @componentValueSTR = NULL
            IF @defSubclientWin = 1 AND @defSubclientRetentionWin = 1 BEGIN
                SET @componentValueXML = (SELECT T.c.query('.')
                                          FROM   @x_xmlData.nodes('/Api_UpdatePlanReq/laptop/content/backupContent/subClientPolicy/subClientList[1]/fsSubClientProp') T(c)
                                          WHERE  T.c.value('(../../../@idatype)[1]', 'INT') = 2
                                          FOR XML PATH(''), ROOT('App_SubClientInfo'))
SET @componentValueSTR = IIF(@componentValueXML IS NULL, dbo.AppPlanGetEntityValueV2(@planId, 'Subclient policy 2', 2), CONVERT(VARCHAR(MAX), @componentValueXML))
EXEC AppPlanSetEntityValueV2 @planId, 'Subclient retentions 2', @componentValueSTR, @errorCode OUTPUT, @errorString OUTPUT
                IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (65, @errorCode, @errorString)
            END
            -- -- -- linux retention rules
            SET @componentValueXML = NULL
            SET @componentValueSTR = NULL
            IF @defSubclientLin = 1 AND @defSubclientRetentionLin = 1 BEGIN
                SET @componentValueXML = (SELECT T.c.query('.')
                                          FROM   @x_xmlData.nodes('/Api_UpdatePlanReq/laptop/content/backupContent/subClientPolicy/subClientList[1]/fsSubClientProp') T(c)
                                          WHERE  T.c.value('(../../../@idatype)[1]', 'INT') = 3
                                          FOR XML PATH(''), ROOT('App_SubClientInfo'))
SET @componentValueSTR = IIF(@componentValueXML IS NULL, dbo.AppPlanGetEntityValueV2(@planId, 'Subclient policy 3', 2), CONVERT(VARCHAR(MAX), @componentValueXML))
EXEC AppPlanSetEntityValueV2 @planId, 'Subclient retentions 3', @componentValueSTR, @errorCode OUTPUT, @errorString OUTPUT
                IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (65, @errorCode, @errorString)
            END
            -- -- -- mac retention rules
            SET @componentValueXML = NULL
            SET @componentValueSTR = NULL
            IF @defSubclientMac = 1 AND @defSubclientRetentionMac = 1 BEGIN
                SET @componentValueXML = (SELECT T.c.query('.')
                                          FROM   @x_xmlData.nodes('/Api_UpdatePlanReq/laptop/content/backupContent/subClientPolicy/subClientList[1]/fsSubClientProp') T(c)
                                          WHERE  T.c.value('(../../../@idatype)[1]', 'INT') = 4
                                          FOR XML PATH(''), ROOT('App_SubClientInfo'))
SET @componentValueSTR = IIF(@componentValueXML IS NULL, dbo.AppPlanGetEntityValueV2(@planId, 'Subclient policy 4', 2), CONVERT(VARCHAR(MAX), @componentValueXML))
EXEC AppPlanSetEntityValueV2 @planId, 'Subclient retentions 4', @componentValueSTR, @errorCode OUTPUT, @errorString OUTPUT
                IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (65, @errorCode, @errorString)
            END
        END
		-- -- arc rules ------------------------------------------------------------------------------------------------------------------------------------------------------
		BEGIN
			-- -- -- windows arc rules
			SET @componentValueXML = NULL
            SET @componentValueSTR = NULL
			IF @defSubclientWin = 1 AND @defSubclientArcRulesWin = 1 BEGIN
                SET @componentValueXML = (SELECT T.c.query('.')
                                          FROM   @x_xmlData.nodes('/Api_UpdatePlanReq/laptop/content/backupContent/subClientPolicy/subClientList[1]/fsSubClientProp') T(c)
                                          WHERE  T.c.value('(../../../@idatype)[1]', 'INT') = 2
                                          FOR XML PATH(''), ROOT('App_SubClientInfo'))
SET @componentValueSTR = IIF(@componentValueXML IS NULL, dbo.AppPlanGetEntityValueV2(@planId, 'Subclient policy 2', 2), CONVERT(VARCHAR(MAX), @componentValueXML))
EXEC AppPlanSetEntityValueV2 @planId, 'Subclient archival rules 2', @componentValueSTR, @errorCode OUTPUT, @errorString OUTPUT
                IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (65, @errorCode, @errorString)
            END
			-- -- -- linux retention rules
            SET @componentValueXML = NULL
            SET @componentValueSTR = NULL
            IF @defSubclientLin = 1 AND @defSubclientArcRulesLin = 1 BEGIN
                SET @componentValueXML = (SELECT T.c.query('.')
                                          FROM   @x_xmlData.nodes('/Api_UpdatePlanReq/laptop/content/backupContent/subClientPolicy/subClientList[1]/fsSubClientProp') T(c)
                                          WHERE  T.c.value('(../../../@idatype)[1]', 'INT') = 3
                                          FOR XML PATH(''), ROOT('App_SubClientInfo'))
SET @componentValueSTR = IIF(@componentValueXML IS NULL, dbo.AppPlanGetEntityValueV2(@planId, 'Subclient policy 3', 2), CONVERT(VARCHAR(MAX), @componentValueXML))
EXEC AppPlanSetEntityValueV2 @planId, 'Subclient archival rules 3', @componentValueSTR, @errorCode OUTPUT, @errorString OUTPUT
                IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (65, @errorCode, @errorString)
            END
		END
        -- number of versions to keep ----------------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
            DECLARE @versionsNum        INT = (SELECT ref.value('@keepAtLeastPreviousVersions', 'INT') AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/laptop/content/backupContent[1]/subClientPolicy/subClientList/fsSubClientProp') R ( ref ))
DECLARE @versionsNumCurrent INT = dbo.AppPlanGetEntityValueV2(@planId, 'Number of synth full versions', default)
            IF @versionsNum IS NULL AND @versionsNumCurrent IS NULL BEGIN
                SET @versionsNum = 5
            END
            IF @versionsNum IS NOT NULL BEGIN
EXEC AppPlanSetEntityValueV2 @planId, 'Number of synth full versions', @versionsNum, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (17, @errorCode, @errorString)
            END
        END
        -- plan client group  ------------------------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
IF (@clientGroupId IS NOT NULL) AND (@planSubType != 33579013) BEGIN
                -- for laptop plans schedule association/de-association should happen. get current schedule id value
SET @scheduleId = dbo.AppPlanGetEntityValueV2(@planId, 'Schedule policy', default)
			-- We have remove SCG code from Update SP as it should not be missing in any case.
            -- -- make sure that client group exists
            IF NOT EXISTS(SELECT id FROM APP_ClientGroup WHERE id = @clientGroupId) BEGIN
                -- -- -- remove client group schedule association -----------------------------------------------------------------------------------------------------
IF (@planSubType = 33554439) AND (@scheduleId IS NOT NULL)
                    DELETE FROM TM_AssocEntity  WHERE assocType = 28 AND clientGroupId = @clientGroupId
                -- -- -- make sure that there is no duplicates in client group names ----------------------------------------------------------------------------------
                DECLARE @clientGroupName NVARCHAR(1020) = @planName + ' clients'
EXEC AppGetUniqueEntityName 28, @clientGroupName, @planOwnerId, @clientGroupName OUTPUT
                -- -- create entry in client group table
                INSERT INTO APP_ClientGroup(name, description, flag, status, userId, refTime, modified, origCCid, GUID)
                    VALUES(@clientGroupName, @planName + ' associated clients' , 4096, 0, @adminUserId, @currentTime, @currentTime, 2, NEWID())
                SET @clientGroupId = SCOPE_IDENTITY()
                -- -- smart client group definition
                -- -- -- SCG_PKID_CLIENT_ASSOCIATED_WITH_PLAN = 34 = prodID
                DECLARE @scgDefintion XML = '<scgRule op="0"><rules><rule op="0"><rules>
                                                <rule filterID="12" propID="' + (SELECT CAST(id AS NVARCHAR(32)) FROM App_SCGProperty WITH(NOLOCK) WHERE name = 'CLIENT_ASSOCIATED_WITH_PLAN')+ '" propType="2" value="' + (SELECT @planName FOR XML PATH('')) + '" />
                                            </rules></rule></rules></scgRule>'
                DECLARE  @scgRule VARCHAR(max)
                EXEC APPSCGV2GenerateQueryParams @scgDefintion, @errorCode OUTPUT, @errorString OUTPUT, @scgRule OUTPUT
                IF @errorCode != 0 BEGIN
                    SET @clientGroupId = NULL
INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (28, @errorCode, @errorString)
                END
                IF @clientGroupId IS NOT NULL BEGIN
                    INSERT  INTO App_SCGRule (scgId, ruleXml, ruleQuery, ownerId, created, modified)
                        VALUES (@clientGroupId, @scgDefintion, @scgRule, @planOwnerId, @currentTime, 0)
                    -- setting ownership for smart client group
                    EXEC sec_setCreatorForEntity @planOwnerId, 0, '1,2', @errorCode OUTPUT, @errorString OUTPUT, 28, @clientGroupId
                    IF @errorCode != 0 BEGIN
                        SET @clientGroupId = NULL
INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (28, @errorCode, @errorString)
                    END
					-- IF owner company is an actual company and not commserv , then change scope to that company
					DECLARE @ownerCompanyId INT = dbo.AppGetOrganizationForUser(@planOwnerId)
					IF (@ownerCompanyId > 0)
					BEGIN
						-- Set scope to that company clients
						UPDATE APSCG
SET APSCG.entityType = 61,
								APSCG.entityId = @ownerCompanyId
							FROM APP_SCGScope APSCG
							INNER JOIN App_SCGRule ASCG WITH(NOLOCK)
								ON ASCG.id=APSCG.scgRuleId
						WHERE
							ASCG.scgId=@clientGroupId
					END
                END
				-- We have to provide owner permission on Plan SCG. So that once any laptop get activated by this plan, then all owners of those laptop get that permission set rights via this SCG
				DECLARE @spXML XML
				DECLARE @errorTable TABLE(
										errorCode INT,
										errorString NVARCHAR(MAX)
									)
				SET @spXML =(SELECT 2 AS '@associationsOperationType',
								(SELECT
								   (SELECT 1 as '@categoriesPermissionOperationType',
(SELECT 102  as '@categoryId',
121 as '@_type_',
													  'Client' AS '@categoryName'  -- CATEGORY_CLIENT_NAME
											FOR XML PATH ('categoriesPermissionList'),TYPE)
									FOR XML PATH('categoryPermission'), TYPE)
								FOR XML PATH('ownerAssociations'),TYPE)
						FOR XML PATH('App_SecurityAssociationForEntityList'))
				IF(@spXML IS NOT NULL)
				BEGIN
					INSERT INTO @errorTable
EXEC Sec_setSecurityAssociationsFromEntity @spXML,@planOwnerId,0,1,28,@clientGroupId,0,0,0,0,0,0,0,0
					IF EXISTS(SELECT 1 FROM @errorTable WHERE errorCode<>0)
					BEGIN
						SET @clientGroupId = NULL
						INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors
SELECT 28, errorCode,errorString FROM @errorTable WHERE errorCode<>0
					END
				END
                DECLARE @clientGroupIdvarchar VARCHAR(32) = CAST(@clientGroupId AS VARCHAR)
EXEC AppPlanSetEntityValueV2 @planId, 'Assigned client group', @clientGroupIdvarchar, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (28, @errorCode, @errorString)
            END
        END
        -- update schedule info
IF (@clientGroupId IS NOT NULL) AND (@planSubType = 33554439) BEGIN
SET @scheduleId = dbo.AppPlanGetEntityValueV2(@planId, 'Schedule policy', default)
                IF (@scheduleId IS NOT NULL) AND (CAST(@scheduleId AS INT) > 0) BEGIN
                IF EXISTS (SELECT assocId FROM TM_AssocEntity WHERE assocType = 28 AND clientGroupId = @clientGroupId)
                    UPDATE TM_AssocEntity SET taskId = @scheduleId WHERE assocType = 28 AND clientGroupId = @clientGroupId
                ELSE
                    INSERT TM_AssocEntity (assocType, taskId, flags, created, clientGroupId, clientId, apptypeId, instanceId, backupsetId, subclientId, policyId, copyId, srmReportSet, srmReportType, exclude, trackingPolicyId, MediaAgentId, agentlessPolicyId, workflowId, sidbStoreId, libraryId, logMonitoringPolicyId)
                    VALUES(28, CAST(@scheduleId AS INT), 0, @currentTime, @clientGroupId, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
            END ELSE BEGIN
               DELETE FROM TM_AssocEntity WHERE assocType = 28 AND clientGroupId = @clientGroupId
            END
			-- dlp feature sync
			IF EXISTS(SELECT  1
				FROM UMPermissions permission INNER JOIN
					 UMRolesPermissions roleToPermissionMap ON roleToPermissionMap.permissionId =  permission.id
WHERE       roleToPermissionMap.roleId = dbo.AppPlanGetEntityValue(@planId, 'Feature',  default)
						AND permission.permissionName = 'DLP')
			BEGIN
UPDATE APP_ComponentProp SET longval = 1 WHERE propertytypeid = 3623 AND componentid = @clientGroupId AND modified = 0
				IF @@ROWCOUNT = 0
					INSERT INTO APP_ComponentProp (componenttype, componentid, propertytypeid,datatype,longval,longlongval,stringval,created,modified)
VALUES (8, @clientGroupId,  3623,8,1,0,N'', @currentTime, 0)
			END
        END
		-- update index copy schedule ----------------------------------------------------------------------------------------------------------------------------------------------------
        DECLARE @indexCopyScheduleId INT = (SELECT ref.value('@taskId', 'INT') AS id FROM @x_xmlData.nodes('Api_UpdatePlanReq/indexCopy/schedule/task') R ( ref ))
        IF @indexCopyScheduleId IS NOT NULL AND @indexCopyScheduleId>0
        BEGIN
EXEC AppPlanSetEntityValueV2 @planId, 'Index copy schedule policy', @indexCopyScheduleId, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (35, @errorCode, @errorString)
			DECLARE @rpoMinutesIndexCopy INT = 0
SELECT @rpoMinutesIndexCopy = dbo.AppPlanGetEntityValueV2(@planId, 'RPO In Minutes', default)
			-- Now set the Schedule policy level RPO interval
			EXEC AppPlanSetRPOInterval @planId, @planSubType, @rpoMinutesIndexCopy, 0/*DB Plan Log RPO*/,1 /*Index copy RPO*/,0, @errorCode OUTPUT, @errorString OUTPUT
			IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (154, @errorCode, @errorString) -- 154 : CONFIGURATION_POLICY_ENTITY
        END
		-- update backup copy schedule ----------------------------------------------------------------------------------------------------------------------------------------------------
        DECLARE @backupCopyScheduleId INT = (SELECT ref.value('@taskId', 'INT') AS id FROM @x_xmlData.nodes('Api_UpdatePlanReq/snapInfo/snapTask/task') R ( ref ))
        IF @backupCopyScheduleId IS NOT NULL AND @backupCopyScheduleId > 0
        BEGIN
EXEC AppPlanSetEntityValueV2 @planId, 'Backup copy schedule policy', @backupCopyScheduleId, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (35, @errorCode, @errorString)
        END
        END
		---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        -- Call SP to Update Addon status
		-- Below SP will update execution error table in case of any failure
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		EXEC AppPlanUpdateAddonV2 @i_userId, @i_localeId, @planId, @planName, @x_xmlData
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        -- update plan options
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        EXEC AppPlanUpdateOptionsV2 @i_userId, @i_localeId, @planId, @debug, @x_xmlData
		-- fetching plan properties
		EXEC AppPlanGetPlanComponentsV2 @planId
        -- -- SLA and default SLA flag if absent
        BEGIN -- primary
IF @planSubType = 33554439 -- as SLA Interval is only handled for smart client group and only laptop plan creates SCG
			BEGIN
				DECLARE @newSLA   INT = (SELECT ref.value('@slaInterval', 'INT') FROM @x_xmlData.nodes('Api_UpdatePlanReq/summary') R ( ref ))
DECLARE @oldSLA   INT = dbo.AppPlanGetEntityValueV2(@planId, 'SLA In Minutes', default)
				IF (@newSLA IS NOT NULL) AND (@newSLA != ISNULL(@oldSLA, 0)) BEGIN
					DECLARE @newSLAvarchar VARCHAR(32) = CAST(@newSLA AS VARCHAR)
EXEC AppPlanSetEntityValueV2 @planId, 'SLA In Minutes', @newSLAvarchar, @errorCode OUTPUT, @errorString OUTPUT
					IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (154, @errorCode, @errorString) -- 154 : CONFIGURATION_POLICY_ENTITY
SET @newSLA = dbo.AppPlanGetEntityValueV2(@planId, 'SLA In Minutes', default)
					-- Update SLA property on client group property
					IF @clientGroupId IS NOT NULL BEGIN
						UPDATE APP_componentProp
						SET longVal = @newSLA
where componentType = 8 and componentId =  @clientGroupId and propertyTypeId = 3300 and dataType = 8
						IF @@ROWCOUNT = 0 BEGIN
							 INSERT INTO APP_ComponentProp (componenttype, componentid, propertytypeid,datatype,longval,longlongval,stringval,created,modified)
VALUES (8, @clientGroupId,  3300,8,  @newSLA,0,  '',  @currentTime,0)
						END
					END
				END
			END
			DECLARE @newRPO INT
			DECLARE @newRPOvarchar NVARCHAR(32)
			-- If the new field isnt present then refer to old field slaInMinutes and check if thats provided. To support backward compatbility
DECLARE @SchedulePolicy INT = ISNULL((SELECT CAST(attrVal AS INT) FROM #PlanDetails_PlanProps WHERE attrName = 'Schedule policy' AND depth = 0), 0)
DECLARE @SchedulePolicyDepth INT = ISNULL((SELECT depth FROM #PlanDetails_PlanProps WHERE attrName = 'Schedule policy'), 0)
DECLARE @IndexSchedulePolicy INT = ISNULL((SELECT CAST(attrVal AS INT) FROM #PlanDetails_PlanProps WHERE attrName = 'Index copy schedule policy' AND depth = 0), 0)
DECLARE @IndexSchedulePolicyDepth INT = ISNULL((SELECT depth FROM #PlanDetails_PlanProps WHERE attrName = 'Index copy schedule policy'), 0)
			SET @newRPO = (SELECT ref.value('@rpoInMinutes', 'INT') FROM @x_xmlData.nodes('Api_UpdatePlanReq/summary') R ( ref ))
			IF (@newRPO IS NOT NULL)
			BEGIN
				SET @newRPOvarchar = CAST(@newRPO AS VARCHAR)
				IF (@SchedulePolicy > 0 AND @SchedulePolicyDepth = 0)
				BEGIN --  RPO
					-- Setting initial Plan level RPO property value
EXEC AppPlanSetEntityValueV2 @planId, 'RPO In Minutes', @newRPOvarchar, @errorCode OUTPUT, @errorString OUTPUT
					IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (35, @errorCode, @errorString) -- 35 : SCHEDULE_POLICY_ENTITY
					--For Server plan we handle modifying RPO via Task Manager ModifyTaskReq which takes care of this
					--Calling below code forces UI to add restrictions in RPO field
IF @planSubType NOT IN (33554437, 83886085, 83918853, 150994951, 50331653, 50331655, 33579013)
					BEGIN
						-- Now set the Schedule policy level RPO interval
						EXEC AppPlanSetRPOInterval @planId, @planSubType, @newRPO, 0/*Regular RPO*/, 0 /*Regular RPO*/,0, @errorCode OUTPUT, @errorString OUTPUT
						IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (35, @errorCode, @errorString) -- 35 : SCHEDULE_POLICY_ENTITY
					END
				END
			 	IF (@IndexSchedulePolicy > 0 AND @IndexSchedulePolicyDepth = 0)
				BEGIN --  Index Copy RPO
					-- Update index copy schedule policy RPO also if present.
					EXEC AppPlanSetRPOInterval @planId, @planSubType, @newRPO, 0, 1 /*Index copy RPO*/,0,@errorCode OUTPUT, @errorString OUTPUT
					IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (35, @errorCode, @errorString) -- 35 : SCHEDULE_POLICY_ENTITY
				END
				ELSE IF ((@IndexSchedulePolicy > 0 AND @IndexSchedulePolicyDepth > 0) OR (@SchedulePolicy > 0 AND @SchedulePolicyDepth > 0))
				BEGIN
					SET @errorCode = 1
					SET @errorString= 'RPO on this plan cannot be modified'
					INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (35, @errorCode, @errorString) -- 35 : SCHEDULE_POLICY_ENTITY
				END
			END
        END
DECLARE @logSchedulePolicyDB INT = ISNULL((SELECT CAST(attrVal AS INT) FROM #PlanDetails_PlanProps WHERE attrName = 'Log schedule policy' AND depth = 0), 0)
DECLARE @logSchedulePolicyDBdepth INT = ISNULL((SELECT depth FROM #PlanDetails_PlanProps WHERE attrName = 'Log schedule policy'), 0)
		DECLARE @newRPOLog   INT = (SELECT ref.value('@rpoInMinutes', 'INT') FROM @x_xmlData.nodes('Api_UpdatePlanReq/database') R ( ref ))
		IF (@newRPOLog IS NOT NULL)
		BEGIN
			DECLARE @newRPOLogvarchar VARCHAR(32) = CAST(@newRPOLog AS VARCHAR)
            IF (@logSchedulePolicyDB > 0 AND @logSchedulePolicyDBdepth = 0)
			BEGIN
				-- Setting initial Plan level RPO property value
EXEC AppPlanSetEntityValueV2 @planId, 'Log RPO In Minutes', @newRPOLogvarchar, @errorCode OUTPUT, @errorString OUTPUT
                IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (35, @errorCode, @errorString) -- 35 : SCHEDULE_POLICY_ENTITY
				-- Now set the Schedule policy level RPO interval
				EXEC AppPlanSetRPOInterval @planId, @planSubType, @newRPOLog, 1/*DB Plan Log RPO*/,0 /*Non index copy RPO*/,0, @errorCode OUTPUT, @errorString OUTPUT
				IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (35, @errorCode, @errorString) -- 35 : SCHEDULE_POLICY_ENTITY
            END
			ELSE IF (@logSchedulePolicyDB > 0 AND @logSchedulePolicyDBdepth > 0)
			BEGIN
				SET @errorCode = 1
				SET @errorString= 'RPO on this plan cannot be modified'
				INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (35, @errorCode, @errorString) -- 35 : SCHEDULE_POLICY_ENTITY
			END
		END
		--backup copy RPO
		DECLARE @newBcopyRPO   INT = (SELECT ref.value('@backupCopyRPO', 'INT') FROM @x_xmlData.nodes('Api_UpdatePlanReq/snapInfo') R ( ref ))
		IF (@newBcopyRPO IS NOT NULL)
		BEGIN
			DECLARE @newBcopyRPONV VARCHAR(32) = CAST(@newBcopyRPO AS VARCHAR(32))
DECLARE @backupCopySchedulePolicy INT = ISNULL((SELECT CAST(attrVal AS INT) FROM #PlanDetails_PlanProps WHERE attrName = 'Backup copy schedule policy' AND depth = 0), 0)
DECLARE @backupCopySchedulePolicyDepth INT = ISNULL((SELECT depth FROM #PlanDetails_PlanProps WHERE attrName = 'Backup copy schedule policy'), 0)
			IF (@backupCopySchedulePolicy > 0 AND @backupCopySchedulePolicyDepth = 0)
			BEGIN
				-- Setting initial Plan level RPO property value
EXEC AppPlanSetEntityValueV2 @planId, 'Backup copy RPO In Minutes', @newBcopyRPONV, @errorCode OUTPUT, @errorString OUTPUT
                IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (35, @errorCode, @errorString) -- 35 : SCHEDULE_POLICY_ENTITY
				-- Now set the Schedule policy level RPO interval
				EXEC AppPlanSetRPOInterval @planId, @planSubType, @newBcopyRPO, 0/*DB Plan Log RPO*/,0 /*Non index copy RPO*/,1/*backupCopy*/, @errorCode OUTPUT, @errorString OUTPUT
				IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (35, @errorCode, @errorString) -- 35 : SCHEDULE_POLICY_ENTITY
            END
			ELSE IF (@backupCopySchedulePolicy > 0 AND @backupCopySchedulePolicyDepth > 0)
			BEGIN
				SET @errorCode = 1
				SET @errorString= 'RPO on this plan cannot be modified'
				INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (35, @errorCode, @errorString) -- 35 : SCHEDULE_POLICY_ENTITY
			END
		END
		END
        IF ((@userHasCapabilityUpdate = 1) OR (@userHasCapabilityInvite = 1)) AND
(EXISTS(SELECT 1 FROM #AppPlanUpdate_tmp__Configuration WHERE [type] = @const_Required AND id = 16) AND NOT EXISTS(SELECT 1 FROM #AppPlanUpdate_tmp__Configuration WHERE [type] = @const_Forbidden AND id = 16)) BEGIN
			EXEC AppPlanUpdateUserOrUserGroupAssocV2 @i_userId, @adminUserId, @i_localeId, @planId, @planName, @x_xmlData, @debug
        END -- (@userHasCapabilityUpdate = 1) OR (@userHasCapabilityInvite = 1)
		---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        -- Call SP to Update Any entity creation failure reason
		-- Below SP will update execution error table in case of any failure
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		EXEC AppPlanUpdateFailureReasons @i_userId, @i_localeId, @planId, @planName, @x_xmlData
		-- calculate plan status
        BEGIN
            SET @idsStr = NULL
            SELECT @idsStr = COALESCE(@idsStr+ ',', '') + CAST(id AS VARCHAR) FROM #AppPlanUpdate_tmp__Configuration WHERE [type] = @const_Required ORDER BY id ASC
            EXEC AppPlanCalcUpdateStatusV2 @planId, @idsStr
            -- -- recalculate derived plan statuses.
            EXEC AppPlanCalcUpdateDescendentStatusV2 @planId
        END
        -- we are done
        IF @debug <> 0 BEGIN
            SELECT * FROM APP_Plan WHERE id = @planId
            SELECT * FROM APP_PlanProp WHERE componentNameId = @planId
            SELECT * FROM APP_NetworkThrottleOptions
            ROLLBACK TRANSACTION
        END
        ELSE BEGIN COMMIT TRANSACTION END
    END TRY
    BEGIN CATCH
        ROLLBACK TRANSACTION
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES(158, ERROR_NUMBER(), 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' + Convert(VARCHAR(5), ERROR_LINE()) + ']. ' + ERROR_MESSAGE())
    END CATCH
END
DECLARE @rv INT = (SELECT COUNT(__type__) FROM #AppPlanUpdate_tmp__ExecutionErrors)
-- if there were no errors so far then create 'success' entry
IF @rv = 0 BEGIN
INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES(158, 0, '')
END
-- build output
SET @x_xmlData =
(
    SELECT
        (SELECT
            (SELECT ER.__type__ AS '@__type__'
             FOR XML PATH('entity'), TYPE),
            (SELECT ER.errCode      AS '@errorCode',
                    ER.errMessage   AS '@errorMessage'
             FOR XML PATH('status'), TYPE)
         FROM #AppPlanUpdate_tmp__ExecutionErrors AS ER
         FOR XML PATH('error'), TYPE)
    FOR XML PATH('Api_PlanComponentErrorList')
)
IF (@debug = 0) AND (EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES  WHERE TABLE_NAME = 'App_PlanDebug')) BEGIN
    SET @debugStmnt = 'INSERT INTO App_PlanDebug([procedure],[parameter],[value]) VALUES(''AppPlanUpdate'', ''@x_xmlData'',''' +  CAST(@x_xmlData AS VARCHAR(MAX)) + ''')'
    EXEC sp_executesql @debugStmnt
END
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__UsersToBeDeassociated') IS NOT NULL DROP TABLE #AppPlanUpdate_tmp__UsersToBeDeassociated
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__UsersToBeReassociated') IS NOT NULL DROP TABLE #AppPlanUpdate_tmp__UsersToBeReassociated
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__Security_VisibleUsers')  IS NOT NULL DROP TABLE #AppPlanUpdate_tmp__Security_VisibleUsers
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__Security_VisibleUsersGroups')  IS NOT NULL DROP TABLE #AppPlanUpdate_tmp__Security_VisibleUsersGroups
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__SubclientUpdate') IS NOT NULL DROP TABLE #AppPlanUpdate_tmp__SubclientUpdate
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__Configuration')  IS NOT NULL DROP TABLE #AppPlanUpdate_tmp__Configuration
IF OBJECT_ID('tempdb.dbo.#PlanDetails_PlanProps')       IS NOT NULL DROP TABLE #PlanDetails_PlanProps
RETURN @rv
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanUpdateV2')
	delete from GxQscripts where name = 'AppPlanUpdateV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateV2')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateV2'
GO

insert into GXDBVersions values(2, 'AppPlanUpdateV2',  '00010001000200840000', 'AppPlanUpdateV2', '00010001000200840000')
GO

