

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanUpdateUserOrUserGroupAssocV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanUpdateUserOrUserGroupAssocV2.sp,v $ $Id: AppPlanUpdateUserOrUserGroupAssocV2.sp,v 1.1.2.10 2020/10/28 04:21:10 alakra Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppPlanUpdateUserOrUserGroupAssocV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanUpdateUserOrUserGroupAssocV2 <<<'
	drop procedure AppPlanUpdateUserOrUserGroupAssocV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanUpdateUserOrUserGroupAssocV2')
	delete from GxQscripts where name = 'AppPlanUpdateUserOrUserGroupAssocV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateUserOrUserGroupAssocV2')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateUserOrUserGroupAssocV2'
GO
print '... Creating Procedure: AppPlanUpdateUserOrUserGroupAssocV2'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppPlanUpdateUserOrUserGroupAssocV2
  @i_userId INT,
  @i_adminUserId INT,
  @i_localeId INT,
  @i_planId INT,
  @i_planName NVARCHAR(1024),
  @x_xmlData XML , 
  @i_debug INT
AS
    -- SET NOCOUNT ON added to prevent extra result sets from
    -- interfering with SELECT statements.
    SET NOCOUNT ON
    -- as the very first step make sure that this sp gets executed in context of App_PlanUpdateV2
    -- -- App_PlanUpdateV2 creates multiple temporary tables. two of them : #AppPlanUpdate_tmp__IdsSet and #AppPlanUpdate_tmp__ExecutionErrors will be used
    -- -- by this sp. verify their existence. There is no need to continue if they do not exist
    IF (OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__IdsSet') IS NULL)  OR (OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__ExecutionErrors') IS NULL)
        THROW 50001, 'Stored procedure must be executed in context of App_PlanUpdateV2', 1
    DECLARE @errorCode      INT = 0
    DECLARE @errorString    NVARCHAR(MAX) = NULL
    DECLARE @opType INT
    DECLARE @idsStr AS VARCHAR(MAX) = '';
    DECLARE @x_xmlGroupResp     XML
    DECLARE @currentTime INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
    DECLARE @iterator INT = 0;
    DECLARE @devnull TABLE (errCode INT, errMessage VARCHAR(256))
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    -- update users. this is for the plan only. derived plans will not be updated. only if entry is necessary
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    -- -- make sure that user group exists
    SET @x_xmlGroupResp = NULL
    DECLARE @userGroupId INT = NULL
    DECLARE @currentAssociation INT
    EXEC AppPlanEnsureUserGroupV2  @i_planId, @userGroupId OUTPUT, @x_xmlGroupResp OUTPUT
    INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors
	    SELECT  ref.value('(../entity/@__type__)[1]', 'INT'), ref.value('@errorCode', 'INT'), ref.value('@errorString', 'NVARCHAR(1024)')
	    FROM    @x_xmlGroupResp.nodes('Api_PlanComponentErrorList/error/status') R ( ref )
	    WHERE   ref.value('@errorCode', 'INT') != 0
SET @opType = (SELECT ISNULL(ref.value('@userOperationType', 'INT'), 0) AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/laptop/users') R ( ref ))
IF @opType != 0 BEGIN
	    -- get list of all users associated with the plan before any users/groups associations modifications.
	    -- it will be used later after all modifications are done to determine list of users which laptops should be deactivated
	    INSERT INTO #AppPlanUpdate_tmp__UsersToBeDeassociated
		    SELECT DISTINCT userId FROM UMUserGroup WHERE groupId IN (SELECT  CAST(attrVal AS INT)
																	    FROM    APP_PlanProp
																	    WHERE       componentNameId = @i_planId
AND attrName IN ('Assigned user group', 'Associated internal user group', 'Associated external user group'))
	    -- -- Remove cached alert recipient list since invitee list has changed below
	    DELETE  FROM NTNotificationProp
WHERE       attrName IN ('Recipient UserId', 'Recipient UserGroupId')
AND componentNameId IN (SELECT CAST(_ID AS INT) FROM dbo.SplitIDString(dbo.AppPlanGetEntityValueV2(@i_planId, 'Alert', default)))
	    -----------------------------------------------------------------------------------
	    -- Get User who have rights on the plan or which belong to actual associated entity
	    -- Get users that user has rights on
	    ------------------------------------------------------------------------------------
	    DECLARE @includeUsersFlags int = -1;
	    DECLARE @excludeUsersFlags int = 0;
SET @includeUsersFlags = ( CAST (0x001 AS INT) )
SET @excludeUsersFlags = ( CAST (0x200 AS INT) | CAST (0x004 AS INT) | CAST (0x080 AS INT) | CAST(0x100 AS INT) )
	    -- -- get visible Users
	    EXEC sec_getUsersForThisUser        '#AppPlanUpdate_tmp__Security_VisibleUsers',        @i_userId, 0, 3, @excludeUsersFlags, @includeUsersFlags
	    -- -- get Visible Users Groups
	    EXEC sec_getUserGroupsForThisUser   '#AppPlanUpdate_tmp__Security_VisibleUsersGroups',  @i_userId
	    DECLARE @groupsList NVARCHAR(MAX)
	    DECLARE @usersAdd   AS TABLE (id INT)
	    DECLARE @usersDel   AS TABLE (id INT)
	    DECLARE @usersReq   AS TABLE (id INT)
	    DECLARE @usersCur   AS TABLE (id INT)
	    DECLARE @groupsAdd  AS TABLE (id INT, providerId INT)
	    DECLARE @groupsDel  AS TABLE (id INT, providerId INT)
	    DECLARE @groupsReq  AS TABLE (id INT, providerId INT)
	    DECLARE @groupsCur  AS TABLE (id INT, providerId INT)
	    -- -- populate working tables users and groups existing in the request, users and groups currently associated with the plan
	    BEGIN
		    -- -- list of users listed in the request and available for the current user
		    INSERT INTO @usersReq
			    SELECT  ref.value('@userId', 'INT') AS id FROM @x_xmlData.nodes('Api_UpdatePlanReq/laptop/users/users/user') R ( ref )
			    INTERSECT
			    SELECT  userId AS id FROM #AppPlanUpdate_tmp__Security_VisibleUsers
		    IF @i_debug != 0  SELECT 'Request users', * FROM @usersReq
		    -- -- list of user groups listed in the request
		    INSERT INTO @groupsReq
			    SELECT  ref.value('@userGroupId', 'INT') AS id, 0 AS provider FROM @x_xmlData.nodes('Api_UpdatePlanReq/laptop/users/users/userGroup') R ( ref )
			    UNION
			    SELECT  ref.value('@groupId', 'INT') AS id, ref.value('@providerId', 'INT') AS provider FROM @x_xmlData.nodes('Api_UpdatePlanReq/laptop/users/users/externalUserGroup') R ( ref )
		    IF @i_debug != 0  SELECT 'Request groups', * FROM @groupsReq
		    -- -- remove user groups not available to the curent user and update missing provider ids
		    DELETE FROM @groupsReq WHERE id NOT IN(SELECT userGroupId AS id FROM #AppPlanUpdate_tmp__Security_VisibleUsersGroups)
		    UPDATE  @groupsReq
		    SET     A.providerId = B.umdsProviderId
		    FROM	@groupsReq A JOIN UMGroups B ON B.id = A.id
		    WHERE   providerId IS NULL
		    IF @i_debug != 0  SELECT 'Filtered request groups', * FROM @groupsReq
		    -- -- list of users currently associated with the plan and visible to curent user
		    INSERT INTO @usersCur
SELECT  DISTINCT userId FROM UMUserGroup WHERE groupId = dbo.AppPlanGetEntityValueV2(@i_planId, 'Assigned user group', default)
			    INTERSECT
			    SELECT  userId AS id FROM #AppPlanUpdate_tmp__Security_VisibleUsers
		    IF @i_debug != 0  SELECT 'Current users', * FROM @usersCur
		    -- -- list of groups currently associated with the plan
		    INSERT INTO @groupsCur
			    SELECT DISTINCT G.id, G.umdsProviderId
			    FROM App_PlanProp PP INNER JOIN UMGroups G ON G.id = CAST(PP.attrVal AS INT)
WHERE componentNameId = @i_planId AND attrName IN ('Associated internal user group', 'Associated external user group')
		    IF @i_debug != 0  SELECT 'Current groups', * FROM @groupsCur
		    -- -- remove user groups not available to the curent user
		    DELETE FROM @groupsCur WHERE id NOT IN(SELECT userGroupId AS id FROM #AppPlanUpdate_tmp__Security_VisibleUsersGroups)
		    IF @i_debug != 0  SELECT 'Filtered current groups', * FROM @groupsCur
	    END
	    -- -- depending on operation type populate @usersAdd, @usersDel, @groupsAdd and @groupsDel tables
	    BEGIN
IF @opType = 1 BEGIN
			    -- -- -- add users that exist in the request and currently not associated with the plan
			    INSERT INTO @usersAdd
				    SELECT id FROM @usersReq EXCEPT SELECT id FROM @usersCur
			    -- -- -- remove users that currently associated with the plan but do not exist in the request
			    INSERT INTO @usersDel
				    SELECT id FROM @usersCur EXCEPT SELECT id FROM @usersReq
			    -- -- -- add groups that exist in the request and currently not associated with the plan
			    INSERT INTO @groupsAdd
				    SELECT id, providerId FROM @groupsReq EXCEPT SELECT id, providerId FROM @groupsCur
			    -- -- -- remove users that currently associated with the plan but do not exist in the request
			    INSERT INTO @groupsDel
				    SELECT id, providerId FROM @groupsCur EXCEPT SELECT id, providerId FROM @groupsReq
END ELSE IF @opType = 2 BEGIN
			    -- -- -- add users that exist in the request and currently not associated with the plan
			    INSERT INTO @usersAdd
				    SELECT id FROM @usersReq EXCEPT SELECT id FROM @usersCur
			    -- -- -- add groups that exist in the request and currently not associated with the plan
			    INSERT INTO @groupsAdd
				    SELECT id, providerId FROM @groupsReq EXCEPT SELECT id, providerId FROM @groupsCur
END ELSE IF @opType = 3 BEGIN
			    -- -- -- remove users that exist in the request and currently assigned to the plan
			    INSERT INTO @usersDel
				    SELECT id FROM @usersCur INTERSECT SELECT id FROM @usersReq
			    -- remove groups that exist in the request and currently assigned to the plan
			    INSERT INTO @groupsDel
				    SELECT id, providerId FROM @groupsCur INTERSECT SELECT id, providerId FROM @groupsReq
END ELSE IF @opType = 4 BEGIN
			    -- remove all users and groups
			    INSERT INTO @usersDel SELECT id FROM @usersCur
			    INSERT INTO @groupsDel SELECT id, 0 FROM @groupsCur
		    END
	    END
	    -- -- add and remove users and groups based on the data stored in @usersAdd, @usersDel, @groupsAdd and @groupsDel tables
	    BEGIN
		    -- -- process users to be deassociated
		    BEGIN
			    IF @i_debug != 0 SELECT 'User to remove', * FROM @usersDel
			    -- -- -- delete user to plan associations
			    UPDATE  UMUsersProp SET modified = @currentTime
			    WHERE       componentNameId IN (SELECT id FROM @usersDel)
AND attrName = 'Associated Plan'
					    AND CAST(attrVal AS VARCHAR) = @i_planId
					    AND modified = 0
			    -- -- -- delete plan user to plan group associations
			    DELETE FROM UMUserGroup
			    WHERE       groupId = @userGroupId
					    AND userId IN (SELECT id FROM @usersDel)
		    END
		    -- -- process groups to be deassociated
		    BEGIN
			    IF @i_debug != 0 SELECT 'Group to remove', * FROM @groupsDel
			    -- -- -- delete group to plan association
			    UPDATE  UMGroupsProp SET modified = @currentTime
			    WHERE       componentNameId IN (SELECT id FROM @groupsDel)
AND attrName = 'Associated Plan'
					    AND CAST(attrVal AS VARCHAR) = @i_planId
					    AND modified = 0
			    -- -- -- remove plan specific user group properties
			    SET @groupsList  = NULL; SELECT @groupsList = COALESCE(@groupsList + ',', '') + CAST(id AS VARCHAR)FROM @groupsDel;
			    SET @x_xmlGroupResp=''
				IF @groupsList IS NOT NULL
				BEGIN
EXEC dbo.AppPlanUpdateUserGroupProp @i_userId, @i_localeId, @i_planId, 3, 0, 100, @groupsList, @x_xmlGroupResp OUTPUT
					INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors
						SELECT  ref.value('(../entity/@__type__)[1]', 'INT'), ref.value('@errorCode', 'INT'), ref.value('@errorString', 'NVARCHAR(1024)')
						FROM    @x_xmlGroupResp.nodes('Api_PlanComponentErrorList/error/status') R ( ref )
						WHERE   ref.value('@errorCode', 'INT') != 0
				END
			    -- -- -- delete plan to group association
			    DELETE  FROM App_PlanProp
			    WHERE       componentNameId = @i_planId
AND attrName IN ('Associated internal user group', 'Associated external user group')
					    AND CAST(attrVal AS INT) IN (SELECT id FROM @groupsDel)
		    END
		    ------------ User OR User Group Add Logic Start -------------
		    IF (EXISTS (SELECT 1 FROM @usersAdd) OR EXISTS (SELECT 1 FROM @groupsAdd))
		    BEGIN
			    -- Reset Error Code
			    SET @errorCode=0
			    DECLARE @xReactivation_1 XML = (SELECT  (SELECT id AS '@userId'      FROM @usersAdd  FOR XML PATH('users'),     TYPE),
													    (SELECT id AS '@userGroupId' FROM @groupsAdd FOR XML PATH('userGroup'), TYPE)
											    FOR XML PATH('App_LaptopActivatedByUserOrUserGroupReq'))
			    EXEC AppGetLaptopAssociatedToUserAndUserGroup @i_userId, @i_localeId, @xReactivation_1 OUTPUT, @errorCode OUTPUT, @errorString OUTPUT
			    IF @errorCode != 0
			    BEGIN
				    INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (12, @errorCode, @errorString)
			    END
			    ELSE
			    BEGIN
				    -- We will now check if provided plan is elastic plan or not
DECLARE @storageRules XML = dbo.AppPlanGetEntityValueV2(@i_planId, 'Storage Rules', default)
				    IF @storageRules.exist('//./rule') = 1
				    BEGIN
					    -- This is Elastic Plan request
					    -- So, we have to check if there are applicable laptops for migration and which don't have applicable region tagged
					    IF EXISTS (SELECT ref.value('(client/@clientId)[1]', 'INT') AS userId FROM @xReactivation_1.nodes('App_LaptopActivatedByUserOrUserGroupResp/laptopDetails') R ( ref ))
					    BEGIN
						    DECLARE @laptopClientId INT
						    DECLARE @laptopUserId INT
						    DECLARE @elasticStoragePolicyId INT = 0
						    DECLARE ClientInfoCursor CURSOR
						    FOR
						    SELECT  ref.value('(client/@clientId)[1]', 'INT') AS clientId,
								    ref.value('(user/@userId)[1]', 'INT') As userId
							    FROM    @xReactivation_1.nodes('App_LaptopActivatedByUserOrUserGroupResp/laptopDetails') R ( ref )
						    OPEN ClientInfoCursor
						    FETCH FROM ClientInfoCursor INTO @laptopClientId, @laptopUserId
						    WHILE @@FETCH_STATUS = 0
						    BEGIN
EXEC dbo.PlanRuleEvaluateStoragePolicyForEntityV2 @i_planId, @laptopClientId, 3, @laptopUserId, @i_localeId, 0, @elasticStoragePolicyId OUTPUT, @errorCode OUTPUT, @errorString OUTPUT
							    -- If for some reason we fail to fetch applicable region, then we should bail out.
							    -- No point in trying out migration
							    IF @errorCode != 0
							    BEGIN
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3864 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @i_localeId)
								    INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (12, @errorCode, @errorString)
								    BREAK
							    END
							    -- If there is no applicable Storage Policy, , then we should bail out.
							    -- No point in trying out migration
							    IF @elasticStoragePolicyId = 0
							    BEGIN
								    INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (12, @errorCode, @errorString)
								    BREAK
							    END
							    FETCH FROM ClientInfoCursor INTO @laptopClientId, @laptopUserId
						    END
						    CLOSE ClientInfoCursor
						    DEALLOCATE ClientInfoCursor
					    END
				    END
			    END
			    -- If we didn't get any for migration from above, then don't move user to plan. We will simply error out with correct error code.
			    IF @errorCode=0
			    BEGIN
				    -----  Start Process Users to be added  --------------------------
				    BEGIN
					    IF @i_debug != 0 SELECT 'User to add', * FROM @usersAdd
					    SELECT @iterator  = MIN(id) FROM @usersAdd
					    WHILE @iterator IS NOT NULL BEGIN
						    -- -- -- get current user association
SET @currentAssociation = (SELECT CAST(attrVal AS INT) FROM UMUsersProp WHERE componentNameId = @iterator AND attrName = 'Associated Plan' AND modified = 0)
						    -- -- -- if database contains information about association but associated plan been deleted or scheduled to be deleted
						    -- -- -- then remove association
IF (@currentAssociation IS NOT NULL) /* AND EXISTS(SELECT id FROM APP_Plan WHERE id = @currentAssociation AND ((flag & 0x00004 != 0) OR (flag & 0x40000000 != 0)))*/ BEGIN
UPDATE UMUsersProp SET modified = @currentTime WHERE componentNameId = @iterator AND attrName = 'Associated Plan' AND modified = 0
							    -- remove user from previous user group
DELETE FROM UMUserGroup WHERE userId = @iterator AND groupId = CAST(ISNULL(dbo.AppPlanGetEntityValue(@currentAssociation, 'Assigned user group', default), '0') AS INT)
							    SET @currentAssociation = NULL
						    END
						    -- -- -- if user is not associated with any plan
						    IF @currentAssociation IS NULL BEGIN
							    -- -- -- -- include user into newly created group.
							    -- -- -- -- -- existance check is necessary to avoid duplication that can happen if plan creation XML request contains multiple entries for the same user
							    IF NOT EXISTS (SELECT userId FROM UMUserGroup WHERE userId = @iterator AND groupId = @userGroupId) BEGIN
								    INSERT INTO UMUserGroup (userId, groupId, flag) VALUES(@iterator, @userGroupId, 0)
							    END
							    -- and also set user's property
							    INSERT INTO UMUsersProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@iterator, 'Associated Plan', 7, @i_planId, @currentTime, 0)
						    END ELSE IF @currentAssociation != @i_planId BEGIN -- user is associated with the plan other then @i_planId
							    -- From CvEntities.x : EntityType.UserEntity = 13, Windows system error code ERROR_ALREADY_EXISTS = 183
							    INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (13, 183, 'Unable to associate user ' + CAST(@iterator AS NVARCHAR) + ' with the plan due to existing association with plan ' + CAST(@currentAssociation AS NVARCHAR) + '.' )
						    END
						    SELECT @iterator = MIN(Id) FROM @usersAdd WHERE Id > @iterator
					    END
				    END
				    -----  Finish Process Users to be added  --------------------------
				    -----  Start Process Users Groups to be added  --------------------------
				    BEGIN
					    IF @i_debug != 0 SELECT 'Group to add', * FROM @groupsAdd
					    SELECT @iterator  = MIN(id) FROM @groupsAdd
					    WHILE @iterator IS NOT NULL BEGIN
						    DECLARE @newGroupProviderId INT = (SELECT providerId FROM @groupsAdd WHERE id = @iterator)
						    -- -- -- if group is associated with any other plan that it could not be associated with the new plan. verify current asscoiation
						    -- -- -- -- get current group association
SET @currentAssociation =(SELECT CAST(attrVal AS INT) FROM UMGroupsProp WHERE componentNameId = @iterator AND attrName = 'Associated Plan' AND modified = 0)
						    -- -- -- -- if database contains information about association but associated plan been deleted or scheduled to be deleted then remove the association
IF (@currentAssociation IS NOT NULL)/* AND EXISTS(SELECT id FROM APP_Plan WHERE id = @currentAssociation AND ((flag & 0x00004 != 0) OR (flag & 0x40000000 != 0))) */BEGIN
DELETE FROM APP_PlanProp WHERE attrval=CAST(@iterator AS NVARCHAR) AND attrName IN ('Associated internal user group', 'Associated external user group')
							    SET @x_xmlGroupResp= ''
							    -- We have to remove user from Edge Drive and previous rights also. New association will be added in next call.
EXEC dbo.AppPlanUpdateUserGroupProp @i_userId, @i_localeId, @i_planId, 3, 0, 100, @iterator, @x_xmlGroupResp OUTPUT
							    INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors
								    SELECT  ref.value('(../entity/@__type__)[1]', 'INT'), ref.value('@errorCode', 'INT'), ref.value('@errorString', 'NVARCHAR(1024)')
								    FROM    @x_xmlGroupResp.nodes('Api_PlanComponentErrorList/error/status') R ( ref )
								    WHERE   ref.value('@errorCode', 'INT') != 0
UPDATE UMGroupsProp SET modified = @currentTime WHERE componentNameId = @iterator AND attrName = 'Associated Plan' AND modified = 0
							    SET @currentAssociation = NULL
						    END
						    IF @currentAssociation IS NULL BEGIN -- if group is not associated with any plan
							    -- -- -- set plan property
IF NOT EXISTS (SELECT 1 FROM APP_PlanProp  WHERE componentNameId = @i_planId AND attrName =  IIF(@newGroupProviderId = 0, 'Associated internal user group', 'Associated external user group') AND RTRIM(LTRIM(attrVal)) = RTRIM(LTRIM(CAST(@iterator AS VARCHAR)))) BEGIN
								    INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@i_planId, IIF(@newGroupProviderId = 0, 'Associated internal user group', 'Associated external user group'),
IIF(@newGroupProviderId = 0, 7, 7), CAST(@iterator AS NVARCHAR), @currentTime, 0)
							    END
							    -- -- -- set user group property
							    INSERT INTO UMGroupsProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@iterator, 'Associated Plan', 7, @i_planId, @currentTime, 0)
							    SET @x_xmlGroupResp= ''
							    -- -- -- Set role mapping for install of smart client and update quota information for internal user group
DECLARE @quotaGroup   INT = ISNULL(dbo.AppPlanGetEntityValueV2(@i_planId, 'Quota', default), 0)
							    DECLARE @quotaEnforce INT = IIF(@quotaGroup = 0, 0, 1)
							    DECLARE @quotaValueA  INT = IIF(@quotaGroup = 0, 100, @quotaGroup)
EXEC dbo.AppPlanUpdateUserGroupProp @i_userId, @i_localeId, @i_planId, 2, @quotaEnforce, @quotaValueA, @iterator, @x_xmlGroupResp OUTPUT
							    INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors
								    SELECT  ref.value('(../entity/@__type__)[1]', 'INT'), ref.value('@errorCode', 'INT'), ref.value('@errorString', 'NVARCHAR(1024)')
								    FROM    @x_xmlGroupResp.nodes('Api_PlanComponentErrorList/error/status') R ( ref )
								    WHERE   ref.value('@errorCode', 'INT') != 0
						    END ELSE IF @currentAssociation != @i_planId BEGIN -- group is associated with the plan other then @i_planId
							    -- -- -- From CvEntities.x : EntityType.USERGROUP_ENTITY = 15, Windows system error code ERROR_ALREADY_EXISTS = 183
							    INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (15, 183, 'Unable to associate group ' + CAST(@iterator AS NVARCHAR) + ' with the plan due to existing association with plan ' + CAST(@currentAssociation AS NVARCHAR) + '.')
						    END
						    -- id of the next group to add
						    SELECT @iterator = MIN(Id) FROM @groupsAdd WHERE Id > @iterator
					    END
				    END
			    END
			    -----  Finish Process Users Groups to be added  --------------------------
				DECLARE @disableLaptopsMigration INT  = ISNULL((SELECT 1 FROM GXGlobalParam WHERE name='DisableLaptopPlanMigration' AND value='1'), 0)
			    -----  Start applicable Laptops  Migration--------------------------
                IF EXISTS (SELECT ref.value('(client/@clientId)[1]', 'INT') AS userId FROM @xReactivation_1.nodes('App_LaptopActivatedByUserOrUserGroupResp/laptopDetails') R ( ref )) AND (@errorCode=0) AND (@disableLaptopsMigration<>1)
			    BEGIN
				    DECLARE @xReactivation_2 XML = (SELECT (SELECT  (SELECT @i_planId  AS '@planId'   FOR XML PATH('newPlan'), TYPE),
																    (SELECT A.clientId AS '@clientId' FOR XML PATH('client'),  TYPE),
																    (SELECT A.userId   AS '@userId'   FOR XML PATH('user'),    TYPE)
														    FROM (SELECT ref.value('(user/@userId)[1]', 'INT') AS userId, ref.value('(client/@clientId)[1]', 'INT') AS clientId  FROM @xReactivation_1.nodes('App_LaptopActivatedByUserOrUserGroupResp/laptopDetails') R ( ref )) A
														    FOR XML PATH('laptopClientInfo'), TYPE)
												    FOR XML PATH('App_ReassociateLaptopClientRequest'))
				    EXEC AppPlanUpdateLaptopAssociation @i_userId, @i_localeId, @xReactivation_2 OUTPUT, @errorCode OUTPUT, @errorString OUTPUT
				    IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (12, @errorCode, @errorString)
			    END
		    END
	    END
	    ------------ User OR User Group Add Logic Finish -------------
	    ------------ Start deactivate laptops which were dissociated from the plan -------------
	    BEGIN
		    -- get list of all users associated with the plan after all users/groups associations modifications.
		    INSERT INTO #AppPlanUpdate_tmp__UsersToBeReassociated
			    SELECT DISTINCT userId FROM UMUserGroup WHERE groupId IN (SELECT  CAST(attrVal AS INT)
																		    FROM    APP_PlanProp
																		    WHERE       componentNameId = @i_planId
AND attrName IN ('Assigned user group', 'Associated internal user group', 'Associated external user group'))
		    -- reactivate all users that were added to the plan (if possible)
		    -- -- leave in the temporary table only those users which were deleted
		    -- -- at this point #AppPlanUpdate_tmp__UsersToBeReassociated contains list of users after  all user operations
		    -- --               #AppPlanUpdate_tmp__UsersToBeDeassociated contains list of users before all user operations
		    -- -- Whatever exists in AppPlanUpdate_tmp__UsersToBeReassociated and do not exists in AppPlanUpdate_tmp__UsersToBeReassociated
		    -- -- is what was added and should be reassociated
		    DELETE FROM #AppPlanUpdate_tmp__UsersToBeReassociated WHERE userId IN (SELECT userId FROM #AppPlanUpdate_tmp__UsersToBeDeassociated)
		    -- For below request , we will only reactivate laptops which were initially activated as Device Centric and not user centric
		    -- We can't reactivate user centric clients as we don't have physical machine id present with us at this point.
		    -- For Sp12 - we will figure out a way to keep old physical client id or something  for user centric client, so that we can honor the same here.
		    -- Also, we won't do any special handling for status or property Platform Deleted 4 here.
		    -- So, if we deactivate any client first, remove user from plan and add that user back to some plan, then
		    --	-- client will be activate back again but licenses won't be consumed. All other cases, we should be covered.
		    -- Above case will again be discussed in SP12 changes
		    DECLARE @clientsToProcess AS TABLE (id INT IDENTITY(1,1), userId INT, userName NVARCHAR(255), pseudoClientId INT, physicalClientId INT, displayClientName NVARCHAR(255), subclientId INT, subclientName NVARCHAR(255))
		    INSERT INTO @clientsToProcess (userId, userName, pseudoClientId, physicalClientId, displayClientName, subclientId, subclientName)
			    SELECT  OW.userId, UU.login , OW.clientId, OW.clientId, AC.displayName, AAP.id, AAP.subclientName
			    FROM    sec_getClientOwnersExpandUG OW WITH(NOLOCK)
INNER JOIN APP_ClientProp PROP WITH(NOLOCK) ON OW.clientId = PROP.componentNameId AND PROP.AttrName = 'Associated Plan' AND PROP.AttrVal=N'0' AND PROP.modified=0
INNER JOIN APP_Client AC WITH(NOLOCK) ON OW.clientId = AC.id AND AC.status&0x1000 = 0x1000 AND AC.specialClientFlags & 0x2=0
						INNER JOIN UMUsers UU WITH(NOLOCK) ON UU.id=OW.userId
						INNER JOIN APP_Application AAP WITH(NOLOCK)
ON AAP.clientId=AC.id AND AAP.subclientStatus&0x00008=0x00008
						INNER JOIN APP_AppTypeGroupAssoc ATGA WITH(NOLOCK)
							ON ATGA.appTypeId=AAP.appTypeId AND ATGA.appGroupId=35 AND ATGA.typeOfGroup=0
						INNER JOIN APP_BackupSetName BS WITH(NOLOCK)
ON BS.id=AAP.backupSet AND BS.status&0x00008=0x00008
LEFT OUTER JOIN APP_ClientProp ACP WITH(NOLOCK) ON OW.clientId = ACP.componentNameId AND ACP.AttrName = 'User Centric Client' AND ACP.AttrVal=N'1' AND ACP.modified=0
			    WHERE   OW.userId IN (SELECT userId FROM #AppPlanUpdate_tmp__UsersToBeReassociated U) AND ACP.componentNameId IS NULL
		    DECLARE @clientId INT = (SELECT MIN(id) FROM @clientsToProcess)
		    WHILE @clientId IS NOT NULL
		    BEGIN
			    DECLARE @localUserId    INT
				DECLARE @localuserName  NVARCHAR(255)
			    DECLARE @pseusdoClient  INT
			    DECLARE @physicalClient INT
			    DECLARE @displayName    NVARCHAR(255)
				DECLARE @subclientId		INT
				DECLARE @subclientName  NVARCHAR(255)
			    SELECT @localUserId = userId, @localuserName = userName, @pseusdoClient  = pseudoClientId, @physicalClient = physicalClientId, @displayName=displayClientName, @subclientId = subclientId, @subclientName = subclientName FROM @clientsToProcess WHERE id = @clientId
			    EXEC AppActivateLaptop @localUserId, @physicalClient, @physicalClient, @i_localeId, 0, 0 , @errorCode OUTPUT, @errorString OUTPUT
			    IF @errorCode != 0
			    BEGIN
				    INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (12, @errorCode, @errorString)
				    -- In case of failure, add this function to Pending Activation.
				    -- It is so because, users for such laptop have already been moved to new plan. We need to activate these laptops
IF @errorCode=(3877 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				    BEGIN
EXEC AppPlanDeferEntityAssociationSetV2 3, @physicalClient, 0, 0 /*userId*/, 1, 2 /*Add*/, 0/*do not result set*/
				    END
			    END
			    ELSE
			    BEGIN
				    -- Set the activated mode to 1 as for normal flow that is done by AppCheck
				    -- Since appactivatelaptop won't set it, we might end up in ambiguous situation
				    UPDATE App_ClientProp SET attrval = 1
WHERE attrname = 'Activated Mode'
				    AND componentNameId = @physicalClient AND modified=0
				    IF (@@ROWCOUNT = 0)
				    BEGIN
					    INSERT INTO App_ClientProp VALUES
					    --(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
(@physicalClient, 'Activated Mode', 7, 1, @currentTime, 0, 0)
				    END
				    -- Just send the refresh workqueue for feature list
				    -- Update feature list on client.
				    DECLARE @workQueueXML XML = ''
				    DECLARE @workQueueParam NVARCHAR(MAX) = ''
				    DECLARE @feature_DLP INT = 0
				    DECLARE @feature_EDGEDRIVE INT = 0
				    DECLARE @featureID INT  = 0
SET @featureID  = ISNULL(dbo.AppPlanGetEntityValueV2(@i_planId, 'Feature',  default), 0)
				    IF @featureID > 0
				    BEGIN
					    SELECT  @feature_DLP=1 FROM
							    UMRolesPermissions roleToPermissionMap WITH (NOLOCK)
					    INNER JOIN UMPermissions permission WITH (NOLOCK)
							    ON permission.id=roleToPermissionMap.permissionId AND permission.permissionName = 'DLP'
					    WHERE roleToPermissionMap.roleId = @featureID
					    SELECT  @feature_EDGEDRIVE=1 FROM
							    UMRolesPermissions roleToPermissionMap WITH (NOLOCK)
					    INNER JOIN UMPermissions permission WITH (NOLOCK)
							    ON permission.id=roleToPermissionMap.permissionId AND permission.permissionName = 'Edge Drive'
					    WHERE roleToPermissionMap.roleId = @featureID
					    IF ((@feature_DLP=1) OR (@feature_EDGEDRIVE=1))
					    BEGIN
						    DECLARE @activateResp NVARCHAR(1024) = '<App_ActivateClientResp activatedMode="1" needActivation="1">
																    <userCentricClient _type_="7" clientId="'+ CAST(@physicalClient AS NVARCHAR(64))+'" clientName="' + @displayName + '" displayName="' + @displayName + '" subclientId="'+ CAST(@subclientId AS NVARCHAR(64))+'" subclientName="' + @subclientName + '" type="0"/>
																    <user _type_="13" userId="'+ CAST(@localUserId AS NVARCHAR(64))+'" userName="'+ CAST(@localuserName AS NVARCHAR(64))+'" />
																    <physicalClient _type_="3" clientId="'+ CAST(@physicalClient AS NVARCHAR(64))+'" clientName="' + @displayName + '" type="0"/>
																    <associatedPlan>
																    <plan planId="'+ CAST (@i_planId AS NVARCHAR(64))+'"/>
																    <permissions permissionId="145" permissionName="Laptop"/>'
						    IF @feature_DLP=1
						    BEGIN
							    SET @activateResp = @activateResp + '<permissions permissionId="148" permissionName="DLP"/>'
						    END
						    IF @feature_EDGEDRIVE=1
						    BEGIN
							    SET @activateResp = @activateResp + '<permissions permissionId="146" permissionName="Edge Drive"/>'
						    END
						    SET @activateResp = @activateResp + '</associatedPlan></App_ActivateClientResp>'
						    -- If client have atleast 1 feature, then push the same to client
						    SET @workQueueXML = (   SELECT
										    (SELECT @activateResp AS '@activateClientResponse',	-- This value to suggest that mode of activation is device centric
											    ( SELECT '1' AS '@enable',  --SYNC_PAUSED
														    '7' AS '@featureType'-- Activation
														    FOR XML PATH('featureDetails'), TYPE
											    ),
											    ( SELECT CASE
												    WHEN @feature_EDGEDRIVE = 1 THEN
												    (  SELECT '1' AS '@enable',  --SYNC_PAUSED
														    '1' AS '@featureType'-- EDGE_DRIVE
														    FOR XML PATH('featureDetails'), TYPE
												    )
												    ELSE NULL
												    END
											    ),
											    ( SELECT CASE
													    WHEN @feature_DLP = 1 THEN
													    (  SELECT '1' AS '@enable',  --SYNC_PAUSED
															    '5' AS '@featureType'-- DLP
															    FOR XML PATH('featureDetails'), TYPE
													    )
													    ELSE NULL
													    END
												    ),
											    (
												    SELECT 'AllUsers' AS '@userName' FOR XML PATH('user'),TYPE
											    )
										    FOR XML PATH('userFeatureList'), TYPE)
										    FOR XML PATH('App_UpdateFeatureList'), TYPE
									    )
						    SET @workQueueParam = CAST(@workQueueXML AS NVARCHAR(MAX))
						    --Push token param on addition of new feature list
						    INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
						    SELECT @physicalClient, 28 /*WORK_TOKEN_FEATURE_LIST*/, @workQueueParam, @currentTime, 0, 0, 0, -1
					    END
				    END
			    END
			    SELECT @clientId = MIN(id) FROM @clientsToProcess WHERE id > @clientId
		    END
		    -- deactivate all users which were deleted from the plan
		    -- -- at this point #AppPlanUpdate_tmp__UsersToBeDeassociated contains list of users before all user operations
		    -- -- leave in the temporary table only those users which were deleted
		    DELETE FROM #AppPlanUpdate_tmp__UsersToBeDeassociated WHERE userId IN( SELECT  DISTINCT userId FROM UMUserGroup WHERE groupId IN (SELECT  CAST(attrVal AS INT)
																				    FROM    APP_PlanProp
																				    WHERE       componentNameId = @i_planId
AND attrName IN ('Assigned user group', 'Associated internal user group', 'Associated external user group')) )
		    -- deassociate users hardware
		    -- actually, errors here are not relevant.
		    -- AppDeactivateLaptopForUser selects error code and error message. These values should not be propagated as AppPlanUpdate output.
			    EXEC AppDeactivateLaptopForUser '#AppPlanUpdate_tmp__UsersToBeDeassociated', @i_adminUserId, @i_localeId
	    END
	    ------------ Start deactivate laptops which were dissociated from the plan -------------
    END
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanUpdateUserOrUserGroupAssocV2')
	delete from GxQscripts where name = 'AppPlanUpdateUserOrUserGroupAssocV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateUserOrUserGroupAssocV2')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateUserOrUserGroupAssocV2'
GO

insert into GXDBVersions values(2, 'AppPlanUpdateUserOrUserGroupAssocV2',  '00010001000200100000', 'AppPlanUpdateUserOrUserGroupAssocV2', '00010001000200100000')
GO

