

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanUpdateUserGroupProp.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppCompanySettingsSet()
--  | Description:  Allows for Add/Edit of company settings
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanUpdateUserGroupProp.sp,v $ $Id: AppPlanUpdateUserGroupProp.sp,v 1.1.2.16 2018/05/30 22:02:17 njain Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppPlanUpdateUserGroupProp <<<'

IF EXISTS (select * from sysobjects where name='AppPlanUpdateUserGroupProp')
	drop procedure AppPlanUpdateUserGroupProp
IF EXISTS (select * from GxQscripts where name='AppPlanUpdateUserGroupProp')
	delete from GxQscripts where name = 'AppPlanUpdateUserGroupProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateUserGroupProp')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateUserGroupProp'
GO
print '... Creating Procedure: AppPlanUpdateUserGroupProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanUpdateUserGroupProp
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_planId INTEGER,
  @i_userGroupOpType INTEGER,		-- 3 For Delete and 2 For Add
  @i_EnforceQuota INTEGER,
  @i_quotaLimitInGB INTEGER,
  @i_userGroupIDs NVARCHAR(MAX),	--	 COMMA SEPRATED GROUP IDS
  @x_xmlData XML OUTPUT 
AS
SET NOCOUNT ON
BEGIN TRY
DECLARE @xmlText                 XML
DECLARE @isExternalGroup         INT = 0
DECLARE @endIndex                INT = 0
DECLARE @startIndex              INT = 0
DECLARE @groupId                 INT = 0
DECLARE @installRoleId           INT = 0
DECLARE @userHasCapabilityUpdate INT = 0
DECLARE @userHasCapabilityInvite INT = 0
DECLARE @ownerId                 INT = 0
DECLARE @enforceEdgeDriveQuota	 INT = 0
DECLARE @edgeDriveQuotaLimitInGB INT = 100
DECLARE @errorTable              TABLE (errorCode INT, errorString NVARCHAR(MAX))
DECLARE @currentTime             INT = dbo.GetUnixTime (GetUTCdate())
DECLARE @adminUserId INT = (SELECT TOP 1 id FROM UMUsers WHERE flags & 0x040 <> 0)
EXEC sec_checkPermissionOnEntity @i_userId, 157, @userHasCapabilityUpdate OUTPUT, 158, @i_planId
EXEC sec_checkPermissionOnEntity @i_userId, 159, @userHasCapabilityInvite OUTPUT, 158, @i_planId
IF (@userHasCapabilityUpdate = 1) OR (@userHasCapabilityInvite = 1) OR (EXISTS (SELECT id FROM App_Plan WHERE id = @i_planId AND ownerId = @i_userId))
BEGIN
	IF @i_userGroupIDs IS NOT null AND @i_userGroupIDs <> '' BEGIN
SET @installRoleId = (SELECT id FROM UMRoles WHERE (flags & 64 <> 0) and name LIKE 'All Users Laptops')
	    DECLARE @userGroupId TABLE(_ID INT PRIMARY KEY)
        INSERT INTO @userGroupId
            SELECT DISTINCT _ID FROM dbo.SplitIDs(@i_userGroupIDs)
		--Need to recompute the quota information for the groups whose 'quota size' property is getting updated. Insert 'ReComputeQuota' property in UmUsersProp table for the modified users.
		DECLARE @inXml XML
		SET @inXml = (SELECT DISTINCT UG.userId as '@id'
						FROM UMUserGroup UG WITH(NOLOCK)
						JOIN @userGroupId D ON UG.groupId = D._ID
						FOR XML PATH ('userID'), ROOT('UserList')
					 )
		exec UpdateUserPropForQuota @inXml
		-- First update Quota Mapping for the provided User Groups
		MERGE   UMGroupsProp AS TGT
		USING   (SELECT _ID FROM @userGroupId) AS SRC
		ON      TGT.componentNameId = SRC._ID and TGT.attrName = 'Enforce quota' AND TGT.attrType = 7
		WHEN    MATCHED THEN        UPDATE SET TGT.attrVal = @i_EnforceQuota
		WHEN    NOT MATCHED THEN    INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
				                        VALUES(SRC._ID, 'Enforce quota', 7, @i_EnforceQuota, @currentTime, 0);
		DECLARE @newEnforceFSQuotaValue INT = @i_EnforceQuota
-- Update global quota check flag
-- Based on this JM and other subsystems decide whether or not to do a quota check.
DECLARE @newDoQuotaCheck INT = CASE WHEN @newEnforceFSQuotaValue > 0 THEN 1
									ELSE ISNULL((
												SELECT TOP 1 1
												FROM UMUsersProp WITH(NOLOCK)
												WHERE attrName = N'Enforce quota' AND cs_attrName = CHECKSUM(N'Enforce quota')
												AND modified = 0
												AND attrVal = '1'
												UNION
												SELECT TOP 1 1
												FROM UMGroupsProp WITH(NOLOCK)
												WHERE attrName = N'Enforce quota' AND cs_attrName = CHECKSUM(N'Enforce quota')
												AND modified = 0
												AND attrVal = '1'), 0)
									END
DECLARE @oldDoQuotaCheck INT = (SELECT CAST(value AS INT) FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'DoFSQuotaCheck' AND modified = 0)
DECLARE @quotaSetTime INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
-- Insert only if it gets enabled
IF @oldDoQuotaCheck IS NULL AND @newDoQuotaCheck = 1
BEGIN
	INSERT INTO GXGlobalParam(name, value, created, modified)
	VALUES('DoFSQuotaCheck', @newDoQuotaCheck, @quotaSetTime, 0)
END
ELSE IF @oldDoQuotaCheck <> @newDoQuotaCheck
BEGIN
	UPDATE GXGlobalParam
	SET value = @newDoQuotaCheck
	WHERE name = 'DoFSQuotaCheck'
	AND modified = 0
END
--
		MERGE   UMGroupsProp AS TGT
		USING   (SELECT _ID FROM @userGroupId) AS SRC
		ON      TGT.componentNameId = SRC._ID and TGT.attrName = 'Quota size' AND TGT.attrType = 7
		WHEN    MATCHED     THEN    UPDATE SET TGT.attrVal = @i_quotaLimitInGB
		WHEN    NOT MATCHED THEN    INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
			                            VALUES(SRC._ID, 'Quota size', 7, @i_quotaLimitInGB, @currentTime, 0);
		--added for edge drive quota. Did not want to modify the SP signature.
IF @i_userGroupOpType != 3 BEGIN
SELECT @edgeDriveQuotaLimitInGB = ISNULL(dbo.AppPlanGetEntityValue(@i_planId, 'Edge Drive Quota Size', default), 0)
			IF @edgeDriveQuotaLimitInGB > 0 SET @enforceEdgeDriveQuota = 1;
		END
		MERGE   UMGroupsProp AS TGT
		USING   (SELECT _ID FROM @userGroupId) AS SRC
ON      TGT.componentNameId = SRC._ID and TGT.attrName = 'Enforce Edge Drive Quota' AND TGT.attrType = 7
		WHEN    MATCHED THEN        UPDATE SET  TGT.attrVal = @enforceEdgeDriveQuota
		WHEN    NOT MATCHED THEN    INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(SRC._ID, 'Enforce Edge Drive Quota', 7, @enforceEdgeDriveQuota, @currentTime, 0);
		MERGE   UMGroupsProp AS TGT
		USING   (SELECT _ID FROM @userGroupId) AS SRC
ON      TGT.componentNameId = SRC._ID and TGT.attrName = 'Edge Drive Quota Size' AND TGT.attrType = 7
		WHEN    MATCHED     THEN    UPDATE SET TGT.attrVal = @edgeDriveQuotaLimitInGB
		WHEN    NOT MATCHED THEN    INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(SRC._ID, 'Edge Drive Quota Size', 7, @edgeDriveQuotaLimitInGB, @currentTime, 0);
		-- START update for Associations. It will be a loop
		SET @i_userGroupIDs = @i_userGroupIDs + ',';
		SET @endIndex = CHARINDEX(',', @i_userGroupIDs, @startIndex)
		-- For Install rights, get the owner ID
		SET @ownerId = ISNULL((SELECT TOP 1 ownerId FROM App_Plan APP INNER JOIN UMUsers UU ON UU.id=APP.ownerId AND UU.enabled<>0 AND UU.flags <> 0
							   WHERE APP.id=@i_planId), 1)
		-- Loop for Associating/Disassociating Entities
		WHILE(@endIndex IS NOT null AND @endIndex <> 0)
		BEGIN
			SET @groupId = CAST(SUBSTRING(@i_userGroupIDs, @startIndex, @endIndex - @startIndex) AS INT)
			if(@groupId > 0)
			BEGIN
				-- We have our Group ID here
				SET @xmlText = (SELECT @i_userGroupOpType AS '@associationsOperationType',
											(SELECT
												(SELECT
(SELECT 3 AS '@_type_',
														(SELECT 1 AS '@includeAll' FOR XML PATH('flags'),TYPE)
													FOR XML PATH('entity'),TYPE)
												FOR XML PATH('entities'),TYPE),
											(SELECT
												(SELECT @installRoleId AS '@roleId' FOR XML PATH('role'),TYPE)
											FOR XML PATH('properties'),TYPE)
										FOR XML PATH('associations'),TYPE)
									FOR XML PATH('App_SecurityAssociationForUserOrGroupList'),TYPE)
					INSERT INTO @errorTable EXEC sec_setSecurityAssociationsFromUserOrUserGroup @xmlText, @adminUserId, 0, @groupId, 0
					IF NOT EXISTS (SELECT TOP 1 errorCode FROM @errorTable where errorCode <> 0)
					BEGIN
						DELETE FROM @errorTable
					END
			END
			-- Process for Next Group
			SET @startIndex = @endIndex + 1
			SET @endIndex = CHARINDEX(',', @i_userGroupIDs, @startIndex)
		END
        -- If edge drive role is enabled
DECLARE @assocEdgeDriveClient INT = dbo.AppPlanGetEntityValueV2(@i_planId, 'Assgined Edge Drive', default)
DECLARE @featureRole INT = dbo.AppPlanGetEntityValueV2(@i_planId, 'Feature', default)
        -- 146 is constant : select id FROM UMPermissions WHERE permissionName = 'Edge Drive'
        IF EXISTS(SELECT 1 FROM UMRolesPermissions WHERE roleId = @featureRole AND permissionId = 146) AND @assocEdgeDriveClient > 0
		BEGIN
			DECLARE @edgeDriveAssocXML XML
			DECLARE @associationEntity XML
			DECLARE @localGroupTbl           TABLE (localGroupId INT PRIMARY KEY, capabilities BIGINT)
			DECLARE @externalGroupTbl        TABLE (externalGroupName NVARCHAR(255) , providerId INT, capabilities BIGINT)
			DECLARE @edgeDriveClientPropsTbl TABLE(assocData xml)
 --
			INSERT INTO @localGroupTbl
			    SELECT UG.id, 549755818032
			    FROM (SELECT data FROM dbo.SplitString(@i_userGroupIDs,',')) GID
			    INNER JOIN UMGroups UG ON UG.id = GID.Data AND UG.umdsProviderId = 0
--
			INSERT INTO @externalGroupTbl
			    SELECT UG.name,UG.umdsProviderId,549755818032
			    FROM (SELECT data FROM dbo.SplitString(@i_userGroupIDs,',')) GID
			    INNER JOIN UMGroups UG ON UG.id = GID.Data AND UG.umdsProviderId > 0
			INSERT INTO @edgeDriveClientPropsTbl
			    EXEC dbo.AppGetEdgeDriveClientAssoc @associationEntity
			SELECT  @associationEntity = assocData FROM @edgeDriveClientPropsTbl
			DECLARE @indexServerId INTEGER = ISNULL((SELECT  ref.value('@clientId', 'integer')
						FROM @associationEntity.nodes('edgeDriveAssociations/indexServer') R ( ref )),0)
			DECLARE @indexServerName NVARCHAR(1024) = ISNULL((SELECT  ref.value('@clientName', 'NVARCHAR(1024)')
						FROM @associationEntity.nodes('edgeDriveAssociations/indexServer') R ( ref )),'')
			DECLARE @storagPolicyId INTEGER = ISNULL((SELECT  ref.value('@storagePolicyId', 'integer')
						FROM @associationEntity.nodes('edgeDriveAssociations/storagePolicy') R ( ref )),0)
			DECLARE @storagPolicyName NVARCHAR(1024) = ISNULL((SELECT  ref.value('@storagePolicyName', 'NVARCHAR(1024)')
						FROM    @associationEntity.nodes('edgeDriveAssociations/storagePolicy') R ( ref )),'')
			SET @edgeDriveAssocXML = (SELECT @i_userGroupOpType AS '@opType',
											(SELECT
												(SELECT @assocEdgeDriveClient AS '@clientId' FOR XML PATH('clientEntity'),TYPE),
												(SELECT 3 AS '@_type_', @indexServerId AS '@clientId', @indexServerName AS '@clientName' FOR XML PATH('indexServer'),TYPE),
												(SELECT 16 AS '@_type_', @storagPolicyId AS '@storagePolicyId', @storagPolicyName AS '@storagePolicyName' FOR XML PATH('storagePolicy'),TYPE),
												(SELECT(SELECT capabilities AS '@capabilities'  ,
												(SELECT localGroupId AS '@userGroupId' FOR XML PATH ('group'),TYPE)
												FROM @localGroupTbl FOR XML PATH('userGroupCapabilities'),TYPE)),
											(SELECT
												(SELECT capabilities AS '@capabilities' ,
												(SELECT externalGroupName AS '@name', providerId AS '@umdsProviderId' FOR XML PATH('externalGroup'),TYPE)
											FROM @externalGroupTbl FOR XML PATH('externalGroupCapabilities'),TYPE))
										FOR XML PATH('edgeDriveAssociations'),TYPE)
									FOR XML PATH('App_EdgeDrivePseudoClientProperties'),TYPE)
--
			INSERT INTO @errorTable (errorCode, errorString)
			    EXEC AppSetEdgeDriveAndGroupsAssoc @i_userGroupOpType, @edgeDriveAssocXML
--
		END
	END
END
ELSE
BEGIN
    INSERT INTO @errorTable VALUES (5, N'Access denied.')
END
IF NOT EXISTS (SELECT TOP 1 errorCode FROM @errorTable where errorCode <> 0)
BEGIN
	INSERT INTO @errorTable VALUES (0, '')
END
-- build output
SET @x_xmlData =(SELECT
					(SELECT
						(SELECT 15 AS '@__type__'
								FOR XML PATH('entity'), TYPE),
						(SELECT ER.errorCode      AS '@errorCode',
								ER.errorString   AS '@errorString'
							FOR XML PATH('status'), TYPE)
						FROM @errorTable AS ER
						FOR XML PATH('error'), TYPE)
					FOR XML PATH('Api_PlanComponentErrorList')
				)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @x_xmlData =(SELECT
						(SELECT
							(SELECT 15 AS '@__type__'
									FOR XML PATH('entity'), TYPE),
							(SELECT ERROR_NUMBER()    AS '@errorCode',
									'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()   AS '@errorString'
								FOR XML PATH('status'), TYPE)
							FOR XML PATH('error'), TYPE)
						FOR XML PATH('Api_PlanComponentErrorList')
					)
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanUpdateUserGroupProp')
	delete from GxQscripts where name = 'AppPlanUpdateUserGroupProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateUserGroupProp')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateUserGroupProp'
GO

insert into GXDBVersions values(2, 'AppPlanUpdateUserGroupProp',  '00010001000200160000', 'AppPlanUpdateUserGroupProp', '00010001000200160000')
GO

