

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanUpdateSubclientStoragePropsV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanUpdateSubclientStoragePropsV2.sp,v $ $Id: AppPlanUpdateSubclientStoragePropsV2.sp,v 1.1.2.2 2018/12/21 18:37:55 evolohov Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanUpdateSubclientStoragePropsV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanUpdateSubclientStoragePropsV2 <<<'
	drop procedure AppPlanUpdateSubclientStoragePropsV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanUpdateSubclientStoragePropsV2')
	delete from GxQscripts where name = 'AppPlanUpdateSubclientStoragePropsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateSubclientStoragePropsV2')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateSubclientStoragePropsV2'
GO
print '... Creating Procedure: AppPlanUpdateSubclientStoragePropsV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanUpdateSubclientStoragePropsV2
  @i_userId INT,
  @i_localeId INT,
  @x_xmlData XML OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdateSubclientStoragePropsV2_tmp__AffectedSubclients') IS NOT NULL DROP TABLE #AppPlanUpdateSubclientStoragePropsV2_tmp__AffectedSubclients
CREATE TABLE AppPlanUpdateSubclientStoragePropsV2_tmp__AffectedSubclients(subclientId INT PRIMARY KEY)
SET NOCOUNT ON
-- plan for which stored procedure is called. can be set as id or as guid
DECLARE @planId             INT = ISNULL((SELECT ref.value('@planId', 'INT') FROM @x_xmlData.nodes ('Api_UpdatePlanSubclientsStoragePropsReq/plan') R(ref)),
                                         (SELECT id FROM APP_Plan WITH(NOLOCK) WHERE [GUID] = (SELECT ref.value('@GUID', 'VARCHAR(64)') FROM @x_xmlData.nodes ('Api_UpdatePlanSubclientsStoragePropsReq/plan') R(ref))))
DECLARE @retentionDays      INT = NULL
DECLARE @syncFullVersions   INT = NULL
DECLARE @logStoragePolicy 	INT = NULL
SELECT  @retentionDays    = ref.value('@retentionDays',    'INT'),
        @syncFullVersions = ref.value('@syncFullVersions', 'INT'),
        @logStoragePolicy = ref.value('@logStoragePolicy', 'INT')
FROM    @x_xmlData.nodes ('Api_UpdatePlanSubclientsStoragePropsReq') R(ref)
DECLARE @errorCode         INT = 0
DECLARE @errorMessage      NVARCHAR(MAX) = ''
DECLARE @currentTime       INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
DECLARE @userHasCapability INT = 0
DECLARE @planSubtype       BIGINT = ISNULL((SELECT subType FROM App_Plan WHERE (id = @planId)), 0)
DECLARE @isUserAdmin       INT = IIF(EXISTS(SELECT 1 FROM UMUsers WHERE (id = @i_userId) AND (flags & 0x040 != 0)), 1, 0)
DECLARE @debug             INT = 0
DECLARE @CONST_RETENTION   VARCHAR(40) = 'Days to keep items past their expiration'
IF @planSubtype = 0 BEGIN
    SET @errorCode    = IIF(@isUserAdmin = 1, 2, 5)
    SET @errorMessage = ISNULL(
                               (SELECT  [Message]
                                FROM    EvLocaleMsgs WITH(NOLOCK)
                                WHERE       (LocaleId = @i_localeId)
AND (MessageID = IIF(@errorCode = 2, (3442 | (CAST(POWER(2, 24) AS BIGINT) * 35)), (3440 | (CAST(POWER(2, 24) AS BIGINT) * 35))))),
                                -- default value
                                IIF(@errorCode = 2, 'Not found', 'Access denied'))
END
-- to check if user has rights to modify plan
IF @errorCode = 0 BEGIN
    EXEC sec_checkPermissionOnEntity @i_userId, 157, @userHasCapability OUTPUT, 158, @planId
    IF (@userHasCapability = 0) AND (NOT EXISTS (SELECT id FROM App_Plan WITH(NOLOCK) WHERE id = @planId AND ownerId = @i_userId)) BEGIN
        SET @errorCode = 5
        SET @errorMessage = ISNULL(
                                   (SELECT  [Message]
                                    FROM    EvLocaleMsgs WITH(NOLOCK)
                                    WHERE       (LocaleId = @i_localeId)
AND (MessageID = (3440 | (CAST(POWER(2, 24) AS BIGINT) * 35)))),
                                    -- default value
                                    'Access denied')
    END
END
IF @errorCode = 0
BEGIN
    BEGIN TRANSACTION
    BEGIN TRY
DECLARE @storagePolicyId INT =  dbo.AppPlanGetEntityValueV2(@planId, IIF(@logStoragePolicy = 0, 'Storage policy', 'Log storage policy'), default)
        INSERT INTO #AppPlanUpdateSubclientStoragePropsV2_tmp__AffectedSubclients
            SELECT SC.id FROM APP_Application SC WITH(NOLOCK) INNER JOIN  APP_ClientProp CLPROP WITH(NOLOCK) ON SC.clientId = CLPROP.componentNameId
WHERE (SC.subclientStatus & 8) != 0 AND (CLPROP.attrType = 10) AND (CLPROP.attrName IN ('Associated Plan Id', 'Associated Plan')) AND attrVal = CAST(@planId AS VARCHAR(20)) AND (CLPROP.modified = 0)
        IF @retentionDays IS NOT NULL
        BEGIN -- update App_PlanProp table
EXEC AppPlanSetEntityValueV2 @planId, 'Subclient retention period', @retentionDays, @errorCode OUTPUT, @errorMessage OUTPUT
IF (@planSubtype & 2) != 0
            BEGIN -- update APP_SubClientProp table
                -- -- mark current values as obsolete
                UPDATE  APP_SubClientProp
                SET     modified = @currentTime
                WHERE       (modified = 0)
                        AND (attrName = @CONST_RETENTION)
                        AND (componentNameId IN (SELECT subclientId FROM #AppPlanUpdateSubclientStoragePropsV2_tmp__AffectedSubclients))
                -- -- insert new set of values
                INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
                    SELECT  subclientId, @CONST_RETENTION, 7, @retentionDays, @currentTime, 0
                    FROM    #AppPlanUpdateSubclientStoragePropsV2_tmp__AffectedSubclients
            END
            ELSE
            BEGIN
                UPDATE archAgingRule SET retentionDays = @retentionDays WHERE (retentionDays != @retentionDays) AND (copyId IN (SELECT defaultCopy FROM archGroup WHERE id = @storagePolicyId))
            END
        END
        IF @syncFullVersions IS NOT NULL
        BEGIN
            -- update App_PlanProp table
EXEC AppPlanSetEntityValueV2  @planId, 'Number of synth full versions', @syncFullVersions, @errorCode OUTPUT, @errorMessage OUTPUT
IF (@planSubtype & 2) != 0 BEGIN
                -- update APP_SubClientProp table
                -- -- mark current values as obsolete
                UPDATE  APP_SubClientProp
                SET     modified = @currentTime
                WHERE       (modified = 0)
                        AND (attrType = 7)
AND (attrName = 'Number of synth full versions')
                        AND (componentNameId IN (SELECT subclientId FROM #AppPlanUpdateSubclientStoragePropsV2_tmp__AffectedSubclients))
                -- -- insert new set of values
                INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
SELECT  subclientId, 'Number of synth full versions', 7, @syncFullVersions, @currentTime, 0
                    FROM    #AppPlanUpdateSubclientStoragePropsV2_tmp__AffectedSubclients
            END
        END
        IF @debug !> 0
        BEGIN
            SELECT * FROM APP_Plan WHERE id = @planId
            SELECT * FROM APP_PlanProp WHERE componentNameId = @planId
            ROLLBACK TRANSACTION
        END
        ELSE
        BEGIN
            COMMIT TRANSACTION
        END
    END TRY
    BEGIN CATCH
        ROLLBACK TRANSACTION
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
        SET @errorCode = ERROR_NUMBER()
        SET @errorMessage = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' + Convert(VARCHAR(5), ERROR_LINE()) + ']. ' + ERROR_MESSAGE()
    END CATCH
END
SET @x_xmlData = (SELECT @errorCode '@errorCode', @errorMessage '@errorMessage' FOR XML PATH('Api_GenericResp'))
SELECT @x_xmlData
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdateSubclientStoragePropsV2_tmp__AffectedSubclients') IS NOT NULL DROP TABLE #AppPlanUpdateSubclientStoragePropsV2_tmp__AffectedSubclients
RETURN @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanUpdateSubclientStoragePropsV2')
	delete from GxQscripts where name = 'AppPlanUpdateSubclientStoragePropsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateSubclientStoragePropsV2')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateSubclientStoragePropsV2'
GO

insert into GXDBVersions values(2, 'AppPlanUpdateSubclientStoragePropsV2',  '00010001000200020000', 'AppPlanUpdateSubclientStoragePropsV2', '00010001000200020000')
GO

