

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanUpdateStoragePolicyV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanUpdateStoragePolicyV2.sp,v $ $Id: AppPlanUpdateStoragePolicyV2.sp,v 1.1.2.2 2018/03/27 08:58:13 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppPlanUpdateStoragePolicyV2 <<<'

IF EXISTS (select * from sysobjects where name='AppPlanUpdateStoragePolicyV2')
	drop procedure AppPlanUpdateStoragePolicyV2
IF EXISTS (select * from GxQscripts where name='AppPlanUpdateStoragePolicyV2')
	delete from GxQscripts where name = 'AppPlanUpdateStoragePolicyV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateStoragePolicyV2')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateStoragePolicyV2'
GO
print '... Creating Procedure: AppPlanUpdateStoragePolicyV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanUpdateStoragePolicyV2
  @i_planId INT,
  @i_libraryId INT,
  @i_retentionDays INT,
  @i_versionsNum INT,
  @i_logStoragePolicy INT,
  @i_userId INT,
  @o_xmlText XML OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
DECLARE @debug INT = 0
DECLARE @errorCode INT = 0
DECLARE @errorMessage NVARCHAR(MAX) = ''
DECLARE @currentTime     INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
DECLARE @userHasCapability INT = 0
DECLARE @affectedSubclients TABLE (subclientId INT)
DECLARE @useLogStoragePolicy INT = ISNULL(@i_logStoragePolicy, 0)
DECLARE @planSubtype BIGINT = ISNULL((SELECT subType FROM App_Plan WHERE (id = @i_planId)), 0)
IF @planSubtype = 0 BEGIN
    SET @errorCode = 2
    SET @errorMessage = N'Plan not found.'
END
-- to check if user has rights to mofify plan
IF @errorCode = 0 BEGIN
    EXEC sec_checkPermissionOnEntity @i_userId, 157, @userHasCapability OUTPUT, 158, @i_planId
    IF (@userHasCapability = 0) AND (NOT EXISTS (SELECT id FROM App_Plan WHERE id = @i_planId AND ownerId = @i_userId)) BEGIN
        SET @errorCode = 5
        SET @errorMessage = N'Access denied.'
    END
END
IF @errorCode = 0 BEGIN
        BEGIN TRY
        BEGIN TRANSACTION
DECLARE @storagePolicyId INT =  dbo.AppPlanGetEntityValue(@i_planId, IIF(@useLogStoragePolicy = 0, 'Storage policy', 'Log storage policy'), default)
        INSERT INTO @affectedSubclients
            SELECT SC.id FROM APP_Application SC INNER JOIN  APP_ClientProp CLPROP ON SC.clientId = CLPROP.componentNameId
            WHERE (SC.subclientStatus & 8) != 0 AND (CLPROP.attrType = 10) AND (CLPROP.attrName = 'Associated Plan Id') AND attrVal = CAST(@i_planId AS varchar(32)) AND (CLPROP.modified = 0)
        IF @i_retentionDays IS NOT NULL
        BEGIN
            -- update App_PlanProp table
EXEC AppPlanSetEntityValueV2 @i_planId, 'Subclient retention period', @i_retentionDays, @errorCode OUTPUT, @errorMessage OUTPUT
IF (@planSubtype & 2) != 0  BEGIN
                -- update APP_SubClientProp table
                -- -- mark current values as obsolete
                UPDATE APP_SubClientProp SET modified = @currentTime WHERE (modified = 0) AND (attrName = 'Days to keep items past their expiration')
                AND (componentNameId IN (SELECT subclientId FROM @affectedSubclients))
                -- -- insert new set of values
                INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
                    SELECT  subclientId, 'Days to keep items past their expiration', 7, @i_retentionDays, @currentTime, 0
                    FROM    @affectedSubclients
            END
            ELSE
            BEGIN
                UPDATE archAgingRule SET retentionDays = @i_retentionDays WHERE copyId IN (SELECT defaultCopy FROM archGroup WHERE id = @storagePolicyId)
            END
        END
        IF @i_versionsNum IS NOT NULL
        BEGIN
            -- update App_PlanProp table
EXEC AppPlanSetEntityValueV2  @i_planId, 'Number of synth full versions', @i_versionsNum, @errorCode OUTPUT, @errorMessage OUTPUT
IF (@planSubtype & 2) != 0 BEGIN
                -- update APP_SubClientProp table
                -- -- mark current values as obsolete
UPDATE APP_SubClientProp SET modified = @currentTime WHERE (modified = 0) AND (attrType = 7) AND (attrName = 'Number of synth full versions') AND (componentNameId IN (SELECT subclientId FROM @affectedSubclients))
                -- -- insert new set of values
                INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
SELECT  subclientId, 'Number of synth full versions', 7, @i_versionsNum, @currentTime, 0
                    FROM    @affectedSubclients
            END
        END
        IF @debug <> 0 BEGIN
            SELECT * FROM APP_Plan WHERE id = @i_planId
            SELECT * FROM APP_PlanProp WHERE componentNameId = @i_planId
            ROLLBACK TRANSACTION
        END
        ELSE BEGIN COMMIT TRANSACTION END
    END TRY
    BEGIN CATCH
        ROLLBACK TRANSACTION
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
        SET @errorCode = ERROR_NUMBER()
        SET @errorMessage = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' + Convert(VARCHAR(5), ERROR_LINE()) + ']. ' + ERROR_MESSAGE()
    END CATCH
END
SET @o_xmlText = (SELECT @errorCode '@errorCode', @errorMessage '@errorMessage' FOR XML PATH('Api_GenericResp'))
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanUpdateStoragePolicyV2')
	delete from GxQscripts where name = 'AppPlanUpdateStoragePolicyV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateStoragePolicyV2')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateStoragePolicyV2'
GO

insert into GXDBVersions values(2, 'AppPlanUpdateStoragePolicyV2',  '00010001000200020000', 'AppPlanUpdateStoragePolicyV2', '00010001000200020000')
GO

