

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanUpdateSnapShotOptions.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--
-- Copyright (c) 1998  CommVault Systems, Inc. All rights reserved.
--
--
-- This is unpublished proprietary source code of CommVault Systems, Inc.  The  copyright  notice  above  does  not  evidence any actual or
-- intended publication of such source code.
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanUpdateSnapShotOptions.sp,v $ $Id: AppPlanUpdateSnapShotOptions.sp,v 1.1.2.1 2020/08/27 20:29:45 rengu Exp $";
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--  Fetches all the storage policies associated to this plan and updates backup copy property on them
--
--      @i_planId   INT             plan id
--
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--  Expected to be called when enabling or disabling snap addon.
-- BEGIN
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanUpdateSnapShotOptions')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanUpdateSnapShotOptions <<<'
	drop procedure AppPlanUpdateSnapShotOptions
END
IF EXISTS (select * from GxQscripts where name='AppPlanUpdateSnapShotOptions')
	delete from GxQscripts where name = 'AppPlanUpdateSnapShotOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateSnapShotOptions')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateSnapShotOptions'
GO
print '... Creating Procedure: AppPlanUpdateSnapShotOptions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanUpdateSnapShotOptions
  @i_planId INTEGER,
  @i_enable INTEGER,
  @o_errorCode INT OUTPUT,
  @o_errorString nvarchar(max) OUTPUT
AS
SET NOCOUNT ON
DECLARE @rv     INT = 0
IF OBJECT_ID('tempdb.dbo.#Plan_Storage_Rule') IS NOT NULL
		DROP TABLE #Plan_Storage_Rule
	CREATE TABLE #Plan_Storage_Rule(storagePolicyId INT , ruleId INT PRIMARY KEY, rank INT)
BEGIN
	BEGIN TRY
DECLARE @planRuleXML XML = dbo.AppPlanGetEntityValueV2(@i_planId, 'Storage Rules', 2/*need to fetch for this plan*/)
DECLARE @storagePolicyId  INT = dbo.AppPlanGetEntityValueV2(@i_planId, 'Storage policy', 2/*need to fetch for this plan*/)
		IF (@planRuleXML IS NULL AND (@storagePolicyId IS NULL OR @storagePolicyId = 0))
			return @rv
		INSERT INTO #Plan_Storage_Rule(ruleId , rank )
		SELECT
			ISNULL(( ref.value('(rule/@ruleId)[1]', 'INT')), 0),
			ISNULL(( ref.value('@rank', 'INT')), 0)
		FROM @planRuleXML.nodes ('Api_PlanRuleMaps/rules') R(ref)
		UPDATE
		PLR
		SET PLR.storagePolicyId = PL.storagePolicyId
		FROM #Plan_Storage_Rule PLR
		INNER JOIN App_PlanRule PL WITH(NOLOCK) ON PL.ruleId = PLR.ruleId
		IF NOT EXISTS(SELECT 1 FROM #Plan_Storage_Rule)
		BEGIN
		 INSERT INTO #Plan_Storage_Rule(storagePolicyId,ruleId,rank)
		 SELECT @storagePolicyId, 0, 1
		END
		UPDATE AMS
		SET AMS.enabled = @i_enable
		FROM ArchMaterializeSnapshotProp AMS WITH(NOLOCK)
		INNER JOIN #Plan_Storage_Rule PSR ON PSR.storagePolicyId = AMS.archGroupId
	END TRY
	BEGIN CATCH
		ROLLBACK TRANSACTION
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @o_errorCode = @@ERROR
		SET @o_errorString = 'Failure updating Snapshot options on planId:'+@i_planId
	END CATCH
END
IF OBJECT_ID('tempdb.dbo.#Plan_Storage_Rule') IS NOT NULL
	DROP TABLE #Plan_Storage_Rule
RETURN @rv
GO
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--  END
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

IF EXISTS (select * from GxQscripts where name = 'AppPlanUpdateSnapShotOptions')
	delete from GxQscripts where name = 'AppPlanUpdateSnapShotOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateSnapShotOptions')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateSnapShotOptions'
GO

insert into GXDBVersions values(2, 'AppPlanUpdateSnapShotOptions',  '00010001000200010000', 'AppPlanUpdateSnapShotOptions', '00010001000200010000')
GO

