

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanUpdateScheduleAssociations.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanUpdateScheduleAssociations.sp,v $ $Id: AppPlanUpdateScheduleAssociations.sp,v 1.1.2.1.4.1 2021/01/16 02:13:26 gpattabiraman Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   Creates or recreates schedule associations to plan
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppPlanUpdateScheduleAssociations')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanUpdateScheduleAssociations <<<'
	drop procedure AppPlanUpdateScheduleAssociations
END
IF EXISTS (select * from GxQscripts where name='AppPlanUpdateScheduleAssociations')
	delete from GxQscripts where name = 'AppPlanUpdateScheduleAssociations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateScheduleAssociations')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateScheduleAssociations'
GO
print '... Creating Procedure: AppPlanUpdateScheduleAssociations'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppPlanUpdateScheduleAssociations
  @i_planId INTEGER,
  @o_errorCode INTEGER       OUTPUT,
  @o_errorMsg VARCHAR(MAX)  OUTPUT
AS
SET NOCOUNT ON
    DECLARE @currentTime     INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
    SET @o_errorCode = 0; SET @o_errorMsg  = '';
	IF OBJECT_ID('tempdb.dbo.#AllPlanIds')       IS NOT NULL DROP TABLE #AllPlanIds
	CREATE TABLE #AllPlanIds(planId INT, schedulePolicyId INT , logSchedulePolicyId INT)
	-- Operation 1 - Data Policy insert, 2 - Log Policy insert, 3 - Removed assoc
	IF OBJECT_ID('tempdb.dbo.#affectedPlans')       IS NOT NULL DROP TABLE #affectedPlans
	CREATE TABLE #affectedPlans(planId INT, taskId INT, operation INT, hasOSC INT)
BEGIN
	BEGIN TRY
		-- Get list of all derived plans
		;WITH T(planId, basePlanId) AS
		(
			SELECT  P.id, CAST(PP.attrVal AS INT)
			FROM    APP_Plan P WITH(NOLOCK)
INNER JOIN APP_PlanProp PP WITH(NOLOCK) ON PP.attrName = 'Base plan' AND  attrVal = CAST(@i_planId AS VARCHAR) AND PP.componentNameId = P.id
			UNION ALL
			SELECT  PP.componentNameId, T.planId
FROM    APP_PlanProp PP WITH(NOLOCK) INNER JOIN T ON PP.attrVal = CAST(T.planId AS VARCHAR) AND attrName = 'Base plan'
													INNER JOIN APP_Plan P WITH(NOLOCK) ON P.id = PP.componentNameId
		)
		INSERT INTO #AllPlanIds
		SELECT DISTINCT planId, 0, 0 FROM T
		--Insert the current plan to be associated
		INSERT INTO #AllPlanIds VALUES (@i_planId, 0, 0)
		UPDATE P
SET schedulePolicyId = CAST(ISNULL(dbo.AppPlanGetEntityValueV2(planId, 'Schedule policy', default), '0') AS INT),
logSchedulePolicyId = CAST(ISNULL(dbo.AppPlanGetEntityValueV2(planId, 'Log schedule policy', default), '0') AS INT)
		FROM #AllPlanIds P
		--Insert into TM_AssocEntity if not present for data schedule policy
		INSERT INTO TM_AssocEntity  (assocType,         taskId,         flags,      created,        exclude,
										clientGroupId,     clientId,       apptypeId,  instanceId,     backupsetId,
										subclientId,       policyId,       copyId,     srmReportSet,   srmReportType,
										trackingPolicyId,  MediaAgentId,   agentlessPolicyId, workflowId, sidbStoreId,
										libraryId, logMonitoringPolicyId,entityId
									)
		OUTPUT  INSERTED.entityId, INSERTED.taskId, 1, 0 INTO #affectedPlans
SELECT	158, schedulePolicyId, 0, @currentTime, 0,
				0, 0, 0, 0, 0,
				0, 0, 0, 0, 0,
				0, 0, 0, 0, 0,
				0, 0, P.planId
		FROM #AllPlanIds P
LEFT JOIN TM_AssocEntity AE ON AE.assocType = 158 AND AE.entityId = P.planId AND AE.taskId = P.schedulePolicyId
		WHERE AE.assocId IS NULL
		--Insert into TM_AssocEntity if not present for data schedule policy
		INSERT INTO TM_AssocEntity  (assocType,         taskId,         flags,      created,        exclude,
										clientGroupId,     clientId,       apptypeId,  instanceId,     backupsetId,
										subclientId,       policyId,       copyId,     srmReportSet,   srmReportType,
										trackingPolicyId,  MediaAgentId,   agentlessPolicyId, workflowId, sidbStoreId,
										libraryId, logMonitoringPolicyId,entityId
									)
		OUTPUT  INSERTED.entityId, INSERTED.taskId, 2, 0 INTO #affectedPlans
SELECT	158, logSchedulePolicyId, 0, @currentTime, 0,
				0, 0, 0, 0, 0,
				0, 0, 0, 0, 0,
				0, 0, 0, 0, 0,
				0, 0, P.planId
		FROM #AllPlanIds P
LEFT JOIN TM_AssocEntity AE ON AE.assocType = 158 AND AE.entityId = P.planId AND AE.taskId = P.logSchedulePolicyId
		WHERE AE.assocId IS NULL
		-- If base plan schedule policy is enforced at a later point after creation of schedule policies in derived plan, then the existing associations
		-- have to be removed.
		DELETE AE
		OUTPUT DELETED.entityId, DELETED.taskId, 3, 0 INTO #affectedPlans
		FROM TM_AssocEntity AE
INNER JOIN #AllPlanIds P ON P.planId = AE.entityId AND AE.assocType = 158
		AND AE.taskId NOT IN(schedulePolicyId, logSchedulePolicyId)
		-- Do Audit - TODO
		-- Figure out if tasks have OSC schedule
		-- Logic from TM_DoesTaskHaveOscSchedule.sp
		UPDATE AP
		SET hasOSC = 1
		FROM #affectedPlans AP
		INNER JOIN TM_Task TA WITH (NOLOCK) ON AP.taskId = TA.taskId
		INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = TA.taskId
		INNER JOIN TM_PatternAssoc PA WITH (NOLOCK) ON PA.subTaskId = SA.subTaskId
INNER JOIN TM_Pattern P WITH (NOLOCK) ON P.patternId = PA.patternId AND P.freq_type=1024
LEFT JOIN TM_SubTaskOptions SO ON SO.subTaskId = SA.subTaskId AND SO.optionId = 458405394 AND SO.value = '4' -- BACKUP_LEVEL_SYNTHETIC_FULL = 4
		WHERE SO.subTaskId IS NULL -- We want to filter automatic synthetic full schedules.
		AND TA.[deleted] = 0
		AND TA.[invalid] = 0
		AND TA.[uninstalled] = 0
		AND TA.[savedReport] = 0
		AND TA.[disabled] = 0
		-- Need to send workqueue for all plans that has OSC schedule
		IF EXISTS(SELECT 1 FROM #affectedPlans WHERE hasOSC = 1)
		BEGIN
			DECLARE @xmlForWQ XML = NULL
			DECLARE @WQResponse TABLE(xmlResponse XML)
			-- push work tokens for OSC
			SET @xmlForWQ = ( SELECT 4 '@workToken', -- OSC Work token
								(
									SELECT DISTINCT APP.clientId '@clientId' -- OSC Work token
									FROM #affectedPlans WQP
									JOIN App_SubclientProp SP
ON SP.attrName = 'Associated Plan' AND SP.cs_attrname = CHECKSUM(N'Associated Plan') AND SP.modified = 0 AND SP.attrVal = CAST(WQP.planId AS NVARCHAR(32))
									JOIN App_Application APP ON SP.componentNameId = APP.id
									WHERE hasOSC = 1
									FOR XML PATH('entityList'), TYPE
								)
								FOR XML PATH('App_SubmitWorkQueueReq')
							)
			IF @xmlForWQ IS NOT NULL
			BEGIN
				INSERT INTO @WQResponse
				EXEC AppWorkQueueSubmitRequestXML @xmlForWQ
			END
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @o_errorCode = ERROR_NUMBER()
		SET @o_errorMsg = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' + Convert(VARCHAR(5), ERROR_LINE()) + ']. ' + ERROR_MESSAGE()
	END CATCH
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanUpdateScheduleAssociations')
	delete from GxQscripts where name = 'AppPlanUpdateScheduleAssociations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateScheduleAssociations')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateScheduleAssociations'
GO

insert into GXDBVersions values(2, 'AppPlanUpdateScheduleAssociations',  'v1.1.2.1.4.1', 'AppPlanUpdateScheduleAssociations', 'v1.1.2.1.4.1')
GO

