

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanUpdateRetentions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanUpdateRetentions.sp,v $ $Id: AppPlanUpdateRetentions.sp,v 1.1.2.5 2018/03/27 09:04:48 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppPlanUpdateRetentions <<<'

IF EXISTS (select * from sysobjects where name='AppPlanUpdateRetentions')
	drop procedure AppPlanUpdateRetentions
IF EXISTS (select * from GxQscripts where name='AppPlanUpdateRetentions')
	delete from GxQscripts where name = 'AppPlanUpdateRetentions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateRetentions')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateRetentions'
GO
print '... Creating Procedure: AppPlanUpdateRetentions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanUpdateRetentions
  @i_planId INT,
  @i_userId INT,
  @i_xmlInput XML,
  @o_xmlResult XML OUTPUT 
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
DECLARE @constForLogStorage VARCHAR(32) = 'updateLogStorage'
DECLARE @debug INT = 0
DECLARE @errorCode INT = 0
DECLARE @errorMessage NVARCHAR(MAX) = ''
DECLARE @currentTime     INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
DECLARE @const_PRIMARY_RETENTION_IN_DAYS        VARCHAR(32) = 'PrimaryRetentionInDays'
DECLARE @const_SECONDARY_RETENTION_IN_DAYS      VARCHAR(32) = 'SecondaryRetentionInDays'
DECLARE @const_BACKUP_COPY_RETENTION_IN_DAYS    VARCHAR(32) = 'BackupCopyRetentionInDays'
DECLARE @const_SNAP_RECOVERY_POINTS             VARCHAR(32) = 'SnapRecoveryPoints'
DECLARE @const_VERSION_RETENTION                VARCHAR(32) = 'numVersionRetention'
DECLARE @const_LAPTOP_PLAN_SUBTYPEVALUE         INT = 33554439 -- Api.x : PlanSubtype.Laptop
-- later we will need plans tyap and subtype. also use the variable to determine existence of the plan with provided id
DECLARE @planSubtype BIGINT = 0
DECLARE @planType    INT    = 0
SELECT @planType = [type], @planSubtype = subType FROM App_Plan WHERE id = @i_planId
-- debug
IF (EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES  WHERE TABLE_NAME = 'App_PlanDebug')) BEGIN
    DECLARE @debugStmnt AS NVARCHAR(MAX) = 'INSERT INTO App_PlanDebug([procedure],[parameter],[value]) VALUES(''AppPlanUpdateRetentions'', ''@i_xmlInput'',''' +  CAST(@i_xmlInput AS VARCHAR(MAX)) + ''')'
    EXEC sp_executesql @debugStmnt
END
IF @planSubtype = 0 BEGIN
    SET @errorCode = 2; SET @errorMessage = N'Plan not found.'
END
-- to check if user has rights to mofify plan
IF @errorCode = 0 BEGIN
    DECLARE @userHasCapability INT = 0
    EXEC sec_checkPermissionOnEntity @i_userId, 157, @userHasCapability OUTPUT, 158, @i_planId
    IF (@userHasCapability = 0) AND (NOT EXISTS (SELECT 1 FROM App_Plan WHERE id = @i_planId AND ownerId = @i_userId)) BEGIN
        SET @errorCode = 5; SET @errorMessage = N'Access denied.'
    END
END
-- continue to update retention periods if there was no errors so far
IF @errorCode = 0 BEGIN
    BEGIN TRY
        BEGIN TRANSACTION
        -- get into temporary table name value pairs sent by frontend
        DECLARE  @retentionValues TABLE (name VARCHAR(MAX), value INT)
        INSERT INTO @retentionValues
            SELECT ref.value('@name', 'NVARCHAR(MAX)'), ref.value('@value', 'INT') FROM @i_xmlInput.nodes('App_NameValueMaps/nameValues') R ( ref )
        IF @debug != 0 SELECT 'retention values copies', * FROM @retentionValues
        -- flag that indicates which storage policy to use
        DECLARE @useLogStoragePolicy BIT = CASE WHEN EXISTS(SELECT 1 FROM @retentionValues WHERE LOWER(name) = LOWER(@constForLogStorage)) THEN 1 ELSE 0 END
        DECLARE @storagePolicyId INT =  (SELECT CAST(attrVal AS int)
										 FROM	App_PlanProp
										 WHERE		componentNameId = @i_planId
AND ((@useLogStoragePolicy = 0 AND attrName = 'Storage policy') OR
(@useLogStoragePolicy = 1 AND attrName = 'Log storage policy')))
        IF @debug != 0 SELECT 'storage policy id', @storagePolicyId
        -- get into temporary table all affected subclients
        DECLARE  @affectedSubclients TABLE (subclientId INT)
        INSERT INTO @affectedSubclients
            SELECT  SC.id
            FROM    APP_Application SC INNER JOIN  APP_ClientProp CLPROP ON SC.clientId = CLPROP.componentNameId
            WHERE       (SC.subclientStatus & 8) != 0
                    AND (CLPROP.attrType = 10)
AND (CLPROP.attrName='Associated Plan')
                    AND attrVal = CAST(@i_planId AS varchar(32)) AND (CLPROP.modified = 0)
        IF @debug != 0 SELECT 'affected subclients', * FROM @affectedSubclients
        -- get into temprary table all copies to be updated
        DECLARE @affectedCopies TABLE(copyId INT, primaryCopy BIT, snapCopy BIT)
        INSERT INTO @affectedCopies
            SELECT  CP.id, CASE WHEN SP.defaultCopy = CP.id THEN 1 ELSE 0 END, CASE WHEN SP.defaultSnapCopy = CP.id THEN 1 ELSE 0 END
            FROM    archGroup SP WITH(NOLOCK) INNER JOIN archGroupCopy CP WITH(NOLOCK) ON CP.archGroupId = SP.id
            WHERE   SP.id = @storagePolicyId
        IF @debug != 0 SELECT 'affected copies', * FROM @affectedCopies
        DECLARE @value INT = NULL
        IF @planType != 4 BEGIN -- all plans but snap type
            -- processing 'PrimaryRetentionInDays'
            SET @value = (SELECT value FROM @retentionValues WHERE name = @const_PRIMARY_RETENTION_IN_DAYS)
            IF @value IS NOT NULL BEGIN
                MERGE   App_PlanProp AS TGT
                USING   (SELECT @i_planId) AS SRC(componentNameId)
ON      TGT.componentNameId = @i_planId AND TGT.attrName = 'Subclient retention period'
                WHEN    MATCHED     THEN UPDATE SET TGT.attrVal  = CAST(@value AS NVARCHAR(32))
WHEN    NOT MATCHED THEN INSERT VALUES (SRC.componentNameId, 'Subclient retention period', 279, CAST(@value AS NVARCHAR(32)), @currentTime, 0);
                -- update App_PlanProp table for laptop plan
                IF @planSubtype = @const_LAPTOP_PLAN_SUBTYPEVALUE BEGIN
                    -- update APP_SubClientProp table
                    -- -- mark current values as obsolete
                    UPDATE  APP_SubClientProp SET modified = @currentTime
                    WHERE       (modified = 0)
                            AND (attrName = 'Days to keep items past their expiration')
                            AND (componentNameId IN (SELECT subclientId FROM @affectedSubclients))
                    -- -- insert new set of values
                    INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
                        SELECT  subclientId, 'Days to keep items past their expiration', 7, @value, @currentTime, 0
                        FROM    @affectedSubclients
                END ELSE  BEGIN
                    UPDATE archAgingRule SET retentionDays = @value WHERE copyId IN (SELECT copyId FROM @affectedCopies WHERE primaryCopy = 1)
                END
            END
            -- processing 'SecondaryRetentionInDays'
            SET @value = (SELECT value FROM @retentionValues WHERE name = @const_SECONDARY_RETENTION_IN_DAYS)
            IF @value IS NOT NULL BEGIN
                UPDATE archAgingRule SET retentionDays = @value WHERE copyId IN (SELECT copyId FROM @affectedCopies WHERE primaryCopy = 0)
            END
        END ELSE BEGIN -- SNAP plans
            SET @value = (SELECT value FROM @retentionValues WHERE name = @const_BACKUP_COPY_RETENTION_IN_DAYS)
            IF @value IS NOT NULL BEGIN
                UPDATE archAgingRule SET retentionDays = @value WHERE copyId IN (SELECT copyId FROM @affectedCopies WHERE primaryCopy = 1)
            END
            SET @value = (SELECT value FROM @retentionValues WHERE name = @const_SNAP_RECOVERY_POINTS)
            IF @value IS NOT NULL BEGIN
                UPDATE archAgingRule SET retentionJobs = @value WHERE copyId IN (SELECT copyId FROM @affectedCopies WHERE snapCopy = 1)
            END
        END
        SET @value = (SELECT value FROM @retentionValues WHERE name = @const_VERSION_RETENTION)
        IF @value IS NOT NULL BEGIN
            -- update App_PlanProp table
            MERGE   App_PlanProp AS TGT
            USING   (SELECT @i_planId) AS SRC(componentNameId)
ON      TGT.componentNameId = @i_planId AND TGT.attrName = 'Number of synth full versions'
            WHEN    MATCHED     THEN UPDATE SET TGT.attrVal  = CAST(@value AS NVARCHAR(32))
WHEN    NOT MATCHED THEN INSERT VALUES (SRC.componentNameId, 'Number of synth full versions', 280, CAST(@value AS NVARCHAR(32)), @currentTime, 0);
IF ((@planSubtype & 2) != 0) OR ((@planSubtype & 256) != 0) OR ((@planSubtype & 512) != 0) OR ((@planSubtype & 1024) != 0) BEGIN
                -- update APP_SubClientProp table
                -- -- mark current values as obsolete
UPDATE APP_SubClientProp SET modified = @currentTime WHERE (modified = 0) AND (attrType = 7) AND (attrName = 'Number of synth full versions') AND (componentNameId IN (SELECT subclientId FROM @affectedSubclients))
                -- -- insert new set of values
                INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
SELECT  subclientId, 'Number of synth full versions', 7, @value, @currentTime, 0
                    FROM    @affectedSubclients
            END
        END
        IF @debug <> 0 BEGIN
            SELECT * FROM APP_Plan WHERE id = @i_planId
            SELECT * FROM APP_PlanProp WHERE componentNameId = @i_planId
            ROLLBACK TRANSACTION
        END ELSE BEGIN
            COMMIT TRANSACTION
        END
    END TRY
    BEGIN CATCH
        ROLLBACK TRANSACTION
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
        SET @errorCode = ERROR_NUMBER()
        SET @errorMessage = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' + Convert(VARCHAR(5), ERROR_LINE()) + ']. ' + ERROR_MESSAGE()
    END CATCH
END
-- create response/return message
SET @o_xmlResult = (SELECT @errorCode '@errorCode', @errorMessage '@errorMessage' FOR XML PATH('Api_GenericResp'))
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanUpdateRetentions')
	delete from GxQscripts where name = 'AppPlanUpdateRetentions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateRetentions')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateRetentions'
GO

insert into GXDBVersions values(2, 'AppPlanUpdateRetentions',  '00010001000200050000', 'AppPlanUpdateRetentions', '00010001000200050000')
GO

