

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanUpdateRestrictionsV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanUpdateRestrictionsV2.sp,v $ $Id: AppPlanUpdateRestrictionsV2.sp,v 1.1.2.5 2020/02/13 00:28:06 evolohov Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanUpdateRestrictionsV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanUpdateRestrictionsV2 <<<'
	drop procedure AppPlanUpdateRestrictionsV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanUpdateRestrictionsV2')
	delete from GxQscripts where name = 'AppPlanUpdateRestrictionsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateRestrictionsV2')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateRestrictionsV2'
GO
print '... Creating Procedure: AppPlanUpdateRestrictionsV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanUpdateRestrictionsV2
  @i_userId INT,
  @i_localeId INT,
  @i_planId INT,
  @i_debug INT,
  @x_xmlData XML
AS
    -- as the very first step make sure that this sp gets executed in context of App_PlanUpdateV2
    -- -- App_PlanUpdateV2 creates multiple temporary tables. two of them : #AppPlanUpdate_tmp__IdsSet and #AppPlanUpdate_tmp__ExecutionErrors will be used
    -- -- by this sp. verify their existence. There is no need to continue if they do not exist
    IF (OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__IdsSet') IS NULL)  OR (OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__ExecutionErrors') IS NULL)
        THROW 50001, 'Stored procedure must be executed in context of App_PlanUpdateV2', 1
    -- from now one all errors to be stored AppPlanUpdate_tmp__ExecutionErrors. no throws.
    DECLARE @errorCode      INT = 0
    DECLARE @errorString    NVARCHAR(MAX) = NULL
	DECLARE @const_Required	   INT = 1, @const_Forbidden   INT = 2, @const_Possible  INT = 3
	DECLARE @const_idTypeNew   INT = 1, @const_idTypeCur   INT = 2, @const_idTypeRes INT = 3
	DECLARE @const_Inheritance INT = 1, @const_DirectAssoc INT = 2
	-- restrictions bits
	DECLARE @constSealed     INT = 0x00000001 -- plan is sealed
    -- current plan restriction flags
	DECLARE @restriction     INT = ISNULL(dbo.AppPlanGetEntityValueV2(@i_planId, 'Derivation restrictions', @const_DirectAssoc), 0)
    -- current plan 'sealed' bit value
    DECLARE @sealedCur       INT = IIF((@restriction & @constSealed) = @constSealed, 1, 0)
    -- new (request) plan 'sealed' bit value
    DECLARE @sealedNew       INT = (SELECT ref.value('@isSealed', 'INT')                      FROM @x_xmlData.nodes('Api_UpdatePlanReq/inheritance') R ( ref ))
    DECLARE @enforcedOpType  INT = (SELECT ref.value('@enforcedEntitiesOperationType', 'INT') FROM @x_xmlData.nodes('Api_UpdatePlanReq/inheritance') R ( ref ))
    DECLARE @privatesOpType  INT = (SELECT ref.value('@privateEntitiesOperationType',  'INT') FROM @x_xmlData.nodes('Api_UpdatePlanReq/inheritance') R ( ref ))
    -- expect to have up to 5 rows
	DECLARE @globalRestrictedEntitiesList AS TABLE([id] INT)
    INSERT INTO @globalRestrictedEntitiesList
SELECT _ID FROM dbo.SplitIDString(ISNULL((SELECT TOP 1 value FROM GxGlobalParam WITH(NOLOCK) WHERE name = 'Plan entites derivation restricted' AND modified=0),''))
    -- expect to have up to 5 rows
	DECLARE @globalPrivateEntitiesList AS TABLE([id] INT)
    INSERT INTO @globalPrivateEntitiesList
SELECT _ID FROM dbo.SplitIDString(ISNULL((SELECT TOP 1 value FROM GxGlobalParam WITH(NOLOCK) WHERE name = 'Plan entites derivation private' AND modified=0),''))
    IF @sealedNew IS NULL -- sealed flag is not getting changed
        SET @sealedNew = @sealedCur
    IF @i_debug != 0 BEGIN
        SELECT 'sealed old',  @sealedCur      UNION ALL
        SELECT 'sealed new',  @sealedNew      UNION ALL
        SELECT 'enforced op', @enforcedOpType UNION ALL
        SELECT 'privates op', @privatesOpType
    END
    DECLARE @restrictionChanged   INT = 0
    -- change from unsealed to sealed is not supported.
    IF (@sealedNew = 1) AND (@sealedCur = 0)
    BEGIN
        SET @errorCode = 50; SET @errorString = 'Operation not supported'
        INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)
    END
    -- when change from sealed to unsealed
    ELSE IF (@sealedNew = 0) AND (@sealedCur = 1)
    BEGIN
        -- remove flag that indicates that plan is sealed. if there is gonna be no errors in sp execution App_PlanProp table will be updated with this new value
        SET @restriction -= @constSealed
        -- if operation types a missing then PLAN_ENTITY_LISTOP__OVERWRITE will be used
SET @enforcedOpType = ISNULL(@enforcedOpType, 1)
SET @privatesOpType = ISNULL(@privatesOpType, 1)
        -- update variable that indicates whether plan sealed or not.
        SET @sealedCur = 0
        -- new restrictions value shoule be stored in the db
        SET @restrictionChanged = 1
    END
    -- process restriction modifications
    -- -- list of enforced entities ----------------------------------------------------------------------------------------------------------------------------------------
    DECLARE @const_idTypeEnforcedNew INT = 2, @const_idTypeEnforcedCur INT = 4, @const_idTypeEnforcedRes INT = 6
    DECLARE @enforcedChanged BIT = 0
	IF @enforcedOpType IS NOT NULL
    BEGIN
        IF @sealedCur = 1 BEGIN
            SET @errorCode = 51; SET @errorString = 'Plan is sealed. Enforced entities restrictions modification is skipped.'
			INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)
        END
        ELSE BEGIN
            -- get list of current enforced entities
            INSERT INTO #AppPlanUpdate_tmp__IdsSet
                SELECT  @const_idTypeEnforcedCur, CAST(_ID AS INT)
FROM    dbo.SplitIDString(dbo.AppPlanGetEntityValueV2(@i_planId, 'Descendants enforced entities', default))
            -- get list of enforced entities in the request
			-- 2nd Query is must. These global entities has to be enforced no matter what
            INSERT INTO #AppPlanUpdate_tmp__IdsSet
                SELECT  @const_idTypeEnforcedNew, ref.value('@val', 'INT')
                FROM    @x_xmlData.nodes('Api_UpdatePlanReq/inheritance/enforcedEntities') R (ref)
            -- if this is request to replace old entities set with new entities set entities set then resulting
IF @enforcedOpType = 1 -- PLAN_ENTITY_LISTOP__OVERWRITE replace old entities set with new entities set.
            BEGIN
                INSERT INTO #AppPlanUpdate_tmp__IdsSet
                    SELECT  @const_idTypeEnforcedRes, id FROM #AppPlanUpdate_tmp__IdsSet WHERE ISNUMERIC(id) > 0 AND [type] = @const_idTypeEnforcedNew
            END
ELSE IF @enforcedOpType = 2 -- PLAN_ENTITY_LISTOP__ADD old and new
            BEGIN
                INSERT INTO #AppPlanUpdate_tmp__IdsSet
                    SELECT  DISTINCT @const_idTypeEnforcedRes, id FROM #AppPlanUpdate_tmp__IdsSet WHERE ISNUMERIC(id) > 0 AND [type] IN (@const_idTypeEnforcedNew, @const_idTypeEnforcedCur)
            END
ELSE IF @enforcedOpType = 3 -- PLAN_ENTITY_LISTOP__DELETE only those existing in old set and not existing in a new one
            BEGIN
                INSERT INTO #AppPlanUpdate_tmp__IdsSet
                    SELECT  @const_idTypeEnforcedRes, id
                    FROM    #AppPlanUpdate_tmp__IdsSet
                    WHERE       [type] = @const_idTypeEnforcedCur
                            AND id NOT IN (SELECT id FROM #AppPlanUpdate_tmp__IdsSet WHERE ISNUMERIC(id) > 0 AND [type] = @const_idTypeEnforcedNew)
                            AND ISNUMERIC(id) > 0
            END
            -- ELSE -- no need to process PLAN_ENTITY_LISTOP__CLEAR as #AppPlanUpdate_tmp__IdsSet will not have any records of const_idTypeRes type so resulting list will be empty
            -- set flag that indicates that enforced entities change should be committed to db
            SET @enforcedChanged = 1
            -- debug
            IF @i_debug != 0 BEGIN
                SELECT 'permissions enforced table::current', * FROM #AppPlanUpdate_tmp__IdsSet WHERE [type] = @const_idTypeEnforcedCur
                SELECT 'permissions enforced table::new',     * FROM #AppPlanUpdate_tmp__IdsSet WHERE [type] = @const_idTypeEnforcedNew
                SELECT 'permissions enforced table::res',     * FROM #AppPlanUpdate_tmp__IdsSet WHERE [type] = @const_idTypeEnforcedRes
            END
        END
    END
    -- -- list of private entities -----------------------------------------------------------------------------------------------------------------------------------------
    DECLARE @const_idTypePrivateNew INT = 1, @const_idTypePrivateCur INT = 3, @const_idTypePrivateRes INT = 5
    DECLARE @privateChanged BIT = 0
    IF @privatesOpType IS NOT NULL
    BEGIN
        IF @sealedCur = 1 BEGIN
			INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, 52, 'Plan is sealed. Private entities restrictions modification is skipped.')
        END
        ELSE BEGIN
            -- get list of current private entities
            INSERT INTO #AppPlanUpdate_tmp__IdsSet
                SELECT  @const_idTypePrivateCur, CAST(_ID AS INT)
FROM    dbo.SplitIDString(dbo.AppPlanGetEntityValueV2(@i_planId, 'Private entities', default))
            -- get list of private entities in the request
            INSERT INTO #AppPlanUpdate_tmp__IdsSet
                SELECT  @const_idTypePrivateNew, ref.value('@val', 'INT')
                FROM    @x_xmlData.nodes('Api_UpdatePlanReq/inheritance/privateEntities') R (ref)
IF @privatesOpType = 1 -- PLAN_ENTITY_LISTOP__OVERWRITE replace old entities set with new entities set.
            BEGIN
                INSERT INTO #AppPlanUpdate_tmp__IdsSet
                    SELECT  @const_idTypePrivateRes, id FROM #AppPlanUpdate_tmp__IdsSet WHERE ISNUMERIC(id) > 0 AND [type] = @const_idTypePrivateNew
            END
ELSE IF @privatesOpType = 2 -- PLAN_ENTITY_LISTOP__ADD old and new       l
            BEGIN
                INSERT INTO #AppPlanUpdate_tmp__IdsSet
                    SELECT  DISTINCT @const_idTypePrivateRes, id FROM #AppPlanUpdate_tmp__IdsSet WHERE ISNUMERIC(id) > 0 AND [type] IN(@const_idTypePrivateNew, @const_idTypePrivateCur)
            END
ELSE IF @privatesOpType = 3 -- PLAN_ENTITY_LISTOP__DELETE only those existing in old set and not existing in a new one
            BEGIN
                INSERT INTO #AppPlanUpdate_tmp__IdsSet
                    SELECT  @const_idTypePrivateRes, id
                    FROM    #AppPlanUpdate_tmp__IdsSet
                    WHERE       [type] = @const_idTypePrivateCur
                            AND id NOT IN (SELECT id FROM #AppPlanUpdate_tmp__IdsSet WHERE ISNUMERIC(id) > 0 AND [type] = @const_idTypePrivateNew)
                            AND ISNUMERIC(id) > 0
            END
            -- ELSE
            -- -- no need to process PLAN_ENTITY_LISTOP__CLEAR as #AppPlanUpdate_tmp__IdsSet will not have any records of const_idTypeRes type so resulting list will be empty
            -- set flag that indicates that private entities change should be committed to db
            SET @privateChanged = 1
            IF @i_debug != 0 BEGIN
                SELECT 'permissions private table::current', * FROM #AppPlanUpdate_tmp__IdsSet WHERE [type] = @const_idTypePrivateCur
                SELECT 'permissions private table::new',     * FROM #AppPlanUpdate_tmp__IdsSet WHERE [type] = @const_idTypePrivateNew
                SELECT 'permissions private table::res',     * FROM #AppPlanUpdate_tmp__IdsSet WHERE [type] = @const_idTypePrivateRes
            END
        END
    END
    -- verify that transition is supported and that enforced and private entities definitions are correct as entity cannot be present in both lists
    -- currently supported transitions
    --
    --          | optional | private | enforced |       the only unsupported combinations as of now are :
    -- ---------+----------+---------+----------+       1) - [optional] to [private]
    -- optional |    -     |         |     X    |       2) - [enforced] to [private]
    -- ---------+----------+---------+----------+       changing any type to [private] does not allowed for plans which serve as a base plan for other plans
    -- private  |    X     |    -    |     X    |
    -- ---------+----------+---------+----------+       so if #AppPlanUpdate_tmp__IdsSet contains record for entity with @const_idTypePrivateRes type and does not
    -- enforced |    X     |         |    -     |       contain record for the same entity with @const_idTypePrivateCur type then table contains incorrect transitions
    -- ---------+----------+---------+----------+       and whole restrictions changes operation will be canceled.
    --
    DECLARE @servesAsBase BIT = 0
IF EXISTS(SELECT * FROM APP_PlanProp WHERE attrName = 'Base plan' AND attrVal = CAST(@i_planId AS VARCHAR(32)))
        SET @servesAsBase = 1
    -- transition to private is forbidden unless plan has no descendants yet
	IF (@servesAsBase = 1) AND (EXISTS (SELECT  1
                                        FROM    #AppPlanUpdate_tmp__IdsSet
                                        WHERE       [type] = @const_idTypePrivateRes
                                                AND  id NOT IN (SELECT id FROM #AppPlanUpdate_tmp__IdsSet WHERE [type] = @const_idTypePrivateCur)))
    BEGIN
        SET @errorCode = 53; SET @errorString = 'Bad transition'
		INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)
    END
    -- make sure that resulting entities set contain globally defined entities
    -- -- enforced
    INSERT INTO #AppPlanUpdate_tmp__IdsSet
        SELECT @const_idTypeEnforcedRes, id FROM @globalRestrictedEntitiesList
        EXCEPT
        SELECT @const_idTypeEnforcedRes, id FROM #AppPlanUpdate_tmp__IdsSet WHERE [type] = @const_idTypeEnforcedRes
    -- -- private
    INSERT INTO #AppPlanUpdate_tmp__IdsSet
        SELECT @const_idTypePrivateRes, id FROM @globalPrivateEntitiesList
        EXCEPT
        SELECT @const_idTypePrivateRes, id FROM #AppPlanUpdate_tmp__IdsSet WHERE [type] = @const_idTypePrivateRes
    -- having the same entities listed both as private and enforced is forbidden
    IF (EXISTS (SELECT  1
                FROM    #AppPlanUpdate_tmp__IdsSet A INNER JOIN (SELECT id FROM #AppPlanUpdate_tmp__IdsSet WHERE [type] = @const_idTypeEnforcedRes) B ON B.id = A.id
                WHERE   [type] = @const_idTypePrivateRes))
    BEGIN
        SET @errorCode = 54; SET @errorString = 'Bad restrictions definition'
		INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)
    END
    -- commit all changes to db
    -- -- commit sealed flag if changed
    IF @errorCode = 0
    BEGIN
        IF @restrictionChanged != 0 BEGIN
            -- -- just to be on a safe side : remove private and restricting records for the plan from App_PlanProp table
            UPDATE  App_PlanProp SET attrVal = ''
            WHERE       componentNameId = @i_planId
AND attrName IN ('Private entities', 'Descendants enforced entities')
            -- update value in db
EXEC AppPlanSetEntityValueV2 @i_planId, 'Derivation restrictions', @restriction, @errorCode OUTPUT, @errorString OUTPUT
            IF @errorCode != 0
			    INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, 55, @errorString)
        END
        DECLARE @idsStr AS VARCHAR(MAX) = '';
        -- -- commit enforced entities
        IF @enforcedChanged = 1 BEGIN
            -- enforced entities
            SET @idsStr = NULL
            -- build comma-separated string
            SELECT  @idsStr = COALESCE(@idsStr + ',', '') + CAST(Id AS VARCHAR(32))
            FROM    #AppPlanUpdate_tmp__IdsSet
            WHERE   [type] = @const_idTypeEnforcedRes
            ORDER   BY id ASC
            -- update db
EXEC AppPlanSetEntityValueV2 @i_planId, 'Descendants enforced entities', @idsStr, @errorCode OUTPUT, @errorString OUTPUT
            IF @errorCode != 0
                -- --
			    INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, 56, @errorString)
        END
        -- -- commit private entities
        IF (@errorCode = 0) AND (@privateChanged = 1) BEGIN
            -- private entities
            SET @idsStr = NULL
            -- build comma-separated string
            SELECT  @idsStr = COALESCE(@idsStr + ',', '') + CAST(Id AS VARCHAR(32))
            FROM    #AppPlanUpdate_tmp__IdsSet
            WHERE   [type] = @const_idTypePrivateRes
            ORDER   BY id ASC
            -- update db
EXEC AppPlanSetEntityValueV2 @i_planId, 'Private entities', @idsStr, @errorCode OUTPUT, @errorString OUTPUT
            IF @errorCode != 0
			    INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)
        END
        -- no need for table data any more. make sure that temporary table is empty for next usage
        TRUNCATE TABLE #AppPlanUpdate_tmp__IdsSet
    END
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanUpdateRestrictionsV2')
	delete from GxQscripts where name = 'AppPlanUpdateRestrictionsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateRestrictionsV2')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateRestrictionsV2'
GO

insert into GXDBVersions values(2, 'AppPlanUpdateRestrictionsV2',  '00010001000200050000', 'AppPlanUpdateRestrictionsV2', '00010001000200050000')
GO

