

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanUpdateOptionsV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanUpdateOptionsV2.sp,v $ $Id: AppPlanUpdateOptionsV2.sp,v 1.1.2.20.8.1 2021/01/14 23:01:20 njain Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppPlanUpdateOptionsV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanUpdateOptionsV2 <<<'
	drop procedure AppPlanUpdateOptionsV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanUpdateOptionsV2')
	delete from GxQscripts where name = 'AppPlanUpdateOptionsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateOptionsV2')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateOptionsV2'
GO
print '... Creating Procedure: AppPlanUpdateOptionsV2'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppPlanUpdateOptionsV2
  @i_userId INT,
  @i_localeId INT,
  @i_planId INT,
  @i_debug INT,
  @x_xmlData XML
AS
    -- SET NOCOUNT ON added to prevent extra result sets from
    -- interfering with SELECT statements.
    SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	IF (@i_debug = 1)
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__IdsSet')  IS NULL CREATE TABLE #AppPlanUpdate_tmp__IdsSet([type] INT, id INT)
		IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__ExecutionErrors') IS NULL CREATE TABLE #AppPlanUpdate_tmp__ExecutionErrors(__type__ INT, errCode INT, errMessage NVARCHAR(MAX))
	END
    -- as the very first step make sure that this sp gets executed in context of App_PlanUpdateV2 or App_PlanCreateV2
    -- -- App_PlanUpdateV2 creates multiple temporary tables. two of them : #AppPlanUpdate_tmp__IdsSet and #AppPlanUpdate_tmp__ExecutionErrors will be used
    -- -- by this sp. verify their existence. There is no need to continue if they do not exist
    IF (OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__IdsSet') IS NULL)  OR (OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__ExecutionErrors') IS NULL)
        THROW 50001, 'Stored procedure must be executed in context of App_PlanUpdateV2', 1
	IF OBJECT_ID('tempdb.dbo.#AppPlanProcess_tmp__Plans') IS NOT NULL DROP TABLE #AppPlanProcess_tmp__Plans
	CREATE TABLE #AppPlanProcess_tmp__Plans(planId INT PRIMARY KEY, basePlanId INT, planSubType INT)
    DECLARE @errorCode      INT = 0
    DECLARE @errorString    NVARCHAR(MAX) = NULL
	DECLARE @const_DirectAssoc  INT = 2
	DECLARE @const_Inheritance  INT = 1
	DECLARE @isCreatePlanReq INT  = ISNULL((SELECT 1  FROM @x_xmlData.nodes('Api_CreatePlanReq/plan/summary/plan') R ( ref )),0)
	DECLARE @emptyXML XML = '<Api_UpdatePlanReq/>'
	-- Get the top most base plan
	-- Not the immediate base plan
	DECLARE @basePlanId INT  = ISNULL((dbo.AppPlanGetBasePlanV2(@i_planId, @const_Inheritance)),0)
	-- Each Option will come with its own handling
	DECLARE @continue BIT = 1
DECLARE @isOptionsRestrictedEntity INT = ISNULL ((SELECT  1  FROM  dbo.SplitIDString(dbo.AppPlanGetEntityValueV2(@i_planId, 'Descendants enforced entities', default)) WHERE _ID=128), 0)
	DECLARE @updateDescendent INT = 0
	-- Add check whether if it is part of restricted list.
	-- If not, then we have to honor current plan throttle values
	IF (@basePlanId > 0)
	BEGIN
		-- If given entity is restricted, then update is not allowed for derived plan
		-- If given entity is not restricted, then honoring create request is not allowed
		IF (@isOptionsRestrictedEntity = 1) AND (@isCreatePlanReq = 0)	-- this means this is update request
		BEGIN
			-- This means this is update request
			-- Insert error if user request update any option. else NO
			--IF EXISTS (SELECT 1 FROM @x_xmlData.nodes('Api_UpdatePlanReq/options') R ( ref ))
			--BEGIN
			--	-- This request not came from AppPlanCreateV2 and this plan has base plan. Don't do anything.
			--	-- Updating throttle is not allowed from here for derived plan from AppPlanUpdateV2.
--	INSERT INTO  #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, 84, 'Restricted Entity Options are not allowed to be updated for derived plan.') -- 158 : PLAN_ENTITY
			--END
			SET @continue = 0
		END
		ELSE IF (@isOptionsRestrictedEntity = 0) AND (@isCreatePlanReq = 1)
		BEGIN
			-- This reuqest came from AppPlanCreateV2 and this options is not restricted. Don't do anything.
			-- Let request go. Update request will handle it.
			SET @continue = 0
		END
	END
	IF @continue = 1
	BEGIN
		-- If we have no base plan and provided entity is restricted
		-- Then get all derived plan . We might need to update them
		-- Means we will update this one only for root base plan
		IF ((@isOptionsRestrictedEntity = 1) AND (@basePlanId = 0))
		BEGIN
			-- get list of all derived plans
			;WITH T(planId, basePlanId, planSubType) AS
			(
				SELECT  P.id, CAST(PP.attrVal AS INT), p.subType
FROM    APP_Plan P WITH(NOLOCK) INNER JOIN APP_PlanProp PP WITH(NOLOCK) ON PP.attrName = 'Base plan' AND  attrVal = @i_planId AND PP.componentNameId = P.id
				UNION ALL
				SELECT  PP.componentNameId, T.planId, P.subType
FROM    APP_PlanProp PP WITH(NOLOCK) INNER JOIN T ON PP.attrVal = CAST(T.planId AS VARCHAR) AND attrName = 'Base plan'
														INNER JOIN APP_Plan P WITH(NOLOCK) ON P.id = PP.componentNameId
			)
			INSERT INTO #AppPlanProcess_tmp__Plans
			SELECT DISTINCT * FROM T
			-- This will help us later in the code.
			-- Two code blocks will be executed. One for entity itself and one for child
			SET @updateDescendent = 1
		END
	END
	-- Now start processing different options
	IF @continue = 1
	BEGIN
        -- -- update default plan level archiving
        DECLARE @forcedArchivingEnabled INT = ISNULL((SELECT ISNULL(ref.value('@forcedArchiving', 'INT'),0) AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/options') R ( ref )), '0')
EXEC AppPlanSetEntityValueV2 @i_planId, 'Forced Archiving', @forcedArchivingEnabled, @errorCode OUTPUT, @errorString OUTPUT
        IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (154, @errorCode, @errorString)   --154 : CONFIGURATION_POLICY_ENTITY
		----- update optimize for instant clone option starts -----
		DECLARE @optimizeForInstantClone INT = (@x_xmlData.value('(Api_UpdatePlanReq/options/@optimizeForInstantClone)[1]', 'INT'))
DECLARE @optimizeForInstantCloneDB INT = ISNULL((SELECT dbo.AppPlanGetEntityValueV2(@i_planId, 'Optimize for instant clone', 2)), 0)
		DECLARE @updateOptionInDB INT = 0, @checkPermission INT = 0
		IF (@optimizeForInstantClone IS NOT NULL) AND (@optimizeForInstantClone <> @optimizeForInstantCloneDB)
		BEGIN
			IF @optimizeForInstantClone = 0
			BEGIN
DELETE App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Optimize for instant clone' AND modified = 0
			END
			ELSE
			BEGIN
				SET @updateOptionInDB = 1
				SET @checkPermission = 1
			END
		END
		ELSE IF @optimizeForInstantClone IS NULL AND @optimizeForInstantCloneDB = 1
		BEGIN
			SET @checkPermission = 1
		END
		IF @checkPermission = 1
		BEGIN
			DECLARE @savedInputUserId INT = @i_userId
			DECLARE @errorMsg    NVARCHAR(MAX) = ''
DECLARE @storagePolicyId INT = dbo.AppPlanGetEntityValueV2(@i_planId, 'Storage policy', 2)
			SET @i_userId = (SELECT ownerId FROM App_plan (NOLOCK) WHERE id = @i_planId)	-- @i_userId is referenced in AppCheckUserPermissionForPlanOptimizeForInstantCloneOption.spb for permission check, here we need to check the plan owner's permission
	IF @storagePolicyId IS NOT NULL
	BEGIN
		-- GET DISTRIBUTED STORAGE ID GIVEN storagePolicyId
		DECLARE @copyId INT, @distributedStorageId INT
		SET @copyId = (SELECT defaultCopy FROM archGroup (NOLOCK) WHERE id = @storagePolicyId)
		IF @copyId IS NOT NULL
		BEGIN
			DECLARE @dsTable TABLE (mmMountId INT, distributedStorageId INT)
			INSERT INTO @dsTable
			EXEC MMGetDistributedStorageForCopy @copyId
			SET @distributedStorageId = (SELECT TOP 1 distributedStorageId FROM @dsTable)
			IF @distributedStorageId IS NOT NULL
			BEGIN
				DECLARE @hasRight INT
EXEC sec_checkPermissionOnEntity @i_userId, 261, @hasRight OUTPUT, 195, @distributedStorageId
				IF @hasRight <> 1
				BEGIN
EXEC sec_checkPermissionOnEntity @i_userId, 260, @hasRight OUTPUT, 195, @distributedStorageId
					IF @hasRight <> 1
					BEGIN
DECLARE @distributedStorageName NVARCHAR(255) = ISNULL((SELECT name FROM App_DistributedStorage (NOLOCK) WHERE id = @distributedStorageId), '')
						SET @errorCode = 4; SET @errorMsg = 'User does not have Use or Manage permissions on distributed storage [' + @distributedStorageName + '] to use it for Instant Clone optimization.'
					END
				END
			END
			ELSE
			BEGIN
				SET @errorCode = 3; SET @errorMsg = 'Distributed storage info not found'
			END
		END
		ELSE
		BEGIN
			SET @errorCode = 3; SET @errorMsg = 'Storage copy info not found'
		END
	END
	ELSE
	BEGIN
		SET @errorCode = 3; SET @errorMsg = 'Storage policy info not found'
	END
			SET @i_userId = @savedInputUserId
			SET @errorString = @errorMsg
            IF @errorCode <> 0	 -- Permission check fails, disable plan option 'Optimize for instant clone'
            BEGIN
DELETE App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Optimize for instant clone' AND modified = 0
            END
			ELSE IF @updateOptionInDB = 1
			BEGIN
EXEC AppPlanSetEntityValueV2 @i_planId, 'Optimize for instant clone', @optimizeForInstantClone, @errorCode OUTPUT, @errorString OUTPUT
			END
			IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)   --158 : PLAN_ENTITY
		END
		----- update optimize for instant clone option ends -----
		-- update forceDeleteDevicesAfterDays and retireDevicesAfter
IF EXISTS (SELECT id from App_Plan where id = @i_planId AND subtype = 33554439)
		BEGIN
			DECLARE @iForceDeleteDevicesAfterDays INT = NULL;
			DECLARE @iRetireDevicesAfterDays INT = NULL;
			DECLARE @oForceDeleteDevicesAfterDays INT = NULL;
			DECLARE @oRetireDevicesAfterDays INT = NULL;
			SET @iForceDeleteDevicesAfterDays = ISNULL((SELECT ISNULL(ref.value('@forceDeleteDevicesAfterDays', 'INT'),
ISNULL((SELECT attrVal FROM APP_PlanProp (NOLOCK) WHERE attrName = 'Force delete devices after days' AND componentNameId = @i_planId AND modified = 0),-1)) AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/options/autoRetireDevices') R ( ref )), ISNULL((SELECT attrVal FROM APP_PlanProp (NOLOCK) WHERE attrName = 'Force delete devices after days' AND componentNameId = @i_planId AND modified = 0),-1))
			SET @iRetireDevicesAfterDays = ISNULL((SELECT ISNULL(ref.value('@retireDevicesAfterDays', 'INT'),
ISNULL((SELECT attrVal FROM APP_PlanProp (NOLOCK) WHERE attrName = 'Retire devices after days' AND componentNameId = @i_planId AND modified = 0),-1)) AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/options/autoRetireDevices') R ( ref )), ISNULL((SELECT attrVal FROM APP_PlanProp (NOLOCK) WHERE attrName = 'Retire devices after days' AND componentNameId = @i_planId AND modified = 0),-1))
			IF @iRetireDevicesAfterDays < 0
			BEGIN
				SET @oRetireDevicesAfterDays = -1;
				SET  @oForceDeleteDevicesAfterDays = -1;
			END
			ELSE IF @iRetireDevicesAfterDays > @iForceDeleteDevicesAfterDays AND  @iForceDeleteDevicesAfterDays >= 0
			BEGIN
				SET @oRetireDevicesAfterDays = @iRetireDevicesAfterDays;
				SET @oForceDeleteDevicesAfterDays = @iRetireDevicesAfterDays +  183;
			END
			ELSE
			BEGIN
				SET @oRetireDevicesAfterDays = @iRetireDevicesAfterDays;
				SET @oForceDeleteDevicesAfterDays = @iForceDeleteDevicesAfterDays;
				IF @iRetireDevicesAfterDays < -1
				BEGIN
					SET @oRetireDevicesAfterDays = -1;
				END
				IF @iForceDeleteDevicesAfterDays < -1
				BEGIN
					SET @oForceDeleteDevicesAfterDays = -1;
				END
			END
EXEC AppPlanSetEntityValueV2 @i_planId, 'Retire devices after days', @oRetireDevicesAfterDays, @errorCode OUTPUT, @errorString OUTPUT
			IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)   --158 : PLAN_ENTITY
EXEC AppPlanSetEntityValueV2 @i_planId, 'Force delete devices after days', @oForceDeleteDevicesAfterDays, @errorCode OUTPUT, @errorString OUTPUT
			IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)   --158 : PLAN_ENTITY
EXEC AppUpdateDataRetentionForDeconfiguredClients @i_planId, 158, @oForceDeleteDevicesAfterDays,0, @errorCode OUTPUT, @errorString OUTPUT
			IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)   --158 : PLAN_ENTITY
		END
		-- Begin FS Quota and Edge Drive Quota Values---
		BEGIN
			IF (@isCreatePlanReq = 1)
			BEGIN
				-- We will come over here only if this create Request and we don this only for derived plan in some cases
				-- Base plan or derived plan(wihtout restrictions) will not come here
				-- this request should always get empty XML as it should read all values from base plan
				EXEC AppPlanUpdateOptionsQuotaV2 @i_userId, @i_localeId, @i_planId, @basePlanId, @i_debug, 0, @emptyXML
			END
			ELSE
			BEGIN
				-- First update the plan itself
				EXEC AppPlanUpdateOptionsQuotaV2 @i_userId, @i_localeId, @i_planId, @i_planId, @i_debug, 1, @x_xmlData
			END
		END
		-- END FS Quota and Edge Drive Quota Values---
		-- Begin Process Network throttle
		-- Network throttle
		BEGIN
			IF (@isCreatePlanReq = 1)
			BEGIN
				-- We will come over here only if this create Request and we don this only for derived plan in some cases
				-- Base plan or derived plan(wihtout restrictions) will not come here
				-- this request should always get empty XML as it should read all values from base plan
				EXEC AppPlanUpdateOptionsThrottleV2 @i_userId, @i_localeId, @i_planId, @basePlanId, @i_debug, 0, @emptyXML
			END
			ELSE
			BEGIN
				-- First update the plan itself
				EXEC AppPlanUpdateOptionsThrottleV2 @i_userId, @i_localeId, @i_planId, @i_planId, @i_debug, 1, @x_xmlData
			END
		END
		-- Close Process Network Throttle
		--	Encryption Settings for a plan
        IF (@x_xmlData.exist('Api_UpdatePlanReq/options/encryptionInfo') = 1)
        BEGIN
            DECLARE @encryptionSettings INT = 0
            DECLARE @encryptionKeyLength INT = 0
            DECLARE @directMediaAccess INT = 0
            DECLARE @cipherType INT = 0
            SELECT @encryptionSettings = (ISNULL(ref.value('@encryptionSettings', 'INT'),3)),
                    @encryptionKeyLength = (ISNULL(ref.value('@encryptKeyLength', 'INT'),128)),
                    @directMediaAccess = (ISNULL(ref.value('@directMediaAccess', 'INT'),0)),
                    @cipherType = (ISNULL(ref.value('@cipherType', 'INT'),2))
                    FROM @x_xmlData.nodes('Api_UpdatePlanReq/options/encryptionInfo') R ( ref )
EXEC AppSetEncryptionSettings @i_planId, 158, @i_localeId, @i_userId, @encryptionSettings, @encryptionKeyLength, @directMediaAccess, @cipherType, 0, 0, @errorCode OUTPUT, @errorString OUTPUT
			INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)
        END
--
--
		-- BEGIN - SET SLA OPTIONS -----------------------------------------------------------------------------------------------------------------------------
		IF @x_xmlData.value('(//slaOptions/@level)[1]', 'INT') > 0
		BEGIN
			DECLARE @slaOptions XML
			SELECT @slaOptions = ref.query('.') FROM @x_xmlData.nodes('//slaOptions') R(ref)
			SELECT @slaOptions = @slaOptions.query('element Api_SLAOptions {slaOptions/@*, /slaOptions/*}')
			EXEC AppPlanSLAOptionsSetV2 @i_userId, @i_planId, @i_localeId, @slaOptions
		END
		-- END   - SET SLA OPTIONS -----------------------------------------------------------------------------------------------------------------------------
--
		-- BEGIN - Enable indexing Plan Property ----------------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
            DECLARE @enableIndexing  INT = (SELECT ISNULL(ref.value('@enableIndexing', 'INT'),0) AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/options') R ( ref ))
			--IF (@enableIndexing IS NULL)
			--BEGIN
				-- Get Indexing property from Infrastructure Pool
				-- If it is configured and has index server, then enable it by default
				-- For initial checkin, we keep this code commented
			--END
			IF (@enableIndexing IS NOT NULL)
			BEGIN
EXEC AppPlanSetEntityValueV2 @i_planId, 'Enable Indexing', @enableIndexing, @errorCode OUTPUT, @errorString OUTPUT
				IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)
			END
        END
		-- END - Enable indexing Plan Property
		-- BEGIN - Different type of Target App for DC Plan ----------------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
			IF ( @x_xmlData.exist('Api_UpdatePlanReq/options/targetApps') = 1)
			BEGIN
			DECLARE @targetAppStatus INT = 0
			SELECT  @targetAppStatus = @targetAppStatus | ref.value('@val', 'int') FROM @x_xmlData.nodes('Api_UpdatePlanReq/options/targetApps') R ( ref )
EXEC AppPlanSetEntityValueV2 @i_planId, 'Target app', @targetAppStatus, @errorCode OUTPUT, @errorString OUTPUT
				IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)
			END
        END
		-- END - Different type of Target App for DC Plan
		-- BEGIN - Cloud Mode index server properties(status and message) ----------------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
			DECLARE @indexingStatus INT
			DECLARE @indexingStatusMessage NVARCHAR(MAX)
			SELECT  @indexingStatusMessage = ref.value('@indexingStatusMessage', 'NVARCHAR(MAX)') FROM @x_xmlData.nodes('Api_UpdatePlanReq/options') R ( ref )
			SELECT  @indexingStatus = ref.value('@indexingStatus', 'INT') FROM @x_xmlData.nodes('Api_UpdatePlanReq/options') R ( ref )
			IF @indexingStatus IS NOT NULL
			BEGIN
EXEC AppPlanSetEntityValueV2 @i_planId, 'Cloud Mode indexing setup status', @indexingStatus, @errorCode OUTPUT, @errorString OUTPUT
				IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)
				-- Set indexing status message only if status is set
				IF @indexingStatusMessage IS NOT NULL
				BEGIN
EXEC AppPlanSetEntityValueV2 @i_planId, 'Cloud Mode indexing setup message', @indexingStatusMessage, @errorCode OUTPUT, @errorString OUTPUT
					IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)
				END
			END
		END
		-- BEGIN - Enable Index Server for Laptop Plan ----------------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
			IF ( @x_xmlData.exist('Api_UpdatePlanReq/options/cloudModeIndexServer') = 1)
			BEGIN
			DECLARE @cloudModeIndexServer INT
			SELECT  @cloudModeIndexServer = ref.value('@clientId', 'int') FROM @x_xmlData.nodes('Api_UpdatePlanReq/options/cloudModeIndexServer') R ( ref )
			IF @cloudModeIndexServer IS NOT NULL
			BEGIN
EXEC AppPlanSetEntityValueV2 @i_planId, 'Cloud Mode Index Server Id', @cloudModeIndexServer, @errorCode OUTPUT, @errorString OUTPUT
				IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)
				END
			END
        END
		-- END - Enable Index Server for Laptop Plan
		-- BEGIN - Enable Cloud Mode Laptop Plan ----------------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
			IF  ( @x_xmlData.exist('Api_UpdatePlanReq/options[@bCloudModeEnabled]') = 1)
			BEGIN
				DECLARE @bCloudModeEnabled INT
				SELECT  @bCloudModeEnabled = ref.value('@bCloudModeEnabled', 'int') FROM @x_xmlData.nodes('Api_UpdatePlanReq/options') R ( ref )
				-- if cloudMode is enabled, check if there exists an index server already set at plan level
				IF (@bCloudModeEnabled = 1 )
				BEGIN
EXEC AppPlanSetEntityValueV2 @i_planId, 'Cloud Mode Enabled', @bCloudModeEnabled, @errorCode OUTPUT, @errorString OUTPUT
					IF @errorCode != 0
					BEGIN
						INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)
					END
					ELSE
					BEGIN
						-- Cloud Mode is set at plan level
						EXEC AppPlanSetCloudLaptop @i_planId, @i_userId, 0, @bCloudModeEnabled, @errorCode OUTPUT, @errorString OUTPUT
						IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)
					END
				END
				ELSE IF (@bCloudModeEnabled = 0 ) -- disable cloud mode
				BEGIN
					-- Disable only if it is already enabled
					DECLARE @currentCloudMode INT = 0
SELECT @currentCloudMode = ISNULL(dbo.AppPlanGetEntityValueV2(@i_planId, 'Cloud Mode Enabled', default),0)
					IF (@currentCloudMode = 1)
					BEGIN
EXEC AppPlanSetEntityValueV2 @i_planId, 'Cloud Mode Enabled', @bCloudModeEnabled, @errorCode OUTPUT, @errorString OUTPUT
						IF @errorCode != 0
						BEGIN
							INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)
						END
						ELSE
						BEGIN
							-- Cloud Mode is set at plan level
							EXEC AppPlanSetCloudLaptop @i_planId, @i_userId, 0, @bCloudModeEnabled, @errorCode OUTPUT, @errorString OUTPUT
							IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)
						END	--@errorCode != 0
					END	-- (@currentCloudMode = 1)
				END	-- IF (@bCloudModeEnabled = 0 ) -- disable cloud mode
			END	-- ( @x_xmlData.exist('Api_UpdatePlanReq/options[@bCloudModeEnabled]') = 1)
        END
		-- END - Enable Cloud Mode/Index server for Laptop Plan
	END -- Close processing different options
	IF @continue = 1 AND EXISTS (SELECT 1 FROM @x_xmlData.nodes('Api_UpdatePlanReq/options') R ( ref ))
	BEGIN
		-- start cursor
		-- Process cursor only if there
		DECLARE @derivedPlanId INT = 0
		DECLARE @baseForDervied INT =0
		DECLARE PlanCursor CURSOR
		FOR
		SELECT planId, basePlanId FROM #AppPlanProcess_tmp__Plans
		OPEN PlanCursor
		FETCH FROM PlanCursor INTO @derivedPlanId, @baseForDervied
		WHILE @@FETCH_STATUS = 0
		BEGIN
			-- Begin FS Quota and Edge Drive Quota Values---
			BEGIN
				EXEC AppPlanUpdateOptionsQuotaV2 @i_userId, @i_localeId, @derivedPlanId, @i_planId, @i_debug, 0, @emptyXML
			END
			-- END FS Quota and Edge Drive Quota Values---
			-- update Netwrok Throttle
			BEGIN
				-- We will use the currently provided planid as base plan id
				EXEC AppPlanUpdateOptionsThrottleV2 @i_userId, @i_localeId, @derivedPlanId, @i_planId, @i_debug, 0, @emptyXML
			END
			FETCH FROM PlanCursor INTO @derivedPlanId, @baseForDervied
		END
		CLOSE PlanCursor
		DEALLOCATE PlanCursor
		--end cursor
	END
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanUpdateOptionsV2')
	delete from GxQscripts where name = 'AppPlanUpdateOptionsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateOptionsV2')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateOptionsV2'
GO

insert into GXDBVersions values(2, 'AppPlanUpdateOptionsV2',  'v1.1.2.20.8.1', 'AppPlanUpdateOptionsV2', 'v1.1.2.20.8.1')
GO

