

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanUpdateOptionsThrottleV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanUpdateOptionsThrottleV2.sp,v $ $Id: AppPlanUpdateOptionsThrottleV2.sp,v 1.1.2.1 2018/12/12 11:58:42 alakra Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanUpdateOptionsThrottleV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanUpdateOptionsThrottleV2 <<<'
	drop procedure AppPlanUpdateOptionsThrottleV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanUpdateOptionsThrottleV2')
	delete from GxQscripts where name = 'AppPlanUpdateOptionsThrottleV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateOptionsThrottleV2')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateOptionsThrottleV2'
GO
print '... Creating Procedure: AppPlanUpdateOptionsThrottleV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanUpdateOptionsThrottleV2
  @i_userId INT,
  @i_localeId INT,
  @i_planId INT,
  @i_basePlanId INT,
  @i_debug INT,
  @i_isXMLReq INT,
  @x_xmlData XML
AS
    -- SET NOCOUNT ON added to prevent extra result sets from
    -- interfering with SELECT statements.
    SET NOCOUNT ON
	IF (@i_debug = 1)
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__IdsSet')  IS NULL CREATE TABLE #AppPlanUpdate_tmp__IdsSet([type] INT, id INT)
		IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__ExecutionErrors') IS NULL CREATE TABLE #AppPlanUpdate_tmp__ExecutionErrors(__type__ INT, errCode INT, errMessage NVARCHAR(MAX))
	END
    -- as the very first step make sure that this sp gets executed in context of App_PlanUpdateV2 or App_PlanCreateV2
    -- -- App_PlanUpdateV2 creates multiple temporary tables. two of them : #AppPlanUpdate_tmp__IdsSet and #AppPlanUpdate_tmp__ExecutionErrors will be used
    -- -- by this sp. verify their existence. There is no need to continue if they do not exist
    IF (OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__IdsSet') IS NULL)  OR (OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__ExecutionErrors') IS NULL)
        THROW 50001, 'Stored procedure must be executed in context of App_PlanUpdateV2', 1
    DECLARE @errorCode      INT = 0
    DECLARE @errorString    NVARCHAR(MAX) = NULL
	DECLARE @networkTbl TABLE (throttle XML)
	DECLARE @networkThrottleEnabled INT
	DECLARE @cv_infra_cgid INT = ISNULL((SELECT TOP 1 id FROM App_ClientGroup WHERE flag & 0x80000 = 0x80000), 0)
	DECLARE @updated INT
	DECLARE @const_DirectAssoc  INT = 2
	DECLARE @const_Inheritance  INT = 1
DECLARE @clientGroupId INT =  ISNULL (dbo.AppPlanGetEntityValueV2(@i_planId, 'Assigned client group', @const_DirectAssoc), 0)
	DECLARE @workQOutPutTbl table (errCode INT,errString nvarchar(max))
	IF (@clientGroupId >0)
	BEGIN
		-- First Read the input for Network Throttle
		-- XML request means read input from actual xML else get it from base plan
		IF((@i_isXMLReq = 0) AND (@i_basePlanId <> @i_planId))
		BEGIN
SET @networkThrottleEnabled = CASE WHEN dbo.AppPlanGetEntityValueV2(@i_basePlanId, 'Network throttle', @const_DirectAssoc) IS NULL THEN 0 ELSE 1 END
			SET @updated = @networkThrottleEnabled
			IF @networkThrottleEnabled = 1
			BEGIN
DECLARE @baseSCGId INT =  ISNULL (dbo.AppPlanGetEntityValueV2(@i_basePlanId, 'Assigned client group', @const_DirectAssoc), 0)
				INSERT INTO @networkTbl
				SELECT NetworkThrottleOptions.query('App_ThrottleScheduleOptionList/throttle')
						FROM   APP_NetworkThrottleOptions
					WHERE  clientGroupId = @baseSCGId
			END
		END
		ELSE	-- This came from Update Request
		BEGIN
			SET @networkThrottleEnabled = (SELECT ref.value('@enableThrottle', 'NVARCHAR(32)') FROM @x_xmlData.nodes('Api_UpdatePlanReq/options/network') R ( ref ))
SET @updated = CASE WHEN dbo.AppPlanGetEntityValueV2(@i_planId, 'Network throttle', @const_DirectAssoc) IS NULL THEN 0 ELSE 1 END
			IF @networkThrottleEnabled = 1
			BEGIN
				INSERT INTO @networkTbl
				SELECT @x_xmlData.query('Api_UpdatePlanReq/options/network/throttle/throttle')
			END
		END
		-- All set now. Complete the processing
		IF @networkThrottleEnabled = 0
		BEGIN
EXEC AppPlanSetEntityValueV2 @i_planId, 'Network throttle', '0', @errorCode OUTPUT, @errorString OUTPUT
			IF @errorCode = 0
			BEGIN
				-- -- -- Push firewall configuration if necessary, 5 -- WORK_TOKEN_NETWORK
				IF @updated = 1
				BEGIN
					INSERT INTO @workQOutPutTbl
					EXEC AppWorkQueueSubmitRequest 5, 0, 0, 0, @clientGroupId, ''
				END
				DELETE FROM APP_NetworkThrottleOptions WHERE clientid = 0 AND clientGroupId = @clientGroupId
				DELETE FROM APP_NetworkThrottle WHERE clientId = 0 AND forClientId = 0 AND clientGroupId = @clientGroupId AND forClientGroupId = @cv_infra_cgid
				-- remove throttling flag from client group
UPDATE APP_ClientGroup SET flag = (flag | 0x0800) ^ 0x0800 WHERE id = @clientGroupId
			END
			ELSE
			BEGIN
INSERT INTO  #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString) -- 158 : PLAN_ENTITY
			END
		END
		ELSE IF @networkThrottleEnabled = 1
		BEGIN
			IF @cv_infra_cgid != 0
			BEGIN
EXEC AppPlanSetEntityValueV2 @i_planId, 'Network throttle', '1', @errorCode OUTPUT, @errorString OUTPUT
				IF @errorCode = 0
				BEGIN
					IF NOT EXISTS(SELECT 1 FROM APP_NetworkThrottle WHERE clientId = 0 AND forClientId = 0 AND clientGroupId = @clientGroupId AND forClientGroupId = @cv_infra_cgid) BEGIN
						INSERT INTO APP_NetworkThrottle (clientId, clientGroupId, forClientId, forClientGroupId)
							VALUES(0, @clientGroupId, 0, @cv_infra_cgid)
					END
					DECLARE @throttleOptions XML = (SELECT '1' as '@shareBandwidth',throttle as [*] from @networkTbl FOR XML PATH ('App_ThrottleScheduleOptionList'))
					MERGE   APP_NetworkThrottleOptions AS TGT
					USING   (SELECT @clientGroupId) AS SRC(clientGroupId)
					ON      TGT.clientId = 0 AND TGT.clientGroupId = SRC.clientGroupId
					WHEN    MATCHED     THEN UPDATE SET NetworkThrottleOptions = @throttleOptions
					WHEN    NOT MATCHED THEN INSERT VALUES (0,@clientGroupId,@throttleOptions);
					-- Push firewall configuration
					INSERT INTO @workQOutPutTbl
					EXEC AppWorkQueueSubmitRequest 5, 0, 0, 0, @clientGroupId, ''
					-- set throttling flag in App_ClientGroup table
UPDATE APP_ClientGroup SET flag = flag | 0x0800 WHERE id =  @clientGroupId
				END
				ELSE
				BEGIN
INSERT INTO  #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString) -- 158 : PLAN_ENTITY
				END
			END
			ELSE
			BEGIN
EXEC AppPlanSetEntityValueV2 @i_planId, 'Network throttle', '0', @errorCode OUTPUT, @errorString OUTPUT
				IF @errorCode = 0
				BEGIN
					-- -- -- Push firewall configuration if necessary, 5 -- WORK_TOKEN_NETWORK
					IF @updated = 1
					BEGIN
						INSERT INTO @workQOutPutTbl
						EXEC AppWorkQueueSubmitRequest 5, 0, 0, 0, @clientGroupId, ''
					END
					DELETE FROM APP_NetworkThrottleOptions WHERE clientid = 0 AND clientGroupId = @clientGroupId
					DELETE FROM APP_NetworkThrottle WHERE clientId = 0 AND forClientId = 0 AND clientGroupId = @clientGroupId AND forClientGroupId = @cv_infra_cgid
					-- remove throttling flag from client group
UPDATE APP_ClientGroup SET flag = (flag | 0x0800) ^ 0x0800 WHERE id = @clientGroupId
				END
				ELSE
				BEGIN
INSERT INTO  #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString) -- 158 : PLAN_ENTITY
				END
				-- -- report an error
INSERT INTO  #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, 84, 'Unable to set client group options. Infastructure client group not found.') -- 158 : PLAN_ENTITY
			END
		END
	END	-- (@clientGroupId >0)
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanUpdateOptionsThrottleV2')
	delete from GxQscripts where name = 'AppPlanUpdateOptionsThrottleV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateOptionsThrottleV2')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateOptionsThrottleV2'
GO

insert into GXDBVersions values(2, 'AppPlanUpdateOptionsThrottleV2',  '00010001000200010000', 'AppPlanUpdateOptionsThrottleV2', '00010001000200010000')
GO

