

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanUpdateOptionsQuotaV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanUpdateOptionsQuotaV2.sp,v $ $Id: AppPlanUpdateOptionsQuotaV2.sp,v 1.1.2.2 2019/03/22 20:17:05 alakra Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanUpdateOptionsQuotaV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanUpdateOptionsQuotaV2 <<<'
	drop procedure AppPlanUpdateOptionsQuotaV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanUpdateOptionsQuotaV2')
	delete from GxQscripts where name = 'AppPlanUpdateOptionsQuotaV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateOptionsQuotaV2')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateOptionsQuotaV2'
GO
print '... Creating Procedure: AppPlanUpdateOptionsQuotaV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanUpdateOptionsQuotaV2
  @i_userId INT,
  @i_localeId INT,
  @i_planId INT,
  @i_basePlanId INT,
  @i_debug INT,
  @i_isXMLReq INT,
  @x_xmlData XML
AS
    -- SET NOCOUNT ON added to prevent extra result sets from
    -- interfering with SELECT statements.
    SET NOCOUNT ON
	IF (@i_debug = 1)
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__IdsSet')  IS NULL CREATE TABLE #AppPlanUpdate_tmp__IdsSet([type] INT, id INT)
		IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__ExecutionErrors') IS NULL CREATE TABLE #AppPlanUpdate_tmp__ExecutionErrors(__type__ INT, errCode INT, errMessage NVARCHAR(MAX))
	END
    -- as the very first step make sure that this sp gets executed in context of App_PlanUpdateV2 or App_PlanCreateV2
    -- -- App_PlanUpdateV2 creates multiple temporary tables. two of them : #AppPlanUpdate_tmp__IdsSet and #AppPlanUpdate_tmp__ExecutionErrors will be used
    -- -- by this sp. verify their existence. There is no need to continue if they do not exist
    IF (OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__IdsSet') IS NULL)  OR (OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__ExecutionErrors') IS NULL)
        THROW 50001, 'Stored procedure must be executed in context of App_PlanUpdateV2', 1
    DECLARE @errorCode      INT = 0
    DECLARE @errorString    NVARCHAR(MAX) = NULL
	DECLARE @quotaValue VARCHAR(32)
	DECLARE @edgeDriveQuotaLimitInGB NVARCHAR(32)
	DECLARE @currentTime INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
	IF((@i_isXMLReq = 0) AND (@i_basePlanId <> @i_planId))
	BEGIN
SET @quotaValue  = dbo.AppPlanGetEntityValueV2(@i_basePlanId, 'Quota', default)
SET @edgeDriveQuotaLimitInGB = dbo.AppPlanGetEntityValueV2(@i_basePlanId, 'Edge Drive Quota Size', default)
	END
	ELSE	-- This came from Update Request
	BEGIN
		SET @quotaValue  = (SELECT TOP 1 ref.value('@quota', 'VARCHAR(32)') AS value FROM @x_xmlData.nodes('Api_UpdatePlanReq/options') R ( ref ))
		SET @edgeDriveQuotaLimitInGB = (SELECT TOP 1 ref.value('@edgeDriveQuota', 'nvarchar(32)') AS value FROM @x_xmlData.nodes('Api_UpdatePlanReq/options') R ( ref ))
	END
	-- -- performing sanity before updating quota - remove plan association with non-existing client group
    DELETE  PP
    FROM    App_PlanProp PP LEFT JOIN UMGroups G ON G.id = PP.attrVal
    WHERE       G.id IS NULL
AND PP.attrName IN ('Associated internal user group', 'Associated external user group')
            AND PP.componentNameId = @i_planId
    -- -- quota value
    IF @quotaValue IS NOT NULL
	BEGIN
        -- -- -- set new value
EXEC AppPlanSetEntityValueV2 @i_planId, 'Quota', @quotaValue, @errorCode OUTPUT, @errorString OUTPUT
        IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (154, @errorCode, @errorString) -- 154 : CONFIGURATION_POLICY_ENTITY
        DECLARE @enforceQuota INT = CASE WHEN CAST(ISNULL(@quotaValue, '0') AS INT) = 0 THEN 0 ELSE 1 END
		--   Recompute Quota
		--Need to recompute the quota information for the groups whose 'quota size' property is getting updated. Insert 'ReComputeQuota' property in UmUsersProp table for the modified users.
		DECLARE @inXml XML
		SET @inXml = (SELECT DISTINCT UG.userId as '@id'
						FROM UMUserGroup UG WITH(NOLOCK)
						INNER JOIN App_PlanProp APP
ON APP.componentnameId=@i_planId AND APP.attrName IN ('Assigned user group','Associated internal user group', 'Associated external user group')
							AND  APP.attrVal=CAST(UG.groupId AS NVARCHAR(32))
						FOR XML PATH ('userID'), ROOT('UserList')
					 )
		exec UpdateUserPropForQuota @inXml
        -- -- -- update quota for all associated groups. groups cannot be inherited because user cannot be associated with more than 1 plan
        -- -- -- -- set enforce quota flag
        MERGE   UMGroupsProp AS TGT
USING   (SELECT CAST(attrVal AS INT) AS userGroupId FROM App_PlanProp WHERE componentNameId = @i_planId AND (attrName IN ('Assigned user group','Associated internal user group', 'Associated external user group'))) AS SRC
        ON      TGT.componentNameId = SRC.userGroupId and TGT.attrName = 'Enforce quota' AND TGT.attrType = 7
        WHEN    MATCHED THEN UPDATE SET
                TGT.attrVal = @enforceQuota
        WHEN    NOT MATCHED THEN  INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
                VALUES(SRC.userGroupId, 'Enforce quota', 7, @enforceQuota, @currentTime, 0);
        -- -- -- -- set group quota size value
        MERGE   UMGroupsProp AS TGT
USING   (SELECT CAST(attrVal AS INT) as userGroupId FROM App_PlanProp WHERE componentNameId = @i_planId AND (attrName IN ('Assigned user group', 'Associated internal user group', 'Associated external user group'))) AS SRC
        ON      TGT.componentNameId = SRC.userGroupId and TGT.attrName = 'Quota size' AND TGT.attrType = 7
        WHEN    MATCHED     THEN
            UPDATE SET TGT.attrVal = @quotaValue
        WHEN    NOT MATCHED THEN
            INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
            VALUES(SRC.userGroupId, 'Quota size', 7, @quotaValue, @currentTime, 0);
		DECLARE @newEnforceFSQuotaValue INT = @enforceQuota
-- Update global quota check flag
-- Based on this JM and other subsystems decide whether or not to do a quota check.
DECLARE @newDoQuotaCheck INT = CASE WHEN @newEnforceFSQuotaValue > 0 THEN 1
									ELSE ISNULL((
												SELECT TOP 1 1
												FROM UMUsersProp WITH(NOLOCK)
												WHERE attrName = N'Enforce quota' AND cs_attrName = CHECKSUM(N'Enforce quota')
												AND modified = 0
												AND attrVal = '1'
												UNION
												SELECT TOP 1 1
												FROM UMGroupsProp WITH(NOLOCK)
												WHERE attrName = N'Enforce quota' AND cs_attrName = CHECKSUM(N'Enforce quota')
												AND modified = 0
												AND attrVal = '1'), 0)
									END
DECLARE @oldDoQuotaCheck INT = (SELECT CAST(value AS INT) FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'DoFSQuotaCheck' AND modified = 0)
DECLARE @quotaSetTime INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
-- Insert only if it gets enabled
IF @oldDoQuotaCheck IS NULL AND @newDoQuotaCheck = 1
BEGIN
	INSERT INTO GXGlobalParam(name, value, created, modified)
	VALUES('DoFSQuotaCheck', @newDoQuotaCheck, @quotaSetTime, 0)
END
ELSE IF @oldDoQuotaCheck <> @newDoQuotaCheck
BEGIN
	UPDATE GXGlobalParam
	SET value = @newDoQuotaCheck
	WHERE name = 'DoFSQuotaCheck'
	AND modified = 0
END
--
    END
    -- -- edge drive quota value
    IF @edgeDriveQuotaLimitInGB IS NOT NULL
	BEGIN
        -- -- -- set new value
EXEC AppPlanSetEntityValueV2 @i_planId, 'Edge Drive Quota Size', @edgeDriveQuotaLimitInGB, @errorCode OUTPUT, @errorString OUTPUT
        IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (154, @errorCode, @errorString) -- 154 : CONFIGURATION_POLICY_ENTITY
        DECLARE @enforceEdgeDriveQuota INT = CASE WHEN CAST(ISNULL(@quotaValue, '0') AS INT) = 0 THEN 0 ELSE 1 END
        -- -- -- update edge drive quota for all associated groups. groups cannot be inherited because user cannot be associated with more than 1 plan
        -- -- -- -- set enforce quota flag
        MERGE   UMGroupsProp AS TGT
USING   (SELECT CAST(attrVal AS INT) as userGroupId FROM App_PlanProp WHERE componentNameId = @i_planId AND (attrName IN ('Assigned user group', 'Associated internal user group', 'Associated external user group'))) AS SRC
ON      TGT.componentNameId = SRC.userGroupId and TGT.attrName = 'Enforce Edge Drive Quota' AND TGT.attrType = 7
        WHEN    MATCHED THEN UPDATE SET
                TGT.attrVal = @enforceEdgeDriveQuota
        WHEN    NOT MATCHED THEN  INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(SRC.userGroupId, 'Enforce Edge Drive Quota', 7, @enforceEdgeDriveQuota, @currentTime, 0);
        -- -- -- -- set group edge drive quota size value
        MERGE   UMGroupsProp AS TGT
USING   (SELECT CAST(attrVal AS INT) as userGroupId FROM App_PlanProp WHERE componentNameId = @i_planId AND (attrName in ('Assigned user group', 'Associated internal user group', 'Associated external user group'))) AS SRC
ON      TGT.componentNameId = SRC.userGroupId and TGT.attrName = 'Edge Drive Quota Size' AND TGT.attrType = 7
        WHEN    MATCHED     THEN
            UPDATE SET TGT.attrVal = @edgeDriveQuotaLimitInGB
        WHEN    NOT MATCHED THEN
            INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(SRC.userGroupId, 'Edge Drive Quota Size', 7, @edgeDriveQuotaLimitInGB, @currentTime, 0);
    END
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanUpdateOptionsQuotaV2')
	delete from GxQscripts where name = 'AppPlanUpdateOptionsQuotaV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateOptionsQuotaV2')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateOptionsQuotaV2'
GO

insert into GXDBVersions values(2, 'AppPlanUpdateOptionsQuotaV2',  '00010001000200020000', 'AppPlanUpdateOptionsQuotaV2', '00010001000200020000')
GO

