

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanUpdateNameV2.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanUpdateNameV2.sp,v $ $Id: AppPlanUpdateNameV2.sp,v 1.1.2.14 2020/07/17 23:50:37 evolohov Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanUpdateNameV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanUpdateNameV2 <<<'
	drop procedure AppPlanUpdateNameV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanUpdateNameV2')
	delete from GxQscripts where name = 'AppPlanUpdateNameV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateNameV2')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateNameV2'
GO
print '... Creating Procedure: AppPlanUpdateNameV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanUpdateNameV2
  @i_planId INT,
  @i_planNewName NVARCHAR(255),
  @i_userId INT,
  @i_localeId INT,
  @o_errorCode INT              OUTPUT,
  @o_errorMessage NVARCHAR(255)    OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdateName_tmp__IDs') IS NOT NULL DROP TABLE #AppPlanUpdateName_tmp__IDs
CREATE TABLE #AppPlanUpdateName_tmp__IDs (id INT PRIMARY KEY)
SET @o_errorCode = 0
SET @o_errorMessage  = ''
DECLARE @currentPlanName NVARCHAR(255) = (SELECT name FROM App_Plan WHERE id = @i_planId)
DECLARE @debug INT = 0
-- check if user has necessary permissions on the plan
DECLARE @userHasCapabilityUpdate INT = 0
EXEC sec_checkPermissionOnEntity @i_userId, 157, @userHasCapabilityUpdate OUTPUT, 158, @i_planId
IF @userHasCapabilityUpdate = 0 BEGIN
    SET @o_errorCode    = 5
    SET @o_errorMessage = 'Access denied'
END
-- check for plan existence and also if new plan name is different from the old one then
IF (@o_errorCode = 0) AND (@currentPlanName != @i_planNewName) BEGIN
    DECLARE @entityId       INT             = 0
    DECLARE @entityOldName  NVARCHAR(255)   = NULL
    DECLARE @entityNewName  NVARCHAR(255)   = NULL
    IF @debug != 0 BEGIN
        BEGIN TRANSACTION
        SELECT 'old plan name', @currentPlanName
UNION SELECT 'old client group',                  (SELECT [name]     FROM APP_ClientGroup         WHERE id =       (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Assigned client group'))
UNION SELECT 'old user group',                    (SELECT [name]     FROM UMGroups                WHERE id =       (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Assigned user group'))
UNION SELECT 'old primary storage policy',        (SELECT [name]     FROM archGroup               WHERE id =       (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Storage policy'))
UNION SELECT 'old log storage policy',            (SELECT [name]     FROM archGroup               WHERE id =       (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Log storage policy'))
UNION SELECT 'old primary schedule policy',       (SELECT taskName   FROM TM_Task                 WHERE taskId =   (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Schedule policy'))
UNION SELECT 'old log schedule policy',           (SELECT taskName   FROM TM_Task                 WHERE taskId =   (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Log schedule policy'))
UNION SELECT 'old subclient policy win',          (SELECT [name]     FROM APP_BackupSetName       WHERE id =       (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Subclient policy 2'))
UNION SELECT 'old subclient policy lin',          (SELECT [name]     FROM APP_BackupSetName       WHERE id =       (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Subclient policy 3'))
UNION SELECT 'old subclient policy mac',          (SELECT [name]     FROM APP_BackupSetName       WHERE id =       (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Subclient policy 4'))
UNION SELECT 'old exchange archiving policy',     (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Exchange mailbox archiving policy'))
UNION SELECT 'old exchange retention policy',     (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Exchange mailbox retention policy'))
UNION SELECT 'old exchange cleanup policy',       (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Exchange mailbox cleanup policy'))
UNION SELECT 'old exchange journal policy',       (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Exchange mailbox journal policy'))
UNION SELECT 'old data classification policy',    (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Data classification policy'))
UNION SELECT 'old features',                      (SELECT [name]     FROM UMRoles                 WHERE id =       (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Feature'))
UNION SELECT 'old access policy',                 (SELECT [name]     FROM UMRoles                 WHERE id =       (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Access policy'))
UNION SELECT 'old edge drive client',             (SELECT [name]     FROM APP_Client              WHERE id =       (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Assgined Edge Drive'))                                                                   --
UNION SELECT 'old content indexing policy',       (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Content Indexing Policy'))
UNION SELECT 'old o365 backup policy',            (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Office 365 backup policy'))
UNION SELECT 'old o365 cleanup policy',           (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Office 365 cleanup policy'))
UNION SELECT 'old o365 retention policy',         (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Office 365 retention policy'))
UNION SELECT 'old o365 mailbox archiving policy', (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Office 365 Mailbox archive policy'))
UNION SELECT 'old o365 mailbox retention policy', (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Office 365 Mailbox retention policy'))
UNION SELECT 'old o365 mailbox cleanup policy',   (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Office 365 Mailbox cleanup policy'))
    END
    -- update plan name
    UPDATE App_Plan SET name = @i_planNewName WHERE id = @i_planId
    -- update plan associated entities names -- associated client group
    SET @entityNewName = @i_planNewName + ' laptop clients'
SET @entityId = ISNULL(CAST(dbo.AppPlanGetEntityValue(@i_planId, ('Assigned client group'), 2) AS INT), 0);     IF @entityId != 0 EXEC AppGetUniqueEntityName 28, @entityNewName, @i_userId, @entityNewName OUTPUT;     IF @entityId != 0
    BEGIN
        -- -- set client group name
        UPDATE APP_ClientGroup SET [name]        = @entityNewName,
                                   [description] =  REPLACE([description], @currentPlanName, @i_planNewName)
        WHERE id = @entityId
        -- -- update smart client group rule.
        -- -- -- definition
        UPDATE  App_SCGRule
        SET     [ruleXml].modify('replace value of (/scgRule/rules/rule/rules/rule/@value)[1] with sql:variable("@i_planNewName")')
        WHERE   scgId = @entityId
        -- -- -- query
        DECLARE @xmlRule XML = (SELECT ruleXml FROM App_SCGRule WHERE scgId = @entityId)
        IF @xmlRule IS NOT NULL
        BEGIN
		    DECLARE @scgRule VARCHAR(max)
		    EXEC APPSCGV2GenerateQueryParams @xmlRule, @o_errorCode OUTPUT, @o_errorMessage OUTPUT, @scgRule OUTPUT
            UPDATE App_SCGRule SET ruleQuery = @scgRule WHERE scgId = @entityId
        END
        --DECLARE @planSCGFuncId INT = (SELECT id FROM App_SCGProperty WHERE [name] = 'CLIENT_ASSOCIATED_WITH_PLAN')
        ---- find all nodes (recursively) which have plan that is being renamed as plan's SCG function parameter
        ---- on prodcommserve App_SCGRule table contains 165 rows and the stats are :
        ---- Table 'Worktable'. Scan count 2, logical reads 29542, physical reads 0, read-ahead reads 0, lob logical reads 20863, lob physical reads 0, lob read-ahead reads 0.
        ---- Table 'App_SCGRule'. Scan count 1, logical reads 38, physical reads 0, read-ahead reads 0, lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
        ----
        ---- SQL Server Execution Times:
        ---- CPU time = 219 ms,  elapsed time = 256 ms.
        --;WITH CTE AS
        --(
        --    SELECT id,
        --            propId  = x.value('@propID', 'INT'),
        --            value   = x.value('@value', 'VARCHAR(MAX)'),
        --            node    = x.query('.'),
        --            name    = x.value('local-name(.)','VARCHAR(MAX)'),
        --            xpath   = CAST('' AS VARCHAR(max))
        --    FROM (SELECT id, ruleXml AS node FROM App_SCGRule) parent CROSS APPLY node.nodes('/*') T(x)
        --    UNION ALL
        --    SELECT id,
        --            propId  = x.value('@propID', 'INT'),
        --            value   = x.value('@value', 'VARCHAR(MAX)'),
        --            node    = x.query('.'),
        --            name    = x.value('local-name(.)','VARCHAR(MAX)'),
        --            xpath   = parent.xpath + '/' + parent.name
        --    FROM CTE parent CROSS APPLY node.nodes('/*/*') T(x)
        --)
        --INSERT INTO #AppPlanUpdateName_tmp__IDs
        --    SELECT id, xpath + '/' + [name]  FROM CTE WHERE propId = @planSCGFuncId AND value = @currentPlanName
    END
    -- update plan associated entities names -- user group
    SET @entityNewName = @i_planNewName + ' users'
SET @entityId = ISNULL(CAST(dbo.AppPlanGetEntityValue(@i_planId, ('Assigned user group'), 2) AS INT), 0);     IF @entityId != 0 EXEC AppGetUniqueEntityName 15, @entityNewName, @i_userId, @entityNewName OUTPUT;     IF @entityId != 0
    BEGIN
        UPDATE UMGroups SET [name]        = @entityNewName,
                            [description] = REPLACE([description], @currentPlanName, @i_planNewName)
        WHERE id = @entityId
    END
    -- update plan associated entities names -- storage policy
    SET @entityNewName = @i_planNewName
SET @entityId = ISNULL(CAST(dbo.AppPlanGetEntityValue(@i_planId, ('Storage policy'), 2) AS INT), 0);     IF @entityId != 0 EXEC AppGetUniqueEntityName 17, @entityNewName, @i_userId, @entityNewName OUTPUT;     IF @entityId != 0
    BEGIN
        -- -- update storage policy name and storage policy description. description should not be unique. simple REPLACE will do
        UPDATE archGroup SET [name]        = @entityNewName,
                             [description] = REPLACE([description], @currentPlanName, @i_planNewName)
        WHERE id = @entityId
        -- -- update storage policy copy names and description, which should not be unique : simple REPLACE
        UPDATE  archGroupCopy  SET [name]        = REPLACE([name],        @currentPlanName, @i_planNewName),
                                   [description] = REPLACE([description], @currentPlanName, @i_planNewName)
        WHERE   archGroupId = @entityId
    END
    -- update plan associated entities names -- log storage policy
    SET @entityNewName = @i_planNewName + ' - Log'
SET @entityId = ISNULL(CAST(dbo.AppPlanGetEntityValue(@i_planId, ('Log storage policy'), 2) AS INT), 0);     IF @entityId != 0 EXEC AppGetUniqueEntityName 17, @entityNewName, @i_userId, @entityNewName OUTPUT;     IF @entityId != 0
    BEGIN
        -- -- update storage policy name and storage policy description. description should not be unique. simple REPLACE will do
        UPDATE archGroup SET [name]        = @entityNewName,
                             [description] = REPLACE([description], @currentPlanName, @i_planNewName)
        WHERE id = @entityId
        -- -- update storage policy copy names and description, which should not be unique : simple REPLACE
        UPDATE  archGroupCopy  SET [name]        = REPLACE([name],        @currentPlanName, @i_planNewName),
                                   [description] = REPLACE([description], @currentPlanName, @i_planNewName)
        WHERE   archGroupId = @entityId
    END
    -- update plan associated entities names -- schedule policy
    SET @entityNewName = @i_planNewName
SET @entityId = ISNULL(CAST(dbo.AppPlanGetEntityValue(@i_planId, ('Schedule policy'), 2) AS INT), 0);     IF @entityId != 0 EXEC AppGetUniqueEntityName 35, @entityNewName, @i_userId, @entityNewName OUTPUT;     IF @entityId != 0
    BEGIN
        -- -- update schedule policy name
        UPDATE TM_Task SET taskName = @entityNewName  WHERE taskId = @entityId
        -- -- update schedule policy description. description should not be unique. simple replace will do
        UPDATE TM_Task SET [description] = REPLACE([description], @currentPlanName, @i_planNewName) WHERE taskId = @entityId
        -- -- update subtask names. they should not be unique, so just replace
        UPDATE TM_SubTask SET subTaskName = REPLACE(subTaskName, @currentPlanName, @i_planNewName)  WHERE taskId = @entityId
        -- -- update schedule associated operation window name
        INSERT INTO #AppPlanUpdateName_tmp__IDs
            SELECT DISTINCT ID FROM APP_OpWindowRule WHERE schedulePolicyId = @entityId
        SET @entityId = (SELECT MIN(id) FROM #AppPlanUpdateName_tmp__IDs)
        WHILE @entityId IS NOT NULL BEGIN
            -- -- -- simple get unique name based on plan name and update op window rules table
EXEC AppGetUniqueEntityName 38, @i_planNewName, @i_userId, @entityNewName OUTPUT
            UPDATE APP_OpWindowRule SET description = @entityNewName  WHERE Id = @entityId
            -- -- -- next entry in the table
            SET @entityId = (SELECT MIN(id) FROM #AppPlanUpdateName_tmp__IDs WHERE id > @entityId)
        END
        -- -- prepare temp table for further use
        TRUNCATE TABLE #AppPlanUpdateName_tmp__IDs
    END
    -- update plan associated entities names -- schedule policy
    SET @entityNewName = @i_planNewName + ' - Log'
SET @entityId = ISNULL(CAST(dbo.AppPlanGetEntityValue(@i_planId, ('Log schedule policy'), 2) AS INT), 0);     IF @entityId != 0 EXEC AppGetUniqueEntityName 35, @entityNewName, @i_userId, @entityNewName OUTPUT;     IF @entityId != 0
    BEGIN
        -- -- update schedule policy name
        UPDATE TM_Task SET taskName = @entityNewName  WHERE taskId = @entityId
        -- -- -- update schedule policy description. description should not be unique. simple replace will do
        UPDATE TM_Task SET [description] = REPLACE([description], @currentPlanName, @i_planNewName) WHERE taskId = @entityId
        -- -- -- update subtask names. they should not be unique, so just replace
        UPDATE TM_SubTask SET subTaskName = REPLACE(subTaskName, @currentPlanName, @i_planNewName)  WHERE taskId = @entityId
    END
     -- update plan associated entities names -- windows subclient policy
     SET @entityNewName = @i_planNewName + ' Windows subclient policy'
SET @entityId = ISNULL(CAST(dbo.AppPlanGetEntityValue(@i_planId, ('Subclient policy 2'), 2) AS INT), 0);     IF @entityId != 0 EXEC AppGetUniqueEntityName 65, @entityNewName, @i_userId, @entityNewName OUTPUT;     IF @entityId != 0
     BEGIN
        -- -- updatebackupset name
        UPDATE APP_BackupSetName SET name = @entityNewName WHERE id = @entityId
     END
     -- update plan associated entities names -- linux subclient policy
     SET @entityNewName = @i_planNewName + ' Linux subclient policy'
SET @entityId = ISNULL(CAST(dbo.AppPlanGetEntityValue(@i_planId, ('Subclient policy 3'), 2) AS INT), 0);     IF @entityId != 0 EXEC AppGetUniqueEntityName 65, @entityNewName, @i_userId, @entityNewName OUTPUT;     IF @entityId != 0
     BEGIN
        -- -- updatebackupset name
        UPDATE APP_BackupSetName SET name = @entityNewName WHERE id = @entityId
     END
     -- update plan associated entities names -- mac subclient policy
     SET @entityNewName = @i_planNewName + ' Mac subclient policy'
SET @entityId = ISNULL(CAST(dbo.AppPlanGetEntityValue(@i_planId, ('Subclient policy 4'), 2) AS INT), 0);     IF @entityId != 0 EXEC AppGetUniqueEntityName 65, @entityNewName, @i_userId, @entityNewName OUTPUT;     IF @entityId != 0
     BEGIN
        -- -- update backupset name
        UPDATE APP_BackupSetName SET name = @entityNewName WHERE id = @entityId
     END
     --  update plan associated entities names -- configuration archiving policy
     SET @entityNewName = @i_planNewName + ' archiving policy'
SET @entityId = ISNULL(CAST(dbo.AppPlanGetEntityValue(@i_planId, ('Exchange mailbox archiving policy'), 2) AS INT), 0);     IF @entityId != 0 EXEC AppGetUniqueEntityName 154, @entityNewName, @i_userId, @entityNewName OUTPUT;     IF @entityId != 0
     BEGIN
        -- -- update configuration policy name
        UPDATE APP_ConfigurationPolicy SET policyName = @entityNewName  WHERE policyId = @entityId
     END
     --  update plan associated entities names -- configuration retention policy
     SET @entityNewName = @i_planNewName + ' retention policy'
SET @entityId = ISNULL(CAST(dbo.AppPlanGetEntityValue(@i_planId, ('Exchange mailbox retention policy'), 2) AS INT), 0);     IF @entityId != 0 EXEC AppGetUniqueEntityName 154, @entityNewName, @i_userId, @entityNewName OUTPUT;     IF @entityId != 0
     BEGIN
        -- -- update configuration policy name
        UPDATE APP_ConfigurationPolicy SET policyName = @entityNewName  WHERE policyId = @entityId
     END
     --  update plan associated entities names -- configuration clean-up policy
     SET @entityNewName = @i_planNewName + ' clean-up policy'
SET @entityId = ISNULL(CAST(dbo.AppPlanGetEntityValue(@i_planId, ('Exchange mailbox cleanup policy'), 2) AS INT), 0);     IF @entityId != 0 EXEC AppGetUniqueEntityName 154, @entityNewName, @i_userId, @entityNewName OUTPUT;     IF @entityId != 0
     BEGIN
        -- -- update configuration policy name
        UPDATE APP_ConfigurationPolicy SET policyName = @entityNewName  WHERE policyId = @entityId
     END
     --  update plan associated entities names -- configuration journal policy
     SET @entityNewName = @i_planNewName + ' journal policy'
SET @entityId = ISNULL(CAST(dbo.AppPlanGetEntityValue(@i_planId, ('Exchange mailbox journal policy'), 2) AS INT), 0);     IF @entityId != 0 EXEC AppGetUniqueEntityName 154, @entityNewName, @i_userId, @entityNewName OUTPUT;     IF @entityId != 0
     BEGIN
        -- -- update configuration policy name
        UPDATE APP_ConfigurationPolicy SET policyName = @entityNewName  WHERE policyId = @entityId
     END
     -- update plan associated entities names -- data classification policy
     SET @entityNewName = @i_planNewName + ' data classification policy'
SET @entityId = ISNULL(CAST(dbo.AppPlanGetEntityValue(@i_planId, ('Data classification policy'), 2) AS INT), 0);     IF @entityId != 0 EXEC AppGetUniqueEntityName 154, @entityNewName, @i_userId, @entityNewName OUTPUT;     IF @entityId != 0
     BEGIN
        -- -- update configuration policy name
        UPDATE APP_ConfigurationPolicy SET policyName = @entityNewName  WHERE policyId = @entityId
     END
     -- update plan associated entities names -- content indexing policy
     SET @entityNewName = @i_planNewName + ' content indexing policy'
SET @entityId = ISNULL(CAST(dbo.AppPlanGetEntityValue(@i_planId, ('Content Indexing Policy'), 2) AS INT), 0);     IF @entityId != 0 EXEC AppGetUniqueEntityName 154, @entityNewName, @i_userId, @entityNewName OUTPUT;     IF @entityId != 0
     BEGIN
        -- -- update configuration policy name
        UPDATE APP_ConfigurationPolicy SET policyName = @entityNewName  WHERE policyId = @entityId
     END
     -- update plan associated entities names -- Office 365 Backup policy
     SET @entityNewName = @i_planNewName + ' Office 365 backup policy'
SET @entityId = ISNULL(CAST(dbo.AppPlanGetEntityValue(@i_planId, ('Office 365 backup policy'), 2) AS INT), 0);     IF @entityId != 0 EXEC AppGetUniqueEntityName 154, @entityNewName, @i_userId, @entityNewName OUTPUT;     IF @entityId != 0
     BEGIN
        -- -- update configuration policy name
        UPDATE APP_ConfigurationPolicy SET policyName = @entityNewName  WHERE policyId = @entityId
     END
     -- update plan associated entities names -- Office 365 Cleanup policy
     SET @entityNewName = @i_planNewName + ' Office 365 cleanup policy'
SET @entityId = ISNULL(CAST(dbo.AppPlanGetEntityValue(@i_planId, ('Office 365 cleanup policy'), 2) AS INT), 0);     IF @entityId != 0 EXEC AppGetUniqueEntityName 154, @entityNewName, @i_userId, @entityNewName OUTPUT;     IF @entityId != 0
     BEGIN
        -- -- update configuration policy name
        UPDATE APP_ConfigurationPolicy SET policyName = @entityNewName  WHERE policyId = @entityId
     END
     -- update plan associated entities names -- Office 365 Retention policy
     SET @entityNewName = @i_planNewName + ' Office 365 retention policy'
SET @entityId = ISNULL(CAST(dbo.AppPlanGetEntityValue(@i_planId, ('Office 365 retention policy'), 2) AS INT), 0);     IF @entityId != 0 EXEC AppGetUniqueEntityName 154, @entityNewName, @i_userId, @entityNewName OUTPUT;     IF @entityId != 0
     BEGIN
        -- -- update configuration policy name
        UPDATE APP_ConfigurationPolicy SET policyName = @entityNewName  WHERE policyId = @entityId
     END
     -- update plan associated entities names -- Office 365 Mailbox archiving policy
     SET @entityNewName = @i_planNewName + ' Office 365 mailbox archiving policy'
SET @entityId = ISNULL(CAST(dbo.AppPlanGetEntityValue(@i_planId, ('Office 365 Mailbox archive policy'), 2) AS INT), 0);     IF @entityId != 0 EXEC AppGetUniqueEntityName 154, @entityNewName, @i_userId, @entityNewName OUTPUT;     IF @entityId != 0
     BEGIN
        -- -- update configuration policy name
        UPDATE APP_ConfigurationPolicy SET policyName = @entityNewName  WHERE policyId = @entityId
     END
     -- update plan associated entities names -- Office 365 Mailbox retention policy
     SET @entityNewName = @i_planNewName + ' Office 365 mailbox retention policy'
SET @entityId = ISNULL(CAST(dbo.AppPlanGetEntityValue(@i_planId, ('Office 365 Mailbox retention policy'), 2) AS INT), 0);     IF @entityId != 0 EXEC AppGetUniqueEntityName 154, @entityNewName, @i_userId, @entityNewName OUTPUT;     IF @entityId != 0
     BEGIN
        -- -- update configuration policy name
        UPDATE APP_ConfigurationPolicy SET policyName = @entityNewName  WHERE policyId = @entityId
     END
     -- update plan associated entities names -- Office 365 Mailbox cleanup policy
     SET @entityNewName = @i_planNewName + ' Office 365 mailbox cleanup policy'
SET @entityId = ISNULL(CAST(dbo.AppPlanGetEntityValue(@i_planId, ('Office 365 Mailbox cleanup policy'), 2) AS INT), 0);     IF @entityId != 0 EXEC AppGetUniqueEntityName 154, @entityNewName, @i_userId, @entityNewName OUTPUT;     IF @entityId != 0
     BEGIN
        -- -- update configuration policy name
        UPDATE APP_ConfigurationPolicy SET policyName = @entityNewName  WHERE policyId = @entityId
     END
     -- update plan associated entities names -- features
     SET @entityNewName = @i_planNewName + ' features'
SET @entityId = ISNULL(CAST(dbo.AppPlanGetEntityValue(@i_planId, ('Feature'), 2) AS INT), 0);     IF @entityId != 0 EXEC AppGetUniqueEntityName 120, @entityNewName, @i_userId, @entityNewName OUTPUT;     IF @entityId != 0
     BEGIN
        -- -- update roles name
        UPDATE  UMRoles SET [name]        = @entityNewName,
                            [description] = REPLACE([description], @currentPlanName, @i_planNewName)
        WHERE id = @entityId
     END
     -- update plan associated entities names -- access policy
     SET @entityNewName = @i_planNewName + ' access policy'
SET @entityId = ISNULL(CAST(dbo.AppPlanGetEntityValue(@i_planId, ('Access policy'), 2) AS INT), 0);     IF @entityId != 0 EXEC AppGetUniqueEntityName 120, @entityNewName, @i_userId, @entityNewName OUTPUT;     IF @entityId != 0
     BEGIN
       -- -- update roles name
        UPDATE  UMRoles SET [name]        = @entityNewName,
                            [description] = REPLACE([description], @currentPlanName, @i_planNewName)
        WHERE id = @entityId
     END
     -- update plan associated entities names -- edge drive
     SET @entityNewName = @i_planNewName + ' Edge Drive'
SET @entityId = ISNULL(CAST(dbo.AppPlanGetEntityValue(@i_planId, ('Assgined Edge Drive'), 2) AS INT), 0);     IF @entityId != 0 EXEC AppGetUniqueEntityName 3, @entityNewName, @i_userId, @entityNewName OUTPUT;     IF @entityId != 0
     BEGIN
       -- -- update client name
        UPDATE  APP_Client SET [name] = @entityNewName  WHERE id = @entityId
     END
    -- update plan associated entities names -- replication schedule
    INSERT INTO #AppPlanUpdateName_tmp__IDs
SELECT CAST(_ID AS INT) FROM dbo.SplitIDString((SELECT attrVal FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Replication schedule policy')) B
    SET @entityId = (SELECT MIN(id) FROM #AppPlanUpdateName_tmp__IDs)
    WHILE @entityId IS NOT NULL BEGIN
        SET @entityNewName = @i_planNewName + ' replication'
        -- -- -- simple get unique name based on plan name and update op window rules table
EXEC AppGetUniqueEntityName 69, @i_planNewName, @i_userId, @entityNewName OUTPUT
        UPDATE TM_Task SET taskName = @entityNewName  WHERE taskId = @entityId
        -- -- -- next entry in the table
        SET @entityId = (SELECT MIN(id) FROM #AppPlanUpdateName_tmp__IDs WHERE id > @entityId)
    END
    -- -- prepare temp table for further use
    TRUNCATE TABLE #AppPlanUpdateName_tmp__IDs
    IF @debug != 0 BEGIN
              SELECT 'new plan name', @currentPlanName
UNION SELECT 'new client group',                  (SELECT [name]     FROM APP_ClientGroup         WHERE id =       (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Assigned client group'))
UNION SELECT 'new user group',                    (SELECT [name]     FROM UMGroups                WHERE id =       (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Assigned user group'))
UNION SELECT 'new primary storage policy',        (SELECT [name]     FROM archGroup               WHERE id =       (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Storage policy'))
UNION SELECT 'new log storage policy',            (SELECT [name]     FROM archGroup               WHERE id =       (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Log storage policy'))
UNION SELECT 'new primary schedule policy',       (SELECT taskName   FROM TM_Task                 WHERE taskId =   (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Schedule policy'))
UNION SELECT 'new log schedule policy',           (SELECT taskName   FROM TM_Task                 WHERE taskId =   (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Log schedule policy'))
UNION SELECT 'new subclient policy win',          (SELECT [name]     FROM APP_BackupSetName       WHERE id =       (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Subclient policy 2'))
UNION SELECT 'new subclient policy lin',          (SELECT [name]     FROM APP_BackupSetName       WHERE id =       (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Subclient policy 3'))
UNION SELECT 'new subclient policy mac',          (SELECT [name]     FROM APP_BackupSetName       WHERE id =       (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Subclient policy 4'))
UNION SELECT 'new exchange archiving policy',     (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Exchange mailbox archiving policy'))
UNION SELECT 'new exchange retention policy',     (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Exchange mailbox retention policy'))
UNION SELECT 'new exchange cleanup policy',       (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Exchange mailbox cleanup policy'))
UNION SELECT 'new exchange journal policy',       (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Exchange mailbox journal policy'))
UNION SELECT 'new data classification policy',    (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Data classification policy'))
UNION SELECT 'new features',                      (SELECT [name]     FROM UMRoles                 WHERE id =       (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Feature'))
UNION SELECT 'new access policy',                 (SELECT [name]     FROM UMRoles                 WHERE id =       (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Access policy'))
UNION SELECT 'new edge drive client',             (SELECT [name]     FROM APP_Client              WHERE id =       (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Assgined Edge Drive'))                                                                   --
UNION SELECT 'new content indexing policy',       (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Content Indexing Policy'))
UNION SELECT 'new o365 backup policy',            (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Office 365 backup policy'))
UNION SELECT 'new o365 cleanup policy',           (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Office 365 cleanup policy'))
UNION SELECT 'new o365 retention policy',         (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Office 365 retention policy'))
UNION SELECT 'new o365 mailbox archiving policy', (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Office 365 Mailbox archive policy'))
UNION SELECT 'new o365 mailbox retention policy', (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Office 365 Mailbox retention policy'))
UNION SELECT 'new o365 mailbox cleanup policy',   (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Office 365 Mailbox cleanup policy'))
        SELECT @o_errorCode AS 'output error code', @o_errorMessage AS 'output error message'
        ROLLBACK TRANSACTION
    END
END
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdateName_tmp__IDs') IS NOT NULL DROP TABLE #AppPlanUpdateName_tmp__IDs
RETURN @o_errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanUpdateNameV2')
	delete from GxQscripts where name = 'AppPlanUpdateNameV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateNameV2')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateNameV2'
GO

insert into GXDBVersions values(2, 'AppPlanUpdateNameV2',  '00010001000200140000', 'AppPlanUpdateNameV2', '00010001000200140000')
GO

