

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanUpdateLaptopAssociation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +================================================================================================+
--  |   Procedure:  AppPlanUpdateLaptopAssociation()
--  |
--  | Description:  SP for associating Laptop to a different plan from the currently associated one.
--  |
--  |       Input:  Physical client(laptop) ID, pseudo client id, user id
--  |      Output:  ErrorCode, ErrorString to determine status of the operation
--  |      Return:  xxx
--  |
--  |   Revisions  Author
--  |   ---------  Arvind Lakra
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppPlanUpdateLaptopAssociation')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanUpdateLaptopAssociation <<<'
	drop procedure AppPlanUpdateLaptopAssociation
END
IF EXISTS (select * from GxQscripts where name='AppPlanUpdateLaptopAssociation')
	delete from GxQscripts where name = 'AppPlanUpdateLaptopAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateLaptopAssociation')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateLaptopAssociation'
GO
print '... Creating Procedure: AppPlanUpdateLaptopAssociation'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppPlanUpdateLaptopAssociation
  @i_userId INT,
  @i_localeId INT,
  @xmlString XML OUTPUT,
  @o_errorCode INTEGER OUTPUT,
  @o_errorString VARCHAR(1024) OUTPUT
AS
  DECLARE @errorCode INTEGER
  DECLARE @errorString NVARCHAR(MAX)
-- Flow to be followed
-- User enitity passed should be part of owner group.
--  -- If bUpdateUsersDefaultAssociationToPlan is TRUE, then make default association of plan to user.
-- Current Plan (already associated one) used to activate client should be valid one. If plan is not active or incomplete, then just error out. It should not have been associated at first place.
-- Passed plan id should have proper plan too.
-- We will figure out different set of features in current plan and new plan. Whatever is Delta, we will send worktoken for that to client. Will also update some properties on client.
-- Sample XML
-- <App_ReassociateLaptopClientRequest>
--   <laptopClientInfo bUpdateUsersDefaultAssociationToPlan="1">
--     <newPlan planId="15" />
--     <client clientId="10" />
--     <user userId="2" />
--   </laptopClientInfo>
--   <laptopClientInfo bUseCurrentSetOfOwners="0" bUpdateUsersDefaultAssociationToPlan="1">
--     <newPlan planId="16" />
--     <client clientId="11" />
--     <user userId="3" />
--   </laptopClientInfo>
--   <laptopClientInfo bUseCurrentSetOfOwners="0" bUpdateUsersDefaultAssociationToPlan="1">
--     <newPlan planId="17" />
--     <client clientId="12" />
--     <user userId="4" />
--   </laptopClientInfo>
-- </App_ReassociateLaptopClientRequest>
DECLARE @nowTime INT = dbo.GetUnixTime(GETUTCDATE())
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @errorCode = 100
SET @errorString = N'No client to Process'
BEGIN TRY
    -- First Get Input of all data from XML to table
    DECLARE @inputTbl TABLE(    clientId INT PRIMARY KEY,
                                userId INT,
                                newPlanId INT,
                                bUpdateUsersDefaultAssociationToPlan INT DEFAULT 0,
                                subClientId INT DEFAULT 0,
                                backupSetId INT DEFAULT 0,
                                shouldProcess INT DEFAULT 0)
    DECLARE @respTbl TABLE (clientId INT PRIMARY KEY,
                            errorCode INT,
                            errorString NVARCHAR(MAX))
    DECLARE @propTbl  TABLE (   clientId INT PRIMARY KEY,
                                currentPlanId INT DEFAULT 0)
    DECLARE @planPropTbl TABLE( planId INT,
                                storagePolicyId INT DEFAULT 0,
                                subclientPolicyIdWin INT DEFAULT 0,
                                subclientPolicyIdMac INT DEFAULT 0,
                                subclientPolicyIdLinux INT DEFAULT 0,
                                planUserGroup INT DEFAULT 0,
                                featureRoleId INT DEFAULT 0,
                                isDLPEnabled INT DEFAULT 0,
                                isEdgeDriveEnabled INT DEFAULT 0,
                                isArchivingEnabled INT DEFAULT 0,
								isForcedArchiving INT DEFAULT 0,
								isCloudModeEnabled INT DEFAULT 0)
	DECLARE @workQueueParamSCG NVARCHAR(MAX)
	-- Fetch input data into table
    INSERT INTO @inputTbl ( clientId, userId, newPlanId, bUpdateUsersDefaultAssociationToPlan)
	SELECT ce.value('@clientId', 'INT'), ue.value('@userId', 'INT'), pe.value('@planId', 'INT'), ref.value('@bUpdateUsersDefaultAssociationToPlan', 'INT') FROM @xmlString.nodes('App_ReassociateLaptopClientRequest/laptopClientInfo') R ( ref )
        CROSS APPLY ref.nodes('./user') U(ue)
        CROSS APPLY ref.nodes('./newPlan') P(pe)
		CROSS APPLY ref.nodes('./client') C(ce)
    -- Get current plan for that laptop.
    -- Also check if it is a valid one
    INSERT INTO @propTbl (clientId, currentPlanId)
    SELECT IT.clientId, ACP.attrVal FROM @inputTbl IT
    INNER JOIN APP_ClientProp ACP WITH (NOLOCK)
ON ACP.componentNameId=IT.clientId AND ACP.attrName=N'Associated Plan'
    INNER JOIN APP_PLAN AP WITH (NOLOCK)
ON CONVERT(NVARCHAR(64),AP.id)=ACP.attrVal AND (AP.subtype=33554439)
AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
    -- Update input table based on whether all provided entities are fine or not.
    -- Provided client is laptop
    -- Provided Plan is valid
    -- Provided user is owner
    -- Previous plan is also valid
    -- Also there should be only 1 subclient for that laptop
    UPDATE IT
		SET IT.shouldProcess = 1, IT.subClientId=SC.scId, IT.backupSetId=SC.bsId
	FROM @inputTbl IT
	INNER JOIN APP_Client AC WITH (NOLOCK)
ON AC.id=IT.clientId AND AC.status&0x1000<>0
	INNER JOIN App_Plan AP WITH (NOLOCK)
ON AP.id=IT.newPlanId AND (AP.subtype=33554439) AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
    INNER JOIN @propTbl PT
        ON (IT.clientId=PT.clientId) AND (PT.currentPlanId IS NOT NULL) AND (PT.currentPlanId <> 0)
    INNER JOIN
                ( SELECT AAP.clientId AS cId , AAP.id as scId, AAP.backupset AS bsId FROM APP_Application AAP
INNER JOIN APP_BackupSetName BS ON BS.id = AAP.backupset AND (BS.status & 0x00008) <> 0
WHERE (AAP.subclientStatus & 0x00008) <> 0
                ) SC
        ON SC.cId = IT.clientId
	WHERE dbo.IsClientOwner(IT.clientId,IT.userId) = 1
    INSERT INTO @planPropTbl(planId, storagePolicyId, subclientPolicyIdWin, subclientPolicyIdLinux, subclientPolicyIdMac, featureRoleId, planUserGroup, isForcedArchiving, isCloudModeEnabled)
    SELECT id,
dbo.AppPlanGetEntityValueV2(id, 'Storage policy',  default),
dbo.AppPlanGetEntityValueV2(id, 'Subclient policy 2', default),
dbo.AppPlanGetEntityValueV2(id, 'Subclient policy 3', default),
dbo.AppPlanGetEntityValueV2(id, 'Subclient policy 4', default),
dbo.AppPlanGetEntityValueV2(id, 'Feature',  default),
dbo.AppPlanGetEntityValueV2(id, 'Assigned user group',  default),
dbo.AppPlanGetEntityValueV2(id, 'Forced Archiving',  default),
dbo.AppPlanGetEntityValueV2(id, 'Cloud Mode Enabled',  default)
     FROM App_Plan  WITH (NOLOCK)
                    WHERE id IN (
                                SELECT DISTINCT TBL._ID FROM
                                    (
                                        SELECT currentPlanId AS _ID FROM @propTbl
                                        UNION
                                        SELECT newPlanId AS _ID FROM @inputTbl
                                     ) TBL
                             )
     UPDATE  PPT
	    SET PPT.isDLPEnabled=(SELECT CASE WHEN permissionDLP.id IS NOT NULL THEN 1 ELSE 0 END)
     FROM @planPropTbl PPT
     INNER JOIN UMRolesPermissions roleToPermissionMap WITH (NOLOCK)
		    ON roleToPermissionMap.roleId=PPT.featureRoleId
    INNER JOIN UMPermissions permissionDLP WITH (NOLOCK)
		    ON permissionDLP.id=roleToPermissionMap.permissionId AND permissionDLP.permissionName = 'DLP'
     UPDATE  PPT
	    SET PPT.isArchivingEnabled=(SELECT CASE WHEN permissionARCHIVE.id IS NOT NULL THEN 1 ELSE 0 END)
     FROM @planPropTbl PPT
     INNER JOIN UMRolesPermissions roleToPermissionMap WITH (NOLOCK)
		    ON roleToPermissionMap.roleId=PPT.featureRoleId
     INNER JOIN UMPermissions permissionARCHIVE WITH (NOLOCK)
		    ON permissionARCHIVE.id=roleToPermissionMap.permissionId AND permissionARCHIVE.permissionName = 'Archiving'
	 AND PPT.isForcedArchiving = 1
     UPDATE  PPT
	    SET PPT.isEdgeDriveEnabled=(SELECT CASE WHEN permissionEDGEDRIVE.id IS NOT NULL THEN 1 ELSE 0 END)
	    FROM @planPropTbl PPT
     INNER JOIN UMRolesPermissions roleToPermissionMap WITH (NOLOCK)
		    ON roleToPermissionMap.roleId=PPT.featureRoleId
     INNER JOIN UMPermissions permissionEDGEDRIVE WITH (NOLOCK)
		    ON permissionEDGEDRIVE.id=roleToPermissionMap.permissionId AND permissionEDGEDRIVE.permissionName = 'Edge Drive'
    DECLARE @profileId INT
    DECLARE @schedulePolicyId INT = 0
    DECLARE @storagePolicyId INT = 0
    DECLARE @subclientPolicyId INT = 0
    DECLARE @pushDLPConfig INT = 0
    DECLARE @pushInstallArchiving INT = 0
    DECLARE @clientInstallPkgReq XML
    DECLARE @clientInstallPkgResp XML
    DECLARE @userCentric INTEGER
    DECLARE @backupsetid INT
    DECLARE @scid INT = 0
    DECLARE @pseudoclientId INT = 0
    DECLARE @physicalClientId INT =0
    DECLARE @userid INT =0
	DECLARE @oldPlancloudModeEnabled INT =0
	DECLARE @newPlancloudModeEnabled INT =0
    -- To work on any feature -
    -- @feature_FeatureName
    -- Possible values -
    -- 0 - No action
    -- 1 - Configure this feature for client
    -- 2 - Remove this feature for client
    DECLARE @feature_DLP INT = 0
    DECLARE @feature_EDGEDRIVE INT = 0
    DECLARE @feature_ARCHIVING INT = 0
    DECLARE @oldPlanId INT = 0
    DECLARE @type INT
    DECLARE @workQOutPutTbl table (errCode INT,errString NVARCHAR(MAX))
    DECLARE @bUpdateUsersDefaultAssociationToPlan INT = 0
    DECLARE @tempRC table (rc INT)
    DECLARE @planUserGroup INT = 0
    DECLARE @cId INT = (SELECT MIN(clientId) FROM @inputTbl WHERE shouldProcess=1)
    WHILE @cId IS NOT NULL
    BEGIN
        -- We have to call relevant API here.
	    SET @profileId = 0
	    SET @schedulePolicyId = 0
	    SET @storagePolicyId = 0
	    SET @subclientPolicyId = 0
	    SET @pushDLPConfig = 0
	    SET @pushInstallArchiving = 0
	    SET @clientInstallPkgReq =''
	    SET @clientInstallPkgResp =''
	    SET @userCentric = 0
        SET @backupsetid=0
        SET @scid = 0
        SET @pseudoclientId = 0
        SET @physicalClientId =0
        SET @userid =0
        SET @feature_DLP = 0
        SET @feature_EDGEDRIVE = 0
        SET @feature_ARCHIVING = 0
        SET @oldPlanId = 0
        SET @bUpdateUsersDefaultAssociationToPlan = 0
        -- Default Value once we enter the loop
        SET @errorCode = 0
        SET @errorString = N''
        SELECT
                @profileId=INPUT.newPlanId, @scid=INPUT.subClientId,  @backupsetid=INPUT.backupSetId,
                @pseudoclientId=INPUT.clientId, @userid=INPUT.userId ,
                @oldPlanId=PROP.currentPlanId,
                @bUpdateUsersDefaultAssociationToPlan=INPUT.bUpdateUsersDefaultAssociationToPlan
            FROM @inputTbl INPUT
            INNER JOIN @propTbl PROP
                ON INPUT.clientId=PROP.clientId
        WHERE INPUT.clientId=@cId
SET @type = ISNULL((SELECT attrval FROM APP_ClientProp WITH (NOLOCK) WHERE attrname = 'Ida Type'
	                                    AND componentNameId = @pseudoClientId AND modified = 0),4)
        -- Get all the applicable values for add and remvoe of features. Make sure code is optimised enough
        SELECT  @storagePolicyId = currPlan.storagePolicyId,
                @subclientPolicyId = IIF(@type = 2, currPlan.subclientPolicyIdWin, IIF(@type=3, currPlan.subclientPolicyIdLinux, currPlan.subclientPolicyIdMac)),
                @planUserGroup=currPlan.planUserGroup,
                @feature_DLP = (CASE WHEN oldPlan.isDLPEnabled=currPlan.isDLPEnabled then 0
						                WHEN currPlan.isDLPEnabled=1  THEN 1
						                ELSE 2 END),
                @feature_EDGEDRIVE = (CASE WHEN oldPlan.isEdgeDriveEnabled=currPlan.isEdgeDriveEnabled then 0
						                WHEN currPlan.isEdgeDriveEnabled=1  THEN 1
						                ELSE 2 END),
                @feature_ARCHIVING = (CASE WHEN oldPlan.isArchivingEnabled=currPlan.isArchivingEnabled then 0
						                WHEN currPlan.isArchivingEnabled=1  THEN 1
						                ELSE 2 END),
				@newPlancloudModeEnabled = currPlan.isCloudModeEnabled,
				@oldPlancloudModeEnabled = oldPlan.isCloudModeEnabled
         FROM @planPropTbl oldPlan INNER JOIN @planPropTbl currPlan ON currPlan.planId=@profileId
          WHERE oldPlan.planId=@oldPlanId
        -- If client is user centric, then simply get the physical client id else pseudo clientid is same as physical client id.
        SET @physicalClientId = ISNULL( (SELECT CONVERT(INT,ACP1.attrVal) FROM APP_ClientProp ACP1 WITH (NOLOCK)
	                                        INNER JOIN APP_ClientProp ACP2 WITH (NOLOCK)
ON ACP1.componentNameId=ACP2.componentNameId AND ACP2.attrName=N'User Centric Client' AND ACP2.attrVal=N'1'
WHERE ACP1.componentNameId=@cId AND ACP1.attrName=N'Physical Client Id'), @pseudoclientId)
        --Set DLP properties on client if DLP feature is selected in Plan.
	    IF @feature_DLP=1   -- Add Feature
        BEGIN
		    IF EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentNameId = @pseudoclientId AND attrName = 'enableDLP' AND modified = 0)
			    UPDATE APP_ClientProp SET attrVal = '1' WHERE componentNameId = @pseudoclientId AND attrName = 'enableDLP' AND attrVal != '1' AND modified = 0
		    ELSE
			    INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			    VALUES(@pseudoclientId, 'enableDLP', 2, '1', @nowTime, 0 ,0)
		    IF EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentNameId = @pseudoclientId AND attrName = 'dlpEnableAutomaticDecryption' AND modified = 0)
			    UPDATE APP_ClientProp SET attrVal = '0' WHERE componentNameId = @pseudoclientId AND attrName = 'dlpEnableAutomaticDecryption' AND attrVal != '0' AND modified = 0
		    ELSE
			    INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			    VALUES(@pseudoclientId, 'dlpEnableAutomaticDecryption', 2, '0', @nowTime, 0 ,0)
		    IF EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentNameId = @pseudoclientId AND attrName = 'dlpEnableClientKeys' AND modified = 0)
			    UPDATE APP_ClientProp SET attrVal = '1' WHERE componentNameId = @pseudoclientId AND attrName = 'dlpEnableClientKeys' AND attrVal != '1' AND modified = 0
		    ELSE
			    INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			    VALUES(@pseudoclientId, 'dlpEnableClientKeys', 2, '1', @nowTime, 0 ,0)
		    IF EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentNameId = @pseudoclientId AND attrName = 'dlpStolen' AND modified = 0)
			    UPDATE APP_ClientProp SET attrVal = '0' WHERE componentNameId = @pseudoclientId AND attrName = 'dlpStolen' AND attrVal != '0' AND modified = 0
		    ELSE
			    INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			    VALUES(@pseudoclientId, 'dlpStolen', 2, '0', @nowTime, 0 ,0)
		    IF EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentNameId = @pseudoclientId AND attrName = 'dlpMinFileAgeMins' AND modified = 0)
			    UPDATE APP_ClientProp SET attrVal = '5' WHERE componentNameId = @pseudoclientId AND attrName = 'dlpMinFileAgeMins' AND attrVal != '5' AND modified = 0
		    ELSE
			    INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			    VALUES(@pseudoclientId, 'dlpMinFileAgeMins', 10, '5', @nowTime, 0 ,0)
		    IF EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentNameId = @pseudoclientId AND attrName = 'dlpScanIntervalMins' AND modified = 0)
			    UPDATE APP_ClientProp SET attrVal = '15' WHERE componentNameId = @pseudoclientId AND attrName = 'dlpScanIntervalMins' AND attrVal != '15' AND modified = 0
		    ELSE
			    INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			    VALUES(@pseudoclientId, 'dlpScanIntervalMins', 10, '15', @nowTime, 0 ,0)
		    IF EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentNameId = @pseudoclientId AND attrName = 'dlpUnlockMethod' AND modified = 0)
			    UPDATE APP_ClientProp SET attrVal = '0' WHERE componentNameId = @pseudoclientId AND attrName = 'dlpUnlockMethod' AND attrVal != '0' AND modified = 0
		    ELSE
			    INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			    VALUES(@pseudoclientId, 'dlpUnlockMethod', 10, '0', @nowTime, 0 ,0)
		    IF EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentNameId = @pseudoclientId AND attrName = 'dlpContents' AND modified = 0)
			    UPDATE APP_ClientProp SET attrVal = ';' WHERE componentNameId = @pseudoclientId AND attrName = 'dlpContents' AND attrVal != ';' AND modified = 0
		    ELSE
			    INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			    VALUES(@pseudoclientId, 'dlpContents', 1, ';', @nowTime, 0 ,0)
		    IF EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentNameId = @pseudoclientId AND attrName = 'dlpFilters' AND modified = 0)
			    UPDATE APP_ClientProp SET attrVal = '**\.edgedrive.cache;*.app;*.bat;*.conf;*.dll;*.dmg;*.exe;*.ini;*.lnk;*.plist;*.rc;*.tmp;.DS_Store;.localized;~$*;' WHERE componentNameId = @pseudoclientId AND attrName = 'dlpFilters' AND attrVal != '**\.edgedrive.cache;*.app;*.bat;*.conf;*.dll;*.dmg;*.exe;*.ini;*.lnk;*.plist;*.rc;*.tmp;.DS_Store;.localized;~$*;' AND modified = 0
		    ELSE
			    INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			    VALUES(@pseudoclientId, 'dlpFilters', 1, '**\.edgedrive.cache;*.app;*.bat;*.conf;*.dll;*.dmg;*.exe;*.ini;*.lnk;*.plist;*.rc;*.tmp;.DS_Store;.localized;~$*;', @nowTime, 0 ,0)
		    SET @pushDLPConfig = 1
	    END
        ELSE IF @feature_DLP=2   -- Remove Feature
        BEGIN
            UPDATE APP_ClientProp SET attrVal = '0' WHERE componentNameId = @pseudoclientId AND attrName = 'enableDLP' AND modified=0
            SET @pushDLPConfig = 2
        END
	    -- Archiving Feature Push Install Software
	    IF @feature_ARCHIVING=1
        BEGIN
DECLARE @archivingPkgId INT = 753  /*WIN INSTALL PACKAGE ID*/
		    DECLARE @i_osType INT = 1 /* 1-Windows, 2-UNIX*/
		    DECLARE @pkgInstalled INT = 0
		    IF EXISTS( SELECT 1 FROM simInstalledPackages
					    WHERE simPackageID = @archivingPkgId AND ClientId = @physicalClientId ) OR dbo.scgGetClientOSType(@physicalClientId) != @i_osType
			    SET @pushInstallArchiving = 0
		    ELSE
		    BEGIN
			    SET @pushInstallArchiving = 1
			    SET @clientInstallPkgReq = (SELECT 0 AS'@checkAndRemoveInstalledPackage',(
									    SELECT @physicalClientId AS 'client/@clientId', @archivingPkgId AS 'packageInfoList/@packageId'
									    FOR XML PATH('reqList'), TYPE)
									    FOR XML PATH('JobManager_ClientPackageReqList'), TYPE)
		    END
            UPDATE APP_SubClientProp SET modified= @nowTime WHERE componentNameId = @scId
		        AND attrName = 'Is Archive Retention Mode Enabled' AND cs_attrName = CHECKSUM(N'Is Archive Retention Mode Enabled') AND modified = 0
		    INSERT INTO APP_SubClientProp
		    VALUES( @scId, N'Is Archive Retention Mode Enabled' , 7, 1 , @nowTime, 0, 0)
		    UPDATE APP_SubClientProp SET modified= @nowTime WHERE componentNameId = @scId
		        AND attrName = 'User deleted stubs expiration days' AND cs_attrName = CHECKSUM(N'User deleted stubs expiration days') AND modified = 0
		    INSERT INTO APP_SubClientProp
		    VALUES( @scId, N'User deleted stubs expiration days', 7, 730 , @nowTime, 0, 0)
		    UPDATE APP_SubClientProp SET modified= @nowTime WHERE componentNameId = @scId
		        AND attrName = 'Is Turbo Subclient' AND cs_attrName = CHECKSUM(N'Is Turbo Subclient') AND modified = 0
		    INSERT INTO APP_SubClientProp
		    VALUES( @scId, N'Is Turbo Subclient' , 7, 1 , @nowTime, 0, 0)
		    INSERT INTO APP_IDAProp
		    SELECT AG.id,N'Enable Archive' , 2, 1 , @nowTime, 0, 0
				    FROM APP_IDAName AG
				    WHERE AG.appTypeId IN (
					    select appTypeId from APP_AppTypeGroupAssoc where appGroupId IN (57, 34) /*APPGRP_WindowsFileSystemIDA, APPGRP_UnixFileSystem*/
				    )
				    AND AG.clientId = @physicalClientId
		    INSERT INTO APP_IDAProp
		    SELECT AG.id,N'Use Archiver Driver' , 2, 1 , @nowTime, 0, 0
				    FROM APP_IDAName AG
				    WHERE AG.appTypeId IN (
					    select appTypeId from APP_AppTypeGroupAssoc where appGroupId = 34 /*APPGRP_UnixFileSystem*/
				    )
				    AND AG.clientId = @physicalClientId
	    END
	    --associate subclient policy to the default backupset
	    DECLARE @currenttime INT = [dbo].getunixtime(GetUTCDate())
	    -- Below 2 statements is due to the bug in AppAssocSubClientPolicy. It create 2 duplicate entry in db during re-association.
		UPDATE APP_SubClientProp
			SET modified = @currenttime
		WHERE componentNameId = @scId AND modified = 0 AND attrName='Associated subclient Policy' AND cs_attrName = CHECKSUM(N'Associated subclient Policy')
		UPDATE APP_BackupSetProp
			SET modified = @currenttime
		WHERE componentNameId = @backupsetid AND modified = 0 AND attrName='Associated subclient Policy'
	    DELETE FROM @tempRC
        INSERT INTO @tempRC
	    EXEC AppAssocSubClientPolicy @backupsetid,@subclientPolicyId,@currenttime
	    IF (SELECT rc from @tempRC) <> 1
	    BEGIN
            -- Wrong for SPB
		    -- GENERATE ERROR
		    SET @errorCode = 2
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2844 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @i_localeId)
		    GOTO MOVE_NEXT
	    END
	-- Get StoragePolicy from the plan rules (if any) and update App_application table
	-- Update only if PlanRuleEvaluateStoragePolicyForEntityV2 returns other than plan's default storagePolicy.
	DECLARE @policyId INT = 0
EXEC dbo.PlanRuleEvaluateStoragePolicyForEntityV2 @profileId, @physicalClientId, 3, @userId, @i_localeId, 0, @policyId OUTPUT, @errorCode OUTPUT, @errorString OUTPUT
	IF (@errorCode <> 0) OR (@policyId = 0)
	BEGIN
		GOTO MOVE_NEXT
	END
	IF @policyId <> @storagePolicyId -- Not equal means it is elastic plan
		UPDATE App_Application SET dataArchGrpId = @policyId, logArchGrpID = @policyId WHERE id = @scId
	    -- if physical client has same owner set, Remove the current owner
	    --if new or old style clear from both tables only for the physical client
	    IF @pseudoClientId <> @physicalClientId
	    BEGIN
		    IF (dbo.isNewSecurity() = 0)
			    DELETE FROM UMUserandGroupEntityAssociation
			    WHERE objectid=@physicalClientId AND entityType = 2009
			    and userId = @userid
		    ELSE
			    DELETE FROM UMOwners WHERE entityId=@physicalClientId AND entityType = 3
			    and userOrGroupId = @userid AND isUser = 1
	    END
	    -- MR : 164299 - Push DLP workqueue if enabled via plan.
		-- DLP was enabled in previous plan but not in new plan. So, we still need to push workqueue for the same
	    IF (@pushDLPConfig = 1) OR (@pushDLPConfig = 2)
	    BEGIN
		    DELETE FROM @workQOutPutTbl
		    INSERT INTO @workQOutPutTbl
		    EXEC AppWorkQueueSubmitRequest 11, 0, 0, @physicalClientId, 0, '' -- WORK_TOKEN_DLP_PUSH_CONFIG
		    SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
			IF @errorCode <> 0
				GOTO MOVE_NEXT
	    END
	    IF @pushInstallArchiving = 1
	    BEGIN
			EXEC JMPushPackagesWithOutputArg @clientInstallPkgReq, @clientInstallPkgResp output
	    END
        ELSE
        BEGIN
        	-- Adding this check so that two OSC Tokens don't get pushed in case of Archiving Feature enabled. JMPushPackages Code already pushes for this.
            --Push OSC token
            DELETE FROM @workQOutPutTbl
		    INSERT INTO @workQOutPutTbl
		    EXEC AppWorkQueueSubmitRequest 4, 0, 0, @physicalClientId, 0, '' -- WORK_TOKEN_OSC
		    SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
			IF @errorCode <> 0
				GOTO MOVE_NEXT
        END
        DELETE FROM @workQOutPutTbl
        -- Update feature list on client.
        DECLARE @workQueueXML XML = ''
        DECLARE @workQueueParam NVARCHAR(MAX) = ''
        DECLARE @activateClientResp NVARCHAR(MAX)
        IF @pseudoClientId = @physicalClientId
        BEGIN
            SET @activateClientResp ='<App_ActivateClientResp activatedMode="1"/>'
        END
        ELSE
        BEGIN
            SET @activateClientResp ='<App_ActivateClientResp activatedMode="2"/>'
        END
        SET @workQueueXML = (   SELECT
                                (SELECT @activateClientResp AS '@activateClientResponse',
                                    ( SELECT CASE
										WHEN @feature_EDGEDRIVE = 1 THEN
                                        (  SELECT '1' AS '@enable',  --SYNC_PAUSED
                                                '1' AS '@featureType'-- EDGE_DRIVE
                                                FOR XML PATH('featureDetails'), TYPE
                                        )
                                        ELSE NULL
                                        END
                                    ),
                                    ( SELECT CASE
										WHEN @feature_ARCHIVING = 1 THEN
                                        (  SELECT '1' AS '@enable',  --SYNC_PAUSED
                                                '6' AS '@featureType'-- ARCHIVING
                                                FOR XML PATH('featureDetails'), TYPE
                                        )
										WHEN @feature_ARCHIVING = 2 THEN
                                        (  SELECT '0' AS '@enable',  --SYNC_PAUSED
                                                '6' AS '@featureType'-- ARCHIVING
                                                FOR XML PATH('featureDetails'), TYPE
                                        )
										ELSE NULL
                                        END
                                    ),
                                    ( SELECT CASE
										WHEN @feature_DLP = 1 THEN
                                        (  SELECT '1' AS '@enable',  --SYNC_PAUSED
                                                '5' AS '@featureType'-- DLP
                                                FOR XML PATH('featureDetails'), TYPE
                                        )
										WHEN @feature_DLP = 2 THEN
                                        (  SELECT '0' AS '@enable',  --SYNC_PAUSED
                                                '5' AS '@featureType'-- DLP
                                                FOR XML PATH('featureDetails'), TYPE
                                        )
										ELSE NULL
                                        END
                                    ),
                                    (
                                        SELECT CASE
                                            WHEN @pseudoClientId = @physicalClientId THEN
                                                (
                                                    SELECT 'AllUsers' AS '@userName' FOR XML PATH('user'),TYPE
                                                )
                                            ELSE
                                                (
                                                    SELECT U.login AS '@userName', id AS '@userId'
                                                        FROM UMUSers U WHERE U.id = @userid
                                                    FOR XML PATH('user'),TYPE
                                                )
                                        END
                                    )
                                FOR XML PATH('userFeatureList'), TYPE)
                                FOR XML PATH('App_UpdateFeatureList'), TYPE
                            )
                 SET @workQueueParam = CAST(@workQueueXML AS NVARCHAR(MAX))
                --Push token param on addition of new feature list
                INSERT INTO @workQOutPutTbl
                EXEC AppWorkQueueSubmitRequest 28/*WORK_TOKEN_FEATURE_LIST*/, 0, 0, @physicalClientId, 0, @workQueueParam
                SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
				IF @errorCode <> 0
					GOTO MOVE_NEXT
UPDATE APP_ClientProp SET attrval=@profileId WHERE componentNameId=@pseudoclientId AND attrname='Associated Plan'
                IF @@ROWCOUNT=0
                BEGIN
                    INSERT INTO APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@pseudoclientId, 'Associated Plan', 7, @profileId, @nowTime, 0)
                END
        -- If requested , then also update user default plan association
        --IF @bUpdateUsersDefaultAssociationToPlan=1
        --BEGIN
            -- First get if user is actually associated to some plan
DECLARE @currPlanId INT  = (SELECT attrVal FROM UMUsersProp WHERE componentNameId=@userid AND attrname='Associated Plan' AND modified=0)
			IF (@currPlanId IS NOT NULL) AND (@currPlanId>0)
            BEGIN
                -- GET Plan User Group. Then remove this user from current plan user group and change modfied to 0 for this property
DECLARE @oldPlanUserGroupId INT = dbo.AppPlanGetEntityValueV2(@currPlanId, 'Assigned user group',  default)
                DELETE FROM UMUserGroup WHERE userId = @userid AND groupId = @oldPlanUserGroupId
            END
            -- We have to do this step, so that any user whose laptop was migrated to this specific plan should keep using it.
            -- Else we will have below case
            -- User A activated laptop with planA. User was part of Group A (associated to Plan A) and Group B (associated to Plan B). Top 1 gave us plan of Group A.
            -- Now, we migrated Group B to plan C, in which we migrated user laptop to Plan C. If we don't add this property then new laptop activation for User A will still be from Plan A (getting reference from Group A)
            -- As of now, updating user plan property and adding user to plan user group
UPDATE UMUsersProp SET attrval=@profileId WHERE componentNameId=@userid AND attrname='Associated Plan' AND modified=0
            IF @@ROWCOUNT=0
            BEGIN
                INSERT INTO UMUsersProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@userid, 'Associated Plan', 7, @profileId, @nowTime, 0)
            END
            IF NOT EXISTS (SELECT userId FROM UMUserGroup WHERE userId = @userid AND groupId = @planUserGroup)
            BEGIN
                INSERT INTO UMUserGroup (userId, groupId, flag) VALUES(@userid, @planUserGroup, 0)
            END
			------------ BEGIN MR 292633 [Set Cloud mode for laptop after plan migration]
		/*
		 old	new		convert
		 1		0		Yes
		 0		1		Yes
		 1		1		No
		 0		0		No
		 0		NULL	No
		 1		NULL	Yes
		 NULL	0		Yes
		 NULL	1		Yes
		 NULL	NULL	No
		 cannot convert NULL to 0 since we will miss (NULL, 0) case
		*/
		IF @newPlancloudModeEnabled IS NULL
		BEGIN
			SET @newPlancloudModeEnabled = 0
		END
		IF @oldPlancloudModeEnabled IS NULL
		BEGIN
			SET @oldPlancloudModeEnabled = 0
		END
		IF @newPlancloudModeEnabled != @oldPlancloudModeEnabled
		BEGIN
			EXEC AppPlanSetCloudLaptop @profileId, @i_userId, @cId, @newPlancloudModeEnabled, @errorCode OUTPUT, @errorString OUTPUT
		END
		------------END MR 292633 [Set Cloud mode for laptop after plan migration]
		    -- Refresh to associate the client to the smart client group.
			--Push work token to refresh smart client group
			SET @workQueueParamSCG = '<App_ProcessSCGUpdate><processinginstructioninfo><user userId="' + cast(@i_userId as nvarchar(max)) + '"/></processinginstructioninfo></App_ProcessSCGUpdate>'
			INSERT INTO @workQOutPutTbl
			EXEC AppWorkQueueSubmitRequest 29, 0, 0, @pseudoclientId, 0, @workQueueParamSCG -- WORK_TOKEN_SCG_UPDATE_CLIENT
		    SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
        --END
        MOVE_NEXT:
        INSERT INTO @respTbl
        SELECT @cId, @errorCode, @errorString
		--Auditing
		DECLARE @opMsgId INTEGER
		DECLARE @opEvMsgId          INTEGER
		DECLARE @opId               INTEGER
		DECLARE @paramMsgId         INTEGER
		DECLARE @paramData          NVARCHAR(MAX)
		DECLARE @clientName         NVARCHAR(255)
		DECLARE @currentPlanName    NVARCHAR(255)
		DECLARE @oldPlanName        NVARCHAR(255)
SET @opMsgId = (586 | (CAST(POWER(2, 24) AS BIGINT) * 84))
		SET @clientName = (SELECT name FROM APP_Client WHERE id=@cId)
		SET @currentPlanName = (SELECT name FROM App_Plan WHERE id=@profileId)
		SET @oldPlanName = ISNULL((SELECT name FROM App_Plan WHERE id=@oldPlanId),'')
		EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
		IF @errorCode = 0
		BEGIN
SET @paramMsgId = (1604 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		END
		ELSE
		BEGIN
SET @paramMsgId = (1603 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		END
        -- SET GUI AUDIT PARAMETER
        EXEC EvGuiAuditSetParamData @opId, @clientName, 0
        EXEC EvGuiAuditSetParamData @opId, @currentPlanName, 0
		EXEC EvGuiAuditSetParamData @opId, @oldPlanName, 0
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
        -- Details for next client to process
        SELECT @cId = MIN(clientId) FROM @inputTbl WHERE (clientId > @cId) AND  (shouldProcess=1)
    END
    IF EXISTS(SELECT TOP 1 * FROM @respTbl WHERE errorCode <> 0)
    BEGIN
        SET @errorCode = 1
        SET @errorString = N'Failed to process atleast one client.'
    END
    SET @xmlString = (SELECT
                        (SELECT
                            (SELECT errorCode AS '@errorCode', errorString AS '@errorMessage'  FOR XML PATH('error'),TYPE),
                            (SELECT clientId AS '@clientId' FOR XML PATH('client'), TYPE)
                            FROM @respTbl FOR XML PATH('laptopReassociationResponse'),TYPE),
                            (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'  FOR XML PATH('error'),TYPE)
                        FOR XML PATH('App_ReassociateLaptopClientResponse'),TYPE)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = 'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
    SET @xmlString = (SELECT @errorCode AS '@errorCode',
                            @errorString AS '@errorMessage'
                    FOR XML PATH ('error'), ROOT('App_ReassociateLaptopClientResponse'))
END  CATCH
GENERATE_OUTPUT:
    SET @o_errorCode=@errorCode
    SET @o_errorString=@errorString
	--Do not select here as this will not work when another sp is calling this sp.
	--SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanUpdateLaptopAssociation')
	delete from GxQscripts where name = 'AppPlanUpdateLaptopAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateLaptopAssociation')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateLaptopAssociation'
GO

insert into GXDBVersions values(2, 'AppPlanUpdateLaptopAssociation',  '00000000000000000000', 'AppPlanUpdateLaptopAssociation', '00000000000000000000')
GO

