

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanUpdateFailureReasons.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanUpdateFailureReasons.sp,v $ $Id: AppPlanUpdateFailureReasons.sp,v 1.1.2.1 2019/05/08 14:40:32 alakra Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanUpdateFailureReasons')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanUpdateFailureReasons <<<'
	drop procedure AppPlanUpdateFailureReasons
END
IF EXISTS (select * from GxQscripts where name='AppPlanUpdateFailureReasons')
	delete from GxQscripts where name = 'AppPlanUpdateFailureReasons'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateFailureReasons')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateFailureReasons'
GO
print '... Creating Procedure: AppPlanUpdateFailureReasons'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanUpdateFailureReasons
  @i_userId INT,
  @i_localeId INT,
  @i_planId INT,
  @i_planName NVARCHAR(1024),
  @x_xmlData XML
AS
    -- SET NOCOUNT ON added to prevent extra result sets from
    -- interfering with SELECT statements.
    SET NOCOUNT ON
    -- as the very first step make sure that this sp gets executed in context of App_PlanUpdateV2
    -- -- App_PlanUpdateV2 creates multiple temporary tables. two of them : #AppPlanUpdate_tmp__IdsSet and #AppPlanUpdate_tmp__ExecutionErrors will be used
    -- -- by this sp. verify their existence. There is no need to continue if they do not exist
    IF (OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__IdsSet') IS NULL)  OR (OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__ExecutionErrors') IS NULL)
        THROW 50001, 'Stored procedure must be executed in context of App_PlanUpdateV2', 1
    DECLARE @errorCode      INT = 0
    DECLARE @errorString    NVARCHAR(MAX) = NULL
	DECLARE @currentTime     INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
	DECLARE @indexServerFailureReasonReq NVARCHAR(1024)
	SELECT @indexServerFailureReasonReq = ref.value('@errorMessage', 'NVARCHAR(1024)')
FROM @x_xmlData.nodes('Api_UpdatePlanReq/errors/status') R ( ref ) WHERE ref.value('../@planEntity', 'INT')=65540
DECLARE @indexServerFailureReasonDB NVARCHAR(1024) = ISNULL(dbo.AppPlanGetEntityValueV2(@i_planId, 'Analytics Index Server failure reason', 0), '')
DECLARE @indexServerIdDB INT = ISNULL(dbo.AppPlanGetEntityValueV2(@i_planId, 'Analytics Index Server Id', 0), 0)
	IF (@indexServerIdDB > 0)
	BEGIN
		IF (@indexServerFailureReasonDB <> '')
		BEGIN
			-- Change modified value of error
DELETE FROM APP_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Analytics Index Server failure reason'
		END
	END
	ELSE
	BEGIN
		-- There is no index server and we have error for index server creation. Insert it
		IF (@indexServerFailureReasonReq IS NOT NULL)
		BEGIN
EXEC AppPlanSetEntityValueV2 @i_planId, 'Analytics Index Server failure reason', @indexServerFailureReasonReq, @errorCode OUTPUT, @errorString OUTPUT
		END
	END
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanUpdateFailureReasons')
	delete from GxQscripts where name = 'AppPlanUpdateFailureReasons'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateFailureReasons')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateFailureReasons'
GO

insert into GXDBVersions values(2, 'AppPlanUpdateFailureReasons',  '00010001000200010000', 'AppPlanUpdateFailureReasons', '00010001000200010000')
GO

