

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanUpdateDeleteEntityNameV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanUpdateDeleteEntityNameV2.sp,v $ $Id: AppPlanUpdateDeleteEntityNameV2.sp,v 1.1.2.1 2019/02/07 02:53:54 alakra Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanUpdateDeleteEntityNameV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanUpdateDeleteEntityNameV2 <<<'
	drop procedure AppPlanUpdateDeleteEntityNameV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanUpdateDeleteEntityNameV2')
	delete from GxQscripts where name = 'AppPlanUpdateDeleteEntityNameV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateDeleteEntityNameV2')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateDeleteEntityNameV2'
GO
print '... Creating Procedure: AppPlanUpdateDeleteEntityNameV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanUpdateDeleteEntityNameV2
  @i_planId INT,
  @i_CurrentPlanName NVARCHAR(255),
  @i_planNewName NVARCHAR(255),
  @i_userId INT,
  @i_localeId INT,
  @o_errorCode INT              OUTPUT,
  @o_errorMessage NVARCHAR(255)    OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET @o_errorCode = 0
SET @o_errorMessage  = ''
DECLARE @debug INT = 0
DECLARE @constPattern1 VARCHAR(24) = '% ([0-9])'
DECLARE @constPattern2 VARCHAR(24) = '% ([0-9][0-9])'
DECLARE @constPattern3 VARCHAR(24) = '% ([0-9][0-9][0-9])'
DECLARE @constPattern4 VARCHAR(24) = '% ([0-9][0-9][0-9][0-9])'
DECLARE @schedulePolicyId INT	   = 0
-- check if user has necessary permissions on the plan
DECLARE @userHasCapabilityUpdate INT = 0
EXEC sec_checkPermissionOnEntity @i_userId, 157, @userHasCapabilityUpdate OUTPUT, 158, @i_planId
IF @userHasCapabilityUpdate = 0 BEGIN
    SET @o_errorCode    = 5
    SET @o_errorMessage = 'Access denied'
END
-- check for plan existence
IF (@o_errorCode = 0)
BEGIN -- if new plan name is different from the old one then
    DECLARE @associatedEntityId     INT             = 0
    DECLARE @associatedEntityName   NVARCHAR(255)   = NULL
	DECLARE @planEntityDeletion     NVARCHAR(255)	= N' : scheduled for deletion.'
    IF @debug != 0
	BEGIN
        BEGIN TRANSACTION
                SELECT 'old plan name', @i_CurrentPlanName
UNION   SELECT 'old client group',              (SELECT name FROM APP_ClientGroup WHERE id =  (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Assigned client group'))
UNION   SELECT 'old user group',                (SELECT name FROM UMGroups WHERE id = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Assigned user group'))
UNION   SELECT 'old primary storage policy',    (SELECT name FROM archGroup WHERE id = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Storage policy'))
UNION   SELECT 'old log storage policy',        (SELECT name FROM archGroup WHERE id = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Log storage policy'))
UNION   SELECT 'old primary schedule policy',   (SELECT taskName FROM TM_Task WHERE taskId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Schedule policy'))
UNION   SELECT 'old log schedule policy',       (SELECT taskName FROM TM_Task WHERE taskId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Log schedule policy'))
UNION   SELECT 'old subclient policy win',      (SELECT name FROM APP_BackupSetName WHERE id = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Subclient policy 2'))
UNION   SELECT 'old subclient policy lin',      (SELECT name FROM APP_BackupSetName WHERE id = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Subclient policy 3'))
UNION   SELECT 'old subclient policy mac',      (SELECT name FROM APP_BackupSetName WHERE id = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Subclient policy 4'))
UNION   SELECT 'old exchange archiving policy', (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Exchange mailbox archiving policy'))
UNION   SELECT 'old exchange retention policy', (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Exchange mailbox retention policy'))
UNION   SELECT 'old exchange cleanup policy',   (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Exchange mailbox cleanup policy'))
UNION   SELECT 'old exchange journal policy',    (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Exchange mailbox journal policy'))
UNION   SELECT 'old data classification policy', (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Data classification policy'))
UNION   SELECT 'old features',                  (SELECT name FROM UMRoles WHERE id = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Feature'))
UNION   SELECT 'old access policy',             (SELECT name FROM UMRoles WHERE id = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Access policy'))
UNION   SELECT 'old edge drive client',         (SELECT name FROM APP_Client WHERE id = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Assgined Edge Drive'))                                                                   --
UNION   SELECT 'old content indexing policy', (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Content Indexing Policy'))
    END
    -- -- update plan associated entities names -- client group
SET @associatedEntityId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Assigned client group')
    IF @associatedEntityId IS NOT NULL
	BEGIN
        SET @associatedEntityName = (SELECT name FROM APP_ClientGroup WHERE id = @associatedEntityId)
        -- -- -- if entity name starts with plan name then update entity name as well
        IF  @associatedEntityName LIKE @i_CurrentPlanName + '%'
		BEGIN
            -- -- -- -- create new entity name
            SET @associatedEntityName = @associatedEntityName + @planEntityDeletion
            -- -- -- -- make sure it is unique
EXEC AppGetUniqueEntityName 28, @associatedEntityName, @i_userId, @associatedEntityName OUTPUT
            -- -- -- -- update
            UPDATE APP_ClientGroup SET name = @associatedEntityName  WHERE id = @associatedEntityId
            -- -- -- -- update smart client group rule.
            -- -- -- -- -- definition
            UPDATE  App_SCGRule
            SET     [ruleXml].modify('replace value of (/scgRule/rules/rule/rules/rule/@value)[1] with sql:variable("@i_planNewName")')
            WHERE   scgId = @associatedEntityId
            -- -- -- -- -- query
            DECLARE @xmlRule XML = (SELECT ruleXml FROM App_SCGRule WHERE scgId = @associatedEntityId)
            IF @xmlRule IS NOT NULL
            BEGIN
		        DECLARE @scgRule VARCHAR(max)
		        EXEC APPSCGV2GenerateQueryParams @xmlRule, @o_errorCode OUTPUT, @o_errorMessage OUTPUT, @scgRule OUTPUT
                UPDATE App_SCGRule SET ruleQuery = @scgRule WHERE scgId = @associatedEntityId
            END
        END
    END
    -- -- update plan associated entities names -- user group
SET @associatedEntityId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Assigned user group')
    IF @associatedEntityId IS NOT NULL
	BEGIN
        SET @associatedEntityName = (SELECT name FROM UMGroups WHERE id = @associatedEntityId)
        -- -- -- if entity name starts with plan name then update entity name as well
        IF  @associatedEntityName LIKE @i_CurrentPlanName + '%'
		BEGIN
			-- -- -- -- create new entity name
            SET @associatedEntityName = @associatedEntityName + @planEntityDeletion
            -- -- -- -- make sure it is unique
EXEC AppGetUniqueEntityName 15, @associatedEntityName, @i_userId, @associatedEntityName OUTPUT
            -- -- -- -- update
            UPDATE UMGroups SET name = @associatedEntityName  WHERE id = @associatedEntityId
        END
    END
    -- -- update plan associated entities names -- storage policy
SET @associatedEntityId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Storage policy')
    IF @associatedEntityId IS NOT NULL
	BEGIN
        SET @associatedEntityName = (SELECT name FROM archGroup WHERE id = @associatedEntityId)
        -- -- -- if entity name starts with plan name then update entity name as well
        IF  @associatedEntityName LIKE @i_CurrentPlanName + '%'
		BEGIN
            -- -- -- -- create new entity name
            SET @associatedEntityName = @associatedEntityName + @planEntityDeletion
            -- -- -- -- make sure it is unique
EXEC AppGetUniqueEntityName 17, @associatedEntityName, @i_userId, @associatedEntityName OUTPUT
            -- -- -- -- update
            UPDATE archGroup SET name = @associatedEntityName  WHERE id = @associatedEntityId
        END
    END
    -- -- update plan associated entities names -- log storage policy
SET @associatedEntityId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Log storage policy')
    IF @associatedEntityId IS NOT NULL
	BEGIN
        SET @associatedEntityName = (SELECT name FROM archGroup WHERE id = @associatedEntityId)
        -- -- -- if entity name starts with plan name then update entity name as well
        IF  @associatedEntityName LIKE @i_CurrentPlanName + '%'
		BEGIN
            -- -- -- -- create new entity name
            SET @associatedEntityName = @associatedEntityName + @planEntityDeletion
            -- -- -- -- make sure it is unique
EXEC AppGetUniqueEntityName 17, @associatedEntityName, @i_userId, @associatedEntityName OUTPUT
            -- -- -- -- update
            UPDATE archGroup SET name = @associatedEntityName  WHERE id = @associatedEntityId
        END
    END
    -- -- update plan associated entities names -- schedule policy
SET @associatedEntityId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Schedule policy')
	SET @schedulePolicyId = @associatedEntityId
    IF @associatedEntityId IS NOT NULL
	BEGIN
        SET @associatedEntityName = (SELECT taskName FROM TM_Task WHERE taskId = @associatedEntityId)
        -- -- -- if entity name starts with plan name then update entity name as well
        IF  @associatedEntityName LIKE @i_CurrentPlanName + '%'
		BEGIN
            -- -- -- -- create new entity name
            SET @associatedEntityName = @associatedEntityName + @planEntityDeletion
            -- -- -- -- make sure it is unique
EXEC AppGetUniqueEntityName 35, @associatedEntityName, @i_userId, @associatedEntityName OUTPUT
            -- -- -- -- update
            UPDATE TM_Task SET taskName = @associatedEntityName  WHERE taskId = @associatedEntityId
        END
    END
    -- -- update plan associated entities names -- log schedule policy
SET @associatedEntityId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Log schedule policy')
    IF @associatedEntityId IS NOT NULL
	BEGIN
        SET @associatedEntityName = (SELECT taskName FROM TM_Task WHERE taskId = @associatedEntityId)
        -- -- -- if entity name starts with plan name then update entity name as well
        IF  @associatedEntityName LIKE @i_CurrentPlanName + '%'
		BEGIN
            -- -- -- -- create new entity name
            SET @associatedEntityName = @associatedEntityName + @planEntityDeletion
            -- -- -- -- make sure it is unique
EXEC AppGetUniqueEntityName 35, @associatedEntityName, @i_userId, @associatedEntityName OUTPUT
            -- -- -- -- update
            UPDATE TM_Task SET taskName = @associatedEntityName  WHERE taskId = @associatedEntityId
        END
    END
    -- -- update plan associated entities names -- windows subclient policy
SET @associatedEntityId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Subclient policy 2')
    IF @associatedEntityId IS NOT NULL
	BEGIN
		SELECT @associatedEntityName=name FROM APP_BackupSetName WHERE id = @associatedEntityId
        IF  @associatedEntityName LIKE @i_CurrentPlanName + '%'
		BEGIN
            -- -- -- -- create new entity name
            SET @associatedEntityName = @associatedEntityName + @planEntityDeletion
            -- -- -- -- make sure it is unique
EXEC AppGetUniqueEntityName 65, @associatedEntityName, @i_userId, @associatedEntityName OUTPUT
            -- -- -- -- update
            UPDATE APP_BackupSetName SET name = @associatedEntityName WHERE id = @associatedEntityId
        END
    END
    -- -- update plan associated entities names -- linux subclient policy
SET @associatedEntityId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Subclient policy 3')
    IF @associatedEntityId IS NOT NULL
	BEGIN
        SELECT @associatedEntityName=name FROM APP_BackupSetName WHERE id = @associatedEntityId
        IF  @associatedEntityName LIKE @i_CurrentPlanName + '%'
		BEGIN
            -- -- -- -- create new entity name
            SET @associatedEntityName = @associatedEntityName + @planEntityDeletion
            -- -- -- -- make sure it is unique
EXEC AppGetUniqueEntityName 65, @associatedEntityName, @i_userId, @associatedEntityName OUTPUT
            -- -- -- -- update
            UPDATE APP_BackupSetName SET name = @associatedEntityName WHERE id = @associatedEntityId
        END
    END
    -- -- update plan associated entities names -- mac subclient policy
SET @associatedEntityId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Subclient policy 4')
    IF @associatedEntityId IS NOT NULL
	BEGIN
        SELECT @associatedEntityName=name FROM APP_BackupSetName WHERE id = @associatedEntityId
        IF  @associatedEntityName LIKE @i_CurrentPlanName + '%'
		BEGIN
            -- -- -- -- create new entity name
            SET @associatedEntityName = @associatedEntityName + @planEntityDeletion
            -- -- -- -- make sure it is unique
EXEC AppGetUniqueEntityName 65, @associatedEntityName, @i_userId, @associatedEntityName OUTPUT
            -- -- -- -- update
            UPDATE APP_BackupSetName SET name = @associatedEntityName WHERE id = @associatedEntityId
        END
    END
    -- -- update plan associated entities names -- configuration archiving policy
SET @associatedEntityId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Exchange mailbox archiving policy')
    IF @associatedEntityId IS NOT NULL
	BEGIN
        SET @associatedEntityName = (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = @associatedEntityId)
        -- -- -- if entity name starts with plan name then update entity name as well
        IF  @associatedEntityName LIKE @i_CurrentPlanName + '%'
		BEGIN
            -- -- -- -- create new entity name
            SET @associatedEntityName = @associatedEntityName + @planEntityDeletion
            -- -- -- -- make sure it is unique
            EXEC AppGetUniqueEntityName 154, @associatedEntityName, @i_userId, @associatedEntityName OUTPUT
            -- -- -- -- update
            UPDATE APP_ConfigurationPolicy SET policyName = @associatedEntityName  WHERE policyId = @associatedEntityId
        END
    END
    -- -- update plan associated entities names -- configuration retention policy
SET @associatedEntityId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Exchange mailbox retention policy')
    IF @associatedEntityId IS NOT NULL
	BEGIN
        SET @associatedEntityName = (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = @associatedEntityId)
        -- -- -- if entity name starts with plan name then update entity name as well
        IF  @associatedEntityName LIKE @i_CurrentPlanName + '%'
		BEGIN
            -- -- -- -- create new entity name
            SET @associatedEntityName = @associatedEntityName + @planEntityDeletion
            -- -- -- -- make sure it is unique
            EXEC AppGetUniqueEntityName 154, @associatedEntityName, @i_userId, @associatedEntityName OUTPUT
            -- -- -- -- update
            UPDATE APP_ConfigurationPolicy SET policyName = @associatedEntityName  WHERE policyId = @associatedEntityId
        END
    END
    -- -- update plan associated entities names -- configuration clean-up policy
SET @associatedEntityId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Exchange mailbox cleanup policy')
    IF @associatedEntityId IS NOT NULL
	BEGIN
        SET @associatedEntityName = (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = @associatedEntityId)
        -- -- -- if entity name starts with plan name then update entity name as well
        IF  @associatedEntityName LIKE @i_CurrentPlanName + '%'
		BEGIN
            -- -- -- -- create new entity name
            SET @associatedEntityName = @associatedEntityName + @planEntityDeletion
            -- -- -- -- make sure it is unique
            EXEC AppGetUniqueEntityName 154, @associatedEntityName, @i_userId, @associatedEntityName OUTPUT
            -- -- -- -- update
            UPDATE APP_ConfigurationPolicy SET policyName = @associatedEntityName  WHERE policyId = @associatedEntityId
        END
    END
    -- -- update plan associated entities names -- configuration journal policy
SET @associatedEntityId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Exchange mailbox journal policy')
    IF @associatedEntityId IS NOT NULL
	BEGIN
        SET @associatedEntityName = (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = @associatedEntityId)
        -- -- -- if entity name starts with plan name then update entity name as well
        IF  @associatedEntityName LIKE @i_CurrentPlanName + '%'
		BEGIN
            -- -- -- -- create new entity name
            SET @associatedEntityName = @associatedEntityName + @planEntityDeletion
            -- -- -- -- make sure it is unique
            EXEC AppGetUniqueEntityName 154, @associatedEntityName, @i_userId, @associatedEntityName OUTPUT
            -- -- -- -- update
            UPDATE APP_ConfigurationPolicy SET policyName = @associatedEntityName  WHERE policyId = @associatedEntityId
        END
    END
	-- -- update plan associated entities names -- data classification policy
SET @associatedEntityId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Data classification policy')
    IF @associatedEntityId IS NOT NULL
	BEGIN
        SET @associatedEntityName = (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = @associatedEntityId)
        -- -- -- if entity name starts with plan name then update entity name as well
        IF  @associatedEntityName LIKE @i_CurrentPlanName + '%'
		BEGIN
            -- -- -- -- create new entity name
            SET @associatedEntityName = @associatedEntityName + @planEntityDeletion
            -- -- -- -- make sure it is unique
            EXEC AppGetUniqueEntityName 154, @associatedEntityName, @i_userId, @associatedEntityName OUTPUT
            -- -- -- -- update
            UPDATE APP_ConfigurationPolicy SET policyName = @associatedEntityName  WHERE policyId = @associatedEntityId
        END
    END
	-- -- update plan associated entities names -- content indexing policy
SET @associatedEntityId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Content Indexing Policy')
    IF @associatedEntityId IS NOT NULL
	BEGIN
        SET @associatedEntityName = (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = @associatedEntityId)
        -- -- -- if entity name starts with plan name then update entity name as well
        IF  @associatedEntityName LIKE @i_CurrentPlanName + '%'
		BEGIN
            -- -- -- -- create new entity name
            SET @associatedEntityName = @associatedEntityName + @planEntityDeletion
            -- -- -- -- make sure it is unique
            EXEC AppGetUniqueEntityName 154, @associatedEntityName, @i_userId, @associatedEntityName OUTPUT
            -- -- -- -- update
            UPDATE APP_ConfigurationPolicy SET policyName = @associatedEntityName  WHERE policyId = @associatedEntityId
        END
    END
    -- -- update plan associated entities names -- features
SET @associatedEntityId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Feature')
    IF @associatedEntityId IS NOT NULL
	BEGIN
        SET @associatedEntityName = (SELECT name FROM UMRoles WHERE id = @associatedEntityId)
        -- -- -- if entity name starts with plan name then update entity name as well
        IF  @associatedEntityName LIKE @i_CurrentPlanName + '%'
		BEGIN
            -- -- -- -- create new entity name
            SET @associatedEntityName = @associatedEntityName + @planEntityDeletion
            -- -- -- -- make sure it is unique
EXEC AppGetUniqueEntityName 120, @associatedEntityName, @i_userId, @associatedEntityName OUTPUT
            -- -- -- -- update
            UPDATE  UMROles SET name = @associatedEntityName  WHERE id = @associatedEntityId
        END
    END
    -- -- update plan associated entities names -- access policies
SET @associatedEntityId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Access policy')
    IF @associatedEntityId IS NOT NULL
	BEGIN
        SET @associatedEntityName = (SELECT name FROM UMRoles WHERE id = @associatedEntityId)
        -- -- -- if entity name starts with plan name then update entity name as well
        IF  @associatedEntityName LIKE @i_CurrentPlanName + '%'
		BEGIN
            -- -- -- -- create new entity name
            SET @associatedEntityName = @associatedEntityName + @planEntityDeletion
            -- -- -- -- make sure it is unique
EXEC AppGetUniqueEntityName 120, @associatedEntityName, @i_userId, @associatedEntityName OUTPUT
            -- -- -- -- update
            UPDATE  UMROles SET name = @associatedEntityName  WHERE id = @associatedEntityId
        END
    END
    -- -- update plan associated entities names -- edge drive
SET @associatedEntityId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Assgined Edge Drive')
    IF @associatedEntityId IS NOT NULL
	BEGIN
        SET @associatedEntityName = (SELECT displayName FROM APP_Client WHERE id = @associatedEntityId)
        -- -- -- if entity name starts with plan name then update entity name as well
        IF  @associatedEntityName LIKE @i_CurrentPlanName + '%'
		BEGIN
            -- -- -- -- create new entity name
            SET @associatedEntityName = @associatedEntityName + @planEntityDeletion
            -- -- -- -- make sure it is unique
EXEC AppGetUniqueEntityName 3, @associatedEntityName, @i_userId, @associatedEntityName OUTPUT
            -- -- -- -- update
            UPDATE  APP_Client SET displayName = @associatedEntityName  WHERE id = @associatedEntityId
        END
    END
	-- -- update plan associated operation window name
    SET @associatedEntityId = @schedulePolicyId
    IF @associatedEntityId IS NOT NULL
	BEGIN
		SET @associatedEntityName = ''
		DECLARE @OperationWindowIdsList AS TABLE (id INT)
		INSERT INTO @OperationWindowIdsList
		SELECT DISTINCT ID FROM APP_OpWindowRule WHERE schedulePolicyId = @schedulePolicyId
		SET @associatedEntityId = (SELECT MIN(id) FROM @OperationWindowIdsList)
		WHILE @associatedEntityId IS NOT NULL
		BEGIN
			SELECT TOP 1 @associatedEntityName  = description FROM APP_OpWindowRule WHERE Id = @associatedEntityId
			-- -- -- if entity name starts with plan name then update entity name as well
			IF  @associatedEntityName IS NOT NULL AND LEN(@associatedEntityName)>0 AND @associatedEntityName LIKE @i_CurrentPlanName + '%'
			BEGIN
				-- -- -- -- create new entity name
				SET @associatedEntityName = @associatedEntityName + @planEntityDeletion
				-- -- -- -- make sure it is unique
EXEC AppGetUniqueEntityName 38, @associatedEntityName, @i_userId, @associatedEntityName OUTPUT
				-- -- -- -- update
				UPDATE APP_OpWindowRule SET description = @associatedEntityName  WHERE Id = @associatedEntityId
			END
			SET @associatedEntityId = (SELECT MIN(id) FROM @OperationWindowIdsList WHERE id > @associatedEntityId)
		END
    END
    -- -- update plan associated entities names -- replication scheduls
    DECLARE @idsList AS TABLE (id INT)
    INSERT INTO @idsList
SELECT CAST(_ID AS INT) FROM dbo.SplitIDString((SELECT attrVal FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Replication schedule policy')) B
    SET @associatedEntityId = (SELECT MIN(id) FROM @idsList)
    WHILE @associatedEntityId IS NOT NULL
	BEGIN
        SET @associatedEntityName = (SELECT taskName FROM TM_Task WHERE taskId = @associatedEntityId)
        -- -- -- if entity name starts with plan name then update entity name as well
        IF  @associatedEntityName LIKE @i_CurrentPlanName + '%'
		BEGIN
            -- -- -- -- create new entity name
            SET @associatedEntityName = @associatedEntityName + @planEntityDeletion
            -- -- -- -- make sure it is unique
EXEC AppGetUniqueEntityName 69, @associatedEntityName, @i_userId, @associatedEntityName OUTPUT
            -- -- -- -- update
            UPDATE TM_Task SET taskName = @associatedEntityName  WHERE taskId = @associatedEntityId
        END
        SET @associatedEntityId = (SELECT MIN(id) FROM @idsList WHERE id > @associatedEntityId)
    END
    IF @debug != 0
	BEGIN
                SELECT 'new plan name', @i_planNewName
UNION   SELECT 'new client group',              (SELECT name FROM APP_ClientGroup WHERE id =  (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Assigned client group'))
UNION   SELECT 'new user group',                (SELECT name FROM UMGroups WHERE id = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Assigned user group'))
UNION   SELECT 'new primary storage policy',    (SELECT name FROM archGroup WHERE id = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Storage policy'))
UNION   SELECT 'new log storage policy',        (SELECT name FROM archGroup WHERE id = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Log storage policy'))
UNION   SELECT 'new primary schedule policy',   (SELECT taskName FROM TM_Task WHERE taskId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Schedule policy'))
UNION   SELECT 'new log schedule policy',       (SELECT taskName FROM TM_Task WHERE taskId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Log schedule policy'))
UNION   SELECT 'new subclient policy win',      (SELECT name FROM APP_BackupSetName WHERE id = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Subclient policy 2'))
UNION   SELECT 'new subclient policy lin',      (SELECT name FROM APP_BackupSetName WHERE id = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Subclient policy 3'))
UNION   SELECT 'new subclient policy mac',      (SELECT name FROM APP_BackupSetName WHERE id = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Subclient policy 4'))
UNION   SELECT 'new exchange archiving policy', (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Exchange mailbox archiving policy'))
UNION   SELECT 'new exchange retention policy', (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Exchange mailbox retention policy'))
UNION   SELECT 'new exchange cleanup policy',   (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Exchange mailbox cleanup policy'))
UNION   SELECT 'new exchange journal policy',    (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Exchange mailbox journal policy'))
UNION   SELECT 'new data classification policy', (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Data classification policy'))
UNION   SELECT 'new features',                  (SELECT name FROM UMRoles WHERE id = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Feature'))
UNION   SELECT 'new access policy',             (SELECT name FROM UMRoles WHERE id = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Access policy'))
UNION   SELECT 'new edge drive client',         (SELECT name FROM APP_Client WHERE id = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Assgined Edge Drive'))                                                                   --
UNION   SELECT 'new content indexing policy', (SELECT policyName FROM APP_ConfigurationPolicy WHERE policyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Content Indexing Policy'))
        ROLLBACK TRANSACTION
    END
END -- AND we are done here
IF @debug != 0 BEGIN
    SELECT @o_errorCode AS 'output error code', @o_errorMessage AS 'output error message'
END
RETURN @o_errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanUpdateDeleteEntityNameV2')
	delete from GxQscripts where name = 'AppPlanUpdateDeleteEntityNameV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateDeleteEntityNameV2')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateDeleteEntityNameV2'
GO

insert into GXDBVersions values(2, 'AppPlanUpdateDeleteEntityNameV2',  '00010001000200010000', 'AppPlanUpdateDeleteEntityNameV2', '00010001000200010000')
GO

