

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanUpdateClientFeaturesV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +================================================================================================+
--  |   Procedure:  AppPlanUpdateClientFeaturesV2()
--  |
--  | Description:  SP for updating features list of plan to associated laptop clients.
--  |
--  |       Input:  planId, user id
--  |      Output:  ErrorCode, ErrorString to determine status of the operation
--  |      Return:  xxx
--  |
--  |   Revisions  Author
--  |   ---------  Rohith Engu
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanUpdateClientFeaturesV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanUpdateClientFeaturesV2 <<<'
	drop procedure AppPlanUpdateClientFeaturesV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanUpdateClientFeaturesV2')
	delete from GxQscripts where name = 'AppPlanUpdateClientFeaturesV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateClientFeaturesV2')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateClientFeaturesV2'
GO
print '... Creating Procedure: AppPlanUpdateClientFeaturesV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanUpdateClientFeaturesV2
  @i_planId INT,
  @i_userId INT,
  @o_xmlResult XML OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @errorCode INTEGER = 0
DECLARE @errorString NVARCHAR(MAX) =N'Success'
-- Find all the users associated to this plan Id and then find their physical client id's and send a work token on the clients to inform about the current features and their status.
DECLARE @nowTime INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @workQueueXML XML = ''
DECLARE @workQueueParam NVARCHAR(MAX) = ''
DECLARE @feature_DLP INT = 0
DECLARE @feature_EDGEDRIVE INT = 0
DECLARE @feature_ARCHIVING INT = 0
DECLARE @featureID INT  = 0
DECLARE @planSCG INT = 0  -- Plan Smart Client Group
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__PlanAssociatedUsers') IS NOT NULL DROP TABLE #AppPlanUpdate_tmp__PlanAssociatedUsers
CREATE TABLE #AppPlanUpdate_tmp__PlanAssociatedUsers(userId integer)
IF OBJECT_ID('tempdb.dbo.#clientsToProcess') IS NOT NULL DROP TABLE #clientsToProcess
CREATE TABLE #clientsToProcess(userId INT, pseudoClientId INT, physicalClientId INT, xmlParam NVARCHAR(MAX))
IF OBJECT_ID('tempdb.dbo.#PlanUserGroups') IS NOT NULL DROP TABLE #PlanUserGroups
CREATE TABLE #PlanUserGroups(groupId integer)
BEGIN TRY
	--Fetching plan associated users from UMGroups property in plan prop
	INSERT INTO #PlanUserGroups
	SELECT CAST(attrVal AS INT)
		FROM APP_PlanProp
		WHERE componentNameId = @i_planId
AND attrName IN ('Assigned user group', 'Associated internal user group', 'Associated external user group')
    INSERT INTO #AppPlanUpdate_tmp__PlanAssociatedUsers
	SELECT DISTINCT
       userId
	FROM UMUserGroup UG
	INNER JOIN #PlanUserGroups PUG ON PUG.groupId = UG.groupId
	--Fetching associated physical clients of users on plan
	INSERT INTO #clientsToProcess(pseudoClientId,physicalClientId)
	SELECT DISTINCT ACP.componentNameId, ISNULL(CONVERT(INT,PC.attrVal),AC.id)
	FROM APP_ClientProp PROP WITH(NOLOCK)
INNER JOIN APP_Client AC WITH(NOLOCK) ON PROP.componentNameId = AC.id AND AC.status&0x1000 = 0x1000
LEFT OUTER JOIN APP_ClientProp ACP WITH(NOLOCK) ON AC.id = ACP.componentNameId AND ACP.AttrName = 'User Centric Client' AND ACP.AttrVal=N'1' AND ACP.modified = 0
LEFT OUTER JOIN APP_ClientProp PC WITH(NOLOCK) ON ACP.componentNameId = PC.componentNameId AND PC.attrName = 'Physical Client Id' AND PC.modified = 0
WHERE PROP.AttrName = 'Associated Plan' AND PROP.AttrVal=CONVERT(NVARCHAR(1024),@i_planId) AND PROP.modified = 0
	UPDATE clientsToProcess
		SET clientsToProcess.userId = OW.userOrGroupId
	FROM #clientsToProcess clientsToProcess
	INNER JOIN UMOwners OW WITH(NOLOCK) ON OW.entityId=clientsToProcess.pseudoClientId AND OW.entityType=3 AND OW.isUser=1
	INNER JOIN #AppPlanUpdate_tmp__PlanAssociatedUsers PU WITH(NOLOCK) ON PU.userId = OW.userOrGroupId
	WHERE clientsToProcess.pseudoClientId IS NOT NULL
	--fill Pseudo clients to be same as physical in case they are null
	UPDATE clientsToProcess
		SET clientsToProcess.pseudoClientId = clientsToProcess.physicalClientId
	FROM #clientsToProcess clientsToProcess
	WHERE clientsToProcess.pseudoClientId IS NULL
SET @featureID  = ISNULL(dbo.AppPlanGetEntityValueV2(@i_planId, 'Feature',  default), 0)
SET @planSCG = ISNULL(dbo.AppPlanGetEntityValueV2(@i_planId, 'Assigned client group', 2),0)
	--Forming a XML to summarize the features on plan
	SET @feature_DLP = ISNULL(
		(
			SELECT 1
			FROM UMPermissions permission WITH(NOLOCK)
				INNER JOIN UMRolesPermissions roleToPermissionMap WITH(NOLOCK) ON roleToPermissionMap.permissionId = permission.id
					WHERE roleToPermissionMap.roleId = @featureID AND permission.permissionName = 'DLP'
		),0)
	SET @feature_ARCHIVING = ISNULL(
		(
			SELECT 1
			FROM UMPermissions permission WITH(NOLOCK)
				INNER JOIN UMRolesPermissions roleToPermissionMap WITH(NOLOCK) ON roleToPermissionMap.permissionId = permission.id
					WHERE roleToPermissionMap.roleId = @featureID AND permission.permissionName = 'Archiving'
		),0)
	SET @feature_EDGEDRIVE = ISNULL(
		(
			SELECT 1
			FROM UMPermissions permission WITH(NOLOCK)
				INNER JOIN UMRolesPermissions roleToPermissionMap WITH(NOLOCK) ON roleToPermissionMap.permissionId = permission.id
					WHERE roleToPermissionMap.roleId = @featureID AND permission.permissionName = 'Edge Drive'
		),0)
	--Reflecting DLP settings on clients in their properties table
	IF @feature_DLP=1   -- Enable DLP
	BEGIN
		--enableDLP
		INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			SELECT clients.pseudoClientId, 'enableDLP', 2, '1', @nowTime, 0 ,0
			FROM #clientsToProcess clients
			LEFT JOIN APP_ClientProp CP ON clients.pseudoClientId = CP.componentNameId AND CP.attrName = 'enableDLP' AND CP.modified = 0
			WHERE CP.attrVal IS NULL
		UPDATE CP
			SET CP.attrVal = '1'
			FROM APP_ClientProp CP
			INNER JOIN #clientsToProcess clients ON clients.pseudoClientId = CP.componentNameId
			WHERE CP.attrName = 'enableDLP' AND CP.attrVal != '1' AND CP.modified = 0
		--Update Plan Smart client group with CV_COMPONENT_SHOW_DLP set to 1
UPDATE APP_ComponentProp SET longval = 1 WHERE propertytypeid = 3623 AND componentid = @planSCG AND modified = 0
		IF @@ROWCOUNT = 0
			INSERT INTO APP_ComponentProp (componenttype, componentid, propertytypeid,datatype,longval,longlongval,stringval,created,modified)
VALUES (8, @planSCG,  3623,8,1,0,N'', @nowTime, 0)
		--dlpEnableAutomaticDecryption
		INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			SELECT clients.pseudoClientId, 'dlpEnableAutomaticDecryption', 2, '0', @nowTime, 0 ,0
			FROM #clientsToProcess clients
			LEFT JOIN APP_ClientProp CP ON clients.pseudoClientId = CP.componentNameId AND CP.attrName = 'dlpEnableAutomaticDecryption' AND CP.modified = 0
			WHERE CP.attrVal IS NULL
		UPDATE CP
			SET CP.attrVal = '0'
			FROM APP_ClientProp CP
			INNER JOIN #clientsToProcess clients ON clients.pseudoClientId = CP.componentNameId
			WHERE CP.attrName = 'dlpEnableAutomaticDecryption' AND CP.attrVal != '0' AND CP.modified = 0
		--dlpEnableClientKeys
		INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			SELECT clients.pseudoClientId, 'dlpEnableClientKeys', 2, '1', @nowTime, 0 ,0
			FROM #clientsToProcess clients
			LEFT JOIN APP_ClientProp CP ON clients.pseudoClientId = CP.componentNameId AND CP.attrName = 'dlpEnableClientKeys' AND CP.modified = 0
			WHERE CP.attrVal IS NULL
		UPDATE CP
			SET CP.attrVal = '1'
			FROM APP_ClientProp CP
			INNER JOIN #clientsToProcess clients ON clients.pseudoClientId = CP.componentNameId
			WHERE CP.attrName = 'dlpEnableClientKeys' AND CP.attrVal != '1' AND CP.modified = 0
		--dlpStolen
		INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			SELECT clients.pseudoClientId, 'dlpStolen', 2, '0', @nowTime, 0 ,0
			FROM #clientsToProcess clients
			LEFT JOIN APP_ClientProp CP ON clients.pseudoClientId = CP.componentNameId AND CP.attrName = 'dlpStolen' AND CP.modified = 0
			WHERE CP.attrVal IS NULL
		UPDATE CP
			SET CP.attrVal = '0'
			FROM APP_ClientProp CP
			INNER JOIN #clientsToProcess clients ON clients.pseudoClientId = CP.componentNameId
			WHERE CP.attrName = 'dlpStolen' AND CP.attrVal != '0' AND CP.modified = 0
		--dlpMinFileAgeMins
		INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			SELECT clients.pseudoClientId, 'dlpMinFileAgeMins', 10, '5', @nowTime, 0 ,0
			FROM #clientsToProcess clients
			LEFT JOIN APP_ClientProp CP ON clients.pseudoClientId = CP.componentNameId AND CP.attrName = 'dlpMinFileAgeMins' AND CP.modified = 0
			WHERE CP.attrVal IS NULL
		UPDATE CP
			SET CP.attrVal = '5'
			FROM APP_ClientProp CP
			INNER JOIN #clientsToProcess clients ON clients.pseudoClientId = CP.componentNameId
			WHERE CP.attrName = 'dlpMinFileAgeMins' AND CP.attrVal != '5' AND CP.modified = 0
		--dlpScanIntervalMins
		INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			SELECT clients.pseudoClientId, 'dlpScanIntervalMins', 10, '15', @nowTime, 0 ,0
			FROM #clientsToProcess clients
			LEFT JOIN APP_ClientProp CP ON clients.pseudoClientId = CP.componentNameId AND CP.attrName = 'dlpScanIntervalMins' AND CP.modified = 0
			WHERE CP.attrVal IS NULL
		UPDATE CP
			SET CP.attrVal = '15'
			FROM APP_ClientProp CP
			INNER JOIN #clientsToProcess clients ON clients.pseudoClientId = CP.componentNameId
			WHERE CP.attrName = 'dlpScanIntervalMins' AND CP.attrVal != '15' AND CP.modified = 0
		--dlpUnlockMethod
		INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			SELECT clients.pseudoClientId, 'dlpUnlockMethod', 10, '0', @nowTime, 0 ,0
			FROM #clientsToProcess clients
			LEFT JOIN APP_ClientProp CP ON clients.pseudoClientId = CP.componentNameId AND CP.attrName = 'dlpUnlockMethod' AND CP.modified = 0
			WHERE CP.attrVal IS NULL
		UPDATE CP
			SET CP.attrVal = '0'
			FROM APP_ClientProp CP
			INNER JOIN #clientsToProcess clients ON clients.pseudoClientId = CP.componentNameId
			WHERE CP.attrName = 'dlpUnlockMethod' AND CP.attrVal != '0' AND CP.modified = 0
		--dlpContents
		INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			SELECT clients.pseudoClientId, 'dlpContents', 1, ';', @nowTime, 0 ,0
			FROM #clientsToProcess clients
			LEFT JOIN APP_ClientProp CP ON clients.pseudoClientId = CP.componentNameId AND CP.attrName = 'dlpContents' AND CP.modified = 0
			WHERE CP.attrVal IS NULL
		UPDATE CP
			SET CP.attrVal = ';'
			FROM APP_ClientProp CP
			INNER JOIN #clientsToProcess clients ON clients.pseudoClientId = CP.componentNameId
			WHERE CP.attrName = 'dlpContents' AND CP.attrVal != ';' AND CP.modified = 0
		--dlpFilters
		INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			SELECT clients.pseudoClientId, 'dlpFilters', 1, '**\.edgedrive.cache;*.app;*.bat;*.conf;*.dll;*.dmg;*.exe;*.ini;*.lnk;*.plist;*.rc;*.tmp;.DS_Store;.localized;~$*;', @nowTime, 0 ,0
			FROM #clientsToProcess clients
			LEFT JOIN APP_ClientProp CP ON clients.pseudoClientId = CP.componentNameId AND CP.attrName = 'dlpFilters' AND CP.modified = 0
			WHERE CP.attrVal IS NULL
		UPDATE CP
			SET CP.attrVal = '**\.edgedrive.cache;*.app;*.bat;*.conf;*.dll;*.dmg;*.exe;*.ini;*.lnk;*.plist;*.rc;*.tmp;.DS_Store;.localized;~$*;'
			FROM APP_ClientProp CP
			INNER JOIN #clientsToProcess clients ON clients.pseudoClientId = CP.componentNameId
			WHERE CP.attrName = 'dlpFilters' AND CP.attrVal != '**\.edgedrive.cache;*.app;*.bat;*.conf;*.dll;*.dmg;*.exe;*.ini;*.lnk;*.plist;*.rc;*.tmp;.DS_Store;.localized;~$*;' AND CP.modified = 0
	END
	ELSE IF @feature_DLP=0   -- Disable DLP
	BEGIN
		INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			SELECT clients.pseudoClientId, 'enableDLP', 2, '0', @nowTime, 0 ,0
			FROM #clientsToProcess clients
			LEFT JOIN APP_ClientProp CP ON clients.pseudoClientId = CP.componentNameId AND CP.attrName = 'enableDLP' AND CP.modified = 0
			WHERE CP.attrVal IS NULL
		UPDATE CP
			SET CP.attrVal = '0'
			FROM APP_ClientProp CP
			INNER JOIN #clientsToProcess clients ON clients.pseudoClientId = CP.componentNameId
			WHERE CP.attrName = 'enableDLP' AND CP.attrVal != '0' AND CP.modified = 0
		--Update Plan Smart client group with CV_COMPONENT_SHOW_DLP set to 0
UPDATE APP_ComponentProp SET longval = 0 WHERE propertytypeid = 3623 AND componentid = @planSCG AND modified = 0
		IF @@ROWCOUNT = 0
			INSERT INTO APP_ComponentProp (componenttype, componentid, propertytypeid,datatype,longval,longlongval,stringval,created,modified)
VALUES (8, @planSCG,  3623,8,0,0,N'', @nowTime, 0)
	END
	UPDATE clientsToProcess
	SET clientsToProcess.xmlParam = CAST(
											(SELECT
												(SELECT CASE
													WHEN clientsToProcess.pseudoClientId = clientsToProcess.physicalClientId
													THEN '<App_ActivateClientResp activatedMode="1"/><App_ActivateClientResp>'
													ELSE '<App_ActivateClientResp activatedMode="2"/><App_ActivateClientResp>'
													END
													AS '@activateClientResponse',
												(
													SELECT CASE
													WHEN @feature_EDGEDRIVE = 1
													THEN
													(
														SELECT '1' AS '@enable', --SYNC_PAUSED
																'1' AS '@featureType'-- EDGE_DRIVE
														FOR XML PATH('featureDetails'), TYPE
													)
													ELSE NULL						--Edge drive can only be enabled
													END
												),
												(
													SELECT CASE
													WHEN @feature_DLP = 1
													THEN
													(
														SELECT '1' AS '@enable', --SYNC_PAUSED
																'5' AS '@featureType'-- DLP
														FOR XML PATH('featureDetails'), TYPE
													)
													ELSE
													(
														SELECT '0' AS '@enable', --SYNC_PAUSED
																'5' AS '@featureType'-- DLP
														FOR XML PATH('featureDetails'), TYPE
													)
													END
												),
												(
													SELECT CASE
													WHEN @feature_ARCHIVING = 1
													THEN
													(
														SELECT '1' AS '@enable', --SYNC_PAUSED
																'6' AS '@featureType'-- DLP
														FOR XML PATH('featureDetails'), TYPE
													)
													ELSE
													(
														SELECT '0' AS '@enable', --SYNC_PAUSED
																'6' AS '@featureType'-- DLP
														FOR XML PATH('featureDetails'), TYPE
													)
													END
												),
												(
													SELECT CASE
														WHEN clientsToProcess.pseudoClientId = clientsToProcess.physicalClientId
														THEN
															(
																SELECT 'AllUsers' AS '@userName' FOR XML PATH('user'),TYPE
															)
														ELSE
															(
																SELECT U.login AS '@userName', U.id AS '@userId'
																	FROM UMUsers U WHERE U.id = clientsToProcess.userid
																FOR XML PATH('user'),TYPE
															)
													END
												)
												FOR XML PATH('userFeatureList'), TYPE)
												FOR XML PATH('App_UpdateFeatureList'), TYPE
											) AS NVARCHAR(MAX))
				FROM #clientsToProcess clientsToProcess
	--Push token param to applicable clients
	INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
	SELECT clientsToProcess.physicalClientId, 28/*WORK_TOKEN_FEATURE_LIST*/, clientsToProcess.xmlParam, @nowTime, 0, 0, 0, -1
	FROM #clientsToProcess clientsToProcess
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = 'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
END  CATCH
SET @o_xmlResult = (SELECT @errorCode AS '@errorCode',
                        @errorString AS '@errorMessage'
                FOR XML PATH ('Api_GenericResp'), TYPE)
SELECT @o_xmlResult
IF OBJECT_ID('tempdb.dbo.#clientsToProcess') IS NOT NULL DROP TABLE #clientsToProcess
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__PlanAssociatedUsers') IS NOT NULL DROP TABLE #AppPlanUpdate_tmp__PlanAssociatedUsers
IF OBJECT_ID('tempdb.dbo.#PlanUserGroups') IS NOT NULL DROP TABLE #PlanUserGroups
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanUpdateClientFeaturesV2')
	delete from GxQscripts where name = 'AppPlanUpdateClientFeaturesV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateClientFeaturesV2')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateClientFeaturesV2'
GO

insert into GXDBVersions values(2, 'AppPlanUpdateClientFeaturesV2',  '00000000000000000000', 'AppPlanUpdateClientFeaturesV2', '00000000000000000000')
GO

