

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanUpdateAddonV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanUpdateAddonV2.sp,v $ $Id: AppPlanUpdateAddonV2.sp,v 1.1.2.6 2019/03/20 15:13:13 rengu Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanUpdateAddonV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanUpdateAddonV2 <<<'
	drop procedure AppPlanUpdateAddonV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanUpdateAddonV2')
	delete from GxQscripts where name = 'AppPlanUpdateAddonV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateAddonV2')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateAddonV2'
GO
print '... Creating Procedure: AppPlanUpdateAddonV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanUpdateAddonV2
  @i_userId INT,
  @i_localeId INT,
  @i_planId INT,
  @i_planName NVARCHAR(1024),
  @x_xmlData XML
AS
    -- SET NOCOUNT ON added to prevent extra result sets from
    -- interfering with SELECT statements.
    SET NOCOUNT ON
    -- as the very first step make sure that this sp gets executed in context of App_PlanUpdateV2
    -- -- App_PlanUpdateV2 creates multiple temporary tables. two of them : #AppPlanUpdate_tmp__IdsSet and #AppPlanUpdate_tmp__ExecutionErrors will be used
    -- -- by this sp. verify their existence. There is no need to continue if they do not exist
    IF (OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__IdsSet') IS NULL)  OR (OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__ExecutionErrors') IS NULL)
        THROW 50001, 'Stored procedure must be executed in context of App_PlanUpdateV2', 1
    DECLARE @errorCode      INT = 0
    DECLARE @errorString    NVARCHAR(MAX) = NULL
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    -- update plan Addon status - Snap
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    -- At this time, also get flag for enabling snap Addon
DECLARE @snapAddonReq INT = ISNULL((SELECT ref.value('@snap', 'INT') AS id FROM @x_xmlData.nodes('Api_UpdatePlanReq/summary/addons') R ( ref )), 2)
DECLARE @snapAddonDB INT = ISNULL(dbo.AppPlanGetEntityValueV2(@i_planId, 'Snap Addon', 0), 2)
    -- 1- Consider the associated schedule
    DECLARE @snapAddonSupported INT = dbo.AppPlanIsSnapAddonEnabled(@i_planId,1)
IF ((@snapAddonReq = 1) AND (@snapAddonDB <> 1))
	BEGIN
		-- Addon is not set and plan already has support for it
		DECLARE @snapAddonStatusEnabled VARCHAR(32) = CAST(@snapAddonSupported AS VARCHAR(32))
EXEC AppPlanSetEntityValueV2 @i_planId, 'Snap Addon', @snapAddonStatusEnabled, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)
	END
ELSE IF ((@snapAddonReq = 0) AND  (@snapAddonDB = 1))
	BEGIN
		-- 1- SNAP
		DECLARE @snapAddonStatusDisabled VARCHAR(32) = CAST(@snapAddonSupported AS VARCHAR(32))
EXEC AppPlanSetEntityValueV2 @i_planId, 'Snap Addon', @snapAddonStatusDisabled, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)
	END
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    -- update plan Addon status - Database
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    -- At this time, also get flag for enabling database Addon
DECLARE @databaseAddonReq INT = ISNULL((SELECT ref.value('@database', 'INT') AS id FROM @x_xmlData.nodes('Api_UpdatePlanReq/summary/addons') R ( ref )), 2)
DECLARE @databaseAddonDB INT = ISNULL(dbo.AppPlanGetEntityValueV2(@i_planId, 'Database Addon', 0), 2)
DECLARE @logSchedulePolicyDB INT = ISNULL(dbo.AppPlanGetEntityValueV2(@i_planId, 'Log schedule policy', 0), 0)
    -- Not Set with valid log schedule policy ID OR
    -- Request with database Addon enabled where it is not already enabled and already have log schedule policy
IF (((@databaseAddonReq = 2) OR (@databaseAddonReq = 1)) AND (@logSchedulePolicyDB >0) AND (@databaseAddonDB <> 1))
    BEGIN
	    -- Addon is not set and plan has log schedule policy, then enable it
DECLARE @dbAddonStatusEnabled VARCHAR(32) = CAST(1 AS VARCHAR(32))
EXEC AppPlanSetEntityValueV2 @i_planId, 'Database Addon', @dbAddonStatusEnabled, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)
    END
ELSE IF ((@databaseAddonReq = 0) AND  (@databaseAddonDB = 1))
    BEGIN
	    -- Before we disable, check if there are no database subclient associated with this plan.
	    -- If yes, then send error and don't disable it.
	    IF NOT EXISTS (SELECT 1 FROM APP_SubClientProp ASCP WITH(NOLOCK)
					    INNER JOIN APP_Application AAP  WITH(NOLOCK)
						    ON AAP.id=ASCP.componentNameId
INNER JOIN dbo.SplitIDs('3,5,22,80,81,135,125,104,37,62,80')
						    ON AAP.appTypeId= _ID
WHERE attrName='Associated Plan' AND attrVal=CAST(@i_planId AS NVARCHAR(32)) AND ASCP.modified=0)
    BEGIN
DECLARE @dbAddonStatusDisabled VARCHAR(32) = CAST(0 AS VARCHAR(32))
EXEC AppPlanSetEntityValueV2 @i_planId, 'Database Addon', @dbAddonStatusDisabled, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)
	    END
	    ELSE
	    BEGIN
		    -- Set the error code and error message
SET @errorCode = (3781 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		    SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @errorCode and localeid = @i_localeId)
		    SET @errorString = REPLACE(@errorString, '^1%s', @i_planName)
INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)
	    END
    END
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    -- update plan Addon status - File system
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    -- At this time, also get flag for enabling database Addon
DECLARE @filesystemAddonReq INT = ISNULL((SELECT ref.value('@filesystem', 'INT') AS id FROM @x_xmlData.nodes('Api_UpdatePlanReq/summary/addons') R ( ref )), 2)
DECLARE @filesystemAddonDB INT = ISNULL(dbo.AppPlanGetEntityValueV2(@i_planId, 'FileSystem Addon', 0), 2)
DECLARE @subclientPolicyDBWin INT = ISNULL(dbo.AppPlanGetEntityValueV2(@i_planId, 'Subclient policy 2', 0), 0)
DECLARE @subclientPolicyDBLinux INT = ISNULL(dbo.AppPlanGetEntityValueV2(@i_planId, 'Subclient policy 3', 0), 0)
DECLARE @subclientPolicyDBMac INT = ISNULL(dbo.AppPlanGetEntityValueV2(@i_planId, 'Subclient policy 4', 0), 0)
    DECLARE @subclientPolicyDB INT = IIF(@subclientPolicyDBWin > 0, @subclientPolicyDBWin, IIF(@subclientPolicyDBLinux > 0, @subclientPolicyDBLinux, @subclientPolicyDBMac))
    -- Not Set with valid log schedule policy ID OR
    -- Request with database Addon enabled where it is not already enabled and already have log schedule policy
IF (((@filesystemAddonReq = 2) OR (@filesystemAddonReq = 1)) AND (@subclientPolicyDB >0) AND (@filesystemAddonDB <> 1))
    BEGIN
	    -- Addon is not set and plan has log schedule policy, then enable it
DECLARE @fsAddonStatusEnabled VARCHAR(32) = CAST(1 AS VARCHAR(32))
EXEC AppPlanSetEntityValueV2 @i_planId, 'FileSystem Addon', @fsAddonStatusEnabled, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)
    END
ELSE IF ((@filesystemAddonReq = 0) AND  (@filesystemAddonDB = 1))
    BEGIN
	    -- Before we disable, check if there are no database subclient associated with this plan.
	    -- If yes, then send error and don't disable it.
    IF NOT EXISTS (SELECT 1 FROM APP_SubClientProp ASCP WITH(NOLOCK)
				    INNER JOIN APP_Application AAP  WITH(NOLOCK)
						    ON AAP.id=ASCP.componentNameId
					    INNER JOIN APP_BackupSetProp ABP  WITH(NOLOCK)
						    ON ABP.componentNameId=AAP.backupSet AND ABP.attrName='Associated subclient Policy' AND ABP.modified=0
WHERE ASCP.attrName='Associated Plan' AND ASCP.attrVal=CAST(@i_planId AS NVARCHAR(32)) AND ASCP.modified=0
							    AND ABP.attrVal IN (CAST(@subclientPolicyDBWin AS NVARCHAR(32)), CAST(@subclientPolicyDBLinux AS NVARCHAR(32)), CAST(@subclientPolicyDBMac AS NVARCHAR(32))))
    BEGIN
DECLARE @fsAddonStatusDisabled VARCHAR(32) = CAST(0 AS VARCHAR(32))
EXEC AppPlanSetEntityValueV2 @i_planId, 'FileSystem Addon', @fsAddonStatusDisabled, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)
	    END
	    ELSE
	    BEGIN
		    -- Set the error code and error message
SET @errorCode = (3807 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		    SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @errorCode and localeid = @i_localeId)
		    SET @errorString = REPLACE(@errorString, '^1%s', @i_planName)
INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)
	    END
    END
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- update plan Index copy status - Index copy addon for case manager clients
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    -- At this time, also get flag for enabling database Addon
DECLARE @indexCopyAddonReq INT = ISNULL((SELECT ref.value('@indexCopy', 'INT') AS id FROM @x_xmlData.nodes('Api_UpdatePlanReq/summary/addons') R ( ref )), 2)
DECLARE @indexCopyAddonDB  INT = ISNULL(dbo.AppPlanGetEntityValueV2(@i_planId, 'Index Copy Addon', 0), 2)
DECLARE @indexCopySchedulePolicyDB INT = ISNULL(dbo.AppPlanGetEntityValueV2(@i_planId, 'Index copy schedule policy', 0), 0)
    -- Not Set with valid log schedule policy ID OR
    -- Request with database Addon enabled where it is not already enabled and already have log schedule policy
IF (((@indexCopyAddonReq = 2) OR (@indexCopyAddonReq = 1)) AND (@indexCopySchedulePolicyDB >0) AND (@indexCopyAddonDB <> 1))
    BEGIN
	-- Addon is not set and plan has log schedule policy, then enable it
DECLARE @addonStatusEnabled VARCHAR(32) = CAST(1 AS VARCHAR(32))
EXEC AppPlanSetEntityValueV2 @i_planId, 'Index Copy Addon', @addonStatusEnabled, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)
    END
ELSE IF ((@indexCopyAddonReq = 0) AND  (@indexCopyAddonDB = 1))
    BEGIN
    	-- Before we disable, check if there are no Case manger clients subclient associated with this plan.
    	-- If yes, then send error and don't disable it.
    	IF NOT EXISTS (SELECT 1 FROM APP_SubClientProp ASCP WITH(NOLOCK)
						INNER JOIN APP_Application AAP  WITH(NOLOCK)
							ON AAP.id=ASCP.componentNameId
						INNER JOIN App_ClientProp
							ON App_ClientProp.componentNameId = AAP.clientId
							AND App_ClientProp.attrName = 'Case Manager Pseudo Client' --- CV_PROP_CASE_MANAGER_PSEUDO_CLIENT = "Case Manager Pseudo Client";
							AND App_ClientProp.attrval = '1'
WHERE ASCP.attrName='Associated Plan' AND ASCP.attrVal=CAST(@i_planId AS NVARCHAR(32)) AND ASCP.modified=0)
	BEGIN
DECLARE @addonStatusDisabled VARCHAR(32) = CAST(0 AS VARCHAR(32))
EXEC AppPlanSetEntityValueV2 @i_planId, 'Index Copy Addon', @addonStatusDisabled, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode != 0 INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)
		END
		ELSE
		BEGIN
			-- Set the error code and error message
SET @errorCode = (3903 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @errorCode and localeid = @i_localeId)
			SET @errorString = REPLACE(@errorString, '^1%s', @i_planName)
INSERT INTO #AppPlanUpdate_tmp__ExecutionErrors VALUES (158, @errorCode, @errorString)
		END
	END
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanUpdateAddonV2')
	delete from GxQscripts where name = 'AppPlanUpdateAddonV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdateAddonV2')
	delete from GXDBVersions where aliasname = 'AppPlanUpdateAddonV2'
GO

insert into GXDBVersions values(2, 'AppPlanUpdateAddonV2',  '00010001000200060000', 'AppPlanUpdateAddonV2', '00010001000200060000')
GO

