

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanUpdate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanUpdate.sp,v $ $Id: AppPlanUpdate.sp,v 1.1.2.39 2018/08/30 22:14:24 snagendra Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppPlanUpdate <<<'

IF EXISTS (select * from sysobjects where name='AppPlanUpdate')
	drop procedure AppPlanUpdate
IF EXISTS (select * from GxQscripts where name='AppPlanUpdate')
	delete from GxQscripts where name = 'AppPlanUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdate')
	delete from GXDBVersions where aliasname = 'AppPlanUpdate'
GO
print '... Creating Procedure: AppPlanUpdate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanUpdate
  @i_userId INT,
  @i_localeId INT,
  @x_xmlData XML OUTPUT 
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
-------------------------------------------------------------------------------------------------------------------------------------------
--Code Below Here is From AppPlanConstants.spb
-- declare plan properties definition shared values
DECLARE @constAttrType_BasePlan					INT = 260
DECLARE @constAttrName_BasePlan					NVARCHAR(32) = N'BasePlan'
DECLARE @constAttrType_Feature					INT = 261
DECLARE @constAttrName_Feature					NVARCHAR(32) = N'Feature'
DECLARE @constAttrType_Alert					INT = 262
DECLARE @constAttrName_Alert					NVARCHAR(32) = N'Alert'
DECLARE @constAttrType_AccessPolicy				INT = 263
DECLARE @constAttrName_AccessPolicy				NVARCHAR(32) = N'Access policy'
DECLARE @constAttrType_Policy_Subclient			INT = 264
DECLARE @constAttrName_Policy_Subclient			NVARCHAR(32) = N'Subclient policy'
DECLARE @constAttrType_Policy_Schedule			INT = 265
DECLARE @constAttrName_Policy_Schedule			NVARCHAR(32) = N'Schedule policy'
DECLARE @constAttrType_Policy_Storage			INT = 266
DECLARE @constAttrName_Policy_Storage			NVARCHAR(32) = N'Storage policy'
DECLARE @constAttrType_Options					INT = 267
DECLARE @constAttrName_Options_Quota			NVARCHAR(32) = 'Quota'
DECLARE @constAttrName_Options_EdgeDriveQuota	NVARCHAR(32) = 'Edge Drive Quota Size'
DECLARE @constAttrName_Options_Throttle			NVARCHAR(32) = 'Network Throttle'
DECLARE @constAttrType_UserGroupAssigned		INT = 268
DECLARE @constAttrName_UserGroupAssigned		NVARCHAR(32) = 'Assigned user group'
DECLARE @constAttrType_UserGroupIAssoc			INT = 269
DECLARE @constAttrName_UserGroupIAssoc			NVARCHAR(32) = 'Associated internal user group'
DECLARE @constAttrType_UserGroupEAssoc			INT = 270
DECLARE @constAttrName_UserGroupEAssoc			NVARCHAR(32) = 'Associated external user group'
DECLARE @constAttrType_Restrictions				INT = 271
DECLARE @constAttrName_Restrictions				NVARCHAR(32) = 'Entity restrictions'
DECLARE @constAttrType_AssociatedPlan			INT = 272
DECLARE @constAttrName_AssociatedPlan			NVARCHAR(32) = 'Associated Plan'
DECLARE @constAttrType_ClientGroupAssigned		INT = 273
DECLARE @constAttrName_ClientGroupAssigned		NVARCHAR(32) = 'Assigned client group'
DECLARE @constAttType_ScheduledForDeletion		INT = 274
DECLARE @constAttName_ScheduledForDeletion		NVARCHAR(32) = 'Scheduled for deletion'
DECLARE @constAttType_EdgeDriveAssigned  		INT = 275
DECLARE @constAttName_EdgeDriveAssigned 		NVARCHAR(32) = 'Assgined Edge Drive'
DECLARE @constAttrType_Policy_SubclientWin		INT = 276
DECLARE @constAttrName_Policy_SubclientWin		NVARCHAR(32) = N'Subclient policy 2'
DECLARE @constAttrType_Policy_SubclientLin		INT = 277
DECLARE @constAttrName_Policy_SubclientLin		NVARCHAR(32) = N'Subclient policy 3'
DECLARE @constAttrType_Policy_SubclientMac		INT = 278
DECLARE @constAttrName_Policy_SubclientMac		NVARCHAR(32) = N'Subclient policy 4'
DECLARE @constAttType_SubclientRetention		INT = 279
DECLARE @constAttName_SubclientRetention		NVARCHAR(32) = 'Subclient retention period'
DECLARE @constAttType_SubclientVersions			INT = 280
DECLARE @constAttName_SubclientVersions			NVARCHAR(32) = 'Number of Synth Full Versions'
DECLARE @constAttrType_Policy_ScheduleLog   		INT = 281
DECLARE @constAttrName_Policy_ScheduleLog   		NVARCHAR(32) = N'Log schedule policy'
DECLARE @constAttrType_Policy_StorageLog    		INT = 282
DECLARE @constAttrName_Policy_StorageLog   		 NVARCHAR(32) = N'Log storage policy'
DECLARE @constAttType_SlaInMinutes			INT = 283
DECLARE @constAttName_SlaInMinutes			NVARCHAR(32) = N'SLA In Minutes'
DECLARE @constAttType_LogSlaInMinutes			INT = 285
DECLARE @constAttName_LogSlaInMinutes			NVARCHAR(32) = N'Log SLA In Minutes'
DECLARE @constAttType_ReplicationTargets    		INT = 284
DECLARE @constAttName_ReplicationTargets   		 NVARCHAR(32) = N'Replication schedule policy'
DECLARE @constAttType_ForcedArchiving   		INT = 286
DECLARE @constAttName_ForcedArchiving   		 NVARCHAR(32) = N'Forced Archiving'
-- plan entity identifiers are declared in http:--ncvs/source/xref/win/vaultcx/Source/Common/XmlMessage/Api.x : enum PlanEntities
DECLARE @constPlanEntity_StoragePolicy		 INT =   1
DECLARE @constPlanEntity_SubclientPolicy	 INT =   2
DECLARE @constPlanEntity_SchedulePolicy		 INT =   4
DECLARE @constPlanEntity_Features			 INT =   8
DECLARE @constPlanEntity_Users				 INT =  16
DECLARE @constPlanEntity_Alerts				 INT =  32
DECLARE @constPlanEntity_AccessPolicies		 INT =  64
DECLARE @constPlanEntity_Options			 INT = 128
DECLARE @constPlanEntity_SubclientPolicy_Win INT = 256
DECLARE @constPlanEntity_SubclientPolicy_Lin INT = 512
DECLARE @constPlanEntity_SubclientPolicy_Mac INT = 1024
DECLARE @constPlanEntity_ClientGroup		 INT = 2048
DECLARE @constPlanEntity_EdgeDrive           INT = 4096
DECLARE @constPlanEntity_StoragePolicyLog	 INT = 8192
DECLARE @constPlanEntity_SchedulePolicyLog   INT = 16384
DECLARE @constPlanEntity_ReplicationTargets	 INT = 32768
-- entity operations. declared in http:--ncvs/source/xref/11.0-win/vaultcx/Source/Common/XmlMessage/CVGui.x#197 : enum ListOperationType
DECLARE @constOpType_NONE					INT = 0
DECLARE @constOpType_OVERWRITE				INT = 1
DECLARE @constOpType_ADD					INT = 2
DECLARE @constOpType_DELETE					INT = 3
DECLARE @constOpType_CLEAR					INT = 4
-------------------------------------------------------------------------------------------------------------------------------------------
DECLARE @debug INT = 0
DECLARE @currentTime INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
DECLARE @planId      INT = (SELECT ISNULL(ref.value('@planId', 'INT'),'') AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/summary/plan') R ( ref ))
DECLARE @tblIds AS TABLE (id NVARCHAR(32))
DECLARE @userHasCapabilityUpdate INT = 0
DECLARE @userHasCapabilityInvite INT = 0
DECLARE @tblToUpdate AS TABLE (id INT, restrictions BIGINT)
DECLARE @iterator INT = 0;
DECLARE @errorCode		INT = 0
DECLARE @errorString	NVARCHAR(MAX) = NULL
DECLARE @executionErrors AS TABLE (__type__ INT, errCode INT, errMessage NVARCHAR(250))
DECLARE @continue BIT = 1
DECLARE @x_xmlGroupResp     XML
DECLARE @opMsgId int = 0
DECLARE @opId int = 0
DECLARE @dataIsEvent		INT = 0
DECLARE @opEvMsgId			INT = 0
DECLARE @paramMsgId			INT = 0
DECLARE @adminUserId INT = ISNULL((SELECT  TOP 1 UG.userId
                                   FROM    UMUserGroup UG INNER JOIN UMGroups G ON G.id = UG.groupId
                                                          INNER JOIN UMUsers  U ON U.id = UG.groupId AND G.allAssociations = 1 AND G.allCapabilities = 1 AND G.selfAssociation = 1 AND U.enabled = 1), 0)
DECLARE @planSubType INT =  (SELECT subType FROM App_Plan WHERE id = @planId)
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__UsersToBeDeassociated') IS NOT NULL DROP TABLE #AppPlanUpdate_tmp__UsersToBeDeassociated
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__UsersToBeReassociated') IS NOT NULL DROP TABLE #AppPlanUpdate_tmp__UsersToBeReassociated
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__Security_VisibleUsers')  IS NOT NULL DROP TABLE #AppPlanUpdate_tmp__Security_VisibleUsers
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__Security_VisibleUsersGroups')  IS NOT NULL DROP TABLE #AppPlanUpdate_tmp__Security_VisibleUsersGroups
CREATE TABLE #AppPlanUpdate_tmp__UsersToBeDeassociated(userId integer)
CREATE TABLE #AppPlanUpdate_tmp__UsersToBeReassociated(userId integer)
CREATE TABLE #AppPlanUpdate_tmp__Security_VisibleUsers(userId integer)
CREATE TABLE #AppPlanUpdate_tmp__Security_VisibleUsersGroups(userGroupId integer);
IF (NOT EXISTS (SELECT id FROM App_Plan WHERE (id = @planId) AND ((flag & 0x00004) = 0) AND ((flag & 0x40000000) = 0) )   )
BEGIN
INSERT INTO @executionErrors VALUES (158, 2, N'Plan not found')
    SET @continue = 0
END
-- to check if user has rights to mofify plan
IF @continue = 1 BEGIN
    EXEC sec_checkPermissionOnEntity @i_userId, 157, @userHasCapabilityUpdate OUTPUT, 158, @planId
	EXEC sec_checkPermissionOnEntity @i_userId, 159, @userHasCapabilityInvite OUTPUT, 158, @planId
    IF (@userHasCapabilityUpdate = 0) AND (@userHasCapabilityInvite = 0) AND (NOT EXISTS (SELECT id FROM App_Plan WHERE id = @planId AND ownerId = @i_userId)) BEGIN
        INSERT INTO @executionErrors VALUES (158, 5, N'Access denied.')
        SET @continue = 0
    END
END
IF @continue = 1 BEGIN
    BEGIN TRY
        BEGIN TRANSACTION
		IF @userHasCapabilityUpdate = 1
		BEGIN
        -- prepare table that contains all plans that has to be updated with new values : plan itself and all children of the plan
        -- with their restrictions
        -- there are 2 ways to do it:
        -- 1. have nested select and get everything in one shot
        -- 2. have two separate queries - first will find all children and second will get their restrictions
        -- test shows that on small amount of data (3 plans, ~55 record in the table) first aproach is 1.8 times faster (36% vs 64%)
        --                 on large amount of data (100,000 plans, ~1,200,000 records) first and second aproaches are equal (50% vs 50%)
        --                 on medium amount of data (200 plans, 2,400 records) first aproach is 1.3 times faster (43% vs 57%)
        -- use first approach
        INSERT INTO @tblToUpdate(id, restrictions)
            -- plan itself
            SELECT @planId, ISNULL((SELECT CAST(attrVal AS BIGINT) FROM App_PlanProp WHERE attrType = @constAttrType_Restrictions AND componentNameId = @planId), 0)
            UNION
            -- children
            SELECT  PP.componentNameId, ISNULL((SELECT  CAST(attrVal AS BIGINT)
                                                FROM    App_PlanProp PP2
                                                WHERE       PP2.componentNameId = PP.componentNameId
                                                        AND PP2.attrType = @constAttrType_Restrictions), 0)
            FROM    App_PlanProp PP
            WHERE       attrType = @constAttrType_BasePlan
                    AND attrVal = CAST(@planId AS NVARCHAR(32))
        -- ========================================================================================================================================================================
        -- start updating
        -- ========================================================================================================================================================================
		DECLARE @planName NVARCHAR(255)
		DECLARE @ownerId INT
		SELECT @planName = name, @ownerId = ownerId FROM APP_Plan WHERE id = @planId
        -- update plan name if requested
        DECLARE @newPlanName NVARCHAR(255) = (SELECT ref.value('@planName', 'nvarchar(255)') AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/summary/plan') R ( ref ))
        IF @newPlanName IS NOT NULL BEGIN
            UPDATE App_Plan SET name = @newPlanName WHERE id = @planId
            SET @planName = @newPlanName
        END
        -- update plan description if requested
        DECLARE @planDesc NVARCHAR(MAX) = (SELECT ref.value('@description', 'nvarchar(max)') AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/summary') R ( ref ))
        IF @planDesc IS NOT NULL BEGIN
            UPDATE App_Plan SET description = @planDesc WHERE id = @planId
        END
        -- update plan status if requested
		DECLARE @planStatus  INT =  (SELECT ref.value('@planStatusFlag', 'INT') AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/summary') R ( ref ))
		IF @planStatus IS NOT NULL BEGIN
			-- status change requested. store new value. if attempt to enable was made then actual status will be calculated at the very end of the this proc
			IF @planStatus = 0 OR @planStatus = 1 BEGIN
				UPDATE App_Plan SET flag = @planStatus WHERE id = @planId
			END
		END
		---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		-- update SLA And default SLA flag if Absent
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		DECLARE @planSType INT = NULL
        SELECT @planSType = subType FROM App_Plan WHERE id = @planId
		DECLARE @newSla INT = (SELECT ref.value('@slaInMinutes', 'INT') FROM @x_xmlData.nodes('Api_UpdatePlanReq/summary') R ( ref ))
		DECLARE @oldSla INT = (SELECT attrVal AS INT FROM App_PlanProp WHERE componentNameId = @planId AND attrName = @constAttName_SlaInMinutes)
		DECLARE @policyID INT = (SELECT attrVal FROM App_PlanProp WHERE attrType=@constAttrType_Policy_Schedule AND componentNameId = @planId)
DECLARE @sTskId INT = (SELECT ST.subTaskId FROM TM_SubTask ST where ST.taskId = @policyID AND ST.flags = CONVERT(INT,0x10000))
		DECLARE @slaDefaultCount INT = 0
		DECLARE @updateCount INT = 0
		DECLARE @autoIncrPattXML XML = NULL
		IF @newSla <> @oldSla
			UPDATE App_PlanProp SET attrVal = CAST(@newSla AS NVARCHAR(32)) WHERE componentNameId = @planId AND attrName = @constAttName_SlaInMinutes
		IF @planSType IN (33554437 /*Server*/, 33579013 /*Database*/, 50331655 /*FSServer*/ , 67108869 /*Snap*/, 83886085 /*VSAServer*/, 83918853 /*VSAReplication*/)
		BEGIN
			-- For Plans with Daily Incremental Schedules
			IF @newSla IS NOT NULL
			BEGIN
				IF @newSla <> @oldSla
				BEGIN
					UPDATE App_PlanProp SET attrVal = CAST(@newSla AS NVARCHAR(32)) WHERE componentNameId = @planId AND attrName = @constAttName_SlaInMinutes
				END
				IF @policyID IS NOT NULL
				BEGIN
					SET ROWCOUNT 0
					SELECT @slaDefaultCount = COUNT(*) FROM TM_SubTask ST
					WHERE ST.subTaskId = @sTskId
					IF @slaDefaultCount = 0
					BEGIN
UPDATE ST SET ST.flags = CONVERT(INT,0x10000)
						FROM TM_SubTask ST
						INNER JOIN TM_SubTaskOptions O WITH(NOLOCK)
							ON ST.subTaskId = O.subTaskId
						INNER JOIN TM_PatternAssoc PA WITH(NOLOCK)
							ON PA.subTaskId = ST.subTaskId
						INNER JOIN TM_Pattern P WITH(NOLOCK)
							ON P.patternId = PA.patternId
WHERE O.optionId = 458405394 AND
								ST.taskId = @policyID AND
								P.freq_subday_interval <> 0 AND
								O.value = 2 AND --2 for Incremental
								P.freq_type = 4 --4 for Daily
						SELECT @updateCount = @@ROWCOUNT
					END
					ELSE
					BEGIN
						SET @updateCount = 1
					END
					UPDATE P SET P.freq_subday_interval = @newSla * 60
					FROM TM_Pattern P
					INNER JOIN TM_PatternAssoc PA WITH(NOLOCK)
						on P.patternId = PA.patternId
					WHERE PA.subTaskId = @sTskId
				END
				IF @updateCount <> 1
				BEGIN
					INSERT INTO @executionErrors VALUES(35,500,'Error in SLA Flag Updation')
				END
			END
		END
		IF @planSType IN ( 33554439/*Laptop*/, 16777223/*DLO*/, 33579013 /*Database*/)
		BEGIN
			IF @planSType = 33579013
			BEGIN
				-- For DB plan with LOG Automatic Schedule
				SET @newSla = (SELECT ref.value('@slaInMinutes', 'INT') FROM @x_xmlData.nodes('Api_UpdatePlanReq/database') R ( ref ))
				SET @oldSla = (SELECT attrVal AS INT FROM App_PlanProp WHERE componentNameId = @planId AND attrType = @constAttType_SlaInMinutes)
				SET @policyID = (SELECT attrVal FROM App_PlanProp WHERE attrType=@constAttrType_Policy_ScheduleLog AND componentNameId = @planId)
SET @sTskId = (SELECT ST.subTaskId FROM TM_SubTask ST where ST.taskId = @policyID AND ST.flags = CONVERT(INT,0x10000))
				IF @newSla <> @oldSla
					UPDATE App_PlanProp SET attrVal = CAST(@newSla AS NVARCHAR(32)) WHERE componentNameId = @planId AND attrType = @constAttType_LogSlaInMinutes
			END
			-- For plans with Automatic Schedules
			IF @newSla <> @oldSla
			BEGIN
				SELECT @autoIncrPattXML = xmlValue FROM TM_SubTaskXMLOptions STXO
					WHERE STXO.subTaskId = @sTskId
				DECLARE @hrs INT = @newSla/60
				DECLARE @min INT = @newSla % 60
				IF @autoIncrPattXML IS NOT NULL
				BEGIN
					SET @autoIncrPattXML.modify('replace value of (/TMMsg_JobOption/commonOpts/automaticSchedulePattern/@maxBackupInterval)[1] with sql:variable("@hrs")')
					SET @autoIncrPattXML.modify('replace value of (/TMMsg_JobOption/commonOpts/automaticSchedulePattern/@maxBackupIntervalMinutes)[1] with sql:variable("@min")')
					UPDATE STXO SET STXO.xmlValue = @autoIncrPattXML
						FROM TM_SubTaskXMLOptions STXO
							WHERE STXO.subTaskId = @sTskId
				END
			END
		END
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        -- update schedule
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        DECLARE @scheduleId INT = (SELECT ISNULL(ref.value('@taskId', 'INT'),'') AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/schedule/task') R ( ref ))
        IF @scheduleId IS NOT NULL BEGIN
            -- normalize value if necessary
            DECLARE @scheduleIdNum bigint = CAST(@scheduleId AS bigint)
            IF @scheduleIdNum  > 0x7FFFFFFF BEGIN -- @scheduleId actually holds schedule creation error value. convert it back to signed integer to store in prop table
	            SET @scheduleId = CAST(-(((0xFFFFFFFF - @scheduleIdNum) + 1)) AS NVARCHAR(32))
            END
            -- update or insert
            MERGE   App_PlanProp AS TGT
            USING   (SELECT id FROM @tblToUpdate WHERE (restrictions & @constPlanEntity_SchedulePolicy) = 0) AS SRC(componentNameId)
            ON      TGT.componentNameId = SRC.componentNameId AND TGT.attrType = @constAttrType_Policy_Schedule
            WHEN    MATCHED     THEN UPDATE SET
                        TGT.attrVal  = CAST(@scheduleId AS NVARCHAR(32)), TGT.modified = @currentTime
            WHEN    NOT MATCHED THEN INSERT VALUES
                        (SRC.componentNameId, @constAttrName_Policy_Schedule, @constAttrType_Policy_Schedule, CAST(@scheduleId AS NVARCHAR(32)), @currentTime, 0);
        END
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        -- update storage
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        DECLARE @storageId INT = (SELECT ISNULL(ref.value('@storagePolicyId', 'INT'),'') AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/storage/storagePolicy ') R ( ref ))
        IF @storageId IS NOT NULL BEGIN
            -- normalize value if necessary
            DECLARE @storageIdNum bigint = CAST(@storageId AS bigint)
            IF @storageIdNum  > 0x7FFFFFFF BEGIN -- @storageId actually holds storage creation error value. convert it back to signed integer to store in prop table
	            SET @storageId = CAST(-(((0xFFFFFFFF - @storageIdNum) + 1)) AS NVARCHAR(32))
            END
            -- update or insert
            MERGE   App_PlanProp AS TGT
            USING   (SELECT id FROM @tblToUpdate WHERE (restrictions & @constPlanEntity_StoragePolicy) = 0) AS SRC(componentNameId)
            ON      TGT.componentNameId = SRC.componentNameId AND TGT.attrType = @constAttrType_Policy_Storage
            WHEN    MATCHED THEN UPDATE SET
                        TGT.attrVal  = CAST(@storageId AS NVARCHAR(32)), TGT.modified = @currentTime
            WHEN    NOT MATCHED THEN INSERT VALUES
                        (SRC.componentNameId, @constAttrName_Policy_Storage, @constAttrType_Policy_Storage, CAST(@storageId AS NVARCHAR(32)), @currentTime, 0);
        END
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        -- update log schedule
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        DECLARE @logScheduleId INT = (SELECT ISNULL(ref.value('@taskId', 'INT'),'') AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/database/scheduleLog/task') R ( ref ))
        IF @logScheduleId IS NOT NULL BEGIN
            -- normalize value if necessary
            DECLARE @logScheduleIdNum bigint = CAST(@logScheduleId AS bigint)
            IF @logScheduleIdNum  > 0x7FFFFFFF BEGIN -- @logScheduleId actually holds schedule creation error value. convert it back to signed integer to store in prop table
	            SET @logScheduleId = CAST(-(((0xFFFFFFFF - @logScheduleIdNum) + 1)) AS NVARCHAR(32))
            END
            -- update or insert
            MERGE   App_PlanProp AS TGT
            USING   (SELECT id FROM @tblToUpdate WHERE (restrictions & @constPlanEntity_SchedulePolicyLog) = 0) AS SRC(componentNameId)
            ON      TGT.componentNameId = SRC.componentNameId AND TGT.attrType = @constAttrType_Policy_ScheduleLog
            WHEN    MATCHED THEN UPDATE SET
                        TGT.attrVal  = CAST(@logScheduleId AS NVARCHAR(32)), TGT.modified = @currentTime
            WHEN    NOT MATCHED THEN INSERT VALUES
                        (SRC.componentNameId, @constAttrName_Policy_ScheduleLog, @constAttrType_Policy_ScheduleLog, CAST(@logScheduleId AS NVARCHAR(32)), @currentTime, 0);
        END
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        -- update log storage
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        DECLARE @logStorageId INT = (SELECT ISNULL(ref.value('@storagePolicyId', 'INT'),'') AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/database/storageLog/storagePolicy ') R ( ref ))
        IF @logStorageId IS NOT NULL BEGIN
            -- normalize value if necessary
            DECLARE @logStorageIdNum bigint = CAST(@logStorageId AS bigint)
            IF @logStorageIdNum > 0x7FFFFFFF BEGIN -- @logStorageId actually holds storage creation error value. convert it back to signed integer to store in prop table
	            SET @logStorageId = CAST(-(((0xFFFFFFFF - @logStorageIdNum) + 1)) AS NVARCHAR(32))
            END
            -- update or insert
            MERGE   App_PlanProp AS TGT
            USING   (SELECT id FROM @tblToUpdate WHERE (restrictions & @constPlanEntity_StoragePolicyLog) = 0) AS SRC(componentNameId)
            ON      TGT.componentNameId = SRC.componentNameId AND TGT.attrType = @constAttrType_Policy_StorageLog
            WHEN    MATCHED THEN UPDATE SET
                        TGT.attrVal  = CAST(@logStorageId AS NVARCHAR(32)), TGT.modified = @currentTime
            WHEN    NOT MATCHED THEN INSERT VALUES
                        (SRC.componentNameId, @constAttrName_Policy_StorageLog, @constAttrType_Policy_StorageLog, CAST(@logStorageId AS NVARCHAR(32)), @currentTime, 0);
        END
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        -- update features
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        DECLARE @featuresRoleId INT = (SELECT ISNULL(ref.value('@roleId', 'INT'),'') AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/laptop/features/feature/role') R ( ref ))
        IF @featuresRoleId IS NOT NULL BEGIN
            -- normalize value if necessary
            DECLARE @featuresRoleIdNum bigint = CAST(@featuresRoleId AS bigint)
            IF @featuresRoleIdNum  > 0x7FFFFFFF BEGIN -- @featuresRoleId actually holds role creation error value. convert it back to signed integer to store in prop table
	            SET @featuresRoleId = CAST(-(((0xFFFFFFFF - @featuresRoleIdNum) + 1)) AS NVARCHAR(32))
            END
            -- update or insert
            MERGE   App_PlanProp AS TGT
            USING   (SELECT id FROM @tblToUpdate WHERE (restrictions & @constPlanEntity_Features) = 0) AS SRC(componentNameId)
            ON      TGT.componentNameId = SRC.componentNameId AND TGT.attrType = @constAttrType_Feature
            WHEN    MATCHED THEN UPDATE SET
                        TGT.attrVal  = CAST(@featuresRoleId AS NVARCHAR(32)), TGT.modified = @currentTime
            WHEN    NOT MATCHED THEN INSERT VALUES
                        (SRC.componentNameId, @constAttrName_Feature, @constAttrType_Feature, CAST(@featuresRoleId AS NVARCHAR(32)), @currentTime, 0);
        END
		---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        -- update Default Plan Level Archiving
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		DECLARE @forcedArchivingEnabled INT = (SELECT ISNULL(ref.value('@forcedArchiving', 'INT'),0) AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/options') R ( ref ))
EXEC AppPlanSetEntityValueV2 @planId, 'Forced Archiving', @forcedArchivingEnabled, @errorCode OUTPUT, @errorString OUTPUT
		IF @errorCode != 0 INSERT INTO @executionErrors VALUES (154, @errorCode, @errorString)   --154 /*CONFIGURATION_POLICY_ENTITY*/
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        -- update access policy
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        DECLARE @accesspolRoleId INT = (SELECT ISNULL(ref.value('@roleId', 'INT'),'') AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/laptop/accessPolicies/accessPolicy/role') R ( ref ))
        IF @accesspolRoleId IS NOT NULL BEGIN
            -- normalize value if necessary
            DECLARE @accesspolRoleIdNum bigint = CAST(@featuresRoleId AS bigint)
            IF @accesspolRoleIdNum  > 0x7FFFFFFF BEGIN -- @accesspolRoleId actually holds role creation error value. convert it back to signed integer to store in prop table
	            SET @accesspolRoleId = CAST(-(((0xFFFFFFFF - @accesspolRoleIdNum) + 1)) AS NVARCHAR(32))
            END
            -- update or insert
            MERGE   App_PlanProp AS TGT
            USING   (SELECT id FROM @tblToUpdate WHERE (restrictions & @constPlanEntity_AccessPolicies) = 0) AS SRC(componentNameId)
            ON      TGT.componentNameId = SRC.componentNameId AND TGT.attrType = @constAttrType_AccessPolicy
            WHEN    MATCHED THEN UPDATE SET
                        TGT.attrVal  = CAST(@accesspolRoleId AS NVARCHAR(32)), TGT.modified = @currentTime
            WHEN    NOT MATCHED THEN INSERT VALUES
                        (SRC.componentNameId, @constAttrName_AccessPolicy, @constAttrType_AccessPolicy, CAST(@accesspolRoleId AS NVARCHAR(32)), @currentTime, 0);
        END
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        -- update subclient policies
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        DECLARE @opType INT = (SELECT ISNULL(ref.value('@backupContentOperationType', 'INT'),'') AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/laptop/content') R ( ref ))
        IF @opType <> @constOpType_NONE BEGIN
            IF @opType = @constOpType_OVERWRITE BEGIN
                -- get apptypes and corresponded subclient ids
                DECLARE @subclientIds AS TABLE( [type] NVARCHAR(32), [id] NVARCHAR(32) )
                INSERT INTO @subclientIds
                    SELECT  ISNULL(ref.value('(../../@idatype)[1]', 'nvarchar(32)'), '') AS [type],
                            ISNULL(ref.value('@backupsetId', 'nvarchar(32)'), '')        AS id
                    FROM    @x_xmlData.nodes('Api_UpdatePlanReq/laptop/content/backupContent/subClientPolicy/backupSetEntity') R (ref)
                -- make sure that error values are negative
                UPDATE @subclientIds SET id = CAST(-(((0xFFFFFFFF - CAST(id AS bigint)) + 1)) AS NVARCHAR(32)) WHERE CAST(id AS bigint) > 0x7FFFFFFF
                SELECT @iterator = MIN([type]) FROM @subclientIds
                WHILE @iterator IS NOT NULL BEGIN
                    DECLARE @value NVARCHAR(32) = (SELECT id FROM @subclientIds WHERE [type] = @iterator)
                    -- update or insert
                    MERGE   App_PlanProp AS TGT
                    USING   (SELECT id FROM @tblToUpdate WHERE (restrictions & @constPlanEntity_SubclientPolicy) = 0) AS SRC(componentNameId)
                    ON          TGT.componentNameId = SRC.componentNameId
                            AND TGT.attrType = @constAttrType_Policy_Subclient
                            AND TGT.attrName = @constAttrName_Policy_Subclient + ' ' + CAST(@iterator AS NVARCHAR(32))
                    WHEN    MATCHED THEN UPDATE SET
                                TGT.attrVal  = @value, TGT.modified = @currentTime
                    WHEN    NOT MATCHED THEN INSERT VALUES
                                (SRC.componentNameId,  @constAttrName_Policy_Subclient + ' ' + CAST(@iterator AS NVARCHAR(32)), @constAttrType_Policy_Subclient, @value, @currentTime, 0);
                    -- next iteration
                    SELECT @iterator = MIN([type]) FROM @subclientIds WHERE [type] > @iterator
                END
            END ELSE IF @opType = @constOpType_DELETE BEGIN
                -- clear the table
                DELETE FROM @tblIds
                -- check what ida types should be cleared
                INSERT INTO @tblIds
                    SELECT ISNULL(ref.value('@idatype', 'nvarchar(32)'), '') FROM @x_xmlData.nodes('Api_UpdatePlanReq/laptop/content/backupContent') R (ref)
                -- mark those specified in the request as empty
                UPDATE  App_PlanProp SET attrVal = '0', modified = @currentTime
                WHERE       attrType = @constAttrType_Policy_Subclient
                        AND componentNameId IN (SELECT id FROM @tblToUpdate WHERE (restrictions & @constPlanEntity_SubclientPolicy) = 0)
                        AND attrName IN (SELECT @constAttrName_Policy_Subclient + ' ' + id FROM @tblIds WHERE id != '')
            END ELSE IF @opType = @constOpType_CLEAR BEGIN
                UPDATE  App_PlanProp SET attrVal = '0', modified = @currentTime
                WHERE       componentNameId IN (SELECT id FROM @tblToUpdate WHERE (restrictions & @constPlanEntity_SubclientPolicy) = 0)
                        AND attrType = @constAttrType_Policy_Subclient
            END
        END
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        -- update alerts
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        SET @opType = (SELECT ISNULL(ref.value('@alertOperationType', 'INT'), @constOpType_NONE) AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/alerts') R ( ref ))
		IF @opType <> @constOpType_NONE BEGIN
            -- get list of ids into local table.
            DELETE FROM @tblIds
            INSERT INTO @tblIds
                SELECT ISNULL(ref.value('@alertId', 'nvarchar(32)'), '') FROM @x_xmlData.nodes('Api_UpdatePlanReq/alerts/alert') R (ref)
		-- Remove recipient cache for all alerts in request so that they are refreshed again
		Delete from NTNotificationProp
where (attrName = 'Recipient UserId' or attrName='Recipient UserGroupId')
		and componentNameId in
		(
			-- New entries as well as older entries
			SELECT	cast(AlertIds.Id as int) AS alertId
			FROM	@tblIds AlertIds
			where IsNumeric(AlertIds.Id)>0
			union
			SELECT   cast(RTRIM(LTRIM(SUBSTRING(attrName, LEN(@constAttrName_Alert) + 1, 32))) as int)
		    FROM	 App_PlanProp PP
		    WHERE    PP.componentNameId IN (SELECT id FROM @tblToUpdate WHERE restrictions & @constPlanEntity_Alerts = 0)
			AND PP.attrType = @constAttrType_Alert
			AND PP.attrVal <> 0 -- return just active ones
		)
            IF @opType = @constOpType_OVERWRITE BEGIN           -- overwrite mode
                -- mark all as inactive
                UPDATE  App_PlanProp SET attrVal = '0', modified = @currentTime
                WHERE       attrType = @constAttrType_Alert
                        AND componentNameId IN (SELECT id FROM @tblToUpdate WHERE restrictions & @constPlanEntity_Alerts = 0)
                -- set as active those that already in database
                -- update or insert
                MERGE   App_PlanProp AS TGT
                USING   (SELECT TUT.id AS componentNameId, TI.id AS alertId FROM @tblToUpdate TUT, @tblIds TI WHERE (TUT.restrictions & @constPlanEntity_Alerts) = 0) AS SRC(componentNameId, alertId)
                ON          TGT.componentNameId = SRC.componentNameId
                        AND TGT.attrType = @constAttrType_Alert
                        AND TGT.attrName = @constAttrName_Alert + ' ' + SRC.alertId
                WHEN    MATCHED THEN UPDATE SET
                            TGT.attrVal  = '1', TGT.modified = @currentTime
                WHEN    NOT MATCHED THEN INSERT VALUES
                            (SRC.componentNameId, @constAttrName_Alert + ' ' + SRC.alertId, @constAttrType_Alert, '1', @currentTime, 0);
            END ELSE IF @opType = @constOpType_ADD BEGIN        -- append mode
                -- update or insert
                MERGE   App_PlanProp AS TGT
                USING   (SELECT TUT.id AS componentNameId, TI.id AS alertId FROM @tblToUpdate TUT, @tblIds TI WHERE (TUT.restrictions & @constPlanEntity_Alerts) = 0) AS SRC(componentNameId, alertId)
                ON          TGT.componentNameId = SRC.componentNameId
                        AND TGT.attrType = @constAttrType_Alert
                        AND TGT.attrName = @constAttrName_Alert + ' ' + SRC.alertId
                WHEN    MATCHED THEN UPDATE SET
                            TGT.attrVal  = '1', TGT.modified = @currentTime
                WHEN    NOT MATCHED THEN INSERT VALUES
                            (SRC.componentNameId, @constAttrName_Alert + ' ' + SRC.alertId, @constAttrType_Alert, '1', @currentTime, 0);
            END ELSE IF @opType = @constOpType_DELETE BEGIN     -- delete mode
                -- mark those specified in the request as inactive
                UPDATE  App_PlanProp SET attrVal = '0', modified = @currentTime
                WHERE       attrType = @constAttrType_Alert
                        AND componentNameId IN (SELECT id FROM @tblToUpdate WHERE (restrictions & @constPlanEntity_Alerts) = 0)
                        AND attrName IN (SELECT @constAttrName_Alert + ' ' + id FROM @tblIds WHERE id != '')
            END ELSE IF @opType = @constOpType_CLEAR BEGIN      -- clear mode
                -- mark all as inactive
                UPDATE  App_PlanProp SET attrVal = '0', modified = @currentTime
                WHERE       attrType = @constAttrType_Alert
                        AND componentNameId IN (SELECT id FROM @tblToUpdate WHERE (restrictions & @constPlanEntity_Alerts) = 0)
            END
        END
		---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        -- update taskIds for replication targets
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		if (@planSType=83918853) --Live Sync .. Api_VSAReplication
		begin
		SET @opType = (SELECT ISNULL(ref.value('@replicationTargetOperationType', 'INT'), @constOpType_NONE) AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/replicationTargets') R ( ref ))
		IF @opType <> @constOpType_NONE
		BEGIN
			Declare @isAnyErrorForRT int = 0
            -- get list of ids into local table.
			Declare @replicationDetails table
			(
				taskId int,
				opType Int
			)
			if ( @opType=@constOpType_ADD OR @opType=@constOpType_OVERWRITE)
			begin
				Insert into @replicationDetails
				SELECT  IsNull(ref.value('@taskId','int'),0),
					@constOpType_ADD
				FROM  @x_xmlData.nodes('Api_UpdatePlanReq/replicationTargets/planReplicationTargets/taskInfo/task') R ( ref )
				-- Update opType to overwrite for already existing entries.
				Update replicationDetails
				set OpType = @constOpType_OVERWRITE
				from @replicationDetails replicationDetails
				inner join APP_PlanProp on APP_PlanProp.componentNameId=@planId
				and attrType=@constAttType_ReplicationTargets
				and taskId=attrval
			end
			else
			begin
				Insert into @replicationDetails
				SELECT  IsNull(ref.value('@taskId','int'),0),
					@constOpType_DELETE
				FROM  @x_xmlData.nodes('Api_UpdatePlanReq/replicationTargets/planReplicationTargets/taskInfo/task') R ( ref )
			end
			Delete from @replicationDetails
			where taskId<=0
			-- For op Type overwrite , we need to delete removed entries.
			if ( @opType=@constOpType_OVERWRITE)
			begin
				Insert into @replicationDetails
				SELECT  APP_PlanProp.attrVal,
					@constOpType_DELETE
				FROM  APP_PlanProp left join @replicationDetails replicationDetails
				on APP_PlanProp.componentNameId=@planId
				and attrType=@constAttType_ReplicationTargets
				and replicationDetails.taskId = APP_PlanProp.attrval
				where replicationDetails.taskId is NULL
				and APP_PlanProp.componentNameId=@planId
				and APP_PlanProp.attrType=@constAttType_ReplicationTargets
			end
			-- Push it to audit when schedule is deleted.
			delete replicationDetails
			from @replicationDetails replicationDetails
			inner join TM_Subtask on
			TM_Subtask.taskId=replicationDetails.TaskId
			and TM_Subtask.operationType<>1007
			and opType=@constOpType_DELETE
			if exists(select 1 from @replicationDetails replicationDetails where opType=@constOpType_DELETE)
			begin
SET @opMsgId = (535 | (CAST(POWER(2, 24) AS BIGINT) * 84))
				EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
				declare @taskIdForDeleteRepl int =0
				EXEC EvGuiAuditSetParamData @opId, @planName, @dataIsEvent
SET @paramMsgId = (1491 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
				IF ( CURSOR_STATUS('global', 'schedulesDelete') >= 0   OR CURSOR_STATUS('local', 'schedulesDelete') >= 0 )  -- CLOSE CURSOR IF OPEN
					CLOSE schedulesDelete
				IF ( CURSOR_STATUS('global','schedulesDelete') = -1     OR CURSOR_STATUS('local','schedulesDelete') = -1 )
					DEALLOCATE schedulesDelete
				DECLARE schedulesDelete CURSOR STATIC FOR
					SELECT  taskId
				    FROM @replicationDetails
					where opType=@constOpType_DELETE
				OPEN schedulesDelete
				FETCH NEXT FROM schedulesDelete INTO @taskIdForDeleteRepl
				WHILE @@FETCH_STATUS = 0
				BEGIN
					declare @subtaskNameForDeleteRepl nvarchar(max) = ''
					select @subtaskNameForDeleteRepl = subtaskName from TM_subtask
					where TaskId=@taskIdForDeleteRepl
					EXEC EvGuiAuditSetParamData @opId, @subtaskNameForDeleteRepl, @dataIsEvent
SET @paramMsgId = (1492 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
					FETCH NEXT FROM schedulesDelete INTO @taskIdForDeleteRepl
				END
				IF ( CURSOR_STATUS('global', 'schedulesDelete') >= 0   OR CURSOR_STATUS('local', 'schedulesDelete') >= 0 )  -- CLOSE CURSOR IF OPEN
					CLOSE schedulesDelete
				IF ( CURSOR_STATUS('global','schedulesDelete') = -1     OR CURSOR_STATUS('local','schedulesDelete') = -1 )
					DEALLOCATE schedulesDelete
			end
			-- All deleted replication schedules mark schedule deleted.
			Update TM_Task
			set deleted = 1
			from TM_Task inner join @replicationDetails replicationDetails on
			TM_task.taskId = replicationDetails.taskId
			and opType=@constOpType_DELETE
			-- Delete all deleted targets from app_Planprop
			delete from app_planprop
			where componentnameid=@planId and attrType=@constAttType_ReplicationTargets
			and attrval in
			(
				select replicationDetails.taskId from @replicationDetails replicationDetails
				where OpType=@constOpType_DELETE
			)
			-- Insert the targets into App_planprop
			INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
			select @planId, @constAttName_ReplicationTargets, @constAttType_ReplicationTargets,  taskId, @currentTime, 0	 -- 7 here is PROPERTY_INTEGER
			from @replicationDetails
			where opType=@constOpType_ADD
		End
		End
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        -- update plan options
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		--performing sanity before updating quota
		DELETE b FROM App_PlanProp b
  			LEFT JOIN UMGroups f ON f.id = b.attrVal
      		WHERE f.id IS NULL
	  			AND b.attrType in (@constAttrType_UserGroupIAssoc, @constAttrType_UserGroupEAssoc)
	  			AND b.componentNameId = @planId
		DECLARE @quotaValue NVARCHAR(32) = NULL
		SET @quotaValue = (SELECT TOP 1 ref.value('@quota', 'nvarchar(32)') AS value FROM @x_xmlData.nodes('Api_UpdatePlanReq/options') R ( ref ))
		IF @quotaValue IS NOT NULL BEGIN
			MERGE   App_PlanProp AS TGT
			USING   (SELECT id FROM @tblToUpdate WHERE restrictions & @constPlanEntity_Options = 0) AS SRC(componentNameId)
			ON      TGT.componentNameId = SRC.componentNameId AND TGT.attrType = @constAttrType_Options AND TGT.attrName = @constAttrName_Options_Quota
			WHEN    MATCHED THEN UPDATE
					SET TGT.attrVal  = @quotaValue,
						TGT.modified = @currentTime
			WHEN    NOT MATCHED THEN INSERT
			VALUES  (SRC.componentNameId, @constAttrName_Options_Quota, @constAttrType_Options, CAST(@quotaValue AS NVARCHAR(32)), @currentTime, 0);
		END
		-- Edge drive quota
		DECLARE @edgeDriveQuotaLimitInGB NVARCHAR(32) = NULL
		SET @edgeDriveQuotaLimitInGB = (SELECT TOP 1 ref.value('@edgeDriveQuota', 'nvarchar(32)') AS value FROM @x_xmlData.nodes('Api_UpdatePlanReq/options') R ( ref ))
		IF @edgeDriveQuotaLimitInGB IS NOT NULL BEGIN
			MERGE   App_PlanProp AS TGT
			USING   (SELECT id FROM @tblToUpdate WHERE restrictions & @constPlanEntity_Options = 0) AS SRC(componentNameId)
			ON      TGT.componentNameId = SRC.componentNameId AND TGT.attrType = @constAttrType_Options AND TGT.attrName = @constAttrName_Options_EdgeDriveQuota
			WHEN    MATCHED THEN UPDATE
					SET TGT.attrVal  = @edgeDriveQuotaLimitInGB,
						TGT.modified = @currentTime
			WHEN    NOT MATCHED THEN INSERT
			VALUES  (SRC.componentNameId, @constAttrName_Options_EdgeDriveQuota, @constAttrType_Options, CAST(@edgeDriveQuotaLimitInGB AS NVARCHAR(32)), @currentTime, 0);
		END
		DECLARE @entryId INT = (SELECT MIN(id) FROM @tblToUpdate WHERE (restrictions & @constPlanEntity_Options) = 0)
		WHILE (@quotaValue IS NOT NULL) AND (@entryId IS NOT NULL) BEGIN
			DECLARE @newEnforceFSQuotaValue INT = 0
			IF CAST(@quotaValue AS INT) = 0 BEGIN
				-- remove quota from the user group with id @userGroupId
				MERGE   UMGroupsProp AS TGT
				USING   (SELECT CAST(attrVal AS INT) as userGroupId FROM App_PlanProp WHERE componentNameId = @entryId AND (attrType in ( @constAttrType_UserGroupAssigned , @constAttrType_UserGroupIAssoc, @constAttrType_UserGroupEAssoc ))) AS SRC
				ON      TGT.componentNameId = SRC.userGroupId and TGT.attrName = 'Enforce quota' AND TGT.attrType = 7
				WHEN    MATCHED	THEN UPDATE SET
						TGT.attrVal = 0
				WHEN    NOT MATCHED THEN  INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
						VALUES(SRC.userGroupId, 'Enforce quota', 7, 0, @currentTime, 0);
			END ELSE BEGIN
				-- add quota to the user group with id @userGroupId
				MERGE   UMGroupsProp AS TGT
				USING   (SELECT CAST(attrVal AS INT) as userGroupId FROM App_PlanProp WHERE componentNameId = @entryId AND (attrType in ( @constAttrType_UserGroupAssigned , @constAttrType_UserGroupIAssoc, @constAttrType_UserGroupEAssoc ))) AS SRC
				ON      TGT.componentNameId = SRC.userGroupId and TGT.attrName = 'Enforce quota' AND TGT.attrType = 7
				WHEN    MATCHED THEN UPDATE SET
						TGT.attrVal = 1
				WHEN    NOT MATCHED THEN INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
						VALUES(SRC.userGroupId, 'Enforce quota', 7, 1, @currentTime, 0);
				MERGE   UMGroupsProp AS TGT
				USING   (SELECT CAST(attrVal AS INT) as userGroupId FROM App_PlanProp WHERE componentNameId = @entryId AND (attrType in ( @constAttrType_UserGroupAssigned , @constAttrType_UserGroupIAssoc, @constAttrType_UserGroupEAssoc ))) AS SRC
				ON      TGT.componentNameId = SRC.userGroupId and TGT.attrName = 'Quota size' AND TGT.attrType = 7
				WHEN    MATCHED		THEN
					UPDATE SET TGT.attrVal = @quotaValue
				WHEN    NOT MATCHED THEN
					INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
					VALUES(SRC.userGroupId, 'Quota size', 7, @quotaValue, @currentTime, 0);
				SET @newEnforceFSQuotaValue = 1
			END
			SET @entryId = (SELECT MIN(id) FROM @tblToUpdate WHERE (restrictions & @constPlanEntity_Options) = 0 AND id > @entryId)
-- Update global quota check flag
-- Based on this JM and other subsystems decide whether or not to do a quota check.
DECLARE @newDoQuotaCheck INT = CASE WHEN @newEnforceFSQuotaValue > 0 THEN 1
									ELSE ISNULL((
												SELECT TOP 1 1
												FROM UMUsersProp WITH(NOLOCK)
												WHERE attrName = N'Enforce quota' AND cs_attrName = CHECKSUM(N'Enforce quota')
												AND modified = 0
												AND attrVal = '1'
												UNION
												SELECT TOP 1 1
												FROM UMGroupsProp WITH(NOLOCK)
												WHERE attrName = N'Enforce quota' AND cs_attrName = CHECKSUM(N'Enforce quota')
												AND modified = 0
												AND attrVal = '1'), 0)
									END
DECLARE @oldDoQuotaCheck INT = (SELECT CAST(value AS INT) FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'DoFSQuotaCheck' AND modified = 0)
DECLARE @quotaSetTime INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
-- Insert only if it gets enabled
IF @oldDoQuotaCheck IS NULL AND @newDoQuotaCheck = 1
BEGIN
	INSERT INTO GXGlobalParam(name, value, created, modified)
	VALUES('DoFSQuotaCheck', @newDoQuotaCheck, @quotaSetTime, 0)
END
ELSE IF @oldDoQuotaCheck <> @newDoQuotaCheck
BEGIN
	UPDATE GXGlobalParam
	SET value = @newDoQuotaCheck
	WHERE name = 'DoFSQuotaCheck'
	AND modified = 0
END
--
		END
		-- Edge drive quota
		WHILE (@edgeDriveQuotaLimitInGB IS NOT NULL) AND (@entryId IS NOT NULL) BEGIN
			IF CAST(@edgeDriveQuotaLimitInGB AS INT) = 0 BEGIN
				-- remove quota from the user group with id @userGroupId
				MERGE   UMGroupsProp AS TGT
				USING   (SELECT CAST(attrVal AS INT) as userGroupId FROM App_PlanProp WHERE componentNameId = @entryId AND (attrType in ( @constAttrType_UserGroupAssigned , @constAttrType_UserGroupIAssoc, @constAttrType_UserGroupEAssoc ))) AS SRC
ON      TGT.componentNameId = SRC.userGroupId and TGT.attrName = 'Enforce Edge Drive Quota' AND TGT.attrType = 7
				WHEN    MATCHED	THEN UPDATE SET
						TGT.attrVal = 0
				WHEN    NOT MATCHED THEN  INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(SRC.userGroupId, 'Enforce Edge Drive Quota', 7, 0, @currentTime, 0);
			END ELSE BEGIN
				-- add quota to the user group with id @userGroupId
				MERGE   UMGroupsProp AS TGT
				USING   (SELECT CAST(attrVal AS INT) as userGroupId FROM App_PlanProp WHERE componentNameId = @entryId AND (attrType in ( @constAttrType_UserGroupAssigned , @constAttrType_UserGroupIAssoc, @constAttrType_UserGroupEAssoc ))) AS SRC
ON      TGT.componentNameId = SRC.userGroupId and TGT.attrName = 'Enforce Edge Drive Quota' AND TGT.attrType = 7
				WHEN    MATCHED THEN UPDATE SET
						TGT.attrVal = 1
				WHEN    NOT MATCHED THEN INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(SRC.userGroupId, 'Enforce Edge Drive Quota', 7, 1, @currentTime, 0);
				MERGE   UMGroupsProp AS TGT
				USING   (SELECT CAST(attrVal AS INT) as userGroupId FROM App_PlanProp WHERE componentNameId = @entryId AND (attrType in ( @constAttrType_UserGroupAssigned , @constAttrType_UserGroupIAssoc, @constAttrType_UserGroupEAssoc ))) AS SRC
ON      TGT.componentNameId = SRC.userGroupId and TGT.attrName = 'Edge Drive Quota Size' AND TGT.attrType = 7
				WHEN    MATCHED		THEN
					UPDATE SET TGT.attrVal = @edgeDriveQuotaLimitInGB
				WHEN    NOT MATCHED THEN
					INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(SRC.userGroupId, 'Edge Drive Quota Size', 7, @edgeDriveQuotaLimitInGB, @currentTime, 0);
			END
			SET @entryId = (SELECT MIN(id) FROM @tblToUpdate WHERE (restrictions & @constPlanEntity_Options) = 0 AND id > @entryId)
		END
		-- -- client groups and throttling
		DECLARE @cv_infra_cgid INT = ISNULL((SELECT TOP 1 id FROM App_ClientGroup WHERE flag & 0x80000 = 0x80000),0)
		SET @entryId = (SELECT MIN(id) FROM @tblToUpdate WHERE (restrictions & @constPlanEntity_Options) = 0)
		WHILE @entryId IS NOT NULL BEGIN
			DECLARE @clientGroupId INT = ISNULL((SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @entryId AND attrType = @constAttrType_ClientGroupAssigned), 0)
			IF (NOT EXISTS(SELECT id FROM APP_ClientGroup WHERE id = @clientGroupId)) AND (@planSubType = 33554439) BEGIN
				DECLARE @clientGroupNameTemplate NVARCHAR(1020) = @planName + ' clients'
				DECLARE @clientGroupName NVARCHAR(1020) = @clientGroupNameTemplate
				DECLARE @clientGroupNameCounter INT = 2
				WHILE EXISTS(SELECT id FROM APP_ClientGroup WHERE name = @clientGroupName) BEGIN
					SET @clientGroupName = @clientGroupNameTemplate + '(' + CAST(@clientGroupNameCounter AS NVARCHAR(32)) + ')'
					SET @clientGroupNameCounter += 1
				END
				-- create group itself
				INSERT INTO APP_ClientGroup(name, description, flag, status, userId, refTime, modified, origCCid, GUID)
				VALUES(@clientGroupName, @planName + ' associated clients' , 4096, 0, @ownerId, @currentTime, @currentTime, 2, NEWID())
				-- get client group id
				SET @clientGroupId = SCOPE_IDENTITY()
				-- smart client group definition
				--SCG_PKID_CLIENT_ASSOCIATED_WITH_PLAN=34=prodID
				DECLARE @scgDefintion XML = '<scgRule op="0"><rules><rule op="0"><rules>
											 <rule filterID="12" propID="' + (SELECT CAST(id AS NVARCHAR(32)) FROM App_SCGProperty WITH(NOLOCK) WHERE name = 'CLIENT_ASSOCIATED_WITH_PLAN')+ '" propType="2" value="' + @planName + '" />
											 </rules></rule></rules></scgRule>'
				DECLARE @scgRule VARCHAR(max)
				EXEC APPSCGV2GenerateQueryParams @scgDefintion, @errorCode OUTPUT, @errorString OUTPUT, @scgRule OUTPUT
				INSERT	INTO	App_SCGRule (scgId, ruleXml, ruleQuery, ownerId, created, modified)
						VALUES	(@clientGroupId, @scgDefintion, @scgRule, @ownerId, @currentTime, 0)
      			-- Setting ownership for smart client group
				DECLARE @permissionsList NVARCHAR(MAX)
SET @permissionsList = CAST(1 AS NVARCHAR(10)) + ',' + CAST(2 AS NVARCHAR(10))
EXEC sec_setCreatorForEntity @ownerId, 0, @permissionsList, @errorCode OUTPUT, @errorString OUTPUT, 28, @clientGroupId
				IF @errorCode != 0 BEGIN
INSERT INTO @executionErrors VALUES (28, @errorCode, @errorString)
				END
				-- store client group id in the Plan property table.
				IF NOT EXISTS (SELECT id FROM APP_PlanProp WHERE componentNameId = @entryId AND attrType = @constAttrType_ClientGroupAssigned) BEGIN
					INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
					VALUES (@entryId, @constAttrName_ClientGroupAssigned, @constAttrType_ClientGroupAssigned, @clientGroupId, @currentTime, 0)
				END ELSE BEGIN
					UPDATE APP_PlanProp SET attrVal = CAST(@clientGroupId AS NVARCHAR(32)), modified = @currentTime WHERE componentNameId = @entryId AND attrType = @constAttrType_ClientGroupAssigned
				END
				-- associate client group with the schedule
				IF @scheduleId > 0 BEGIN
					IF EXISTS (SELECT assocId FROM TM_AssocEntity WHERE assocType = 28 AND clientGroupId = @clientGroupId)
						UPDATE TM_AssocEntity SET taskId = @scheduleId WHERE assocType = 28 AND clientGroupId = @clientGroupId
					ELSE
						INSERT TM_AssocEntity (assocType, taskId, flags, created, clientGroupId, clientId, apptypeId, instanceId, backupsetId, subclientId, policyId, copyId, srmReportSet, srmReportType, exclude, trackingPolicyId, MediaAgentId, agentlessPolicyId, workflowId, sidbStoreId, libraryId, logMonitoringPolicyId)
						VALUES(28, CAST(@scheduleId AS INT), 0, @currentTime, @clientGroupId, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
				END ELSE BEGIN
					DELETE FROM TM_AssocEntity  WHERE assocType = 28 AND clientGroupId = @clientGroupId
				END
			END
            IF @planSubType = 33554439 BEGIN
			    DECLARE @networkThrottleEnabled INT = (SELECT ref.value('@enableThrottle', 'nvarchar(32)') AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/options/network') R ( ref ))
			    IF @debug != 0 BEGIN
				    SELECT 'quota', @quotaValue 'planId', @entryId , 'clientGroupId', @clientGroupId, 'networkThrottleEnabled', @networkThrottleEnabled, 'cv_infra_cgid', @cv_infra_cgid, 'edgeDriveQuota', @edgeDriveQuotaLimitInGB
			    END
			    -- update throttling data
			    IF @networkThrottleEnabled = 0 BEGIN
				    DELETE FROM APP_NetworkThrottleOptions WHERE clientid = 0 AND clientGroupId = @clientGroupId
				    DELETE FROM APP_NetworkThrottle WHERE clientId = 0 AND forClientId = 0 AND clientGroupId = @clientGroupId AND forClientGroupId = @cv_infra_cgid
				    -- remove throttling flag from App_PlanProp table for the plan
				    IF EXISTS (SELECT id FROM  App_PlanProp WHERE attrType = @constAttrType_Options AND attrName = @constAttrName_Options_Throttle AND componentNameId = @entryId)
				    BEGIN
					    UPDATE App_PlanProp SET attrVal = '0' WHERE attrType = @constAttrType_Options AND attrName = @constAttrName_Options_Throttle AND componentNameId = @entryId
					    -- Push firewall configuration
					    EXEC AppWorkQueueSubmitRequest 5 -- WORK_TOKEN_NETWORK
					    , 0, 0, 0, @clientGroupId, ''
				    END
				    ELSE
					    INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
					    VALUES (@entryId, @constAttrName_Options_Throttle, @constAttrType_Options, '0', @currentTime, 0)
				    -- remove throttling flag from client group
				    -- -- first - set it up
UPDATE APP_ClientGroup SET flag = flag | 0x0800 WHERE id = @clientGroupId
				    -- -- second unconditionally remove it
UPDATE APP_ClientGroup SET flag = flag - 0x0800 WHERE id = @clientGroupId
			    END ELSE IF @networkThrottleEnabled = 1 BEGIN
				    IF @cv_infra_cgid != 0
				    BEGIN
					    IF NOT EXISTS(SELECT 1 FROM APP_NetworkThrottle WHERE clientId = 0 AND forClientId = 0 AND clientGroupId = @clientGroupId AND forClientGroupId = @cv_infra_cgid) BEGIN
						    INSERT INTO APP_NetworkThrottle (clientId, clientGroupId, forClientId, forClientGroupId)
								    VALUES(0, @clientGroupId, 0, @cv_infra_cgid)
					    END
					    -- Insert throttle options (Assuming shareBandwidth is true)
					    DECLARE @networkTbl TABLE (throttle XML)
					    INSERT INTO @networkTbl
						    SELECT @x_xmlData.query('Api_UpdatePlanReq/options/network/throttle/throttle')
					    DECLARE @throttleOptions XML = (SELECT '1' as '@shareBandwidth',throttle as [*] from @networkTbl FOR XML PATH ('App_ThrottleScheduleOptionList'))
					    MERGE   APP_NetworkThrottleOptions AS TGT
					    USING   (SELECT @clientGroupId) AS SRC(clientGroupId)
					    ON      TGT.clientId = 0 AND TGT.clientGroupId = SRC.clientGroupId
					    WHEN    MATCHED		THEN UPDATE SET NetworkThrottleOptions = @throttleOptions
					    WHEN    NOT MATCHED THEN INSERT VALUES (0,@clientGroupId,@throttleOptions);
					    -- set throttling flag in App_PlanProp table for the plan
					    IF EXISTS (SELECT id FROM  App_PlanProp WHERE attrType = @constAttrType_Options AND attrName = @constAttrName_Options_Throttle AND componentNameId = @entryId)
						    UPDATE App_PlanProp SET attrVal = '1' WHERE attrType = @constAttrType_Options AND attrName = @constAttrName_Options_Throttle AND componentNameId = @entryId
					    ELSE
						    INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
						    VALUES (@entryId, @constAttrName_Options_Throttle, @constAttrType_Options, '1', @currentTime, 0)
					    -- Push firewall configuration
					    EXEC AppWorkQueueSubmitRequest 4 -- WORK_TOKEN_NETWORK
					    , 0, 0, 0, @clientGroupId, ''
					    -- set throttling flag in App_ClientGroup table
UPDATE APP_ClientGroup SET flag = flag | 0x0800 WHERE id =  @clientGroupId
				    END
				    ELSE
				    BEGIN
					    -- remove throttling flag from App_PlanProp table for the plan
					    IF EXISTS (SELECT id FROM  App_PlanProp WHERE attrType = @constAttrType_Options AND attrName = @constAttrName_Options_Throttle AND componentNameId = @entryId)
						    UPDATE App_PlanProp SET attrVal = '0' WHERE attrType = @constAttrType_Options AND attrName = @constAttrName_Options_Throttle AND componentNameId = @entryId
					    ELSE
						    INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
						    VALUES (@entryId, @constAttrName_Options_Throttle, @constAttrType_Options, '0', @currentTime, 0)
						    -- Push firewall configuration
						    EXEC AppWorkQueueSubmitRequest 4 -- WORK_TOKEN_NETWORK
						    , 0, 0, 0, @clientGroupId, ''
					    -- remove throttling flag from client group
					    -- -- first - set it up
UPDATE APP_ClientGroup SET flag = flag | 0x0800 WHERE id = @clientGroupId
					    -- -- second unconditionally remove it
UPDATE APP_ClientGroup SET flag = flag - 0x0800 WHERE id = @clientGroupId
					    -- report error
					    INSERT INTO @executionErrors VALUES (154, 184, 'Unable to set client group options. Infastructure client group not found')
				    END
			    END
            END
			-- next iteration
			SET @entryId = (SELECT MIN(id) FROM @tblToUpdate WHERE (restrictions & @constPlanEntity_Options) = 0 AND id > @entryId)
		END
		END
		IF (@userHasCapabilityUpdate = 1) OR (@userHasCapabilityInvite = 1)
		BEGIN
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        -- update users. this is for the plan only. derived plans will not be updated.
        ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		-- make sure that user group exists
		SET @x_xmlGroupResp = NULL
		DECLARE @groupId INT = NULL
        DECLARE @currentAssociation INT
        IF @planSubType = 33554439 BEGIN
            EXEC AppPlanEnsureUserGroup  @planId, @groupId OUTPUT, @x_xmlGroupResp OUTPUT
		    INSERT INTO @executionErrors SELECT dt.value('@__type', 'INT'), pe.value('@errorCode', 'INT'), pe.value('@errorMessage', 'NVARCHAR(1024)') FROM @x_xmlGroupResp.nodes('Api_PlanComponentErrorList/error') R ( ref )
			    CROSS APPLY ref.nodes('./entity') D(dt)
			    CROSS APPLY ref.nodes('./status') P(pe)
			    WHERE pe.value('@errorCode', 'INT') <> 0
            SET @opType = (SELECT ISNULL(ref.value('@userOperationType', 'INT'),'') AS name FROM @x_xmlData.nodes('Api_UpdatePlanReq/laptop/users') R ( ref ))
            IF @opType != @constOpType_NONE BEGIN
			    -- get list of all users associated with the plan
			    INSERT INTO #AppPlanUpdate_tmp__UsersToBeDeassociated
				    SELECT userId FROM UMUserGroup WHERE groupId = @groupId		-- explicitely created group
				    UNION
				    SELECT DISTINCT userId FROM UMUserGroup WHERE groupId IN (SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE componentNameId = @planId AND attrType IN (@constAttrType_UserGroupIAssoc, @constAttrType_UserGroupEAssoc))
			    -----------------------------------------------------------------------------------
			    -- Get User who have rights on the plan or which belong to actual associated entity
			    -- Get users that user has rights on
			    -- Need to merge this in new SP Logic
			    ------------------------------------------------------------------------------------
			    DECLARE @includeUsersFlags int = -1;
			    DECLARE @excludeUsersFlags int = 0;
SET @includeUsersFlags = ( CAST (0x001 AS INT) )
SET @excludeUsersFlags = ( CAST (0x200 AS INT) | CAST (0x004 AS INT) | CAST (0x080 AS INT) | CAST(0x100 AS INT) )
			    -- Get Visible Users
			    EXEC sec_getUsersForThisUser '#AppPlanUpdate_tmp__Security_VisibleUsers' ,@i_userId,0,3,@excludeUsersFlags,@includeUsersFlags
			    -- Get Visible Users Groups
			    EXEC sec_getUserGroupsForThisUser '#AppPlanUpdate_tmp__Security_VisibleUsersGroups',@i_userId
                DECLARE @userIds AS TABLE (Id INT IDENTITY (1,1), entityId INT, entityName NVARCHAR(510), providerId INT, providerName NVARCHAR(510))
			    --- Remove cached alert recipient list since invitee list has changed below
			    DELETE	FROM NTNotificationProp
WHERE		(attrName = 'Recipient UserId' or attrName='Recipient UserGroupId')
					    AND componentNameId IN (SELECT	CAST(RTRIM(LTRIM(SUBSTRING(attrName, LEN(@constAttrName_Alert) + 1, 32))) AS INT)
											    FROM	App_PlanProp PP
											    WHERE		PP.componentNameId=@planId
													    AND PP.attrType = @constAttrType_Alert
													    AND PP.attrVal <> 0 ) -- return just active ones
                IF (@opType = @constOpType_OVERWRITE) OR (@opType = @constOpType_ADD) BEGIN
                    DECLARE @id         INT = NULL
                    DECLARE @entityId   INT = NULL
                    DECLARE @entityName NVARCHAR(510)
                    DECLARE @providerId INT
                    DECLARE @providerName NVARCHAR(510)
                    DECLARE @userEntityDescription NVARCHAR(510) = 'Plan ' + @planName + ' user'
                    -- -- -- -- users
                    -- delete current associations if overwrite is requested
                    -- -- mark entries as deleted in UMUsersProp
                    UPDATE UMUsersProp SET modified = @currentTime WHERE attrName = @constAttrName_AssociatedPlan AND componentNameId IN (SELECT userId FROM UMUserGroup WHERE groupId = @groupId  AND userId IN (SELECT userId FROM #AppPlanUpdate_tmp__Security_VisibleUsers) AND @opType = @constOpType_OVERWRITE)
                    -- -- delete user to group association enties
                    DELETE FROM UMUserGroup WHERE groupId = @groupId AND userId IN (SELECT userId FROM #AppPlanUpdate_tmp__Security_VisibleUsers) AND @opType = @constOpType_OVERWRITE
                    -- delete all records for internal and external groups if overwrite is requested
                    -- -- mark entry as deleted in UMGroupsProp
                    UPDATE UMGroupsProp SET modified = @currentTime WHERE attrName = @constAttrName_AssociatedPlan AND componentNameId IN (SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE componentNameId = @planId AND attrType in (@constAttrType_UserGroupIAssoc, @constAttrType_UserGroupEAssoc)) AND componentNameId IN (SELECT userGroupId FROM #AppPlanUpdate_tmp__Security_VisibleUsersGroups) AND @opType = @constOpType_OVERWRITE
				    IF @opType = @constOpType_OVERWRITE
				    BEGIN
					    DECLARE @overwriteGroupId NVARCHAR(MAX)
					    SET @x_xmlGroupResp = ''
					    SELECT @overwriteGroupId = COALESCE(@overwriteGroupId + ',', '') + attrVal FROM APP_PlanProp WHERE componentNameId = @planId AND attrType in (@constAttrType_UserGroupIAssoc, @constAttrType_UserGroupEAssoc) AND (CAST(attrVal AS INT) IN (SELECT userGroupId FROM #AppPlanUpdate_tmp__Security_VisibleUsersGroups))
					    --enum ListOperationType  DELETE=3
					    EXEC dbo.AppPlanUpdateUserGroupProp @i_userId, @i_localeId, @planId, 3, 0, 100, @overwriteGroupId, @x_xmlGroupResp OUTPUT
					    INSERT INTO @executionErrors SELECT dt.value('@__type', 'INT'), pe.value('@errorCode', 'INT'), pe.value('@errorMessage', 'NVARCHAR(1024)') FROM @x_xmlGroupResp.nodes('Api_PlanComponentErrorList/error') R ( ref )
						    CROSS APPLY ref.nodes('./entity') D(dt)
						    CROSS APPLY ref.nodes('./status') P(pe)
						    WHERE pe.value('@errorCode', 'INT') <> 0
				    END
                    -- -- delete entry from APP_PlanProp
                    DELETE FROM App_PlanProp WHERE componentNameId = @planId AND attrType in (@constAttrType_UserGroupIAssoc, @constAttrType_UserGroupEAssoc) AND (CAST(attrVal AS INT) IN (SELECT userGroupId FROM #AppPlanUpdate_tmp__Security_VisibleUsersGroups)) AND @opType = @constOpType_OVERWRITE
                    -- make sure that intermidiate table is empty
                    DELETE FROM @userIds
                    -- get into intermidiate table list of users
                    INSERT INTO @userIds
	                    SELECT	ref.value('@userId', 'INT'), ref.value('@userName', 'NVARCHAR(512)'), NULL, NULL
	                    FROM	@x_xmlData.nodes('Api_UpdatePlanReq/laptop/users/users/user') R ( ref )
                    SELECT @id = MIN(Id) FROM @userIds
                    WHILE @id IS NOT NULL BEGIN
                        SELECT @entityId = entityId, @entityName = entityName FROM @userIds WHERE Id = @id
                        IF ISNULL(@entityId, 0) <> 0 BEGIN
                            -- get current user association
                            SET @currentAssociation =(SELECT CAST(attrVal AS INT) FROM UMUsersProp WHERE componentNameId = @entityId AND attrName = @constAttrName_AssociatedPlan AND modified = 0)
						    -- if database contains information about association but associated plan been deleted or scheduled to be deleted
						    -- then remove association
IF (@currentAssociation IS NOT NULL) AND EXISTS(SELECT id FROM APP_Plan WHERE id = @currentAssociation AND ((flag & 0x00004 != 0) OR (flag & 0x40000000 != 0))) BEGIN
							    UPDATE UMUsersProp SET modified = @currentTime WHERE componentNameId = @entityId AND attrName = @constAttrName_AssociatedPlan AND modified = 0
							    SET @currentAssociation = NULL
						    END
                            IF @currentAssociation IS NULL BEGIN -- if user is not associated with any plan
                                -- include user into newly created group.
				                -- -- existance check is necessary to avoid duplication that can happen if plan creation XML request
				                -- -- contains multiple entries for the same user
                                IF NOT EXISTS (SELECT userId FROM UMUserGroup WHERE userId = @entityId AND groupId = @groupId) BEGIN
                                    INSERT INTO UMUserGroup (userId, groupId, flag) VALUES(@entityId, @groupId, 0)
                                END
                                -- and also set user's property
                                INSERT INTO UMUsersProp(componentNameId, attrName, attrType, attrVal, created, modified)
                                VALUES(@entityId, @constAttrName_AssociatedPlan, @constAttrType_AssociatedPlan, @planId, @currentTime, 0)
                            END ELSE IF @currentAssociation != @planId BEGIN -- user is associated with the plan other then @planId
                                -- From CvEntities.x : EntityType.UserEntity = 13
                                -- Windows system error code ERROR_ALREADY_EXISTS = 183
                                INSERT INTO @executionErrors VALUES (13, 183, 'Unable to associate user ' + @entityName + ' (' + CAST(@entityId AS NVARCHAR(32)) + ') with the plan due to existing association with plan ' + CAST(@currentAssociation AS NVARCHAR(32)) )
                            END
                        END
                        SELECT @id = MIN(Id) FROM @userIds WHERE Id > @id
                    END
                    -- -- -- -- internal (cc) groups
                    SET @userEntityDescription= 'Plan ' + @planName + ' associated user group'
                    DELETE FROM @userIds
                    INSERT INTO @userIds
	                    SELECT	ref.value('@userGroupId', 'INT'), ref.value('@userGroupName', 'NVARCHAR(512)'), NULL, NULL
	                    FROM	@x_xmlData.nodes('Api_UpdatePlanReq/laptop/users/users/userGroup') R ( ref )
                    SELECT @id = MIN(Id) FROM @userIds
                    WHILE @id IS NOT NULL BEGIN
                        SELECT @entityId = entityId, @entityName = entityName FROM @userIds WHERE Id = @id
                        IF ISNULL(@entityId, 0) <> 0 BEGIN
                            -- get current group association
                            SET @currentAssociation =(SELECT CAST(attrVal AS INT) FROM UMGroupsProp WHERE componentNameId = @entityId AND attrName = @constAttrName_AssociatedPlan AND modified = 0)
						    -- if database contains information about association but associated plan been deleted or scheduled to be deleted
						    -- then remove association
IF (@currentAssociation IS NOT NULL) AND EXISTS(SELECT id FROM APP_Plan WHERE id = @currentAssociation AND ((flag & 0x00004 != 0) OR (flag & 0x40000000 != 0))) BEGIN
							    UPDATE UMGroupsProp SET modified = @currentTime WHERE componentNameId = @entityId AND attrName = @constAttrName_AssociatedPlan AND modified = 0
							    SET @currentAssociation = NULL
						    END
                            IF @currentAssociation IS NULL BEGIN -- if group is not associated with any plan
                                -- set plan property
                                IF NOT EXISTS (SELECT componentNameId FROM APP_PlanProp  WHERE componentNameId = @planId AND attrType = @constAttrType_UserGroupIAssoc AND CAST(LTRIM(attrVal) AS INT) = @entityId) BEGIN
                                    INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
                                        VALUES (@planId, @constAttrName_UserGroupIAssoc, @constAttrType_UserGroupIAssoc, CAST(@entityId AS NVARCHAR(32)), @currentTime, 0)
                                END
                                -- set user group property
                                INSERT INTO UMGroupsProp(componentNameId, attrName, attrType, attrVal, created, modified)
                                VALUES(@entityId, @constAttrName_AssociatedPlan, @constAttrType_AssociatedPlan, @planId, @currentTime, 0)
							    SET @x_xmlGroupResp= ''
							    -- Set Role Mapping for Install of Smart Client and Update Quota information for Internal User Group
							    DECLARE @quotaIGroup INT = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @planId AND attrType = @constAttrType_Options AND attrName = @constAttrName_Options_Quota)
							    IF @quotaIGroup IS NOT NULL AND CAST(@quotaIGroup AS INT) <> 0
							    BEGIN
								    EXEC dbo.AppPlanUpdateUserGroupProp @i_userId, @i_localeId, @planId, 2, 1, @quotaIGroup, @entityId, @x_xmlGroupResp OUTPUT
							    END
							    ELSE
							    BEGIN
								    EXEC dbo.AppPlanUpdateUserGroupProp @i_userId, @i_localeId, @planId, 2, 0, 100, @entityId, @x_xmlGroupResp OUTPUT
							    END
							    INSERT INTO @executionErrors SELECT dt.value('@__type', 'INT'), pe.value('@errorCode', 'INT'), pe.value('@errorMessage', 'NVARCHAR(1024)') FROM @x_xmlGroupResp.nodes('Api_PlanComponentErrorList/error') R ( ref )
								    CROSS APPLY ref.nodes('./entity') D(dt)
								    CROSS APPLY ref.nodes('./status') P(pe)
								    WHERE pe.value('@errorCode', 'INT') <> 0
                            END ELSE IF @currentAssociation != @planId BEGIN -- group is associated with the plan other then @planId
                                -- From CvEntities.x : EntityType.USERGROUP_ENTITY = 15
                                -- Windows system error code ERROR_ALREADY_EXISTS = 183
                                INSERT INTO @executionErrors VALUES (15, 183, 'Unable to associate group ' + CAST(@entityId AS NVARCHAR(32)) + ' with the plan due to existing association with plan ' + CAST(@currentAssociation AS NVARCHAR(32)) )
                            END
                        END
                        SELECT @id = MIN(Id) FROM @userIds WHERE Id > @id
                    END
                    -- -- -- -- external groups
                    SET @userEntityDescription= 'Plan ' + @planName + ' associated external user group'
                    DELETE FROM @userIds
                    INSERT INTO @userIds
	                    SELECT	ref.value('@groupId', 'INT'), ref.value('@externalGroupName', 'NVARCHAR(512)'), ref.value('@providerId', 'INT'), ref.value('@providerDomainName', 'NVARCHAR(512)')
	                    FROM	@x_xmlData.nodes('Api_UpdatePlanReq/laptop/users/users/externalUserGroup') R ( ref )
                    SELECT @id = MIN(Id) FROM @userIds
                    WHILE @id IS NOT NULL BEGIN
                        SELECT @entityId = entityId, @entityName = entityName, @providerId = providerId, @providerName = providerName FROM @userIds WHERE Id = @id
                        IF ISNULL(@entityId, 0) <> 0 BEGIN
                            -- get current external group association
                            SET @currentAssociation = (SELECT CAST(attrVal AS INT) FROM UMGroupsProp WHERE componentNameId = @entityId AND attrName = @constAttrName_AssociatedPlan AND modified = 0)
						    -- if database contains information about association but associated plan been deleted or scheduled to be deleted
						    -- then remove association
IF (@currentAssociation IS NOT NULL) AND EXISTS(SELECT id FROM APP_Plan WHERE id = @currentAssociation AND ((flag & 0x00004 != 0) OR (flag & 0x40000000 != 0))) BEGIN
							    UPDATE UMGroupsProp SET modified = @currentTime WHERE componentNameId = @entityId AND attrName = @constAttrName_AssociatedPlan AND modified = 0
							    SET @currentAssociation = NULL
						    END
                            IF @currentAssociation IS NULL BEGIN -- if external group is not associated with any plan
                                -- set plan property
                                IF NOT EXISTS (SELECT componentNameId FROM APP_PlanProp  WHERE componentNameId = @planId AND attrType = @constAttrType_UserGroupEAssoc AND CAST(LTRIM(attrVal) AS INT) = @entityId) BEGIN
                                    INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
                                        VALUES (@planId, @constAttrName_UserGroupEAssoc, @constAttrType_UserGroupEAssoc, CAST(@entityId AS NVARCHAR(32)), @currentTime, 0)
                                END
                                -- set external user group property
                                INSERT INTO UMGroupsProp(componentNameId, attrName, attrType, attrVal, created, modified)
                                VALUES(@entityId, @constAttrName_AssociatedPlan, @constAttrType_AssociatedPlan, @planId, @currentTime, 0)
							    SET @x_xmlGroupResp= ''
							    -- Set Role Mapping for Install of Smart Client and Update Quota information for Internal User Group
							    DECLARE @quotaEGroup INT = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @planId AND attrType = @constAttrType_Options AND attrName = @constAttrName_Options_Quota)
							    IF @quotaEGroup IS NOT NULL AND CAST(@quotaEGroup AS INT) <> 0
							    BEGIN
								    EXEC dbo.AppPlanUpdateUserGroupProp @i_userId, @i_localeId, @planId, 2, 1, @quotaEGroup, @entityId, @x_xmlGroupResp OUTPUT
							    END
							    ELSE
							    BEGIN
								    EXEC dbo.AppPlanUpdateUserGroupProp @i_userId, @i_localeId, @planId, 2, 0, 100, @entityId, @x_xmlGroupResp OUTPUT
							    END
							    INSERT INTO @executionErrors SELECT dt.value('@__type', 'INT'), pe.value('@errorCode', 'INT'), pe.value('@errorMessage', 'NVARCHAR(1024)') FROM @x_xmlGroupResp.nodes('Api_PlanComponentErrorList/error') R ( ref )
								    CROSS APPLY ref.nodes('./entity') D(dt)
								    CROSS APPLY ref.nodes('./status') P(pe)
								    WHERE pe.value('@errorCode', 'INT') <> 0
                            END ELSE IF @currentAssociation != @planId BEGIN -- external group is associated with the plan other then @planId
                                -- From CvEntities.x : EntityType.EXTERNAL_GROUP_ENTITY = 62
                                -- Windows system error code ERROR_ALREADY_EXISTS = 183
                                INSERT INTO @executionErrors VALUES (62, 183, 'Unable to associate external group ' + CAST(@entityId AS NVARCHAR(32)) + ' with the plan due to existing association with plan' + CAST(@currentAssociation AS NVARCHAR(32)) )
                            END
                        END
                        SELECT @id = MIN(Id) FROM @userIds WHERE Id > @id
                    END
                END ELSE IF @opType = @constOpType_DELETE BEGIN
                    -- delete user-group associations
                    DELETE FROM @tblIds
                    INSERT INTO @tblIds
	                    SELECT	ref.value('@userId', 'INT')
	                    FROM	@x_xmlData.nodes('Api_UpdatePlanReq/laptop/users/users/user') R ( ref )
                    -- delete all associations for specified users
                    -- -- remove association with the plan
                    UPDATE UMUsersProp SET modified = @currentTime WHERE attrName = @constAttrName_AssociatedPlan AND attrType = @constAttrType_AssociatedPlan AND componentNameId IN (SELECT id FROM @tblIds)
                    -- -- remove user to group association
                    DELETE FROM UMUserGroup WHERE groupId = @groupId AND userId IN (SELECT id FROM @tblIds)
                    -- delete internal and external (cv) groups
                    DELETE FROM @tblIds
				    -- Insert Internal User Group
                    INSERT INTO @tblIds
	                    SELECT	ref.value('@userGroupId', 'NVARCHAR(32)')
	                    FROM	@x_xmlData.nodes('Api_UpdatePlanReq/laptop/users/users/userGroup') R ( ref )
				    -- Insert External User Group
				    INSERT INTO @tblIds
	                    SELECT	ref.value('@groupId', 'NVARCHAR(32)')
	                    FROM	@x_xmlData.nodes('Api_UpdatePlanReq/laptop/users/users/externalUserGroup') R ( ref )
                    -- -- remove association with the plan from group properties
                    UPDATE UMGroupsProp SET modified = @currentTime WHERE attrName = @constAttrName_AssociatedPlan AND attrType = @constAttrType_AssociatedPlan and componentNameId IN (SELECT id FROM @tblIds WHERE id <> '')
				    -- Remove Any Role and Quota Mapping for the User Group
				    DECLARE @deleteGroupId NVARCHAR(MAX)
				    SELECT @deleteGroupId = COALESCE(@deleteGroupId + ',', '') + id FROM @tblIds WHERE id <> ''
				    BEGIN
					    SET @x_xmlGroupResp=''
					    --enum ListOperationType  DELETE=3
					    EXEC dbo.AppPlanUpdateUserGroupProp @i_userId, @i_localeId, @planId, 3, 0, 100, @deleteGroupId, @x_xmlGroupResp OUTPUT
					    INSERT INTO @executionErrors SELECT dt.value('@__type', 'INT'), pe.value('@errorCode', 'INT'), pe.value('@errorMessage', 'NVARCHAR(1024)') FROM @x_xmlGroupResp.nodes('Api_PlanComponentErrorList/error') R ( ref )
						    CROSS APPLY ref.nodes('./entity') D(dt)
						    CROSS APPLY ref.nodes('./status') P(pe)
						    WHERE pe.value('@errorCode', 'INT') <> 0
				    END
                    -- -- remove entries in App_PlanProp table
                    DELETE FROM App_PlanProp WHERE componentNameId = @planId AND attrType in (@constAttrType_UserGroupIAssoc, @constAttrType_UserGroupEAssoc) AND attrVal IN (SELECT id FROM @tblIds WHERE id <> '')
                    DELETE FROM @tblIds
                END ELSE IF @opType = @constOpType_CLEAR BEGIN
                    -- delete all users from group association
                    -- -- delete plan associations
                    UPDATE UMUsersProp SET modified = @currentTime WHERE attrName = @constAttrName_AssociatedPlan AND attrType = @constAttrType_AssociatedPlan AND componentNameId IN (SELECT userId FROM UMUserGroup WHERE groupId = @groupId)
                    -- -- delete user to group association
                    DELETE FROM UMUserGroup WHERE groupId = @groupId
                    -- delete all records for internal groups and external groups
                    DELETE FROM @tblIds
                    INSERT INTO @tblIds
                        SELECT attrVal FROM App_PlanProp WHERE componentNameId = @planId AND attrType IN (@constAttrType_UserGroupIAssoc, @constAttrType_UserGroupEAssoc)
                    -- -- delete plan associations
                    UPDATE  UMGroupsProp SET modified = @currentTime
                    WHERE   attrName = @constAttrName_AssociatedPlan AND attrType = @constAttrType_AssociatedPlan and componentNameId IN (SELECT CAST(id AS INT) FROM @tblIds WHERE id <> '')
				    -- Remove Any Role and Quota Mapping for the User Group
				    DECLARE @clearGroupId NVARCHAR(MAX)
				    SELECT @clearGroupId = COALESCE(@clearGroupId + ',', '') + id FROM @tblIds WHERE id <> ''
				    BEGIN
					    SET @x_xmlGroupResp=''
					    --enum ListOperationType  DELETE=3
					    EXEC dbo.AppPlanUpdateUserGroupProp @i_userId, @i_localeId, @planId, 3, 0, 100, @clearGroupId, @x_xmlGroupResp OUTPUT
					    INSERT INTO @executionErrors SELECT dt.value('@__type', 'INT'), pe.value('@errorCode', 'INT'), pe.value('@errorMessage', 'NVARCHAR(1024)') FROM @x_xmlGroupResp.nodes('Api_PlanComponentErrorList/error') R ( ref )
						    CROSS APPLY ref.nodes('./entity') D(dt)
						    CROSS APPLY ref.nodes('./status') P(pe)
						    WHERE pe.value('@errorCode', 'INT') <> 0
				    END
                    -- -- delete plan to group association
                    DELETE FROM App_PlanProp WHERE componentNameId = @planId AND attrType IN (@constAttrType_UserGroupIAssoc, @constAttrType_UserGroupEAssoc)
                END
			    DECLARE @tblErrors AS TABLE (errCode INT, errMsg NVARCHAR(MAX))
			    -- reactivate all users which were moved to the plan
			    INSERT INTO #AppPlanUpdate_tmp__UsersToBeReassociated
				    SELECT userId FROM UMUserGroup WHERE groupId = @groupId		-- explicitely created group
				    UNION
				    SELECT DISTINCT userId FROM UMUserGroup WHERE groupId IN (SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE componentNameId = @planId AND attrType IN (@constAttrType_UserGroupIAssoc, @constAttrType_UserGroupEAssoc))
			    -- reactivate all users that were added to the plan (if possible)
			    -- -- leave in the temporary table only those users which were deleted
			    -- -- at this point #AppPlanUpdate_tmp__UsersToBeReassociated contains list of users after  all user operations
			    -- --               #AppPlanUpdate_tmp__UsersToBeDeassociated contains list of users before all user operations
			    -- -- Whatever exists in AppPlanUpdate_tmp__UsersToBeReassociated and do not exists in AppPlanUpdate_tmp__UsersToBeReassociated
			    -- -- is what was added and should be reassociated
			    DELETE FROM #AppPlanUpdate_tmp__UsersToBeReassociated WHERE userId IN (SELECT userId FROM #AppPlanUpdate_tmp__UsersToBeDeassociated)
			    DECLARE @clientsToProcess AS TABLE (id INT IDENTITY(1,1), userId INT, pseudoClientId INT, physicalClientId INT)
			    INSERT INTO @clientsToProcess (userId, pseudoClientId, physicalClientId)
				    SELECT  OW.clientId, PROP.componentNameId, CAST(PROP.AttrVal AS INT)
FROM    sec_getClientOwnersExpandUG OW WITH(NOLOCK) INNER JOIN APP_ClientProp PROP WITH(NOLOCK) ON OW.clientId = PROP.componentNameId AND PROP.AttrName = 'Physical Client Id'
				    WHERE   OW.userId IN (SELECT userId FROM #AppPlanUpdate_tmp__UsersToBeReassociated U)
			    DECLARE @localUserId    INT
			    DECLARE @pseusdoClient  INT
			    DECLARE @physicalClient INT
			    SELECT @id = MIN(id) FROM @clientsToProcess
			    WHILE @id IS NOT NULL BEGIN
				    SELECT @localUserId = userId, @pseusdoClient  = pseudoClientId, @physicalClient = physicalClientId FROM @clientsToProcess WHERE id = @id
                    EXEC AppDeactivateLaptop @localUserId, @i_localeId, @physicalClient, 0, 0
				    SELECT @id = MIN(userId) FROM @clientsToProcess WHERE id > @id
			    END
			    -- deactivate all users which were deleted from the plan
			    -- -- at this point #AppPlanUpdate_tmp__UsersToBeDeassociated contains list of users before all user operations
			    -- -- leave in the temporary table only those users which were deleted
			    DELETE FROM #AppPlanUpdate_tmp__UsersToBeDeassociated WHERE userId IN (SELECT userId FROM UMUserGroup WHERE groupId = @groupId
																				       UNION
																				       SELECT DISTINCT userId FROM UMUserGroup WHERE groupId IN (SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE componentNameId = @planId AND attrType IN (@constAttrType_UserGroupIAssoc, @constAttrType_UserGroupEAssoc)) )
			    -- deassociate users hardware
                -- actually, errors here are not relevant.
                EXEC AppDeactivateLaptopForUser '#AppPlanUpdate_tmp__UsersToBeDeassociated', @adminUserId, @i_localeId
            END
		    END
        END
        -- calculate plan status
        SELECT @planStatus = ISNULL(flag, 0), @planSubType = subType FROM App_Plan WHERE id = @planId
        -- if request's status is Disabled then use it, calculate actual status (enable or incomplete otherwise
        IF (@planStatus & 0x1) <> 0x1 BEGIN -- if plan is not disabled
            -- reset incomplete flag if necessary
            SET @planStatus = @planStatus - (CASE (@planStatus & 0x2) WHEN 0x2 THEN 0x2 ELSE 0 END)
            IF @planSubType & 0x1 = 0x1 BEGIN --  PlanEntities.StoragePolicy
                IF ISNULL((SELECT id FROM App_PlanProp WHERE componentNameId = @planId AND attrType = @constAttrType_Policy_Storage AND CAST(attrVal AS INT) > 0), 0) = 0 BEGIN
                    SET @planStatus = @planStatus | 0x2 -- incomplete
                END
            END
            IF @planSubType & 0x2 = 0x2 BEGIN --  PlanEntities.SubclientPolicy
                IF ((SELECT COUNT(id) FROM App_PlanProp WHERE componentNameId = @planId AND attrType = @constAttrType_Policy_Subclient AND CAST(attrVal AS INT) > 0) <> 3) BEGIN
                    SET @planStatus = @planStatus | 0x2 -- incomplete
                END
            END
            IF @planSubType & 0x4 = 0x4 BEGIN --  PlanEntities.SchedulePolicy
                IF ISNULL((SELECT id FROM App_PlanProp WHERE componentNameId = @planId AND attrType = @constAttrType_Policy_Schedule AND CAST(attrVal AS INT) > 0), 0) = 0 BEGIN
                    SET @planStatus = @planStatus | 0x2 -- incomplete
                END
            END
            IF @planStatus = 0 AND @planSubType & 0x8000 = 0x8000 BEGIN --  PlanEntities.ReplicationTarget
                IF ISNULL((SELECT top 1 id FROM App_PlanProp WHERE componentNameId = @planId AND attrType = @constAttType_ReplicationTargets AND CAST(attrVal AS INT) > 0), 0) = 0 BEGIN
                    SET @planStatus = @planStatus | 0x2 -- incomplete
                END
            END
            UPDATE App_Plan SET flag = @planStatus WHERE id = @planId
        END
        -- we are done
        IF @debug <> 0 BEGIN
            SELECT * FROM APP_Plan WHERE id = @planId
            SELECT * FROM APP_PlanProp WHERE componentNameId = @planId
			SELECT * FROM APP_NetworkThrottleOptions
            ROLLBACK TRANSACTION
        END
        ELSE BEGIN COMMIT TRANSACTION END
    END TRY
	BEGIN CATCH
        ROLLBACK TRANSACTION
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
INSERT INTO @executionErrors VALUES(158, ERROR_NUMBER(), 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' + Convert(VARCHAR(5), ERROR_LINE()) + ']. ' + ERROR_MESSAGE())
    END CATCH
END
DECLARE @rv INT = (SELECT COUNT(__type__) FROM @executionErrors)
-- if there were no errors so far then create 'success' entry
IF @rv = 0 BEGIN
INSERT INTO @executionErrors VALUES(158, 0, '')
END
-- build output
SET @x_xmlData =
(
    SELECT
        (SELECT
            (SELECT ER.__type__ AS '@__type__'
             FOR XML PATH('entity'), TYPE),
            (SELECT ER.errCode      AS '@errorCode',
                    ER.errMessage   AS '@errorMessage'
             FOR XML PATH('status'), TYPE)
         FROM @executionErrors AS ER
         FOR XML PATH('error'), TYPE)
    FOR XML PATH('Api_PlanComponentErrorList')
)
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__UsersToBeDeassociated') IS NOT NULL DROP TABLE #AppPlanUpdate_tmp__UsersToBeDeassociated
IF OBJECT_ID('tempdb.dbo.#AppPlanUpdate_tmp__UsersToBeReassociated') IS NOT NULL DROP TABLE #AppPlanUpdate_tmp__UsersToBeReassociated
RETURN @rv
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanUpdate')
	delete from GxQscripts where name = 'AppPlanUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanUpdate')
	delete from GXDBVersions where aliasname = 'AppPlanUpdate'
GO

insert into GXDBVersions values(2, 'AppPlanUpdate',  '00010001000200390000', 'AppPlanUpdate', '00010001000200390000')
GO

