

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanTransferOwnershipV2.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--
-- Copyright (c) 1998  CommVault Systems, Inc. All rights reserved.
--
--
-- This is unpublished proprietary source code of CommVault Systems, Inc.  The  copyright  notice  above  does  not  evidence any actual or
-- intended publication of such source code.
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanTransferOwnershipV2.sp,v $ $Id: AppPlanTransferOwnershipV2.sp,v 1.1.2.1 2018/12/06 22:28:03 evolohov Exp $";
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Transfers
--
--      @i_planId   INT             plan id
--
-- BEGIN
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanTransferOwnershipV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanTransferOwnershipV2 <<<'
	drop procedure AppPlanTransferOwnershipV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanTransferOwnershipV2')
	delete from GxQscripts where name = 'AppPlanTransferOwnershipV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanTransferOwnershipV2')
	delete from GXDBVersions where aliasname = 'AppPlanTransferOwnershipV2'
GO
print '... Creating Procedure: AppPlanTransferOwnershipV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanTransferOwnershipV2
  @i_planId INTEGER,
  @i_entityType INTEGER,
  @i_entityId INTEGER,
  @i_userId INTEGER,
  @i_localeId INTEGER
AS
  DECLARE @o_xmlResp XML;
SET NOCOUNT ON
DECLARE @rv     INT = 0
DECLARE @debug  INT = 0
DECLARE @errorCode INT = 0, @errorMessage VARCHAR(MAX) = ''
DECLARE @adminUserId INT = (SELECT TOP 1 id FROM UMUsers WITH(NOLOCK) WHERE flags & 0x040 <> 0)
DECLARE @userId INT = IIF(ISNULL(@i_userId, 0) = 0, ISNULL((SELECT ownerId FROM APP_Plan WHERE id = @i_planId), 0), @i_userId)
IF NOT EXISTS (SELECT 1 FROM UMUsers WHERE id = @userId)
BEGIN
    SET @errorCode = 2
    SELECT @errorMessage = ISNULL((SELECT  [Message]
                                   FROM    EvLocaleMsgs WITH(NOLOCK)
                                   WHERE       LocaleId = @i_localeId
AND MessageID = (3290 | (CAST(POWER(2, 24) AS BIGINT) * 35))), 'Invalid user id')
END
IF NOT EXISTS (SELECT 1 FROM APP_Plan WHERE id = @i_planId)
BEGIN
    SET @errorCode = 2
    SELECT @errorMessage = ISNULL((SELECT  [Message]
                                   FROM    EvLocaleMsgs WITH(NOLOCK)
                                   WHERE       LocaleId = @i_localeId
AND MessageID = (3442 | (CAST(POWER(2, 24) AS BIGINT) * 35))), 'Invalid plan id')
END
IF @errorCode = 0
BEGIN
IF @i_entityType = 65
        EXEC sec_setCreatorForEntity @adminUserId, 0, '', @errorCode OUTPUT, @errorMessage OUTPUT, 3, 2, 4, 1030, 5, 1, 6, @i_entityId, @userId
    ELSE
        EXEC sec_setCreatorForEntity @adminUserId, 0, '', @errorCode OUTPUT, @errorMessage OUTPUT, @i_entityType, @i_entityId, @userId
END
SET  @o_xmlResp = (SELECT @errorCode '@errorCode', @errorMessage '@errorMessage' FOR XML PATH('Api_GenericResp'))
SELECT @o_xmlResp
RETURN @errorCode
GO
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--  END
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

IF EXISTS (select * from GxQscripts where name = 'AppPlanTransferOwnershipV2')
	delete from GxQscripts where name = 'AppPlanTransferOwnershipV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanTransferOwnershipV2')
	delete from GXDBVersions where aliasname = 'AppPlanTransferOwnershipV2'
GO

insert into GXDBVersions values(2, 'AppPlanTransferOwnershipV2',  '00010001000200010000', 'AppPlanTransferOwnershipV2', '00010001000200010000')
GO

