

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanSetRPOInterval.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanSetRPOInterval.sp,v $ $Id: AppPlanSetRPOInterval.sp,v 1.1.2.14.14.1 2021/01/13 14:35:27 mnatarajan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppPlanSetRPOInterval')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanSetRPOInterval <<<'
	drop procedure AppPlanSetRPOInterval
END
IF EXISTS (select * from GxQscripts where name='AppPlanSetRPOInterval')
	delete from GxQscripts where name = 'AppPlanSetRPOInterval'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanSetRPOInterval')
	delete from GXDBVersions where aliasname = 'AppPlanSetRPOInterval'
GO
print '... Creating Procedure: AppPlanSetRPOInterval'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppPlanSetRPOInterval
  @i_planId INT,
  @i_planSubType INT,
  @i_rpoInMinutes INT,
  @i_isDBLogRPO INT,
  @i_isIndexCopyRPO INT,
  @i_isBackupCopyRPO INT,
  @o_errorCode INTEGER       OUTPUT,
  @o_errorMsg VARCHAR(MAX)  OUTPUT
AS
SET NOCOUNT ON
--Variable Declarations
DECLARE @taskId INT = 0
DECLARE @subTaskId INT = 0
DECLARE @rpoDefaultCount INT = 0
DECLARE @updateCount INT = 1
DECLARE @autoIncrPattXML XML = NULL
DECLARE @xmlForOscWQ XML = NULL
DECLARE @WQResponse TABLE(xmlResponse XML)
-- Getting the task id and subtask id
IF @i_isDBLogRPO = 0 AND @i_isIndexCopyRPO = 0 AND @i_isBackupCopyRPO= 0 BEGIN
SET @taskId = dbo.AppPlanGetEntityValueV2(@i_planId, 'Schedule policy', default)
END
ELSE IF @i_isDBLogRPO = 1 BEGIN
SET @taskId = dbo.AppPlanGetEntityValueV2(@i_planId, 'Log schedule policy', default)
END
ELSE IF @i_isIndexCopyRPO = 1 BEGIN
SET @taskId = dbo.AppPlanGetEntityValueV2(@i_planId, 'Index copy schedule policy', default)
END
ELSE IF @i_isBackupCopyRPO = 1 BEGIN
SET @taskId = dbo.AppPlanGetEntityValueV2(@i_planId, 'Backup copy schedule policy', default)
END
IF @taskId IS NULL OR @taskId=0 BEGIN
	RETURN
END
IF @taskId IS NOT NULL BEGIN
	IF @i_isBackupCopyRPO = 0
	BEGIN
SET @subTaskId = (SELECT ST.subTaskId FROM TM_SubTask ST WITH (READUNCOMMITTED) WHERE ST.taskId = @taskId AND ST.flags & 0x10000 > 0)
	END
	ELSE --if backupcopy schedule, introducing new flags
	BEGIN
SET @subTaskId = (SELECT ST.subTaskId FROM TM_SubTask ST WITH (READUNCOMMITTED) WHERE ST.taskId = @taskId AND ST.flags & 0x2000000 > 0)
	END
END
SET @o_errorCode = 0; SET @o_errorMsg  = '';
BEGIN
	BEGIN TRY
		IF @subTaskId IS NOT NULL AND @i_rpoInMinutes > 0 BEGIN
IF @i_planSubType NOT IN (33554439, 100859907, 100794372, 83918853, 117506053) AND (@i_isDBLogRPO = 0) AND (@i_isIndexCopyRPO=0)
			BEGIN
				-- First Check if provided subtask id is Continuos or Daily incremental
				-- We might have case where some customer might have had RPO greater than 24 hours earlier without Daily coming into picutre.
				-- We don't want to break there logic
				IF @i_rpoInMinutes < 1440
				BEGIN
					UPDATE  P
SET P.freq_type = 4096
					FROM    TM_Pattern P INNER JOIN TM_PatternAssoc PA WITH(NOLOCK) ON P.patternId = PA.patternId
WHERE   PA.subTaskId = @subTaskId AND P.freq_type <> 4096
					IF (@@ROWCOUNT > 0)
					BEGIN
						DELETE TR
						FROM TM_RunTime TR
						INNER JOIN TM_PatternAssoc TMP
							ON TMP.patternId=TR.patternId AND TMP.subTaskId=@subTaskId
					END
					SET ROWCOUNT 0
					UPDATE  P SET P.freq_interval = @i_rpoInMinutes, --this is in minutes
							P.freq_subday_interval = 0,
P.tzId = 1000
					FROM    TM_Pattern P INNER JOIN TM_PatternAssoc PA WITH(NOLOCK) ON P.patternId = PA.patternId
					WHERE   PA.subTaskId = @subTaskId
					SELECT @updateCount = @@ROWCOUNT
				END
				ELSE IF @i_rpoInMinutes < 10080
				BEGIN
					-- 1440 is equivalent of 24 hours.. means we have daily schedule
					-- Get number of days for freq interval
					DECLARE @rpoIntervalDays INT = @i_rpoInMinutes / ( 60 * 24)
					SET ROWCOUNT 0
					UPDATE  P
							SET P.freq_interval = @rpoIntervalDays, --this is in days
							P.freq_recurrence_factor = @rpoIntervalDays,
							P.freq_subday_interval = 0,
P.tzId = 1001,
P.freq_type = 4-- We can't allow changing of recurrence factor. It should be repeat evry day
					FROM    TM_Pattern P INNER JOIN TM_PatternAssoc PA WITH(NOLOCK) ON P.patternId = PA.patternId
					WHERE   PA.subTaskId = @subTaskId AND (P.freq_interval <> @rpoIntervalDays OR
							P.freq_recurrence_factor <> @rpoIntervalDays OR
							P.freq_subday_interval <> 0 OR
P.tzId <> 1001 OR P.freq_type = 4)
					SELECT @updateCount = @@ROWCOUNT
					IF (@updateCount = 1)
					BEGIN
						DELETE TR
						FROM TM_RunTime TR
						INNER JOIN TM_PatternAssoc TMP
							ON TMP.patternId=TR.patternId AND TMP.subTaskId=@subTaskId
					END
				END
				ELSE
				BEGIN
					-- If frequency is greater than 7 days,then we will save it as weekly
					-- 24*60*7 =10080
					DECLARE @rpoIntervalWeeks INT = @i_rpoInMinutes / ( 60 * 24 * 7)
					SET ROWCOUNT 0
					UPDATE  P
							SET P.freq_recurrence_factor = @rpoIntervalWeeks,
							P.freq_subday_interval = 0,
P.tzId = 1001,
P.freq_type = 8-- We can't allow changing of recurrence factor. It should be repeat evry week
					FROM    TM_Pattern P INNER JOIN TM_PatternAssoc PA WITH(NOLOCK) ON P.patternId = PA.patternId
					WHERE   PA.subTaskId = @subTaskId AND (P.freq_recurrence_factor <> @rpoIntervalWeeks OR
							P.freq_subday_interval <> 0 OR
P.tzId <> 1001 OR P.freq_type = 8)
					SELECT @updateCount = @@ROWCOUNT
					IF (@updateCount = 1)
					BEGIN
						DELETE TR
						FROM TM_RunTime TR
						INNER JOIN TM_PatternAssoc TMP
							ON TMP.patternId=TR.patternId AND TMP.subTaskId=@subTaskId
					END
				END
			END
IF @i_planSubType IN (50331655, 67108869, 83886085, 83918853)  OR ((@i_planSubType = 33554437) AND ((@i_isDBLogRPO = 1) OR (@i_isIndexCopyRPO=1)))
			BEGIN
				SET ROWCOUNT 0
				UPDATE  P SET P.freq_interval = @i_rpoInMinutes --this is in minutes
				FROM    TM_Pattern P INNER JOIN TM_PatternAssoc PA WITH(NOLOCK) ON P.patternId = PA.patternId
				WHERE   PA.subTaskId = @subTaskId
				SELECT @updateCount = @@ROWCOUNT
			END
IF @i_planSubType = 33579013 AND @i_isDBLogRPO = 0
			BEGIN
				SET ROWCOUNT 0
				UPDATE  P SET P.freq_subday_interval = @i_rpoInMinutes * 60 --this is in seconds
				FROM    TM_Pattern P INNER JOIN TM_PatternAssoc PA WITH(NOLOCK) ON P.patternId = PA.patternId
				WHERE   PA.subTaskId = @subTaskId
				SELECT @updateCount = @@ROWCOUNT
			END
			IF @updateCount <> 1 BEGIN
				SET @o_errorCode = 500
				SET @o_errorMsg = 'Error in updating RPO'
				GOTO ENDSP
			END
		END
IF @i_planSubType IN (16777223, 33554439) BEGIN
			SELECT @autoIncrPattXML = xmlValue FROM TM_SubTaskXMLOptions STXO WHERE STXO.subTaskId = @subTaskId
			DECLARE @hrs INT = @i_rpoInMinutes / 60
			DECLARE @min INT = @i_rpoInMinutes % 60
			IF @autoIncrPattXML IS NOT NULL BEGIN
				SET @autoIncrPattXML.modify('replace value of (/TMMsg_JobOption/commonOpts/automaticSchedulePattern/@minBackupInterval)[1] with sql:variable("@hrs")')
				SET @autoIncrPattXML.modify('replace value of (/TMMsg_JobOption/commonOpts/automaticSchedulePattern/@minBackupIntervalMinutes)[1] with sql:variable("@min")')
				UPDATE STXO SET STXO.xmlValue = @autoIncrPattXML FROM TM_SubTaskXMLOptions STXO WHERE STXO.subTaskId = @subTaskId
				-- Check whether this schedule is OSC schedule
				IF EXISTS(SELECT 1 FROM TM_PatternAssoc PA WITH(NOLOCK)
						INNER JOIN TM_Pattern P WITH(NOLOCK) ON P.patternId = PA.patternId
						AND PA.subTaskId = @subTaskId
						AND P.freq_type = 1024 --Automatic
						)
				BEGIN
					-- Push OSC request for all associated clients
					SET @xmlForOscWQ = ( SELECT 4 '@workToken',  -- OSC Work token
						(
							(SELECT TM_AssocEntity.clientId '@clientId', TM_AssocEntity.clientGroupId '@clientGroupId'
							FROM TM_AssocEntity WITH(NOLOCK) INNER JOIN TM_Task WITH(NOLOCK) ON TM_AssocEntity.TaskID = TM_Task.taskID
							INNER JOIN TM_SubTask WITH(NOLOCK) ON TM_Subtask.taskID = TM_Task.TaskID AND TM_Subtask.subTaskID = @subTaskId
							FOR XML PATH('entityList'),TYPE)
						)
						FOR XML PATH('App_SubmitWorkQueueReq')
					)
					IF @xmlForOscWQ IS NOT NULL
					BEGIN
						INSERT INTO @WQResponse
						EXEC AppWorkQueueSubmitRequestXML @xmlForOscWQ
					END
				END
				-- Get the max value of RPO hours attribute across all laptop/dlo plans and change default no backup alert if needed
				DECLARE @noBackupDuration INT
				SELECT  @noBackupDuration = MAX(CONVERT(INT, attrVal))
				FROM        App_PlanProp WITH (NOLOCK) INNER JOIN
App_Plan     WITH (NOLOCK) ON  App_PlanProp.componentNameId = App_Plan.id AND App_Plan.subType IN (16777223, 33554439)
AND ((flag & 0x00004) = 0
AND ((flag & 0x40000000) = 0)) -- Check only plans which do not need to be deleted.
WHERE   attrName = 'RPO In Minutes' AND ISNUMERIC(attrVal) = 1
				if (@noBackupDuration IS NULL OR @noBackupDuration<95*60)
					SET @noBackupDuration = 95 * 60 -- so that we dont change default of 4 days in no backup alert.
				-- convert it into hrs
				SET @noBackupDuration = @noBackupDuration / 60.0
				UPDATE  NTSelCriteriaParams
				SET     value = (@noBackupDuration/24) + 1
FROM    NTSelCriteriaParams INNER JOIN  NTSelCriteria ON NTSelCriteriaParams.selCriteriaid = NTSelCriteria.id AND NTSelCriteria.availCriteriaid = 65
											INNER JOIN NTnotificationRule ON NTnotificationRule.id = NTSelCriteria.ruleId AND NTnotificationRule.notificationName='No backup for last 4 days'
AND NTnotificationRule.alertTypeId = 3
																		AND NTnotificationRule.revision = 1
																		AND (NTnotificationRule.status & 2) = 0 -- NT_STATUS_DELETED
AND (NTnotificationRule.status & 128) > 0
AND (NTnotificationRule.status & 2048) > 0 -- NT_STATUS_DELETED
			END
		END
IF @i_planSubType IN (33554437 ,33579013) AND @i_isDBLogRPO = 1 BEGIN
			SELECT @autoIncrPattXML = xmlValue FROM TM_SubTaskXMLOptions STXO WHERE STXO.subTaskId = @subTaskId
			DECLARE @hrsLog INT = @i_rpoInMinutes / 60
			DECLARE @minLog INT = @i_rpoInMinutes % 60
			DECLARE @minhrsLog INT = 0 -- @minBackupInterval / 60. will always be 0.
			DECLARE @minMinsLog INT = 15 -- if the max is >15, min should be 15. Have this as default
			IF @autoIncrPattXML IS NOT NULL BEGIN
				SET @autoIncrPattXML.modify('replace value of (/TMMsg_JobOption/commonOpts/automaticSchedulePattern/@maxBackupInterval)[1] with sql:variable("@hrsLog")')
				SET @autoIncrPattXML.modify('replace value of (/TMMsg_JobOption/commonOpts/automaticSchedulePattern/@maxBackupIntervalMinutes)[1] with sql:variable("@minLog")')
				IF @i_rpoInMinutes<15
				BEGIN
					-- Compute min backup interval based on i_rpoInMinutes
					-- if the max is <15, min should be 10
					-- if the max < 10, min = max
					IF @i_rpoInMinutes<10
					BEGIN
						SET @minMinsLog = @i_rpoInMinutes
					END
					ELSE
					BEGIN
						SET @minMinsLog = 10
					END
				END
				SET @autoIncrPattXML.modify('replace value of (/TMMsg_JobOption/commonOpts/automaticSchedulePattern/@minBackupInterval)[1] with sql:variable("@minhrsLog")')
				SET @autoIncrPattXML.modify('replace value of (/TMMsg_JobOption/commonOpts/automaticSchedulePattern/@minBackupIntervalMinutes)[1] with sql:variable("@minMinsLog")')
				UPDATE STXO SET STXO.xmlValue = @autoIncrPattXML FROM TM_SubTaskXMLOptions STXO WHERE STXO.subTaskId = @subTaskId
				-- Check whether this schedule is OSC schedule
				IF EXISTS(SELECT 1 FROM TM_PatternAssoc PA WITH(NOLOCK)
						INNER JOIN TM_Pattern P WITH(NOLOCK) ON P.patternId = PA.patternId
						AND PA.subTaskId = @subTaskId
						AND P.freq_type = 1024 --Automatic
					)
				BEGIN
					-- Push OSC request for all associated clients
					SET @xmlForOscWQ = ( SELECT 4 '@workToken',  -- OSC Work token
						(
							(SELECT TM_AssocEntity.clientId '@clientId', TM_AssocEntity.clientGroupId '@clientGroupId'
							FROM dbo.TM_Associations TM_AssocEntity (NOLOCK)
							INNER JOIN TM_Task WITH(NOLOCK) ON TM_AssocEntity.TaskID = TM_Task.taskID
							INNER JOIN TM_SubTask WITH(NOLOCK) ON TM_Subtask.taskID = TM_Task.TaskID AND TM_Subtask.subTaskID = @subTaskId
							AND (TM_AssocEntity.clientId>0 OR TM_AssocEntity.clientGroupId >0)
							FOR XML PATH('entityList'),TYPE)
						)
						FOR XML PATH('App_SubmitWorkQueueReq')
					)
					IF @xmlForOscWQ IS NOT NULL
					BEGIN
						INSERT INTO @WQResponse
						EXEC AppWorkQueueSubmitRequestXML @xmlForOscWQ
					END
				END
			END
		END
		-- CHECK WHETHER THE SUBTASK PATTERN IS CONTINOUS AND IF SO, CALL SP TO RESET RUN TIME.
		IF @i_isIndexCopyRPO = 0 AND EXISTS(SELECT 1 FROM TM_PatternAssoc PA WITH(NOLOCK)
						INNER JOIN TM_Pattern P WITH(NOLOCK) ON P.patternId = PA.patternId
						AND PA.subTaskId = @subTaskId
						AND P.freq_type = 4096 --After job completes
						)
		BEGIN
			DECLARE @xmlForResetScProp XML
			SET @xmlForResetScProp = (SELECT @subTaskId '@subtaskId' , 68 '_type_' FOR XML PATH('scheduleEntity'),ROOT('App_AssociationsForNextRunTimeRecompute')) -- SUBTASK_ENTITY
			EXEC dbo.TM_ResetNextStartTimeForContSched @xmlForResetScProp, @o_errorCode OUTPUT, @o_errorMsg OUTPUT
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
        SET @o_errorCode = ERROR_NUMBER()
		SET @o_errorMsg = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' + Convert(VARCHAR(5), ERROR_LINE()) + ']. ' + ERROR_MESSAGE()
    END CATCH
END
ENDSP:
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanSetRPOInterval')
	delete from GxQscripts where name = 'AppPlanSetRPOInterval'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanSetRPOInterval')
	delete from GXDBVersions where aliasname = 'AppPlanSetRPOInterval'
GO

insert into GXDBVersions values(2, 'AppPlanSetRPOInterval',  'v1.1.2.14.14.1', 'AppPlanSetRPOInterval', 'v1.1.2.14.14.1')
GO

