

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanSetEntityValueV2.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanSetEntityValueV2.sp,v $ $Id: AppPlanSetEntityValueV2.sp,v 1.1.2.20 2020/05/12 10:45:30 saurabhagrawal Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   Creates or recreates plan associated client group   - marks existing profile as deleted
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanSetEntityValueV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanSetEntityValueV2 <<<'
	drop procedure AppPlanSetEntityValueV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanSetEntityValueV2')
	delete from GxQscripts where name = 'AppPlanSetEntityValueV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanSetEntityValueV2')
	delete from GXDBVersions where aliasname = 'AppPlanSetEntityValueV2'
GO
print '... Creating Procedure: AppPlanSetEntityValueV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanSetEntityValueV2
  @i_planId INTEGER,
  @i_entityName VARCHAR(128),
  @i_value VARCHAR(MAX),
  @o_errorCode INTEGER       OUTPUT,
  @o_errorMsg VARCHAR(MAX)  OUTPUT
AS
SET NOCOUNT ON
    DECLARE @allowPrintingLogMessages  BIT = ISNULL((SELECT CAST((CASE WHEN ISNUMERIC(value) = 1 THEN value ELSE 0 END) AS BIT) FROM GXGlobalParam WHERE name = 'Plan.allowPrintingLogMessages'), 0)
    DECLARE @__function__ SYSNAME = 'DB.AppPlanSetEntityValueV2'
    DECLARE @currentTime     INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
    DECLARE @rv INT  = 0
    DECLARE @debug INT = 0
    SET @o_errorCode = 0; SET @o_errorMsg  = '';
    -- @i_value == -32000 indicates an error in entity creation. For some of the plan entities this value represented as is unsigned int - '4294935296'. correct this
    IF @i_value = '4294935296' SET @i_value = '-32000'
    DECLARE @entityId     INT           = NULL,
            @propertyType INT           = NULL
    SELECT  @entityId = entityId, @propertyType = [type] FROM App_PlanEntity WHERE name = @i_entityName
    IF @i_entityName IS NULL BEGIN
        SET @o_errorCode = 87;  SET @o_errorMsg  = 'Invalid parameter';
        ;THROW 500087, 'Invalid parameter', 1
    END
    -- get current value
    DECLARE @currentValueId INT         = NULL
    DECLARE @currentValue NVARCHAR(MAX) = NULL
    SELECT @currentValueId = id, @currentValue = attrVal FROM APP_PlanProp WHERE componentNameId = @i_planId AND attrName = @i_entityName
    IF ISNULL(@i_value, '') != ISNULL(@currentValue, '') BEGIN
        -- -- these values cannot be updated as entities with these ids should be deleted from system
        -- -- just mark entity to be deleted and pruning thread will process it
IF @entityId IN (16,
2048,
4096,
1,
8192,
4,
16384,
65545,
8,
64,
65536,
65537,
65538,
65539,
65542,
32768,
2,
256,
512,
1024,
65543,
65546,
65547,
65548,
65557,
65558,
65559)
        BEGIN
UPDATE APP_PlanProp SET attrName  = attrName + ' : to be deleted' WHERE componentNameId = @i_planId AND attrName = @i_entityName
            SET @currentValueId = NULL
        END
        -- -- insert new record or update existing one
        IF @currentValueId IS NULL
            INSERT INTO APP_PlanProp(componentNameId, attrName, attrType, attrVal, created, modified)
            VALUES (@i_planId, @i_entityName, ISNULL((SELECT [type] FROM App_PlanEntity WHERE name = @i_entityName), 1), ISNULL(@i_value, ''), @currentTime, 0)
        ELSE
            UPDATE APP_PlanProp SET attrVal = ISNULL(@i_value, '') WHERE componentNameId = @i_planId AND attrName = @i_entityName
        -- -- query return value - id of the updated or created record
        SET @rv = (SELECT id FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName = @i_entityName AND attrVal = @i_value AND modified = 0)
        IF @i_value != '-32000'
        BEGIN
            -- -- set entity flag.
            -- -- flag setting should be in sync with flag cleanup in AppPlanMaintenanceV2
IF @entityId IN (16)
UPDATE UMGroups SET groupFlags = (groupFlags | 536870912 | 0x0010) WHERE id = CAST(@i_value AS INT)
ELSE IF @entityId IN (2048)
UPDATE APP_ClientGroup SET flag = (flag | 536870912) WHERE id = CAST(@i_value AS INT)
ELSE IF @entityId IN (1, 8192)
UPDATE archGroup SET flags = (flags | 536870912) WHERE id = CAST(@i_value AS INT)
ELSE IF @entityId IN (65544) AND @i_value IS NOT NULL AND @i_value <> '' BEGIN
				DECLARE @rules xml = CAST(@i_value as xml)
UPDATE archGroup SET flags = (flags | 536870912) WHERE id IN (select ref.value('@storagePolicyId', 'int') as storagePolicyId FROM @rules.nodes('/Api_PlanRuleMaps/rules/policy') R(ref))
			END
ELSE IF @entityId IN (4, 16384,65545 )
UPDATE TM_Task SET flags = (flags | 536870912) WHERE taskId = CAST(@i_value AS INT)
ELSE IF @entityId IN (4096) BEGIN
DECLARE @cprId INT = (SELECT id FROM APP_ClientProp WHERE componentNameId = @i_value AND attrName = 'Associated Plan')
                IF @cprId IS NULL BEGIN
                    INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
VALUES(@i_value, 'Associated Plan', 2, CAST(@i_planId AS VARCHAR(32)), @currentTime, 0, 0)
                END ELSE BEGIN
                    UPDATE APP_ClientProp SET attrVal = CAST(@i_planId AS VARCHAR(32)) WHERE id = @cprId
                END
END ELSE IF @entityId IN (8, 64)
UPDATE UMRoles SET flags = (flags | 536870912) WHERE id = CAST(@i_value AS INT)
ELSE IF @entityId IN (65536,65537,65538,65539, 65542, 65543, 65546, 65547, 65548, 65557, 65558, 65559)
UPDATE APP_ConfigurationPolicy SET flags = (flags | 536870912) WHERE policyId = CAST(@i_value AS INT)
ELSE IF @entityId IN (32768)
UPDATE TM_Task SET flags = (flags | 536870912) WHERE taskId IN (SELECT _ID FROM dbo.SplitIDString(@i_value))
ELSE IF @entityId IN (2, 256, 512, 1024) BEGIN
DECLARE @bsprId INT = (SELECT id FROM APP_BackupSetProp WHERE componentNameId = @i_value AND attrName = 'Associated Plan')
                IF @bsprId IS NULL BEGIN
                    INSERT INTO APP_BackupSetProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
VALUES(@i_value, 'Associated Plan', 2, CAST(@i_planId AS VARCHAR(32)), @currentTime, 0, 0)
                END ELSE BEGIN
                    UPDATE APP_BackupSetProp SET attrVal = CAST(@i_planId AS VARCHAR(32)) WHERE id = @bsprId
                END
            END
        END
    END
    IF @debug != 0
        SELECT * FROM APP_PlanProp WHERE componentNameId = @i_planId AND attrName = @i_entityName
    RETURN @rv
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanSetEntityValueV2')
	delete from GxQscripts where name = 'AppPlanSetEntityValueV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanSetEntityValueV2')
	delete from GXDBVersions where aliasname = 'AppPlanSetEntityValueV2'
GO

insert into GXDBVersions values(2, 'AppPlanSetEntityValueV2',  '00010001000200200000', 'AppPlanSetEntityValueV2', '00010001000200200000')
GO

