

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanSetCloudLaptop.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanSetCloudLaptop.sp,v $ $Id: AppPlanSetCloudLaptop.sp,v 1.1.2.3 2020/11/17 14:29:58 cnaik Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +==============================================================================================================+
--  |   Procedure:  AppPlanSetCloudLaptop()
--  |
--  | Description:  SP for setting property 'Cloud Mode Enabled' for clients & default subclient associated with a Laptop plan
--  |
--  |       Input:  plan id & optional client id
--  |      Output:  None
--  |      Return:  xxx
--  |
--  |   Revisions  Author
--  |   ---------  Chinmay Naik
--  +==============================================================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppPlanSetCloudLaptop')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanSetCloudLaptop <<<'
	drop procedure AppPlanSetCloudLaptop
END
IF EXISTS (select * from GxQscripts where name='AppPlanSetCloudLaptop')
	delete from GxQscripts where name = 'AppPlanSetCloudLaptop'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanSetCloudLaptop')
	delete from GXDBVersions where aliasname = 'AppPlanSetCloudLaptop'
GO
print '... Creating Procedure: AppPlanSetCloudLaptop'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppPlanSetCloudLaptop
  @i_planId INT,
  @i_userId INT,
  @i_clientId INT = 0,
  @i_enabled INT = 1,
  @o_errorCode INTEGER       OUTPUT,
  @o_errorMsg VARCHAR(MAX)  OUTPUT
AS
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	SET @o_errorCode = 0; SET @o_errorMsg  = '';
	IF @i_planId IS NULL
	BEGIN
        SET @o_errorCode = 87;  SET @o_errorMsg  = 'Invalid parameter: plan ID';
        RETURN
    END
	IF @i_userId IS NULL
	BEGIN
        SET @o_errorCode = 87;  SET @o_errorMsg  = 'Invalid parameter: user ID';
        RETURN
    END
	DECLARE @nowTime INT
	-- drop stale temp tables
	IF OBJECT_ID('tempdb.dbo.#GetPlanLaptopClients') IS NOT NULL DROP TABLE #GetPlanLaptopClients
	IF OBJECT_ID('tempdb.dbo.#GetDefaultSubClients') IS NOT NULL DROP TABLE #GetDefaultSubClients
	-- create temporary tables
	CREATE TABLE #GetPlanLaptopClients (clientId INT, primary key (clientId))
	CREATE TABLE #GetDefaultSubClients (subclientId INT, primary key (subclientId))
	--get windows laptop client associated with the plan
	INSERT INTO #GetPlanLaptopClients
	SELECT DISTINCT AC.id
	FROM APP_Client AC
	INNER JOIN APP_ClientProp ACP
ON ACP.componentNameId=AC.id AND ACP.attrName=N'Associated Plan'
		INNER JOIN App_Plan AP
ON CAST(AP.id AS NVARCHAR(16))=ACP.attrVal AND (AP.subtype=33554439) AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0) AND ACP.modified = 0
	INNER JOIN simOperatingSystem simOS
ON AC.simOperatingSystemId = simOS.id AND simOS.Type in ('Windows')
WHERE AC.status&0x1000<>0 and Ap.id = @i_planId and
	(Ac.id=@i_clientId OR @i_ClientId=0)
	-- get default subclient from default backupset
	INSERT INTO #GetDefaultSubClients
	Select distinct A.id
	FROM APP_Application A
	INNER JOIN APP_BackupSetName B
	ON A.backupSet = B.id
	INNER JOIN #GetPlanLaptopClients LC
	ON LC.clientId = A.clientId
WHERE (B.status & 0x00008) <> 0
	AND    B.id = A.backupset
AND    (A.subclientStatus & 0x00008) = 0x00008
	SELECT @nowTime = dbo.GetUnixTime(GETUTCDATE())
	/*
	We have no use case to have property at client level. Hence commenting this out
	-- update exisiting property for laptops if already exisiting at client/subclient level
	UPDATE ACP
	SET attrVal = @i_enabled
	FROM APP_ClientProp ACP
	INNER JOIN #GetPlanLaptopClients LC
	ON ACP.componentNameId = LC.clientId
WHERE attrName='Cloud Mode Enabled'  --'Cloud Mode Enabled'
	and attrVal <> CAST(@i_enabled as nvarchar(12)) AND modified = 0
	INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
SELECT clientId, 'Cloud Mode Enabled', 7, @i_enabled, @nowTime, 0, 0
	FROM #GetPlanLaptopClients LC
	LEFT OUTER JOIN APP_ClientProp ACP WITH (NOLOCK)
ON ACP.componentNameId = LC.clientId and  ACP.attrName = 'Cloud Mode Enabled' AND ACP.modified = 0
	WHERE ACP.id IS NULL
	*/
	-- PIT property only for subclients
	UPDATE SCP
	SET  modified = @nowTime
	FROM APP_SubClientProp SCP
	INNER JOIN #GetDefaultSubClients SC
	ON SC.subclientId = SCP.componentNameId
WHERE attrName='Cloud Mode Enabled'  --'Cloud Mode Enabled'
and attrVal <> CAST(@i_enabled as nvarchar(12)) AND cs_attrName = CHECKSUM(N'Cloud Mode Enabled')
	and SCP.modified=0
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
SELECT subclientId, 'Cloud Mode Enabled', 7, @i_enabled, @nowTime, 0, 0
	FROM #GetDefaultSubClients SC
	LEFT OUTER JOIN APP_SubClientProp SCP WITH (NOLOCK)
ON SCP.componentNameId = SC.subclientId and  SCP.attrName = 'Cloud Mode Enabled'
AND SCP.cs_attrName = CHECKSUM(N'Cloud Mode Enabled')
	AND SCP.modified = 0
	WHERE SCP.id IS NULL
	------BEGIN :add push MA core package
	--- At this point, the properties are already updated
	--get clients which do not have MA installed
	DECLARE @clientInstallPkgReq XML
	DECLARE @clientInstallPkgResp XML
	DECLARE @errorCode INT = 0
	DECLARE @errorString NVARCHAR(MAX) = N''
	DECLARE @tempClientPkgId TABLE ( clientId INT PRIMARY KEY, packageId INT)
    INSERT INTO @tempClientPkgId
    SELECT T.clientId, (  CASE S.type
When 'Windows' then 54
else 1305
                        end
                    )
    FROM #GetPlanLaptopClients  T
	INNER JOIN APP_CLIENT C WITH(NOLOCK) ON C.id = T.clientId
    INNer JOIN simOperatingSystem S WITH(NOLOCK) ON S.id = C.simoperatingSystemId
	INNER JOIN APP_Application A WITH(NOLOCK)  ON T.clientId = A.clientId
INNER JOIN APP_BackupSetName B WITH(NOLOCK) ON A.backupSet = B.id AND (B.status & 0x00008) = 0x00008 AND (A.subclientStatus & 0x00008) = 0x00008
INNER JOIN APP_SubClientProp SCP WITH(NOLOCK) ON SCP.componentNameId = A.id AND SCP.attrName = 'Cloud Mode Enabled' AND SCP.modified = 0 AND SCP.attrVal = N'1'
    AND T.clientId NOT IN (SELECT clientId FROM simInstalledPackages  WITH (NOLOCK) WHERE simPackageID IN
(54, 1305))
	IF (SELECT count(clientId) FROM @tempClientPkgId) >=1
    BEGIN
        SET @clientInstallPkgReq = (SELECT 0 AS'@checkAndRemoveInstalledPackage',(
                                            SELECT clientId AS 'client/@clientId',
                                            packageId AS 'packageInfoList/@packageId'FROM @tempClientPkgId
                                            FOR XML PATH('reqList'),TYPE)
                                            FOR XML PATH('JobManager_ClientPackageReqList'), TYPE)
        BEGIN
            if object_id('tempdb.dbo.#pushPkgResp') is not null DROP TABLE #pushPkgResp
            CREATE TABLE #pushPkgResp (
            val XML
            )
            EXEC JMPushPackagesWithOutputArg @clientInstallPkgReq, @clientInstallPkgResp output
        END
        DECLARE @responseTable TABLE (clientId INT,stat INT)
        INSERT INTO @responseTable
        SELECT  params.value('(client/ClientEntity/@clientId)[1]', 'int'),  params.value('(status)[1]','int')
            FROM  @clientInstallPkgResp.nodes ('JobManager_ClientPackageStatusResp/clientPackageStatusList
            /ClientPackageStatus') as R(params)
        IF (SELECT count(clientId) FROM @responseTable WHERE stat <> 0) >=1
        BEGIN
            SELECT @errorString = COALESCE(@errorString+',','') + CAST(clientId AS nvarchar) + ':' + CAST(stat AS nvarchar)  FROM @responseTable WHERE stat <> 0
            PRINT @errorString
        END
        ELSE
        BEGIN
SET @errorCode = 0
            SET @errorString = N'Package Install Request SUCCESS'
            PRINT @errorString
        END
		-- kill jobs from laptop clients which which are pending
		DECLARE @tblRsp TABLE(requestId INTEGER, rqGUID VARCHAR(1024))
		DECLARE @killXML XML
		DECLARE @wqXML XML
		SET @killXML = (SELECT
		1 as '@message',  -- ALL_SELECTED_JOBS  = 1
		'Converting the client to Cloud laptop mode' as '@operationDescription',
		3 as 'jobOpReq/@operationType', -- JOB_KILL = 3
		jInfo.jobId as 'jobOpReq/jobs/@jobId'
		FROM JMJobInfo jInfo WITH(NOLOCK) INNER JOIN JMBkpJobInfo bkpInfo WITH(NOLOCK) ON jInfo.jobId = bkpInfo.jobId AND jInfo.commCellId = bkpInfo.commcellId AND jInfo.opType <> 116 --STATELESS_BACKUP =116 (J0bManager.x)
				INNER JOIN APP_Application app WITH(NOLOCK) ON bkpInfo.applicationId = app.id
				INNER JOIN #GetPlanLaptopClients LC ON LC.clientId = app.clientId
INNER JOIN APP_BackupSetName B WITH(NOLOCK) ON app.backupSet = B.id AND (B.status & 0x00008) = 0x00008 AND (app.subclientStatus & 0x00008) = 0x00008
INNER JOIN APP_SubClientProp SCP WITH(NOLOCK) ON SCP.componentNameId = app.id AND SCP.attrName = 'Cloud Mode Enabled' AND SCP.modified = 0 AND SCP.attrVal = N'1'
		FOR XML PATH('JobManager_PerformMultiCellJobOpReq'))
		IF @killXML IS NOT NULL -- there jobs to be killed
		BEGIN
			INSERT INTO @tblRsp
			exec AppSubmitXMLRequestForWQ @killXML,@i_userId,-1
			SET @wqXML = (SELECT requestId as '@requestId',
					rqGUID as '@GUID'
			FROM @tblRsp
			FOR XML PATH('App_AsyncXMLRequestInfo'))
			IF @wqXML IS NOT NULL
			BEGIN
				INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
				Values(2, 27,CONVERT(NVARCHAR(MAX),@wqXML),@nowTime,0,0,0,-1)-- WORK_TOKEN_EXECUTE_XML_REQUEST
			END
		END
    END
    ELSE
    BEGIN
SET @errorCode = 2
        SET @errorString = 'Property Cloud Mode Enabled not set OR all the client have the Media agent package installed'
        PRINT @errorString
    END
	------END :add push MA core package
	IF OBJECT_ID('tempdb.dbo.#GetPlanLaptopClients') IS NOT NULL DROP TABLE #GetPlanLaptopClients
	IF OBJECT_ID('tempdb.dbo.#GetDefaultSubClients') IS NOT NULL DROP TABLE #GetDefaultSubClients
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanSetCloudLaptop')
	delete from GxQscripts where name = 'AppPlanSetCloudLaptop'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanSetCloudLaptop')
	delete from GXDBVersions where aliasname = 'AppPlanSetCloudLaptop'
GO

insert into GXDBVersions values(2, 'AppPlanSetCloudLaptop',  '00010001000200030000', 'AppPlanSetCloudLaptop', '00010001000200030000')
GO

