

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanScheduleEntityDeleteV2.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanScheduleEntityDeleteV2.sp,v $ $Id: AppPlanScheduleEntityDeleteV2.sp,v 1.1.4.4 2018/12/06 22:27:57 evolohov Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppProfileDelete   - marks existing profile as deleted
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanScheduleEntityDeleteV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanScheduleEntityDeleteV2 <<<'
	drop procedure AppPlanScheduleEntityDeleteV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanScheduleEntityDeleteV2')
	delete from GxQscripts where name = 'AppPlanScheduleEntityDeleteV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanScheduleEntityDeleteV2')
	delete from GXDBVersions where aliasname = 'AppPlanScheduleEntityDeleteV2'
GO
print '... Creating Procedure: AppPlanScheduleEntityDeleteV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanScheduleEntityDeleteV2
  @i_planId INT,
  @i_entityId INT,
  @i_userId INT,
  @i_localeId INT,
  @o_xmlText XML OUTPUT
AS
DECLARE @executionTime AS DATETIME = GETUTCDATE()
DECLARE @currentTime   INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', @executionTime))
DECLARE @errorCode     INT = 0
DECLARE @errorString   NVARCHAR(1024) = N'Entity ' + CAST(@i_entityId AS NVARCHAR(32)) + ' of plan ' + CAST(@i_planId AS NVARCHAR(32)) + ' is scheduled for deletion.'
SET @o_xmlText = NULL
-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
SET NOCOUNT ON
-- check if such plan exists
IF NOT EXISTS (SELECT * FROM App_Plan WITH(NOLOCK) WHERE id = @i_planId AND ((flag & 0x00004) = 0)) BEGIN
	SET @errorCode = 2
	SET @errorString = N'Plan not found'
END
-- check if user has an ability / permission to modify the plan
DECLARE @userHasCapability INT = 0
EXEC sec_checkPermissionOnEntity @i_userId, 157, @userHasCapability OUTPUT, 158, @i_planId
IF @errorCode = 0 BEGIN
	-- check if user is the plan owner/global admin and profile is not of special type
	IF NOT EXISTS ( SELECT  id
                    FROM    App_Plan WITH(NOLOCK)
                    WHERE       Id = @i_planId
AND (flag & 0x00004) = 0
                            AND  pclass NOT IN (0, 1) -- not master (0), template (1)
                            AND ((ownerId = @i_userId) OR (@userHasCapability = 1)))  BEGIN
		SET @errorCode = 5
		SET @errorString = N'Access is denied'
	END
END
DECLARE @planEntities TABLE(depth INT, componentNameId INT, attrName VARCHAR(512), attrType INT, attrVal VARCHAR(MAX), planEntityId INT, [Status] INT, PRIMARY KEY(attrName))
INSERT INTO @planEntities
    SELECT TOP 1 * FROM dbo.AppPlanGetAssociatedValuesV2(@i_planId, default) WHERE planEntityId = @i_entityId
DECLARE @level INT = NULL, @providerPlan INT = NULL, @attrName VARCHAR(512), @attrVal VARCHAR(MAX)
SELECT @level = depth, @providerPlan = componentNameId, @attrName = attrName, @attrVal = attrVal FROM @planEntities
IF @level IS NULL BEGIN -- there is no such entity : plan does not contain specified entity
	SET @errorCode = 87
	SET @errorString = N'Invalid parameter'
END ELSE IF @level != 0 BEGIN -- plan does not defines entity : entity value is derived
	SET @errorCode = 33
	SET @errorString = N'Sharing violation. Entity is provided by base plan ''' + (SELECT name FROM APP_Plan WHERE id = @providerPlan) + ''' (' + CAST(@providerPlan AS VARCHAR(32))+ ') and cannot be deleted'
END ELSE BEGIN -- everything is fine. mark entry for deletion
UPDATE App_PlanProp SET attrName = attrName + ' : to be deleted'
    WHERE  componentNameId = @i_planId AND attrName = @attrName AND attrVal = @attrVal AND  modified = 0
DECLARE @requiredEntitesList VARCHAR(MAX) = ISNULL((SELECT attrVal FROM APP_PlanProp WHERE componentNameId = @i_planId AND attrName = 'Defintion entities : required'), '')
    EXEC AppPlanCalcUpdateStatusV2 @i_planId, @requiredEntitesList
    -- update descendant
    EXEC AppPlanCalcUpdateDescendentStatusV2 @i_planId
END
-- set output value
SET @o_xmlText = (SELECT @errorCode '@errorCode', @errorString '@errorMessage' FOR XML PATH('Api_GenericResp'))
SET NOCOUNT OFF
RETURN @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanScheduleEntityDeleteV2')
	delete from GxQscripts where name = 'AppPlanScheduleEntityDeleteV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanScheduleEntityDeleteV2')
	delete from GXDBVersions where aliasname = 'AppPlanScheduleEntityDeleteV2'
GO

insert into GXDBVersions values(2, 'AppPlanScheduleEntityDeleteV2',  '00010001000400040000', 'AppPlanScheduleEntityDeleteV2', '00010001000400040000')
GO

