

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanScheduleDeleteV2.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanScheduleDeleteV2.sp,v $ $Id: AppPlanScheduleDeleteV2.sp,v 1.1.2.37.8.2 2021/02/09 20:49:04 rengu Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppProfileDelete   - marks existing profile as deleted
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppPlanScheduleDeleteV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanScheduleDeleteV2 <<<'
	drop procedure AppPlanScheduleDeleteV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanScheduleDeleteV2')
	delete from GxQscripts where name = 'AppPlanScheduleDeleteV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanScheduleDeleteV2')
	delete from GXDBVersions where aliasname = 'AppPlanScheduleDeleteV2'
GO
print '... Creating Procedure: AppPlanScheduleDeleteV2'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppPlanScheduleDeleteV2
  @i_planId INT,
  @i_userId INT,
  @i_localeId INT,
  @o_xmlText XML OUTPUT,
  @selectOutput INT=0
AS
IF OBJECT_ID('tempdb.dbo.#AppPlanScheduleDelete_tmp__Errors') IS NOT NULL DROP TABLE #AppPlanScheduleDelete_tmp__Errors
IF OBJECT_ID('tempdb.dbo.#AppPlanScheduleDelete_tmp__PreventingEntites') IS NOT NULL DROP TABLE #AppPlanScheduleDelete_tmp__PreventingEntites
IF OBJECT_ID('tempdb.dbo.#AppPlanScheduleDelete_tmp__ProvidersTable') IS NOT NULL DROP TABLE #AppPlanScheduleDelete_tmp__ProvidersTable
CREATE TABLE #AppPlanScheduleDelete_tmp__Errors(__type__ INT, errCode INT, errMessage NVARCHAR(MAX))
CREATE TABLE #AppPlanScheduleDelete_tmp__PreventingEntites(arg INT IDENTITY(1,1), [name] NVARCHAR(510), [parentName] NVARCHAR(510) DEFAULT NULL)
CREATE TABLE #AppPlanScheduleDelete_tmp__ProvidersTable(providerId INT, ownerCompany INT DEFAULT 0, [name] NVARCHAR(510) DEFAULT NULL)
DECLARE @executionTime AS DATETIME = GETUTCDATE()
DECLARE @currentTime   INT = DATEDIFF(s, '1970-01-01 00:00:00', @executionTime)
DECLARE @errorCode     INT = 0
DECLARE @errorString   NVARCHAR(1024) = N'Plan ' + CAST(@i_planId AS NVARCHAR(32)) + ' scheduled for deletion.'
DECLARE @rv            INT -- return value : number of errors
-- reset output value
SET @o_xmlText = NULL
-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
SET NOCOUNT ON
-- check if such plan exists
DECLARE @planName AS NVARCHAR(510) = (SELECT name FROM App_Plan WHERE id = @i_planId AND ((flag & 0x00004) = 0))
IF @planName IS NULL BEGIN
    INSERT INTO #AppPlanScheduleDelete_tmp__Errors
VALUES(158, 2, N'Plan not found')
END
IF NOT EXISTS (SELECT 1 FROM #AppPlanScheduleDelete_tmp__Errors)
BEGIN
    -- check if user has an ability / permission to delete the plan
    DECLARE @userHasCapability INT = 0
EXEC sec_checkPermissionOnEntity @i_userId, 158, @userHasCapability OUTPUT, 158, @i_planId
	-- check if user is the plan owner/global admin and profile is not of special type
	IF NOT EXISTS ( SELECT  id
                    FROM    App_Plan
                    WHERE       Id = @i_planId
AND (flag & 0x00004) = 0
                            AND  pclass NOT IN (0, 1) -- not master (0), template (1)
                            AND ((ownerId = @i_userId) OR (@userHasCapability = 1)))
	BEGIN
		-- sec_checkPermissionOnEntity just checks for rights on the plan. For replication plans, you need some extra checks like checking rights on the Hypervisor
        -- associated with the replication task of the plan.
		DECLARE @planSubtype INT = ISNULL((SELECT subType FROM App_Plan WHERE id = @i_planId),0)
IF(@i_planId <> 0 AND @planSubType = 83918853)
		BEGIN
EXEC [dbo].[sec_CheckRepPlanEntitiesSecurity] @i_planId, 158,@planSubType, @i_userId,0, @userHasCapability OUTPUT
			IF(@userHasCapability = 0)
			BEGIN
				INSERT INTO #AppPlanScheduleDelete_tmp__Errors
VALUES(158, 5, ISNULL((SELECT [Message] FROM EvLocaleMsgs WHERE LocaleId = @i_localeId AND MessageID = (3712 | (CAST(POWER(2, 24) AS BIGINT) * 35))), 'Access denied'))
			END
		END
		ELSE
		BEGIN
			INSERT INTO #AppPlanScheduleDelete_tmp__Errors
VALUES(158, 5, ISNULL((SELECT [Message] FROM EvLocaleMsgs WHERE LocaleId = @i_localeId AND MessageID = (3712 | (CAST(POWER(2, 24) AS BIGINT) * 35))), 'Access denied'))
		END
	END
END
IF NOT EXISTS (SELECT 1 FROM #AppPlanScheduleDelete_tmp__Errors)
BEGIN
    -- check if plan serves as a base plan for the other plan(s)
    DECLARE @preventingEntitiesCount INT = 0
    DECLARE @message NVARCHAR(MAX)
    -- -- -- query for all plans derived from the one being deleted
    INSERT INTO #AppPlanScheduleDelete_tmp__PreventingEntites (name)
        SELECT  [name]
FROM    APP_Plan P WITH(NOLOCK) INNER JOIN App_PlanProp PP WITH(NOLOCK) ON PP.componentNameId = P.id AND PP.attrName = 'Base plan' AND attrVal = CAST(@i_planId AS NVARCHAR(32))
    -- -- -- query out number of preventing entities
    SET @preventingEntitiesCount = (SELECT COUNT(1) FROM #AppPlanScheduleDelete_tmp__PreventingEntites)
    IF @preventingEntitiesCount > 0
    BEGIN
        SELECT @message = ISNULL((SELECT    [Message]
                                   FROM     EvLocaleMsgs
                                   WHERE        LocaleId = @i_localeId
AND MessageID = IIF(@preventingEntitiesCount = 1, (3733 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
IIF(@preventingEntitiesCount = 2, (3734 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
IIF(@preventingEntitiesCount = 3, (3735 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
(3736 | (CAST(POWER(2, 24) AS BIGINT) * 35)))))), 'Plan serves as a base plan for ' + CAST(@preventingEntitiesCount AS VARCHAR(32)) + ' other plans')
        SELECT @message = REPLACE(@message, '^' + CAST(PE.arg AS NVARCHAR(20)) + '%s', PE.name)
        FROM   #AppPlanScheduleDelete_tmp__PreventingEntites PE
        WHERE  arg < 4 -- only first 3 records
        SELECT @message = REPLACE(@message, '^4%d', CAST(@preventingEntitiesCount AS VARCHAR(32)))
        INSERT INTO #AppPlanScheduleDelete_tmp__Errors
VALUES (158, 170, @message)
    END
    -- check if there are still entities associated with the plan
    -- -- users
    -- -- -- make sure that there are no records in the entities table
    TRUNCATE TABLE #AppPlanScheduleDelete_tmp__PreventingEntites
    -- -- -- query for all users associated with the plan
    INSERT INTO #AppPlanScheduleDelete_tmp__PreventingEntites (name)
        SELECT  [name]
FROM    UMUsersProp UP WITH(NOLOCK) INNER JOIN UMUsers U WITH(NOLOCK) ON U.id = UP.componentNameId WHERE U.enabled = 1 AND UP.attrName = 'Associated Plan' AND UP.modified = 0 AND UP.attrVal = CAST(@i_planId AS NVARCHAR(32))
    -- -- -- query out number of preventing entities
    SET @preventingEntitiesCount = (SELECT COUNT(1) FROM #AppPlanScheduleDelete_tmp__PreventingEntites)
    IF @preventingEntitiesCount > 0
    BEGIN
        SELECT @message = ISNULL((SELECT    [Message]
                                  FROM      EvLocaleMsgs
                                  WHERE         LocaleId = @i_localeId
AND MessageID = IIF(@preventingEntitiesCount = 1, (3729 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
IIF(@preventingEntitiesCount = 2, (3730 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
IIF(@preventingEntitiesCount = 3, (3731 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
(3732 | (CAST(POWER(2, 24) AS BIGINT) * 35)))))), 'Plan is associated with ' + CAST(@preventingEntitiesCount AS VARCHAR(32)) + ' users')
            SELECT @message = REPLACE(@message, '^' + CAST(PE.arg AS NVARCHAR(20)) + '%s', PE.[name])
            FROM   #AppPlanScheduleDelete_tmp__PreventingEntites PE
            WHERE  arg < 4 -- only first 3 records
            SELECT @message = REPLACE(@message, '^4%d', CAST((@preventingEntitiesCount - 3) AS VARCHAR(32)))
            INSERT INTO #AppPlanScheduleDelete_tmp__Errors
VALUES (13, 170, @message)
    END
    -- -- mailbox users, databases, exchange db
    -- -- -- make sure that there are no records in the entities table
    TRUNCATE TABLE #AppPlanScheduleDelete_tmp__PreventingEntites
    -- -- -- query for all configuration entities associated with the plan
    INSERT INTO #AppPlanScheduleDelete_tmp__PreventingEntites (name)
        SELECT  [displayName]
        FROM    APP_EmailConfigPolicyAssoc WITH(NOLOCK) WHERE deleted = 0 AND planId = @i_planId AND modified = 0
    -- -- -- query out number of preventing entities
    SET @preventingEntitiesCount = (SELECT COUNT(1) FROM #AppPlanScheduleDelete_tmp__PreventingEntites)
    IF @preventingEntitiesCount > 0
    BEGIN
        SELECT @message = ISNULL((SELECT    [Message]
                                  FROM      EvLocaleMsgs
                                  WHERE         LocaleId = @i_localeId
AND MessageID = IIF(@preventingEntitiesCount = 1, (3721 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
IIF(@preventingEntitiesCount = 2, (3722 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
IIF(@preventingEntitiesCount = 3, (3723 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
(3724 | (CAST(POWER(2, 24) AS BIGINT) * 35)))))), 'Plan is associated with ' + CAST(@preventingEntitiesCount AS VARCHAR(32)) + ' configuration policies')
            SELECT @message = REPLACE(@message, '^' + CAST(PE.arg AS NVARCHAR(20)) + '%s', PE.[name])
            FROM   #AppPlanScheduleDelete_tmp__PreventingEntites PE
            WHERE  arg < 4 -- only first 3 records
            SELECT @message = REPLACE(@message, '^4%d', CAST((@preventingEntitiesCount - 3) AS VARCHAR(32)))
            INSERT INTO #AppPlanScheduleDelete_tmp__Errors
VALUES (177, 170, @message)
    END
		-- -- Onedrive and Sharepoint users\Sites
    -- -- -- make sure that there are no records in the entities table
    TRUNCATE TABLE #AppPlanScheduleDelete_tmp__PreventingEntites
    -- -- -- query for all configuration entities associated with the plan
    INSERT INTO #AppPlanScheduleDelete_tmp__PreventingEntites (name)
        SELECT  [displayName]
        FROM    APP_CloudAppUserDetails WITH(NOLOCK) WHERE status <> 1 AND planId = @i_planId AND modified = 0
    -- -- -- query out number of preventing entities
    SET @preventingEntitiesCount = (SELECT COUNT(1) FROM #AppPlanScheduleDelete_tmp__PreventingEntites)
    IF @preventingEntitiesCount > 0
    BEGIN
        SELECT @message = ISNULL((SELECT    [Message]
                                  FROM      EvLocaleMsgs
                                  WHERE         LocaleId = @i_localeId
AND MessageID = IIF(@preventingEntitiesCount = 1, (3721 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
IIF(@preventingEntitiesCount = 2, (3722 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
IIF(@preventingEntitiesCount = 3, (3723 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
(3724 | (CAST(POWER(2, 24) AS BIGINT) * 35)))))), 'Plan is associated with ' + CAST(@preventingEntitiesCount AS VARCHAR(32)) + ' configuration policies')
            SELECT @message = REPLACE(@message, '^' + CAST(PE.arg AS NVARCHAR(20)) + '%s', PE.[name])
            FROM   #AppPlanScheduleDelete_tmp__PreventingEntites PE
            WHERE  arg < 4 -- only first 3 records
            SELECT @message = REPLACE(@message, '^4%d', CAST((@preventingEntitiesCount - 3) AS VARCHAR(32)))
            INSERT INTO #AppPlanScheduleDelete_tmp__Errors
VALUES (177, 170, @message)
    END
        -- -- clients
    -- -- -- make sure that there are no records in the entities table
    TRUNCATE TABLE #AppPlanScheduleDelete_tmp__PreventingEntites
    -- -- -- query for all clients associated with the plan
    INSERT INTO   #AppPlanScheduleDelete_tmp__PreventingEntites (name)
        SELECT    CL.[name]
FROM      APP_Client CL WITH(NOLOCK) INNER JOIN APP_ClientProp CLP WITH(NOLOCK) ON CL.id = CLP.componentNameId AND CLP.attrName = 'Associated Plan'
            WHERE       CLP.modified = 0 AND CLP.attrVal = CAST(@i_planId AS NVARCHAR(32))
AND (((CL.status & 0x1000) != 0) OR ( 1 = (SELECT 1 FROM APP_ClientProp CLP2 WITH(NOLOCK) where CLP2.modified=0 and CL.id = CLP2.componentNameId
AND CLP2.attrName = 'System Drive Type' AND  CLP2.attrVal = CAST(6 AS NVARCHAR(32)))))--EdgeSystemDriveTypes_EDISCOVERY
                    AND iSNULL((SELECT attrVal FROM APP_ClientProp WHERE attrName = 'platformDeleted 4' AND componentNameId = CL.id), 0) = 0
AND ((CL.status & 0x00004) = 0) AND ((CL.status & 0x00002) = 0)
		UNION
		SELECT    CL.[name]
        FROM      APP_Client CL WITH(NOLOCK)
			INNER JOIN APP_ClientProp CLP WITH(NOLOCK)
ON CL.id = CLP.componentNameId AND CLP.attrName IN ('Associated Plan', 'Default Data classification Plan') AND CLP.modified = 0 AND CLP.attrVal = CAST(@i_planId AS NVARCHAR(32))
			INNER JOIN APP_PLAN AP WITH(NOLOCK)
ON AP.id=@i_planId AND AP.subtype=117506053
            WHERE  ISNULL((SELECT attrVal FROM APP_ClientProp WHERE attrName = 'platformDeleted 4' AND componentNameId = CL.id), 0) = 0
AND ((CL.status & 0x00004) = 0) AND ((CL.status & 0x00002) = 0)
    -- -- -- query out number of preventing entities
    SET @preventingEntitiesCount = (SELECT COUNT(1) FROM #AppPlanScheduleDelete_tmp__PreventingEntites)
    IF @preventingEntitiesCount > 0
    BEGIN
        SELECT @message = ISNULL((SELECT    [Message]
                                  FROM      EvLocaleMsgs
                                  WHERE         LocaleId = @i_localeId
AND MessageID = IIF(@preventingEntitiesCount = 1, (3713 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
IIF(@preventingEntitiesCount = 2, (3714 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
IIF(@preventingEntitiesCount = 3, (3715 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
(3716 | (CAST(POWER(2, 24) AS BIGINT) * 35)))))), 'Plan is associated with ' + CAST(@preventingEntitiesCount AS VARCHAR(32)) + ' clients')
            SELECT @message = REPLACE(@message, '^' + CAST(PE.arg AS NVARCHAR(20)) + '%s', PE.[name])
            FROM   #AppPlanScheduleDelete_tmp__PreventingEntites PE
            WHERE  arg < 4 -- only first 3 records
            SELECT @message = REPLACE(@message, '^4%d', CAST((@preventingEntitiesCount - 3) AS VARCHAR(32)))
            INSERT INTO #AppPlanScheduleDelete_tmp__Errors
VALUES (3, 170, @message)
    END
    -- -- subclients - a little bit different from the other entities as subclient's client name required as well
    -- -- -- make sure that there are no records in the entities table
    TRUNCATE TABLE #AppPlanScheduleDelete_tmp__PreventingEntites
    -- -- -- query for all subclient entities associated with the plan
    INSERT INTO #AppPlanScheduleDelete_tmp__PreventingEntites ([name], [parentName])
        SELECT  APP.subclientName, CL.[name]
        FROM    APP_SubClientProp SCPROP WITH (NOLOCK) INNER JOIN APP_Application APP WITH (NOLOCK) ON APP.id = SCPROP.componentNameId
                                                       INNER JOIN APP_Client       CL WITH (NOLOCK) ON CL.id  = APP.clientId
WHERE   (SCPROP.attrName IN ('Associated Plan' , 'Associated DC Plan')) AND (SCPROP.modified = 0) AND (SCPROP.attrVal =  CAST(@i_planId AS NVARCHAR(32)))
AND  SCPROP.cs_attrName IN (CHECKSUM(N'Associated Plan'),  CHECKSUM(N'Associated DC Plan')) AND  ((APP.subclientStatus & 0x00004) = 0) AND ((APP.subclientStatus &  0x00002) = 0)
    -- -- -- query out number of preventing entities
    SET @preventingEntitiesCount = (SELECT COUNT(1) FROM #AppPlanScheduleDelete_tmp__PreventingEntites)
    IF @preventingEntitiesCount > 0
    BEGIN
        SELECT @message = ISNULL((SELECT    [Message]
                                  FROM      EvLocaleMsgs
                                  WHERE         LocaleId = @i_localeId
AND MessageID = IIF(@preventingEntitiesCount = 1, (3725 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
IIF(@preventingEntitiesCount = 2, (3726 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
IIF(@preventingEntitiesCount = 3, (3727 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
(3728 | (CAST(POWER(2, 24) AS BIGINT) * 35)))))), 'Plan is associated with ' + CAST(@preventingEntitiesCount AS VARCHAR(32)) + ' subclients')
        SELECT @message = REPLACE(REPLACE(@message, '^' + CAST(((PE.arg * 2) - 1) AS varchar(32)) + '%s', PE.name), '^' + CAST((PE.arg * 2) AS varchar(32)) + '%s', PE.ParentName)
        FROM   #AppPlanScheduleDelete_tmp__PreventingEntites PE
        WHERE  arg < 4 -- only first 3 records
        SELECT @message = REPLACE(@message, '^7%d', CAST((@preventingEntitiesCount - 3) AS VARCHAR(32)))
        INSERT INTO #AppPlanScheduleDelete_tmp__Errors
VALUES (7, 170, @message)
    END
    -- -- check if any company associated with the plan
    -- -- -- make sure that there are no records in the entities table
    TRUNCATE TABLE #AppPlanScheduleDelete_tmp__PreventingEntites
DECLARE @adminUserId INT = (SELECT TOP 1 id FROM UMUsers WHERE flags & 0x040 <> 0)
	DECLARE @securityAssociations XML
EXEC sec_getSecurityForEntity @adminuserId, @securityAssociations OUTPUT, 158, @i_planId
    INSERT INTO #AppPlanScheduleDelete_tmp__ProvidersTable (providerId)
    SELECT ISNULL(ref.value('userOrGroup[1]/@providerId', 'INT'),0) FROM @securityAssociations.nodes('associations') R ( ref )
    -- figure out company's names
    UPDATE CT
SET     CT.ownerCompany = CASE UD.serviceType WHEN 5 THEN UD.id
WHEN 2 THEN UD.ownerCompany
WHEN 12 THEN UD.ownerCompany
WHEN 1 THEN 0
                                                  ELSE 0 END,
            CT.[name] = UD.hostName
    FROM    #AppPlanScheduleDelete_tmp__ProvidersTable CT INNER JOIN UMDSProviders UD ON UD.id = CT.providerId
    WHERE CT.providerId != 0
    INSERT INTO #AppPlanScheduleDelete_tmp__PreventingEntites([name])
        SELECT DISTINCT [name] FROM  #AppPlanScheduleDelete_tmp__ProvidersTable WHERE ownerCompany <> 0
    SET @preventingEntitiesCount = (SELECT COUNT(DISTINCT ownerCompany) FROM #AppPlanScheduleDelete_tmp__ProvidersTable WHERE ownerCompany <> 0)
    SET @preventingEntitiesCount = IIF((@preventingEntitiesCount = 1) AND (EXISTS(SELECT 1 FROM #AppPlanScheduleDelete_tmp__ProvidersTable WHERE ownerCompany = dbo.AppGetCompanyForUserOrUserGroup(@i_userId,default))), 0, @preventingEntitiesCount)
    IF @preventingEntitiesCount > 0
    BEGIN
        SELECT @message = ISNULL((SELECT    [Message]
                                  FROM      EvLocaleMsgs
                                  WHERE         LocaleId = @i_localeId
AND MessageID = IIF(@preventingEntitiesCount = 1, (3717 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
IIF(@preventingEntitiesCount = 2, (3718 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
IIF(@preventingEntitiesCount = 3, (3719 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
(3720 | (CAST(POWER(2, 24) AS BIGINT) * 35)))))), 'Plan is associated with ' + CAST(@preventingEntitiesCount AS VARCHAR(32)) + ' companies')
            SELECT @message = REPLACE(@message, '^' + CAST(PE.arg AS NVARCHAR(20)) + '%s', PE.[name])
            FROM   #AppPlanScheduleDelete_tmp__PreventingEntites PE
            WHERE  arg < 4 -- only first 3 records
            SELECT @message = REPLACE(@message, '^4%d', CAST((@preventingEntitiesCount - 3) AS VARCHAR(32)))
            INSERT INTO #AppPlanScheduleDelete_tmp__Errors
VALUES (177, 170, @message)
    END
    -- -- default for companies
    -- -- -- make sure that there are no records in the entities table
    TRUNCATE TABLE #AppPlanScheduleDelete_tmp__PreventingEntites
    -- -- -- query for all companies associated with the plan
    INSERT INTO   #AppPlanScheduleDelete_tmp__PreventingEntites (name)
        SELECT  A.[name]
FROM    (SELECT IIF(attrName IN('Default Server Plan',
'Default Laptop Plan',
'Default Snap Plan',
'Default DB Plan',
'Default File System Plan',
'Default Virtual Server Backup Plan',
'Default Virtual Server Replication Plan'), 1, 0 ) AS doesExist,
                        UD.domainName AS [name]
                FROM    App_CompanyProp CP INNER JOIN UMDSProviders UD ON UD.id = CP.componentNameId AND UD.id > 0
                WHERE       attrValInt=@i_planId
                            --
AND cs_attrName IN(checksum('Default Server Plan',
checksum('Default Laptop Plan'),
checksum('Default Snap Plan'),
checksum('Default DB Plan'),
checksum('Default File System Plan'),
checksum('Default Virtual Server Backup Plan'),
checksum('Default Virtual Server Replication Plan')))) A
        WHERE A.doesExist = 1
        -- -- -- query out number of preventing entities
    SET @preventingEntitiesCount = (SELECT COUNT(1) FROM #AppPlanScheduleDelete_tmp__PreventingEntites)
    IF @preventingEntitiesCount > 0
    BEGIN
        SELECT @message = ISNULL((SELECT    [Message]
                                  FROM      EvLocaleMsgs
                                  WHERE         LocaleId = @i_localeId
AND MessageID = IIF(@preventingEntitiesCount = 1, (3737 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
IIF(@preventingEntitiesCount = 2, (3738 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
IIF(@preventingEntitiesCount = 3, (3739 | (CAST(POWER(2, 24) AS BIGINT) * 35)),
(3740 | (CAST(POWER(2, 24) AS BIGINT) * 35)))))), 'Plan is default for ' + CAST(@preventingEntitiesCount AS VARCHAR(32)) + ' companies')
        SELECT @message = REPLACE(@message, '^' + CAST(PE.arg AS NVARCHAR(20)) + '%s', PE.[name])
        FROM   #AppPlanScheduleDelete_tmp__PreventingEntites PE
        WHERE  arg < 4 -- only first 3 records
        SELECT @message = REPLACE(@message, '^4%d', CAST((@preventingEntitiesCount - 3) AS VARCHAR(32)))
        INSERT INTO #AppPlanScheduleDelete_tmp__Errors
VALUES (158, 170, @message)
    END
END
-- mark plan as deleted if there were no errors.
IF NOT EXISTS (SELECT 1 FROM #AppPlanScheduleDelete_tmp__Errors)
BEGIN
    -- flag that indicates that plan is scheduled for deletion
	MERGE   App_PlanProp AS TGT
USING   (SELECT @i_planId, 'Scheduled for deletion') AS SRC(componentNameId, attrName)
	ON      TGT.componentNameId = SRC.componentNameId AND TGT.attrName = SRC.attrName
    WHEN    MATCHED     THEN UPDATE SET TGT.attrVal  = '1'
WHEN    NOT MATCHED THEN INSERT VALUES (SRC.componentNameId, SRC.attrName, 2, '1', @currentTime, 0);
	DECLARE @planDeleteName NVARCHAR(MAX) = @planName + N' : scheduled for deletion ' + CONVERT(VARCHAR(24), @executionTime, 121)  + N' by ' + ISNULL((SELECT name + ' (' + CAST(@i_userId AS NVARCHAR(32)) + ')'  FROM UMUsers WHERE id = @i_userId), CAST(@i_userId AS NVARCHAR(32)))
	UPDATE APP_Plan
		SET name = @planDeleteName,
flag = flag | 0x40000000,
            modified = @currentTime
	WHERE id = @i_planId
	-- Sequence is important here
	-- First rename app_plan, so that scg refresh in below code refresh without any issue
    -- MR 240529 (https://engweb.commvault.com/engtools/defect/240529). plan is going to be deleted right away. no need to rename entities to mark 'em as scheduled for deletion
	-- EXEC AppPlanUpdateDeleteEntityNameV2 @i_planId, @planName, @planDeleteName, @i_userId, @i_localeId, @errorCode OUTPUT, @errorString OUTPUT
	-- disable schedule for the task
    -- -- get list of storage polices associated with the plan. will be used to find and disable aux copy schedules
    DECLARE @storagePolicies AS TABLE (id INT)
    INSERT INTO @storagePolicies
SELECT  CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName IN ('Storage policy', 'Log storage policy')
	DECLARE @schedulePolicies AS TABLE(taskId INT)
	INSERT INTO @schedulePolicies(taskId)
SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @i_planId AND attrName IN ('Schedule policy','Log schedule policy')
	UPDATE	TM_Task
	SET		disabled = 1
    WHERE	taskId IN ( -- schedule policies directly associated with the plan
                        SELECT taskId FROM @schedulePolicies
                        UNION ALL
                        -- replication schedules
SELECT CAST(_ID AS INT) FROM dbo.SplitIDString((SELECT attrVal FROM APP_PlanProp WHERE (componentNameId = @i_planId) AND (attrName = 'Replication schedule policy')))
                        UNION ALL
                        -- aux copy schedules
                        SELECT taskId FROM TM_AssocEntity WHERE ((copyId IN (SELECT id FROM archGroupCopy WHERE archGroupId IN (SELECT id FROM @storagePolicies)))
																		OR ((policyId IN (SELECT id FROM @storagePolicies)) AND (copyId = 0)))
																AND (taskId NOT IN (SELECT taskId FROM TM_Task WHERE taskType = 4)) -- 4:schedule policy
                      )
	-- from SP23 plan id is associated to schedule policy instead of subclient id
	-- on plan deletion we need to remove associations of this plan id.
	DELETE assoc
	FROM TM_AssocEntity assoc
	JOIN TM_Task task
	ON task.taskId = assoc.taskId
	WHERE task.taskId in (
		SELECT taskId FROM @schedulePolicies
	)
AND assoc.assocType = 158-- plan entity
	-- If auxcopy is associated with system created auxcopy schedule policy, then remove this association
	DELETE assc
	FROM TM_AssocEntity assc
	JOIN TM_Task task
	ON ((assc.copyId IN (SELECT id FROM archGroupCopy WHERE archGroupId IN (SELECT id FROM @storagePolicies))) OR ((assc.policyId IN (SELECT id FROM @storagePolicies)) AND (assc.copyId = 0)))
		AND task.taskId = assc.taskId
	WHERE task.taskType = 4 -- 4:schedule policy
    -- audit operation ---------------------------------------------------------------------------------------------------------------------------------------------------------
DECLARE @opMsgId   INT = (608 | (CAST(POWER(2, 24) AS BIGINT) * 84)) -- 'Delete existing plan'
    DECLARE @opEvMsgId INT -- dummy not used.
    DECLARE @opId      INT = 0
    EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
DECLARE @paramMsgId INT = (1639 | (CAST(POWER(2, 24) AS BIGINT) * 85))  -- Plan scheduled for deletion : '^1%s'
    EXEC EvGuiAuditSetParamData @opId, @planName, 0
    EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
    -- -------------------------------------------------------------------------------------------------------------------------------------------------------------------------
END
-- set output value
SET @o_xmlText =
(
    SELECT
        (SELECT
            (SELECT ER.__type__ AS '@__type__'
             FOR XML PATH('entity'), TYPE),
            (SELECT ER.errCode      AS '@errorCode',
                    ER.errMessage   AS '@errorMessage'
             FOR XML PATH('status'), TYPE)
         FROM #AppPlanScheduleDelete_tmp__Errors AS ER
         FOR XML PATH('error'), TYPE)
    FOR XML PATH('Api_PlanComponentErrorList')
)
SET @rv = (SELECT COUNT(1) FROM #AppPlanScheduleDelete_tmp__Errors)
IF OBJECT_ID('tempdb.dbo.#AppPlanScheduleDelete_tmp__ProvidersTable') IS NOT NULL DROP TABLE #AppPlanScheduleDelete_tmp__ProvidersTable
IF OBJECT_ID('tempdb.dbo.#AppPlanScheduleDelete_tmp__PreventingEntites') IS NOT NULL DROP TABLE #AppPlanScheduleDelete_tmp__PreventingEntites
IF OBJECT_ID('tempdb.dbo.#AppPlanScheduleDelete_tmp__Errors') IS NOT NULL DROP TABLE #AppPlanScheduleDelete_tmp__Errors
SET NOCOUNT OFF
IF(@selectOutput =1)
	SELECT @o_xmlText
RETURN @rv
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanScheduleDeleteV2')
	delete from GxQscripts where name = 'AppPlanScheduleDeleteV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanScheduleDeleteV2')
	delete from GXDBVersions where aliasname = 'AppPlanScheduleDeleteV2'
GO

insert into GXDBVersions values(2, 'AppPlanScheduleDeleteV2',  'v1.1.2.37.8.2', 'AppPlanScheduleDeleteV2', 'v1.1.2.37.8.2')
GO

