

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanScheduleDelete.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanScheduleDelete.sp,v $ $Id: AppPlanScheduleDelete.sp,v 1.1.2.10 2018/06/16 12:40:12 vdevassy Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppProfileDelete   - marks existing profile as deleted
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppPlanScheduleDelete <<<'

IF EXISTS (select * from sysobjects where name='AppPlanScheduleDelete')
	drop procedure AppPlanScheduleDelete
IF EXISTS (select * from GxQscripts where name='AppPlanScheduleDelete')
	delete from GxQscripts where name = 'AppPlanScheduleDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanScheduleDelete')
	delete from GXDBVersions where aliasname = 'AppPlanScheduleDelete'
GO
print '... Creating Procedure: AppPlanScheduleDelete'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanScheduleDelete
  @i_planId INT,
  @i_userId INT,
  @o_xmlText XML OUTPUT
AS
-------------------------------------------------------------------------------------------------------------------------------------------
--Code Below Here is From AppPlanConstants.spb
-- declare plan properties definition shared values
DECLARE @constAttrType_BasePlan					INT = 260
DECLARE @constAttrName_BasePlan					NVARCHAR(32) = N'BasePlan'
DECLARE @constAttrType_Feature					INT = 261
DECLARE @constAttrName_Feature					NVARCHAR(32) = N'Feature'
DECLARE @constAttrType_Alert					INT = 262
DECLARE @constAttrName_Alert					NVARCHAR(32) = N'Alert'
DECLARE @constAttrType_AccessPolicy				INT = 263
DECLARE @constAttrName_AccessPolicy				NVARCHAR(32) = N'Access policy'
DECLARE @constAttrType_Policy_Subclient			INT = 264
DECLARE @constAttrName_Policy_Subclient			NVARCHAR(32) = N'Subclient policy'
DECLARE @constAttrType_Policy_Schedule			INT = 265
DECLARE @constAttrName_Policy_Schedule			NVARCHAR(32) = N'Schedule policy'
DECLARE @constAttrType_Policy_Storage			INT = 266
DECLARE @constAttrName_Policy_Storage			NVARCHAR(32) = N'Storage policy'
DECLARE @constAttrType_Options					INT = 267
DECLARE @constAttrName_Options_Quota			NVARCHAR(32) = 'Quota'
DECLARE @constAttrName_Options_EdgeDriveQuota	NVARCHAR(32) = 'Edge Drive Quota Size'
DECLARE @constAttrName_Options_Throttle			NVARCHAR(32) = 'Network Throttle'
DECLARE @constAttrType_UserGroupAssigned		INT = 268
DECLARE @constAttrName_UserGroupAssigned		NVARCHAR(32) = 'Assigned user group'
DECLARE @constAttrType_UserGroupIAssoc			INT = 269
DECLARE @constAttrName_UserGroupIAssoc			NVARCHAR(32) = 'Associated internal user group'
DECLARE @constAttrType_UserGroupEAssoc			INT = 270
DECLARE @constAttrName_UserGroupEAssoc			NVARCHAR(32) = 'Associated external user group'
DECLARE @constAttrType_Restrictions				INT = 271
DECLARE @constAttrName_Restrictions				NVARCHAR(32) = 'Entity restrictions'
DECLARE @constAttrType_AssociatedPlan			INT = 272
DECLARE @constAttrName_AssociatedPlan			NVARCHAR(32) = 'Associated Plan'
DECLARE @constAttrType_ClientGroupAssigned		INT = 273
DECLARE @constAttrName_ClientGroupAssigned		NVARCHAR(32) = 'Assigned client group'
DECLARE @constAttType_ScheduledForDeletion		INT = 274
DECLARE @constAttName_ScheduledForDeletion		NVARCHAR(32) = 'Scheduled for deletion'
DECLARE @constAttType_EdgeDriveAssigned  		INT = 275
DECLARE @constAttName_EdgeDriveAssigned 		NVARCHAR(32) = 'Assgined Edge Drive'
DECLARE @constAttrType_Policy_SubclientWin		INT = 276
DECLARE @constAttrName_Policy_SubclientWin		NVARCHAR(32) = N'Subclient policy 2'
DECLARE @constAttrType_Policy_SubclientLin		INT = 277
DECLARE @constAttrName_Policy_SubclientLin		NVARCHAR(32) = N'Subclient policy 3'
DECLARE @constAttrType_Policy_SubclientMac		INT = 278
DECLARE @constAttrName_Policy_SubclientMac		NVARCHAR(32) = N'Subclient policy 4'
DECLARE @constAttType_SubclientRetention		INT = 279
DECLARE @constAttName_SubclientRetention		NVARCHAR(32) = 'Subclient retention period'
DECLARE @constAttType_SubclientVersions			INT = 280
DECLARE @constAttName_SubclientVersions			NVARCHAR(32) = 'Number of Synth Full Versions'
DECLARE @constAttrType_Policy_ScheduleLog   		INT = 281
DECLARE @constAttrName_Policy_ScheduleLog   		NVARCHAR(32) = N'Log schedule policy'
DECLARE @constAttrType_Policy_StorageLog    		INT = 282
DECLARE @constAttrName_Policy_StorageLog   		 NVARCHAR(32) = N'Log storage policy'
DECLARE @constAttType_SlaInMinutes			INT = 283
DECLARE @constAttName_SlaInMinutes			NVARCHAR(32) = N'SLA In Minutes'
DECLARE @constAttType_LogSlaInMinutes			INT = 285
DECLARE @constAttName_LogSlaInMinutes			NVARCHAR(32) = N'Log SLA In Minutes'
DECLARE @constAttType_ReplicationTargets    		INT = 284
DECLARE @constAttName_ReplicationTargets   		 NVARCHAR(32) = N'Replication schedule policy'
DECLARE @constAttType_ForcedArchiving   		INT = 286
DECLARE @constAttName_ForcedArchiving   		 NVARCHAR(32) = N'Forced Archiving'
-- plan entity identifiers are declared in http:--ncvs/source/xref/win/vaultcx/Source/Common/XmlMessage/Api.x : enum PlanEntities
DECLARE @constPlanEntity_StoragePolicy		 INT =   1
DECLARE @constPlanEntity_SubclientPolicy	 INT =   2
DECLARE @constPlanEntity_SchedulePolicy		 INT =   4
DECLARE @constPlanEntity_Features			 INT =   8
DECLARE @constPlanEntity_Users				 INT =  16
DECLARE @constPlanEntity_Alerts				 INT =  32
DECLARE @constPlanEntity_AccessPolicies		 INT =  64
DECLARE @constPlanEntity_Options			 INT = 128
DECLARE @constPlanEntity_SubclientPolicy_Win INT = 256
DECLARE @constPlanEntity_SubclientPolicy_Lin INT = 512
DECLARE @constPlanEntity_SubclientPolicy_Mac INT = 1024
DECLARE @constPlanEntity_ClientGroup		 INT = 2048
DECLARE @constPlanEntity_EdgeDrive           INT = 4096
DECLARE @constPlanEntity_StoragePolicyLog	 INT = 8192
DECLARE @constPlanEntity_SchedulePolicyLog   INT = 16384
DECLARE @constPlanEntity_ReplicationTargets	 INT = 32768
-- entity operations. declared in http:--ncvs/source/xref/11.0-win/vaultcx/Source/Common/XmlMessage/CVGui.x#197 : enum ListOperationType
DECLARE @constOpType_NONE					INT = 0
DECLARE @constOpType_OVERWRITE				INT = 1
DECLARE @constOpType_ADD					INT = 2
DECLARE @constOpType_DELETE					INT = 3
DECLARE @constOpType_CLEAR					INT = 4
-------------------------------------------------------------------------------------------------------------------------------------------
DECLARE @executionTime AS DATETIME = GETUTCDATE()
DECLARE @currentTime   INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', @executionTime))
DECLARE @errorCode     INT = 0
DECLARE @errorString   NVARCHAR(1024) = N'Plan ' + CAST(@i_planId AS NVARCHAR(32)) + ' scheduled for deletion.'
DECLARE @planSubType INT =  0
SELECT @planSubType = subType FROM App_Plan WHERE id = @i_planId
SET @o_xmlText = NULL
-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
SET NOCOUNT ON
-- check if such plan exists
IF NOT EXISTS (SELECT * FROM App_Plan WHERE id = @i_planId AND ((flag & 0x00004) = 0)) BEGIN
	SET @errorCode = 2
	SET @errorString = N'Plan not found'
END
-- check if user has an ability / permission to delete the plan
DECLARE @userHasCapability INT = 0
EXEC sec_checkPermissionOnEntity @i_userId, 158, @userHasCapability OUTPUT, 158, @i_planId
IF @errorCode = 0 BEGIN
	-- check if user is the plan owner/global admin and profile is not of special type
	IF NOT EXISTS ( SELECT  id
                    FROM    App_Plan
                    WHERE       Id = @i_planId
AND (flag & 0x00004) = 0
                            AND  pclass NOT IN (0, 1) -- not master (0), template (1)
                            AND ((ownerId = @i_userId) OR (@userHasCapability = 1)))  BEGIN
		SET @errorCode = 5
		SET @errorString = N'Access is denied'
	END
END
-- check if plan serves as a base plan for the other plan(s)
IF @errorCode = 0 BEGIN
    IF EXISTS (SELECT id FROM APP_PlanProp WHERE attrType = @constAttrType_BasePlan AND attrVal = CAST(@i_planId AS NVARCHAR(32))) BEGIN
		SET @errorCode = 170
		SET @errorString = N'Plan is in use.'
    END
END
-- check if there is still users associated with the plan
IF @errorCode = 0 BEGIN
	IF EXISTS (SELECT id FROM UMUsersProp WHERE attrName = @constAttrName_AssociatedPlan AND modified = 0 AND attrVal = CAST(@i_planId AS NVARCHAR(32))) OR
	   EXISTS (SELECT APP.id FROM APP_SubClientProp SCPROP WITH (NOLOCK) INNER JOIN APP_Application APP WITH (NOLOCK) ON APP.id = SCPROP.componentNameId
WHERE (SCPROP.attrName = @constAttrName_AssociatedPlan) AND (SCPROP.modified = 0) AND (SCPROP.attrVal =  CAST(@i_planId AS NVARCHAR(32))) AND ((APP.subclientStatus & 0x00004) = 0) AND ((APP.subclientStatus &  0x00002) = 0)) BEGIN
		SET @errorCode = 170
		SET @errorString = N'Plan is in use.'
	END
END
-- Check If Any Company has been allocated this plan
IF @errorCode = 0
BEGIN
	DECLARE @securityAssociations XML
EXEC sec_getSecurityForEntity @i_userId, @securityAssociations OUTPUT, 158, @i_planId
	DECLARE @companyAssocTable TABLE (roleId int, permissionId int)
	INSERT into @companyAssocTable
		SELECT ISNULL(ref.value('@roleId', 'INT'),0), 0 FROM @securityAssociations.nodes('associations/properties/role') R ( ref )
		UNION ALL
		SELECT 0, ISNULL(ref.value('@permissionId', 'INT'),0) FROM @securityAssociations.nodes('associations/properties/categoryPermission/categoriesPermissionList') R ( ref )
DECLARE @rolePlanCreatorId INT =ISNULL((SELECT id FROM UMRoles WHERE name = 'Plan Creator Role' ),0)
	IF EXISTS (SELECT TOP 1 * from @companyAssocTable WHERE (@rolePlanCreatorId <> 0) AND (permissionId <> 0 OR roleId <> @rolePlanCreatorId))
	BEGIN
		SET @errorCode = 170
		SET @errorString = N'Plan is assigned to some companies. Please de-associate plan from companies and try again.'
	END
END
-- mark plan as deleted if there were no errors.
IF @errorCode = 0 BEGIN
	MERGE   App_PlanProp AS TGT
	USING   (SELECT @i_planId, @constAttName_ScheduledForDeletion, @constAttType_ScheduledForDeletion) AS SRC(componentNameId, attrName, attrType)
	ON      TGT.componentNameId = SRC.componentNameId AND TGT.attrType = SRC.attrType AND TGT.attrName = SRC.attrName
    WHEN    MATCHED     THEN UPDATE SET TGT.attrVal  = '1'
    WHEN    NOT MATCHED THEN INSERT VALUES (SRC.componentNameId, SRC.attrName, SRC.attrType, '1', @currentTime, 0);
	UPDATE APP_Plan
		SET name = name + N' : scheduled for deletion ' + CONVERT(VARCHAR(24), @executionTime, 121)  + N' by ' + ISNULL((SELECT name + ' (' + CAST(@i_userId AS NVARCHAR(32)) + ')'  FROM UMUsers WHERE id = @i_userId), CAST(@i_userId AS NVARCHAR(32))),
flag = flag | 0x40000000
	WHERE id = @i_planId
	-- disable schedule for the task
	UPDATE	TM_Task
	SET		disabled = 1
	WHERE	taskId IN (SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE (componentNameId = @i_planId) AND (attrType = @constAttrType_Policy_Schedule))
	-- Mark replication schedule deleted for VSA replication plans
	if (@planSubType=83918853) --Live Sync .. Api_VSAReplication
	begin
		UPDATE	TM_Task
		SET		deleted = 1
		WHERE	taskId IN (SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE (componentNameId = @i_planId) AND (attrType = @constAttType_ReplicationTargets))
		-- run the maintenance thread so that replications are deleted immediately if applicable for deleted replication schedules.
		IF object_id('tempdb.dbo.#replicationIdTable') is not null
			DROP TABLE #replicationIdTable
		create table #replicationIdTable(replicationId int primary key(replicationId) )
		Insert into #replicationIdTable
		SELECT distinct T.replicationId
		FROM
		(
			SELECT replicationId, taskId
			FROM APP_VSAReplication VR WITH (NOLOCK)
			WHERE NOT EXISTS (SELECT 1 FROM TM_Task T WITH (NOLOCK) WHERE T.taskId = VR.taskId and T.deleted=0)	--SCHEDULE GOT DELETED
			UNION
			SELECT replicationId, taskId
			FROM APP_VSAReplication VR
			WHERE flags = 1		--MARK FOR DELETION
		) T
		WHERE NOT EXISTS (
			SELECT 1 FROM JMRstJobInfo JR WITH (NOLOCK) --TABLE STORES THE SUBTASK NOT THE TASK ID
			JOIN TM_JobOptions JO (NOLOCK) ON JO.subTaskId = JR.rstTaskID	--ONLY WAY TO GET THE TASK ID IF TASK IS DELETED
			WHERE JO.taskId = T.taskId
			)
		DELETE APP_VSAReplicationProp
		FROM APP_VSAReplicationProp
		inner join #replicationIdTable replicationIdTable on
		APP_VSAReplicationProp.replicationId = replicationIdTable.replicationId
		DELETE APP_VSAReplication
		FROM APP_VSAReplication
		inner join #replicationIdTable replicationIdTable on
		APP_VSAReplication.replicationId = replicationIdTable.replicationId
		IF object_id('tempdb.dbo.#replicationIdTable') is not null
			DROP TABLE #replicationIdTable
	end
END
-- set output value
SET @o_xmlText = (SELECT @errorCode '@errorCode', @errorString '@errorMessage' FOR XML PATH('Api_GenericResp'))
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanScheduleDelete')
	delete from GxQscripts where name = 'AppPlanScheduleDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanScheduleDelete')
	delete from GXDBVersions where aliasname = 'AppPlanScheduleDelete'
GO

insert into GXDBVersions values(2, 'AppPlanScheduleDelete',  '00010001000200100000', 'AppPlanScheduleDelete', '00010001000200100000')
GO

