

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanSLAOptionsSetV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanSLAOptionsSetV2.sp,v $ $Id: AppPlanSLAOptionsSetV2.sp,v 1.1.2.6 2020/12/03 13:17:17 samrutkar Exp $";
--	+===============================================================================+
--	|  							AppPlanSLAOptionsSetV2								|
--	|																				|
--  |  PARAMETERS			  														|
--  |    i_userId	  = id of the requestor											|
--  |    i_planId	  = id of the plan												|
--  |    i_localeId	  = id of the locale											|
--  |    x_xmlData	  = input Api_SLAOptions request xml							|
--	|					output App_GenericResp xml									|
--	+===============================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppPlanSLAOptionsSetV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanSLAOptionsSetV2 <<<'
	drop procedure AppPlanSLAOptionsSetV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanSLAOptionsSetV2')
	delete from GxQscripts where name = 'AppPlanSLAOptionsSetV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanSLAOptionsSetV2')
	delete from GXDBVersions where aliasname = 'AppPlanSLAOptionsSetV2'
GO
print '... Creating Procedure: AppPlanSLAOptionsSetV2'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppPlanSLAOptionsSetV2
  @i_userId INT,
  @i_planId INT,
  @i_localeId INT,
  @x_xmlData XML OUTPUT 
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
--
BEGIN TRY
-- CHECK PLAN EXIST AND UPDATE SECURITY CHECK --------------------------------------------------------------------------------------------------------------------------------
DECLARE @errorCode					INT = 0,
		@errorString				NVARCHAR(1024) = '',
		@userHasCapabilityUpdate	INT = 0,
		@tranCnt					INT = @@TRANCOUNT
IF @tranCnt > 0
	SAVE TRAN AppSLAOptionsSet_Tran
ELSE
	BEGIN TRAN AppSLAOptionsSet_Tran
IF (NOT EXISTS (SELECT id FROM App_Plan WHERE (id = @i_planId) AND ((flag & 0x00004) = 0) AND ((flag & 0x40000000) = 0) )   )
BEGIN
    SET @errorCode = 1
	SET @errorString = N'Plan not found'
END
--
IF @errorCode = 0
BEGIN
EXEC sec_checkPermissionOnEntity @i_userId, 157, @userHasCapabilityUpdate OUTPUT, 158, @i_planId
    IF (@userHasCapabilityUpdate = 0) AND (NOT EXISTS (SELECT id FROM App_Plan WHERE id = @i_planId AND ownerId = @i_userId)) BEGIN
        SET @errorCode = 1
		SET @errorString = N'Access denied.'
    END
END
--
IF @errorCode <> 0
	GOTO ERROR_EXIT
--
--
-- CHECK PLAN EXIST AND UPDATE SECURITY CHECK --------------------------------------------------------------------------------------------------------------------------------
DECLARE @slaLevel    INT, @slaDays int, @delayInterval INT, @excludeSLA INT, @slaDescription NVARCHAR(1024)
SELECT
	@slaLevel		= ISNULL(ref.value('@level', 'INT'), NULL),
	@slaDays		= ISNULL(ref.value('@slaDays', 'INT'), NULL),
	@delayInterval  = ISNULL(ref.value('@delayInterval', 'INT'), NULL),
	@slaDescription = ISNULL(ref.value('@slaDescription', 'NVARCHAR(1024)'), NULL),
	@excludeSLA		= ISNULL(ref.value('@excludeSLA', 'INT'), NULL)
FROM @x_xmlData.nodes('Api_SLAOptions') R ( ref )
--
--
-- Add/Update SLA options ----------------------------------------------------------------------------------------------------------------------------------------------------
IF @slaLevel IS NOT NULL
EXEC AppPlanSetEntityValueV2 @i_planId, 'SLA option', @slaLevel, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode = 0 AND @slaDescription IS NOT NULL
EXEC AppPlanSetEntityValueV2 @i_planId, 'SLA option description', @slaDescription, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode = 0 AND @slaDays IS NOT NULL
EXEC AppPlanSetEntityValueV2 @i_planId, 'SLA option in days', @slaDays, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode = 0 AND @delayInterval IS NOT NULL
EXEC AppPlanSetEntityValueV2 @i_planId, 'SLA option exclusion delay interval', @delayInterval, @errorCode OUTPUT, @errorString OUTPUT
IF @errorCode = 0 AND @delayInterval IS NOT NULL
EXEC AppPlanSetEntityValueV2 @i_planId, 'SLA option excluded', @excludeSLA, @errorCode OUTPUT, @errorString OUTPUT
-- Add/Update SLA options ----------------------------------------------------------------------------------------------------------------------------------------------------
--	--Audit
DECLARE @opMsgId    INT = (609 | (CAST(POWER(2, 24) AS BIGINT) * 84)) -- 'Modify existing plan'
        DECLARE @opEvMsgId  INT -- dummy not used.
        DECLARE @paramMsgId INT = 0
        DECLARE @opId       INT = 0
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userId, 158, @i_planId, @opEvMsgId OUTPUT, @opId OUTPUT
		DECLARE @planName    NVARCHAR(255) = NULL
		SELECT  @planName = name FROM APP_Plan WITH (NOLOCK) WHERE id = @i_planId
SET @paramMsgId = (1491 | (CAST(POWER(2, 24) AS BIGINT) * 85))
                EXEC EvGuiAuditSetParamData @opId, @planName, 0
                EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
	IF @slaLevel IS NOT NULL
	BEGIN
SET @paramMsgId = (1795 | (CAST(POWER(2, 24) AS BIGINT) * 85))
        EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		IF (@slaLevel = 1 AND @excludeSLA <> 1)
		BEGIN
SET @paramMsgId = (1797 | (CAST(POWER(2, 24) AS BIGINT) * 85))
            EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		END
		IF (@slaLevel = 2 AND @excludeSLA <> 1)
		BEGIN
			IF (@slaDays IS NOT NULL AND @slaDays <> 0)
			BEGIN
SET @paramMsgId = (1796 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParamData @opId, @slaDays, 0
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
			END
		END
		IF (@excludeSLA = 1)
		BEGIN
SET @paramMsgId = (1792 | (CAST(POWER(2, 24) AS BIGINT) * 85))
            EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		END
	END
IF (@slaDescription IS NOT NULL AND @slaDescription <> '')
BEGIN
SET @paramMsgId = (1793 | (CAST(POWER(2, 24) AS BIGINT) * 85))
        EXEC EvGuiAuditSetParamData @opId, @slaDescription, 0
        EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
END
IF (@delayInterval IS NOT NULL AND @delayInterval <> 0)
BEGIN
	DECLARE @unixTime VARCHAR(32)
	SET @unixTime = CAST(dbo.UTCToClientLocalTime(dbo.getdatetime(@delayInterval),2)AS DATE)
SET @paramMsgId = (1794 | (CAST(POWER(2, 24) AS BIGINT) * 85))
    EXEC EvGuiAuditSetParamData @opId, @unixTime, 0
    EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
END
-- build output
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
END CATCH
--
ERROR_EXIT:
	IF @errorCode = 0 AND XACT_STATE() = 1
		COMMIT TRAN AppSLAOptionsSet_Tran
	ELSE
		ROLLBACK TRAN AppSLAOptionsSet_Tran
--
SET @x_xmlData =
    (
		SELECT
			@errorCode '@errorCode',
			@errorString '@errorMessage'
		FOR XML PATH('App_GenericResp')
    )
SELECT @x_xmlData AS x_xmlData
RETURN @errorCode;
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanSLAOptionsSetV2')
	delete from GxQscripts where name = 'AppPlanSLAOptionsSetV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanSLAOptionsSetV2')
	delete from GXDBVersions where aliasname = 'AppPlanSLAOptionsSetV2'
GO

insert into GXDBVersions values(2, 'AppPlanSLAOptionsSetV2',  '00010001000200060000', 'AppPlanSLAOptionsSetV2', '00010001000200060000')
GO

