

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanPrepareCSForACApp.sp] ---------- 

--  +======================================================================================+
--  |		 		 Name:  AppPlanPrepareCSForACApp()
--  | Description:  Configure CS generic settings based on the Plan type for ease of use
--  +======================================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanPrepareCSForACApp.sp,v $ $Id: AppPlanPrepareCSForACApp.sp,v 1.1.2.15 2020/06/30 10:28:15 jswaminathan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanPrepareCSForACApp')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanPrepareCSForACApp <<<'
	drop procedure AppPlanPrepareCSForACApp
END
IF EXISTS (select * from GxQscripts where name='AppPlanPrepareCSForACApp')
	delete from GxQscripts where name = 'AppPlanPrepareCSForACApp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanPrepareCSForACApp')
	delete from GXDBVersions where aliasname = 'AppPlanPrepareCSForACApp'
GO
print '... Creating Procedure: AppPlanPrepareCSForACApp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanPrepareCSForACApp
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_planId INTEGER,
  @i_planSubType INTEGER,
  @x_xmlData XML OUTPUT 
AS
SET NOCOUNT ON
BEGIN TRY
DECLARE @userHasCapability INT = 0
DECLARE @errorTable TABLE (errorCode INT, errorString NVARCHAR(MAX))
DECLARE @currentTime AS integer = dbo.GetUnixTime (GetUTCdate())
EXEC sec_checkPermissionOnEntity @i_userId, 156, @userHasCapability OUTPUT, 1, 2
IF (@userHasCapability <> 0)
BEGIN
    -- In case of first Laptop plan being created, we have to make CS Compliant for EndPoint APP
    DECLARE @FreshInstallSettingName NVARCHAR(255) = N'Set Default Plan Automatically'
    IF EXISTS  (SELECT TOP 1 * FROM	GXGlobalParam WHERE name=@FreshInstallSettingName AND value=N'1')
    BEGIN
	    -- In case of any plan being created, we just have to made the first one of that type to be the default plan for MSP\Comcell Admin
        -- Once default plan for that subtype is set, we have nothing to do here.
        DECLARE @orgId INT = dbo.AppGetOrganizationForUser(@i_userId)
        DECLARE @defaultPlanId INT
	    DECLARE @propName NVARCHAR(128) = (SELECT CASE @i_planSubType
WHEN 33554437 THEN 'Default Server Plan'
WHEN 33554439 THEN 'Default Laptop Plan'
WHEN 50331655 THEN 'Default File System Plan'
												    ELSE NULL
            									    END)
IF (@i_planSubType IN (33554437, 33554439, 50331655)) AND @propName IS NOT NULL
        BEGIN
            SELECT @defaultPlanId=attrValInt FROM App_CompanyProp WHERE componentNameId=@orgId AND
		        attrName = @propName
	        IF (((@defaultPlanId IS NULL) OR (@defaultPlanId = 0)) AND (EXISTS (SELECT TOP 1 * FROM APP_Plan WITH (NOLOCK) WHERE id=@i_planId AND flag=0)) OR
			    (EXISTS (SELECT TOP 1 * FROM APP_Plan WITH (NOLOCK) WHERE id=@defaultPlanId AND flag<>0)))	-- Remove old default plan if it is not enabled
	        BEGIN
			    DELETE FROM App_CompanyProp WHERE componentNameId=@orgId AND  attrName = @propName
		        INSERT INTO App_CompanyProp (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@orgId, @propName, 7, @i_planId , dbo.GetUnixTime(GETUTCDATE()), 0)
	        END
            -- audit operation -----------------------------------------------------------------------------------------------------------------------------------------------------
            DECLARE @planName  VARCHAR(510) = (SELECT name FROM APP_Plan WHERE id = @i_planId)
DECLARE @opMsgId   INT = (610 | (CAST(POWER(2, 24) AS BIGINT) * 84)) -- 'Setting default plan'
            DECLARE @opEvMsgId INT -- dummy not used.
            DECLARE @opId      INT = 0
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userId, 158, @i_planId, @opEvMsgId OUTPUT, @opId OUTPUT
DECLARE @paramMsgId INT = IIF(@i_planSubType = 33554437,   (1661 | (CAST(POWER(2, 24) AS BIGINT) * 85)),
IIF(@i_planSubType = 33554439,   (1660 | (CAST(POWER(2, 24) AS BIGINT) * 85)),
IIF(@i_planSubType = 50331655, (1659 | (CAST(POWER(2, 24) AS BIGINT) * 85)), (1637 | (CAST(POWER(2, 24) AS BIGINT) * 85)))))
            EXEC EvGuiAuditSetParamData @opId, @planName, 0
IF @paramMsgId = (1637 | (CAST(POWER(2, 24) AS BIGINT) * 85))
            BEGIN
                DECLARE @strPlanSubType VARCHAR(32) = CAST(@i_planSubType AS VARCHAR(32))
                EXEC EvGuiAuditSetParamData @opId, @strPlanSubType, 0
            END
            EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
            -- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------
        END
    END
    -- In case of first Laptop plan being created, we have to make CS Compliant for EndPoint APP
    DECLARE @PrepareCSForEndPointSettingName	NVARCHAR(255) = N'Prepare CS for EndPoint'
    -- API.X
    -- Laptop  = 33554439
IF (@i_planSubType = 33554439) AND (NOT EXISTS(SELECT TOP 1 * FROM	GXGlobalParam WHERE name=@PrepareCSForEndPointSettingName AND value=N'1'))
    BEGIN
        DECLARE @INSERT_PROP_RESULTS TABLE (
                                            errorCode           integer,
                                            hasChanged          integer,
                                            propId              integer,
                                            errorString         varchar(1024)
                                            )
        --Set lock down
        INSERT @INSERT_PROP_RESULTS
        EXEC  AppInsertGlobalParam
                    @isPIT = 1,
                    @createdTime = @currentTime,
                    @name = N'Secure Agent Install',
                    @newValue = N'1'
IF NOT EXISTS (SELECT 1 FROM UMGroups WITH (NOLOCK) WHERE name = 'Tenant Users' AND umdsProviderId = 0)
        BEGIN
            INSERT INTO UMGroups(groupFlags, allCapabilities, allAssociations, selfAssociation, name, description, origCCId, GUID, umdsProviderId, email, lastCredSetTime)
VALUES( 1,0,0,1,'Tenant Users', '', 2, NEWID(), 0, '', 0)
        END
        --Generate Download URL and add it to GxGlobalParam
        DECLARE @PackageUrlWin64 NVARCHAR(MAX) = 'https://cloud.commvault.com/edge/'
        DECLARE @PackageUrlWin32 NVARCHAR(MAX) = 'https://cloud.commvault.com/edge/'
        DECLARE @PackageUrlMac NVARCHAR(MAX) = 'https://cloud.commvault.com/edge/'
        DECLARE @releaseId INT = 11
        DECLARE @highestSP INT = 1
        DECLARE @minorSP   INT
        IF EXISTS(SELECT 1 FROM simAllGalaxyRel WHERE id = (SELECT releaseId FROM APP_Client WHERE id = 2))
        AND EXISTS(SELECT 1 FROM SimInstalledPackages WHERE ClientId = 2 AND simPackageID = 1)
        BEGIN
            SET @releaseId = (SELECT release FROM simAllGalaxyRel WHERE id = (SELECT releaseId FROM APP_Client WHERE id = 2))
            SET @highestSP = ISNULL((SELECT HighestSP FROM SimInstalledPackages WHERE ClientId = 2 AND simPackageID = 1), 1)
            SET @minorSP = ISNULL((SELECT SpMinorVersion FROM SimInstalledPackages WHERE ClientId = 2 AND simPackageID = 1), 0)
            SET @PackageUrlWin64 = @PackageUrlWin64 + CAST(@releaseId AS NVARCHAR(10)) + '/' + CAST(@highestSP AS NVARCHAR(10))
            SET @PackageUrlWin32 = @PackageUrlWin32 + CAST(@releaseId AS NVARCHAR(10)) + '/' + CAST(@highestSP AS NVARCHAR(10))
            SET @PackageUrlMac = @PackageUrlMac + CAST(@releaseId AS NVARCHAR(10)) + '/' + CAST(@highestSP AS NVARCHAR(10))
            IF @minorSP = 0
            BEGIN
                SET @PackageUrlWin64 = @PackageUrlWin64 + '/Edge_x64.exe'
                SET @PackageUrlWin32 = @PackageUrlWin32 + '/Edge_x86.exe'
                SET @PackageUrlMac = @PackageUrlMac + '/Edge_Mac.dmg'
            END
            ELSE
            BEGIN
                SET @PackageUrlWin64 = @PackageUrlWin64 + '/' + CAST(@minorSP AS NVARCHAR(10)) + '/Edge_x64.exe'
                SET @PackageUrlWin32 = @PackageUrlWin32 + '/' + CAST(@minorSP AS NVARCHAR(10)) + '/Edge_x86.exe'
                SET @PackageUrlMac = @PackageUrlMac + '/' + CAST(@minorSP AS NVARCHAR(10)) + '/Edge_Mac.dmg'
            END
        END
        ELSE
        BEGIN
            SET @PackageUrlWin64 = @PackageUrlWin64 + '11/1/Edge_x64.exe'
            SET @PackageUrlWin32 = @PackageUrlWin32 + '11/1/Edge_x86.exe'
            SET @PackageUrlMac = @PackageUrlMac + '11/1/Edge_Mac.dmg'
        END
        INSERT @INSERT_PROP_RESULTS
        EXEC  AppInsertGlobalParam
                    @isPIT = 0,
                    @createdTime = @currentTime,
                    @name = N'PackageUrlWin64',
                    @newValue = @PackageUrlWin64
        INSERT @INSERT_PROP_RESULTS
        EXEC  AppInsertGlobalParam
                    @isPIT = 0,
                    @createdTime = @currentTime,
                    @name = N'PackageUrlWin32',
                    @newValue = @PackageUrlWin32
        INSERT @INSERT_PROP_RESULTS
        EXEC  AppInsertGlobalParam
                    @isPIT = 0,
                    @createdTime = @currentTime,
                    @name = N'PackageUrlMac',
                    @newValue = @PackageUrlMac
        IF EXISTS (SELECT TOP 1 * FROM @INSERT_PROP_RESULTS WHERE errorCode = 0)
        BEGIN
            -- Update GxGlobalParam Table table , so that this code doesn't execute anymore'
            INSERT @INSERT_PROP_RESULTS
            EXEC  AppInsertGlobalParam
                        @isPIT = 1,
                        @createdTime = @currentTime,
                        @name = @PrepareCSForEndPointSettingName,
                        @newValue = N'1'
        END
    END
IF (@i_planSubType = 150994951)
	BEGIN
		-- Set retention at subclient policy to 0.
		-- Archival plan should always use retention from storage policy copy.
		DECLARE @_winSCPId INT = 0, @_unixSCPId INT = 0
		DECLARE @_extentionPropertyName NVARCHAR(128) = N'User deleted stubs expiration days'		/*CV_PROP_USER_DELETED_STUBS_EXPIRY*/		-- Macro does not have ''.
		DECLARE @_ArchivedExpirationDays  NVARCHAR(128) = N'Archived expiration days'
		DECLARE @_backupConfigurationNodes NVARCHAR(128) = N'Backup Configuration Nodes'			/*CV_PROP_BACKUP_CONFIG_NODES*/			-- This is a const string in C++.
		SELECT @_winSCPId = CAST(attrVal AS INT)
		FROM APP_PlanProp PP(NOLOCK)
		WHERE
			PP.componentNameId = @i_planId
AND PP.attrName = 'Subclient policy 2'
			AND PP.modified = 0
		SELECT @_unixSCPId = CAST(attrVal AS INT)
		FROM APP_PlanProp PP(NOLOCK)
		WHERE
			PP.componentNameId = @i_planId
AND PP.attrName = 'Subclient policy 3'
			AND PP.modified = 0
		UPDATE SCP
		SET attrVal = '0'
		FROM APP_SubclientProp SCP
			INNER JOIN APP_Application A
				ON SCP.componentNameId = A.id
				AND A.backupset IN (@_winSCPid, @_unixSCPid)
				AND SCP.attrName IN (@_extentionPropertyName, @_ArchivedExpirationDays)
				AND SCP.cs_attrName IN (CHECKSUM(@_extentionPropertyName), CHECKSUM(@_ArchivedExpirationDays))
				AND SCP.modified = 0
		-- We should not set any backup configuration nodes at archiver plan level. Sometimes C++ code sets it with empty XML string.
		-- Cannot skip it there, remove it here. (Setting modified <> 0 is enough).
		UPDATE SCP
		SET modified = @currentTime
		FROM APP_SubclientProp SCP
			INNER JOIN APP_Application A
				ON SCP.componentNameId = A.id
				AND A.backupset IN (@_winSCPid, @_unixSCPid)
				AND SCP.attrName = @_backupConfigurationNodes
				AND SCP.cs_attrName = (CHECKSUM(@_backupConfigurationNodes))
				AND SCP.modified = 0
	END
END
ELSE
BEGIN
    INSERT INTO @errorTable VALUES (5, 'Access denied. User has no plan creation capabilities.')
END
IF NOT EXISTS (SELECT TOP 1 errorCode FROM @errorTable where errorCode <> 0)
BEGIN
	INSERT INTO @errorTable VALUES (0, '')
END
-- build output
SET @x_xmlData =(SELECT
					(SELECT
						(SELECT 15 AS '@__type__'
								FOR XML PATH('entity'), TYPE),
						(SELECT ER.errorCode      AS '@errorCode',
								ER.errorString   AS '@errorString'
							FOR XML PATH('status'), TYPE)
						FROM @errorTable AS ER
						FOR XML PATH('error'), TYPE)
					FOR XML PATH('Api_PlanComponentErrorList')
				)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @x_xmlData =(SELECT
						(SELECT
							(SELECT 15 AS '@__type__'
									FOR XML PATH('entity'), TYPE),
							(SELECT ERROR_NUMBER()    AS '@errorCode',
									'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()   AS '@errorString'
								FOR XML PATH('status'), TYPE)
							FOR XML PATH('error'), TYPE)
						FOR XML PATH('Api_PlanComponentErrorList')
					)
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanPrepareCSForACApp')
	delete from GxQscripts where name = 'AppPlanPrepareCSForACApp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanPrepareCSForACApp')
	delete from GXDBVersions where aliasname = 'AppPlanPrepareCSForACApp'
GO

insert into GXDBVersions values(2, 'AppPlanPrepareCSForACApp',  '00010001000200150000', 'AppPlanPrepareCSForACApp', '00010001000200150000')
GO

