

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanPostInstallActions.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanPostInstallActions.sp,v $ $Id: AppPlanPostInstallActions.sp,v 1.1.4.22.4.1 2021/01/12 23:53:15 abilbrey Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppPlanPostInstallActions"
--	|	This Procedure will perform post install operation of associating company id to client, refreshing SCG group and then updating user credentials for proper rights management.
-- 	+-----------------------------------------------------------------------+
-- Procedure Name
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppPlanPostInstallActions')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanPostInstallActions <<<'
	drop procedure AppPlanPostInstallActions
END
IF EXISTS (select * from GxQscripts where name='AppPlanPostInstallActions')
	delete from GxQscripts where name = 'AppPlanPostInstallActions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanPostInstallActions')
	delete from GXDBVersions where aliasname = 'AppPlanPostInstallActions'
GO
print '... Creating Procedure: AppPlanPostInstallActions'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppPlanPostInstallActions
-- Input arguments
  @i_userId INT,
  @i_clientId INT,
  @i_xmlStr XML,
  @o_errorCode INT OUTPUT,
  @o_errorString VARCHAR(MAX) OUTPUT
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @errorCode INT
  DECLARE @errorString VARCHAR(MAX)
BEGIN
	DECLARE @workQOutPutTbl table (errCode INT,errString nvarchar(max))
    -- Flow as per discussion with Bhavyan
    -- Authcode will be point in time. If we get any other request, then we will update modified time of previous request and will keep new one.
    -- Installation user Id and Installation Company Id will be one time property set during fresh install. It won't be udpated.
    DECLARE @authCode VARCHAR(64)
    DECLARE @authCompanyID INTEGER
    DECLARE @providerId INTEGER
    DECLARE @nowTime INTEGER
    DECLARE @isValidAuthCode INTEGER = 0
    DECLARE @rcnt INTEGER
	DECLARE @workQueueParam NVARCHAR(MAX)
	SET @o_errorCode = 0
    SET @o_errorString = ''
    SET @nowTime =  dbo.GetUnixTime (GetUTCdate())
    SET @authCode = (SELECT  ref.value('@authCode', 'VARCHAR(64)') AS client
                              FROM    @i_xmlStr.nodes('Api_PostInstallClientProperties') R ( ref ))
    IF (@i_clientId <= 0)
    BEGIN
SET @o_errorCode = (1760 | (CAST(POWER(2, 24) AS BIGINT) * 62))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (1760 | (CAST(POWER(2, 24) AS BIGINT) * 62)) and localeid = 0)
    END
    ELSE
    BEGIN
		DECLARE @clientIsLatop TINYINT = 0
		SELECT
			@clientIsLatop = 1
		FROM App_Client WITH(NOLOCK)
		WHERE
(status & 0x1000) <> 0
			AND id = @i_clientId
        IF (@authCode IS NOT NULL)
        BEGIN
            -- First validate Auth code again here
            -- If valid one, then simply save it
            -- If not valid, still save it but also create property to suggest same is invalid auth code.
SELECT @authCompanyID=componentNameId FROM APP_CompanyProp WHERE attrname='Authorization Code' and attrVal=@authCode AND modified=0
            IF @authCompanyID IS NOT NULL AND (@authCompanyID >=0)
            BEGIN
                SET @isValidAuthCode = 1
                -- Provider Id and user id should now be refered from here
                SELECT @providerId=@authCompanyID
				DECLARE @excludeUserFlags INT = dbo.sec_getExcludeFlagsForUser()
				DECLARE @tenantAdminGroupId INT = 0
SELECT @tenantAdminGroupId=UG.id FROM UMGroups UG where UG.groupFlags&0x10000 <> 0 and UG.umdsProviderId=@providerId
                SET @i_userId = (SELECT TOP 1 UU.id FROM UMUsers UU
							INNER JOIN UMUserGroup UUG
							ON UUG.userId=UU.id
							WHERE UUG.groupId=@tenantAdminGroupId AND (UU.flags& @excludeUserFlags) = 0)
				IF( @i_userId IS NULL) --This happens when company is created without the tenant admin user
				BEGIN
					DECLARE @createAsUserID int =0
					EXEC sec_getCreateAsUserId 0,0 , @createAsUserID OUTPUT,0,0,@tenantAdminGroupId
					IF @createAsUserID > 0
					BEGIN
						SET @i_userId = @createAsUserID
					END
				END
            END
            UPDATE App_ClientProp SET modified = @nowTime
WHERE attrname = 'Authorization Code'
            AND componentNameId = @i_clientId AND modified=0
            INSERT INTO App_ClientProp VALUES
            --(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
(@i_clientId, 'Authorization Code', 1, @authCode, @nowTime, 0, 0)
            IF @isValidAuthCode <> 1
            BEGIN
                UPDATE App_ClientProp SET attrval = 1
WHERE attrname = 'Is Invalid Authorization Code'
                AND componentNameId = @i_clientId AND modified=0
                SET @rcnt = @@ROWCOUNT
                IF (@rcnt = 0)
	            BEGIN
                    INSERT INTO App_ClientProp VALUES
                    --(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
(@i_clientId, 'Is Invalid Authorization Code', 7, 1, @nowTime, 0, 0)
                END
            END
            ELSE
            BEGIN
DELETE App_ClientProp WHERE attrname = 'Is Invalid Authorization Code' AND componentNameId = @i_clientId
            END
        END
		IF @i_userId IS NULL OR @i_userId < 1
		BEGIN
			-- If client is installed in open CS and no authentication was passed, then assign this client to Admin
SET @i_userId= (SELECT TOP 1 id FROM UMUsers WHERE flags & 0x040 <> 0)
		END
IF NOT EXISTS (SELECT 1 FROM APP_ClientProp WHERE attrname='Installation Company ID' AND componentNameId=@i_clientId AND modified=0)
        BEGIN
            SET @providerId = (SELECT dbo.AppGetOrganizationForUser(@i_userId))
			DECLARE @clusterPhysicalClient INT = ISNULL((SELECT TOP 1 PMClientId FROM APP_VMToPMMap WHERE VMClientId=@i_clientId), 0)
			IF @clusterPhysicalClient > 0
			BEGIN
				-- In case of client being cluster client for physical client, get company id form physical client
SET @providerId = ISNULL((SELECT TOP 1 attrval FROM APP_ClientProp WHERE attrname='Installation Company ID' AND componentNameId=@clusterPhysicalClient AND modified=0), 0)
			END
DELETE FROM APP_ClientProp WHERE attrname='Installation User ID' AND componentNameId=@i_clientId
            INSERT INTO APP_ClientProp
VALUES (@i_clientId, 'Installation Company ID', 7, @providerId, @nowTime, 0, 0),
(@i_clientId, 'Installation User ID', 7, @i_userId, @nowTime, 0, 0)
EXEC sec_setCompanyIdForEntity 3, @i_clientId, @providerId
			-- Call code to setup Ediscovery for Company before processing company properties
			DECLARE @nClientId NVARCHAR(16) = CAST(@i_clientId AS NVARCHAR(16))
			EXEC dbo.AppSetEDiscoveryForCompany -1, @nClientId, '' , @o_errorCode OUTPUT, @o_errorString OUTPUT
			-- Do this only if client is not laptop. SCG Refresh will happen via AppSetSpecialClientStatesAsync during installation
			-- From SP13 , we will only refresh Company SCG. If we wait for AppSetSpecialClientStatesAsync, then company dashboard don't show correct value till all SCG's haven't been refreshed.
			DECLARE @companyScgId INTEGER = 0
			DECLARE @scgProcessed INT = 0
			IF @authCompanyID IS NULL or (@authCompanyID < 0)
			BEGIN
				set @authCompanyID = @providerId
			END
SELECT @companyScgId=attrValInt  FROM APP_CompanyProp WHERE attrname = 'Associated Smart Client Group' AND componentNameId = @authCompanyID AND modified=0
			IF (@companyScgId IS NOT NULL) AND (@companyScgId >0)
			BEGIN
				-- Refresh only Company SCG
				EXEC AppSCGUpdateClient 1, @i_clientId, @companyScgId
				SET @scgProcessed = 1
			END
			IF (@clientIsLatop = 0)
			BEGIN
				-- If SCG's for this client's haven't been processed
				IF @scgProcessed=0
				BEGIN
            		-- Update all applicable SCG for this client
					SET @workQueueParam = '<App_ProcessSCGUpdate><processinginstructioninfo><user userId="' + cast(@i_userId as nvarchar(max)) + '"/></processinginstructioninfo></App_ProcessSCGUpdate>'
					INSERT INTO @workQOutPutTbl
					EXEC AppWorkQueueSubmitRequest 29, 0, 0, @i_clientId, 0, @workQueueParam  -- WORK_TOKEN_SCG_UPDATE_CLIENT
				END
		        -- Call update User Credentials
				-- Improved Version to just update cache for the given client id
EXEC sec_populateCache_OneEntity @i_userId, 3, @i_clientId, 0,0,0,0,1
			END
        END
        ELSE
        BEGIN
            SET @o_errorCode = 0
            SET @o_errorString = 'Either Cluster client or property is already set. So, not setting company and user id'
        END
		-- Configure CCS Laptop
		IF (@clientIsLatop = 1)
		BEGIN
			-- Is CCS Functionality enabled on the CommServer?
			DECLARE @ccsEnabled INT = 0
			SELECT
				@ccsEnabled = CAST(value AS INT)
			FROM GXGlobalParam WITH(NOLOCK)
			WHERE
				name = 'CommServCCSEnabled'
			IF (@ccsEnabled = 1)
			BEGIN
				-- Is Cloud / CCS Laptop Client configuration meet
				IF EXISTS (
					SELECT 1
					FROM ClientsWithValidCCSCfgsView  WITH(NOLOCK)
					WHERE clientId = @i_clientId
						--GESP12Version >= 14
				)
				BEGIN
					DECLARE @disabled INT = 0
					SELECT TOP 1
						@disabled = 1
					FROM APP_AdvanceSettings a WITH(NOLOCK)
					WHERE
						a.entityId = @i_clientId
						AND a.entityType = 3	-- client
						AND a.keyName IN (N'DisableCCSDbMode', N'DisableCloudLaptopMode')
						AND a.enabled = 1
						AND a.deleted = 0
						AND CAST(a.value AS NVARCHAR(32)) = N'1'
					-- Perform CCS Configuration
					UPDATE APP_ClientProp
						SET attrval = CASE @disabled WHEN 1 THEN N'0' ELSE N'1' END
					WHERE attrname = N'CCS Enabled'
						AND componentNameId = @i_clientId
						AND modified = 0
					IF @@ROWCOUNT = 0
					BEGIN
						INSERT INTO App_ClientProp
							VALUES (@i_clientId, N'CCS Enabled', 2, (CASE @disabled WHEN 1 THEN N'0' ELSE N'1' END), @nowTime, 0, 0)
					END
					-- CCS Client Registry key
					UPDATE APP_AdvanceSettings
						SET value = (CASE @disabled WHEN 1 THEN N'DISABLED' ELSE N'LOAD' END),
							enabled = 1,
							deleted = 0
					WHERE
						entityType = 3      -- client
						AND entityId = @i_clientId
						AND keyName = N'sCCSDbStatus'
					IF @@ROWCOUNT = 0
					BEGIN
						DECLARE @ccsId INT
						INSERT INTO APP_AdvanceSettings (entityId, keyName, type, relativePath, value, enabled, deleted, entityType, sourceId, sourceEntityType)
							VALUES (@i_clientId, N'sCCSDbStatus', N'STRING', N'iDataAgent', (CASE @disabled WHEN 1 THEN N'DISABLED' ELSE N'LOAD' END), 1, 0, 3 /* client */, 0, 0)
						SET @ccsId = SCOPE_IDENTITY()
						INSERT INTO APP_AdvanceSettingsEx (keyId, details, hidden)
							VALUES (@ccsId, N'', 1)
					END
					-- Work Queue CCS Operations
					INSERT INTO APP_WorkQueueRequest(clientId, remoteClient, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag)
						VALUES (@i_clientId, -1, 6 /*WORK_TOKEN_REGISTRY*/, '', @nowTime, 0, 0, 0),
								(@i_clientId, -1, 49 /*WORK_TOKEN_CCS_DB_CHANGE_STATE*/, (CASE @disabled WHEN 1 THEN N'DISABLED' ELSE N'LOAD' END), @nowTime, 0, 0, 0)
				END
			END
		END
    END
    SET @errorCode = @o_errorCode
    SET @errorString = @o_errorString
	SELECT @errorCode, @errorString;
	return;
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanPostInstallActions')
	delete from GxQscripts where name = 'AppPlanPostInstallActions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanPostInstallActions')
	delete from GXDBVersions where aliasname = 'AppPlanPostInstallActions'
GO

insert into GXDBVersions values(2, 'AppPlanPostInstallActions',  'v1.1.4.22.4.1', 'AppPlanPostInstallActions', 'v1.1.4.22.4.1')
GO

