

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanMaintenanceV2.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanMaintenanceV2.sp,v $ $Id: AppPlanMaintenanceV2.sp,v 1.1.2.9 2019/07/10 10:31:05 njain Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppPlanMaintenanceV2   -
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanMaintenanceV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanMaintenanceV2 <<<'
	drop procedure AppPlanMaintenanceV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanMaintenanceV2')
	delete from GxQscripts where name = 'AppPlanMaintenanceV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanMaintenanceV2')
	delete from GXDBVersions where aliasname = 'AppPlanMaintenanceV2'
GO
print '... Creating Procedure: AppPlanMaintenanceV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanMaintenanceV2
  @x_xmlData XML OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF OBJECT_ID('tempdb.dbo.#AppPlanMaintenance_tmp__ExcludeEntites') IS NOT NULL DROP TABLE #AppPlanMaintenance_tmp__ExcludeEntites
CREATE TABLE #AppPlanMaintenance_tmp__ExcludeEntites(entityType INT, entityId INT)
CREATE UNIQUE INDEX AppPlanMaintenance_tmp__SkipEntites_entry ON #AppPlanMaintenance_tmp__ExcludeEntites(entityType, entityId )
IF OBJECT_ID('tempdb.dbo.#AppPlanMaintenance_tmp__ClearFlag') IS NOT NULL DROP TABLE #AppPlanMaintenance_tmp__ClearFlag
CREATE TABLE #AppPlanMaintenance_tmp__ClearFlag( __type__ INT PRIMARY KEY, affected INT)
    -- clean up plan association flags for entities which are not used by any plan anymore.
    -- -- flags cleanup should be in sync with flag setting in AppPlanSetEntityValueV2 stored procedure
	-- dummy changes for checkin
    BEGIN
    DECLARE @idsStr     VARCHAR(MAX)
    DECLARE @rowCount   INT
    BEGIN -- client groups
        -- create comma separated list of client group ids used by all plans
        SET @idsStr = NULL
        SET @rowCount = -0
SELECT @idsStr = COALESCE(@idsStr + ',', '') + attrVal FROM App_PlanProp WHERE attrName IN('Assigned client group')
        -- remove flag for entries which have it but are not in the list of plans used client groups
        IF @idsStr IS NOT NULL
        BEGIN
UPDATE  APP_ClientGroup SET flag &= ~(536870912)
WHERE       (flag & 536870912) != 0
                    AND CAST(id AS VARCHAR(20)) NOT IN (SELECT _ID FROM dbo.SplitIDString(@idsStr))
            SET @rowCount = @@ROWCOUNT
        END
        -- report number of affected records
INSERT INTO #AppPlanMaintenance_tmp__ClearFlag VALUES(2048, @rowCount)
    END
    BEGIN -- user groups
        -- create comma separated list of group ids used by all plans
        SET @idsStr = NULL
        SET @rowCount = 0
SELECT @idsStr = COALESCE(@idsStr + ',', '') + attrVal FROM App_PlanProp WHERE attrName IN('Assigned user group')
        -- remove flag for entries which have it but are not in the list of plans used user groups
        IF @idsStr IS NOT NULL
        BEGIN
UPDATE  UMGroups SET groupFlags &= ~(536870912)
WHERE       (groupFlags & 536870912) != 0
                    AND CAST(id AS VARCHAR(20)) NOT IN (SELECT _ID FROM dbo.SplitIDString(@idsStr))
            SET @rowCount = @@ROWCOUNT
        END
        -- report number of affected records
INSERT INTO #AppPlanMaintenance_tmp__ClearFlag VALUES(16, @rowCount)
    END
    BEGIN -- storage policies
        -- create comma separated list of storage policies used by all plans
        SET @idsStr = NULL
        SET @rowCount = 0
SELECT @idsStr = COALESCE(@idsStr + ',', '') + attrVal FROM App_PlanProp WHERE attrName IN('Storage policy', 'Log storage policy')
		SELECT @idsStr = COALESCE(@idsStr + ',', '') + CAST(storagePolicyId AS VARCHAR(100)) FROM App_PlanRule
        -- remove flag for entries which have it but are not in the list of plans used user groups
        IF @idsStr IS NOT NULL
        BEGIN
UPDATE  archGroup SET flags &= ~(536870912)
WHERE       (flags & 536870912) != 0
                    AND CAST(id AS VARCHAR(20)) NOT IN (SELECT _ID FROM dbo.SplitIDString(@idsStr))
            SET @rowCount = @@ROWCOUNT
        END
        -- report number of affected records
INSERT INTO #AppPlanMaintenance_tmp__ClearFlag VALUES(1, @rowCount)
    END
    BEGIN -- schedule policies and replication schedules
        -- create comma separated list of schedule policies and replication schedules used by all plans
        SET @idsStr = NULL
        SET @rowCount = 0
SELECT @idsStr = COALESCE(@idsStr + ',', '') + attrVal FROM App_PlanProp WHERE attrName IN('Schedule policy', 'Log schedule policy', 'Replication schedule policy', 'Index copy schedule policy' )
        -- remove flag for entries which have it but are not in the list of plans used schedules and schedule policies
        IF @idsStr IS NOT NULL
        BEGIN
UPDATE  TM_Task SET flags &= ~(536870912)
WHERE       (flags & 536870912) != 0
                    AND CAST(taskId AS VARCHAR(20)) NOT IN (SELECT _ID FROM dbo.SplitIDString(@idsStr))
            SET @rowCount = @@ROWCOUNT
        END
        -- report number of affected records
INSERT INTO #AppPlanMaintenance_tmp__ClearFlag VALUES(4, @rowCount)
    END
    BEGIN -- features and access policies
        -- create comma separated list of features and access policies used by all plans
        SET @idsStr = NULL
        SET @rowCount = 0
SELECT @idsStr = COALESCE(@idsStr + ',', '') + attrVal FROM App_PlanProp WHERE attrName IN('Feature', 'Access policy')
        -- remove flag for entries which have it but are not in the list of plans used roles
        IF @idsStr IS NOT NULL
        BEGIN
UPDATE  UMRoles SET flags &= ~(536870912)
WHERE       (flags & 536870912) != 0
                    AND CAST(id AS VARCHAR(20)) NOT IN (SELECT _ID FROM dbo.SplitIDString(@idsStr))
            SET @rowCount = @@ROWCOUNT
        END
        -- report number of affected records
INSERT INTO #AppPlanMaintenance_tmp__ClearFlag VALUES(8, @rowCount)
    END
    BEGIN -- configuration policies
        -- create comma separated list of all configuration policies used by all plans
        SET @idsStr = NULL
        SET @rowCount = 0
SELECT @idsStr = COALESCE(@idsStr + ',', '') + attrVal FROM App_PlanProp WHERE attrName IN('Exchange mailbox archiving policy', 'Exchange mailbox retention policy', 'Exchange mailbox cleanup policy', 'Exchange mailbox journal policy', 'Data classification policy', 'Content Indexing Policy')
        -- remove flag for entries which have it but are not in the list of plans used configuration policies
        IF @idsStr IS NOT NULL
        BEGIN
UPDATE  APP_ConfigurationPolicy SET flags &= ~(536870912)
WHERE       (flags & 536870912) != 0
                    AND CAST(policyId AS VARCHAR(20)) NOT IN (SELECT _ID FROM dbo.SplitIDString(@idsStr))
            SET @rowCount = @@ROWCOUNT
        END
        -- report number of affected records
INSERT INTO #AppPlanMaintenance_tmp__ClearFlag VALUES(65536, @rowCount)
    END
    BEGIN -- edge drive clients
        -- create comma separated list of all edge drives used by all plans
        SET @idsStr = NULL
        SET @rowCount = 0
SELECT @idsStr = COALESCE(@idsStr + ',', '') + attrVal FROM App_PlanProp WHERE attrName IN('Assgined Edge Drive')
        -- GDRP pseudo clients have edge drive flag set but should not be deleted
        INSERT INTO #AppPlanMaintenance_tmp__ExcludeEntites
SELECT  DISTINCT 3, componentNameId
            FROM    APP_ClientProp
            WHERE   attrName = 'System Drive Type' AND attrVal = '6' AND modified = 0
        -- delete from property table all entries that ties edge drive to a plan for those plans which do not exist any more
        IF @idsStr IS NOT NULL
        BEGIN
			IF OBJECT_ID('tempdb..#clients') IS NOT NULL DROP TABLE #clients
			CREATE TABLE #clients ( clientId INT PRIMARY KEY )
			INSERT INTO #clients (clientId)
			SELECT c.id
			FROM APP_Client c WITH(NOLOCK)
			WHERE
					c.id NOT IN (SELECT _ID FROM dbo.SplitIDString(@idsStr))
AND (c.status & 0x10000000) <> 0
AND c.id NOT IN (SELECT entityId FROM #AppPlanMaintenance_tmp__ExcludeEntites WHERE entityType = 3)
			IF OBJECT_ID('tempdb..#clientProps') IS NOT NULL DROP TABLE #clientProps
			CREATE TABLE #clientProps (cpId INT PRIMARY KEY)
			INSERT INTO #clientProps (cpId)
			SELECT cp.id
				FROM APP_ClientProp cp  WITH(NOLOCK)
					INNER JOIN #clients c WITH(NOLOCK) ON
						c.clientId = cp.componentNameId
AND cp.attrName = N'Associated Plan'
			DELETE cp
			FROM APP_ClientProp cp
				   INNER JOIN #clientProps d ON
						  d.cpId = cp.id
            SET @rowCount = @@ROWCOUNT
        END
        -- report number of affected records
INSERT INTO #AppPlanMaintenance_tmp__ClearFlag VALUES(4096, @rowCount)
    END
    END
    SET @x_xmlData =
    (
        SELECT
            (SELECT
                (SELECT CF.__type__ AS '@__type__'
                 FOR XML PATH('entity'), TYPE),
                (SELECT CF.affected AS '@errorCode',
                        'Total ' + CAST(CF.affected AS VARCHAR(32)) + ' entries updated.' AS '@errorMessage'
                 FOR XML PATH('status'), TYPE)
             FROM #AppPlanMaintenance_tmp__ClearFlag AS CF
             FOR XML PATH('error'), TYPE)
        FOR XML PATH('Api_PlanComponentErrorList')
    )
    SELECT @x_xmlData
IF OBJECT_ID('tempdb.dbo.#AppPlanMaintenance_tmp__ExcludeEntites') IS NOT NULL DROP TABLE #AppPlanMaintenance_tmp__ExcludeEntites
IF OBJECT_ID('tempdb.dbo.#AppPlanMaintenance_tmp__ClearFlag') IS NOT NULL DROP TABLE #AppPlanMaintenance_tmp__ClearFlag
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanMaintenanceV2')
	delete from GxQscripts where name = 'AppPlanMaintenanceV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanMaintenanceV2')
	delete from GXDBVersions where aliasname = 'AppPlanMaintenanceV2'
GO

insert into GXDBVersions values(2, 'AppPlanMaintenanceV2',  '00010001000200090000', 'AppPlanMaintenanceV2', '00010001000200090000')
GO

