

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanListFilters.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanListFilters.sp,v $ $Id: AppPlanListFilters.sp,v 1.1.2.11 2018/09/29 21:11:59 alakra Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppPlanListFilters   -
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppPlanListFilters <<<'

IF EXISTS (select * from sysobjects where name='AppPlanListFilters')
	drop procedure AppPlanListFilters
IF EXISTS (select * from GxQscripts where name='AppPlanListFilters')
	delete from GxQscripts where name = 'AppPlanListFilters'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanListFilters')
	delete from GXDBVersions where aliasname = 'AppPlanListFilters'
GO
print '... Creating Procedure: AppPlanListFilters'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanListFilters
  @i_userId INT,
  @i_localeId INT,
  @o_xmlText XML OUTPUT,
  @o_errCode INTEGER OUTPUT,
  @o_errString NVARCHAR(1024) OUTPUT
AS
  DECLARE @xmlText XML
  DECLARE @errCode INTEGER
  DECLARE @errString NVARCHAR(1024) 
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
DECLARE @i_SubClientId INT
DECLARE @i_BackupSetId INT
DECLARE @i_AppType INT
DECLARE @i_ClientId INT
DECLARE @arrayId INT = 0
DECLARE @siblingsSubClient INT = 0
DECLARE @clientStatus INT = 0
DECLARE @appTbl Table (appType INT)
SET @o_errCode = 0 -- Optimism
SET @o_errString = '' -- Optimism
DECLARE @FSClientAppType VARCHAR(256) = '11,33,34,42,43,19,20,17,18,21,29,38,36,63,64,74'    -- AppID for FS Plan. Hardcoding will be removed in SP6A
SET @i_SubClientId = ISNULL((
			SELECT ref.value('@subClientId', 'INT')
			FROM @o_xmlText.nodes('Api_GetEligiblePlanFilterReq') R(ref)
			), 0)
SET @i_BackupSetId = ISNULL((
			SELECT ref.value('@backupSetId', 'INT')
			FROM @o_xmlText.nodes('Api_GetEligiblePlanFilterReq') R(ref)
			), 0)
SET @i_AppType = ISNULL((
			SELECT ref.value('@appType', 'INT')
			FROM @o_xmlText.nodes('Api_GetEligiblePlanFilterReq') R(ref)
			), 0)
SET @i_ClientId = ISNULL((
			SELECT ref.value('@clientId', 'INT')
			FROM @o_xmlText.nodes('Api_GetEligiblePlanFilterReq') R(ref)
			), 0)
IF (@i_SubClientId <> 0)
BEGIN
    SELECT @i_AppType = AAP.appTypeId, @i_ClientId = AAP.clientId, @siblingsSubClient = COUNT(DISTINCT AAP1.id) FROM APP_Application AAP WITH (NOLOCK)
LEFT OUTER JOIN APP_Application AAP1 WITH(NOLOCK) ON AAP1.backupSet=AAP.backupSet AND (AAP1.subclientStatus&0x0200 = 0) AND (AAP1.subclientStatus&0x00004 = 0)  AND (AAP1.subclientStatus&0x00002 = 0)
	                                                                    WHERE AAP.id=@i_SubClientId
	                                                                    GROUP BY AAP.appTypeId, AAP.clientId
    INSERT INTO @appTbl
    SELECT @i_AppType
END
ELSE IF (@i_BackupSetId <> 0)
BEGIN
        SELECT @i_ClientId = AAP.clientId, @i_AppType = AAP.appTypeId , @siblingsSubClient = COUNT(DISTINCT AAP.id)
                                                                         FROM APP_Application AAP WITH(NOLOCK)
WHERE AAP.backupSet=@i_BackupSetId AND (AAP.subclientStatus&0x0200 = 0) AND (AAP.subclientStatus&0x00004 = 0)  AND (AAP.subclientStatus&0x00002 = 0)
                                                                                GROUP BY AAP.clientId, AAP.appTypeId
        INSERT INTO @appTbl
        SELECT @i_AppType
END
ELSE IF (@i_AppType <> 0)
BEGIN
    INSERT INTO @appTbl
    SELECT @i_AppType
END
ELSE IF (@i_ClientId <> 0)
BEGIN
    -- Here get all AppTypes For provided CLIENT ID
    INSERT INTO @appTbl
    SELECT DISTINCT AAP.appTypeId FROM APP_Application AAP WITH(NOLOCK) WHERE clientId=@i_ClientId
    -- For Applicable FS AppIDs Check if FS Plan is applicable
    -- At client level, we will always have FS plan applicable. Reason - If someone is requesting it here, it will be required for new backupset and it will always have single sinclge subclient by default
    -- Commenting it out, as it might help later for some other case.
--IF EXISTS (SELECT appTypeId, backupSet, COUNT(DISTINCT id) AS TotalCount from APP_Application WHERE clientId=@i_ClientId AND appTypeId IN (select _ID from dbo.SplitIDs(@FSClientAppType)) AND (subclientStatus&0x0200 = 0) AND (subclientStatus&0x00004 = 0)  AND (subclientStatus&0x00002 = 0)
    --            GROUP BY appTypeId,backupSet HAVING COUNT(DISTINCT id) > 1)
    --BEGIN
        -- -- Setting this value suffice our purpose. we don't care about actual count
        --SET @siblingsSubClient = 2
    --END
END
ELSE
BEGIN
SET @o_errCode = (7 | (CAST(POWER(2, 24) AS BIGINT) * 4))  -- Invalid combination of arguments.
SET @o_errString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (7 | (CAST(POWER(2, 24) AS BIGINT) * 4)) and localeid = @i_localeId)
    GOTO COMPLETE_EXIT
END
-- Check For Array ID on Client ID
SET  @arrayId = (SELECT TOP 1 _id FROM dbo.SplitIDs(ISNULL((SELECT TOP 1 ACPA.attrVal FROM APP_ClientProp ACPA WITH(NOLOCK)
		                                                                INNER JOIN APP_ClientProp ACPI WITH(NOLOCK)
			                                                                ON ACPI.componentNameId=ACPA.componentNameId
		                                                                WHERE ACPA.attrName='Arrays' AND ACPA.componentNameId=@i_ClientId AND ACPA.modified=0
				                                                                AND ACPI.attrName='Snap Backups Enabled' AND ACPI.attrVal=1 AND ACPI.modified=0), N'0')))
-- Check if a client is a laptop client
SELECT @clientStatus = status FROM APP_Client WITH(NOLOCK) WHERE id=@i_ClientId
-- Formulate Result Set
COMPLETE_EXIT:
IF (0 = @o_errCode)
BEGIN
SET @o_xmlText = (SELECT @arrayId AS '@arrayId', @clientStatus AS '@clientStatus', CASE
                                                        WHEN (@siblingsSubClient > 1) THEN 1    -- Multiple Subclient Present. No FS Plan
                                                        ELSE 0                                  -- Only Single Applicable Subclients. FS Plan will be allowed
                                                        END AS'@isMutlipleSubclientsSiblingsPresent',
			(SELECT
                    appType AS '@val'
				    FROM @appTbl
			FOR XML PATH('appTypes'), TYPE),
			(SELECT @o_errCode AS '@o_errCode', @o_errString AS '@errorMessage'  FOR XML PATH('error'),TYPE)
		FOR XML PATH('Api_GetEligiblePlanFilterResp'),TYPE)
END
ELSE
BEGIN
    SET @o_xmlText = (SELECT @o_errCode AS '@errorCode', @o_errString AS '@errorMessage' FOR XML PATH ('error'), ROOT('Api_GetEligiblePlanFilterResp'))
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @o_errCode = ERROR_NUMBER()
    set @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @o_xmlText = (SELECT @o_errCode AS '@errorCode', @o_errString AS '@errorMessage' FOR XML PATH ('error'), ROOT('Api_GetEligiblePlanFilterResp'))
END CATCH
SET @xmlText             = @o_xmlText
SET @errCode             = @o_errCode
SET @errString           = @o_errString
SELECT @xmlText, @errCode, @errString
SCRIPT_EXIT:
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanListFilters')
	delete from GxQscripts where name = 'AppPlanListFilters'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanListFilters')
	delete from GXDBVersions where aliasname = 'AppPlanListFilters'
GO

insert into GXDBVersions values(2, 'AppPlanListFilters',  '00010001000200110000', 'AppPlanListFilters', '00010001000200110000')
GO

