

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanGetUsersAssociated.sp] ---------- 

--  +=====================================================================================================================+
--  |		 		 Name:  AppPlanGetUsersAssociated()
--  | Description:  Allows to GET Users count for all plan that user have some sort of right on.
--  +=====================================================================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanGetUsersAssociated.sp,v $ $Id: AppPlanGetUsersAssociated.sp,v 1.1.2.5 2018/03/27 08:48:41 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppPlanGetUsersAssociated <<<'

IF EXISTS (select * from sysobjects where name='AppPlanGetUsersAssociated')
	drop procedure AppPlanGetUsersAssociated
IF EXISTS (select * from GxQscripts where name='AppPlanGetUsersAssociated')
	delete from GxQscripts where name = 'AppPlanGetUsersAssociated'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetUsersAssociated')
	delete from GXDBVersions where aliasname = 'AppPlanGetUsersAssociated'
GO
print '... Creating Procedure: AppPlanGetUsersAssociated'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanGetUsersAssociated
  @i_userId INTEGER,
  @o_usersCount INTEGER	OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
BEGIN TRY
--Get the list of plan ids which are visible to user
if object_id('tempdb.dbo.#planList') is not null
BEGIN
	DROP TABLE #planList
end
CREATE TABLE #planList (planId integer NOT NULL)
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 31, '#planList'
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 159, '#planList'
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 158, '#planList'
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 157, '#planList'
-- Get the count
SET @o_usersCount  = (SELECT COUNT(DISTINCT id) FROM UMUsersProp WHERE attrName = 'Assigned user group' AND modified = 0 AND attrVal in (SELECT DISTINCT planId FROM #planList))
if object_id('tempdb.dbo.#planList') is not null
BEGIN
	DROP TABLE #planList
end
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_usersCount = 0
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanGetUsersAssociated')
	delete from GxQscripts where name = 'AppPlanGetUsersAssociated'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetUsersAssociated')
	delete from GXDBVersions where aliasname = 'AppPlanGetUsersAssociated'
GO

insert into GXDBVersions values(2, 'AppPlanGetUsersAssociated',  '00010001000200050000', 'AppPlanGetUsersAssociated', '00010001000200050000')
GO

