

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanGetSummaryListV2.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanGetSummaryListV2.sp,v $ $Id: AppPlanGetSummaryListV2.sp,v 1.1.2.44.4.1 2021/01/26 01:59:15 nshah Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppPlanGetSummaryList   - get list of available profiles
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppPlanGetSummaryListV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanGetSummaryListV2 <<<'
	drop procedure AppPlanGetSummaryListV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanGetSummaryListV2')
	delete from GxQscripts where name = 'AppPlanGetSummaryListV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetSummaryListV2')
	delete from GXDBVersions where aliasname = 'AppPlanGetSummaryListV2'
GO
print '... Creating Procedure: AppPlanGetSummaryListV2'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppPlanGetSummaryListV2
  @i_planType INT,
  @i_planSubtype INT,
  @i_userId INT,
  @i_owner INT,
  @i_includeComplete INT = 1,
  @i_includeIncomplete INT = 1,
  @i_includeDeleted INT = 0,
  @i_forUser INT = 0,
  @i_forGroup INT = 0,
  @i_forCompany INT = -1,
  @o_xmlText XML OUTPUT,
  @i_localeId INT = 0,
  @i_planIds VARCHAR(MAX) = ''
AS
  DECLARE @xmlText XML
  DECLARE @isO365App INT = NULL /*Setting NULL makes sure that the O365 filtering added for metallic is NOT honoured*/
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @debug INT = 0
DECLARE @isCommCellAdmin INT = 0
-- adjust plan owners for those plans for which owner was deleted from the system.
-- just make admin user new owner of such plans
DECLARE @adminUser INT = ISNULL((SELECT TOP 1 UG.userId
                          FROM UMUserGroup UG INNER JOIN UMGroups G ON G.id = UG.groupId
							                  INNER JOIN UMUsers  U ON U.id = UG.groupId AND G.allAssociations = 1 AND G.allCapabilities = 1 AND G.selfAssociation = 1 AND U.enabled = 1), 0)
UPDATE App_Plan SET ownerId  = @adminUser
WHERE  (ownerId != @adminUser) AND (ownerId IN (SELECT id FROM UMUsers WHERE flags = 0 AND [login] LIKE '%deleted%'))
-- find out for which user plan list should be created
IF (ISNULL(@i_forUser, 0) != 0) OR (ISNULL(@i_forGroup, 0) != 0)  BEGIN
    -- get company to which user or user group belongs
    DECLARE @ownerCompany INT = dbo.AppGetCompanyForUserOrUserGroup(IIF(@i_forUser != 0, @i_forUser, @i_forGroup), IIF(@i_forUser != 0, 1, 0))
    IF ISNULL(@ownerCompany, 0) != 0 BEGIN
        -- get company's admin group
DECLARE @tenantAdminGroupId INT = (SELECT UG.id FROM UMGroups UG where UG.groupFlags & 0x10000 <> 0 AND UG.umdsProviderId = @ownerCompany)
        IF ISNULL(@tenantAdminGroupId, 0) != 0 BEGIN
            -- get tenant admin id
            DECLARE @tenantAdminId INT = ISNULL((SELECT TOP 1 userId FROM UMUserGroup WHERE groupId = @tenantAdminGroupId),0)
            -- impersonate user
            SET @i_userId = IIF(ISNULL(@tenantAdminId, 0) = 0, @i_userId, @tenantAdminId);
        END
    END
END
-- get the list of plan ids which are visible to the user
IF OBJECT_ID('tempdb.dbo.#OutputPlans') IS NOT NULL DROP TABLE #OutputPlans
IF OBJECT_ID('tempdb.dbo.#PlansList')   IS NOT NULL DROP TABLE #PlansList
IF OBJECT_ID('tempdb.dbo.#PlanTempInfo') IS NOT NULL DROP TABLE #PlanTempInfo
IF OBJECT_ID('tempdb.dbo.#userClients')					IS NOT NULL DROP TABLE #userClients
IF OBJECT_ID('tempdb.dbo.#usersSec_getUsersNewTbl')     IS NOT NULL DROP TABLE #usersSec_getUsersNewTbl
IF OBJECT_ID('tempdb.dbo.#usergroupsSec_getUsersNewTbl')IS NOT NULL DROP TABLE #usergroupsSec_getUsersNewTbl
IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_InputTable') IS NOT NULL DROP TABLE #getPermissionsOnEntities_InputTable
IF OBJECT_ID('tempdb.dbo.#PlanStoragePolicy')IS NOT NULL DROP TABLE #PlanStoragePolicy
IF OBJECT_ID('tempdb.dbo.#AssociatedCompanies') IS NOT NULL DROP TABLE #AssociatedCompanies
CREATE TABLE #AssociatedCompanies(planId INT, companyId INT DEFAULT 0)
IF OBJECT_ID('tempdb.dbo.#archivalRulesForPlan') IS NOT NULL DROP TABLE #archivalRulesForPlan
CREATE TABLE #archivalRulesForPlan
(
    planId INT NOT NULL,
    subclientId INT NOT NULL,
    fileModifiedTimeOlderThan INT,
    fileAccessTimeOlderThan INT,
    fileSizeGreaterThan INT
)
CREATE UNIQUE CLUSTERED INDEX archivalRulesForPlan_planId_subclientId_Idx on #archivalRulesForPlan (planId, subclientId)
CREATE TABLE #getPermissionsOnEntities_InputTable
(
	entityId1 INT,
	entityId2 INT DEFAULT 0,
	entityId3 INT DEFAULT 0,
	entityId4 INT DEFAULT 0,
	entityId5 INT DEFAULT 0,
	planId	  INT DEFAULT 0,
	planSubtype	  INT DEFAULT 0,
	planParentEntityType INT DEFAULT NULL,
	planParentEntityID INT DEFAULT NULL
)
IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_OutputTable') IS NOT NULL
	DROP TABLE #getPermissionsOnEntities_OutputTable
CREATE TABLE #getPermissionsOnEntities_OutputTable
(
	entityId1 INT,
	entityId2 INT,
	entityId3 INT,
	entityId4 INT,
	entityId5 INT,
	permissionsString VARCHAR(512),
	isChildRow BIT DEFAULT 0
)
CREATE TABLE #userClients					(t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT)
CREATE TABLE #usergroupsSec_getUsersNewTbl  (userGroupId INT PRIMARY KEY)
CREATE TABLE #usersSec_getUsersNewTbl       (userId INT PRIMARY KEY)
CREATE TABLE #OutputPlans(planId INT NOT NULL, permission int)
CREATE CLUSTERED INDEX OutputPlans_planId_permission_idx ON #OutputPlans(planId, permission)
CREATE TABLE #PlansList(planId INT NOT NULL)
CREATE CLUSTERED INDEX PlansList_planId_idx ON #PlansList(planId)
--Table will contain temp fields used to send in plan summary
CREATE TABLE #PlanTempInfo(planId INT NOT NULL, planType int ,numAssocEntities INT DEFAULT 0, numCopies INT, rpoInMinutes INT, primaryStorageType NVARCHAR(128) DEFAULT NULL, secondaryStorageType NVARCHAR(128) DEFAULT NULL,planSummary NVARCHAR(MAX))
CREATE CLUSTERED INDEX PlanTempInfo_planId_idx ON #PlanTempInfo(planId)
-- table that contains effective (with respect to inheritance) storage policy for each plan
CREATE TABLE #PlanStoragePolicy (planId INT PRIMARY KEY, storagePolicyId INT, primaryStorageType NVARCHAR(1024) DEFAULT NULL, secondaryStorageType NVARCHAR(128) DEFAULT NULL)
-- temperary table to store requested planIds if exists
DECLARE @tempPlanIdsList TABLE (planId INT NOT NULL PRIMARY KEY);
IF @i_planIds != ''
BEGIN
	-- Insert only valid ids into @tempPlanIdsList
	IF(@i_includeDeleted!=0)
	    INSERT INTO @tempPlanIdsList
		SELECT _ID FROM dbo.SplitIDs(@i_planIds) PI
		INNER JOIN App_Plan as AP ON PI._ID = AP.id
	ELSE
	    INSERT INTO @tempPlanIdsList
	    SELECT _ID FROM dbo.SplitIDs(@i_planIds) PI
		INNER JOIN App_Plan as AP on PI._ID = AP.id
WHERE (flag & 0x40000000) = 0 AND (flag & 0x00004) = 0
	-- If @tempPlanIdsList is empty after removing invalid ids, just exit
	IF NOT EXISTS (SELECT TOP 1 1 FROM @tempPlanIdsList)
	BEGIN
	    GOTO ERROR_EXIT
	END
END
DECLARE @isAdminUserId INT = ISNULL((SELECT 1 FROM UMUsers WHERE (id=@i_userId) AND (flags & 0x040 <> 0)) , 0)
IF(@isAdminUserId = 0) --Non-ADMIN user
BEGIN
    -- -- plans visible to the user
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 31, '#PlansList'
    INSERT INTO #OutputPlans
SELECT planId, 31 FROM #PlansList
    TRUNCATE TABLE #PlansList
    -- -- plans that user has rights to associate/deassociate
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 159, '#PlansList'
    INSERT INTO #OutputPlans
SELECT planId, 159 FROM #PlansList
    TRUNCATE TABLE #PlansList
    -- -- plans that user has rights to delete
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 158, '#PlansList'
    INSERT INTO #OutputPlans
SELECT planId, 158 FROM #PlansList
    TRUNCATE TABLE #PlansList
    -- -- plans that user has rights to edit
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 157, '#PlansList'
    INSERT INTO #OutputPlans
SELECT planId, 157 FROM #PlansList
    TRUNCATE TABLE #PlansList
    -- -- deleted plans if requested
    IF @i_includeDeleted != 0 BEGIN
        DECLARE @deletedPlanId INT = (SELECT MIN(id) FROM APP_Plan WHERE  (flag & 0x40000000) != 0)
        WHILE @deletedPlanId IS NOT NULL BEGIN
            DECLARE @userHasPermission INT = 0
EXEC sec_checkPermissionOnEntity @i_userId, 31, @userHasPermission OUTPUT,  158, @deletedPlanId
IF (@userHasPermission != 0) AND (NOT EXISTS (SELECT 1 FROM #OutputPlans WHERE planId = @deletedPlanId AND permission = 31))
INSERT INTO #OutputPlans VALUES(@deletedPlanId, 31)
EXEC sec_checkPermissionOnEntity @i_userId, 159, @userHasPermission OUTPUT,  158, @deletedPlanId
IF (@userHasPermission != 0) AND (NOT EXISTS (SELECT 1 FROM #OutputPlans WHERE planId = @deletedPlanId AND permission = 159))
INSERT INTO #OutputPlans VALUES(@deletedPlanId, 159)
EXEC sec_checkPermissionOnEntity @i_userId, 156, @userHasPermission OUTPUT, 158, @deletedPlanId
IF (@userHasPermission != 0) AND (NOT EXISTS (SELECT 1 FROM #OutputPlans WHERE planId = @deletedPlanId AND permission = 156))
INSERT INTO #OutputPlans VALUES(@deletedPlanId, 156)
EXEC sec_checkPermissionOnEntity @i_userId, 157, @userHasPermission OUTPUT, 158, @deletedPlanId
IF (@userHasPermission != 0) AND (NOT EXISTS (SELECT 1 FROM #OutputPlans WHERE planId = @deletedPlanId AND permission = 157))
INSERT INTO #OutputPlans VALUES(@deletedPlanId, 157)
EXEC sec_checkPermissionOnEntity @i_userId, 158, @userHasPermission OUTPUT, 158, @deletedPlanId
IF (@userHasPermission != 0) AND (NOT EXISTS (SELECT 1 FROM #OutputPlans WHERE planId = @deletedPlanId AND permission = 158))
INSERT INTO #OutputPlans VALUES(@deletedPlanId, 158)
            -- next iteration
            SET @deletedPlanId = (SELECT MIN(id) FROM APP_Plan WHERE  (flag & 0x40000000) != 0 AND id > @deletedPlanId)
        END
    END
    ELSE -- -- in some cases #OutputPlans contains plans scheduled for deletion :
         -- -- -- Jagadeesh Kallidaikurichi Swaminathan <jswaminathan@commvault.com> :
         -- -- -- -- if user has direct association for a plan in UMSecurityAssociations table plan will be fetched irrespective of filter defined in Plan_Entity table.
         -- -- -- -- caller code needs to filter out the unneeded data.
    BEGIN
	    DELETE  FROM #OutputPlans
WHERE   planId IN (SELECT id FROM APP_Plan WHERE (flag & 0x40000000) != 0 OR (flag & 0x00004) != 0)
    END
	-- -- If caller explicitly provided planIds, only retain those that were provided in the list
	IF EXISTS (SELECT TOP 1 1 FROM @tempPlanIdsList)
	BEGIN
	    DELETE OP FROM #OutputPlans as OP
		LEFT OUTER JOIN @tempPlanIdsList as PL ON OP.planId = PL.planId
		where PL.planId is null
	END
	-- -- add 'view' capability for plans wherever needed.
	INSERT INTO #OutputPlans
SELECT planId, 31
    FROM   (SELECT DISTINCT planId FROM #OutputPlans
	        EXCEPT
SELECT DISTINCT planId FROM #OutputPlans WHERE permission != 31) T
END
ELSE -- ADMIN USER
BEGIN
    --If the caller explicitly provided planIds, blindly insert into #OutputPlans with all applicable permissions as its admin user
	--else dump all applicable planIds from App_Plan into @tempPlanIdsList
	IF NOT EXISTS (SELECT TOP 1 1 FROM @tempPlanIdsList)
	BEGIN
	    IF(@i_includeDeleted!=0) --if caller asked for Deleted plans dump all ids of App_Plan into @tempPlanIdsList
	        INSERT INTO @tempPlanIdsList SELECT id FROM App_Plan
		ELSE --else dump all non deleted/scheduled to delete plans of App_Plan into @tempPlanIdsList
		    INSERT INTO @tempPlanIdsList SELECT id FROM App_Plan
Where (flag & 0x40000000) = 0 AND (flag & 0x00004) = 0
    END
	INSERT INTO #OutputPlans
SELECT planID, 31 FROM @tempPlanIdsList
UNION SELECT planID, 159 FROM @tempPlanIdsList
UNION SELECT planId, 158 FROM @tempPlanIdsList
UNION SELECT planId, 157 FROM @tempPlanIdsList
	--give deleted plans CAT_PLAN_CREATE Permission
	IF(@i_includeDeleted !=0)
INSERT INTO #OutputPlans SELECT planId, 156 FROM  @tempPlanIdsList as PL
		JOIN App_Plan as AP ON PL.planId = AP.id
WHERE (AP.flag & 0x00004) != 0
END
IF @debug != 0 SELECT 'available plan', * FROM #OutputPlans
-- filter it out
-- -- leave plans of the requested types
IF (@i_planType != 0) OR (@i_planSubtype != 0) BEGIN
    DELETE #OutputPlans
    FROM   #OutputPlans OP INNER JOIN APP_Plan P ON P.id = OP.planId
    WHERE       ((P.type != @i_planType)       AND (@i_planType     != 0))
            OR  ((P.subType != @i_planSubtype) AND (@i_planSubtype  != 0))
    IF @debug != 0 SELECT 'filtered by type', * FROM #OutputPlans
END
-- -- leave plans where owner == @i_owner having @i_owner is provided
IF ISNULL(@i_owner, 0) != 0 BEGIN
    DELETE #OutputPlans
    FROM   #OutputPlans OP INNER JOIN APP_Plan P WITH (NOLOCK) ON P.id = OP.planId
    WHERE  P.ownerId != @i_userId
    IF @debug != 0 SELECT 'filtered by owner', * FROM #OutputPlans
END
-- 0 is a valid company id. So, our default value will be -1
-- Logic is -
--	--	Get Plan for any company provided(means plan owner is part of that company) along with all plan for company 0
--	--	Above statement will be executed on top of currently fetched plans. So, we are not going to breach any security constraint
IF ISNULL(@i_forCompany, -1) != -1
BEGIN
    DELETE #OutputPlans
    FROM   #OutputPlans OP
	INNER JOIN APP_Plan P ON P.id = OP.planId
		WHERE  dbo.AppGetOrganizationForUser(P.ownerId) NOT IN (0 /*Commcell company Id*/, @i_forCompany)
	IF @debug != 0 SELECT 'filtered by company', * FROM #OutputPlans
END
-- -- leave plans with specified flags only.
IF @i_includeComplete = 0
    DELETE #OutputPlans
    FROM   #OutputPlans OP INNER JOIN APP_Plan P WITH (NOLOCK) ON P.id = OP.planId
    WHERE  P.flag = 0
IF @i_includeIncomplete = 0
    DELETE #OutputPlans
    FROM   #OutputPlans OP INNER JOIN APP_Plan P WITH (NOLOCK) ON P.id = OP.planId
    WHERE  P.flag = 2
-- leave plans which have status set to hidden (CV_STATUS_HIDDEN)
DELETE #OutputPlans
FROM #OutputPlans OP INNER JOIN APP_Plan P WITH(NOLOCK) ON P.id = OP.planId
WHERE (P.flag & 0x00020) = 0x00020
--Generate Temporary information before populating XML
INSERT INTO #getPermissionsOnEntities_InputTable (entityId1, entityId2, entityId3, entityId4, entityId5,planId)
    SELECT  A.clientId, A.appTypeId, A.instance, A.backupSet,A.id,OP.planId
    FROM    APP_Application  A WITH(NOLOCK)
		INNER JOIN  APP_SubclientProp SP WITH(NOLOCK) ON A.id = SP.componentNameId
AND (SP.cs_attrName IN (CHECKSUM(N'Associated Plan'),CHECKSUM(N'Associated DC Plan')))
AND SP.attrName IN ('Associated Plan', 'Associated DC Plan')
                                                                                             AND SP.modified = 0
        INNER JOIN  #OutputPlans OP ON CAST (OP.planId AS NVARCHAR(32)) = SP.attrVal
WHERE	A.subclientStatus & (CAST(0x00004 AS INT) | CAST(0x00002 AS INT) ) = 0
    UNION
    SELECT CP.componentNameId,0,0,0,0,OP.planId
        FROM APP_CLIENT C INNER JOIN APP_ClientProp CP WITH(NOLOCK) ON C.id = CP.componentNameId
AND (CP.attrName = 'Associated Plan' OR CP.attrName LIKE 'Default % Plan' OR CP.attrName = 'Associated DC Plan' )
                                                                       AND CP.modified = 0
AND C.status & (CAST(0x00004 AS INT) | CAST(0x00002 AS INT)) = 0
                INNER JOIN  #OutputPlans OP ON CAST (OP.planId AS NVARCHAR(32)) = CP.attrVal
	UNION
	SELECT DISTINCT A.clientId, A.appTypeId, A.instance, A.backupSet,0, planId
FROM APP_Application A WITH(NOLOCK) INNER JOIN APP_BackupSetProp SP WITH(NOLOCK) ON A.backupSet = SP.componentNameId AND SP.attrName = 'Associated Plan' AND SP.modified = 0
    INNER JOIN  #OutputPlans OP ON CAST (OP.planId AS NVARCHAR(32)) = SP.attrVal
	INNER JOIN APP_Plan APP  WITH(NOLOCK) ON APP.id=OP.planId
	WHERE A.appTypeId!=1030
	UNION
	SELECT DISTINCT A.clientId, A.appTypeId, A.instance, 0,0, planId
FROM APP_Application A WITH(NOLOCK) INNER JOIN APP_InstanceProp SP WITH(NOLOCK) ON A.instance = SP.componentNameId AND SP.attrName = 'Associated Plan' AND SP.modified = 0
    INNER JOIN  #OutputPlans OP ON CAST (OP.planId AS NVARCHAR(32)) = SP.attrVal
	WHERE A.appTypeId!=1030
	UNION --for exchange plan
	SELECT e.clientId, 0, 0, 0, 0, e.planId
		FROM APP_EmailConfigPolicyAssoc e
	INNER JOIN  #OutputPlans OP ON OP.planId  = e.planId
	WHERE e.modified=0
	UPDATE i SET planSubtype=p.subtype
	FROM #getPermissionsOnEntities_InputTable  i
	INNER JOIN app_plan p ON p.id = i.planId
EXEC sec_checkPermissionOnEntity @i_userId, 1, @isCommCellAdmin OUT, 1, 2
IF(@isCommCellAdmin != 1)
BEGIN
EXEC sec_getPermissionsOnEntities @i_userId, 7  /* 7 (7) */
	-- have to delete the entities which user has no permission on as above sp doesn't remove entities that user doesn't have rights on
	DELETE FROM #getPermissionsOnEntities_OutputTable
	WHERE (SUBSTRING(permissionsString,1,1) != CAST(1 AS NVARCHAR(1)))
END
EXEC sec_getIdaObjectsForUser @i_userId, 3 /*CLIENT_ENTITY*/ , 0, 0, '#userClients'
-- prepare
INSERT INTO #PlanStoragePolicy(planId, storagePolicyId)
SELECT P.id,
        (CASE
                WHEN SR.storageRules IS NOT NULL AND DATALENGTH(SR.storageRules) > 5 THEN
                        ISNULL(SR.storageRules.value('(/Api_PlanRuleMaps/rules[@rank=1]/policy/@storagePolicyId)[1]', 'int'), dbo.AppPlanGetEntityValueV2(P.id, 'Storage policy', default))
                ELSE dbo.AppPlanGetEntityValueV2(P.id, 'Storage policy', default)
        END)
        FROM APP_Plan P  WITH(NOLOCK) INNER JOIN (SELECT DISTINCT planId FROM #OutputPlans) PL ON P.id = PL.planId
        OUTER APPLY (SELECT (CAST(dbo.AppPlanGetEntityValueV2(P.id, 'Storage Rules', default) AS XML)) AS storageRules) AS SR
--
--O365 RELATED HANDLING FOR METALLIC
IF @isO365App = 1
BEGIN
	DELETE FROM #PlanStoragePolicy WHERE planId NOT IN
		(SELECT P.planId
			FROM #PlanStoragePolicy P
			INNER JOIN archGroup AG ON AG.id = P.storagePolicyId
			INNER JOIN ArchCopyToGlobalPolicy DC2GC ON AG.defaultCopy = DC2GC.copyId
			INNER JOIN MMEntityProp EP ON EP.EntityType=1 AND EP.EntityId = DC2GC.globalPolicyId
			WHERE EP.intVal=2 /*This property tells if the storage pool is created for O365*/
		)
END
ELSE IF @isO365App = 0
BEGIN
	DELETE FROM #PlanStoragePolicy WHERE planId IN
		(SELECT P.planId
			FROM #PlanStoragePolicy P
			INNER JOIN archGroup AG ON AG.id = P.storagePolicyId
			INNER JOIN ArchCopyToGlobalPolicy DC2GC ON AG.defaultCopy = DC2GC.copyId
			INNER JOIN MMEntityProp EP ON EP.EntityType=1 AND EP.EntityId = DC2GC.globalPolicyId
			WHERE EP.intVal IN (2, 3) /*This property tells if the storage pool is created for O365=2, Laptop=3*/
		)
END
--
--
UPDATE PT
	SET PT.primaryStorageType = (CASE
                WHEN L.LibraryTypeId <> 3 THEN 'Tape'
                WHEN EXISTS(SELECT 1 FROM MMMountPath MP WHERE MP.LibraryId = L.LibraryId AND MP.MountPathTypeId = 7) THEN 'Cloud'
                WHEN EXISTS(SELECT 1 FROM MMSDSStoragePool S WHERE S.LibraryId = L.LibraryId) THEN 'HyperScale'
                ELSE 'Disk'
            END)
FROM #PlanStoragePolicy PT
INNER JOIN archGroup ag
	ON AG.id=PT.storagePolicyId
 INNER JOIN archGroupCopy AGC ON AGC.archGroupId=AG.id AND AGC.isSnapCopy=0 AND AGC.id=AG.defaultCopy
    INNER JOIN MMDataPath P ON P.CopyId = AGC.id
    INNER JOIN MMDrivePool DP ON DP.DrivePoolId = P.DrivePoolId
    INNER JOIN MMMasterPool M ON M.MasterPoolId = DP.MasterPoolId
    INNER JOIN MMLibrary L ON L.LibraryId = M.LibraryId
UPDATE PT
	SET PT.secondaryStoragetype = (CASE
                WHEN L.LibraryTypeId=3 AND EXISTS(SELECT 1 FROM MMMountPath MP WHERE MP.LibraryId = L.LibraryId AND MP.MountPathTypeId = 7) THEN 'Cloud'
                WHEN L.LibraryTypeId=3 AND EXISTS(SELECT 1 FROM MMSDSStoragePool S WHERE S.LibraryId = L.LibraryId) THEN 'HyperScale'
				WHEN L.LibraryTypeId <> 3 THEN 'Tape'
                ELSE 'Disk'
            END)
FROM #PlanStoragePolicy PT
INNER JOIN archGroup ag
	ON AG.id=PT.storagePolicyId
 INNER JOIN archGroupCopy AGC ON AGC.archGroupId=AG.id AND AGC.isSnapCopy=0 AND AGC.sourceCopyId IN (0,AG.defaultCopy) AND AGC.id<>AG.defaultCopy
    INNER JOIN MMDataPath P ON P.CopyId = AGC.id
    INNER JOIN MMDrivePool DP ON DP.DrivePoolId = P.DrivePoolId
    INNER JOIN MMMasterPool M ON M.MasterPoolId = DP.MasterPoolId
    INNER JOIN MMLibrary L ON L.LibraryId = M.LibraryId
UPDATE SCL
SET SCL.planParentEntityType=ACP1.attrVal,
SCL.planParentEntityID=ACP2.attrVal
FROM #getPermissionsOnEntities_InputTable SCL
INNER JOIN APP_SubClientProp ACP1 WITH(NOLOCK)
ON ACP1.componentNameId=SCL.entityId5 AND ACP1.attrName = 'Associated Plan Parent EntityType' AND ACP1.modified=0 AND ACP1.cs_attrName=CHECKSUM(N'Associated Plan Parent EntityType')
INNER JOIN APP_SubClientProp ACP2 WITH(NOLOCK)
ON ACP2.componentNameId=SCL.entityId5 AND ACP2.attrName = 'Associated Plan Parent EntityId' AND ACP2.modified=0 AND ACP2.cs_attrName=CHECKSUM(N'Associated Plan Parent EntityId')
WHERE SCL.planSubtype<>117506053
UPDATE SCL
SET SCL.planParentEntityType=ACP1.attrVal,
SCL.planParentEntityID=ACP2.attrVal
FROM #getPermissionsOnEntities_InputTable SCL
INNER JOIN APP_SubClientProp ACP1 WITH(NOLOCK)
ON ACP1.componentNameId=SCL.entityId5 AND ACP1.attrName = 'Associated DC Plan Parent EntityType' AND ACP1.modified=0 AND ACP1.cs_attrName=CHECKSUM(N'Associated DC Plan Parent EntityType')
INNER JOIN APP_SubClientProp ACP2 WITH(NOLOCK)
ON ACP2.componentNameId=SCL.entityId5 AND ACP2.attrName = 'Associated DC Plan Parent EntityId' AND ACP2.modified=0 AND ACP2.cs_attrName=CHECKSUM(N'Associated DC Plan Parent EntityId')
WHERE SCL.planSubtype=117506053
--update the backupset parent entity if client entity is set for it's subclient. Do not include these entities in the list as
UPDATE o
SET o.planParentEntityID= o1.planParentEntityID,  o.planParentEntityType = o1.planParentEntityType
FROM #getPermissionsOnEntities_InputTable o
INNER JOIN #getPermissionsOnEntities_InputTable o1 ON (o.entityId1= o1.entityId1 AND  o1.planParentEntityType=3 and o.planId=o1.planId  or (o1.entityId3= o.entityId3 AND  o1.planParentEntityType=5))
WHERE o.entityId5=0 AND o.entityId4<>0 AND o.planParentEntityID IS NULL
--set planParentEntity to null for the entities that has companyId set as parent entity. This entities needs to counted in the list.
UPDATE #getPermissionsOnEntities_InputTable SET  planParentEntityID= null, planParentEntityType=null   WHERE planParentEntityType = 61
--Delete plans child entities
DELETE #getPermissionsOnEntities_InputTable WHERE planParentEntityID IS NOT NULL
INSERT INTO #PlanTempInfo(planId, planType  , numCopies , rpoInMinutes, primaryStorageType, secondaryStorageType, planSummary )
SELECT P.id as planId, p.type   as planType,
	-- Get number of copies
    (SELECT COUNT(1)
     FROM archGroupCopy C WITH (NOLOCK) INNER JOIN #PlanStoragePolicy PSP ON PSP.planId = P.id AND
                                                                             C.archGroupId = PSP.storagePolicyId
     -- Note : 'C.isSnapCopy = 0' filter removed from the WHERE clause due to MR 282386.
     -- Starting SP21 there is a SNAP support on admin console. thus snap copies to be included in calculation
     WHERE C.type != 5 AND ((C.flags & 524288) = 0)) AS numCopies,
	-- Get RPO in minutes
ISNULL((SELECT  CASE WHEN(P.subType = 33579013) THEN
dbo.AppPlanGetEntityValueV2(P.id, 'Log RPO In Minutes', default)
						 ELSE
dbo.AppPlanGetEntityValueV2(P.id, 'RPO In Minutes', default)
                    END), -1) AS rpoInMinutes,
	-- Primary storage type
	(SELECT primaryStorageType FROM #PlanStoragePolicy PSP WHERE PSP.planId = P.id) AS primaryStorageType,
	(SELECT secondaryStorageType FROM #PlanStoragePolicy PSP WHERE PSP.planId = P.id) AS secondaryStorageType,
	                    -- Empty Summary String for now. We will generate it below
	                    '' AS planSummary
	FROM    APP_Plan P WITH(NOLOCK) INNER JOIN (SELECT DISTINCT planId FROM #OutputPlans) PL ON P.id = PL.planId
OUTER APPLY (SELECT (CAST(dbo.AppPlanGetEntityValueV2(P.id, 'Storage Rules', default) AS XML)) AS storageRules) AS SR
--update count for exchange plan
UPDATE #PlanTempInfo SET numAssocEntities = (SELECT CASE WHEN(@isCommCellAdmin = 1) THEN (SELECT COUNT(*) FROM APP_EmailConfigPolicyAssoc e WHERE e.planId = pt.planId and modified=0)
					ELSE (SELECT COUNT(*) FROM #getPermissionsOnEntities_OutputTable OP INNER JOIN APP_EmailConfigPolicyAssoc IP ON
					OP.entityId1 = IP.clientId  AND
					OP.entityId4 = IP.backupsetId AND OP.entityId5 = IP.subClientId
					WHERE IP.planId = planId AND IP.modified=0) END)
FROM #PlanTempInfo pt where planType=6
--update count for other plans
UPDATE #PlanTempInfo SET numAssocEntities = (SELECT CASE WHEN(@isCommCellAdmin = 1) THEN (SELECT COUNT(*) FROM #getPermissionsOnEntities_InputTable i WHERE i.planId = pt.planId and planParentEntityID is null)
					ELSE (SELECT COUNT(*) FROM #getPermissionsOnEntities_OutputTable OP INNER JOIN #getPermissionsOnEntities_InputTable IP ON
					OP.entityId1 = IP.entityId1 AND OP.entityId2 = IP.entityId2 AND OP.entityId3 = IP.entityId3 AND
					OP.entityId4 = IP.entityId4 AND OP.entityId5 = IP.entityId5
					WHERE IP.planId = pt.planId)
							END)
FROM #PlanTempInfo pt where pt.planType<>6
-- Generate plan summary string
UPDATE  #PlanTempInfo
SET     planSummary = 'RPOHours'         + ':' + CAST((rpoInMinutes / 60) AS NVARCHAR(32)) + ','  +
'NumberOfCopies'         + ':' + CAST(numCopies AS NVARCHAR(32)) + ',' +
'AssociatedEntitiesCount'  + ':' + CAST(numAssocEntities AS NVARCHAR(32))
FROM    #PlanTempInfo PT
UPDATE  #PlanTempInfo
		SET     planSummary = planSummary + ','  +
'PrimaryStorageType'  + ':' + primaryStorageType
FROM    #PlanTempInfo PT
	WHERE primaryStorageType IS NOT NULL
UPDATE  #PlanTempInfo
		SET     planSummary = planSummary + ','  +
'SecondaryStorageType'  + ':' + secondaryStorageType
FROM    #PlanTempInfo PT
	WHERE (primaryStorageType IS NOT NULL AND secondaryStorageType IS NOT NULL)
--Get company count
INSERT INTO #AssociatedCompanies (planId,companyId)
    SELECT DISTINCT P.planId, UG.umdsProviderId FROM        UMSecurityAssociations S WITH(NOLOCK)
INNER JOIN  #OutputPlans   P              ON P.planId = S.entityId1  AND entityType1 = 158 AND isUser = 0
INNER JOIN  UMGroups      UG WITH(NOLOCK) ON S.userOrGroupId = UG.id AND umdsProviderId > 0 AND ((UG.groupFlags & 0x10000) <> 0)
                                                INNER JOIN  UMDSProviders  U WITH(NOLOCK) ON U.id = UG.umdsProviderId
--Get users that user has rights on
DECLARE @usersFlagExclude INT = CAST(0x200 AS INT)| CAST(0x004 AS INT) | CAST(0x080 AS INT) | CAST(0x100 AS INT)
DECLARE @usersFlagInclude INT = CAST(0x001 AS INT)
EXEC sec_getUsersForThisUser '#usersSec_getUsersNewTbl', @i_userId, 0, 3, @usersFlagExclude, @usersFlagInclude
--Get user groups that user has rights on
EXEC sec_getUserGroupsForThisUser '#usergroupsSec_getUsersNewTbl', @i_userId
IF OBJECT_ID('tempdb.dbo.#archivalPlans') IS NOT NULL DROP TABLE #archivalPlans
CREATE TABLE #archivalPlans(planId INT PRIMARY KEY)
INSERT INTO #archivalPlans
SELECT DISTINCT OP.planId
FROM #OutputPlans OP
    INNER JOIN APP_Plan P WITH (NOLOCK)
ON P.id = OP.planId AND P.type = 9 AND P.subType = 150994951 --type = Api::PlanType::PlanType_ARCHIVER AND subType = Api::PlanSubtype::PlanSubtype_Archiver 150994951
IF EXISTS(SELECT TOP 1 planId FROM #archivalPlans)
BEGIN
    INSERT INTO #archivalRulesForPlan (planId, subclientId)
        SELECT  AP.planId, APP.id
        FROM #archivalPlans AP
        INNER JOIN APP_PlanProp PP WITH (NOLOCK)
            ON PP.componentNameId = AP.planId
AND PP.attrName IN ('Subclient policy 2', 'Subclient policy 3')
        INNER JOIN APP_Application APP WITH (NOLOCK)
            ON CAST(PP.attrVal AS INT) = APP.backupset
AND (APP.subclientStatus & 0x00008) = 0x00008
    UPDATE #archivalRulesForPlan
    SET
        fileModifiedTimeOlderThan = [Num of Days Old Modified],
        fileAccessTimeOlderThan = [Num of Days Old],
        fileSizeGreaterThan = [Minimum File Size]
        FROM
        (
            SELECT componentNameId, attrName, attrVal FROM APP_SubclientProp Props WITH (NOLOCK)
            INNER JOIN #archivalRulesForPlan ARP ON ARP.subclientId = Props.componentNameId AND Props.modified = 0
        ) AS SubClientProps
        PIVOT
        (	max(attrVal)
            FOR attrName IN
            (
                [Num of Days Old Modified],
                [Num of Days Old],
                [Minimum File Size]
            )
        ) AS PVT
    WHERE #archivalRulesForPlan.subclientId = componentNameId
END
-- generate output XML
ERROR_EXIT:
SET @o_xmlText = (
SELECT(
        SELECT  P.type          AS '@type',
                P.subType       AS '@subtype',
                P.description   AS '@description',
                P.flag			AS '@planStatusFlag',
				( SELECT Count(DISTINCT T.userID)
                                    FROM
									(SELECT UMG.userId AS userID FROM #usersSec_getUsersNewTbl UT
									INNER JOIN UMUserGroup UMG ON UT.userId = UMG.userId
									INNER JOIN APP_PlanProp APP
ON CAST(UMG.groupId AS NVARCHAR(32)) = APP.attrVal AND APP.attrName='Assigned user group' AND APP.componentNameId = P.id AND APP.modified=0
                                    UNION
                                    SELECT UMG.userId AS userID
										FROM #usergroupsSec_getUsersNewTbl UGT
									INNER JOIN APP_PlanProp APP
ON CAST(UGT.userGroupId AS NVARCHAR(32)) = APP.attrVal AND APP.attrName IN ('Associated internal user group', 'Associated external user group') AND APP.componentNameId = P.id AND APP.modified=0
                                    INNER JOIN UMUserGroup UMG
										ON UMG.groupId=UGT.userGroupId
									INNER JOIN #usersSec_getUsersNewTbl UT
										ON UT.userId=UMG.userId
LEFT OUTER JOIN UMUsersProp UUP  on UUP.componentNameId =  UT.userId AND UUP.attrName ='Associated Plan' AND UUP.modified = 0 AND UUP.cs_attrName = CHECKSUM(N'Associated Plan')
										   WHERE UUP.id IS NULL)T
									) AS '@numUsers',
                (SELECT  COUNT(1)
					FROM    APP_ClientProp CP WITH (READUNCOMMITTED)
					INNER JOIN APP_Client AC
ON AC.id=CP.componentNameId AND (AC.status & 0x1000 = 0x1000 )
					INNER JOIN #userClients UC
ON UC.t_clientId=CP.componentNameId AND CP.attrName = 'Associated Plan' AND CP.modified = 0 AND CP.attrVal = CAST(P.id AS VARCHAR(32))
WHERE P.subType=33554439) AS '@numDevices',
		PTI.numCopies AS '@numCopies',
		PTI.numAssocEntities  AS '@numAssocEntities',
		(SELECT COUNT(companyId) FROM #AssociatedCompanies where planId = p.id) AS '@numCompanies',
ISNULL((SELECT CAST(attrVal AS INT) FROM APP_PlanProp WITH(NOLOCK) WHERE componentNameId = P.id AND attrName = 'Derivation restrictions'), 0)  AS '@restrictions',
		PTI.rpoInMinutes AS '@rpoInMinutes',
		(IIF(EXISTS	(SELECT 1
FROM App_PlanProp WITH(NOLOCK) WHERE componentNameId = P.id AND attrName = 'Storage Rules' AND CHARINDEX('ruleId', attrVal) > 0),
				-- Using substring search as the value is of XML type and xml operation will be performance intensive when done for each plan.
				 1, 0)) AS '@isElastic',
		(
            SELECT P.id            AS '@planId',
				    P.name	         AS '@planName',
				    P.type          AS '@planType',
				    P.subType       AS '@planSubtype',
				    158             AS '@_type_',    -- defined in CVEntities.x
				    PTI.planSummary AS '@planSummary'
            FOR XML PATH('plan'), TYPE
        ),
        (
			SELECT  ownerId   AS '@userId',
					ISNULL((SELECT TOP 1 name FROM UMUsers U WITH (NOLOCK) WHERE U.id = P.ownerId), '') AS '@userName',
					13  AS '@_type_' -- defined in CVEntities.x
			FOR XML PATH('planOwner'), TYPE
        ),
		(
            SELECT PP.permission  AS '@permissionId'
            FROM   #OutputPlans PP
            WHERE  PP.planId = P.Id
            FOR XML PATH('permissions'), TYPE
        ),
		(
            SELECT PP.id           AS '@planId',
					PP.name	        AS '@planName',
					PP.type         AS '@planType',
					PP.subType      AS '@planSubtype',
					158             AS '@_type_',    -- defined in CVEntities.x
					PTI.planSummary AS '@planSummary'
			FROM	 APP_Plan PP
WHERE	 PP.id IN (SELECT CAST(attrVal AS INT) FROM APP_PlanProp WITH(NOLOCK) WHERE componentNameId = P.id AND attrName = 'Base plan')
            FOR XML PATH('parent'), TYPE
        ),
        (
            SELECT B.entityId  AS '@id',
                   C.[Message] AS '@name'
FROM dbo.SplitIDString((SELECT attrVal FROM APP_PlanProp WHERE componentNameId = P.id AND attrName = 'Defintion entities : missing')) A
            INNER JOIN APP_PlanEntity   B ON B.entityId = A._ID
            INNER JOIN EvLocaleMsgs     C ON C.MessageID = B.displayNameId AND C.LocaleID = @i_localeId
            FOR XML PATH('missingEntities'), TYPE
        ),
        (
            SELECT ARP.fileModifiedTimeOlderThan '@fileModifiedTimeOlderThan',
                ARP.fileAccessTimeOlderThan '@fileAccessTimeOlderThan',
                ARP.fileSizeGreaterThan '@fileSizeGreaterThan'
            FROM #archivalRulesForPlan ARP
            WHERE ARP.planId = P.id
            FOR XML PATH('diskCleanupRules'), TYPE
        )
        FROM    APP_Plan P WITH (NOLOCK) INNER JOIN (SELECT DISTINCT planId FROM #OutputPlans) PL ON P.id = PL.planId
                           INNER JOIN #PlanTempInfo PTI ON PTI.planId = P.id
        FOR	XML PATH('plans'), TYPE )
FOR XML PATH(''), ROOT('Api_GetPlanSummaryResp')
)
IF OBJECT_ID('tempdb.dbo.#OutputPlans') IS NOT NULL DROP TABLE #OutputPlans
IF OBJECT_ID('tempdb.dbo.#PlansList')   IS NOT NULL DROP TABLE #PlansList
IF OBJECT_ID('tempdb.dbo.#PlanTempInfo') IS NOT NULL DROP TABLE #PlanTempInfo
IF OBJECT_ID('tempdb.dbo.#archivalPlans') IS NOT NULL DROP TABLE #archivalPlans
IF OBJECT_ID('tempdb.dbo.#archivalRulesForPlan') IS NOT NULL DROP TABLE #archivalRulesForPlan
IF OBJECT_ID('tempdb.dbo.#PlanStoragePolicy')IS NOT NULL DROP TABLE #PlanStoragePolicy
SET @xmlText             = @o_xmlText
SELECT @xmlText
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanGetSummaryListV2')
	delete from GxQscripts where name = 'AppPlanGetSummaryListV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetSummaryListV2')
	delete from GXDBVersions where aliasname = 'AppPlanGetSummaryListV2'
GO

insert into GXDBVersions values(2, 'AppPlanGetSummaryListV2',  'v1.1.2.44.4.1', 'AppPlanGetSummaryListV2', 'v1.1.2.44.4.1')
GO

