

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanGetSummaryList.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanGetSummaryList.sp,v $ $Id: AppPlanGetSummaryList.sp,v 1.1.2.15 2018/06/16 12:37:24 vdevassy Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppPlanGetSummaryList   - get list of available profiles
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppPlanGetSummaryList <<<'

IF EXISTS (select * from sysobjects where name='AppPlanGetSummaryList')
	drop procedure AppPlanGetSummaryList
IF EXISTS (select * from GxQscripts where name='AppPlanGetSummaryList')
	delete from GxQscripts where name = 'AppPlanGetSummaryList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetSummaryList')
	delete from GXDBVersions where aliasname = 'AppPlanGetSummaryList'
GO
print '... Creating Procedure: AppPlanGetSummaryList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanGetSummaryList
  @i_planType INT,
  @i_planSubtype INT,
  @i_userId INT,
  @i_owner INT,
  @o_xmlText XML OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
-------------------------------------------------------------------------------------------------------------------------------------------
--Code Below Here is From AppPlanConstants.spb
-- declare plan properties definition shared values
DECLARE @constAttrType_BasePlan					INT = 260
DECLARE @constAttrName_BasePlan					NVARCHAR(32) = N'BasePlan'
DECLARE @constAttrType_Feature					INT = 261
DECLARE @constAttrName_Feature					NVARCHAR(32) = N'Feature'
DECLARE @constAttrType_Alert					INT = 262
DECLARE @constAttrName_Alert					NVARCHAR(32) = N'Alert'
DECLARE @constAttrType_AccessPolicy				INT = 263
DECLARE @constAttrName_AccessPolicy				NVARCHAR(32) = N'Access policy'
DECLARE @constAttrType_Policy_Subclient			INT = 264
DECLARE @constAttrName_Policy_Subclient			NVARCHAR(32) = N'Subclient policy'
DECLARE @constAttrType_Policy_Schedule			INT = 265
DECLARE @constAttrName_Policy_Schedule			NVARCHAR(32) = N'Schedule policy'
DECLARE @constAttrType_Policy_Storage			INT = 266
DECLARE @constAttrName_Policy_Storage			NVARCHAR(32) = N'Storage policy'
DECLARE @constAttrType_Options					INT = 267
DECLARE @constAttrName_Options_Quota			NVARCHAR(32) = 'Quota'
DECLARE @constAttrName_Options_EdgeDriveQuota	NVARCHAR(32) = 'Edge Drive Quota Size'
DECLARE @constAttrName_Options_Throttle			NVARCHAR(32) = 'Network Throttle'
DECLARE @constAttrType_UserGroupAssigned		INT = 268
DECLARE @constAttrName_UserGroupAssigned		NVARCHAR(32) = 'Assigned user group'
DECLARE @constAttrType_UserGroupIAssoc			INT = 269
DECLARE @constAttrName_UserGroupIAssoc			NVARCHAR(32) = 'Associated internal user group'
DECLARE @constAttrType_UserGroupEAssoc			INT = 270
DECLARE @constAttrName_UserGroupEAssoc			NVARCHAR(32) = 'Associated external user group'
DECLARE @constAttrType_Restrictions				INT = 271
DECLARE @constAttrName_Restrictions				NVARCHAR(32) = 'Entity restrictions'
DECLARE @constAttrType_AssociatedPlan			INT = 272
DECLARE @constAttrName_AssociatedPlan			NVARCHAR(32) = 'Associated Plan'
DECLARE @constAttrType_ClientGroupAssigned		INT = 273
DECLARE @constAttrName_ClientGroupAssigned		NVARCHAR(32) = 'Assigned client group'
DECLARE @constAttType_ScheduledForDeletion		INT = 274
DECLARE @constAttName_ScheduledForDeletion		NVARCHAR(32) = 'Scheduled for deletion'
DECLARE @constAttType_EdgeDriveAssigned  		INT = 275
DECLARE @constAttName_EdgeDriveAssigned 		NVARCHAR(32) = 'Assgined Edge Drive'
DECLARE @constAttrType_Policy_SubclientWin		INT = 276
DECLARE @constAttrName_Policy_SubclientWin		NVARCHAR(32) = N'Subclient policy 2'
DECLARE @constAttrType_Policy_SubclientLin		INT = 277
DECLARE @constAttrName_Policy_SubclientLin		NVARCHAR(32) = N'Subclient policy 3'
DECLARE @constAttrType_Policy_SubclientMac		INT = 278
DECLARE @constAttrName_Policy_SubclientMac		NVARCHAR(32) = N'Subclient policy 4'
DECLARE @constAttType_SubclientRetention		INT = 279
DECLARE @constAttName_SubclientRetention		NVARCHAR(32) = 'Subclient retention period'
DECLARE @constAttType_SubclientVersions			INT = 280
DECLARE @constAttName_SubclientVersions			NVARCHAR(32) = 'Number of Synth Full Versions'
DECLARE @constAttrType_Policy_ScheduleLog   		INT = 281
DECLARE @constAttrName_Policy_ScheduleLog   		NVARCHAR(32) = N'Log schedule policy'
DECLARE @constAttrType_Policy_StorageLog    		INT = 282
DECLARE @constAttrName_Policy_StorageLog   		 NVARCHAR(32) = N'Log storage policy'
DECLARE @constAttType_SlaInMinutes			INT = 283
DECLARE @constAttName_SlaInMinutes			NVARCHAR(32) = N'SLA In Minutes'
DECLARE @constAttType_LogSlaInMinutes			INT = 285
DECLARE @constAttName_LogSlaInMinutes			NVARCHAR(32) = N'Log SLA In Minutes'
DECLARE @constAttType_ReplicationTargets    		INT = 284
DECLARE @constAttName_ReplicationTargets   		 NVARCHAR(32) = N'Replication schedule policy'
DECLARE @constAttType_ForcedArchiving   		INT = 286
DECLARE @constAttName_ForcedArchiving   		 NVARCHAR(32) = N'Forced Archiving'
-- plan entity identifiers are declared in http:--ncvs/source/xref/win/vaultcx/Source/Common/XmlMessage/Api.x : enum PlanEntities
DECLARE @constPlanEntity_StoragePolicy		 INT =   1
DECLARE @constPlanEntity_SubclientPolicy	 INT =   2
DECLARE @constPlanEntity_SchedulePolicy		 INT =   4
DECLARE @constPlanEntity_Features			 INT =   8
DECLARE @constPlanEntity_Users				 INT =  16
DECLARE @constPlanEntity_Alerts				 INT =  32
DECLARE @constPlanEntity_AccessPolicies		 INT =  64
DECLARE @constPlanEntity_Options			 INT = 128
DECLARE @constPlanEntity_SubclientPolicy_Win INT = 256
DECLARE @constPlanEntity_SubclientPolicy_Lin INT = 512
DECLARE @constPlanEntity_SubclientPolicy_Mac INT = 1024
DECLARE @constPlanEntity_ClientGroup		 INT = 2048
DECLARE @constPlanEntity_EdgeDrive           INT = 4096
DECLARE @constPlanEntity_StoragePolicyLog	 INT = 8192
DECLARE @constPlanEntity_SchedulePolicyLog   INT = 16384
DECLARE @constPlanEntity_ReplicationTargets	 INT = 32768
-- entity operations. declared in http:--ncvs/source/xref/11.0-win/vaultcx/Source/Common/XmlMessage/CVGui.x#197 : enum ListOperationType
DECLARE @constOpType_NONE					INT = 0
DECLARE @constOpType_OVERWRITE				INT = 1
DECLARE @constOpType_ADD					INT = 2
DECLARE @constOpType_DELETE					INT = 3
DECLARE @constOpType_CLEAR					INT = 4
-------------------------------------------------------------------------------------------------------------------------------------------
-- adjust plan owners for those plans for which owner was deleted from the system.
-- just make admin user new owner of such plans
DECLARE @adminUser INT = ISNULL((SELECT TOP 1 UG.userId
                          FROM UMUserGroup UG INNER JOIN UMGroups G ON G.id = UG.groupId
							                  INNER JOIN UMUsers  U ON U.id = UG.groupId AND G.allAssociations = 1 AND G.allCapabilities = 1 AND G.selfAssociation = 1 AND U.enabled = 1), 0)
UPDATE App_Plan SET ownerId  = @adminUser
WHERE  (ownerId != @adminUser) AND (ownerId IN (SELECT id FROM UMUsers WHERE flags = 0 AND [login] LIKE '%deleted%'))
--Get the list of plan ids which are visible to user
if object_id('tempdb.dbo.#planList') is not null
BEGIN
	DROP TABLE #planList
end
if object_id('tempdb.dbo.#AggregatedPlanList') is not null
BEGIN
	DROP TABLE #AggregatedPlanList
end
CREATE TABLE #AggregatedPlanList (planId integer NOT NULL, permission int)
CREATE TABLE #planList (planId integer NOT NULL)
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 31, '#planList'
Insert into #AggregatedPlanList
select planId,31
from #planList
Delete from #planList
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 159, '#planList'
Insert into #AggregatedPlanList
select planId,159
from #planList
Delete from #planList
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 158, '#planList'
Insert into #AggregatedPlanList
select planId,158
from #planList
Delete from #planList
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 157, '#planList'
Insert into #AggregatedPlanList
select planId,157
from #planList
Delete from #planList
-- Add View capability for plans wherever needed.
Insert into #AggregatedPlanList
select planId,31 from
(
	select distinct planId from #AggregatedPlanList
	except
	select distinct planId from #AggregatedPlanList
where permission!=31
) t
SET @o_xmlText = (
SELECT(
        SELECT  P.type          AS '@type',
                P.subType       AS '@subtype',
                P.description   AS '@description',
                P.flag			AS '@planStatusFlag',
                (SELECT COUNT(A.userId) FROM
                    (SELECT DISTINCT userId FROM UMUserGroup WHERE groupId IN
                        (SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE componentNameId = P.id
                            AND attrType IN (@constAttrType_UserGroupAssigned, @constAttrType_UserGroupIAssoc,@constAttrType_UserGroupEAssoc))) A ) AS '@numUsers',
                (SELECT  COUNT(1)
                 FROM    APP_ClientProp CP WITH (READUNCOMMITTED)
WHERE       CP.attrName = 'Associated Plan'
                         AND modified = 0
                         AND attrVal = CAST(P.id AS VARCHAR(32)))                                                                                   AS '@numDevices',
				ISNULL((SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE componentNameId = P.id AND attrType = @constAttrType_Restrictions), 0)  AS '@restrictions',
		        (
                  SELECT P.id           AS '@planId',
					     P.name	        AS '@planName',
					     158            AS '@_type_'    -- defined in CVEntities.x
                  FOR XML PATH('plan'), TYPE
                ),
                (
			      SELECT  ownerId                                                               AS '@userId',
					      ISNULL((SELECT TOP 1 name FROM UMUsers U WHERE U.id = P.ownerId), '') AS '@userName',
					      13                                                                    AS '@_type_' -- defined in CVEntities.x
			      FOR XML PATH('planOwner'), TYPE
                ),
				(
					select PlanList.permission '@permissionId'
					from #AggregatedPlanList PlanList
					where PlanList.planId = P.Id
					FOR XML PATH('permissions'),TYPE
                ),
				(
                  SELECT PP.id           AS '@planId',
					     PP.name	     AS '@planName',
					     158             AS '@_type_'    -- defined in CVEntities.x
				  FROM	 APP_Plan PP
				  WHERE	 PP.id IN (SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE componentNameId = P.id AND attrType = @constAttrType_BasePlan)
                  FOR XML PATH('parent'), TYPE
				)
        FROM    APP_Plan P
		inner join
		(
			select distinct AggplanList.planId as PlanId from #AggregatedPlanList AggplanList
			where (@i_owner = 0)
			union
			select AppPlan.id from app_plan AppPlan
			where AppPlan.ownerId = @i_userId
		) planList
		on  P.id = planList.PlanId
WHERE       ((P.flag & 0x00004) = 0) AND ((P.flag & 0x40000000) = 0) AND ((P.flag & 0x00020) = 0)  -- Hide deleted, scheduled for deletion and hidden
                -- show only those belonging to the user or all of then
                AND ((P.type = @i_planType) OR (@i_planType = 0))
                AND ((P.subType = @i_planSubtype) OR (@i_planSubtype = 0))
        FOR	XML PATH('plans'), TYPE )
FOR XML PATH(''), ROOT('Api_GetPlanSummaryResp')
)
DROP TABLE #planList
DROP TABLE #AggregatedPlanList
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanGetSummaryList')
	delete from GxQscripts where name = 'AppPlanGetSummaryList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetSummaryList')
	delete from GXDBVersions where aliasname = 'AppPlanGetSummaryList'
GO

insert into GXDBVersions values(2, 'AppPlanGetSummaryList',  '00010001000200150000', 'AppPlanGetSummaryList', '00010001000200150000')
GO

