

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanGetSubclientsAssociated.sp] ---------- 

--  +=====================================================================================================================+
--  |		 		 Name:  AppPlanGetUsersAssociated()
--  | Description:  Allows to GET Users count for all plan that user have some sort of right on.
--  +=====================================================================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanGetSubclientsAssociated.sp,v $ $Id: AppPlanGetSubclientsAssociated.sp,v 1.1.2.5 2019/11/11 18:12:49 evolohov Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanGetSubclientsAssociated')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanGetSubclientsAssociated <<<'
	drop procedure AppPlanGetSubclientsAssociated
END
IF EXISTS (select * from GxQscripts where name='AppPlanGetSubclientsAssociated')
	delete from GxQscripts where name = 'AppPlanGetSubclientsAssociated'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetSubclientsAssociated')
	delete from GXDBVersions where aliasname = 'AppPlanGetSubclientsAssociated'
GO
print '... Creating Procedure: AppPlanGetSubclientsAssociated'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanGetSubclientsAssociated
  @i_planId INTEGER,
  @i_planType INTEGER,
  @i_userId INTEGER,
  @o_xmlSubclients XML	OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @debug INT = 0;
DECLARE @errorCode	  INT = 0
DECLARE @errorMessage NVARCHAR(MAX) = ''
IF OBJECT_ID('tempdb.dbo.#AppPlanGetSubclientsAssociated_tmp__planList') IS NOT null DROP TABLE #AppPlanGetSubclientsAssociated_tmp__planList
CREATE TABLE #AppPlanGetSubclientsAssociated_tmp__planList (planId integer NOT NULL)
DECLARE @subclients AS TABLE (subclientId   INT PRIMARY KEY, subclientName NVARCHAR(MAX), subclientGUID VARCHAR(MAX),
                              backupsetId   INT,             backupsetName NVARCHAR(MAX), backupsetGUID VARCHAR(MAX),
                              instanceId    INT,             instanceName  NVARCHAR(MAX), instanceGUID  VARCHAR(MAX),
                              applicationId INT,             appName       NVARCHAR(MAX),
                              clientId      INT,             clientName    NVARCHAR(MAX), clientGUID    VARCHAR(MAX), displayName NVARCHAR(MAX),
                              accessible    INT)
BEGIN TRY
	DECLARE @subtype INT = ISNULL(@i_planType, 0)
	IF @subtype = 0 BEGIN	-- request for subclients associated with the plan
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 0, '#AppPlanGetSubclientsAssociated_tmp__planList'
		IF ((NOT EXISTS (SELECT 1 FROM #AppPlanGetSubclientsAssociated_tmp__planList WHERE planid = @i_planId)) AND
            (NOT EXISTS (SELECT 1 FROM App_plan WHERE id = @i_planId AND ownerId = @i_userId))) BEGIN
				SET @errorCode = 5
				SET @errorMessage = 'Access denied'
		END
IF (@errorCode = 0) AND (NOT EXISTS (SELECT id FROM App_Plan WHERE id = @i_planId AND ((flag & 0x00004) = 0) AND ((flag & 0x40000000) = 0))) BEGIN
			SET @errorCode = 2
			SET @errorMessage = 'Not found'
		END
		IF @errorCode = 0 BEGIN
            TRUNCATE TABLE #AppPlanGetSubclientsAssociated_tmp__planList
            INSERT INTO #AppPlanGetSubclientsAssociated_tmp__planList
                SELECT @i_planId
        END
	END ELSE BEGIN			-- request for the subclients associated with plan subtype
        INSERT INTO #AppPlanGetSubclientsAssociated_tmp__planList
            SELECT id FROM App_Plan WHERE subType = @subtype
    END
    IF @errorCode = 0 BEGIN
	    INSERT INTO @subclients
		    SELECT  DISTINCT
				    SC.id,      SC.subclientName, SC.[GUID],
				    BS.id,      BS.name,          BS.[GUID],
				    INS.id,     INS.name,         INS.[GUID],
				    IDA.type,   IDA.name,
				    CL.id,      CL.name,           CL.[GUID], CL.displayName, NULL
		    FROM    APP_Application SC WITH (NOLOCK) INNER JOIN APP_Client          CL   WITH (NOLOCK) ON CL.id = SC.clientId
													    INNER JOIN APP_BackupSetName   BS   WITH (NOLOCK) ON BS.id = SC.backupSet
													    INNER JOIN APP_InstanceName    INS  WITH (NOLOCK) ON INS.id = SC.instance
													    INNER JOIN APP_iDAType         IDA  WITH (NOLOCK) ON IDA.[type] = SC.appTypeId
		    WHERE  (SC.id IN (SELECT CAST(componentNameId AS INT)
                              FROM   APP_SubclientProp WITH(NOLOCK)
                              WHERE  attrVal IN (SELECT CAST(planId AS NVARCHAR(32)) FROM #AppPlanGetSubclientsAssociated_tmp__planList) AND modified = 0 AND attrName = 'Associated plan'))
        IF @debug != 0 BEGIN
            SELECT 'subclients', * FROM @subclients
        END
        -- remove those subclients which are not accessible by the user
        DECLARE @accessible INT = 0
        DECLARE @iterationId INT = (SELECT MIN(subclientId) FROM @subclients)
        WHILE @iterationId IS NOT NULL BEGIN
            SET @accessible = 0
            -- check capability
            EXEC sec_checkPermissionOnEntity @i_userId, 0, @accessible OUTPUT, 7, @iterationId
            -- update temporary table
            UPDATE @subclients SET accessible = @accessible WHERE subclientId = @iterationId
            -- next iteration
            SELECT @iterationId = MIN(subclientId) FROM @subclients WHERE subclientId > @iterationId
        END
        IF @debug != 0 BEGIN
            SELECT 'permissions resolved', * FROM @subclients
        END
        -- remove entries user has no capabilities on
        DELETE FROM @subclients WHERE accessible = 0
        IF @debug != 0 BEGIN
            SELECT 'subclients filtered', * FROM @subclients
        END
        SET @o_xmlSubclients = (
            SELECT
            (
                SELECT subclientId    AS '@subclientId',    subclientName  AS '@subclientName', subclientGUID  AS '@subclientGUID',
                       backupsetId    AS '@backupsetId',    backupsetName  AS '@backupsetName', backupsetGUID  AS '@backupsetGUID',
                       instanceId     AS '@instanceId',     instanceName   AS '@instanceName',  instanceGUID   AS '@instanceGUID',
                       applicationId  AS '@applicationId',  appName        AS '@appName',
                       clientId       AS '@clientId',       clientName     AS '@clientName',    clientGUID     AS '@clientGUID', displayName AS '@displayName'
                FROM @subclients
                FOR XML PATH('subclients'), TYPE
            ) FOR XML PATH(''), ROOT('Api_GetAssociatedSubclientsListResp')
        )
    END ELSE BEGIN
        SET @o_xmlSubclients = (SELECT @errorCode '@errorCode', @errorMessage '@errorMessage' FOR XML PATH('Api_GenericResp'))
    END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
END CATCH
IF @debug != 0 BEGIN
    SELECT 'response', @o_xmlSubclients
END
IF OBJECT_ID('tempdb.dbo.#AppPlanGetSubclientsAssociated_tmp__planList') IS NOT null DROP TABLE #AppPlanGetSubclientsAssociated_tmp__planList
SET NOCOUNT OFF
RETURN (SELECT COUNT(subclientId) FROM @subclients)
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanGetSubclientsAssociated')
	delete from GxQscripts where name = 'AppPlanGetSubclientsAssociated'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetSubclientsAssociated')
	delete from GXDBVersions where aliasname = 'AppPlanGetSubclientsAssociated'
GO

insert into GXDBVersions values(2, 'AppPlanGetSubclientsAssociated',  '00010001000200050000', 'AppPlanGetSubclientsAssociated', '00010001000200050000')
GO

