

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanGetSubclientDefaultPlan.sp] ---------- 

--  +===================================================================================================+
--  |		 		 Name:  AppPlanGetSubclientDefaultPlan()
--  | Description:  Fetches applicable Plan for the subclient either from Client Level or Company Level
--  +===================================================================================================+
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanGetSubclientDefaultPlan.sp,v $ $Id: AppPlanGetSubclientDefaultPlan.sp,v 1.1.2.5 2020/05/16 00:48:14 alakra Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppPlanGetSubclientDefaultPlan   -
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanGetSubclientDefaultPlan')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanGetSubclientDefaultPlan <<<'
	drop procedure AppPlanGetSubclientDefaultPlan
END
IF EXISTS (select * from GxQscripts where name='AppPlanGetSubclientDefaultPlan')
	delete from GxQscripts where name = 'AppPlanGetSubclientDefaultPlan'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetSubclientDefaultPlan')
	delete from GXDBVersions where aliasname = 'AppPlanGetSubclientDefaultPlan'
GO
print '... Creating Procedure: AppPlanGetSubclientDefaultPlan'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanGetSubclientDefaultPlan
  @i_userId INT,
  @i_localeId INT,
  @i_subClientId INT,
  @o_planId INT OUTPUT,
  @o_errCode INTEGER OUTPUT,
  @o_errString NVARCHAR(1024) OUTPUT
AS
  DECLARE @planId INT
  DECLARE @errCode INTEGER
  DECLARE @errString NVARCHAR(1024)
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
    SET @o_planId = 0
    SET @o_errCode = 0 -- Optimism
    SET @o_errString = '' -- Optimism
    -- siblingSubClients include the current subclient too. They are total child in the current backupset
    DECLARE @subClientIdsTmp TABLE (subclientId INT, clientId INT, appType INT, siblingSubClients INT, planId INT)
    DECLARE @defaultPlansTmp TABLE (planId INT, planSubType INT)
    DECLARE @plansApptype TABLE (planSubType INT, apptype INT, priorityType INT)
    INSERT INTO @plansApptype
SELECT 33579013, _ID, 1 FROM dbo.SplitIDs('3,5,22,80,81,135,125,104,37,62,80')     -- Priority 1
    UNION
SELECT 50331655, _ID, 2 FROM dbo.SplitIDs('11,33,34,42,43,19,20,17,18,21,29,38,36,63,64,74')     -- Priority 2
    UNION
SELECT 33554437, _ID, 3 FROM dbo.SplitIDs('3,5,11,33,34,42,43,19,20,17,18,21,29,38,36,63,64,74,106,134,22,80,81,135,125,104,53,78,37,62,80')        -- Priority 3
    -- Get Values from Input in temp table
    -- We are keeping this in temp table, so that in future if we want to use this SP for mulitple subclients, then nothing much needs to be changed
    INSERT INTO @subClientIdsTmp (subclientId, clientId, appType, siblingSubClients)
    SELECT AAP.id, AAP.clientId, AAP.appTypeId, COUNT(DISTINCT AAP1.id) FROM APP_Application AAP
LEFT OUTER JOIN APP_Application AAP1 WITH(NOLOCK) ON AAP1.backupSet=AAP.backupSet AND (AAP1.subclientStatus&0x0200 = 0) AND (AAP1.subclientStatus&0x00004 = 0)  AND (AAP1.subclientStatus&0x00002 = 0)
WHERE AAP.id=@i_subClientId AND AAP.appTypeId NOT IN (1000, 1030)
	GROUP BY AAP.id, AAP.CLIENTID, AAP.APPTYPEID
    --Remove DDB Backup subclient, Index Backup subclient
	-- This will be useful in long term application, if we want to use this SP for applicable plan for number of subclient ids
    UPDATE SCT SET SCT.planId=0 FROM @subClientIdsTmp SCT WHERE  SCT.subclientId IN
    (
        SELECT componentNameId
        FROM APP_SubClientProp (NOLOCK) P
        JOIN @subClientIdsTmp SCT ON SCT.subclientId = P.componentNameId
        WHERE (attrName = 'DDB Backup' AND attrVal = '1' AND modified = 0)
        UNION
        SELECT componentNameId
        FROM APP_SubClientProp (NOLOCK) P
        JOIN @subClientIdsTmp SCT ON SCT.subclientId = P.componentNameId
        WHERE (attrName = 'Index SubClient' AND attrVal = '1' AND modified = 0)
    )
    -- First Update Plan Value if Check At the Client Level Passes
    UPDATE SCT SET SCT.planId=1 FROM @subClientIdsTmp SCT
        INNER JOIN APP_ClientProp ACP
ON ACP.componentNameId=SCT.clientId AND ACP.attrName='Associated Plan' AND ACP.modified=0
        WHERE SCT.planId IS NULL
    IF EXISTS(SELECT TOP 1 subclientId FROM @subClientIdsTmp WHERE planId IS NULL)
    BEGIN
        -- Get Value from CompanyProp for the Plans for this client
        -- Don't fetch Laptop Plan
        INSERT INTO @defaultPlansTmp
        SELECT attrValInt, CASE attrName
WHEN 'Default Server Plan' THEN 33554437
WHEN 'Default DB Plan' THEN 33579013
WHEN 'Default File System Plan' THEN 50331655
        END
        FROM App_CompanyProp
WHERE componentNameId=dbo.AppGetOrganizationForUser(@i_userId) AND attrName IN ('Default Server Plan', 'Default DB Plan', 'Default File System Plan')
        -- File system plan will only be applicable if backupset have only 1 subclient
        UPDATE SC
        SET SC.planId= (SELECT TOP 1 DCT.planId FROM @subClientIdsTmp SCT
                                INNER JOIN @plansApptype APT
	                                ON APT.apptype=SCT.appType
                                INNER JOIN @defaultPlansTmp DCT
                                    ON DCT.planSubType=APT.planSubType
                                 WHERE SCT.subclientId=SC.subclientId
                                 AND (((DCT.planSubType = 50331655) AND (SCT.siblingSubClients=1)) OR (DCT.planSubType <> 50331655))
                                 ORDER by APT.priorityType)
        FROM @subClientIdsTmp SC WHERE SC.planId IS NULL
    END
    -- Create Output. Currently, it will be only single subclient
	SELECT @o_planId=planId FROM @subClientIdsTmp
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @o_errCode = ERROR_NUMBER()
    SET @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
SCRIPT_EXIT:
SET @planId         = @o_planId
SET @errCode        = @o_errCode
SET @errString      = @o_errString
SELECT @o_planId, @o_errCode, @o_errString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanGetSubclientDefaultPlan')
	delete from GxQscripts where name = 'AppPlanGetSubclientDefaultPlan'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetSubclientDefaultPlan')
	delete from GXDBVersions where aliasname = 'AppPlanGetSubclientDefaultPlan'
GO

insert into GXDBVersions values(2, 'AppPlanGetSubclientDefaultPlan',  '00010001000200050000', 'AppPlanGetSubclientDefaultPlan', '00010001000200050000')
GO

