

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanGetPlanComponentsV2.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- MODIFIED FOR (CCP)
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--
-- Copyright (c) 1998  CommVault Systems, Inc. All rights reserved.
--
--
-- This is unpublished proprietary source code of CommVault Systems, Inc.  The  copyright  notice  above  does  not  evidence any actual or intended publication of such source code
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanGetPlanComponentsV2.sp,v $ $Id: AppPlanGetPlanComponentsV2.sp,v 1.1.2.5.26.1 2021/05/06 19:23:05 pwang Exp $";
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--  Returns list of plans components - own and inherited
--
--      @i_planId       INT             id of the plan for which to return components
--
--      @i_mode     INTEGER             0 - auto
--                                      1 - to get entities with respect to inheritance rules
--                                      2 - to get direct associated entities only
--
--      result is placed into well-known temporary table #PlanDetails_PlanProps
--      temporary table should be of the following structure
--                                      CREATE TABLE #PlanDetails_PlanProps ( depth INT,
--                                                                            componentNameId INT,
--                                                                            attrName VARCHAR(512),
--                                                                            attrType INT,
--                                                                            attrVal VARCHAR(MAX),
--                                                                            [entityTypeId] INT,
--                                                                            [Status] INT )
-- BEGIN
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppPlanGetPlanComponentsV2')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanGetPlanComponentsV2 <<<'
	drop procedure AppPlanGetPlanComponentsV2
END
IF EXISTS (select * from GxQscripts where name='AppPlanGetPlanComponentsV2')
	delete from GxQscripts where name = 'AppPlanGetPlanComponentsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetPlanComponentsV2')
	delete from GXDBVersions where aliasname = 'AppPlanGetPlanComponentsV2'
GO
print '... Creating Procedure: AppPlanGetPlanComponentsV2'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppPlanGetPlanComponentsV2
  @i_planId INTEGER,
  @i_mode INTEGER = 0
AS
    SET NOCOUNT ON
    -- drop stale temp tables
    IF OBJECT_ID('tempdb.dbo.#GetPlanComponentsV2_PropsHierarchy')   IS NOT NULL DROP TABLE #GetPlanComponentsV2_PropsHierarchy
    IF OBJECT_ID('tempdb.dbo.#GetPlanComponentsV2_PlanProps')        IS NOT NULL DROP TABLE #GetPlanComponentsV2_PlanProps
    IF OBJECT_ID('tempdb.dbo.#GetPlanComponentsV2_LinkedProperties') IS NOT NULL DROP TABLE #GetPlanComponentsV2_LinkedProperties
    IF OBJECT_ID('tempdb.dbo.#GetPlanComponentsV2_LinkedPropSet')    IS NOT NULL DROP TABLE #GetPlanComponentsV2_LinkedPropSet
    -- create temporary tables
    CREATE TABLE #GetPlanComponentsV2_PlanProps(depth INT, planId INT, entityType INT, attrName VARCHAR(512), attrType INT, attrVal VARCHAR(MAX), entityStatus INT)
    CREATE CLUSTERED INDEX #GetPlanComponentsV2_PlanProps_attrName_idx ON #GetPlanComponentsV2_PlanProps(attrName)
    CREATE TABLE #GetPlanComponentsV2_PropsHierarchy (depth INT, componentNameId INT, attrName VARCHAR(512), attrType INT, attrVal VARCHAR(MAX), [Private] VARCHAR(MAX), [Enforced] VARCHAR(MAX), [entityType] INT)
    CREATE CLUSTERED INDEX  #GetPlanComponentsV2_PropsHierarchy_depth_idx    ON #GetPlanComponentsV2_PropsHierarchy (depth)
    CREATE INDEX            #GetPlanComponentsV2_PropsHierarchy_attrName_idx ON #GetPlanComponentsV2_PropsHierarchy(attrName)
	CREATE TABLE #GetPlanComponentsV2_LinkedProperties(attrName VARCHAR(512), componentNameId INT, entityType INT, [attrType] INT , depth INT, [Private] VARCHAR(4096) NULL, Enforced VARCHAR(4096), [attrVal] VARCHAR(4096))
    CREATE CLUSTERED INDEX  #GetPlanComponentsV2_LinkedProperties_attrName_idx ON #GetPlanComponentsV2_LinkedProperties (attrName)
    CREATE TABLE #GetPlanComponentsV2_LinkedPropSet(planEntityId INT, tiedAttrName VARCHAR(512), PRIMARY KEY(planEntityId, tiedAttrName) )
    INSERT INTO  #GetPlanComponentsV2_LinkedPropSet
        SELECT linkedTo, [name] FROM APP_PlanEntity WITH(NOLOCK) WHERE linkedTo IS NOT NULL
    DECLARE @const_modeInheritance   INT = 1
    DECLARE @const_modeDirectAssoc   INT = 2
    DECLARE @debug INT = 0
    IF @i_planId IS NOT NULL BEGIN
        SET @i_mode = IIF(@i_mode IN (@const_modeInheritance, @const_modeDirectAssoc), @i_mode, @const_modeInheritance)
    END
    DECLARE @depth  INT = 0, @iterator INT = @i_planId
    -- It seems that simple loop in this case is more effective
    -- |               |      % relative to the batch        |
    -- |hierarchy dept +-------------------------------------+
    -- |               | cte implementation | loop (combined)|
    -- +---------------+--------------------+----------------+
    -- |             1 |        57          |       10       |
    -- |             2 |        51          |       20       |
    -- |             3 |        46          |       27       |
    -- |             4 |        42          |       32       |
    -- deepest hierarchy level expected is 3.
    -- Also it is a little faster to populate temporary table with all values and remove private entities afterwards than to have complex where clauses
    -- but it is way more readable
    -- |               |      % relative to the batch        |
    -- |hierarchy dept +-------------------------------------+
    -- |               |    complex where   | simple where   |
    -- +---------------+--------------------+----------------+
    -- |             1 |        18          |     12+13      |
    -- |             2 |      13*2=26       |    8*2+9=25    |
    -- |             3 |      10*3=30       |    6*3+7=25    |
    WHILE (@iterator IS NOT NULL) AND (((@i_mode = @const_modeDirectAssoc) AND (@depth = 0)) OR (@i_mode != @const_modeDirectAssoc))  BEGIN
        INSERT INTO #GetPlanComponentsV2_PropsHierarchy
            SELECT  @depth, A1.componentNameId, A1.attrName, A1.attrType, A1.attrVal, A2.attrVal, A3.attrVal, ISNULL(EN.entityId, 0)
            FROM    App_PlanProp A1 WITH(NOLOCK) LEFT JOIN App_PlanProp     A2 WITH(NOLOCK) ON A1.componentNameId = A2.componentNameId AND A2.attrName = 'Private entities'
                                                 LEFT JOIN App_PlanProp     A3 WITH(NOLOCK) ON A1.componentNameId = A3.componentNameId AND A3.attrName = 'Descendants enforced entities'
                                                 LEFT JOIN App_PlanEntity   EN ON A1.attrName = EN.name
            WHERE   -- not deleted entries for the current iteration's plan
                    A1.componentNameId = @iterator AND A1.modified = 0
                    -- requested plan entries or those which can be inherited
                    AND (@depth = 0 OR A1.attrName IN (SELECT [name] FROM App_PlanEntity WHERE flag = 1))
                    -- skip linked properties which should come from the same plan corresponded entity comes from
                    AND A1.attrName NOT IN (SELECT tiedAttrName FROM #GetPlanComponentsV2_LinkedPropSet)
        -- next iteration
        SET @depth += 1
SET @iterator = (SELECT CAST(attrVal AS int) FROM App_PlanProp WHERE @i_mode = 1 AND componentNameId = @iterator AND attrName = 'Base plan')
    END
    IF @debug != 0 SELECT 'H : raw', * FROM #GetPlanComponentsV2_PropsHierarchy
    -- get all enforced entities
    INSERT INTO #GetPlanComponentsV2_PlanProps(depth, planId, entityType, attrName, attrType, attrVal, entityStatus)
        -- select entries for found level and entity types
        SELECT H2.depth, H2.componentNameId, H2.entityType, H2.attrName, H2.attrType, H2.attrVal, 2 FROM #GetPlanComponentsV2_PropsHierarchy H2 INNER JOIN
        (
            -- for each entity get the highest level that is dipper or equal than level that restricts entity.
            SELECT  MIN(H.depth) AS Depth, H.entityType
            FROM    #GetPlanComponentsV2_PropsHierarchy H INNER JOIN (
                        -- for each entity get the deepest level that restricts that entity
                        SELECT MAX(A.depth) Depth, B._ID
                        FROM (
                                -- retrieve list of levels and which entity(es) level restricts
                                SELECT DISTINCT depth, Enforced FROM #GetPlanComponentsV2_PropsHierarchy WHERE LEN(Enforced) > 0) A
                                CROSS APPLY dbo.SplitIDString(A.Enforced) AS B
                                GROUP   BY B._ID
                        ) A ON A._ID = H.entityType AND H.depth >= A.Depth AND A.Depth != 0
            GROUP BY H.entityType) C ON H2.depth = C.Depth AND H2.entityType = C.entityType
    DELETE FROM #GetPlanComponentsV2_PropsHierarchy WHERE attrName IN (SELECT attrName FROM #GetPlanComponentsV2_PlanProps)
    IF @debug != 0
    BEGIN
        SELECT 'H : no enforced', * FROM #GetPlanComponentsV2_PropsHierarchy
        SELECT 'O : enforced', * FROM #GetPlanComponentsV2_PlanProps
    END
    -- delete all private entities
    -- remove private entities.
    DECLARE @allPrivateEntities VARCHAR(MAX) = NULL
    SELECT  @allPrivateEntities = COALESCE(@allPrivateEntities + ',', '') + [Private] FROM #GetPlanComponentsV2_PropsHierarchy WHERE depth != 0
    DELETE  FROM #GetPlanComponentsV2_PropsHierarchy
    WHERE (depth != 0) AND (dbo.AppPlanIsEntityInTheListV2(entityType, @allPrivateEntities) = 1)
    IF @debug != 0  BEGIN SELECT 'H : no private', * FROM #GetPlanComponentsV2_PropsHierarchy END
    -- remove duplicated entities from the base plans
    DELETE FROM P1
    FROM #GetPlanComponentsV2_PropsHierarchy P1 WHERE EXISTS (SELECT 1 FROM #GetPlanComponentsV2_PropsHierarchy P2 WHERE P1.attrName = P2.attrName AND P1.depth > P2.depth)
    IF @debug != 0  BEGIN SELECT 'H : dedup', * FROM #GetPlanComponentsV2_PropsHierarchy END
    INSERT INTO #GetPlanComponentsV2_PlanProps(depth, planId, entityType, attrName, attrType, attrVal, entityStatus)
        SELECT depth, componentNameId, entityType, attrName, attrType, attrVal, IIF(dbo.AppPlanIsEntityInTheListV2(entityType, [Private]) = 1, 1, 0) FROM #GetPlanComponentsV2_PropsHierarchy
    -- output table should contain all but linked properties
    IF @debug != 0  BEGIN SELECT 'O : entities', * FROM #GetPlanComponentsV2_PlanProps END
    -- HANDLE SPECIAL CASES : attributes linked to entity.
    -- for example :
    --      if schedule policy  comes from the base plan then SLA value should also come from the same plan
    --      if log schedule policy comes from the base plan then LogSLA value should also come from the same plan
    INSERT INTO #GetPlanComponentsV2_PlanProps(depth, planId, entityType, attrName, attrType, attrVal, entityStatus)
        SELECT A.depth, A.planId, 0, A.tiedAttrName, PP.attrType, PP.attrVal, A.entityStatus
        FROM App_PlanProp PP INNER JOIN
        (
            SELECT  O.depth, O.planId, L.tiedAttrName, O.entityStatus
            FROM    #GetPlanComponentsV2_LinkedPropSet L INNER JOIN #GetPlanComponentsV2_PlanProps O ON O.entityType = L.planEntityId
        ) A ON PP.componentNameId = A.planId AND PP.attrName = A.tiedAttrName
    -- we basically done here
    IF @debug != 0  BEGIN SELECT 'O : full', * FROM #GetPlanComponentsV2_PlanProps END
    IF OBJECT_ID('tempdb.dbo.#PlanDetails_PlanProps') IS NOT NULL BEGIN
        -- insert values into return table calculating entities status
        INSERT INTO #PlanDetails_PlanProps
            SELECT DISTINCT  depth, planId, attrName, attrType, SUBSTRING((SELECT  ',' + PP2.attrVal AS [text()]
                                                                           FROM     #GetPlanComponentsV2_PlanProps PP2
                                                                           WHERE    PP2.attrName = PP1.attrName
                                                                           FOR      XML PATH ('')), 2, 4096) AS attrVal, entityType, entityStatus
            FROM  #GetPlanComponentsV2_PlanProps PP1
    END ELSE BEGIN
        -- just select it
        SELECT DISTINCT  depth, planId, attrName, attrType, SUBSTRING((SELECT  ',' + PP2.attrVal AS [text()]
                                                                       FROM     #GetPlanComponentsV2_PlanProps PP2
                                                                       WHERE    PP2.attrName = PP1.attrName
                                                                       FOR      XML PATH ('')), 2, 4096) AS attrVal, entityType, entityStatus
        FROM  #GetPlanComponentsV2_PlanProps PP1
    END
    DROP TABLE #GetPlanComponentsV2_PlanProps
    DROP TABLE #GetPlanComponentsV2_PropsHierarchy
    DROP TABLE #GetPlanComponentsV2_LinkedProperties
    DROP TABLE #GetPlanComponentsV2_LinkedPropSet
    RETURN 1
GO
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--  END
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

IF EXISTS (select * from GxQscripts where name = 'AppPlanGetPlanComponentsV2')
	delete from GxQscripts where name = 'AppPlanGetPlanComponentsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetPlanComponentsV2')
	delete from GXDBVersions where aliasname = 'AppPlanGetPlanComponentsV2'
GO

insert into GXDBVersions values(2, 'AppPlanGetPlanComponentsV2',  'v1.1.2.5.26.1', 'AppPlanGetPlanComponentsV2', 'v1.1.2.5.26.1')
GO

