

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanGetNumOfAssocEntities.sp] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppPlanGetNumOfAssocEntities')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanGetNumOfAssocEntities <<<'
	drop procedure AppPlanGetNumOfAssocEntities
END
IF EXISTS (select * from GxQscripts where name='AppPlanGetNumOfAssocEntities')
	delete from GxQscripts where name = 'AppPlanGetNumOfAssocEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetNumOfAssocEntities')
	delete from GXDBVersions where aliasname = 'AppPlanGetNumOfAssocEntities'
GO
print '... Creating Procedure: AppPlanGetNumOfAssocEntities'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppPlanGetNumOfAssocEntities
  @i_planIds VARCHAR(MAX),
  @i_userId Int,
  @o_xmlText XML OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- Used to skip Security Checks If UserId is CommCellAdmin
DECLARE @isCommCellAdmin INT = 0
-- stores Entities that user have permission
IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_OutputTable') IS NOT NULL DROP TABLE #getPermissionsOnEntities_OutputTable
CREATE TABLE #getPermissionsOnEntities_OutputTable
(
	entityId1 INT,
	entityId2 INT,
	entityId3 INT,
	entityId4 INT,
	entityId5 INT,
	permissionsString VARCHAR(512),
	isChildRow BIT DEFAULT 0
)
--stores Entities which have a plan associated to them
IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_InputTable') IS NOT NULL DROP TABLE #getPermissionsOnEntities_InputTable
CREATE TABLE #getPermissionsOnEntities_InputTable
(
	entityId1 INT,
	entityId2 INT DEFAULT 0,
	entityId3 INT DEFAULT 0,
	entityId4 INT DEFAULT 0,
	entityId5 INT DEFAULT 0,
	planId	  INT DEFAULT 0,
	planSubtype	  INT DEFAULT 0,
	planParentEntityType INT DEFAULT NULL,
	planParentEntityID INT DEFAULT NULL
)
--Temp table to store planIds and numAssocEntities
DECLARE @tempPlanIdsList
TABLE (planId INT NOT NULL PRIMARY KEY, numAssocEntities INT DEFAULT 0, planType INT);
CREATE TABLE #PlansList(planId INT NOT NULL)
CREATE CLUSTERED INDEX PlansList_planId_idx ON #PlansList(planId)
--Filter Out Plans Visible to the User from given i_planIds and dump into  @tempPlanIdsList
if(@isCommCellAdmin = 0)
BEGIN
    -- Get All Plans Visible to the User
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 31, '#PlansList'
	INSERT INTO @tempPlanIdsList
	SELECT _ID,0,type
	FROM dbo.SplitIDs(@i_planIds) SI
	JOIN #PlansList on  SI._ID = planId
	JOIN App_Plan AP on SI._ID = AP.id
END
ELSE
    INSERT INTO @tempPlanIdsList
	SELECT _ID,0,type
	FROM dbo.SplitIDs(@i_planIds) SI
	JOIN App_Plan AP on SI._ID= AP.id
-- Get entities and plans association information
INSERT INTO #getPermissionsOnEntities_InputTable (entityId1, entityId2, entityId3, entityId4, entityId5,planId)
-- Get Associated Entities of given plan list -------------------------------------------
SELECT  A.clientId, A.appTypeId, A.instance, A.backupSet,A.id,TP.planId
FROM    APP_Application  A WITH(NOLOCK)
INNER JOIN  APP_SubclientProp SP WITH(NOLOCK) ON A.id = SP.componentNameId
AND (SP.cs_attrName IN (CHECKSUM(N'Associated Plan'),CHECKSUM(N'Associated DC Plan')))
AND SP.attrName IN ('Associated Plan', 'Associated DC Plan')
AND SP.modified = 0
INNER JOIN  @tempPlanIdsList TP ON CAST (TP.planId AS NVARCHAR(32)) = SP.attrVal
WHERE	A.subclientStatus & (CAST(0x00004 AS INT) | CAST(0x00002 AS INT) ) = 0
UNION -- Associated Client Entities
SELECT CP.componentNameId,0,0,0,0,TP.planId
FROM APP_CLIENT C INNER JOIN APP_ClientProp CP WITH(NOLOCK) ON C.id = CP.componentNameId
AND (CP.attrName = 'Associated Plan' OR CP.attrName LIKE 'Default % Plan' OR CP.attrName = 'Associated DC Plan' )
AND CP.modified = 0 AND C.status & (CAST(0x00004 AS INT) | CAST(0x00002 AS INT)) = 0
INNER JOIN  @tempPlanIdsList TP ON CAST (TP.planId AS NVARCHAR(32)) = CP.attrVal
UNION -- Associated BackupSet Entities
SELECT DISTINCT A.clientId, A.appTypeId, A.instance, A.backupSet,0, planId
FROM APP_Application A WITH(NOLOCK) INNER JOIN APP_BackupSetProp SP WITH(NOLOCK) ON A.backupSet = SP.componentNameId AND SP.attrName = 'Associated Plan' AND SP.modified = 0
INNER JOIN  @tempPlanIdsList TP ON CAST (TP.planId AS NVARCHAR(32)) = SP.attrVal
INNER JOIN APP_Plan APP  WITH(NOLOCK) ON APP.id=TP.planId
WHERE A.appTypeId!=1030
UNION -- Associated Instance Entities
SELECT DISTINCT A.clientId, A.appTypeId, A.instance, 0,0, planId
FROM APP_Application A WITH(NOLOCK) INNER JOIN APP_InstanceProp SP WITH(NOLOCK) ON A.instance = SP.componentNameId AND SP.attrName = 'Associated Plan' AND SP.modified = 0
INNER JOIN  @tempPlanIdsList TP ON CAST (TP.planId AS NVARCHAR(32)) = SP.attrVal
WHERE A.appTypeId!=1030
UNION --for exchange plan
SELECT e.clientId, 0, 0, 0, 0, e.planId
FROM APP_EmailConfigPolicyAssoc e
INNER JOIN  @tempPlanIdsList TP ON TP.planId  = e.planId
WHERE e.modified=0
-- Delete Plan Child entities -------------------------------------------
UPDATE i SET planSubtype=p.subtype
FROM #getPermissionsOnEntities_InputTable  i
INNER JOIN app_plan p ON p.id = i.planId
UPDATE SCL
SET SCL.planParentEntityType=ACP1.attrVal,
SCL.planParentEntityID=ACP2.attrVal
FROM #getPermissionsOnEntities_InputTable SCL
INNER JOIN APP_SubClientProp ACP1 WITH(NOLOCK)
ON ACP1.componentNameId=SCL.entityId5 AND ACP1.attrName = 'Associated Plan Parent EntityType' AND ACP1.modified=0 AND ACP1.cs_attrName=CHECKSUM(N'Associated Plan Parent EntityType')
INNER JOIN APP_SubClientProp ACP2 WITH(NOLOCK)
ON ACP2.componentNameId=SCL.entityId5 AND ACP2.attrName = 'Associated Plan Parent EntityId' AND ACP2.modified=0 AND ACP2.cs_attrName=CHECKSUM(N'Associated Plan Parent EntityId')
WHERE SCL.planSubtype<>117506053
UPDATE SCL
SET SCL.planParentEntityType=ACP1.attrVal,
SCL.planParentEntityID=ACP2.attrVal
FROM #getPermissionsOnEntities_InputTable SCL
INNER JOIN APP_SubClientProp ACP1 WITH(NOLOCK)
ON ACP1.componentNameId=SCL.entityId5 AND ACP1.attrName = 'Associated DC Plan Parent EntityType' AND ACP1.modified=0 AND ACP1.cs_attrName=CHECKSUM(N'Associated DC Plan Parent EntityType')
INNER JOIN APP_SubClientProp ACP2 WITH(NOLOCK)
ON ACP2.componentNameId=SCL.entityId5 AND ACP2.attrName = 'Associated DC Plan Parent EntityId' AND ACP2.modified=0 AND ACP2.cs_attrName=CHECKSUM(N'Associated DC Plan Parent EntityId')
WHERE SCL.planSubtype=117506053
--update the backupset parent entity if client entity is set for it's subclient. Do not include these entities in the list
UPDATE o
SET o.planParentEntityID= o1.planParentEntityID,  o.planParentEntityType = o1.planParentEntityType
FROM #getPermissionsOnEntities_InputTable o
INNER JOIN #getPermissionsOnEntities_InputTable o1 ON (o.entityId1= o1.entityId1 AND  o1.planParentEntityType=3 and o.planId=o1.planId  or (o1.entityId3= o.entityId3 AND  o1.planParentEntityType=5))
WHERE o.entityId5=0 AND o.entityId4<>0 AND o.planParentEntityID IS NULL
--set planParentEntity to null for the entities that has companyId set as parent entity. This entities needs to counted in the list.
UPDATE #getPermissionsOnEntities_InputTable SET  planParentEntityID= null, planParentEntityType=null   WHERE planParentEntityType = 61
--Delete plans child entities
DELETE #getPermissionsOnEntities_InputTable WHERE planParentEntityID IS NOT NULL
-- get Entities that user have Permission on if he does not have CommCellAdmin rights -------------------------------------------
EXEC sec_checkPermissionOnEntity @i_userId, 1, @isCommCellAdmin OUT, 1, 2
IF(@isCommCellAdmin != 1)
BEGIN
EXEC sec_getPermissionsOnEntities @i_userId, 7  /* 7 (7) */
	-- have to delete the entities which user has no permission on as above sp doesn't remove entities that user doesn't have rights on
	DELETE FROM #getPermissionsOnEntities_OutputTable
	WHERE (SUBSTRING(permissionsString,1,1) != CAST(1 AS NVARCHAR(1)))
END
-- Count Associated Entities of plans in given plan List -------------------------------------------
--update count for exchange plan
UPDATE @tempPlanIdsList SET numAssocEntities = (SELECT CASE WHEN(@isCommCellAdmin = 1) THEN (SELECT COUNT(*) FROM APP_EmailConfigPolicyAssoc e WHERE e.planId = pl.planId and modified=0)
					ELSE (SELECT COUNT(*) FROM #getPermissionsOnEntities_OutputTable OP INNER JOIN APP_EmailConfigPolicyAssoc IP ON
					OP.entityId1 = IP.clientId  AND
					OP.entityId4 = IP.backupsetId AND OP.entityId5 = IP.subClientId
					WHERE IP.planId = pl.planId AND IP.modified=0) END)
FROM @tempPlanIdsList pl where planType=6 -- Exchange Plans
--update count for other plans
UPDATE @tempPlanIdsList SET numAssocEntities = (SELECT CASE WHEN(@isCommCellAdmin = 1) THEN (SELECT COUNT(*) FROM #getPermissionsOnEntities_InputTable i WHERE i.planId = pl.planId and planParentEntityID is null)
					ELSE (SELECT COUNT(*) FROM #getPermissionsOnEntities_OutputTable OP INNER JOIN #getPermissionsOnEntities_InputTable IP ON
					OP.entityId1 = IP.entityId1 AND OP.entityId2 = IP.entityId2 AND OP.entityId3 = IP.entityId3 AND
					OP.entityId4 = IP.entityId4 AND OP.entityId5 = IP.entityId5
					WHERE IP.planId = pl.planId)
							END)
FROM @tempPlanIdsList pl where pl.planType<>6 -- Exchange Plans
SET @o_xmlText = (
       SELECT
	   planId AS '@planId',
	   numAssocEntities AS '@numAssocEntities'
	   FROM @tempPlanIdsList
	   FOR XML PATH('planAssocEntitiesCount') , ROOT('Api_GetPlanNumAssocEntitiesResp')
	   )
IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_OutputTable') IS NOT NULL DROP TABLE #getPermissionsOnEntities_OutputTable
IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_InputTable') IS NOT NULL DROP TABLE #getPermissionsOnEntities_InputTable
IF OBJECT_ID('tempdb.dbo.#PlansList')   IS NOT NULL DROP TABLE #PlansList
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanGetNumOfAssocEntities')
	delete from GxQscripts where name = 'AppPlanGetNumOfAssocEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetNumOfAssocEntities')
	delete from GXDBVersions where aliasname = 'AppPlanGetNumOfAssocEntities'
GO

insert into GXDBVersions values(2, 'AppPlanGetNumOfAssocEntities',  '00000000000000000000', 'AppPlanGetNumOfAssocEntities', '00000000000000000000')
GO

