

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPlanGetEnitityDefaultPlan.sp] ---------- 

--  +===================================================================================================+
--  |		 		 Name:  AppPlanGetEnitityDefaultPlan()
--  | Description:  Fetches applicable Plan for the entity provided from any where in the hierarchy
--  +===================================================================================================+
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPlanGetEnitityDefaultPlan.sp,v $ $Id: AppPlanGetEnitityDefaultPlan.sp,v 1.1.2.15 2020/09/26 02:48:38 alakra Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPlanGetEnitityDefaultPlan')
BEGIN
	print '>>> Drop Stored Procedure: AppPlanGetEnitityDefaultPlan <<<'
	drop procedure AppPlanGetEnitityDefaultPlan
END
IF EXISTS (select * from GxQscripts where name='AppPlanGetEnitityDefaultPlan')
	delete from GxQscripts where name = 'AppPlanGetEnitityDefaultPlan'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetEnitityDefaultPlan')
	delete from GXDBVersions where aliasname = 'AppPlanGetEnitityDefaultPlan'
GO
print '... Creating Procedure: AppPlanGetEnitityDefaultPlan'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPlanGetEnitityDefaultPlan
  @i_userId INT,
  @i_localeId INT,
  @i_entityId INT,
  @i_entityType INT,
  @i_checkPlanOnEntityItself INT = 1,
  @i_clientID INT = 0,
  @i_plansubType INT = 0,
  @o_planId INT OUTPUT,
  @o_errCode INTEGER OUTPUT,
  @o_errString VARCHAR(1024) OUTPUT
-- i_checkPlanOnEntityItself - To Check for Associate Plan on the provided Entity itself. User might want to check only parent plans
AS
  DECLARE @planId INT
  DECLARE @planParentEntityType INTEGER
  DECLARE @planParentEntityId INTEGER
  DECLARE @errCode INTEGER
  DECLARE @errString VARCHAR(1024)
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
-------------------------------------------------------------------------------------------------------------------------------------------
--Code Below Here is From AppPlanConstants.spb
-- declare plan properties definition shared values
DECLARE @constAttrType_BasePlan					INT = 260
DECLARE @constAttrName_BasePlan					NVARCHAR(32) = N'BasePlan'
DECLARE @constAttrType_Feature					INT = 261
DECLARE @constAttrName_Feature					NVARCHAR(32) = N'Feature'
DECLARE @constAttrType_Alert					INT = 262
DECLARE @constAttrName_Alert					NVARCHAR(32) = N'Alert'
DECLARE @constAttrType_AccessPolicy				INT = 263
DECLARE @constAttrName_AccessPolicy				NVARCHAR(32) = N'Access policy'
DECLARE @constAttrType_Policy_Subclient			INT = 264
DECLARE @constAttrName_Policy_Subclient			NVARCHAR(32) = N'Subclient policy'
DECLARE @constAttrType_Policy_Schedule			INT = 265
DECLARE @constAttrName_Policy_Schedule			NVARCHAR(32) = N'Schedule policy'
DECLARE @constAttrType_Policy_Storage			INT = 266
DECLARE @constAttrName_Policy_Storage			NVARCHAR(32) = N'Storage policy'
DECLARE @constAttrType_Options					INT = 267
DECLARE @constAttrName_Options_Quota			NVARCHAR(32) = 'Quota'
DECLARE @constAttrName_Options_EdgeDriveQuota	NVARCHAR(32) = 'Edge Drive Quota Size'
DECLARE @constAttrName_Options_Throttle			NVARCHAR(32) = 'Network Throttle'
DECLARE @constAttrType_UserGroupAssigned		INT = 268
DECLARE @constAttrName_UserGroupAssigned		NVARCHAR(32) = 'Assigned user group'
DECLARE @constAttrType_UserGroupIAssoc			INT = 269
DECLARE @constAttrName_UserGroupIAssoc			NVARCHAR(32) = 'Associated internal user group'
DECLARE @constAttrType_UserGroupEAssoc			INT = 270
DECLARE @constAttrName_UserGroupEAssoc			NVARCHAR(32) = 'Associated external user group'
DECLARE @constAttrType_Restrictions				INT = 271
DECLARE @constAttrName_Restrictions				NVARCHAR(32) = 'Entity restrictions'
DECLARE @constAttrType_AssociatedPlan			INT = 272
DECLARE @constAttrName_AssociatedPlan			NVARCHAR(32) = 'Associated Plan'
DECLARE @constAttrType_ClientGroupAssigned		INT = 273
DECLARE @constAttrName_ClientGroupAssigned		NVARCHAR(32) = 'Assigned client group'
DECLARE @constAttType_ScheduledForDeletion		INT = 274
DECLARE @constAttName_ScheduledForDeletion		NVARCHAR(32) = 'Scheduled for deletion'
DECLARE @constAttType_EdgeDriveAssigned  		INT = 275
DECLARE @constAttName_EdgeDriveAssigned 		NVARCHAR(32) = 'Assgined Edge Drive'
DECLARE @constAttrType_Policy_SubclientWin		INT = 276
DECLARE @constAttrName_Policy_SubclientWin		NVARCHAR(32) = N'Subclient policy 2'
DECLARE @constAttrType_Policy_SubclientLin		INT = 277
DECLARE @constAttrName_Policy_SubclientLin		NVARCHAR(32) = N'Subclient policy 3'
DECLARE @constAttrType_Policy_SubclientMac		INT = 278
DECLARE @constAttrName_Policy_SubclientMac		NVARCHAR(32) = N'Subclient policy 4'
DECLARE @constAttType_SubclientRetention		INT = 279
DECLARE @constAttName_SubclientRetention		NVARCHAR(32) = 'Subclient retention period'
DECLARE @constAttType_SubclientVersions			INT = 280
DECLARE @constAttName_SubclientVersions			NVARCHAR(32) = 'Number of Synth Full Versions'
DECLARE @constAttrType_Policy_ScheduleLog   		INT = 281
DECLARE @constAttrName_Policy_ScheduleLog   		NVARCHAR(32) = N'Log schedule policy'
DECLARE @constAttrType_Policy_StorageLog    		INT = 282
DECLARE @constAttrName_Policy_StorageLog   		 NVARCHAR(32) = N'Log storage policy'
DECLARE @constAttType_SlaInMinutes			INT = 283
DECLARE @constAttName_SlaInMinutes			NVARCHAR(32) = N'SLA In Minutes'
DECLARE @constAttType_LogSlaInMinutes			INT = 285
DECLARE @constAttName_LogSlaInMinutes			NVARCHAR(32) = N'Log SLA In Minutes'
DECLARE @constAttType_ReplicationTargets    		INT = 284
DECLARE @constAttName_ReplicationTargets   		 NVARCHAR(32) = N'Replication schedule policy'
DECLARE @constAttType_ForcedArchiving   		INT = 286
DECLARE @constAttName_ForcedArchiving   		 NVARCHAR(32) = N'Forced Archiving'
-- plan entity identifiers are declared in http:--ncvs/source/xref/win/vaultcx/Source/Common/XmlMessage/Api.x : enum PlanEntities
DECLARE @constPlanEntity_StoragePolicy		 INT =   1
DECLARE @constPlanEntity_SubclientPolicy	 INT =   2
DECLARE @constPlanEntity_SchedulePolicy		 INT =   4
DECLARE @constPlanEntity_Features			 INT =   8
DECLARE @constPlanEntity_Users				 INT =  16
DECLARE @constPlanEntity_Alerts				 INT =  32
DECLARE @constPlanEntity_AccessPolicies		 INT =  64
DECLARE @constPlanEntity_Options			 INT = 128
DECLARE @constPlanEntity_SubclientPolicy_Win INT = 256
DECLARE @constPlanEntity_SubclientPolicy_Lin INT = 512
DECLARE @constPlanEntity_SubclientPolicy_Mac INT = 1024
DECLARE @constPlanEntity_ClientGroup		 INT = 2048
DECLARE @constPlanEntity_EdgeDrive           INT = 4096
DECLARE @constPlanEntity_StoragePolicyLog	 INT = 8192
DECLARE @constPlanEntity_SchedulePolicyLog   INT = 16384
DECLARE @constPlanEntity_ReplicationTargets	 INT = 32768
-- entity operations. declared in http:--ncvs/source/xref/11.0-win/vaultcx/Source/Common/XmlMessage/CVGui.x#197 : enum ListOperationType
DECLARE @constOpType_NONE					INT = 0
DECLARE @constOpType_OVERWRITE				INT = 1
DECLARE @constOpType_ADD					INT = 2
DECLARE @constOpType_DELETE					INT = 3
DECLARE @constOpType_CLEAR					INT = 4
-------------------------------------------------------------------------------------------------------------------------------------------
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	SET @planParentEntityType = -1
	SET @planParentEntityId = -1
    SET @o_planId = 0
    SET @o_errCode = 0 -- Optimism
    SET @o_errString = '' -- Optimism
    DECLARE @entityTBL TABLE (subclientId INT, backupSetID INT, instanceID INT, appType INT, clientId INT, siblingSubClients INT, planId INT)
    DECLARE @entityTableProcessed INT = 0
    DECLARE @defaultPlansTmp TABLE (planId INT, planSubType INT)
    DECLARE @plansApptype TABLE (planSubType INT, apptype INT, priorityType INT)
    INSERT INTO @plansApptype
SELECT 33579013, _ID, 1 FROM dbo.SplitIDs('3,5,22,80,81,135,125,104,37,62,80')     -- Priority 1
        UNION
SELECT 50331655, _ID, 2 FROM dbo.SplitIDs('11,33,34,42,43,19,20,17,18,21,29,38,36,63,64,74')     -- Priority 2
        UNION
SELECT 33554437, type, 3 FROM  dbo.App_IdaType (NOLOCK)       -- Priority 3
    -- Lets start processing.
	-- Lets go bottom up approach, starting from subclient level.
IF ((@o_planId = 0) AND (@i_entityType= 7))
	BEGIN
		SELECT @o_planId = AP.id FROM APP_SubclientProp ASP WITH(NOLOCK)
				INNER JOIN App_Plan AP  WITH(NOLOCK)
ON CONVERT(NVARCHAR(64), ISNULL(AP.id, 0))=ASP.attrVal AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
WHERE ASP.attrName='Associated Plan' AND ASP.cs_attrName = checksum(N'Associated Plan') AND ASP.modified=0 AND ASP.componentNameId=@i_entityId AND (@i_checkPlanOnEntityItself = 1)
		IF ((@o_planId = 0) OR (@o_planId IS NULL))
		BEGIN
			INSERT INTO @entityTBL
				SELECT AAP.id, AAP.backupSet, AAP.instance, AAP.appTypeId, AAP.clientId, COUNT(DISTINCT AAP1.id), 0 FROM APP_Application  AAP WITH(NOLOCK)
LEFT OUTER JOIN APP_Application AAP1 WITH(NOLOCK) ON AAP1.backupSet=AAP.backupSet AND (AAP1.subclientStatus&0x0200 = 0) AND (AAP1.subclientStatus&0x00004 = 0)  AND (AAP1.subclientStatus&0x00002 = 0)
WHERE AAP.id=@i_entityId AND AAP.appTypeId NOT IN (1000, 1030) AND (AAP.subclientStatus&0x0200 = 0) AND (AAP.subclientStatus&0x00004 = 0)  AND (AAP.subclientStatus&0x00002 = 0)
				GROUP BY AAP.id, AAP.backupSet, AAP.instance, AAP.appTypeId, AAP.clientId
		SET @entityTableProcessed=1
		END
	END
IF ((@o_planId = 0) OR (@o_planId IS NULL)) AND ((@i_entityType= 6) OR (@entityTableProcessed = 1))
	BEGIN
SELECT @o_planId = AP.id, @planParentEntityType=6, @planParentEntityId=ABP.componentNameId FROM APP_BackupSetProp ABP WITH(NOLOCK)
			INNER JOIN App_Plan AP  WITH(NOLOCK)
ON CONVERT(NVARCHAR(64), ISNULL(AP.id, 0))=ABP.attrVal AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
WHERE ABP.attrName='Associated Plan' AND ABP.modified=0
				AND ABP.componentNameId IN (SELECT backupSetID FROM @entityTBL
											UNION
SELECT @i_entityId WHERE @i_entityType=6 AND (@i_checkPlanOnEntityItself = 1))
		IF ((@o_planId=0) AND (@entityTableProcessed = 0))
		BEGIN
			INSERT INTO @entityTBL
				SELECT 0, AAP.backupSet, AAP.instance, AAP.appTypeId, AAP.clientId, COUNT(DISTINCT AAP.id), 0 FROM APP_Application  AAP WITH(NOLOCK)
WHERE AAP.backupSet=@i_entityId AND AAP.appTypeId NOT IN (1000, 1030)
AND (AAP.subclientStatus&0x0200 = 0) AND (AAP.subclientStatus&0x00004 = 0)  AND (AAP.subclientStatus&0x00002 = 0)
				GROUP BY AAP.backupSet, AAP.instance, AAP.appTypeId, AAP.clientId
			SET @entityTableProcessed=1
		END
	END
IF ((@o_planId = 0) OR (@o_planId IS NULL)) AND ((@i_entityType= 5) OR (@entityTableProcessed = 1))
	BEGIN
SELECT @o_planId = AP.id, @planParentEntityType=5, @planParentEntityId=AIP.componentNameId FROM APP_InstanceProp AIP WITH(NOLOCK)
					INNER JOIN App_Plan AP  WITH(NOLOCK)
ON CONVERT(NVARCHAR(64), ISNULL(AP.id, 0))=AIP.attrVal AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
WHERE AIP.attrName='Associated Plan' AND AIP.modified=0
				AND AIP.componentNameId IN (SELECT instanceID FROM @entityTBL
											UNION
SELECT @i_entityId WHERE (@i_entityType= 5) AND (@i_checkPlanOnEntityItself = 1))
		IF ((@o_planId=0) AND (@entityTableProcessed = 0))
		BEGIN
			INSERT INTO @entityTBL
				SELECT 0, 0, AAP.instance, AAP.appTypeId, AAP.clientId, 0, 0 FROM APP_Application  AAP WITH(NOLOCK)
WHERE AAP.instance=@i_entityId AND AAP.appTypeId NOT IN (1000, 1030)
				GROUP BY AAP.instance, AAP.appTypeId, AAP.clientId
			SET @entityTableProcessed=1
		END
	END
IF ((@o_planId = 0) OR (@o_planId IS NULL)) AND (((@i_entityType= 4) AND (@i_clientID <> 0)) OR (@entityTableProcessed = 1))
	BEGIN
SELECT @o_planId =  AP.id, @planParentEntityType=4, @planParentEntityId=AIP.componentNameId FROM APP_IDAProp AIP WITH(NOLOCK)
					INNER JOIN App_Plan AP  WITH(NOLOCK)
ON CONVERT(NVARCHAR(64), ISNULL(AP.id, 0))=AIP.attrVal AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
WHERE AIP.attrName='Associated Plan' AND AIP.modified=0
			AND AIP.componentNameId IN (SELECT AID.id FROM APP_IDAName AID WITH(NOLOCK)
WHERE AID.clientId=@i_clientID AND AID.appTypeId=@i_entityId AND (@i_entityType= 4  AND (@i_checkPlanOnEntityItself = 1))
											UNION
											SELECT AID.id FROM APP_IDAName AID WITH(NOLOCK)
												INNER JOIN @entityTBL ET
													ON ET.clientId=AID.clientId AND ET.appType=AID.appTypeId)
		IF ((@o_planId=0) AND (@entityTableProcessed = 0))
		BEGIN
			INSERT INTO @entityTBL
				SELECT 0, 0, 0, @i_entityId, @i_clientID, 0, 0
			SET @entityTableProcessed=1
		END
	END
IF ((@o_planId = 0) OR (@o_planId IS NULL)) AND ((@i_entityType= 3) OR (@entityTableProcessed = 1))
	BEGIN
		-- We just have to see if current plan at client level is applicable for the provided apptype
		-- If something is present and its also applicable(as per apptype and plan mapping), then we should use that plan
SELECT @o_planId = AP.id, @planParentEntityType=3, @planParentEntityId=ACP.componentNameId FROM APP_ClientProp ACP  WITH(NOLOCK)
			INNER JOIN App_Plan AP  WITH(NOLOCK)
ON CONVERT(NVARCHAR(64), ISNULL(AP.id, 0))=ACP.attrVal AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
WHERE ACP.attrName='Associated Plan' AND ACP.modified=0 AND ACP.componentNameId=@i_entityId AND (@i_entityType= 3  AND (@i_checkPlanOnEntityItself = 1))
				AND ((@i_plansubType=0) OR (@i_plansubType=AP.subType))
		IF ((@o_planId = 0) OR (@o_planId IS NULL))
		BEGIN
SELECT @o_planId = AP.id, @planParentEntityType=3, @planParentEntityId=ACP.componentNameId FROM APP_ClientProp ACP  WITH(NOLOCK)
				INNER JOIN App_Plan AP  WITH(NOLOCK)
ON CONVERT(NVARCHAR(64), ISNULL(AP.id, 0))=ACP.attrVal AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
				INNER JOIN @entityTBL ET
					ON ET.clientId=ACP.componentNameId
				INNER JOIN @plansApptype PAT
					ON PAT.apptype=ET.appType AND AP.subType=PAT.planSubType
WHERE ACP.attrName='Associated Plan' AND ACP.modified=0 AND (((AP.subType = 50331655) AND (ET.siblingSubClients<2)) OR (AP.subType <> 50331655))
		END
	END
IF ((@o_planId = 0) OR (@o_planId IS NULL)) AND ((@i_entityType != 3) OR (@entityTableProcessed = 1))
	BEGIN
        INSERT INTO @defaultPlansTmp
		SELECT ACP.attrVal, CASE ACP.attrName
WHEN 'Default Server Plan' THEN 33554437
WHEN 'Default Database Plan' THEN 33579013
WHEN 'Default File System Plan' THEN 50331655
							END
		FROM APP_ClientProp ACP  WITH(NOLOCK)
				INNER JOIN @entityTBL ET
					ON ET.clientId=ACP.componentNameId
				INNER JOIN App_Plan AP  WITH(NOLOCK)
ON CONVERT(NVARCHAR(64), ISNULL(AP.id, 0))=ACP.attrVal AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
WHERE ACP.attrName IN ('Default Server Plan', 'Default Database Plan', 'Default File System Plan')
					 AND ACP.modified=0
        -- File system plan will only be applicable if backupset have only 1 subclient
        UPDATE ET
        SET ET.planId= (SELECT TOP 1 DCT.planId FROM @entityTBL ET
                                INNER JOIN @plansApptype APT
	                                ON APT.apptype=ET.appType
                                INNER JOIN @defaultPlansTmp DCT
                                    ON DCT.planSubType=APT.planSubType
WHERE (((DCT.planSubType = 50331655) AND (ET.siblingSubClients<2)) OR (DCT.planSubType <> 50331655))
                                 ORDER by APT.priorityType)
        FROM @entityTBL ET
		-- Create Output. Currently, it will be only single subclient
SELECT @o_planId=planId, @planParentEntityType=3, @planParentEntityId=clientId FROM @entityTBL
	END
	-- We have been asked to fetch plan on client. We haven't got the type of plan asked for particular type. So, we will try to find that since we have the chance
IF ((@o_planId = 0) OR (@o_planId IS NULL)) AND ((@i_entityType= 3) AND (@i_clientID <> 0) AND (@i_plansubType <> 0) AND (@i_checkPlanOnEntityItself = 1))
	BEGIN
SELECT @o_planId = AP.id, @planParentEntityType=3, @planParentEntityId=ACP.componentNameId FROM APP_ClientProp ACP  WITH(NOLOCK)
			INNER JOIN App_Plan AP  WITH(NOLOCK)
ON CONVERT(NVARCHAR(64), ISNULL(AP.id, 0))=ACP.attrVal AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
WHERE ACP.attrName like 'Default % Plan' AND ACP.modified=0 AND ACP.componentNameId=@i_entityId AND (@i_plansubType=AP.subType)
	END
    IF ((@o_planId = 0) OR (@o_planId IS NULL)) AND (@entityTableProcessed = 1)
    BEGIN
		-- Delete Any existing rows
		DELETE FROM @defaultPlansTmp
		-- Need to revisit this logic and discuss same with Bhavyan once
		-- We are taking company id of logged in user. Ideally , we should look for company id associated with client
        -- Get Value from CompanyProp for the Plans for this client and apptype
        -- Don't fetch Laptop Plan
        INSERT INTO @defaultPlansTmp
        SELECT ACP.attrValInt, CASE ACP.attrName
WHEN 'Default Server Plan' THEN 33554437
WHEN 'Default Database Plan' THEN 33579013
WHEN 'Default File System Plan' THEN 50331655
        END
        FROM App_CompanyProp ACP WITH(NOLOCK)
		INNER JOIN App_Plan AP  WITH(NOLOCK)
ON CONVERT(NVARCHAR(64), ISNULL(AP.id, 0))=ACP.attrVal AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
		INNER JOIN App_ClientProp ACP1 WITH(NOLOCK)
ON CAST(ACP.componentNameId AS NVARCHAR(32))=ACP1.attrVal AND ACP1.attrName='Installation Company ID' AND ACP1.modified=0
		INNER JOIN @entityTBL ET
			ON ET.clientId=ACP1.componentNameId
WHERE ACP.attrName IN ('Default Server Plan', 'Default Database Plan', 'Default File System Plan')
        -- File system plan will only be applicable if backupset have only 1 subclient
        UPDATE ET
        SET ET.planId= (SELECT TOP 1 DCT.planId FROM @entityTBL ET
                                INNER JOIN @plansApptype APT
	                                ON APT.apptype=ET.appType
                                INNER JOIN @defaultPlansTmp DCT
                                    ON DCT.planSubType=APT.planSubType
WHERE (((DCT.planSubType = 50331655) AND (ET.siblingSubClients<2)) OR (DCT.planSubType <> 50331655))
                                 ORDER by APT.priorityType)
        FROM @entityTBL ET
		-- Create Output. Currently, it will be only single subclient
		-- We will only fetch plan from company level. But company level should not be saved as parent entity as it can change
		SELECT @o_planId=planId, @planParentEntityType=-1, @planParentEntityId=-1 FROM @entityTBL ET
		INNER JOIN APP_ClientProp ACP1
ON ET.clientId=ACP1.componentNameId AND ACP1.attrName='Installation Company ID' AND ACP1.modified=0
    END
IF ((@i_plansubType = 117506053) AND (@o_planId > 1))
	BEGIN
		-- If requirement is for DC plan, make sure we are returning that only
		SET @o_planId = ISNULL((SELECT id FROM APP_Plan WHERE id=@o_planId AND subType=@i_plansubType), 0)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @o_errCode = ERROR_NUMBER()
    SET @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
SCRIPT_EXIT:
SET @planId         = @o_planId
SET @errCode        = @o_errCode
SET @errString      = @o_errString
IF object_id('tempdb.dbo.#tempPlanIdTbl') IS NOT NULL
BEGIN -- if output temp table is present, populate result
	INSERT INTO #tempPlanIdTbl VALUES (@planId, @errCode, @errString)
END
ELSE
BEGIN
    SELECT @o_planId,@planParentEntityType, @planParentEntityId, @o_errCode, @o_errString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppPlanGetEnitityDefaultPlan')
	delete from GxQscripts where name = 'AppPlanGetEnitityDefaultPlan'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPlanGetEnitityDefaultPlan')
	delete from GXDBVersions where aliasname = 'AppPlanGetEnitityDefaultPlan'
GO

insert into GXDBVersions values(2, 'AppPlanGetEnitityDefaultPlan',  '00010001000200150000', 'AppPlanGetEnitityDefaultPlan', '00010001000200150000')
GO

